if not exists (select * from information_schema.tables where table_name = 'AB_EDInterventionPicklist')
CREATE TABLE [dbo].[AB_EDInterventionPicklist](
	[AbstractID] [int] NOT NULL,
	[Occurrence] [int] not NULL,
	[EDInterventionPickList] [int] NULL,
	CONSTRAINT [PK_AB_EDInterventionPicklist] PRIMARY KEY  CLUSTERED (AbstractID, Occurrence)	
)
GO
if not exists (select * from information_schema.tables where table_name = 'AB_InvestigativeTechnology')
CREATE TABLE [dbo].[AB_InvestigativeTechnology](
	[AbstractID] [int] NOT NULL,
	[Occurrence] [int] not NULL,
	[InvestigativeTechnology] [int] NULL,
	[NumberInvestigativeTechnologyPerformed] [int] NULL,
	CONSTRAINT [PK_AB_InvestigativeTechnology] PRIMARY KEY  CLUSTERED (AbstractID, Occurrence)	
)
GO
delete u_fields where [FieldID] between 164 and 165
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(164, 'ED Intervention Picklist', 'None', 'NONE', 0, 3)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(165, 'ED Investigative Technology', 'NONE', 'NONE', 0, 3)
GO
delete u_fields where [FieldID] between 981 and 985
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(981, 'ED Intervention Picklist Occurrence', 'Occurrence', 'Occurrence', 2, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(982, 'ED Intervention Picklist', 'EDInterventionPicklist', 'EDInterventionPicklist', 0, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(983, 'Investigative Technology Occurrence', 'Occurrence', 'Occurrence', 2, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(984, 'Investigative Technology', 'InvestigativeTechnology', 'EDInvestigativeTechnology', 0, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(985, 'Investigative Technology Number', 'NumberInvestigativeTechnologyPerformed', 'NumberInvestigativeTechnologyPerformed', 0, 0)
GO

if not exists (select * from u_usersfields where userid = 1 and appid = 401 and fieldid = 164)
	Update U_UsersFields
	set SortOrder = a.SortOrder + 10
	from U_UsersFields a
		inner join (select * from u_Usersfields where AppID in (401) and fieldid = 153) b 
		on a.UserID = b.UserID and a.AppID = b.AppID and a.SortOrder >= b.SortOrder
GO
if not exists (select * from u_usersfields where userid = 1 and appid = 401 and fieldid = 164)
begin
	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 164, 
		SortOrder = SortOrder - 10, 
		GroupID = 64, MultipleIndex = 42, MandatoryStatus = 1000, Needed = 0, FieldSize = 0, 
		DataType = 0,  
        SubAppID = 0, LookUpTable = '', CIHI_ID = '', 
		Header_CIHI_English = 'ED Intervention Pick List Information', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'ED Intervention Pick List Information', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 0, 
		ParamOrder = -1, 
		ParamName = '', 
		ParamDataType = 0, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID = 401 and fieldid = 153

	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 981, 
		SortOrder = SortOrder - 9, 
		GroupID = 64, MultipleIndex = 42, MandatoryStatus = 1000, Needed = 0, FieldSize = 3, 
		DataType = 4,  
        SubAppID = 0, LookUpTable = '', CIHI_ID = '', 
		Header_CIHI_English = 'ED Intervention Occurrence', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'ED Intervention Occurrence', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 46, 
		ParamOrder = 0, 
		ParamName = 'pEDIntervOcc', 
		ParamDataType = 3, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID = 401 and fieldid = 153

	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 982, 
		SortOrder = SortOrder - 8, 
		GroupID = 64, MultipleIndex = 42, MandatoryStatus = 3, Needed = 1, FieldSize = 3, 
		DataType = 50,  
        SubAppID = 0, LookUpTable = 'LU_EDIntervnetionPickList', CIHI_ID = '173', 
		Header_CIHI_English = 'ED Intervention Pick List', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'ED Intervention Pick List', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 46, 
		ParamOrder = 1, 
		ParamName = 'pEDIntervCode', 
		ParamDataType = 3, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID = 401 and fieldid = 153

	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 165, 
		SortOrder = SortOrder - 5, 
		GroupID = 65, MultipleIndex = 43, MandatoryStatus = 1000, Needed = 0, FieldSize = 0, 
		DataType = 0,  
        SubAppID = 0, LookUpTable = '', CIHI_ID = '', 
		Header_CIHI_English = 'Investigative Technology Information', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Investigative Technology Information', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 0, 
		ParamOrder = -1, 
		ParamName = '', 
		ParamDataType = 0, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID = 401 and fieldid = 153

	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 983, 
		SortOrder = SortOrder - 4, 
		GroupID = 65, MultipleIndex = 43, MandatoryStatus = 1000, Needed = 0, FieldSize = 3, 
		DataType = 4,  
        SubAppID = 0, LookUpTable = '', CIHI_ID = '', 
		Header_CIHI_English = 'Investigative Technology Occurrence', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Investigative Technology Occurrence', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 47, 
		ParamOrder = 0, 
		ParamName = 'pEDInvestOcc', 
		ParamDataType = 3, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID = 401 and fieldid = 153

	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 984, 
		SortOrder = SortOrder - 3, 
		GroupID = 65, MultipleIndex = 43, MandatoryStatus = 1000, Needed = 0, FieldSize = 3, 
		DataType = 50,  
        SubAppID = 0, LookUpTable = 'LU_EDInvestigativeTechnology', CIHI_ID = '', 
		Header_CIHI_English = 'Investigative Technology', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Investigative Technology', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 47, 
		ParamOrder = 1, 
		ParamName = 'pEDInvestTech', 
		ParamDataType = 3, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID = 401 and fieldid = 153

	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 985, 
		SortOrder = SortOrder - 2, 
		GroupID = 65, MultipleIndex = 43, MandatoryStatus = 1000, Needed = 0, FieldSize = 3, 
		DataType = 0,  
        SubAppID = 0, LookUpTable = '', CIHI_ID = '', 
		Header_CIHI_English = 'Number of Investigative Technologies Performed', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Number of Investigative Technologies Performed', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 47, 
		ParamOrder = 2, 
		ParamName = 'pEDInvestNumber', 
		ParamDataType = 3, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID = 401 and fieldid = 153
end
GO
--Lookup Table
--New Disposition Code
declare @MaxID int
declare @Disable int
set @Disable = 0
if exists (select * from LU_DispositionCode_A where code between 50 and 69)
begin
    if not exists (select * from LU_DispositionCode_A where code = 50 and cihivalue = '06' and defaultdescription = 'Admit to reporting facility as inpatient to SCU or OR from amb care')
    begin
        set @MaxID = (select max(code) from LU_DispositionCode_A where code >= 100000)
        if isnull(@MaxID, 0) < 500000 set @MaxID = 500000
        Update LU_DispositionCode_A set code = code + @MaxID where code between 50 and 69
        Update AB_Abstract set DispositionCode = DispositionCode + @MaxID where DispositionCode between 50 and 69 and caretype in (1, 2)
        set @Disable = 1
    end
end
else
    set @Disable = 1

if @Disable = 1
    update LU_DispositionCode_A set Validto = '2018/03/31' where ValidTo > '2018/03/31' and code not between 50 and 69
GO
if not exists (select * from LU_DispositionCode_A where code between 50 and 69)
begin
    insert into [dbo].[LU_DispositionCode_A](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
    select code, CIHIValue, DefaultDescription, DefaultDescription, CIHIValue, '2018/04/01', '2099/03/31', CIHIValue, 0, ''
    from 
	(
	select code = 50, DefaultDescription = 'Admit to reporting facility as inpatient to SCU or OR from amb care', CIHIValue = '06' union
	select code = 51, DefaultDescription = 'Admit to reporting facility as inpatient to another unit from amb care', CIHIValue = '07' union
	select code = 52, DefaultDescription = 'Transfer to another acute care facility directly from amb care', CIHIValue = '08' union
	select code = 53, DefaultDescription = 'Transfer to another non-acute care facility directly from amb care', CIHIValue = '09' union
	select code = 54, DefaultDescription = 'Intra-facility transfer to day surgery', CIHIValue = '12' union
	select code = 55, DefaultDescription = 'Intra-facility transfer to ED', CIHIValue = '13' union
	select code = 56, DefaultDescription = 'Intra-facility transfer to clinic', CIHIValue = '14' union
	select code = 57, DefaultDescription = 'Transfer to Residential care', CIHIValue = '30' union
	select code = 58, DefaultDescription = 'Transfer to Group/supportive living', CIHIValue = '40' union
	select code = 59, DefaultDescription = 'Transfer to correctional facility', CIHIValue = '90' union
	select code = 60, DefaultDescription = 'Discharge to private home, condo, apt with support service/referral', CIHIValue = '16' union
	select code = 61, DefaultDescription = 'Discharge to private home, condo, apt without support service/referral', CIHIValue = '17' union
	select code = 62, DefaultDescription = 'Left at his/her own risk following registration', CIHIValue = '61' union
	select code = 63, DefaultDescription = 'Left at his/her own risk post-initial treatment', CIHIValue = '62' union
	select code = 64, DefaultDescription = 'Left After Triage', CIHIValue = '63' union
	select code = 65, DefaultDescription = 'Left After Initial Assessment', CIHIValue = '64' union
	select code = 66, DefaultDescription = 'Category (Died)  Dead on arrival', CIHIValue = '71' union
	select code = 67, DefaultDescription = 'Died in Facility', CIHIValue = '72' union
	select code = 68, DefaultDescription = 'Medical Assistance in Dying (MAID)', CIHIValue = '73' union
	select code = 69, DefaultDescription = 'Suicide in Facility', CIHIValue = '74' 
	) a
end
GO
--New Mental health field lookup table for NACRS
if not exists (select * from information_schema.tables where table_name = 'LU_MentalLegalStatusUponArrivalED_A')
create table dbo.LU_MentalLegalStatusUponArrivalED_A(
    Code int not null ,
	DisplayCode varchar(50) NULL,
	UserDescription varchar(255) NULL,
	DefaultDescription varchar(255) NULL,
	CIHIValue varchar(50) NULL,
	ValidFrom datetime NULL,
	ValidTo datetime NULL,
	InterfaceIn varchar(50) NULL,
	HospitalID int NULL,
	LUText varchar(255) NULL,
    CONSTRAINT [PK_LU_MentalLegalStatusUponArrivalED_A] PRIMARY KEY CLUSTERED (Code ASC)
)
GO
if not exists (select * from LU_MentalLegalStatusUponArrivalED_A)
begin
    insert into LU_MentalLegalStatusUponArrivalED_A(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
    select code, CIHIValue, UserDescription, UserDescription, CIHIValue, '2018/04/01', '2099/03/31', CIHIValue,  0, ''
    from (
    select code = 11, CIHIValue = '30', UserDescription = 'Orders for Assessment / Apprehension'
    union
    select code = 20, CIHIValue = '39', UserDescription = 'Community Treatment Order (CTO)'
    union
    select code = 21, CIHIValue = '40', UserDescription = 'Drug Treatment Court'
    union
    select code = 31, CIHIValue = '50', UserDescription = 'Forensic admission'
    union
    select code = 41, CIHIValue = '60', UserDescription = 'Consent to admission'
    union
    select code = 51, CIHIValue = '70', UserDescription = 'Inmates'
    union
    select code = 61, CIHIValue = '80', UserDescription = 'Other'
    ) a
end
GO
Update [dbo].[U_UsersFields]
set LookUpTable = 'LU_MentalLegalStatusUponArrivalED_A'
where FieldID = 1263 and appid = 401
GO
--New 173: ED Intervention Picklist for NACRS
if not exists (select * from information_schema.tables where table_name = 'LU_EDIntervnetionPickList')
create table dbo.LU_EDIntervnetionPickList(
    Code int not null ,
	DisplayCode varchar(50) NULL,
	UserDescription varchar(255) NULL,
	DefaultDescription varchar(255) NULL,
	CIHIValue varchar(50) NULL,
	ValidFrom datetime NULL,
	ValidTo datetime NULL,
	InterfaceIn varchar(50) NULL,
	HospitalID int NULL,
	LUText varchar(255) NULL,
    CONSTRAINT [PK_LU_LU_EDIntervnetionPickList] PRIMARY KEY CLUSTERED (Code ASC)
)
GO
if not exists (select * from LU_EDIntervnetionPickList)
begin
    insert into LU_EDIntervnetionPickList(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
    select code, CIHIValue, UserDescription, UserDescription, CIHIValue, '2018/04/01', '2099/03/31', CIHIValue,  0, ''
    from (
    select code =  1, CIHIValue = 'I01', UserDescription = 'Angiogram'
    union 
    select code =  2, CIHIValue = 'I02', UserDescription = 'Aspiration, Incision and Drainage (I&D)'
    union
    select code =  3, CIHIValue = 'I03', UserDescription = 'Blood transfusion'
    union
    select code =  4, CIHIValue = 'I04', UserDescription = 'Cardiopulmonary resuscitation (CPR)/Heart stimulation'
    union
    select code =  5, CIHIValue = 'I05', UserDescription = 'Dialysis, Hemodialysis, peritoneal dialysis'
    union
    select code =  6, CIHIValue = 'I06', UserDescription = 'Electrocardiogram (ECG)'
    union
    select code =  7, CIHIValue = 'I07', UserDescription = 'Foreign body removal  endoscopic per orifice approach'
    union
    select code =  8, CIHIValue = 'I08', UserDescription = 'Endoscopic inspection or biopsy of the digestive system'
    union
    select code =  9, CIHIValue = 'I09', UserDescription = 'Insertion of central line'
    union
    select code = 10, CIHIValue = 'I10', UserDescription = 'Insertion of intravenous device I.V.'
    union
    select code = 11, CIHIValue = 'I11', UserDescription = 'Administration of thrombolytic agent'
    union
    select code = 12, CIHIValue = 'I12', UserDescription = 'Intraosseous infusion'
    union
    select code = 13, CIHIValue = 'I13', UserDescription = 'Foley catheter insertion'
    union
    select code = 14, CIHIValue = 'I14', UserDescription = 'Lumbar puncture/spinal tap'
    union
    select code = 15, CIHIValue = 'I15', UserDescription = 'Nasogastric tube (NG tube) insertion'
    union
    select code = 16, CIHIValue = 'I16', UserDescription = 'Management of device'
    union
    select code = 17, CIHIValue = 'I17', UserDescription = 'Counselling, mental health assmnt, test, certifctn, interv'
    union
    select code = 18, CIHIValue = 'I18', UserDescription = 'Assmnt life coping skill/activities daily living (ADL)'
    union
    select code = 19, CIHIValue = 'I19', UserDescription = 'Nasal cautery/packing'
    union
    select code = 20, CIHIValue = 'I20', UserDescription = 'Paracentesis/thoracentesis with/without tube'
    union
    select code = 21, CIHIValue = 'I21', UserDescription = 'Physical or chemical restraints'
    union
    select code = 22, CIHIValue = 'I22', UserDescription = 'Repair skin'
    union
    select code = 23, CIHIValue = 'I23', UserDescription = 'Deep/complicated repair'
    union
    select code = 24, CIHIValue = 'I24', UserDescription = 'Removal foreign body cornea'
    union
    select code = 25, CIHIValue = 'I25', UserDescription = 'Removal foreign body skin/soft tissue'
    union
    select code = 26, CIHIValue = 'I26', UserDescription = 'Cricothyrotomy/tracheostomy'
    union
    select code = 27, CIHIValue = 'I27', UserDescription = 'Invasive intubation/ventilation'
    union
    select code = 28, CIHIValue = 'I28', UserDescription = 'Ventilation via non-invasive approach'
    ) a
end
GO
--New 174: ED Investigative Technology for NACRS
if not exists (select * from information_schema.tables where table_name = 'LU_EDInvestigativeTechnology')
create table dbo.LU_EDInvestigativeTechnology(
    Code int not null ,
	DisplayCode varchar(50) NULL,
	UserDescription varchar(255) NULL,
	DefaultDescription varchar(255) NULL,
	CIHIValue varchar(50) NULL,
	ValidFrom datetime NULL,
	ValidTo datetime NULL,
	InterfaceIn varchar(50) NULL,
	HospitalID int NULL,
	LUText varchar(255) NULL,
    CONSTRAINT [PK_LU_EDInvestigativeTechnology] PRIMARY KEY CLUSTERED (Code ASC)
)
GO
if not exists (select * from LU_EDInvestigativeTechnology)
begin
    insert into LU_EDInvestigativeTechnology(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
    select code, CIHIValue, UserDescription, UserDescription, CIHIValue, '2018/04/01', '2099/03/31', CIHIValue,  0, ''
    from (
    select code =  1, CIHIValue = 'C01', UserDescription = 'CT Scan - head/brain, neck or upper extremities'
    union
    select code =  2, CIHIValue = 'C02', UserDescription = 'CT Scan - other specified sites'
    union
    select code =  3, CIHIValue = 'M01', UserDescription = 'MRI - any site'
    union
    select code =  4, CIHIValue = 'N01', UserDescription = 'Nuclear imaging - chest, spine'
    union
    select code =  5, CIHIValue = 'N02', UserDescription = 'Nuclear imaging - other specified site'
    union
    select code =  6, CIHIValue = 'U01', UserDescription = 'Ultrasound - other specified site'
    union
    select code =  7, CIHIValue = 'U02', UserDescription = 'Ultrasound - head, neck or extremities'
    union
    select code =  8, CIHIValue = 'X01', UserDescription = 'X-ray - extremities'
    union
    select code =  9, CIHIValue = 'X02', UserDescription = 'X-ray - other specified site'
    ) a
end
GO
update [dbo].[LU_AnaestTechnique] set DefaultDescription = 'Regional nerve block (other than digital)' where CIHIValue = '5' and ValidTo > '2018/04/01'
GO
update [dbo].[LU_AnaestTechnique] set DefaultDescription = 'Monitored procedural sedation (with at least one other professional present)' where CIHIValue = '6' and ValidTo > '2018/04/01'
GO
update [dbo].[LU_AnaestTechnique] set DefaultDescription = 'Local anaesthetic (include digital nerve block)' where CIHIValue = '7' and ValidTo > '2018/04/01'
GO
update [dbo].[LU_AnaestTechnique] set DefaultDescription = 'IV sedation/ analgesia without monitoring' where CIHIValue = '9' and ValidTo > '2018/04/01'
GO
--
update [dbo].[LU_DiagnosisPrefix] set validto = '2018/03/31' where CIHIValue = 'M' and validto >= '2018/04/01'
GO
--fix 294.3 issue
if exists (SELECT * from [LU_MentalLegalStatusUponArrivalED] where code = 2 and cihivalue = '11')
	delete from [LU_MentalLegalStatusUponArrivalED] where CIHIValue not in ('10', '30', '39', '40', '50', '60', '70', '80', '99')
GO
if exists (SELECT * from [LU_MentalLegalStatusAdmission] where code = 2 and cihivalue = '11')
	delete from [LU_MentalLegalStatusAdmission] where CIHIValue not in ('10', '20', '40', '50', '60', '70', '80', '99')
GO
update U_usersfields set DataType = 100000, FieldEnabled = 2, FieldVisible = 2, LookupTable = '' where fieldid = 1264 and appid = 401
GO
--2.x-1035
if not exists (select * from  [dbo].[U_UsersFields] where AppID = 401 and fieldid = 1231)
insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 1231, 
		SortOrder = SortOrder + 2, 
		GroupID, MultipleIndex, MandatoryStatus = 1000, Needed = 0, FieldSize = 3, 
		DataType = (case when AppID = 100 or AppID = 101 or AppID = 102 or AppID = 301 or AppID = 401 then 100000 else 50 end),  
        SubAppID, LookUpTable = 'LU_CJRR_RevisionReason', CIHI_ID = '11-23', 
		Header_CIHI_English = 'Revision Reason', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Revision Reason', 
		FieldEnabled = (case when AppID = 100 or AppID = 101 or AppID = 102 or AppID = 301 or AppID = 401 then 2 else 1 end), 
        FieldVisible = (case when AppID = 100 or AppID = 101 or AppID = 102 or AppID = 301 or AppID = 401 then 2 else 1 end), 
        DefaultValue = null, 
		ParamProcID, 
		ParamOrder = 30, 
		ParamName = 'pRevisionReason', 
		ParamDataType = 3, ParamSize = 0, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID in (100, 101, 102, 301, 401) and fieldid = 1207
GO
update u_usersfields set GroupID = 0, MultipleIndex = 0
where fieldid in (1230, 1231)
	and appid in (100, 101, 102, 301, 401)
GO
if not exists (select * from information_schema.tables where table_name = 'LU_Institution_TypeCode')
create table dbo.LU_Institution_TypeCode(
    Code int not null ,
	DisplayCode varchar(50) NULL,
	UserDescription varchar(255) NULL,
	DefaultDescription varchar(255) NULL,
	CIHIValue varchar(50) NULL,
	ValidFrom datetime NULL,
	ValidTo datetime NULL,
	InterfaceIn varchar(50) NULL,
	HospitalID int NULL,
	LUText varchar(255) NULL,
    CONSTRAINT [PK_LU_Institution_TypeCode] PRIMARY KEY CLUSTERED (Code ASC)
)
GO
if exists (select * from sysindexes where [name] = 'IX_LU_Institution_TypeCode_CIHIValue')
	DROP INDEX LU_Institution_TypeCode.[IX_LU_Institution_TypeCode_CIHIValue]
GO
CREATE NONCLUSTERED INDEX [IX_LU_Institution_TypeCode_CIHIValue] ON [dbo].[LU_Institution_TypeCode] ([CIHIValue] ASC)
GO
if not exists (select * from LU_Institution_TypeCode)
begin
    insert into LU_Institution_TypeCode(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
    select code, CIHIValue, UserDescription, UserDescription, CIHIValue, '2001/04/01', '2099/03/31', CIHIValue,  0, ''
    from (
    select code = 01, CIHIValue = '0', UserDescription = 'Community-based clinic'
	union
    select code = 02, CIHIValue = '1', UserDescription = 'Acute inpatient care'
	union
    select code = 03, CIHIValue = '2', UserDescription = 'Inpatient rehabilitation'
	union
    select code = 04, CIHIValue = '3', UserDescription = 'Inpatient complex continuing care'
	union
    select code = 05, CIHIValue = '4', UserDescription = 'Long-term care (24-hour nursing care)'
	union
    select code = 06, CIHIValue = '5', UserDescription = 'Inpatient psychiatry (mental health)'
	union
    select code = 07, CIHIValue = '6', UserDescription = 'Nursing stations'
	union
    select code = 08, CIHIValue = '8', UserDescription = 'Home care program'
	union
    select code = 09, CIHIValue = '9', UserDescription = 'Inpatient palliative care'
	union
    select code = 10, CIHIValue = 'A', UserDescription = 'Day surgery' 
	union
    select code = 11, CIHIValue = 'C', UserDescription = 'Correctional facility'
	union
    select code = 12, CIHIValue = 'E', UserDescription = 'Emergency department'
	union
    select code = 13, CIHIValue = 'F', UserDescription = 'Other health facility'
	union
    select code = 14, CIHIValue = 'G', UserDescription = 'Group living/supportive housing'
	union
    select code = 15, CIHIValue = 'H', UserDescription = 'Transitional housing'
	union
    select code = 16, CIHIValue = 'J', UserDescription = 'Other non-health facility'
	union
    select code = 17, CIHIValue = 'M', UserDescription = 'Community mental health services'
	union
    select code = 18, CIHIValue = 'N', UserDescription = 'Ambulatory care clinic'
	union
    select code = 19, CIHIValue = 'P', UserDescription = 'Hospice/palliative care facility'
	union
    select code = 20, CIHIValue = 'T', UserDescription = 'Mental health and/or addiction treatment centre'
	union
    select code = 21, CIHIValue = 'U', UserDescription = 'Unknown facility'
    ) a
end
GO

if not exists (select * from information_schema.columns where table_name = 'AB_Abstract' and column_name = 'InstitutionFromType')
begin
	alter table AB_Abstract add InstitutionFromType int
	alter table AB_Abstract add InstitutionToType int
end
GO
delete u_fields where [FieldID] between 754 and 755
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(754, 'Institution From Type', 'InstitutionFromType', 'InstitutionFromType', 2, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(755, 'Institution To Type', 'InstitutionToType', 'InstitutionToType', 2, 0)
GO

if not exists (select * from u_usersfields where userid = 1 and appid = 201 and fieldid = 754)
	Update U_UsersFields
	set SortOrder = a.SortOrder + 1
	from U_UsersFields a
		inner join (select * from u_Usersfields where AppID in (100, 101, 102, 200, 201, 202, 301, 401) and fieldid = 667) b 
		on a.UserID = b.UserID and a.AppID = b.AppID and a.SortOrder > b.SortOrder
GO
if not exists (select * from u_usersfields where userid = 1 and appid = 201 and fieldid = 755)
	Update U_UsersFields
	set SortOrder = a.SortOrder + 1
	from U_UsersFields a
		inner join (select * from u_Usersfields where AppID in (100, 101, 102, 200, 201, 202, 301, 401) and fieldid = 705) b 
		on a.UserID = b.UserID and a.AppID = b.AppID and a.SortOrder > b.SortOrder
GO
if not exists (select * from u_usersfields where userid = 1 and appid = 401 and fieldid = 754)
begin
	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 754, 
		SortOrder = SortOrder + 1, 
		GroupID, MultipleIndex, MandatoryStatus = 1000, Needed = 0, FieldSize = 1, 
		DataType = 50,  
        SubAppID = 0, LookUpTable = 'LU_Institution_TypeCode', CIHI_ID = '', 
		Header_CIHI_English = 'Institution From Type', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Institution From Type', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 1, 
		ParamOrder = 178, 
		ParamName = 'pInstFromType', 
		ParamDataType, ParamSize, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID in (100, 101, 102, 200, 201, 202, 301, 401) and fieldid = 667

	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 755, 
		SortOrder = SortOrder + 1, 
		GroupID, MultipleIndex, MandatoryStatus = 1000, Needed = 0, FieldSize = 1, 
		DataType = 50,  
        SubAppID = 0, LookUpTable = 'LU_Institution_TypeCode', CIHI_ID = '', 
		Header_CIHI_English = 'Institution To Type', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Institution To Type', 
		FieldEnabled = 1, 
        FieldVisible = 1, 
        DefaultValue = null, 
		ParamProcID = 1, 
		ParamOrder = 179, 
		ParamName = 'pInstToType', 
		ParamDataType, ParamSize, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  AppID in (100, 101, 102, 200, 201, 202, 301, 401) and fieldid = 705
end
GO
--End build 1
update U_UsersFields
set Header_CIHI_English = 'Investigative Technology Information'
where  AppID = 401 and fieldid = 165 and  Header_CIHI_English = 'Investigative Technolog Information'
GO
update U_UsersFields
set Header_User = 'Investigative Technology Information'
where  AppID = 401 and fieldid = 165 and Header_User = 'Investigative Technolog Information'
GO
update U_UsersFields
set Header_CIHI_English = 'Investigative Technology Occurrence'
where  AppID = 401 and fieldid = 983 and Header_CIHI_English = 'Investigative Technolog Occurrence'
GO
update U_UsersFields
set Header_User = 'Investigative Technology Occurrence'
where  AppID = 401 and fieldid = 983 and Header_User = 'Investigative Technolog Occurrence'
GO

update U_UsersFields
set Header_CIHI_English = 'Investigative Technology'
where  AppID = 401 and fieldid = 984 and Header_CIHI_English = 'Investigative Technolog'
GO
update U_UsersFields
set Header_User = 'Investigative Technology'
where  AppID = 401 and fieldid = 984 and Header_User = 'Investigative Technolog'
GO
--End build 1
--enable it
--Weight & Height
update u_usersfields
set FieldEnabled = 1,
    FieldVisible = 1
where fieldid in (835, 836) and appid in (200, 201, 202)
GO
--Blood
update u_usersfields
set FieldEnabled = 1,
    FieldVisible = 1
where [FieldID] between 1023 and 1031 and appid in (200, 201, 202, 401)
GO
--Mental Health
update u_usersfields
set FieldEnabled = 1,
    FieldVisible = 1
where [FieldID] = 1264 and appid in (200, 201, 202)
GO
update u_usersfields
set FieldEnabled = 1,
    FieldVisible = 1
where [FieldID] between 1263 and 1272 and appid in (200, 201, 202, 401) and [FieldID] <> 1264
GO
--1055 Enable Account Number in ROI Module
update  u_fields set fieldaccess = 0 where fieldid = 4653
GO
update u_usersfields set FieldEnabled = 2, FieldVisible = 2 where fieldid = 4653
GO
--0888 Add Institution Type to institution profile
if not exists (select * from information_schema.columns where table_name = 'H_InstitutionProfile' and column_name = 'InstitutionType')
	alter table H_InstitutionProfile add InstitutionType varchar(10)
GO
Update H_InstitutionProfile
set InstitutionType = z.[InstitutionType]
from H_InstitutionProfile a
	inner join [dbo].[LU_Institution_Type] z on a.CIHIValue = z.[InstitutionNumber]
GO
Update H_InstitutionProfile
set InstitutionType = ''
from H_InstitutionProfile a
where InstitutionType is null
GO
Update u_fields set propertyName = 'Height_ABS' where fieldid = 836 and  systemname = 'Height' 
GO
Update u_fields 
set PropertyName = 'Mental' + systemname
where systemname in ('LegalStatusUponArrivaltoED', 'LegalStatusAtAdmission', 'TypeOfRestraint01', 'FrequencyOfRestraint01', 
	'TypeOfRestraint02', 'FrequencyOfRestraint02', 'TypeOfRestraint03', 'FrequencyOfRestraint03', 'TypeOfRestraint04', 'FrequencyOfRestraint04')
	and PropertyName not like 'Mental%'
GO
--end build 2
update LU_DiagnosisType
set ValidTo = '2018/03/31'
where cihivalue = '4' and validto > '2018/03/31'
GO
declare @code int
declare @Add int
set @add = 0
set @code = 20
if not exists (select * from lu_project where code = 20 and CIHIValue = '440')
begin
	set @add = 1
	if exists (select * from lu_project where code = 20)
	begin
		--Move the project to other place
		set @code = (select max(code) from lu_project) + 1
		if @code < 500000
			set @code = 500001
		update lu_project set code = @code where code = 20
		update [dbo].[LU_ProjectQuestion1] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion2] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion3] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion4] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion5] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion6] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion7] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion8] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion9] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion10] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion11] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion12] set associationid = @code where associationid = 20
		update [dbo].[LU_ProjectQuestion13] set associationid = @code where associationid = 20
		update ab_project set projectnumber = @code where projectnumber = 20
	end
	insert into [dbo].[LU_Project](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, 
		QuestionState1, Question1, QuestionState2, Question2, QuestionState3, Question3, QuestionState4, Question4, QuestionState5, Question5, 
		QuestionState6, Question6, QuestionState7, Question7, QuestionState8, Question8, QuestionState9, Question9, QuestionState10, Question10, 
		QuestionState11, Question11, QuestionState12, Question12, QuestionState13, Question13, QuestionState14, Question14, QuestionState15, Question15,
		QuestionState16, Question16, QuestionState17, Question17, QuestionState18, Question18, QuestionState19, Question19, QuestionState20, Question20, 
		QuestionState21, Question21, QuestionState22, Question22, QuestionState23, Question23, QuestionState24, Question24,  
		InterfaceIn, HospitalID, LUText)
	select
		Code = 20, DisplayCode = '440', UserDescription = 'Endovascular Thrombectomy', DefaultDescription = 'Endovascular Thrombectomy', 
		CIHIValue = '440', ValidFrom = '2018-04-01', ValidTo = '2099-03-31', 
		QuestionState1 = 2,   Question1 = 'CTA, CTP or MRA Scan Performed Prior to Start of', -- of Endovascular Thrombectomy Intervention
		QuestionState2 = 11,  Question2 = 'First digit of Month of Qualifying Scan Prior to', 
		QuestionState3 = 11,  Question3 = 'Second digit of Month of Qualifying Scan Prior to', 
		QuestionState4 = 11,  Question4 = 'First digit of Day of Qualifying Scan Prior to', 
		QuestionState5 = 11,  Question5 = 'Second digit of Day of Qualifying Scan Prior to', 
		QuestionState6 = 11,  Question6 = 'First digit of Hour of Qualifying Scan Prior to', 
		QuestionState7 = 11,  Question7 = 'Second digit of Hour of Qualifying Scan Prior to', 
		QuestionState8 = 11,  Question8 = 'First digit of Minute of Qualifying Scan Prior to', 
		QuestionState9 = 11,  Question9 = 'Second digit of Minute of Qualifying Scan Prior to', 
		QuestionState10 = 11, Question10 = 'First digit of Day of Arterial Puncture', 
		QuestionState11 = 11, Question11 = 'Second digit of Day of Arterial Puncture', 
		QuestionState12 = 11, Question12 = 'First digit of Hour of Arterial Puncture', 
		QuestionState13 = 11, Question13 = 'Second digit of Hour of Arterial Puncture', 
		QuestionState14 = 11, Question14 = 'First digit of Minute of Arterial Puncture', 
		QuestionState15 = 11, Question15 = 'Second digit of Minute of Arterial Puncture',
		QuestionState16 = 11, Question16 = 'First Reperfusion Achieved', 
		QuestionState17 = 11, Question17 = 'First digit of Day of First Reperfusion Achieved', 
		QuestionState18 = 11, Question18 = 'Second digit of Day of First Reperfusion Achieved', 
		QuestionState19 = 11, Question19 = 'First digit of Hour of First Reperfusion Achieved', 
		QuestionState20 = 11, Question20 = 'Second digit of Hour of First Reperfusion Achieved', 
		QuestionState21 = 11, Question21 = 'First digit of Minute of First Reperfusion Achieved', 
		QuestionState22 = 11, Question22 = 'Second digit of Minute of First Reperfusion Achieved', 
		QuestionState23 = 11, Question23 = 'Final Endovascular Thrombectomy Reperfusion Outcome Achieved', 
		QuestionState24 = 10, Question24 = '',  
		InterfaceIn = '440', HospitalID = 0, LUText = ''

		--Question 1
		if exists (select * from [dbo].[LU_ProjectQuestion1] where code between 301 and 304 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion1])
			if @code < 500000 set @code = 500000
			update AB_Project set question1 = question1 + @code where question1 between 301 and 304
			update [LU_ProjectQuestion1] set code = code + @code where code between 301 and 304
		end
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, 'P', 'Yes, prior', 'Yes, prior', 'P', '2018-04-01', '2099-03-31', 20, 'P', 0, '')
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, 'Y', 'Yes', 'Yes', 'Y', '2018-04-01', '2099-03-31', 20, 'Y', 0, '')
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, 'N', 'No', 'No', 'N', '2018-04-01', '2099-03-31', 20, 'N', 0, '')
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '8', 'Not applicable', 'Not applicable', '8', '2018-04-01', '2099-03-31', 20, '8', 0, '')

		--Question 2
		if exists (select * from [dbo].[LU_ProjectQuestion2] where code between 301 and 303 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion2])
			if @code < 500000 set @code = 500000
			update AB_Project set question2 = question2 + @code where question2 between 301 and 304
			update [LU_ProjectQuestion2] set code = code + @code where code between 301 and 304
		end
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 3
		if exists (select * from [dbo].[LU_ProjectQuestion3] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion3])
			if @code < 500000 set @code = 500000
			update AB_Project set Question3 = Question3 + @code where Question3 between 301 and 310
			update [LU_ProjectQuestion3] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(305, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 20, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(306, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 20, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(307, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 20, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(308, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 20, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(309, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 20, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 4
		if exists (select * from [dbo].[LU_ProjectQuestion4] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion4])
			if @code < 500000 set @code = 500000
			update AB_Project set Question4 = Question4 + @code where Question4 between 301 and 310
			update [LU_ProjectQuestion4] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 5
		if exists (select * from [dbo].[LU_ProjectQuestion5] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion5])
			if @code < 500000 set @code = 500000
			update AB_Project set Question5 = Question5 + @code where Question5 between 301 and 310
			update [LU_ProjectQuestion5] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(305, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 20, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(306, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 20, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(307, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 20, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(308, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 20, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(309, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 20, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 6 the first digit of hour
		if exists (select * from [dbo].[LU_ProjectQuestion6] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion6])
			if @code < 500000 set @code = 500000
			update AB_Project set Question6 = Question6 + @code where Question6 between 301 and 310
			update [LU_ProjectQuestion6] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 7 the second digit of hour
		if exists (select * from [dbo].[LU_ProjectQuestion7] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion7])
			if @code < 500000 set @code = 500000
			update AB_Project set Question7 = Question7 + @code where Question7 between 301 and 310
			update [LU_ProjectQuestion7] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(305, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 20, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(306, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 20, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(307, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 20, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(308, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 20, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(309, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 20, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 8 the first digit of minute
		if exists (select * from [dbo].[LU_ProjectQuestion8] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion8])
			if @code < 500000 set @code = 500000
			update AB_Project set Question8 = Question8 + @code where Question8 between 301 and 310
			update [LU_ProjectQuestion8] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(305, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 20, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(306, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 20, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 9 the second digit of minute
		if exists (select * from [dbo].[LU_ProjectQuestion9] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion9])
			if @code < 500000 set @code = 500000
			update AB_Project set Question9 = Question9 + @code where Question9 between 301 and 310
			update [LU_ProjectQuestion9] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(305, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 20, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(306, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 20, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(307, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 20, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(308, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 20, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(309, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 20, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 10 the first digit of day of Arterial Puncture
		if exists (select * from [dbo].[LU_ProjectQuestion10] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion10])
			if @code < 500000 set @code = 500000
			update AB_Project set Question10 = Question10 + @code where Question10 between 301 and 310
			update [LU_ProjectQuestion10] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 11 the second digit of day of  Arterial Puncture
		if exists (select * from [dbo].[LU_ProjectQuestion11] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion11])
			if @code < 500000 set @code = 500000
			update AB_Project set Question11 = Question11 + @code where Question11 between 301 and 310
			update [LU_ProjectQuestion11] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(305, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 20, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(306, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 20, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(307, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 20, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(308, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 20, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(309, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 20, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 12 the first digit of hour of  Arterial Puncture
		if exists (select * from [dbo].[LU_ProjectQuestion12] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion12])
			if @code < 500000 set @code = 500000
			update AB_Project set Question12 = Question12 + @code where Question12 between 301 and 310
			update [LU_ProjectQuestion12] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')

		--Question 13 the second digit of hour of  Arterial Puncture
		if exists (select * from [dbo].[LU_ProjectQuestion13] where code between 301 and 310 and associationid <> 20)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion13])
			if @code < 500000 set @code = 500000
			update AB_Project set Question13 = Question13 + @code where Question13 between 301 and 310
			update [LU_ProjectQuestion13] set code = code + @code where code between 301 and 310
		end
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(301, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 20, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(302, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 20, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(303, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 20, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(304, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 20, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(305, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 20, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(306, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 20, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(307, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 20, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(308, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 20, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(309, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 20, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(310, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 20, '9', 0, '')
end
GO

update u_usersfields set LookupTable = 'LU_YesBlank'
where appid = 401 and fieldid between 1023 and 1031
GO

Delete [dbo].[LLU_BatchYears] where [BatchYear] = 2018
GO
Insert into [dbo].[LLU_BatchYears](Code, BatchYear, CareType, ICDType)
values(102, 2018, 1, 'T')
GO
Insert into [dbo].[LLU_BatchYears](Code, BatchYear, CareType, ICDType)
values(103, 2018, 2, 'T')
GO
Insert into [dbo].[LLU_BatchYears](Code, BatchYear, CareType, ICDType)
values(104, 2018, 3, 'T')
GO
Insert into [dbo].[LLU_BatchYears](Code, BatchYear, CareType, ICDType)
values(105, 2018, 4, 'T')
GO
Insert into [dbo].[LLU_BatchYears](Code, BatchYear, CareType, ICDType)
values(106, 2018, 5, 'T')
GO
Insert into [dbo].[LLU_BatchYears](Code, BatchYear, CareType, ICDType)
values(107, 2018, 7, 'T')
GO
--2.x-1019
update lu_CodeFile
set UserDescription = (case when UserDescription = 'Near Drowning' then 'Drowning' else UserDescription end),
	DefaultDescription = 'Drowning'
where lookupID = 1100 and cihivalue = '206'
GO
--2018 Submission
Delete from  [dbo].[SU_StructureList] where BatchYear = 2018
GO
insert into [dbo].[SU_StructureList](SU_type, Province, AppID, BatchYear, GroupID, GroupOrder, GroupDesc, list_id)
select SU_type, Province, AppID, BatchYear = 2018, GroupID, GroupOrder, GroupDesc = replace(GroupDesc, '2017', '2018'), list_id
from [SU_StructureList]
where batchyear = 2017
GO
Delete from [dbo].[SU_StructureFile] where groupid in (74, 75, 76, 77)
GO
--NACRS Level 1
Update [dbo].[SU_StructureList] set GroupID = 74 where BatchYear = 2018 and GroupID = 72
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 74, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 72
GO
Update [dbo].[SU_StructureFile] 
set FieldName = 'DiagnosisPrefix', FieldID = 1152, RecodeID = 0
where groupid = 74 and TextPosition in (381, 389, 397, 405, 413, 421, 429, 437, 445) and TableName = 'AB_Diagnosis' and FieldName like 'Filter%'
GO
Update [dbo].[SU_StructureFile] 
set TextLength = 280,
	FieldAlias = 'Intervention Info'
where GroupID = 74 and TextPosition = 453
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 74, SubGroupID + 40, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 733 and 737 order by textposition
GO
Update [dbo].[SU_StructureFile] 
set TextPosition = 738,
	TextLength = 538
where GroupID = 74 and TextPosition = 969
GO
--Mental Health
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival to ED', 'LegalStatusUponArrivaltoED', 1263,  0, 0, 2176, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 1', 'TypeOfRestraint01', 1265,  0, 0, 2178, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 1', 'FrequencyOfRestraint01', 1266,  0, 0, 2179, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 2', 'TypeOfRestraint02', 1267,  0, 0, 2181, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 2', 'FrequencyOfRestraint02', 1268,  0, 0, 2182, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 3', 'TypeOfRestraint03', 1269,  0, 0, 2184, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 3', 'FrequencyOfRestraint03', 1270,  0, 0, 2185, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 4', 'TypeOfRestraint04', 1271,  0, 0, 2187, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 4', 'FrequencyOfRestraint04', 1272,  0, 0, 2188, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 56, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  1, 0, 2190, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 57, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  2, 0, 2193, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 58, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  3, 0, 2196, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 59, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  1, 0, 2199, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 59, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  1, 0, 2202, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 60, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  2, 0, 2204, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 60, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  2, 0, 2207, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 61, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  3, 0, 2209, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 61, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  3, 0, 2212, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--Level 2
Update [dbo].[SU_StructureList] set GroupID = 75 where BatchYear = 2018 and GroupID = 73
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 73
GO
Update [dbo].[SU_StructureFile] 
set FieldName = 'DiagnosisPrefix', FieldID = 1152, RecodeID = 0
where groupid = 75 and TextPosition in (381, 389, 397, 405, 413, 421, 429, 437, 445) and TableName = 'AB_Diagnosis' and FieldName like 'Filter%'
GO
Update [dbo].[SU_StructureFile] 
set TextLength = 280,
	FieldAlias = 'Intervention Info'
where GroupID = 75 and TextPosition = 453
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID + 40, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 733 and 737 order by textposition
GO
Update [dbo].[SU_StructureFile] 
set TextPosition = 738,
	TextLength = 387
where GroupID = 75 and TextPosition = 969
GO
--CACS
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 1125 and 1131 order by textposition
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 0, 'T', 'AB_Abstract', 'Complete Record  ', 'Filler_1140', NULL, 0, 2, 1140, 136, 0)
GO
Delete from  [dbo].[SU_StructureFile] where GroupID = 75 and TextPosition = 1497
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 1497 and 1499 order by textposition
GO

--Mental Health
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival to ED', 'LegalStatusUponArrivaltoED', 1263,  0, 0, 2176, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 1', 'TypeOfRestraint01', 1265,  0, 0, 2178, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 1', 'FrequencyOfRestraint01', 1266,  0, 0, 2179, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 2', 'TypeOfRestraint02', 1267,  0, 0, 2181, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 2', 'FrequencyOfRestraint02', 1268,  0, 0, 2182, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 3', 'TypeOfRestraint03', 1269,  0, 0, 2184, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 3', 'FrequencyOfRestraint03', 1270,  0, 0, 2185, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 4', 'TypeOfRestraint04', 1271,  0, 0, 2187, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 4', 'FrequencyOfRestraint04', 1272,  0, 0, 2188, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 56, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  1, 0, 2190, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 57, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  2, 0, 2193, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 58, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  3, 0, 2196, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 59, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  1, 0, 2199, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 59, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  1, 0, 2202, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 60, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  2, 0, 2204, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 60, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  2, 0, 2207, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 61, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  3, 0, 2209, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 61, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  3, 0, 2212, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--Level 3
Update [dbo].[SU_StructureList] set GroupID = 76 where BatchYear = 2018 and GroupID = 68
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 76, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 68
GO
--Mental Health
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival to ED', 'LegalStatusUponArrivaltoED', 1263,  0, 0, 2176, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 1', 'TypeOfRestraint01', 1265,  0, 0, 2178, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 1', 'FrequencyOfRestraint01', 1266,  0, 0, 2179, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 2', 'TypeOfRestraint02', 1267,  0, 0, 2181, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 2', 'FrequencyOfRestraint02', 1268,  0, 0, 2182, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 3', 'TypeOfRestraint03', 1269,  0, 0, 2184, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 3', 'FrequencyOfRestraint03', 1270,  0, 0, 2185, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 4', 'TypeOfRestraint04', 1271,  0, 0, 2187, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 4', 'FrequencyOfRestraint04', 1272,  0, 0, 2188, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 80, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  1, 0, 2190, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 81, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  2, 0, 2193, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 82, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  3, 0, 2196, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 83, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  1, 0, 2199, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 83, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  1, 0, 2202, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 84, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  2, 0, 2204, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 84, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  2, 0, 2207, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 85, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  3, 0, 2209, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 85, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  3, 0, 2212, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--Level lite
Update [dbo].[SU_StructureList] set GroupID = 77 where BatchYear = 2018 and GroupID = 71
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 77, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 71
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 0, 'T', 'AB_Abstract', 'Mental Health', 'Filler_2176', null,  0, 2, 2176, 38, 0)
GO
--Blood
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--End build 3
--1093 -   2018 BC Report Periods
declare @province varchar(20)
set @Province = (select top 1 p.CIHIValue from H_HospitalProfile h inner join lu_province p on h.provincenumber = p.code)
if @Province = '9'
begin
    delete from lu_batchperiod where code between 460 and 472
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(460, '01', 'Period 01 - 2018', 'Period 01 - 2018', '01', '2018/04/01', '2019/03/31', '01-Apr-2018', '03-May-2018', '01', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(461, '02', 'Period 02 - 2018', 'Period 02 - 2018', '02', '2018/04/01', '2019/03/31', '04-May-2018', '31-May-2018', '02', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(462, '03', 'Period 03 - 2018', 'Period 03 - 2018', '03', '2018/04/01', '2019/03/31', '01-Jun-2018', '28-Jun-2018', '03', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(463, '04', 'Period 04 - 2018', 'Period 04 - 2018', '04', '2018/04/01', '2019/03/31', '29-Jun-2018', '26-Jul-2018', '04', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(464, '05', 'Period 05 - 2018', 'Period 05 - 2018', '05', '2018/04/01', '2019/03/31', '27-Jul-2018', '23-Aug-2018', '05', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(465, '06', 'Period 06 - 2018', 'Period 06 - 2018', '06', '2018/04/01', '2019/03/31', '24-Aug-2018', '20-Sep-2018', '06', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(466, '07', 'Period 07 - 2018', 'Period 07 - 2018', '07', '2018/04/01', '2019/03/31', '21-Sep-2018', '18-Oct-2018', '07', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(467, '08', 'Period 08 - 2018', 'Period 08 - 2018', '08', '2018/04/01', '2019/03/31', '19-Oct-2018', '15-Nov-2018', '08', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(468, '09', 'Period 09 - 2018', 'Period 09 - 2018', '09', '2018/04/01', '2019/03/31', '16-Nov-2018', '13-Dec-2018', '09', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(469, '10', 'Period 10 - 2018', 'Period 10 - 2018', '10', '2018/04/01', '2019/03/31', '14-Dec-2018', '10-Jan-2019', '10', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(470, '11', 'Period 11 - 2018', 'Period 11 - 2018', '11', '2018/04/01', '2019/03/31', '11-Jan-2019', '07-Feb-2019', '11', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(471, '12', 'Period 12 - 2018', 'Period 12 - 2018', '12', '2018/04/01', '2019/03/31', '08-Feb-2019', '07-Mar-2019', '12', 0, '')
	insert into [dbo].[LU_BatchPeriod](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, CIHIDateFrom, CIHIDateTo, InterfaceIn, HospitalID, LUText)
	values(472, '13', 'Period 13 - 2018', 'Period 13 - 2018', '13', '2018/04/01', '2019/03/31', '08-Mar-2019', '31-Mar-2019', '13', 0, '')
end
GO
Update LU_EDIntervnetionPickList set UserDescription = 'Removal Foreign Body Eye' where CIHIValue = 'I24' and UserDescription = 'Removal foreign body cornea'
GO
Update LU_EDIntervnetionPickList set DefaultDescription = 'Removal Foreign Body Eye' where CIHIValue = 'I24'
GO
update [dbo].[LU_EDInvestigativeTechnology]
set UserDescription = b.y, DefaultDescription = b.y
from [dbo].[LU_EDInvestigativeTechnology] a
full join
(
select x = 'C01', y = 'CT Scan   Head/Brain, Neck or Upper Extremities' union
select x = 'C02', y = 'CT Scan  Other Specified Sites' union
select x = 'M01', y = 'MRI  Any Site' union
select x = 'N01', y = 'Nuclear Imaging  Chest, Spine' union
select x = 'N02', y = 'Nuclear Imaging  Other Specified Site' union
select x = 'U01', y = 'Ultrasound  Other Specified Site' union
select x = 'U02', y = 'Ultrasound  Head, Neck or Extremities' union
select x = 'X01', y = 'Xray  Extremities' union
select x = 'X02', y = 'Xray  Other Specified Site' 
) b on a.cihivalue = b.x
where isnull(a.userdescription, '') <> isnull(b.y, '')
GO
--2018 Submission
Delete from  [dbo].[SU_StructureList] where BatchYear = 2018
GO
insert into [dbo].[SU_StructureList](SU_type, Province, AppID, BatchYear, GroupID, GroupOrder, GroupDesc, list_id)
select SU_type, Province, AppID, BatchYear = 2018, GroupID, GroupOrder, GroupDesc = replace(GroupDesc, '2017', '2018'), list_id
from [SU_StructureList]
where batchyear = 2017
GO
Delete from [dbo].[SU_StructureFile] where groupid in (74, 75, 76, 77)
GO
--NACRS Level 1
Update [dbo].[SU_StructureList] set GroupID = 74 where BatchYear = 2018 and GroupID = 72
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 74, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 72
GO
Update [dbo].[SU_StructureFile] 
set FieldName = 'DiagnosisPrefix', FieldID = 1152, RecodeID = 0
where groupid = 74 and TextPosition in (381, 389, 397, 405, 413, 421, 429, 437, 445) and TableName = 'AB_Diagnosis' and FieldName like 'Filter%'
GO
Update [dbo].[SU_StructureFile] 
set TextLength = 280,
	FieldAlias = 'Intervention Info'
where GroupID = 74 and TextPosition = 453
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 74, SubGroupID + 40, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 733 and 737 order by textposition
GO
Update [dbo].[SU_StructureFile] 
set TextPosition = 738,
	TextLength = 538
where GroupID = 74 and TextPosition = 969
GO
--Mental Health
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival to ED', 'LegalStatusUponArrivaltoED', 1263,  0, 0, 2176, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 1', 'TypeOfRestraint01', 1265,  0, 0, 2178, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 1', 'FrequencyOfRestraint01', 1266,  0, 0, 2179, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 2', 'TypeOfRestraint02', 1267,  0, 0, 2181, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 2', 'FrequencyOfRestraint02', 1268,  0, 0, 2182, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 3', 'TypeOfRestraint03', 1269,  0, 0, 2184, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 3', 'FrequencyOfRestraint03', 1270,  0, 0, 2185, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 4', 'TypeOfRestraint04', 1271,  0, 0, 2187, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 4', 'FrequencyOfRestraint04', 1272,  0, 0, 2188, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 56, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  1, 0, 2190, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 57, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  2, 0, 2193, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 58, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  3, 0, 2196, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 59, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  1, 0, 2199, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 59, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  1, 0, 2202, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 60, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  2, 0, 2204, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 60, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  2, 0, 2207, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 61, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  3, 0, 2209, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 61, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  3, 0, 2212, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(74, 62, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--Level 2
Update [dbo].[SU_StructureList] set GroupID = 75 where BatchYear = 2018 and GroupID = 73
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 73
GO
Update [dbo].[SU_StructureFile] 
set FieldName = 'DiagnosisPrefix', FieldID = 1152, RecodeID = 0
where groupid = 75 and TextPosition in (381, 389, 397, 405, 413, 421, 429, 437, 445) and TableName = 'AB_Diagnosis' and FieldName like 'Filter%'
GO
Update [dbo].[SU_StructureFile] 
set TextLength = 280,
	FieldAlias = 'Intervention Info'
where GroupID = 75 and TextPosition = 453
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID + 40, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 733 and 737 order by textposition
GO
Update [dbo].[SU_StructureFile] 
set TextPosition = 738,
	TextLength = 387
where GroupID = 75 and TextPosition = 969
GO
--CACS
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 1125 and 1131 order by textposition
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 0, 'T', 'AB_Abstract', 'Complete Record  ', 'Filler_1140', NULL, 0, 2, 1140, 136, 0)
GO
Delete from  [dbo].[SU_StructureFile] where GroupID = 75 and TextPosition = 1497
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 75, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile] 
where GroupID = 68 and textposition between 1497 and 1499 order by textposition
GO

--Mental Health
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival to ED', 'LegalStatusUponArrivaltoED', 1263,  0, 0, 2176, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 1', 'TypeOfRestraint01', 1265,  0, 0, 2178, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 1', 'FrequencyOfRestraint01', 1266,  0, 0, 2179, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 2', 'TypeOfRestraint02', 1267,  0, 0, 2181, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 2', 'FrequencyOfRestraint02', 1268,  0, 0, 2182, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 3', 'TypeOfRestraint03', 1269,  0, 0, 2184, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 3', 'FrequencyOfRestraint03', 1270,  0, 0, 2185, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Type of Restraint 4', 'TypeOfRestraint04', 1271,  0, 0, 2187, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 55, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 4', 'FrequencyOfRestraint04', 1272,  0, 0, 2188, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 56, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  1, 0, 2190, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 57, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  2, 0, 2193, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 58, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  3, 0, 2196, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 59, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  1, 0, 2199, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 59, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  1, 0, 2202, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 60, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  2, 0, 2204, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 60, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  2, 0, 2207, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 61, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  3, 0, 2209, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 61, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  3, 0, 2212, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(75, 62, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--Level 3
Update [dbo].[SU_StructureList] set GroupID = 76 where BatchYear = 2018 and GroupID = 68
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 76, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 68
GO
--Mental Health
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival to ED', 'LegalStatusUponArrivaltoED', 1263,  0, 0, 2176, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 1', 'TypeOfRestraint01', 1265,  0, 0, 2178, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 1', 'FrequencyOfRestraint01', 1266,  0, 0, 2179, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 2', 'TypeOfRestraint02', 1267,  0, 0, 2181, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 2', 'FrequencyOfRestraint02', 1268,  0, 0, 2182, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 3', 'TypeOfRestraint03', 1269,  0, 0, 2184, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 3', 'FrequencyOfRestraint03', 1270,  0, 0, 2185, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Type of Restraint 4', 'TypeOfRestraint04', 1271,  0, 0, 2187, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 79, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 4', 'FrequencyOfRestraint04', 1272,  0, 0, 2188, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 80, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  1, 0, 2190, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 81, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  2, 0, 2193, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 82, 'T', 'AB_EDInterventionPicklist', 'ED Intervention Pick List', 'EDInterventionPickList', 982,  3, 0, 2196, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 83, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  1, 0, 2199, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 83, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  1, 0, 2202, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 84, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  2, 0, 2204, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 84, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  2, 0, 2207, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 85, 'T', 'AB_InvestigativeTechnology', 'ED Investigative Technology', 'InvestigativeTechnology', 984,  3, 0, 2209, 3, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 85, 'T', 'AB_InvestigativeTechnology', 'Number of Investigative Technologies Performed', 'NumberInvestigativeTechnologyPerformed', 985,  3, 0, 2212, 2, 2)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(76, 40, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--Level lite
Update [dbo].[SU_StructureList] set GroupID = 77 where BatchYear = 2018 and GroupID = 71
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 77, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 71
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 0, 'T', 'AB_Abstract', 'Mental Health', 'Filler_2176', null,  0, 2, 2176, 38, 0)
GO
--Blood
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 2214, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 2215, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 2216, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 2217, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 2218, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 2219, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 2220, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 2221, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(77, 40, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 2222, 1, 0)
GO
--End build 4

insert into LU_MentalLegalStatusUponArrivalED(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
select a.code, a.CIHIValue, a.UserDescription, a.UserDescription, a.CIHIValue, '2018/04/01', '2099/03/31', a.CIHIValue,  0, ''
from (
    select code = 1, CIHIValue = '10', UserDescription = 'Voluntary'
    union
    select code = 2, CIHIValue = '11', UserDescription = 'P/T locally assigned'
    union
    select code = 3, CIHIValue = '12', UserDescription = 'P/T locally assigned'
    union
    select code = 4, CIHIValue = '13', UserDescription = 'P/T locally assigned'
    union
    select code = 5, CIHIValue = '14', UserDescription = 'P/T locally assigned'
    union
    select code = 6, CIHIValue = '15', UserDescription = 'P/T locally assigned'
    union
    select code = 7, CIHIValue = '16', UserDescription = 'P/T locally assigned'
    union
    select code = 8, CIHIValue = '17', UserDescription = 'P/T locally assigned'
    union
    select code = 9, CIHIValue = '18', UserDescription = 'P/T locally assigned'
    union
    select code = 10, CIHIValue = '19', UserDescription = 'P/T locally assigned'
    union
    select code = 11, CIHIValue = '30', UserDescription = 'Orders for Assessment / Apprehension'
    union
    select code = 12, CIHIValue = '31', UserDescription = 'P/T locally assigned'
    union
    select code = 13, CIHIValue = '32', UserDescription = 'P/T locally assigned'
    union
    select code = 14, CIHIValue = '33', UserDescription = 'P/T locally assigned'
    union
    select code = 15, CIHIValue = '34', UserDescription = 'P/T locally assigned'
    union
    select code = 16, CIHIValue = '35', UserDescription = 'P/T locally assigned'
    union
    select code = 17, CIHIValue = '36', UserDescription = 'P/T locally assigned'
    union
    select code = 18, CIHIValue = '37', UserDescription = 'P/T locally assigned'
    union
    select code = 19, CIHIValue = '38', UserDescription = 'P/T locally assigned'
    union
    select code = 20, CIHIValue = '39', UserDescription = 'Community Treatment Order (CTO)'
    union
    select code = 21, CIHIValue = '40', UserDescription = 'Drug Treatment Court'
    union
    select code = 22, CIHIValue = '41', UserDescription = 'P/T locally assigned'
    union
    select code = 23, CIHIValue = '42', UserDescription = 'P/T locally assigned'
    union
    select code = 24, CIHIValue = '43', UserDescription = 'P/T locally assigned'
    union
    select code = 25, CIHIValue = '44', UserDescription = 'P/T locally assigned'
    union
    select code = 26, CIHIValue = '45', UserDescription = 'P/T locally assigned'
    union
    select code = 27, CIHIValue = '46', UserDescription = 'P/T locally assigned'
    union
    select code = 28, CIHIValue = '47', UserDescription = 'P/T locally assigned'
    union
    select code = 29, CIHIValue = '48', UserDescription = 'P/T locally assigned'
    union
    select code = 30, CIHIValue = '49', UserDescription = 'P/T locally assigned'
    union
    select code = 31, CIHIValue = '50', UserDescription = 'Forensic admission'
    union
    select code = 32, CIHIValue = '51', UserDescription = 'P/T locally assigned'
    union
    select code = 33, CIHIValue = '52', UserDescription = 'P/T locally assigned'
    union
    select code = 34, CIHIValue = '53', UserDescription = 'P/T locally assigned'
    union
    select code = 35, CIHIValue = '54', UserDescription = 'P/T locally assigned'
    union
    select code = 36, CIHIValue = '55', UserDescription = 'P/T locally assigned'
    union
    select code = 37, CIHIValue = '56', UserDescription = 'P/T locally assigned'
    union
    select code = 38, CIHIValue = '57', UserDescription = 'P/T locally assigned'
    union
    select code = 39, CIHIValue = '58', UserDescription = 'P/T locally assigned'
    union
    select code = 40, CIHIValue = '59', UserDescription = 'P/T locally assigned'
    union
    select code = 41, CIHIValue = '60', UserDescription = 'Consent to admission'
    union
    select code = 42, CIHIValue = '61', UserDescription = 'P/T locally assigned'
    union
    select code = 43, CIHIValue = '62', UserDescription = 'P/T locally assigned'
    union
    select code = 44, CIHIValue = '63', UserDescription = 'P/T locally assigned'
    union
    select code = 45, CIHIValue = '64', UserDescription = 'P/T locally assigned'
    union
    select code = 46, CIHIValue = '65', UserDescription = 'P/T locally assigned'
    union
    select code = 47, CIHIValue = '66', UserDescription = 'P/T locally assigned'
    union
    select code = 48, CIHIValue = '67', UserDescription = 'P/T locally assigned'
    union
    select code = 49, CIHIValue = '68', UserDescription = 'P/T locally assigned'
    union
    select code = 50, CIHIValue = '69', UserDescription = 'P/T locally assigned'
    union
    select code = 51, CIHIValue = '70', UserDescription = 'Inmates'
    union
    select code = 52, CIHIValue = '71', UserDescription = 'P/T locally assigned'
    union
    select code = 53, CIHIValue = '72', UserDescription = 'P/T locally assigned'
    union
    select code = 54, CIHIValue = '73', UserDescription = 'P/T locally assigned'
    union
    select code = 55, CIHIValue = '74', UserDescription = 'P/T locally assigned'
    union
    select code = 56, CIHIValue = '75', UserDescription = 'P/T locally assigned'
    union
    select code = 57, CIHIValue = '76', UserDescription = 'P/T locally assigned'
    union
    select code = 58, CIHIValue = '77', UserDescription = 'P/T locally assigned'
    union
    select code = 59, CIHIValue = '78', UserDescription = 'P/T locally assigned'
    union
    select code = 60, CIHIValue = '79', UserDescription = 'P/T locally assigned'
    union
    select code = 61, CIHIValue = '80', UserDescription = 'Other'
    union
    select code = 62, CIHIValue = '81', UserDescription = 'P/T locally assigned'
    union
    select code = 63, CIHIValue = '82', UserDescription = 'P/T locally assigned'
    union
    select code = 64, CIHIValue = '83', UserDescription = 'P/T locally assigned'
    union
    select code = 65, CIHIValue = '84', UserDescription = 'P/T locally assigned'
    union
    select code = 66, CIHIValue = '85', UserDescription = 'P/T locally assigned'
    union
    select code = 67, CIHIValue = '86', UserDescription = 'P/T locally assigned'
    union
    select code = 68, CIHIValue = '87', UserDescription = 'P/T locally assigned'
    union
    select code = 69, CIHIValue = '88', UserDescription = 'P/T locally assigned'
    union
    select code = 70, CIHIValue = '89', UserDescription = 'P/T locally assigned'
    union
    select code = 71, CIHIValue = '99', UserDescription = 'Unknown') a
left join LU_MentalLegalStatusUponArrivalED b on a.code = b.code
where b.code is null
GO
insert into LU_MentalLegalStatusAdmission(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
select a.code, a.CIHIValue, a.UserDescription, a.UserDescription, a.CIHIValue, '2018/04/01', '2099/03/31', a.CIHIValue,  0, ''
from (
    select code = 1, CIHIValue = '10', UserDescription = 'Voluntary'
    union
    select code = 2, CIHIValue = '11', UserDescription = 'P/T locally assigned'
    union
    select code = 3, CIHIValue = '12', UserDescription = 'P/T locally assigned'
    union
    select code = 4, CIHIValue = '13', UserDescription = 'P/T locally assigned'
    union
    select code = 5, CIHIValue = '14', UserDescription = 'P/T locally assigned'
    union
    select code = 6, CIHIValue = '15', UserDescription = 'P/T locally assigned'
    union
    select code = 7, CIHIValue = '16', UserDescription = 'P/T locally assigned'
    union
    select code = 8, CIHIValue = '17', UserDescription = 'P/T locally assigned'
    union
    select code = 9, CIHIValue = '18', UserDescription = 'P/T locally assigned'
    union
    select code = 10, CIHIValue = '19', UserDescription = 'P/T locally assigned'
    union
    select code = 11, CIHIValue = '20', UserDescription = 'Involuntary Psychiatric Assessment'
    union
    select code = 12, CIHIValue = '21', UserDescription = 'P/T locally assigned'
    union
    select code = 13, CIHIValue = '22', UserDescription = 'P/T locally assigned'
    union
    select code = 14, CIHIValue = '23', UserDescription = 'P/T locally assigned'
    union
    select code = 15, CIHIValue = '24', UserDescription = 'P/T locally assigned'
    union
    select code = 16, CIHIValue = '25', UserDescription = 'P/T locally assigned'
    union
    select code = 17, CIHIValue = '26', UserDescription = 'P/T locally assigned'
    union
    select code = 18, CIHIValue = '27', UserDescription = 'P/T locally assigned'
    union
    select code = 19, CIHIValue = '28', UserDescription = 'P/T locally assigned'
    union
    select code = 20, CIHIValue = '29', UserDescription = 'P/T locally assigned'
    union
    select code = 21, CIHIValue = '40', UserDescription = 'Drug Treatment Court'
    union
    select code = 22, CIHIValue = '41', UserDescription = 'P/T locally assigned'
    union
    select code = 23, CIHIValue = '42', UserDescription = 'P/T locally assigned'
    union
    select code = 24, CIHIValue = '43', UserDescription = 'P/T locally assigned'
    union
    select code = 25, CIHIValue = '44', UserDescription = 'P/T locally assigned'
    union
    select code = 26, CIHIValue = '45', UserDescription = 'P/T locally assigned'
    union
    select code = 27, CIHIValue = '46', UserDescription = 'P/T locally assigned'
    union
    select code = 28, CIHIValue = '47', UserDescription = 'P/T locally assigned'
    union
    select code = 29, CIHIValue = '48', UserDescription = 'P/T locally assigned'
    union
    select code = 30, CIHIValue = '49', UserDescription = 'P/T locally assigned'
    union
    select code = 31, CIHIValue = '50', UserDescription = 'Forensic admission'
    union
    select code = 32, CIHIValue = '51', UserDescription = 'P/T locally assigned'
    union
    select code = 33, CIHIValue = '52', UserDescription = 'P/T locally assigned'
    union
    select code = 34, CIHIValue = '53', UserDescription = 'P/T locally assigned'
    union
    select code = 35, CIHIValue = '54', UserDescription = 'P/T locally assigned'
    union
    select code = 36, CIHIValue = '55', UserDescription = 'P/T locally assigned'
    union
    select code = 37, CIHIValue = '56', UserDescription = 'P/T locally assigned'
    union
    select code = 38, CIHIValue = '57', UserDescription = 'P/T locally assigned'
    union
    select code = 39, CIHIValue = '58', UserDescription = 'P/T locally assigned'
    union
    select code = 40, CIHIValue = '59', UserDescription = 'P/T locally assigned'
    union
    select code = 41, CIHIValue = '60', UserDescription = 'Consent to admission'
    union
    select code = 42, CIHIValue = '61', UserDescription = 'P/T locally assigned'
    union
    select code = 43, CIHIValue = '62', UserDescription = 'P/T locally assigned'
    union
    select code = 44, CIHIValue = '63', UserDescription = 'P/T locally assigned'
    union
    select code = 45, CIHIValue = '64', UserDescription = 'P/T locally assigned'
    union
    select code = 46, CIHIValue = '65', UserDescription = 'P/T locally assigned'
    union
    select code = 47, CIHIValue = '66', UserDescription = 'P/T locally assigned'
    union
    select code = 48, CIHIValue = '67', UserDescription = 'P/T locally assigned'
    union
    select code = 49, CIHIValue = '68', UserDescription = 'P/T locally assigned'
    union
    select code = 50, CIHIValue = '69', UserDescription = 'P/T locally assigned'
    union
    select code = 51, CIHIValue = '70', UserDescription = 'Inmates'
    union
    select code = 52, CIHIValue = '71', UserDescription = 'P/T locally assigned'
    union
    select code = 53, CIHIValue = '72', UserDescription = 'P/T locally assigned'
    union
    select code = 54, CIHIValue = '73', UserDescription = 'P/T locally assigned'
    union
    select code = 55, CIHIValue = '74', UserDescription = 'P/T locally assigned'
    union
    select code = 56, CIHIValue = '75', UserDescription = 'P/T locally assigned'
    union
    select code = 57, CIHIValue = '76', UserDescription = 'P/T locally assigned'
    union
    select code = 58, CIHIValue = '77', UserDescription = 'P/T locally assigned'
    union
    select code = 59, CIHIValue = '78', UserDescription = 'P/T locally assigned'
    union
    select code = 60, CIHIValue = '79', UserDescription = 'P/T locally assigned'
    union
    select code = 61, CIHIValue = '80', UserDescription = 'Other'
    union
    select code = 62, CIHIValue = '81', UserDescription = 'P/T locally assigned'
    union
    select code = 63, CIHIValue = '82', UserDescription = 'P/T locally assigned'
    union
    select code = 64, CIHIValue = '83', UserDescription = 'P/T locally assigned'
    union
    select code = 65, CIHIValue = '84', UserDescription = 'P/T locally assigned'
    union
    select code = 66, CIHIValue = '85', UserDescription = 'P/T locally assigned'
    union
    select code = 67, CIHIValue = '86', UserDescription = 'P/T locally assigned'
    union
    select code = 68, CIHIValue = '87', UserDescription = 'P/T locally assigned'
    union
    select code = 69, CIHIValue = '88', UserDescription = 'P/T locally assigned'
    union
    select code = 70, CIHIValue = '89', UserDescription = 'P/T locally assigned'
    union
    select code = 71, CIHIValue = '99', UserDescription = 'Unknown - not documented'
    ) a
	left join LU_MentalLegalStatusAdmission b on a.code = b.code
where b.code is null
GO
insert into LU_MentalLegalStatusUponArrivalED_A(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
select a.code, a.CIHIValue, a.UserDescription, a.UserDescription, a.CIHIValue, '2018/04/01', '2099/03/31', a.CIHIValue,  0, ''
from (
    select code = 11, CIHIValue = '30', UserDescription = 'Orders for Assessment / Apprehension'
    union
    select code = 12, CIHIValue = '31', UserDescription = 'P/T locally assigned'
    union
    select code = 13, CIHIValue = '32', UserDescription = 'P/T locally assigned'
    union
    select code = 14, CIHIValue = '33', UserDescription = 'P/T locally assigned'
    union
    select code = 15, CIHIValue = '34', UserDescription = 'P/T locally assigned'
    union
    select code = 16, CIHIValue = '35', UserDescription = 'P/T locally assigned'
    union
    select code = 17, CIHIValue = '36', UserDescription = 'P/T locally assigned'
    union
    select code = 18, CIHIValue = '37', UserDescription = 'P/T locally assigned'
    union
    select code = 19, CIHIValue = '38', UserDescription = 'P/T locally assigned'
    union
    select code = 20, CIHIValue = '39', UserDescription = 'Community Treatment Order (CTO)'
    union
    select code = 21, CIHIValue = '40', UserDescription = 'Drug Treatment Court'
    union
    select code = 22, CIHIValue = '41', UserDescription = 'P/T locally assigned'
    union
    select code = 23, CIHIValue = '42', UserDescription = 'P/T locally assigned'
    union
    select code = 24, CIHIValue = '43', UserDescription = 'P/T locally assigned'
    union
    select code = 25, CIHIValue = '44', UserDescription = 'P/T locally assigned'
    union
    select code = 26, CIHIValue = '45', UserDescription = 'P/T locally assigned'
    union
    select code = 27, CIHIValue = '46', UserDescription = 'P/T locally assigned'
    union
    select code = 28, CIHIValue = '47', UserDescription = 'P/T locally assigned'
    union
    select code = 29, CIHIValue = '48', UserDescription = 'P/T locally assigned'
    union
    select code = 30, CIHIValue = '49', UserDescription = 'P/T locally assigned'
    union
    select code = 31, CIHIValue = '50', UserDescription = 'Forensic admission'
    union
    select code = 32, CIHIValue = '51', UserDescription = 'P/T locally assigned'
    union
    select code = 33, CIHIValue = '52', UserDescription = 'P/T locally assigned'
    union
    select code = 34, CIHIValue = '53', UserDescription = 'P/T locally assigned'
    union
    select code = 35, CIHIValue = '54', UserDescription = 'P/T locally assigned'
    union
    select code = 36, CIHIValue = '55', UserDescription = 'P/T locally assigned'
    union
    select code = 37, CIHIValue = '56', UserDescription = 'P/T locally assigned'
    union
    select code = 38, CIHIValue = '57', UserDescription = 'P/T locally assigned'
    union
    select code = 39, CIHIValue = '58', UserDescription = 'P/T locally assigned'
    union
    select code = 40, CIHIValue = '59', UserDescription = 'P/T locally assigned'
    union
    select code = 41, CIHIValue = '60', UserDescription = 'Consent to admission'
    union
    select code = 42, CIHIValue = '61', UserDescription = 'P/T locally assigned'
    union
    select code = 43, CIHIValue = '62', UserDescription = 'P/T locally assigned'
    union
    select code = 44, CIHIValue = '63', UserDescription = 'P/T locally assigned'
    union
    select code = 45, CIHIValue = '64', UserDescription = 'P/T locally assigned'
    union
    select code = 46, CIHIValue = '65', UserDescription = 'P/T locally assigned'
    union
    select code = 47, CIHIValue = '66', UserDescription = 'P/T locally assigned'
    union
    select code = 48, CIHIValue = '67', UserDescription = 'P/T locally assigned'
    union
    select code = 49, CIHIValue = '68', UserDescription = 'P/T locally assigned'
    union
    select code = 50, CIHIValue = '69', UserDescription = 'P/T locally assigned'
    union
    select code = 51, CIHIValue = '70', UserDescription = 'Inmates'
    union
    select code = 52, CIHIValue = '71', UserDescription = 'P/T locally assigned'
    union
    select code = 53, CIHIValue = '72', UserDescription = 'P/T locally assigned'
    union
    select code = 54, CIHIValue = '73', UserDescription = 'P/T locally assigned'
    union
    select code = 55, CIHIValue = '74', UserDescription = 'P/T locally assigned'
    union
    select code = 56, CIHIValue = '75', UserDescription = 'P/T locally assigned'
    union
    select code = 57, CIHIValue = '76', UserDescription = 'P/T locally assigned'
    union
    select code = 58, CIHIValue = '77', UserDescription = 'P/T locally assigned'
    union
    select code = 59, CIHIValue = '78', UserDescription = 'P/T locally assigned'
    union
    select code = 60, CIHIValue = '79', UserDescription = 'P/T locally assigned'
    union
    select code = 61, CIHIValue = '80', UserDescription = 'Other'
) a
left join LU_MentalLegalStatusUponArrivalED_A b on a.code = b.code
where b.code is null
GO
--1105 
update  [dbo].[U_UsersFields] set CIHI_ID = '174' where  AppID = 401 and fieldid = 984
GO
update  [dbo].[U_UsersFields] set CIHI_ID = '175' where  AppID = 401 and fieldid = 985
GO
update u_usersfields
set DataType = 50
where appid = 401 and fieldid in (1023,1024,1025,1026,1027,1028,1029,1030,1031)
GO
--LegalStatusUponArrivaltoED
update u_usersfields
set CIHI_ID = '170'
where appid = 401 and fieldid = 1263
GO
--TypeOfRestraint01
update u_usersfields
set CIHI_ID = '171a'
where appid = 401 and fieldid = 1265
GO
--TypeOfRestraint02
update u_usersfields
set CIHI_ID = '171b'
where appid = 401 and fieldid = 1267
GO
--TypeOfRestraint03
update u_usersfields
set CIHI_ID = '171c'
where appid = 401 and fieldid = 1269
GO
--TypeOfRestraint04
update u_usersfields
set CIHI_ID = '171d'
where appid = 401 and fieldid = 1271
GO
--FrequencyOfRestraint01
update u_usersfields
set CIHI_ID = '172a'
where appid = 401 and fieldid = 1266
GO
--FrequencyOfRestraint02
update u_usersfields
set CIHI_ID = '172b'
where appid = 401 and fieldid = 1268
GO
--FrequencyOfRestraint03
update u_usersfields
set CIHI_ID = '172c'
where appid = 401 and fieldid = 1270
GO
--FrequencyOfRestraint04
update u_usersfields
set CIHI_ID = '172d'
where appid = 401 and fieldid = 1272
GO
--Bloods
--CryoprecipitatePlasma
update u_usersfields
set CIHI_ID = '177'
where appid = 401 and fieldid = 1023
GO
--CryosupernatantPlasma
update u_usersfields
set CIHI_ID = '178'
where appid = 401 and fieldid = 1024
GO
--IVIG_SCIG
update u_usersfields
set CIHI_ID = '179'
where appid = 401 and fieldid = 1025
GO
--Fibrinogen
update u_usersfields
set CIHI_ID = '180'
where appid = 401 and fieldid = 1026
GO
--PCC
update u_usersfields
set CIHI_ID = '181'
where appid = 401 and fieldid = 1027
GO
--FEIBA
update u_usersfields
set CIHI_ID = '182'
where appid = 401 and fieldid = 1028
GO
--AntithrombinIII
update u_usersfields
set CIHI_ID = '183'
where appid = 401 and fieldid = 1029
GO
--C1Inhibitor
update u_usersfields
set CIHI_ID = '184'
where appid = 401 and fieldid = 1030
GO
--ProteinC_OtherFactors
update u_usersfields
set CIHI_ID = '185'
where appid = 401 and fieldid = 1031
GO
--End build 5
--DAD Submission
Update [dbo].[SU_StructureList] set GroupID = 47 where BatchYear = 2018 and GroupID = 45
GO
Delete from [dbo].[SU_StructureFile] where groupid in (47)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 47, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 45
order by TextPosition
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler168',
	FieldID = null,
	RecodeID = 2,
	TextFormat = 0
where GroupID = 47 and TextPosition = 168
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2553',
	FieldID = null,
	TextLength = 2, 
	RecodeID = 2,
	TextFormat = 0
where GroupID = 47 and TextPosition = 2553
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2556',
	FieldID = null,
	RecodeID = 2,
	TextLength = 2, 
	TextFormat = 0
where GroupID = 47 and TextPosition = 2556
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2559',
	FieldID = null,
	RecodeID = 2,
	TextLength = 2, 
	TextFormat = 0
where GroupID = 47 and TextPosition = 2559
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2563',
	FieldID = null,
	RecodeID = 2,
	TextLength = 138, 
	TextFormat = 0
where GroupID = 47 and TextPosition = 2563
GO
Delete from  [dbo].[SU_StructureFile] where GroupID = 47 and TextPosition in (2554, 2557, 2560, 2564, 2565, 2566)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 0, 'T', 'AB_Abstract', 'Height', 'Height', 836,  0, 0, 3455, 6, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 0, 'T', 'AB_Abstract', 'Weight', 'WeightKilo', 835,  0, 0, 3461, 7, 1)
GO
declare @occ int
set @occ = 1
while (@occ < 21)
begin
	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 30 + @occ, 'T', 'AB_Intervention', 'Intervention Joint Identifie', 'IntervJointIdentifier', 1230,  @occ, 0, 3468 + (@occ - 1) * 4, 1, 1
	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 30 + @occ, 'T', 'AB_Intervention', 'Intervention Revision Reason', 'IntervRevisionReason', 1231,  @occ, 0, 3469 + (@occ - 1) * 4, 3, 1
	set @occ = @occ + 1
end
GO
--DAD CJRR
declare @occ int
declare @comp int
declare @part int
declare @seq int
declare @diff int
declare @comp_diff int
declare @part_diff int
set @diff = 4364
set @comp_diff = 1388
set @part_diff = 198
set @occ = 1
while (@occ < 5)
begin
	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Joint Identifier', 'JointIdentifier', null,  @occ, 0, 3548 + (@occ - 1) * @diff, 1, 0

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Side', 'Side', null,  @occ, 0, 3549 + (@occ - 1) * @diff, 1, 1

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Cement', 'Cement', null,  @occ, 0, 3550 + (@occ - 1) * @diff, 3, 1

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Cement Other', 'CementOther', null,  @occ, 0, 3553 + (@occ - 1) * @diff, 45, 1

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Cement Product Number', 'CementProductNumber', null,  @occ, 0, 3598 + (@occ - 1) * @diff, 75, 1

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Cement Lot Number', 'CementLotNumber', null,  @occ, 0, 3673 + (@occ - 1) * @diff, 75, 1

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Component 1', 'Component1', null,  @occ, 0, 3748 + (@occ - 1) * @diff, 2, 1

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Component 2', 'Component2', null,  @occ, 0, 5136 + (@occ - 1) * @diff, 2, 1

	insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
	select 47, 96 + @occ, 'T', 'AB_CJRR', 'Component 3', 'Component3', null,  @occ, 0, 6524 + (@occ - 1) * @diff, 2, 1

	--Part For component 1
	set @comp = 1
	while(@comp < 4)
	begin
		set @part = 1
		while (@part < 8)
		begin
			set @seq = (@occ - 1) * 21 + (@comp - 1) * 7 + @part
			insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
			select 47, 100 + @seq, 'T', 'AB_CJRR_Parts', 'Manufacturer', 'Manufacturer', null,  @seq, 0, 3750 + (@part - 1) * @part_diff + (@comp - 1) * @comp_diff + (@occ - 1) * @diff, 3, 1
			insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
			select 47, 100 + @seq, 'T', 'AB_CJRR_Parts', 'Manufacturer Other', 'ManufacturerOther', null,  @seq, 0, 3753 + (@part - 1) * @part_diff + (@comp - 1) * @comp_diff + (@occ - 1) * @diff, 45, 1
			insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
			select 47, 100 + @seq, 'T', 'AB_CJRR_Parts', 'Product Number', 'ProductNumber', null,  @seq, 0, 3798 + (@part - 1) * @part_diff + (@comp - 1) * @comp_diff + (@occ - 1) * @diff, 75, 1
			insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
			select 47, 100 + @seq, 'T', 'AB_CJRR_Parts', 'Lot Number', 'LotNumber', null,  @seq, 0, 3873 + (@part - 1) * @part_diff + (@comp - 1) * @comp_diff + (@occ - 1) * @diff, 75, 1
			set @part = @part + 1
		end
		set @comp = @comp + 1
	end
	set @occ = @occ + 1
end
GO

--New Mental Health
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival to ED', 'LegalStatusUponArrivaltoED', 1263,  0, 0, 21004, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Legal Status Upon Arrival At Admission', 'LegalStatusAtAdmission', 1264,  0, 0, 21006, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Type of Restraint 1', 'TypeOfRestraint01', 1265,  0, 0, 21008, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 1', 'FrequencyOfRestraint01', 1266,  0, 0, 21009, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Type of Restraint 2', 'TypeOfRestraint02', 1267,  0, 0, 21011, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 2', 'FrequencyOfRestraint02', 1268,  0, 0, 21012, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Type of Restraint 3', 'TypeOfRestraint03', 1269,  0, 0, 21014, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 3', 'FrequencyOfRestraint03', 1270,  0, 0, 21015, 2, 1)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Type of Restraint 4', 'TypeOfRestraint04', 1271,  0, 0, 21017, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 51, 'T', 'AB_MentalHealth', 'Frequency of Restraint Use 4', 'FrequencyOfRestraint04', 1272,  0, 0, 21018, 2, 1)
GO
--New Blood
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 21020, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 21021, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 21022, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 21023, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 21024, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 21025, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 21026, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 21027, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(47, 3, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 21028, 1, 0)
GO
Update [dbo].[SU_StructureFile]
set FieldID = 1751 
where GroupID = 47 and FieldID is null and TextPosition >= 3548
GO
update u_usersfields
set Header_User = 'Plasma  Other and Unspecified',
	Header_CIHI_English = 'Plasma  Other and Unspecified'
where fieldid = 1010 and appid in (200, 201, 202, 401)
GO
update u_usersfields
set LookupTable = 'LU_YesBlankAlpha'
where appid = 401 and fieldid in (1023,1024,1025,1026,1027,1028,1029,1030,1031)
GO
Delete from u_fields where fieldid between 10254 and 10259
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(10254, 'Mental Legal Status Admission', 'LU_MentalLegalStatusAdmission', 'LU_MentalLegalStatusAdmission', 0, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(10255, 'Mental Legal Status Upon Arrival ED(DAD)', 'LU_MentalLegalStatusUponArrivalED', 'LU_MentalLegalStatusUponArrivalED', 0, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(10256, 'Mental Legal Status Upon Arrival ED(NACRS)', 'LU_MentalLegalStatusUponArrivalED_A', 'LU_MentalLegalStatusUponArrivalED_A', 0, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(10257, 'Mental Type Restraint', 'LU_MentalTypeRestraint', 'LU_MentalTypeRestraint', 0, 0)
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(10258, 'Mental Frequency Restraint Use', 'LU_MentalFrequencyRestraintUse', 'LU_MentalFrequencyRestraintUse', 0, 0)
GO
declare @SourceOrder int
set @SourceOrder = (select max(SortOrder) from [U_UsersFields] where appid = 1100)

if not exists (select * from u_usersfields where userid = 1 and fieldid = 10254)
begin
	insert into [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, 
		FieldID = 10254, 
		SortOrder = @SourceOrder + 1, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, 
		LookUpTable = 'LU_MentalLegalStatusAdmission', CIHI_ID, 
		Header_CIHI_English = 'Mental Legal Status Admission', Header_CIHI_French = '', Header_CIHI_Spanish = '', 
		Header_User = 'Mental Legal Status Admission', FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode
	from u_usersfields 
	where lookuptable = 'LU_MentalLegalStatus' and appid = 1100

	insert into [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, 
		FieldID = 10255, 
		SortOrder = @SourceOrder + 2, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, 
		LookUpTable = 'LU_MentalLegalStatusUponArrivalED', CIHI_ID, 
		Header_CIHI_English = 'Mental Legal Status Upon Arrival ED(DAD)', Header_CIHI_French = '', Header_CIHI_Spanish = '', 
		Header_User = 'Mental Legal Status Upon Arrival ED(DAD)', FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode
	from u_usersfields 
	where lookuptable = 'LU_MentalLegalStatus' and appid = 1100

	insert into [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, 
		FieldID = 10256, 
		SortOrder = @SourceOrder + 3, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, 
		LookUpTable = 'LU_MentalLegalStatusUponArrivalED_A', CIHI_ID, 
		Header_CIHI_English = 'Mental Legal Status Upon Arrival ED(NACRS)', Header_CIHI_French = '', Header_CIHI_Spanish = '', 
		Header_User = 'Mental Legal Status Upon Arrival ED(NACRS)', FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode
	from u_usersfields 
	where lookuptable = 'LU_MentalLegalStatus' and appid = 1100

	insert into [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, 
		FieldID = 10257, 
		SortOrder = @SourceOrder + 4, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, 
		LookUpTable = 'LU_MentalTypeRestraint', CIHI_ID, 
		Header_CIHI_English = 'Mental Type of Restraint', Header_CIHI_French = '', Header_CIHI_Spanish = '', 
		Header_User = 'Mental Type of Restraint', FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode
	from u_usersfields 
	where lookuptable = 'LU_MentalLegalStatus' and appid = 1100

	insert into [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, 
		FieldID = 10258, 
		SortOrder = @SourceOrder + 5, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, 
		LookUpTable = 'LU_MentalFrequencyRestraintUse', CIHI_ID, 
		Header_CIHI_English = 'Mental Frequency of Restraint Use', Header_CIHI_French = '', Header_CIHI_Spanish = '', 
		Header_User = 'Mental Frequency of Restraint Use', FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode
	from u_usersfields 
	where lookuptable = 'LU_MentalLegalStatus' and appid = 1100
end
GO
--End build 6
--0876 
if not exists (select * from information_schema.columns where table_name = 'H_HospitalProfile' and column_name = 'UserLevel2CACS')
	alter table H_HospitalProfile add UserLevel2CACS int
GO
update H_HospitalProfile set UserLevel2CACS = 0 where UserLevel2CACS is null
GO
update [LU_DispositionCode_I]
set userdescription = 'Discharge to private home, condo, apt without support service/referral'
where cihivalue = '05' and userdescription = 'Service/referral Discharge to private home, condo, apt without support service/referral'
GO
update [LU_DispositionCode_I]
set defaultdescription = 'Discharge to private home, condo, apt without support service/referral'
where cihivalue = '05' and defaultdescription = 'Service/referral Discharge to private home, condo, apt without support service/referral'
GO
update [LU_DispositionCode_a]
set userdescription = 'Dead on arrival'
where cihivalue = '71' and userdescription = 'Category (Died)  Dead on arrival'
GO
update [LU_DispositionCode_a]
set defaultdescription = 'Dead on arrival'
where cihivalue = '71' and defaultdescription = 'Category (Died)  Dead on arrival'
GO
--End build 7
if exists (select * from information_schema.tables where table_name = 'zz2018ALC')
	drop table zz2018ALC
GO
create table zz2018ALC(
	Code int identity (1, 1),
	DisplayCode varchar(10), 
	UserDescription varchar(200)
)
GO
insert into zz2018ALC(DisplayCode, UserDescription)
select a.DisplayCode, a.UserDescription
from
(select DisplayCode = '11', UserDescription = 'In Panel Process' union
select DisplayCode = '12', UserDescription = 'Panel approved for PCH' union
select DisplayCode = '13', UserDescription = 'Panel approved for Chronic Care Placement' union
select DisplayCode = '14', UserDescription = 'Panel approved for Companion Care Placement' union
select DisplayCode = '21', UserDescription = 'Awaiting Home Care - professional nursing services' union
select DisplayCode = '22', UserDescription = 'Awaiting speciality supplies/equipment (e.g. Home oxygen, bariatric equipment)' union
select DisplayCode = '23', UserDescription = 'Awaiting Community Parenteral Therapy Program (Home/Community IV)' union
select DisplayCode = '24', UserDescription = 'Awaiting Home Care - palliative care' union
select DisplayCode = '25', UserDescription = 'Awaiting Community Therapy Services (e.g. PT/OT/SLP)' union
select DisplayCode = '26', UserDescription = 'Awaiting Home Care - Support Staff (bathing, laundry, etc)' union
select DisplayCode = '27', UserDescription = 'Awaiting Community Mental Health Worker or Services (PACT, EPPIS, etc)' union
select DisplayCode = '28', UserDescription = 'Awaiting private personal health care services (e.g. Self and Managed Care)' union
select DisplayCode = '29', UserDescription = 'Awaiting Home Nutrition Services' union
select DisplayCode = '31', UserDescription = 'Awaiting foster care (newborn or child)' union
select DisplayCode = '32', UserDescription = 'Awaiting Group Home (e.g. Knowles Centre, boarding home/women''s shelter)' union
select DisplayCode = '33', UserDescription = 'Awaiting Special Housing (e.g. 1010 Sinclair,  Assisted Living)' union
select DisplayCode = '34', UserDescription = 'Awaiting Non-acute Mental Health Inpatient Program' union
select DisplayCode = '35', UserDescription = 'Awaiting Residential Addictions Centre bed' union
select DisplayCode = '36', UserDescription = 'Awaiting Hospice (Jocelyn House, Grace Hospice)' union
select DisplayCode = '37', UserDescription = 'Panel approved for supportive housing' union
select DisplayCode = '38', UserDescription = 'Awaiting residential long term care (St Amant)' union
select DisplayCode = '39', UserDescription = 'Awaiting arrangements to fund out-of-hospital medications or therapies' union
select DisplayCode = '41', UserDescription = 'Pre-arranged respite care' union
select DisplayCode = '42', UserDescription = 'Awaiting accommodation (homeless)' union
select DisplayCode = '43', UserDescription = 'Assessment for potential above of patient (e.g. Child or Elder abuse)' union
select DisplayCode = '44', UserDescription = 'Care provider unavailable (e.g. on vacation, hospitalized, incarcerated, etc)' union
select DisplayCode = '45', UserDescription = 'Awaiting transportation of stable patient to non-acute setting' union
select DisplayCode = '46', UserDescription = 'Healthy baby (boarder) accompanying ill mother' union
select DisplayCode = '47', UserDescription = 'Awaiting home renovations/modifications; utility installation; heavy cleaning (hoarding)' union
select DisplayCode = '48', UserDescription = 'Specialized training for caregiver/patient' union
select DisplayCode = '49', UserDescription = 'Other (specify):' union
select DisplayCode = '51', UserDescription = 'Awaiting Rehab Bed in same or other RHA' union
select DisplayCode = '53', UserDescription = 'Awaiting Committeeship/assignment of Public Trustee' union
select DisplayCode = '54', UserDescription = 'Awaiting Manitoba Adolescent Treatment Centre bed (intensive treatment services)' union
select DisplayCode = '55', UserDescription = 'Panel approved for General Dementia/Special Needs Unit' union
select DisplayCode = '56', UserDescription = 'Panel approved for Behavioral Support & Care Environment or Behavioral Treatment Unit' union
select DisplayCode = '57', UserDescription = 'Awaiting assessment by Selkirk Mental Health Centre' union
select DisplayCode = '58', UserDescription = 'Awaiting Special Contracts (Home Care/Mental Health)' union
select DisplayCode = '59', UserDescription = 'Hospice bed does not exist in RHA' union
select DisplayCode = '60', UserDescription = 'Palliative home care service does not exist in RHA' union
select DisplayCode = '61', UserDescription = 'Caregiver burnout - need for urgent (unplanned) respite' union
select DisplayCode = '62', UserDescription = 'Baby/child abandoned at hospital' union
select DisplayCode = '63', UserDescription = 'Patient/family refusing or family disageement about proposed discharge/placement plan or option' union
select DisplayCode = '64', UserDescription = 'Abusive patient unable to return homoe out of concern for other family members' union
select DisplayCode = '65', UserDescription = 'Evacuation (e.g. flood/fire); unable to return to long term care due to infectious outbreak' union
select DisplayCode = '66', UserDescription = 'Adult waiting for supervised home environment in residential care' union
select DisplayCode = '67', UserDescription = 'Home/Community IV service does not exist in RHA' union
select DisplayCode = '68', UserDescription = 'Healthy mom accompanying sick baby/child' 
 ) a
GO
Update b
set ValidTo = '2018/03/31'
-- select b.*
from zz2018ALC a
right  join lu_codefile b on a.displaycode = b.cihivalue
--where a.UserDescription <> b.defaultdescription
where a.DisplayCode is null and b.validto > '2016/04/01' and  lookupid = 60
GO
update b
set UserDescription = a.UserDescription, DefaultDescription = a.UserDescription
--select a.*, b.*
from zz2018ALC a
inner  join lu_codefile b on lookupid = 60 and a.displaycode = b.cihivalue
where a.UserDescription <> b.defaultdescription --and b.code < 15780
GO

if exists (select * from information_schema.tables where table_name = 'zz2018NewALC')
	drop table zz2018NewALC
GO
create table zz2018NewALC(
	Code int,
	DisplayCode varchar(10), 
	UserDescription varchar(200)
)
GO
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(1, '53', 'Awaiting Committeeship/assignment of Public Trustee') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(2, '54', 'Awaiting Manitoba Adolescent Treatment Centre bed (intensive treatment services)') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(3, '55', 'Panel approved for General Dementia/Special Needs Unit') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(4, '56', 'Panel approved for Behavioral Support & Care Environment or Behavioral Treatment Unit') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(5, '57', 'Awaiting assessment by Selkirk Mental Health Centre') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(6, '58', 'Awaiting Special Contracts (Home Care/Mental Health)') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(7, '59', 'Hospice bed does not exist in RHA') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(8, '60', 'Palliative home care service does not exist in RHA') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(9, '61', 'Caregiver burnout - need for urgent (unplanned) respite') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(10, '62', 'Baby/child abandoned at hospital') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(11, '63', 'Patient/family refusing or family disageement about proposed discharge/placement plan or option') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(12, '64', 'Abusive patient unable to return homoe out of concern for other family members') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(13, '65', 'Evacuation (e.g. flood/fire); unable to return to long term care due to infectious outbreak') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(14, '66', 'Adult waiting for supervised home environment in residential care') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(15, '67', 'Home/Community IV service does not exist in RHA') 
Insert into zz2018NewALC(Code, DisplayCode, UserDescription) values(16, '68', 'Healthy mom accompanying sick baby/child') 
GO
declare @MaxID int
set @MaxID = 15780
if exists (select * from lu_codefile where code between  15781 and 15796)
begin
	set @MaxID = (select max(code) from lu_codefile where code < 600000)
	if @MaxID < 50000 set @MaxID = 500000
end
Insert into LU_CodeFile(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, LookupID, HospitalID, LUText)
select @MaxID + z.Code, z.DisplayCode, z.UserDescription, z.UserDescription, z.DisplayCode, '2016/04/01', '2099/03/31', z.DisplayCode, 60, 0, ''
from zz2018NewALC z
	left join (select * from lu_codefile where lookupid = 60) b on z.displaycode = b.cihivalue
where b.cihivalue is null
GO

if exists (select * from information_schema.tables where table_name = 'zz2018NewALC')
	drop table zz2018NewALC
GO
if exists (select * from information_schema.tables where table_name = 'zz2018ALC')
	drop table zz2018ALC
GO

declare @Province varchar(50)
set @Province = (select top 1 p.CIHIValue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @Province = '9'
begin
	Update LU_MentalLegalStatusAdmission 
	set UserDescription = 'Involuntary Psychiatric Assessment - Recalls: A patient who is on leave may, if the conditions of the patient leave are not being met. be recalled to the designated facility from which the patient was released',
		DefaultDescription = 'Involuntary Psychiatric Assessment - Recalls: A patient who is on leave may, if the conditions of the patient leave are not being met, be recalled to the designated facility from which the patient was released' 
	where code = 12 and CIHIValue = '21' and UserDescription = 'P/T locally assigned'


	Update LU_MentalLegalStatusUponArrivalED 
	set UserDescription = 'Orders for Assessment/Apprehension - Apprehended by police',
		DefaultDescription = 'Orders for Assessment/Apprehension - Apprehended by police' 
	where code = 12 and CIHIValue = '31' and UserDescription = 'P/T locally assigned'

	Update LU_MentalLegalStatusUponArrivalED 
	set UserDescription = 'Orders for Assessment/Apprehension - From 21: Director warrant(apprehension of involuntary patient on leave)',
		DefaultDescription = 'Orders for Assessment/Apprehension - From 21: Director warrant(apprehension of involuntary patient on leave)' 
	where code = 13 and CIHIValue = '32' and UserDescription = 'P/T locally assigned'

	Update LU_MentalLegalStatusUponArrivalED 
	set UserDescription = 'Orders for Assessment/Apprehension - Form 10: Warrant(Apprehension of a Person with an Apparent Mental Disorder)',
		DefaultDescription = 'Orders for Assessment/Apprehension - Form 10: Warrant(Apprehension of a Person with an Apparent Mental Disorder)' 
	where code = 14 and CIHIValue = '33' and UserDescription = 'P/T locally assigned'

	Update LU_MentalLegalStatusUponArrivalED_A 
	set UserDescription = 'Orders for Assessment/Apprehension - Apprehended by police',
		DefaultDescription = 'Orders for Assessment/Apprehension - Apprehended by police' 
	where code = 12 and CIHIValue = '31' and UserDescription = 'P/T locally assigned'

	Update LU_MentalLegalStatusUponArrivalED_A 
	set UserDescription = 'Orders for Assessment/Apprehension - From 21: Director warrant(apprehension of involuntary patient on leave)',
		DefaultDescription = 'Orders for Assessment/Apprehension - From 21: Director warrant(apprehension of involuntary patient on leave)' 
	where code = 13 and CIHIValue = '32' and UserDescription = 'P/T locally assigned'

	Update LU_MentalLegalStatusUponArrivalED_A 
	set UserDescription = 'Orders for Assessment/Apprehension - Form 10: Warrant(Apprehension of a Person with an Apparent Mental Disorder)',
		DefaultDescription = 'Orders for Assessment/Apprehension - Form 10: Warrant(Apprehension of a Person with an Apparent Mental Disorder)' 
	where code = 14 and CIHIValue = '33' and UserDescription = 'P/T locally assigned'

end
GO
-- 1107 -   DAD & NACRS Special Project 250
--DAD project 250
declare @code int
declare @Add int
set @add = 0
set @code = 20
if not exists (select * from lu_project where code = 21 and CIHIValue = '250')
begin
	set @add = 1
	if exists (select * from lu_project where code = 21)
	begin
		--Move the project to other place
		set @code = (select max(code) from lu_project) + 1
		if @code < 500000
			set @code = 500001
		update lu_project set code = @code where code = 21
		update [dbo].[LU_ProjectQuestion1] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion2] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion3] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion4] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion5] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion6] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion7] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion8] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion9] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion10] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion11] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion12] set associationid = @code where associationid = 21
		update [dbo].[LU_ProjectQuestion13] set associationid = @code where associationid = 21
		update ab_project set projectnumber = @code where projectnumber = 21
	end

	insert into [dbo].[LU_Project](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, 
		QuestionState1, Question1, QuestionState2, Question2, QuestionState3, Question3, QuestionState4, Question4, QuestionState5, Question5, 
		QuestionState6, Question6, QuestionState7, Question7, QuestionState8, Question8, QuestionState9, Question9, QuestionState10, Question10, 
		QuestionState11, Question11, QuestionState12, Question12, QuestionState13, Question13, QuestionState14, Question14, QuestionState15, Question15,
		QuestionState16, Question16, QuestionState17, Question17, QuestionState18, Question18, QuestionState19, Question19, QuestionState20, Question20, 
		QuestionState21, Question21, QuestionState22, Question22, QuestionState23, Question23, QuestionState24, Question24,  
		InterfaceIn, HospitalID, LUText)
	select
		Code = 21, DisplayCode = '250', UserDescription = 'GI Endoscopy - DAD', DefaultDescription = 'GI Endoscopy - DAD', 
		CIHIValue = '250', ValidFrom = '2018-04-01', ValidTo = '2099-03-31', 
		QuestionState1 = 11,   Question1 = 'Metal Stent', 
		QuestionState2 = 11,  Question2 = 'the first digit of Number of Esophageal Polyps (1st Polypectomy Episode)', 
		QuestionState3 = 11,  Question3 = 'the second digit of Number of Esophageal Polyps (1st Polypectomy Episode)', 
		QuestionState4 = 11,  Question4 = 'the first digit of Number of Stomach Polyps (1st Polypectomy Episode)', 
		QuestionState5 = 11,  Question5 = 'the second digit of Number of Stomach Polyps (1st Polypectomy Episode)', 
		QuestionState6 = 11,  Question6 = 'the first digit of Number of Small Intestine Polyps (1st Polypectomy Episode)', 
		QuestionState7 = 11,  Question7 = 'the second digit of Number of Small Intestine Polyps (1st Polypectomy Episode)', 
		QuestionState8 = 11,  Question8 = 'the first digit of Number of Large Intestine Polyps (1st Polypectomy Episode)', 
		QuestionState9 = 11,  Question9 = 'the second digit of Number of Large Intestine Polyps (1st Polypectomy Episode)', 
		QuestionState10 = 11, Question10 = 'the first digit of Number of Rectal Polyps (1st Polypectomy Episode)', 
		QuestionState11 = 11, Question11 = 'the second digit of Number of Rectal Polyps (1st Polypectomy Episode)', 
		QuestionState12 = 11, Question12 = 'the first digit of Number of Esophageal Polyps (2nd Polypectomy Episode)', 
		QuestionState13 = 11, Question13 = 'the second digit of Number of Esophageal Polyps (2nd Polypectomy Episode)', 
		QuestionState14 = 11, Question14 = 'the first digit of Number of Stomach Polyps (2nd Polypectomy Episode)', 
		QuestionState15 = 11, Question15 = 'the second digit of Number of Stomach Polyps (2nd Polypectomy Episode)',
		QuestionState16 = 11, Question16 = 'the first digit of Number of Small Intestine Polyps (2nd Polypectomy Episode)', 
		QuestionState17 = 11, Question17 = 'the second digit of Number of Small Intestine Polyps (2nd Polypectomy Episode)', 
		QuestionState18 = 11, Question18 = 'the first digit of Number of Large Intestine Polyps (2nd Polypectomy Episode)', 
		QuestionState19 = 11, Question19 = 'the second digit of Number of Large Intestine Polyps (2nd Polypectomy Episode)', 
		QuestionState20 = 11, Question20 = 'the first digit of Number of Rectal Polyps (2nd Polypectomy Episode)', 
		QuestionState21 = 11, Question21 = 'the second digit of Number of Rectal Polyps (2nd Polypectomy Episode)', 
		QuestionState22 = 10, Question22 = '', 
		QuestionState23 = 10, Question23 = '', 
		QuestionState24 = 10, Question24 = '',  
		InterfaceIn = '250', HospitalID = 0, LUText = ''

		--Question 1
		if exists (select * from [dbo].[LU_ProjectQuestion1] where code = 351 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion1])
			if @code < 500000 set @code = 500000
			update AB_Project set question1 = question1 + @code where question1 = 351
			update [LU_ProjectQuestion1] set code = code + @code where code = 351
		end
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, 'M', 'metal stent', 'metal stent', 'P', '2018-04-01', '2099-03-31', 21, 'M', 0, '')

		--Question 2 the first digit of Number of Esophageal Polyps (1st Polypectomy Episode) 
		if exists (select * from [dbo].[LU_ProjectQuestion2] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion2])
			if @code < 500000 set @code = 500000
			update AB_Project set question2 = question2 + @code where question2 between 351 and 360
			update [LU_ProjectQuestion2] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 3: the second digit of Number of Esophageal Polyps (1st Polypectomy Episode) 
		if exists (select * from [dbo].[LU_ProjectQuestion3] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion3])
			if @code < 500000 set @code = 500000
			update AB_Project set Question3 = Question3 + @code where Question3 between 351 and 360
			update [LU_ProjectQuestion3] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 4 the first digit of Number of Stomach Polyps (1st Polypectomy Episode) 
		if exists (select * from [dbo].[LU_ProjectQuestion4] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion4])
			if @code < 500000 set @code = 500000
			update AB_Project set Question4 = Question4 + @code where Question4 between 351 and 360
			update [LU_ProjectQuestion4] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 5 the second digit of Number of Stomach Polyps (1st Polypectomy Episode) 
		if exists (select * from [dbo].[LU_ProjectQuestion5] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion5])
			if @code < 500000 set @code = 500000
			update AB_Project set Question5 = Question5 + @code where Question5 between 351 and 360
			update [LU_ProjectQuestion5] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 6 the first digit of Number of Small Intestine Polyps (1st Polypectomy Episode) 
		if exists (select * from [dbo].[LU_ProjectQuestion6] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion6])
			if @code < 500000 set @code = 500000
			update AB_Project set Question6 = Question6 + @code where Question6 between 351 and 360
			update [LU_ProjectQuestion6] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 7 the second digit of Number of Small Intestine Polyps (1st Polypectomy Episode) 
		if exists (select * from [dbo].[LU_ProjectQuestion7] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion7])
			if @code < 500000 set @code = 500000
			update AB_Project set Question7 = Question7 + @code where Question7 between 351 and 360
			update [LU_ProjectQuestion7] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 8 the first digit of Number of Large Intestine Polyps (1st Polypectomy Episode)
		if exists (select * from [dbo].[LU_ProjectQuestion8] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion8])
			if @code < 500000 set @code = 500000
			update AB_Project set Question8 = Question8 + @code where Question8 between 351 and 360
			update [LU_ProjectQuestion8] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 9 the second digit of Number of Large Intestine Polyps (1st Polypectomy Episode)
		if exists (select * from [dbo].[LU_ProjectQuestion9] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion9])
			if @code < 500000 set @code = 500000
			update AB_Project set Question9 = Question9 + @code where Question9 between 351 and 360
			update [LU_ProjectQuestion9] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 10 the first digit of Number of Rectal Polyps (1st Polypectomy Episode)
		if exists (select * from [dbo].[LU_ProjectQuestion10] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion10])
			if @code < 500000 set @code = 500000
			update AB_Project set Question10 = Question10 + @code where Question10 between 351 and 360
			update [LU_ProjectQuestion10] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 11 the second digit of Number of Rectal Polyps (1st Polypectomy Episode)
		if exists (select * from [dbo].[LU_ProjectQuestion11] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion11])
			if @code < 500000 set @code = 500000
			update AB_Project set Question11 = Question11 + @code where Question11 between 351 and 360
			update [LU_ProjectQuestion11] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 12 the first digit of Number of Esophageal Polyps (2nd Polypectomy Episode)
		if exists (select * from [dbo].[LU_ProjectQuestion12] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion12])
			if @code < 500000 set @code = 500000
			update AB_Project set Question12 = Question12 + @code where Question12 between 351 and 360
			update [LU_ProjectQuestion12] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')

		--Question 13 the second digit of Number of Esophageal Polyps (2nd Polypectomy Episode)
		if exists (select * from [dbo].[LU_ProjectQuestion13] where code between 351 and 360 and associationid <> 21)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion13])
			if @code < 500000 set @code = 500000
			update AB_Project set Question13 = Question13 + @code where Question13 between 351 and 360
			update [LU_ProjectQuestion13] set code = code + @code where code between 351 and 360
		end
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(351, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 21, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(352, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 21, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(353, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 21, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(354, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 21, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(355, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 21, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(356, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 21, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(357, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 21, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(358, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 21, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(359, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 21, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(360, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 21, '9', 0, '')
end
GO
--NACRS project 250
declare @code int
declare @Add int
set @add = 0
set @code = 20
if not exists (select * from lu_project where code = 22 and CIHIValue = '250')
begin
	set @add = 1
	if exists (select * from lu_project where code = 22)
	begin
		--Move the project to other place
		set @code = (select max(code) from lu_project) + 1
		if @code < 500000
			set @code = 500001
		update lu_project set code = @code where code = 22
		update [dbo].[LU_ProjectQuestion1] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion2] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion3] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion4] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion5] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion6] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion7] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion8] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion9] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion10] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion11] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion12] set associationid = @code where associationid = 22
		update [dbo].[LU_ProjectQuestion13] set associationid = @code where associationid = 22
		update ab_project set projectnumber = @code where projectnumber = 22
	end

	insert into [dbo].[LU_Project](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, 
		QuestionState1, Question1, QuestionState2, Question2, QuestionState3, Question3, QuestionState4, Question4, QuestionState5, Question5, 
		QuestionState6, Question6, QuestionState7, Question7, QuestionState8, Question8, QuestionState9, Question9, QuestionState10, Question10, 
		QuestionState11, Question11, QuestionState12, Question12, QuestionState13, Question13, QuestionState14, Question14, QuestionState15, Question15,
		QuestionState16, Question16, QuestionState17, Question17, QuestionState18, Question18, QuestionState19, Question19, QuestionState20, Question20, 
		QuestionState21, Question21, QuestionState22, Question22, QuestionState23, Question23, QuestionState24, Question24,  
		InterfaceIn, HospitalID, LUText)
	select
		Code = 22, DisplayCode = '250', UserDescription = 'GI Endoscopy - NACRS', DefaultDescription = 'GI Endoscopy - NACRS', 
		CIHIValue = '250', ValidFrom = '2018-04-01', ValidTo = '2099-03-31', 
		QuestionState1 = 11,   Question1 = 'Metal Stent', 
		QuestionState2 = 11,  Question2 = 'the first digit of Number of Esophageal Polyps', 
		QuestionState3 = 11,  Question3 = 'the second digit of Number of Esophageal Polyps', 
		QuestionState4 = 11,  Question4 = 'the first digit of Number of Stomach Polyps', 
		QuestionState5 = 11,  Question5 = 'the second digit of Number of Stomach Polyps', 
		QuestionState6 = 11,  Question6 = 'the first digit of Number of Small Intestine Polyps', 
		QuestionState7 = 11,  Question7 = 'the second digit of Number of Small Intestine Polyps', 
		QuestionState8 = 11,  Question8 = 'the first digit of Number of Large Intestine Polyps', 
		QuestionState9 = 11,  Question9 = 'the second digit of Number of Large Intestine Polyps', 
		QuestionState10 = 11, Question10 = 'the first digit of Number of Rectal Polyps', 
		QuestionState11 = 11, Question11 = 'the second digit of Number of Rectal Polyps', 
		QuestionState12 = 10, Question12 = '', 
		QuestionState13 = 10, Question13 = '', 
		QuestionState14 = 10, Question14 = '', 
		QuestionState15 = 10, Question15 = '',
		QuestionState16 = 10, Question16 = '', 
		QuestionState17 = 10, Question17 = '', 
		QuestionState18 = 10, Question18 = '', 
		QuestionState19 = 10, Question19 = '', 
		QuestionState20 = 10, Question20 = '', 
		QuestionState21 = 10, Question21 = '', 
		QuestionState22 = 10, Question22 = '', 
		QuestionState23 = 10, Question23 = '', 
		QuestionState24 = 10, Question24 = '',  
		InterfaceIn = '250', HospitalID = 0, LUText = ''

		--Question 1
		if exists (select * from [dbo].[LU_ProjectQuestion1] where code = 351 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion1])
			if @code < 500000 set @code = 500000
			update AB_Project set question1 = question1 + @code where question1 = 351
			update [LU_ProjectQuestion1] set code = code + @code where code = 351
		end
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, 'M', 'metal stent', 'metal stent', 'P', '2018-04-01', '2099-03-31', 22, 'M', 0, '')

		--Question 2 the first digit of Number of Esophageal Polyps  
		if exists (select * from [dbo].[LU_ProjectQuestion2] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion2])
			if @code < 500000 set @code = 500000
			update AB_Project set question2 = question2 + @code where question2 between 371 and 380
			update [LU_ProjectQuestion2] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 3: the second digit of Number of Esophageal Polyps  
		if exists (select * from [dbo].[LU_ProjectQuestion3] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion3])
			if @code < 500000 set @code = 500000
			update AB_Project set Question3 = Question3 + @code where Question3 between 371 and 380
			update [LU_ProjectQuestion3] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 4 the first digit of Number of Stomach Polyps  
		if exists (select * from [dbo].[LU_ProjectQuestion4] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion4])
			if @code < 500000 set @code = 500000
			update AB_Project set Question4 = Question4 + @code where Question4 between 371 and 380
			update [LU_ProjectQuestion4] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 5 the second digit of Number of Stomach Polyps  
		if exists (select * from [dbo].[LU_ProjectQuestion5] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion5])
			if @code < 500000 set @code = 500000
			update AB_Project set Question5 = Question5 + @code where Question5 between 371 and 380
			update [LU_ProjectQuestion5] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 6 the first digit of Number of Small Intestine Polyps  
		if exists (select * from [dbo].[LU_ProjectQuestion6] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion6])
			if @code < 500000 set @code = 500000
			update AB_Project set Question6 = Question6 + @code where Question6 between 371 and 380
			update [LU_ProjectQuestion6] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 7 the second digit of Number of Small Intestine Polyps  
		if exists (select * from [dbo].[LU_ProjectQuestion7] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion7])
			if @code < 500000 set @code = 500000
			update AB_Project set Question7 = Question7 + @code where Question7 between 371 and 380
			update [LU_ProjectQuestion7] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 8 the first digit of Number of Large Intestine Polyps 
		if exists (select * from [dbo].[LU_ProjectQuestion8] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion8])
			if @code < 500000 set @code = 500000
			update AB_Project set Question8 = Question8 + @code where Question8 between 371 and 380
			update [LU_ProjectQuestion8] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 9 the second digit of Number of Large Intestine Polyps 
		if exists (select * from [dbo].[LU_ProjectQuestion9] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion9])
			if @code < 500000 set @code = 500000
			update AB_Project set Question9 = Question9 + @code where Question9 between 371 and 380
			update [LU_ProjectQuestion9] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 10 the first digit of Number of Rectal Polyps 
		if exists (select * from [dbo].[LU_ProjectQuestion10] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion10])
			if @code < 500000 set @code = 500000
			update AB_Project set Question10 = Question10 + @code where Question10 between 371 and 380
			update [LU_ProjectQuestion10] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

		--Question 11 the second digit of Number of Rectal Polyps 
		if exists (select * from [dbo].[LU_ProjectQuestion11] where code between 371 and 380 and associationid <> 22)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion11])
			if @code < 500000 set @code = 500000
			update AB_Project set Question11 = Question11 + @code where Question11 between 371 and 380
			update [LU_ProjectQuestion11] set code = code + @code where code between 371 and 380
		end
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(371, '0', '0', '0', '0', '2018-04-01', '2099-03-31', 22, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(372, '1', '1', '1', '1', '2018-04-01', '2099-03-31', 22, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(373, '2', '2', '2', '2', '2018-04-01', '2099-03-31', 22, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(374, '3', '3', '3', '3', '2018-04-01', '2099-03-31', 22, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(375, '4', '4', '4', '4', '2018-04-01', '2099-03-31', 22, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(376, '5', '5', '5', '5', '2018-04-01', '2099-03-31', 22, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(377, '6', '6', '6', '6', '2018-04-01', '2099-03-31', 22, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(378, '7', '7', '7', '7', '2018-04-01', '2099-03-31', 22, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(379, '8', '8', '8', '8', '2018-04-01', '2099-03-31', 22, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(380, '9', '9', '9', '9', '2018-04-01', '2099-03-31', 22, '9', 0, '')

end
GO
--1087
Update U_UsersFields
set LookupTable = '574',
	header_CIHI_English = 'MH - A3ab: Status at Time of Admission/Assessment',
	Header_User = 'MH - A3ab: Status at Time of Admission/Assessment'
where AppID = 1100 and FieldID = 10915 
GO
--2.x-1005 
update lu_codefile 
set ValidTo = '2099/03/31'
where lookupid = 47010
and cihivalue in ('aii', 'byn', 'cld', 'coo', 'crj', 'crl', 'crm', 'din', 'fry', 'fuf', 'har', 'hil', 'kas', 'msa', 'ori', 'otw', 'uig', 'uzb', 'vls', 'war', 'yor')
GO
Update lu_codefile 
set UserDescription = 'Oriya (macrolanguage)',
	DefaultDescription = 'Oriya (macrolanguage)'
where lookupid = 47010 and CIHIValue = 'ori'
GO
Update lu_codefile 
set UserDescription = 'Uyghur',
	DefaultDescription = 'Uyghur'
where lookupid = 47010 and CIHIValue = 'uig'
GO
Update lu_codefile 
set UserDescription = 'Frisian, Western',
	DefaultDescription = 'Frisian, Western'
where lookupid = 47010 and CIHIValue = 'fry'
GO
Update lu_codefile 
set UserDescription = 'Neo-Aramaic, Assyrian',
	DefaultDescription = 'Neo-Aramaic, Assyrian'
where lookupid = 47010 and CIHIValue = 'aii'
GO
Update lu_codefile 
set UserDescription = 'Neo-Aramaic, Chaldean',
	DefaultDescription = 'Neo-Aramaic, Chaldean'
where lookupid = 47010 and CIHIValue = 'cld'
GO
Update lu_codefile 
set UserDescription = 'Cree, Southern East',
	DefaultDescription = 'Cree, Southern East'
where lookupid = 47010 and CIHIValue = 'crj'
GO
Update lu_codefile 
set UserDescription = 'Cree, Northern East',
	DefaultDescription = 'Cree, Northern East'
where lookupid = 47010 and CIHIValue = 'crl'
GO
Update lu_codefile 
set UserDescription = 'Cree, Moose',
	DefaultDescription = 'Cree, Moose'
where lookupid = 47010 and CIHIValue = 'crm'
GO
Update lu_codefile 
set UserDescription = 'Panjabi, Punjabi',
	DefaultDescription = 'Panjabi, Punjabi'
where lookupid = 47010 and CIHIValue = 'pan'
GO
--MADE Submission
Update [dbo].[SU_StructureList] set GroupID = 56 where BatchYear = 2018 and GroupID = 55
GO
Delete from [dbo].[SU_StructureFile] where groupid in (56)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 56, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 55
order by TextPosition
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler431',
	FieldID = null,
	RecodeID = 2,
	TextFormat = 0
where GroupID = 56 and TextPosition = 431
GO
update [dbo].[SU_StructureFile]
set TextLength = 356, 
	TextPosition = 645
where GroupID = 56 and TextPosition = 591 and TextLength = 410
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 7, 'T', 'AB_MB_ALC', 'Date designated as ALC (occ 4)', 'DateDesignatedALC', 1881, 4, 50, 591, 8, 15)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 7, 'T', 'AB_MB_ALC', 'Date reassigned as Acute (occ 4)', 'DateReassignedAcute', 1882, 4, 50, 599, 8, 15)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 7, 'T', 'AB_MB_ALC', 'ALC Reason Code (occ 4)', 'ALCReasonCode', 1883, 4, 50, 607, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 8, 'T', 'AB_MB_ALC', 'Date designated as ALC (occ 5)', 'DateDesignatedALC', 1881, 5, 50, 609, 8, 15)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 8, 'T', 'AB_MB_ALC', 'Date reassigned as Acute (occ 5)', 'DateReassignedAcute', 1882, 5, 50, 617, 8, 15)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 8, 'T', 'AB_MB_ALC', 'ALC Reason Code (occ 5)', 'ALCReasonCode', 1883, 5, 50, 625, 2, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 9, 'T', 'AB_MB_ALC', 'Date designated as ALC (occ 6)', 'DateDesignatedALC', 1881, 6, 50, 627, 8, 15)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 9, 'T', 'AB_MB_ALC', 'Date reassigned as Acute (occ 6)', 'DateReassignedAcute', 1882, 6, 50, 635, 8, 15)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(56, 9, 'T', 'AB_MB_ALC', 'ALC Reason Code (occ 6)', 'ALCReasonCode', 1883, 6, 50, 643, 2, 0)
GO
--End build 8
--1130
if not exists (select * from information_schema.tables where table_name = 'LU_CJRR_JointIdentifier')
CREATE TABLE [dbo].[LU_CJRR_JointIdentifier](
	[Code] [int] NOT NULL,
	[DisplayCode] [varchar](50) NULL,
	[UserDescription] [varchar](255) NULL,
	[DefaultDescription] [varchar](255) NULL,
	[CIHIValue] [varchar](50) NULL,
	[ValidFrom] [datetime] NULL,
	[ValidTo] [datetime] NULL,
	[InterfaceIn] [varchar](50) NULL,
	[HospitalID] [int] NULL,
	[LUText] [varchar](255) NULL,
 CONSTRAINT [PK_LU_CJRR_JointIdentifier] PRIMARY KEY CLUSTERED (	[Code] ASC )
)
GO
if not exists (select * from  [dbo].[LU_CJRR_JointIdentifier] where code = 1)
begin
	insert into LU_CJRR_JointIdentifier(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
	values(1, '1', '1', '1', '1', '2018/04/01', '2099/03/31', '1', 0, '' )
	insert into LU_CJRR_JointIdentifier(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
	values(2, '2', '2', '2', '2', '2018/04/01', '2099/03/31', '2', 0, '' )
end
GO
Update u_usersfields set DataType = 50, LookupTable = 'LU_CJRR_JointIdentifier' where appid in (201, 202, 200) and fieldid = 1230
GO
--DAD Submission
Update [dbo].[SU_StructureList] set GroupID = 48 where BatchYear = 2018 and GroupID = 46
GO
Delete from [dbo].[SU_StructureFile] where groupid in (48)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 48, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 46
order by TextPosition
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Fille37',
	FieldID = null,
	RecodeID = 2,
	TextFormat = 0
where GroupID = 48 and TextPosition = 37	--
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler168',
	FieldID = null,
	RecodeID = 2,
	TextFormat = 0
where GroupID = 48 and TextPosition = 168
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler615',
	FieldID = null,
	RecodeID = 2,
	TextLength = 14,
	TextFormat = 0
where GroupID = 48 and TextPosition = 615	--Cancer Fields
GO
Delete from [dbo].[SU_StructureFile] where  GroupID = 48 and TextPosition between 617 and 625
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler' + cast(TextPosition as varchar(10)),
	FieldID = null,
	RecodeID = 2,
	TextFormat = 0
where GroupID = 48 and FieldName = 'IntervTissueCode'
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2553',
	FieldID = null,
	TextLength = 2, 
	RecodeID = 2,
	TextFormat = 0
where GroupID = 48 and TextPosition = 2553
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2556',
	FieldID = null,
	RecodeID = 2,
	TextLength = 2, 
	TextFormat = 0
where GroupID = 48 and TextPosition = 2556
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2559',
	FieldID = null,
	RecodeID = 2,
	TextLength = 2, 
	TextFormat = 0
where GroupID = 48 and TextPosition = 2559
GO
update [dbo].[SU_StructureFile]
set FieldName = 'Filler2563',
	FieldID = null,
	RecodeID = 2,
	TextLength = 138, 
	TextFormat = 0
where GroupID = 48 and TextPosition = 2563
GO
Delete from  [dbo].[SU_StructureFile] where GroupID = 48 and TextPosition in (2554, 2557, 2560, 2564, 2565, 2566)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 0, 'T', 'AB_Abstract', 'Weight', 'WeightKilo', 835,  0, 0, 3455, 7, 1)
GO
--New Blood
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Cryoprecipitate Plasma', 'CryoprecipitatePlasma', 1023,  0, 0, 3462, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Cryosupernatant Plasma', 'CryosupernatantPlasma', 1024,  0, 0, 3463, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Intravenous / Subcutaneous Immune Globulin', 'IVIG_SCIG', 1025,  0, 0, 3464, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Fibrinogen', 'Fibrinogen', 1026,  0, 0, 3465, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Prothrombin Complex Concentrate (PCC)', 'PCC', 1027,  0, 0, 3466, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Anti-Inhibitor Coagulant (FEIBA)', 'FEIBA', 1028,  0, 0, 3467, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Antithrombin III', 'AntithrombinIII', 1029,  0, 0, 3468, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'C1 Inhibitor', 'C1Inhibitor', 1030,  0, 0, 3469, 1, 0)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
values(48, 3, 'T', 'AB_Blood', 'Protein C/Other Factors', 'ProteinC_OtherFactors', 1031,  0, 0, 3470, 1, 0)
GO
--DAD Deletion
Update [dbo].[SU_StructureList] set GroupID = 26 where BatchYear = 2018 and GroupID = 43
GO
Delete from [dbo].[SU_StructureFile] where groupid in (26)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 26, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 43
order by TextPosition
GO
update [dbo].[SU_StructureFile]
set TextLength = 20999
where GroupID = 26 and TextPosition = 30
GO
--DAD Alberta Deletion
Update [dbo].[SU_StructureList] set GroupID = 27 where BatchYear = 2018 and GroupID = 25
GO
Delete from [dbo].[SU_StructureFile] where groupid in (27)
GO
insert into [dbo].[SU_StructureFile](GroupID, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat)
select GroupID = 27, SubGroupID, ICDType, TableName, FieldAlias, FieldName, FieldID, Occurrence, RecodeID, TextPosition, TextLength, TextFormat
from [dbo].[SU_StructureFile]
where groupid = 25
order by TextPosition
GO
update [dbo].[SU_StructureFile]
set TextLength = 3441
where GroupID = 27 and TextPosition = 30
GO

--End build 9
if exists (select * from information_schema.tables where table_name = 'zzInst_Missing')
    drop table zzInst_Missing
GO
declare @Province varchar(50)
set @Province = (select top 1 p.CIHIValue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
select Code = identity(int, 1, 1), a.* into dbo.zzInst_Missing
from (select * from [dbo].[LU_Institution_Type] where left([InstitutionNumber], 1) = @Province) a
    left join lu_institution_10 x on a.[InstitutionNumber] = x.CIHIValue
where x.CIHIValue is null
GO
declare @maxID int

set @maxID = 20000
if exists (select * from lu_institution_10 where code between 20000 and 29999)
begin
    set @maxID = 30000
    if exists (select * from lu_institution_10 where code between 30000 and 39999)
    begin
        set @maxID = 40000
        if exists (select * from lu_institution_10 where code between 40000 and 49999)
        begin
            set @maxID = (select max(code) from lu_institution_10)
            if isnull(@maxID, 0) < 500000 set @maxID = 500000
        end
    end
end
insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
select @maxID + z.Code, z.InstitutionNumber, z.InstitutionName, z.InstitutionName, z.InstitutionNumber, '2017/04/01', '2099/03/31', z.InstitutionNumber, 
    InstCareType = z.InstitutionType, HospitalType = z.InstitutionType, 
    IsAcute = (case when z.InstitutionType = '1' then 1 else 0 end), 
    0, '', z.InstitutionType
from zzInst_Missing z
GO
if exists (select * from information_schema.tables where table_name = 'zzInst_Missing')
    drop table zzInst_Missing
GO
update lu_institution_10
set UserDescription = a.[InstitutionName]
from [dbo].[LU_Institution_Type] a
    inner join lu_institution_10 x on a.[InstitutionNumber] = x.CIHIValue
where x.UserDescription like 'undefined%'
GO
update lu_institution_10
set DefaultDescription = a.[InstitutionName]
from [dbo].[LU_Institution_Type] a
    inner join lu_institution_10 x on a.[InstitutionNumber] = x.CIHIValue
where x.DefaultDescription like 'undefined%'
GO
if exists (select * from information_schema.tables where table_name = 'zzInst_MB')
    drop table zzInst_MB
GO
create table dbo.zzInst_MB(
    code int identity(1, 1),
    Inst varchar(10),
    UserDescription varchar(100),
    InstitutionType varchar(10)
)
GO
Insert into zzInst_MB(Inst, UserDescription) values('65196', 'Child & Adolescent Treatment Centre - Brandon')
Insert into zzInst_MB(Inst, UserDescription) values('69299', 'Birthing Centre')
GO
update z
set InstitutionType = x.InstitutionType
from zzInst_MB z
    inner join [dbo].[LU_Institution_Type] x on z.Inst = x.[InstitutionNumber]
GO

declare @Province varchar(50)
declare @maxID int
set @Province = (select top 1 p.CIHIValue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @province = '6'
begin
    set @maxID = 6000
    if exists (select * from lu_institution_10 where code between 6000 and 6100)
    begin
        set @maxID = (select max(code) from lu_institution_10)
        if isnull(@maxID, 0) < 50000 set @maxID = 500000
    end
    insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
    select @maxID + z.Code, z.Inst, z.UserDescription, z.UserDescription, z.Inst, '2018/04/01', '2099/03/31', z.Inst, 
        InstCareType = z.InstitutionType, HospitalType = z.InstitutionType, 
        IsAcute = (case when z.InstitutionType = '1' then 1 else 0 end), 
        0, '', z.InstitutionType
    from zzInst_MB z
        left join [LU_Institution_10] x on z.Inst = x.CIHIValue
    where x.CIHIValue is null
end
GO
if exists (select * from information_schema.tables where table_name = 'zzInst_MB')
    drop table zzInst_MB
GO
--2.x-1089
update lu_codefile set Validto = '2018/03/31' where lookupid = 1007 and code in (200677, 200678, 200679)
GO
if not exists (select * from lu_codefile where code between 200939 and 200942)
begin
    insert into [dbo].[LU_CodeFile](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, LookupID, HospitalID, LUText)
    values(200939, '0', 'Non-reportable disease', 'Non-reportable disease', '0', '2018-04-01', '2099-03-31', '0', 1007, 0, '')
    insert into [dbo].[LU_CodeFile](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, LookupID, HospitalID, LUText)
    values(200940, '1', 'Yes, Analytic', 'Yes, Analytic', '1', '2018-04-01', '2099-03-31', '1', 1007, 0, '')
    insert into [dbo].[LU_CodeFile](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, LookupID, HospitalID, LUText)
    values(200941, '2', 'No, Not Analytic /non-analytice', 'No, Not Analytic /non-analytic', '2', '2018-04-01', '2099-03-31', '2', 1007, 0, '')
    insert into [dbo].[LU_CodeFile](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, LookupID, HospitalID, LUText)
    values(200942, '9', 'Unknown if Analytic or Not', 'Unknown if Analytic or Not', '9', '2018-04-01', '2099-03-31', '9', 1007, 0, '')
end
GO
--1140 
Update u_usersfields 
set LookUpTable = 'LU_YesBlankAlpha'
where appid in (200, 201, 202) and fieldid between 1023 and 1031
GO
--2.x-1144
update LU_Glasgow
set ValidTo = '2018/03/31'
where CIHIValue in ('01', '02')
GO
--End build 10
--2.x-1145
update [LU_MentalLegalStatus] set validto = '2018/03/31' where cihivalue not in ('2', '5', '6') and validto > '2018/03/31'
GO
