--2.x-1909
Update  u_usersfields
set CIHI_ID = 'R3c'
where appid between 470 and 479 and DataType <> 100000
and fieldid = 5512
GO
--2.x-1918
declare @province varchar(10)
declare @maxId int
set @province = (select top 1 p.cihivalue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @province = '5'
begin
    if not exists (select * from lu_institution_10 where cihivalue = '56955')
    begin
        set  @maxid = 91764
        if exists (select * from lu_institution_10 where code = @maxid)
        begin
            set @maxid = (select max(code) from lu_institution_10) + 1
            if isnull(@maxID, 0) < 500001 set @maxid = 500001
        end
        Insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
        select Code = @maxid, 
               DisplayCode = '56955', 
               UserDescription = 'The Focus Eye Center', DefaultDescription = 'The Focus Eye Center', 
               CIHIValue = '56955', ValidFrom = '2020/04/01', ValidTo = '2099/03/31', InterfaceIn = '56955', 
               InstCareType = 'B', HospitalType = 'AM', IsAcute = 0, HospitalID = 0, LUText = '', InstitutionType = 'N'
    end
    else
        update [dbo].[LU_Institution_10]
        set InstCareType = 'B', HospitalType = 'AM', IsAcute = 0, InstitutionType = 'N'
        where CIHIValue = '56955'
end 
GO
if not exists (select *from [dbo].[LU_Institution_Type] where InstitutionNumber = '56955')
    insert into [dbo].[LU_Institution_Type](Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD)
    select 'ON', '56955', 'N', 'Ambulatory care clinic', 'The Focus Eye Center', '0'
GO
--Permit MDAS
update u_usersfields set MandatoryStatus = 1000 where fieldid = 45557
GO
--2.x-1931 
declare @ID int
if not exists (select * from lu_diagnosisprefix where CIHIValue = '7' and DefaultDescription = 'Condition(s) or symptom(s) with relationship between/associated with past COVID-19')
begin
    set @ID = 31
    if exists (select * from lu_diagnosisprefix where code = @ID)
    begin
        set @ID = (select max(code) from lu_diagnosisprefix) + 1
        if isnull(@ID, 0) < 500001 set @ID = 500001
    end
    Insert into lu_diagnosisprefix(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
    values(@ID, '7', 'Condition(s) or symptom(s) with relationship between/associated with past COVID-19', 'Condition(s) or symptom(s) with relationship between/associated with past COVID-19',
    '7', '2020/04/01', '2099/03/31', '7', 0, '')
end
GO
--2.x-1932 -   DAD : Special Project 019
declare @code int
set @code = 40
if not exists (select * from lu_project where code = 40 and CIHIValue = '019')
begin
	if exists (select * from lu_project where code = 40)
	begin
		--Move the project to other place
		set @code = (select max(code) from lu_project) + 1
		if @code < 500000
			set @code = 500001
		update lu_project set code = @code where code = 40
		update [dbo].[LU_ProjectQuestion1] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion2] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion3] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion4] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion5] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion6] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion7] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion8] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion9] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion10] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion11] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion12] set associationid = @code where associationid = 40
		update [dbo].[LU_ProjectQuestion13] set associationid = @code where associationid = 40
		update ab_project set projectnumber = @code where projectnumber = 40
	end
	insert into [dbo].[LU_Project](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, 
		QuestionState1, Question1, QuestionState2, Question2, QuestionState3, Question3, QuestionState4, Question4, QuestionState5, Question5, 
		QuestionState6, Question6, QuestionState7, Question7, QuestionState8, Question8, QuestionState9, Question9, QuestionState10, Question10, 
		QuestionState11, Question11, QuestionState12, Question12, QuestionState13, Question13, QuestionState14, Question14, QuestionState15, Question15,
		QuestionState16, Question16, QuestionState17, Question17, QuestionState18, Question18, QuestionState19, Question19, QuestionState20, Question20, 
		QuestionState21, Question21, QuestionState22, Question22, QuestionState23, Question23, QuestionState24, Question24,  
		InterfaceIn, HospitalID, LUText)
	select
		Code = 40, DisplayCode = '019', UserDescription = '[DAD] Field Hospital/Alternate Health Facility Use', DefaultDescription = '[DAD] Field Hospital/Alternate Health Facility Use', 
		CIHIValue = '019', ValidFrom = '2019-04-01', ValidTo = '2099-03-31', 
		QuestionState1 = 2,  Question1 = 'Admission to Field Hospital/AHF', 
		QuestionState2 = 2,  Question2 = 'First digit of Days in Field Hospital/AHF', 
		QuestionState3 = 2,  Question3 = 'Second digit of Days in Field Hospital/AHF', 
		QuestionState4 = 2,  Question4 = 'Third digit of Days in Field Hospital/AHF', 
		QuestionState5 = 11,  Question5 = 'Regional Definition and Use 1', 
		QuestionState6 = 11,  Question6 = 'Regional Definition and Use 2', 
		QuestionState7 = 11,  Question7 = 'Regional Definition and Use 3', 
		QuestionState8 = 11,  Question8 = 'Regional Definition and Use 4', 
		QuestionState9 = 11,  Question9 = 'Regional Definition and Use 5', 
		QuestionState10 = 11,  Question10 = 'Regional Definition and Use 6', 
		QuestionState11 = 11,  Question11 = 'Regional Definition and Use 7', 
		QuestionState12 = 11,  Question12 = 'Regional Definition and Use 8', 
		QuestionState13 = 11,  Question13 = 'Regional Definition and Use 9', 
		QuestionState14 = 11,  Question14 = 'Regional Definition and Use 10', 
		QuestionState15 = 11,  Question15 = 'Regional Definition and Use 11', 
		QuestionState16 = 11,  Question16 = 'Regional Definition and Use 12', 
		QuestionState17 = 11,  Question17 = 'Regional Definition and Use 13', 
		QuestionState18 = 11,  Question18 = 'Regional Definition and Use 14', 
		QuestionState19 = 11,  Question19 = 'Regional Definition and Use 15', 
		QuestionState20 = 11,  Question20 = 'Regional Definition and Use 16', 
		QuestionState21 = 11,  Question21 = 'Regional Definition and Use 17', 
		QuestionState22 = 11,  Question22 = 'Regional Definition and Use 18', 
		QuestionState23 = 11,  Question23 = 'Regional Definition and Use 19', 
		QuestionState24 = 11,  Question24 = 'Regional Definition and Use 20', 
		InterfaceIn = '019', HospitalID = 0, LUText = ''

		--Question 1: Admission to Field Hospital/AHF 
		if exists (select * from [dbo].[LU_ProjectQuestion1] where code between 1401 and 1410 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion1])
			if @code < 500000 set @code = 500000
			update AB_Project set question1 = question1 + @code where question1 between 1401 and 1410
			update [LU_ProjectQuestion1] set code = code + @code where code between 1401 and 1410
		end
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1401, 'Y', 'Yes', 'Yes', 'Y', '2019-04-01', '2099-03-31', 40, 'Y', 0, '')

		--Question 2: First digit of Days in Field Hospital/AHF 
		if exists (select * from [dbo].[LU_ProjectQuestion2] where code between 1401 and 1410 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion2])
			if @code < 500000 set @code = 500000
			update AB_Project set question2 = question2 + @code where question2 between 1401 and 1410
			update [LU_ProjectQuestion2] set code = code + @code where code between 1401 and 1410
		end
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1401, '0', '0', '0', '0', '2019-04-01', '2099-03-31', 40, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1402, '1', '1', '1', '1', '2019-04-01', '2099-03-31', 40, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1403, '2', '2', '2', '2', '2019-04-01', '2099-03-31', 40, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1404, '3', '3', '3', '3', '2019-04-01', '2099-03-31', 40, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1405, '4', '4', '4', '4', '2019-04-01', '2099-03-31', 40, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1406, '5', '5', '5', '5', '2019-04-01', '2099-03-31', 40, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1407, '6', '6', '6', '6', '2019-04-01', '2099-03-31', 40, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1408, '7', '7', '7', '7', '2019-04-01', '2099-03-31', 40, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1409, '8', '8', '8', '8', '2019-04-01', '2099-03-31', 40, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1410, '9', '9', '9', '9', '2019-04-01', '2099-03-31', 40, '9', 0, '')
		
        --Question 3: Second digit of Days in Field Hospital/AHF 
		if exists (select * from [dbo].[LU_ProjectQuestion3] where code between 1401 and 1410 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion3])
			if @code < 500000 set @code = 500000
			update AB_Project set Question3 = Question3 + @code where Question3 between 1401 and 1410
			update [LU_ProjectQuestion3] set code = code + @code where code between 1401 and 1410
		end
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1401, '0', '0', '0', '0', '2019-04-01', '2099-03-31', 40, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1402, '1', '1', '1', '1', '2019-04-01', '2099-03-31', 40, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1403, '2', '2', '2', '2', '2019-04-01', '2099-03-31', 40, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1404, '3', '3', '3', '3', '2019-04-01', '2099-03-31', 40, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1405, '4', '4', '4', '4', '2019-04-01', '2099-03-31', 40, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1406, '5', '5', '5', '5', '2019-04-01', '2099-03-31', 40, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1407, '6', '6', '6', '6', '2019-04-01', '2099-03-31', 40, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1408, '7', '7', '7', '7', '2019-04-01', '2099-03-31', 40, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1409, '8', '8', '8', '8', '2019-04-01', '2099-03-31', 40, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1410, '9', '9', '9', '9', '2019-04-01', '2099-03-31', 40, '9', 0, '')

		--Question 4: Third digit of Days in Field Hospital/AHF 
		if exists (select * from [dbo].[LU_ProjectQuestion4] where code between 1401 and 1410 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion4])
			if @code < 500000 set @code = 500000
			update AB_Project set Question4 = Question4 + @code where Question4 between 1401 and 1410
			update [LU_ProjectQuestion4] set code = code + @code where code between 1401 and 1410
		end
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1401, '0', '0', '0', '0', '2019-04-01', '2099-03-31', 40, '0', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1402, '1', '1', '1', '1', '2019-04-01', '2099-03-31', 40, '1', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1403, '2', '2', '2', '2', '2019-04-01', '2099-03-31', 40, '2', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1404, '3', '3', '3', '3', '2019-04-01', '2099-03-31', 40, '3', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1405, '4', '4', '4', '4', '2019-04-01', '2099-03-31', 40, '4', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1406, '5', '5', '5', '5', '2019-04-01', '2099-03-31', 40, '5', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1407, '6', '6', '6', '6', '2019-04-01', '2099-03-31', 40, '6', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1408, '7', '7', '7', '7', '2019-04-01', '2099-03-31', 40, '7', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1409, '8', '8', '8', '8', '2019-04-01', '2099-03-31', 40, '8', 0, '')
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1410, '9', '9', '9', '9', '2019-04-01', '2099-03-31', 40, '9', 0, '')

		--Question 5: 1st digit of regional definition and use
		if exists (select * from [dbo].[LU_ProjectQuestion5] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion5])
			if @code < 500000 set @code = 500000
			update AB_Project set Question5 = Question5 + @code where Question5 between 1401 and 1435
			update [LU_ProjectQuestion5] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 6: 2nd digit of regional definition and use
		if exists (select * from [dbo].[LU_ProjectQuestion6] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion6])
			if @code < 500000 set @code = 500000
			update AB_Project set Question6 = Question6 + @code where Question6 between 1401 and 1435
			update [LU_ProjectQuestion6] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 7: 3rd digit of regional definition and use
		if exists (select * from [dbo].[LU_ProjectQuestion7] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion7])
			if @code < 500000 set @code = 500000
			update AB_Project set Question7 = Question7 + @code where Question7 between 1401 and 1435
			update [LU_ProjectQuestion7] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 8: 4th digit of regional definition and use
		if exists (select * from [dbo].[LU_ProjectQuestion8] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion8])
			if @code < 500000 set @code = 500000
			update AB_Project set Question8 = Question8 + @code where Question8 between 1401 and 1435
			update [LU_ProjectQuestion8] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 9: 5th digit of Month of Date of First Visit
		if exists (select * from [dbo].[LU_ProjectQuestion9] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion9])
			if @code < 500000 set @code = 500000
			update AB_Project set Question9 = Question9 + @code where Question9 between 1401 and 1435
			update [LU_ProjectQuestion9] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 10: 6th digit of Month of Date of First Visit
		if exists (select * from [dbo].[LU_ProjectQuestion10] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion10])
			if @code < 500000 set @code = 500000
			update AB_Project set Question10 = Question10 + @code where Question10 between 1401 and 1435
			update [LU_ProjectQuestion10] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 11: 7th digit of Month of Date of First Visit
		if exists (select * from [dbo].[LU_ProjectQuestion11] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion11])
			if @code < 500000 set @code = 500000
			update AB_Project set Question11 = Question11 + @code where Question11 between 1401 and 1435
			update [LU_ProjectQuestion11] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 12: 8th digit of Month of Date of First Visit
		if exists (select * from [dbo].[LU_ProjectQuestion12] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion12])
			if @code < 500000 set @code = 500000
			update AB_Project set Question12 = Question12 + @code where Question12 between 1401 and 1435
			update [LU_ProjectQuestion12] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

		--Question 13: 9th digit of Month of Date of First Visit
		if exists (select * from [dbo].[LU_ProjectQuestion13] where code between 1401 and 1435 and associationid <> 40)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion13])
			if @code < 500000 set @code = 500000
			update AB_Project set Question13 = Question13 + @code where Question13 between 1401 and 1435
			update [LU_ProjectQuestion13] set code = code + @code where code between 1401 and 1435
		end
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 40, cihivalue, 0, ''
        from (
		select code = 1401, cihivalue = '0' union
		select code = 1402, cihivalue = '1' union
		select code = 1403, cihivalue = '2' union
		select code = 1404, cihivalue = '3' union
		select code = 1405, cihivalue = '4' union
		select code = 1406, cihivalue = '5' union
		select code = 1407, cihivalue = '6' union
		select code = 1408, cihivalue = '7' union
		select code = 1409, cihivalue = '8' union
		select code = 1410, cihivalue = '9' union
		select code = 1411, cihivalue = 'A' union
		select code = 1412, cihivalue = 'B' union
		select code = 1413, cihivalue = 'C' union
		select code = 1414, cihivalue = 'D' union
		select code = 1415, cihivalue = 'E' union
		select code = 1416, cihivalue = 'F' union
		select code = 1417, cihivalue = 'G' union
		select code = 1418, cihivalue = 'H' union
		select code = 1419, cihivalue = 'I' union
		select code = 1420, cihivalue = 'J' union
		select code = 1421, cihivalue = 'K' union
		select code = 1422, cihivalue = 'L' union
		select code = 1423, cihivalue = 'M' union
		select code = 1424, cihivalue = 'N' union
		select code = 1425, cihivalue = 'O' union
		select code = 1426, cihivalue = 'P' union
		select code = 1427, cihivalue = 'Q' union
		select code = 1428, cihivalue = 'R' union
		select code = 1429, cihivalue = 'S' union
		select code = 1430, cihivalue = 'T' union
		select code = 1431, cihivalue = 'U' union
		select code = 1432, cihivalue = 'V' union
		select code = 1433, cihivalue = 'W' union
		select code = 1434, cihivalue = 'X' union
		select code = 1435, cihivalue = 'Y') A

	end
GO
--2.x-1932 -   NACRS : Special Project 019
declare @code int
set @code = 41
if not exists (select * from lu_project where code = 41 and CIHIValue = '019')
begin
	if exists (select * from lu_project where code = 41)
	begin
		--Move the project to other place
		set @code = (select max(code) from lu_project) + 1
		if @code < 500000
			set @code = 500001
		update lu_project set code = @code where code = 41
		update [dbo].[LU_ProjectQuestion1] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion2] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion3] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion4] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion5] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion6] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion7] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion8] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion9] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion10] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion11] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion12] set associationid = @code where associationid = 41
		update [dbo].[LU_ProjectQuestion13] set associationid = @code where associationid = 41
		update ab_project set projectnumber = @code where projectnumber = 41
	end
	insert into [dbo].[LU_Project](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, 
		QuestionState1, Question1, QuestionState2, Question2, QuestionState3, Question3, QuestionState4, Question4, QuestionState5, Question5, 
		QuestionState6, Question6, QuestionState7, Question7, QuestionState8, Question8, QuestionState9, Question9, QuestionState10, Question10, 
		QuestionState11, Question11, QuestionState12, Question12, QuestionState13, Question13, QuestionState14, Question14, QuestionState15, Question15,
		QuestionState16, Question16, QuestionState17, Question17, QuestionState18, Question18, QuestionState19, Question19, QuestionState20, Question20, 
		QuestionState21, Question21, QuestionState22, Question22, QuestionState23, Question23, QuestionState24, Question24,  
		InterfaceIn, HospitalID, LUText)
	select
		Code = 41, DisplayCode = '019', UserDescription = '[NACRS] Field Hospital/Alternate Health Facility Use', DefaultDescription = '[NACRS] Field Hospital/Alternate Health Facility Use', 
		CIHIValue = '019', ValidFrom = '2019-04-01', ValidTo = '2099-03-31', 
		QuestionState1 = 2,  Question1 = 'Visit Occurred in Field Hospital/AHF', 
		QuestionState2 = 11,  Question2 = 'Regional Definition and Use 1', 
		QuestionState3 = 11,  Question3 = 'Regional Definition and Use 2', 
		QuestionState4 = 11,  Question4 = 'Regional Definition and Use 3', 
		QuestionState5 = 11,  Question5 = 'Regional Definition and Use 4', 
		QuestionState6 = 11,  Question6 = 'Regional Definition and Use 5', 
		QuestionState7 = 11,  Question7 = 'Regional Definition and Use 6', 
		QuestionState8 = 11,  Question8 = 'Regional Definition and Use 7', 
		QuestionState9 = 11,  Question9 = 'Regional Definition and Use 8', 
		QuestionState10 = 11,  Question10 = 'Regional Definition and Use 9', 
		QuestionState11 = 11,  Question11 = 'Regional Definition and Use 10', 
		QuestionState12 = 11,  Question12 = 'Regional Definition and Use 11', 
		QuestionState13 = 11,  Question13 = 'Regional Definition and Use 12', 
		QuestionState14 = 11,  Question14 = 'Regional Definition and Use 13', 
		QuestionState15 = 11,  Question15 = 'Regional Definition and Use 14', 
		QuestionState16 = 11,  Question16 = 'Regional Definition and Use 15', 
		QuestionState17 = 11,  Question17 = 'Regional Definition and Use 16', 
		QuestionState18 = 11,  Question18 = 'Regional Definition and Use 17', 
		QuestionState19 = 11,  Question19 = 'Regional Definition and Use 18', 
		QuestionState20 = 11,  Question20 = 'Regional Definition and Use 19', 
		QuestionState21 = 11,  Question21 = 'Regional Definition and Use 20', 
		QuestionState22 = 11,  Question22 = 'Regional Definition and Use 21', 
		QuestionState23 = 11,  Question23 = 'Regional Definition and Use 22', 
		QuestionState24 = 11,  Question24 = 'Regional Definition and Use 23', 
		InterfaceIn = '019', HospitalID = 0, LUText = ''

		--Question 1: Visit Occurred in Field Hospital/AHF
		if exists (select * from [dbo].[LU_ProjectQuestion1] where code between 1501 and 1510 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion1])
			if @code < 500000 set @code = 500000
			update AB_Project set question1 = question1 + @code where question1 between 1501 and 1510
			update [LU_ProjectQuestion1] set code = code + @code where code between 1501 and 1510
		end
		insert into [dbo].[LU_ProjectQuestion1](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
		values(1501, 'Y', 'Yes', 'Yes', 'Y', '2019-04-01', '2099-03-31', 41, 'Y', 0, '')

		--Question 2: regional definition and use 1
		if exists (select * from [dbo].[LU_ProjectQuestion2] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion2])
			if @code < 500000 set @code = 500000
			update AB_Project set Question2 = Question2 + @code where Question2 between 1501 and 1535
			update [LU_ProjectQuestion2] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion2](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A
		
        --Question 3: regional definition and use 2
		if exists (select * from [dbo].[LU_ProjectQuestion3] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion3])
			if @code < 500000 set @code = 500000
			update AB_Project set Question3 = Question3 + @code where Question3 between 1501 and 1535
			update [LU_ProjectQuestion3] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion3](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 4: regional definition and use 3
		if exists (select * from [dbo].[LU_ProjectQuestion4] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion4])
			if @code < 500000 set @code = 500000
			update AB_Project set Question4 = Question4 + @code where Question4 between 1501 and 1535
			update [LU_ProjectQuestion4] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion4](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 5: regional definition and use 4
		if exists (select * from [dbo].[LU_ProjectQuestion5] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion5])
			if @code < 500000 set @code = 500000
			update AB_Project set Question5 = Question5 + @code where Question5 between 1501 and 1535
			update [LU_ProjectQuestion5] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion5](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 6: regional definition and use 5
		if exists (select * from [dbo].[LU_ProjectQuestion6] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion6])
			if @code < 500000 set @code = 500000
			update AB_Project set Question6 = Question6 + @code where Question6 between 1501 and 1535
			update [LU_ProjectQuestion6] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion6](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 7: regional definition and use 6
		if exists (select * from [dbo].[LU_ProjectQuestion7] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion7])
			if @code < 500000 set @code = 500000
			update AB_Project set Question7 = Question7 + @code where Question7 between 1501 and 1535
			update [LU_ProjectQuestion7] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion7](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 8: regional definition and use 7
		if exists (select * from [dbo].[LU_ProjectQuestion8] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion8])
			if @code < 500000 set @code = 500000
			update AB_Project set Question8 = Question8 + @code where Question8 between 1501 and 1535
			update [LU_ProjectQuestion8] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion8](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 9: regional definition and use 8
		if exists (select * from [dbo].[LU_ProjectQuestion9] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion9])
			if @code < 500000 set @code = 500000
			update AB_Project set Question9 = Question9 + @code where Question9 between 1501 and 1535
			update [LU_ProjectQuestion9] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion9](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 10: regional definition and use 9
		if exists (select * from [dbo].[LU_ProjectQuestion10] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion10])
			if @code < 500000 set @code = 500000
			update AB_Project set Question10 = Question10 + @code where Question10 between 1501 and 1535
			update [LU_ProjectQuestion10] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 11: regional definition and use 10
		if exists (select * from [dbo].[LU_ProjectQuestion11] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion11])
			if @code < 500000 set @code = 500000
			update AB_Project set Question11 = Question11 + @code where Question11 between 1501 and 1535
			update [LU_ProjectQuestion11] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion11](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 12: regional definition and use 11
		if exists (select * from [dbo].[LU_ProjectQuestion12] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion12])
			if @code < 500000 set @code = 500000
			update AB_Project set Question12 = Question12 + @code where Question12 between 1501 and 1535
			update [LU_ProjectQuestion12] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion12](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

		--Question 13: regional definition and use 12
		if exists (select * from [dbo].[LU_ProjectQuestion13] where code between 1501 and 1535 and associationid <> 41)
		begin
			set @code = (select max(code) from [dbo].[LU_ProjectQuestion13])
			if @code < 500000 set @code = 500000
			update AB_Project set Question13 = Question13 + @code where Question13 between 1501 and 1535
			update [LU_ProjectQuestion13] set code = code + @code where code between 1501 and 1535
		end
		insert into [dbo].[LU_ProjectQuestion13](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, AssociationID, InterfaceIn, HospitalID, LUText)
        select code, cihivalue, cihivalue, cihivalue, cihivalue, '2019-04-01', '2099-03-31', 41, cihivalue, 0, ''
        from (
		select code = 1501, cihivalue = '0' union
		select code = 1502, cihivalue = '1' union
		select code = 1503, cihivalue = '2' union
		select code = 1504, cihivalue = '3' union
		select code = 1505, cihivalue = '4' union
		select code = 1506, cihivalue = '5' union
		select code = 1507, cihivalue = '6' union
		select code = 1508, cihivalue = '7' union
		select code = 1509, cihivalue = '8' union
		select code = 1510, cihivalue = '9' union
		select code = 1511, cihivalue = 'A' union
		select code = 1512, cihivalue = 'B' union
		select code = 1513, cihivalue = 'C' union
		select code = 1514, cihivalue = 'D' union
		select code = 1515, cihivalue = 'E' union
		select code = 1516, cihivalue = 'F' union
		select code = 1517, cihivalue = 'G' union
		select code = 1518, cihivalue = 'H' union
		select code = 1519, cihivalue = 'I' union
		select code = 1520, cihivalue = 'J' union
		select code = 1521, cihivalue = 'K' union
		select code = 1522, cihivalue = 'L' union
		select code = 1523, cihivalue = 'M' union
		select code = 1524, cihivalue = 'N' union
		select code = 1525, cihivalue = 'O' union
		select code = 1526, cihivalue = 'P' union
		select code = 1527, cihivalue = 'Q' union
		select code = 1528, cihivalue = 'R' union
		select code = 1529, cihivalue = 'S' union
		select code = 1530, cihivalue = 'T' union
		select code = 1531, cihivalue = 'U' union
		select code = 1532, cihivalue = 'V' union
		select code = 1533, cihivalue = 'W' union
		select code = 1534, cihivalue = 'X' union
		select code = 1535, cihivalue = 'Y') A

	end
GO
--2.x-1935/1939 -   Add User Descriptions for COVID-19 Codes
Update icd_diagfile10
set UserDescription = 'Multisystem inflammatory syndrome (MIS) associated with COVID-19',
    [IsDischarge] = 1,
    [EDDiagnosis] = 1
where cihivalue = 'U073' 
GO
Update icd_diagfile10
set UserDescription = 'Post COVID-19 condition',
    [IsDischarge] = 1,
    [EDDiagnosis] = 1
where cihivalue = 'U074' 
GO
Update icd_diagfile10
set UserDescription = 'Personal history of COVID-19'
where cihivalue = 'U075' 
GO
--2.x-1941 
declare @province varchar(10)
declare @maxId int
set @province = (select top 1 p.cihivalue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @province = '5'
begin
    if not exists (select * from lu_institution_10 where cihivalue = '56688')
    begin
        set  @maxid = 91765
        if exists (select * from lu_institution_10 where code = @maxid)
        begin
            set @maxid = (select max(code) from lu_institution_10) + 1
            if isnull(@maxID, 0) < 500001 set @maxid = 500001
        end
        Insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
        select Code = @maxid, 
               DisplayCode = '56688', 
               UserDescription = 'Alternate Health Facility', DefaultDescription = 'Alternate Health Facility', 
               CIHIValue = '56688', ValidFrom = '2020/04/01', ValidTo = '2099/03/31', InterfaceIn = '56688', 
               InstCareType = 'A', HospitalType = 'AT', IsAcute = 1, HospitalID = 0, LUText = '', InstitutionType = '1'
    end
    else
        update [dbo].[LU_Institution_10]
        set InstCareType = 'A', HospitalType = 'AT', IsAcute = 1, InstitutionType = '1'
        where CIHIValue = '56688'
end 
GO
if not exists (select *from [dbo].[LU_Institution_Type] where InstitutionNumber = '56688')
    insert into [dbo].[LU_Institution_Type](Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD)
    select 'ON', '56688', '1', 'Acute inpatient care', 'Alternate Health Facility', '1'
GO
--2.x-1943 
declare @province varchar(10)
declare @maxId int
set @province = (select top 1 p.cihivalue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @province = '5'
begin
    if not exists (select * from lu_institution_10 where cihivalue = '56677')
    begin
        set  @maxid = 91766
        if exists (select * from lu_institution_10 where code = @maxid)
        begin
            set @maxid = (select max(code) from lu_institution_10) + 1
            if isnull(@maxID, 0) < 500001 set @maxid = 500001
        end
        Insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
        select Code = @maxid, 
               DisplayCode = '56677', 
               UserDescription = 'AHF Missassauga Hospital -Acute -Pandemic Response Unit', DefaultDescription = 'AHF Missassauga Hospital -Acute -Pandemic Response Unit', 
               CIHIValue = '56677', ValidFrom = '2020/04/01', ValidTo = '2099/03/31', InterfaceIn = '56677', 
               InstCareType = 'A', HospitalType = 'AT', IsAcute = 1, HospitalID = 0, LUText = '', InstitutionType = '1'
    end
    else
        update [dbo].[LU_Institution_10]
        set InstCareType = 'A', HospitalType = 'AT', IsAcute = 1, InstitutionType = '1'
        where CIHIValue = '56677'
end 
GO
if not exists (select *from [dbo].[LU_Institution_Type] where InstitutionNumber = '56677')
    insert into [dbo].[LU_Institution_Type](Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD)
    select 'ON', '56677', '1', 'Acute inpatient care', 'AHF Missassauga Hospital -Acute -Pandemic Response Unit ', '1'
GO
declare @province varchar(10)
declare @maxId int
set @province = (select top 1 p.cihivalue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @province = '5'
begin
    if not exists (select * from lu_institution_10 where cihivalue = '56678')
    begin
        set  @maxid = 91767
        if exists (select * from lu_institution_10 where code = @maxid)
        begin
            set @maxid = (select max(code) from lu_institution_10) + 1
            if isnull(@maxID, 0) < 500001 set @maxid = 500001
        end
        Insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
        select Code = @maxid, 
               DisplayCode = '56678', 
               UserDescription = 'AHF Missassauga Hospital -Rehab -Pandemic Response Unit', DefaultDescription = 'AHF Missassauga Hospital -Rehab -Pandemic Response Unit', 
               CIHIValue = '56678', ValidFrom = '2020/04/01', ValidTo = '2099/03/31', InterfaceIn = '56678', 
               InstCareType = 'R', HospitalType = 'GR', IsAcute = 0, HospitalID = 0, LUText = '', InstitutionType = '2'
    end
    else
        update [dbo].[LU_Institution_10]
        set InstCareType = 'R', HospitalType = 'GR', IsAcute = 0, InstitutionType = '2'
        where CIHIValue = '56678'
end 
GO
if not exists (select *from [dbo].[LU_Institution_Type] where InstitutionNumber = '56678')
    insert into [dbo].[LU_Institution_Type](Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD)
    select 'ON', '56678', '2', 'Inpatient rehabilitation', 'AHF Missassauga Hospital -Acute -Pandemic Response Unit ', '0'
GO
--2.x-1948
if exists (select * from information_schema.tables where table_name = 'zzNRS_CA_2020')
    drop table zzNRS_CA_2020
GO
if exists (select * from information_schema.tables where table_name = 'zzNRS_CA_2020_new')
    drop table zzNRS_CA_2020_new
GO
create table dbo.zzNRS_CA_2020(
    CIHIValue varchar(10), 
    UserDescription varchar(1000)
)
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A047', 'Enterocolitis due to Clostridium difficile [C. dif]  (Includes:  Foodborne intoxication by Clostridium difficile, pseudomembranous colitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A048', 'Other specified bacterial intestinal infections ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A049', 'Bacterial intestinal infection, unspecified  (Includes:  Bacterial enteritis NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A08', 'Viral and other specified intestinal infections  (Excludes:  Norwalk virus (A08.1))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A081', 'Acute gastroenteropathy due to Norwalk agent  (Includes:  Small round structured virus enteritis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A09', 'Other gastroenteritis and colitis of infectious and unspecified origin.  (Excludes:  Noninfective (noninfectious) diarrhoea (K52))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A15', 'Respiratory tuberculosis, bacteriologically and histologically confirmed  (Excludes:  Primary respiratory tuberculosis, confirmed bacteriologically and histologically  (A15.7))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A157', 'Primary respiratory tuberculosis, confirmed bacteriologically and histologically')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A16', 'Respiratory tuberculosis, not confirmed bacteriologically or histologically  (Excludes:  Primary respiratory tuberculosis without mention of bacteriological or histological confirmation  (A16.7))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A167', 'Primary respiratory tuberculosis without mention of bacteriological or histological confirmation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A17', 'Tuberculosis of nervous system   ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A18', 'Tuberculosis of other organs  (Excludes:  Tuberculosis of bones and joints (A18.0) )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A180', 'Tuberculosis of bones and joints (Note:  Code also tuberculosis arthritis (M01.1) when applicable.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A390', 'Meningococcal meningitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A40', 'Streptococcal sepsis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A41', 'Other sepsis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A490', 'Staphylococcal infection, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A491', 'Streptococcal infection, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A498', 'Other bacterial infections of unspecified site  (Includes:  Haemophilus influenzae infection unspecified; mycoplasma infection unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A499', 'Bacterial infection unspecified  (Includes: Bacteraemia/bacteremia NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A521', 'Symptomatic neurosyphilis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A80', 'Acute poliomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A86', 'Unspecified viral encephalitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A87', 'Viral meningitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('A923', 'West Nile Virus ( Includes:  West Nile: encephalitis, encephalomyelitis, fever, meningitis, virus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B02', 'Zoster [herpes zoster]  (Includes:  Shingles, zona)  (Excludes:  That with nervous system involvement (See B02.2)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B022', 'Zoster with other nervous system involvement.  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B15', 'Acute hepatitis A')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B16', 'Acute hepatitis B')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B17', 'Other acute viral hepatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B18', 'Chronic viral hepatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B19', 'Unspecified viral hepatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B24', 'Human immunodeficiency virus [HIV] disease (Includes:  Acquired immunodeficiency syndrome [AIDS] NOS AIDS-related complex [ARC] NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B27', 'Infectious mononucleosis  (Includes:  Glandular fever, monocytic angina, Pfeiffer''s disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B90', 'Sequelae of tuberculosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B91', 'Sequelae of poliomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B941', 'Sequelae of viral encephalitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('B99', 'Other and unspecified infectious diseases')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C14', 'Malignant neoplasm of other and ill-defined sites in the lip, oral cavity and pharynx')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C15', 'Malignant neoplasm of oesophagus (Includes:  Malignant neoplasm of esophagus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C16', 'Malignant neoplasm of stomach')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C17', 'Malignant neoplasm of small intestine (Includes:  Duodenum, jejunum, ileum)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C18', 'Malignant neoplasm of colon')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C19', 'Malignant neoplasm of rectosigmoid junction  (Includes:  Colon with rectum, pelvic peritoneal reflection, rectosigmoid (colon))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C20', 'Malignant neoplasm of rectum  (Includes:  Rectal ampulla)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C21', 'Malignant neoplasm of anus and anal canal')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C22', 'Malignant neoplasm of liver and intrahepatic bile ducts (Excludes:  Biliary tract NOS (C24))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C23', 'Malignant neoplasm of gallbladder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C24', 'Malignant neoplasm of other and unspecified parts of biliary tract (Excludes:  Intrahepatic bile duct (C22))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C25', 'Malignant neoplasm of pancreas')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C30', 'Malignant neoplasm of nasal cavity and middle ear')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C31', 'Malignant neoplasm of accessory sinuses (Includes: Maxillary, ethmoid, frontal and sphenoid sinuses)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C32', 'Malignant neoplasm of larynx')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C33', 'Malignant neoplasm of trachea')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C34', 'Malignant neoplasm of bronchus and lung')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C37', 'Malignant neoplasm of thymus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C38', 'Malignant neoplasm of heart, mediastinum and pleura')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C400', 'Malignant neoplasm scapula and long bones of upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C401', 'Malignant neoplasm short bones of upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C402', 'Malignant neoplasm long bones of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C403', 'Malignant neoplasm short bones of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C408', 'Overlapping malignant lesion of bone and articular cartilage of limbs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C409', 'Malignant neoplasm bone and articular cartilage of limb, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C41', 'Malignant neoplasm of bone and articular cartilage of other and unspecified sites  (Excludes:  Malignant neoplasm of vertebral column (C41.2))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C412', 'Malignant neoplasm of vertebral column  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C43', 'Malignant melanoma of skin')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C44', 'Other malignant neoplasms of skin  (Includes:  Malignant neoplasm of:  sebaceous glands, sweat glands)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C490', 'Malignant neoplasm of connective and soft tissue of head, face and neck (Includes:  Connective tissue of:  ear, eyelid)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C491', 'Malignant neoplasm of connective and soft tissue of upper limb, including shoulder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C492', 'Malignant neoplasm of connective and soft tissue of lower limb, including hip')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C493', 'Malignant neoplasm of connective and soft tissue of thorax (Includes:  Axilla, diaphragm, great vessels)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C494', 'Malignant neoplasm of connective and soft tissue of abdomen (Includes:  Abdominal wall, hypochondrium)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C495', 'Malignant neoplasm of connective and soft tissue of pelvis  (Includes:  Buttock, groin, perineum)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C496', 'Malignant neoplasm of connective and soft tissue of trunk, unspecified (Includes:  Back NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C499', 'Malignant neoplasm of connective and soft tissue, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C50', 'Malignant neoplasm of breast  (Includes:  Connective tissue of breast)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C51', 'Malignant neoplasm of vulva')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C52', 'Malignant neoplasm of vagina')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C53', 'Malignant neoplasm of cervix uteri  (Includes:  Endocervix, exocervix)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C54', 'Malignant neoplasm of corpus uteri  (Includes:  Endometrium, myometrium, fundus uteri)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C55', 'Malignant neoplasm of uterus, part unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C56', 'Malignant neoplasm of ovary  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C57', 'Malignant neoplasm of other and unspecified female genital organs (Includes:  Fallopian tube, broad and round ligament, parametrium, uterine adnexa)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C61', 'Malignant neoplasm of prostate')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C63', 'Malignant neoplasm of other and unspecified male genital organs (Includes:  Epididymis, spermatic cord, scrotum, seminal vesicle, tunica vaginalis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C64', 'Malignant neoplasm of kidney, except renal pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C65', 'Malignant neoplasm of renal pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C66', 'Malignant neoplasm of ureter')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C67', 'Malignant neoplasm of bladder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C68', 'Malignant neoplasm of other and unspecified urinary organs (Includes: Urethra, paraurethral gland)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C701', 'Malignant neoplasm of spinal meninges (cord)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C71', 'Malignant neoplasm of brain  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C72', 'Malignant neoplasm of spinal cord, cranial nerves and other parts of central nervous system (Includes: Cauda equina, olfactory nerve, acoustic nerve, cranial nerve NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C76', 'Malignant neoplasm of other and ill-defined sites  (Includes:  Head face & neck, thorax, abdomen, pelvis, upper limb, lower limb)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C770', 'Secondary [metastasis] malignant neoplasm lymph nodes of head, face and neck  (Includes:  Supraclavicular lymph nodes)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C771', 'Secondary  [metastasis] malignant neoplasm of intrathoracic lymph nodes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C772', 'Secondary  [metastasis] malignant neoplasm of intra-abdominal lymph nodes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C773', 'Secondary  [metastasis] malignant neoplasm of axillary and upper limb lymph nodes  (Includes:  Pectoral lymph nodes)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C774', 'Secondary  [metastasis] malignant neoplasm of inguinal and lower limb lymph nodes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C775', 'Secondary  [metastasis] malignant neoplasm of intrapelvic lymph nodes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C778', 'Secondary  [metastasis] malignant neoplasm of lymph nodes of multiple regions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C779', 'Secondary [metastasis]  malignant neoplasm of lymph node, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C780', 'Secondary  [metastasis] malignant neoplasm of lung')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C781', 'Secondary  [metastasis] malignant neoplasm of mediastinum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C782', 'Secondary  [metastasis] malignant neoplasm of pleura  (Includes:  Malignant pleural effusion NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C783', 'Secondary  [metastasis] malignant neoplasm of other and unspecified respiratory organs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C788', 'Secondary  [metastasis] malignant neoplasm of other and unspecified digestive organs (Includes: Small intestine, large intestine and rectum, retroperitoneum, peritoneum, malignant ascites NOS, liver and intrahepatic bile duct)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C790', 'Secondary [metastasis]  malignant neoplasm of kidney and renal pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C791', 'Secondary  [metastasis] malignant neoplasm of bladder and other and unspecified urinary organs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C792', 'Secondary  [metastasis] malignant neoplasm of skin')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C793', 'Secondary  [metastasis] malignant neoplasm of brain and cerebral meninges. (Includes: Brain meninges, cerebral, cranial, intracranial)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C794', 'Secondary  [metastasis] malignant neoplasm of other and unspecified parts of nervous system (Includes: Meninges, spinal meninges,  spinal cord, spinal dura (mater))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C795', 'Secondary  [metastasis] malignant neoplasm of bone and bone marrow')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C796', 'Secondary  [metastasis] malignant neoplasm of ovary')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C797', 'Secondary  [metastasis] malignant neoplasm of adrenal gland')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C7980', 'Secondary  [metastasis] malignant neoplasm of breast')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C7988', 'Secondary  [metastasis] malignant neoplasm of other specified sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C799', 'Secondary malignant neoplasm, unspecified site (Includes: Carcinomatosis (secondary), generalized (secondary),  cancer NOS, malignancy NOS, and multiple cancer (secondary) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C80', 'Malignant neoplasm without specification of site (Includes: Primary cancer NOS or unknown) ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C81', 'Hodgkin lymphoma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C85', 'Other and unspecified types of non-Hodgkin lymphoma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C88', 'Malignant immunoproliferative diseases')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C90', 'Multiple myeloma and malignant plasma cell neoplasms  (Includes:  Kahler''s disease, myelomatosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C91', 'Lymphoid leukaemia   (Includes:  Acute lymphoblastic leukaemia [ALL], chronic lymphocytic leukaemia [CLL], lymphoid leukemia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C92', 'Myeloid leukaemia  (Includes:  Acute myeloblastic leukemia [AML], chronic myeloid leukemia [CML], myeloid leukemia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C93', 'Monocytic leukaemia  (Includes: Monocytic leukemia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C94', 'Other specified leukaemias (Includes: Other specified leukemias)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('C95', 'Leukaemia of unspecified cell type (Includes: Leukemia of unspecified cell type)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D18', 'Haemangioma and lymphangioma, any site (Includes: Angioma NOS, hemangioma)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D200', 'Benign neoplasm of retroperitoneum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D21', 'Other benign neoplasms of connective and other soft tissue (Includes:  Blood vessel, bursa, cartilage, fascia, fat ligament, except uterine, lymphatic channel, muscle, synovia, tendon)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D31', 'Benign neoplasm of eye and adnexa')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D320', 'Benign neoplasm of cerebral meninges')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D321', 'Benign neoplasm of spinal meninges')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D332', 'Benign neoplasm of brain, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D333', 'Benign neoplasm of cranial nerves')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D334', 'Benign neoplasm of spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D339', 'Benign neoplasm of central nervous system, unspecified (Includes:  Nervous system (central) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D34', 'Benign neoplasm of thyroid gland')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D35', 'Benign neoplasm of other and unspecified endocrine glands (Includes: Adrenal, parathyroid, pituitary, craniopharyngeal, pineal)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D36', 'Benign neoplasm of other and unspecified sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D432', 'Neoplasm of uncertain or unknown behaviour of brain, unspecified  (Includes: Brain NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D434', 'Neoplasm of uncertain or unknown behaviour of spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D48', 'Neoplasm of uncertain or unknown behaviour of other and unspecified sites   (Includes: Bone and articular cartilage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D649', 'Anaemia, unspecified (Includes: Anemia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D66', 'Hereditary factor VIII deficiency (Includes: Haemophilia A, haemophilia/hemophilia NOS;)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D67', 'Hereditary factor IX deficiency (Includes: Haemophilia B; hemophilia B)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D68', 'Other coagulation defects (Includes: Haemophilia C; hemophilia C, Von Willebrand''s disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D696', 'Thrombocytopenia, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D75', 'Other diseases of blood and blood-forming organs (Includes: familial erythrocytosis, secondary polycythaemia, secondary thrombocytosis, basophilia) (Excludes: Leukemia (see codes C91 to C94), Abnormal findings of blood chemistry (R79) )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('D86', 'Sarcoidosis (Includes:  lung, lymph nodes, skin, other and combined sites)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E03', 'Other hypothyroidism (Includes: Unspecified hypothyroidism)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E04', 'Other  nontoxic goitre (Includes: Unspecified nontoxic goitre)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E05', 'Thyrotoxicosis [hyperthyroidism]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E06', 'Thyroiditis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E07', 'Other disorders of thyroid  (Includes: Unspecified disorders of thyroid)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E10', 'Type 1 diabetes mellitus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E11', 'Type 2 diabetes mellitus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E13', 'Other specified diabetes mellitus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E14', 'Unspecified diabetes mellitus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E34', 'Other endocrine disorders  (Includes: Unspecified endocrine disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E46', 'Unspecified protein-energy malnutrition')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E63', 'Other nutritional deficiencies  (Includes: Unspecified nutritional deficiencies)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E66', 'Obesity')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E67', 'Other hyperalimentation    (Excludes: Hyperalimentation unspecified  (R63.2))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E785', 'Hyperlipidaemia, unspecified  (Includes: Hyperlipidemia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E84', 'Cystic fibrosis  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E860', 'Dehydration')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E87', 'Other disorders of fluid, electrolyte and acid-base balance (Includes: Acidosis, hyponatraemia/hyponatremia, alkalosis, hyperkalaemia/hyperkalemia, fluid overload)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E88', 'Other metabolic disorders (Includes: Unspecified metabolic disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('E89', 'Postprocedural endocrine and metabolic disorders, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F00', 'Dementia in Alzheimer''s disease (Includes:  Primary degenerative dementia of the Alzheimer''s type, presenile onset)  (Excludes: Alzheimer''s disease (see G30)).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F01', 'Vascular Dementia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F02', 'Dementia in other diseases classified elsewhere (Includes: Dementia in Picks disease (G31), dementia in Creutzfeldt-Jakob disease, dementia in Huntingtons disease (G10), dementia in Parkinsons disease (G20), Lewy body dementia (G31) etc.) (Note: Code both codes - (F02) and the neurological involvement (G31, G10 or G20, etc.))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F03', 'Unspecified dementia  (Includes: Presenile: dementia NOS,  presenile psychosis NOS, primary degenerative dementia NOS, psychosis NOS, senile dementia NOS and senile dementia depressed or paranoid type)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F04', 'Organic amnesic syndrome, not induced by alcohol and other psychoactive substances  (Includes: Korsakov''s psychosis or syndrome, nonalcoholic)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F05', 'Delirium, not induced by alcohol and other psychoactive substances  (Includes:  Acute or subacute:  brain syndrome, confusional state (nonalcoholic), infective psychosis, organic reaction, psycho-organic syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F06', 'Other mental disorders due to brain damage and dysfunction and to physical disease')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F07', 'Personality and behavioural disorders due to brain disease, damage and dysfunction (Excludes:  Postencephalitic syndrome (F07.1) and postconcussional syndrome (F07.2))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F071', 'Postencephalitic syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F072', 'Postconcussional syndrome (Includes: Cognitive impairment with head injury, post-traumatic brain syndrome, nonpsychotic postcontusional syndrome (encephalopathy))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F100', 'Mental and behavioural disorders due to use of alcohol, acute intoxication (Includes: "Bad trips" (drugs), acute drunkenness in alcoholism, drunkenness NOS, pathological intoxication, trance and possession disorders in psychoactive substance intoxication)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F101', 'Mental and behavioural disorders due to use of alcohol, harmful use (Includes:  Addiction or dependence on alcohol)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F102', 'Mental and behavioural disorders due to use of alcohol, dependence syndrome  (Includes:  Chronic alcoholism, dipsomania, drug addiction)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F105', 'Mental and behavioural disorders due to use of alcohol, psychotic disorder (Includes:  Alcoholic halucinosis, alcoholic jealousy, alcoholic paranoia, alcoholic psychosis NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F106', 'Mental and behavioural disorders due to use of alcohol, amnesic syndrome (Includes:  Amnestic disorder, alcohol-or drug-induced, Korsakov''s psychosis or syndrome, alcohol-or other psychoactive substance-induced or unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F107', 'Mental and behavioural disorders due to use of alcohol, residual and late-onset psychotic disorder (Includes: Alcoholic dementia NOS, chronic alcoholic brain syndrome, flashbacks, late-onset psychoactive substance-induced psychotic disorder, posthallucinogen perception disorder, residual affective disorder, residual disorder of personality and behaviour.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F108', 'Mental and behavioural disorders due to use of alcohol, other mental and behavioural disorders (Includes:  Alcohol withdrawal with and without delirium)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F109', 'Mental and behavioural disorders due to use of alcohol, unspecified mental and behavioural disorder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F11', 'Mental and behavioural disorders due to use of opioids (Includes disorders that are attributable to the use of opioids. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to the use of opioids.) ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F12', 'Mental and behavioural disorders due to use of cannabinoids (Includes disorders that are attributable to the use of cannabinoids. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to the use of cannabinoids.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F13', 'Mental and behavioural disorders due to use of sedatives or hypnotics (Includes disorders that are attributable to the use of sedatives or hypnotics. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to the use of sedatives or hypnotics.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F14', 'Mental and behavioural disorders due to use of cocaine (Includes disorders that are attributable to the use of cocaine. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to the use of cocaine.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F15', 'Mental and behavioural disorders due to use of other stimulants, including caffeine  (Includes disorders that are attributable to the use of other stimulants, including caffeine. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to the use of other stimulants, including caffeine).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F16', 'Mental and behavioural disorders due to use of hallucinogens  (Includes disorders that are attributable to the use of hallucinogens. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, and other and unspecified mental and behavioural disorders due to the use of hallucinogens.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F17', 'Mental and behavioural disorders due to use of tobacco   (Includes mental and behavioural disorders due to the use of tobacco. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to the use of tobacco.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F172', 'Mental and behavioural disorders due to use of tobacco, dependence syndrome   (Includes:  Drug addiction)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F18', 'Mental and behavioural disorders due to use of volatile solvents  (Includes mental and behavioural disorders due to the use of volatile solvents. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to the use of volatile solvents.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F19', 'Mental and behavioural disorders due to multiple drug use and use of other psychoactive substances  (Includes mental and behavioural disorders due to multiple drug use and use of other psychoactive substances. This includes: Acute intoxication, harmful use, dependence syndrome (drug addiction), withdrawal state with or without delirium, psychotic disorder, Amnesic syndrome, residual and late-onset psychotic disorder, other and unspecified mental and behavioural disorders due to multiple drug use and use of psychoactive substances.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F20', 'Schizophrenia ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F21', 'Schizotypal disorder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F22', 'Persistent delusional disorders (Includes:  Paranoia, paranoid Psychosis, paranoid State, paraphrenia (late), sensitive Beziehungswahn, other and unspecified persistent delusional disorders )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F23', 'Acute and transient psychotic disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F24', 'Induced delusional disorder (Includes:   Folie  deux, induced paranoid disorder, induced psychotic disorder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F25', 'Schizoaffective disorders  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F28', 'Other nonorganic psychotic disorder (Includes:  Chronic hallucinatory psychosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F29', 'Unspecified nonorganic psychosis (Includes:  Psychosis NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F30', 'Manic episode (Includes:  Hypomania, mania NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F31', 'Bipolar affective disorder (Includes:  Manic-depressive:  illness, psychosis, reaction and manic depression NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F32', 'Depressive episode (Includes:  Single episode of:  depressive reaction, psychogenic depression, reactive depression, depression NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F33', 'Recurrent depressive disorder  (Includes:  Recurrent episodes of:  depressive reaction, psychogenic depression, reactive depression,  Seasonal affective disorder, and monopolar depression NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F34', 'Persistent mood [affective] disorders  (Includes:  Cyclothymia, Dysthymia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F38', 'Other mood [affective] disorders  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F39', 'Unspecified mood [affective] disorder (Includes:  Affective psychosis NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F40', 'Phobic anxiety disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F41', 'Other anxiety disorders  (Includes: Unspecified anxiety disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F42', 'Obsessive-compulsive disorder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F430', 'Acute stress reaction (Includes:  Acute crisis reaction, acute reaction to stress, combat fatigue, crisis state, psychic shock )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F431', 'Post-traumatic stress disorder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F432', 'Adjustment disorders (Includes:  Adolescent adjustment reaction, culture shock, grief reaction)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F439', 'Reaction to severe stress, unspecified (Includes: Other reactions to severe stress NEC)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F44', 'Dissociative [conversion] disorders  (Includes:  Conversion:  hysteria, reaction, hysteria, hysterical psychosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F453', 'Somatoform autonomic dysfunction (Includes:  Cardiac neurosis, Da Costa''s syndrome, gastric neurosis, neurocirculatory asthenia, psychogenic forms of: aerophagy, cough, diarrhoea/diarrhea, dyspepsia, dysuria, flatulence, hiccough, hyperventilation, increased frequency of micturition, irritable bowel syndrome, pylorospasm)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F454', 'Persistent somatoform pain disorder (Includes:  Psychalgia, psychogenic:  backache, headache)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F459', 'Somatoform disorder, unspecified  (Includes:  Psychosomatic disorder NOS, somatization disorder, hypochondriacal disorder, other somatoform disorders, teeth grinding)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F480', 'Neurasthenia  (Includes:  Fatigue syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F489', 'Neurotic disorder, unspecified  (Includes:  Neurosis NOS, depersonalization derealization syndrome, other specified neurotic disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F50', 'Eating disorders   (Includes: Anorexia nervosa, Atypical anorexia nervosa, bulimia nervosa, bulimia NOS, hyperorexia nervosa, atypical bulimia nervosa, overeating and vomiting associated with other psychological disturbances, other and unspecified eating disorder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F60', 'Specific personality disorders  (Includes the following personality disorders: Paranoid, schizoid, dissocial, emotionally unstable, histrionic, anankastic, anxious [avoidant], dependent, and other and unspecified personality disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F61', 'Mixed and other personality disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F62', 'Enduring personality changes, not attributable to brain damage and disease')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F63', 'Habit and impulse disorders  (Includes:  Pathological gambling, fire - setting [pyromania], pathological stealing, [kleptomania], Trichotillomania)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F64', 'Gender identity disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F68', 'Other disorders of adult personality and behaviour  (Includes:  Compensation neurosis, hospital hopper syndrome, Munchhausen''s syndrome, peregrinating patient, character disorder NOS, relationship disorder NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F69', 'Unspecified disorder of adult personality and behaviour')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F70', 'Mild mental retardation  (Includes:  Feeble-mindedness, mild mental subnormality. Approximate IQ range of 50 to 69 (in adults, mental age from 9 to under 12 years).)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F71', 'Moderate mental retardation  (Includes:  Moderate mental subnormality.  Approximate IQ range of 35 to 49 (in adults, mental age from 6 to under 9 years).)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F72', 'Severe mental retardation  (Includes:  Severe mental subnormality.  Approximate IQ range of 20 to 34 (in adults, mental age from 3 to under 6 years).)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F73', 'Profound mental retardation  (Includes:  profound mental subnormality.  IQ under 20 (in adults, mental age below 3 years).)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F78', 'Other mental retardation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F79', 'Unspecified mental retardation  (Includes:  Mental:  deficiency NOS, subnormality NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F80', 'Specific developmental disorders of speech and language')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F81', 'Specific developmental disorders of scholastic skills')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F82', 'Specific developmental disorder of motor function')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F83', 'Mixed specific developmental disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F840', 'Childhood autism  (Includes:  Autistic disorder, infantile:  autism, psychosis, Kanner''s syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F842', 'Rett''s syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F845', 'Asperger''s syndrome  (Includes:  Autistic psychopathy, schizoid disorder of childhood)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F848', 'Other pervasive developmental disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F849', 'Pervasive developmental disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F88', 'Other disorders of psychological development  (Includes:  Developmental agnosia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F89', 'Unspecified disorder of psychological development  (Includes: Developmental disorder NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F90', 'Hyperkinetic disorders  (Includes:  Attention deficit disorder with hyperactivity, hyperactivity disorder, syndrome with hyperactivity)  (Excludes:  attention deficit disorder stated without hyperactivity (F98))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F91', 'Conduct disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F92', 'Mixed disorders of conduct and emotions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F93', 'Emotional disorders with onset specific to childhood')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F94', 'Disorders of social functioning with onset specific to childhood and adolescence')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F95', 'Tic disorders  (Includes:  de la Tourette)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F98', 'Other behavioural and emotional disorders with onset usually occurring in childhood and adolescence (Includes:  Attention deficit disorder without hyperactivity, expressive masturbation, nail-biting, nose-picking, thumb-sucking, Pica of infancy/childhood, stereotyped movement disorders, stuttering, cluttering)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('F99', 'Mental disorder, not otherwise specified  (Includes:  Mental Illness NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G00', 'Bacterial meningitis, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G03', 'Meningitis due to other and unspecified causes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G04', 'Encephalitis, myelitis and encephalomyelitis  (Excludes:  West Nile Virus (A92.3), MS (G35))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G060', 'Intracranial abscess and granuloma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G061', 'Intraspinal abscess and granuloma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G08', 'Intracranial and intraspinal phlebitis and thrombophlebitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G09', 'Sequelae of inflammatory diseases of central nervous system  (Includes:  Encephalitis NOS, late effects of intracranial or intraspinal abscess, and pyogenic infection)  (Excludes:  Late effects of viral encephalitis (B94.1))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G10', 'Huntington''s disease (Note: When dementia is also present code also F02 Dementia in other diseases classified elsewhere.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G110', 'Congenital nonprogressive ataxia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G111', 'Early-onset cerebellar ataxia   (Includes:  Friedreich''s ataxia, Spinocerebellar ataxia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G112', 'Late-onset cerebellar ataxia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G113', 'Cerebellar ataxia with defective DNA repair  (Includes:  Ataxia telangiectasia [Louis-Bar])')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G114', 'Hereditary spastic paraplegia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G118', 'Other hereditary ataxias')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G119', 'Hereditary ataxia, unspecified  (Includes: Hereditary cerebellar: ataxia NOS, degeneration (primary), disease, syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G120', 'Infantile spinal muscular atrophy, type I [Werdnig-Hoffman]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G121', 'Other inherited spinal muscular atrophy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G122', 'Motor neuron disease  (Includes: ALS, progressive bulbar palsy and spinal muscular atrophy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G128', 'Other spinal muscular atrophies and related syndromes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G129', 'Spinal muscular atrophy, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G20', 'Parkinson''s disease (Note: When dementia is also present code also F02 Dementia in other diseases classified elsewhere.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G21', 'Secondary parkinsonism')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G22', 'Parkinsonism in diseases classified elsewhere (Note: Code also specific infectious code. Code both codes - A52.1 Symptomatic neurosyphilis and G22.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G23', 'Other degenerative diseases of basal ganglia  (Includes: Unspecified degenerative diseases of basal ganglia, Hallervorden-Spatz disease, progressive supranuceal palsy, striatonigral degeneration, multiple system atrophy, parkinsonian type [MSA-P] and cerebellar type [MSA-C])')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G24', 'Dystonia  (Includes: Dyskinesia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G25', 'Other extrapyramidal and movement disorders  (Includes: Unspecified extrapyramidal and movement disorders)  (Excludes: Huntington''s disease (G10))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G30', 'Alzheimer''s disease   (Excludes: Dementia in Alzheimer''s disease. (See F00))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G31', 'Other degenerative diseases of nervous system, not elsewhere classified (Includes: Unspecified degenerative diseases of nervous system, Pick''s disease, frontal lobe dementia and Lewy body dementia) (Note: When dementia is also present code also F02 Dementia in other diseases classified elsewhere)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G35', 'Multiple sclerosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G36', 'Other acute disseminated demyelination  (Includes: Unspecified acute disseminated demyelination)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G37', 'Other demyelinating diseases of central nervous system (Includes: Unspecified demyelinating diseases of central nervous system) (Excludes:   Acute transverse myelitis in demyelinating disease of central nervous system (G37.3))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G373', 'Acute transverse myelitis in demyelinating disease of central nervous system')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G40', 'Epilepsy  (Includes: a previous history of seizure(s) or recurrent seizures) (Excludes: Status epilepticus (G41); First time, single isolated seizure (no history of previous seizure) see R56)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G41', 'Status epilepticus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G43', 'Migraine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G44', 'Other headache syndromes ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G459', 'Transient cerebral ischaemic attack, unspecified  (Includes: TIA; transient cerebral ischemic attack)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G470', 'Disorders of initiating and maintaining sleep [insomnias]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G471', 'Disorders of excessive somnolence [hypersomnias]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G472', 'Disorders of the sleep-wake schedule')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G4730', 'Sleep apnoea, obstructed  (Includes: Sleep apnea, obstructed)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G4731', 'Sleep apnoea, central  (Includes: Sleep apnea, central)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G4738', 'Other sleep apnoea  (Includes: Other sleep apnea)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G474', 'Narcolepsy and cataplexy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G478', 'Other sleep disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G479', 'Sleep disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G50', 'Disorders of trigeminal nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G51', 'Facial nerve disorders  (Excludes: Bell''s Palsy (G51.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G510', 'Bell''s palsy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G52', 'Disorders of other cranial nerves   (Includes:  Cranial nerve disorder unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G540', 'Brachial plexus disorders  (Includes: Thoracic outlet syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G541', 'Lumbosacral plexus disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G542', 'Cervical root disorders, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G543', 'Thoracic root disorders, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G544', 'Lumbosacral root disorders, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G545', 'Neuralgic amyotrophy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G546', 'Phantom limb syndrome with pain')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G547', 'Phantom limb syndrome without pain')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G548', 'Other nerve root and plexus disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G549', 'Nerve root and plexus disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G560', 'Carpal tunnel syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G561', 'Other lesions of median nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G562', 'Lesion of ulnar nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G563', 'Lesion of radial nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G564', 'Causalgia of upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G568', 'Other mononeuropathies of upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G569', 'Mononeuropathy of upper limb, unspecified  (Excludes: Carpal tunnel syndrome (G56.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G570', 'Lesion of sciatic nerve  (Excludes: Sciatica NOS (See M54.3))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G571', 'Meralgia paraesthetica')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G572', 'Lesion of femoral nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G573', 'Lesion of lateral popliteal nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G574', 'Lesion of medial popliteal nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G575', 'Tarsal tunnel syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G576', 'Lesion of plantar nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G577', 'Causalgia of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G578', 'Other mononeuropathies of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G579', 'Mononeuropathy of lower limb, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G58', 'Other mononeuropathies')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G600', 'Hereditary motor and sensory neuropathy (Includes: Charcot-Marie Tooth disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G61', 'Inflammatory polyneuropathy  (Excludes: Guillain-Barre syndrome (G61.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G610', 'Guillain-Barr syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G62', 'Other polyneuropathies  (Includes:  Drug-induced polyneuropathy, chronic inflammatory demyelinizing polyneuropathy, radiation-induced polyneuropathy, and neuropathy, not otherwise specified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G64', 'Other disorders of peripheral nervous system')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G700', 'Myasthenia gravis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G709', 'Myoneural disorder, unspecified  (Includes:  Other specific myoneural disorders; toxic myoneural disorders; congenital and developmental myasthenia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G71', 'Primary disorders of muscles  (Includes:  Muscular dystrophy, myotonic disorders, congenital myopathies, mitochondrial myopathies)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G72', 'Other myopathies  (Includes: Drug-induced myopathy, alcoholic myopathy, inflammatory myopathy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G73', 'Disorders of myoneural junction and muscle in diseases classified elsewhere')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G800', 'Spastic quadriplegic cerebral palsy (Includes: Congenital spastic paralysis (cerebral), and  Spastic tetraplegic cerebral palsy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G801', 'Spastic diplegic cerebral palsy  (Includes: Spastic cerebral palsy NOS )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G802', 'Spastic hemiplegic cerebral palsy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G803', 'Dyskinetic cerebral palsy  (Includes: Athetoid cerebral palsy, and dystonic cerebral palsy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G804', 'Ataxic cerebral palsy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G808', 'Other cerebral palsy  (Includes: Mixed cerebral palsy syndromes)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G809', 'Cerebral palsy, unspecified  (Includes: Cerebral palsy NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8100', 'Flaccid hemiplegia of dominant side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8101', 'Flaccid hemiplegia of non-dominant side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8109', 'Flaccid hemiplegia of unspecified [unilateral] side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8110', 'Spastic hemiplegia of dominant side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8111', 'Spastic hemiplegia of non-dominant side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8119', 'Spastic hemiplegia of unspecified [unilateral] side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8190', 'Hemiplegia of unspecified type of dominant side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8191', 'Hemiplegia of unspecified type of non-dominant side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8199', 'Hemiplegia of unspecified type of unspecified [unilateral] side  (Includes: hemiplegia, NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G820', 'Flaccid paraplegia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G821', 'Spastic paraplegia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G822', 'Paraplegia, unspecified  (Includes: Diplegia of lower limbs, Paraplegia NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82310', 'Flaccid quadriplegia, complete at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82311', 'Flaccid quadriplegia, complete at cervical spine level C5 to C7  (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82320', 'Flaccid quadriplegia, incomplete at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82321', 'Flaccid quadriplegia, incomplete at cervical spine level C5 to C7  (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82390', 'Flaccid quadriplegia, unspecified at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82391', 'Flaccid quadriplegia, unspecified at cervical spine level C5 to C7  (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82410', 'Spastic quadriplegia, complete at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82411', 'Spastic quadriplegia, complete at cervical spine level C5 to C7  (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82420', 'Spastic quadriplegia, incomplete at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82421', 'Spastic quadriplegia, incomplete at cervical spine level C5 to C7  (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82490', 'Spastic quadriplegia, unspecified at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82491', 'Spastic quadriplegia, unspecified at cervical spine level C5 to C7  (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82510', 'Quadriplegia, unspecified type, complete at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82511', 'Quadriplegia, unspecified type, complete at cervical spine level C5 to C7  (Includes: level unspecified )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82520', 'Quadriplegia, unspecified type, incomplete at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82521', 'Quadriplegia, unspecified type, incomplete at cervical spine level C5 to C7 (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82590', 'Quadriplegia, unspecified type, unspecified at cervical spine level C1 to C4')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G82591', 'Quadriplegia, unspecified type, unspecified at cervical spine level C5 to C7  (Includes: level unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G830', 'Diplegia of upper limbs  (Includes: Paralysis of both upper limbs, paresis of both upper limbs)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G831', 'Monoplegia of lower limb  (Includes: Paralysis of lower limb, paresis of lower limb)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8320', 'Monoplegia of upper limb on dominant side (Includes: Paresis of upper limb on dominant side)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8321', 'Monoplegia of upper limb on non-dominant side (Includes: Paresis of upper limb on non-dominant side)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G8322', 'Monoplegia of upper limb on unspecified [unilateral] side (Includes: Paresis of upper limb on unspecified [unilateral] side)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G834', 'Cauda equina syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G835', 'Locked-in state')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G838', 'Other specified paralytic syndromes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G839', 'Paralytic syndrome, unspecified (Includes:  Paresis, unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G900', 'Idiopathic peripheral autonomic neuropathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G904', 'Autonomic dysreflexia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G909', 'Disorder of autonomic nervous system, unspecified  (Includes: Other disorders of autonomic nervous system; familial dysautonomia [Riley-Day], Horner''s syndrome) ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G91', 'Hydrocephalus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G92', 'Toxic encephalopathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G931', 'Anoxic brain damage, not elsewhere classified ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G933', 'Postviral fatigue syndrome (Includes:  Benign myalgic encephalopathy and chronic fatigue syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G934', 'Encephalopathy, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G9388', 'Other specified disorders of brain  (Includes: Unspecified disorders of brain) (Excludes:  Anoxic brain damage (G93.1),  Postviral fatigue syndrome (G93.3), and  Encephalopathy, unspecified (G93.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G950', 'Syringomyelia and syringobulbia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G951', 'Vascular myelopathies  (Includes:  Acute infarction of spinal cord)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G952', 'Cord compression, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G958', 'Other specified diseases of spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G959', 'Disease of spinal cord, unspecified  (Includes:  Myelopathy, not otherwise specified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G96', 'Other disorders of central nervous system  (Includes: Unspecified disorders of central nervous system, cerebrospinal fluid leak, CSF leak)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G971', 'Other reaction to spinal and lumbar puncture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G972', 'Intracranial hypotension following ventricular shunting')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G978', 'Other postprocedural disorders of nervous system')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('G979', 'Postprocedural disorder of nervous system, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H10', 'Conjunctivitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H25', 'Senile cataract')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H26', 'Other Cataract')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H33', 'Retinal detachments and breaks')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H35', 'Other retinal disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H40', 'Glaucoma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H46', 'Optic neuritis  (Includes:  Optic:  neuropathy, except ischaemic, papillitis, Retrobulbar neuritis NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H47', 'Other disorders of optic [2nd] nerve and visual pathways  (Includes: Unspecified disorders of optic [2nd] nerve and visual pathways)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H49', 'Paralytic strabismus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H50', 'Other strabismus  (Includes: Unspecified strabismus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H53', 'Visual Disturbance   (Excludes: Diplopia (H53.2))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H532', 'Diplopia (Double Vision)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H540', 'Blindness, binocular')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H541', 'Severe visual impairment, binocular')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H542', 'Moderate visual impairment, binocular')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H543', 'Mild or no visual impairment, binocular')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H544', 'Blindness, monocular')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H545', 'Severe visual impairment, monocular')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H546', 'Moderate visual impairment, monocular')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H549', 'Unspecified visual impairment (binocular)  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H55', 'Nystagmus and other irregular eye movements  (Includes:  Nystagmus:  NOS, congenital, deprivation, dissociated, latent)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H57', 'Other disorders of eye and adnexa  (Includes: Unspecified disorders of eye and adnexa)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H59', 'Postprocedural disorders of eye and adnexa, not elsewhere classified (Includes: keratopathy following cataract surgery)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H60', 'Otitis externa')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H61', 'Other disorders of external ear  (Includes:  Wax in ear) ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H65', 'Nonsuppurative otitis media  (Includes:  With myringitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H66', 'Suppurative and unspecified otitis media  (Includes:  With myringitis, otitis media not elsewhere classified  )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H72', 'Perforation of tympanic membrane  (Includes:  Perforation of ear drum:  persistent post-traumatic, postinflammatory)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H74', 'Other disorders of middle ear and mastoid  (Includes:  Unspecified disorders of middle ear and mastoid)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H80', 'Otosclerosis  (Includes:  otospongiosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H810', 'Mnire''s disease  (Includes:  Labyrinthine hydrops, Mnire''s syndrome or vertigo)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H811', 'Benign paroxysmal vertigo')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H812', 'Vestibular neuronitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H813', 'Other peripheral vertigo  (Includes:  Lermoyez'' syndrome, vertigo aural, vertigo otogenic, vertigo peripheral NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H814', 'Vertigo of central origin  (Includes:  Central positional nystagmus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H818', 'Other disorders of vestibular function')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H819', 'Disorder of vestibular function, unspecified  (Includes:  Vertiginous syndrome NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H83', 'Other diseases of inner ear (Includes:  Labyrinthitis, noise-induced hearing loss)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H900', 'Conductive hearing loss, bilateral')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H901', 'Conductive hearing loss, unilateral with unrestricted hearing on the contralateral side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H902', 'Conductive hearing loss, unspecified  (Includes:  Conductive deafness NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H903', 'Sensorineural hearing loss, bilateral')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H904', 'Sensorineural hearing loss, unilateral with unrestricted hearing on the contralateral side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H905', 'Sensorineural hearing loss, unspecified  (Includes:  Congenital deafness NOS, Hearing loss: central NOS, neural NOS, perceptive NOS, sensory NOS, Sensorineural deafness NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H906', 'Mixed conductive and sensorineural hearing loss, bilateral')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H907', 'Mixed conductive and sensorineural hearing loss, unilateral with unrestricted hearing on the contralateral side')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H908', 'Mixed conductive and sensorineural hearing loss, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H91', 'Other hearing loss  (Includes: Unspecified hearing loss)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H93', 'Other disorders of ear, not elsewhere classified (Includes:  Tinnitus and disorders of acoustic nerve, unspecified disorders of ear)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('H95', 'Postprocedural disorders of ear and mastoid process, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I00', 'Rheumatic fever without mention of heart involvement  (Includes:  Arthritis, rheumatic, acute or subacute)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I01', 'Rheumatic fever with heart involvement')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I02', 'Rheumatic chorea  (Includes:  Sydenham''s chorea)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I05', 'Rheumatic mitral valve diseases  (Includes: Mitral stenosis, rheumatic mitral insufficiency, mitral (valve) failure)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I06', 'Rheumatic aortic valve diseases  (Includes: Rheumatic aortic stenosis) (Excludes:  Nonrheumatic aortic (valve)stenosis (See I35.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I07', 'Rheumatic tricuspid valve diseases  (Includes:  Whether specified as rheumatic or of unspecified origin)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I08', 'Multiple valve diseases')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I09', 'Other rheumatic heart diseases  (Includes: Unspecified rheumatic heart diseases)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I10', 'Essential (primary) hypertension ( Includes:  Hypertension NOS, High blood pressure)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I11', 'Hypertensive heart disease  (Includes:  Hypertensive heart disease NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I12', 'Hypertensive renal disease    (Includes:  Arteriosclerosis of kidney, Arteriosclerotic nephritis (chronic) (interstitial), Hypertensive nephropathy, Hypertensive renal disease NOS, Nephrosclerosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I13', 'Hypertensive heart and renal disease')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I15', 'Secondary hypertension (Includes:  Hypertension secondary to renal disorders and hypertension secondary to endocrine disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I20', 'Angina pectoris  (Includes: Stable angina,  Unstable angina)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I21', 'Acute myocardial infarction  (Includes: Myocardial infarction specified as acute or with a stated duration of 4 weeks (28 days) or less from onset)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I22', 'Subsequent myocardial infarction  (Includes:  Further extension of myocardial infarction, recurrent myocardial infarction) (Note: Code is assigned for infarction of any myocardial site occurring within 4 weeks (28 days) from the onset of a previous infarction.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I23', 'Certain current complications following acute myocardial infarction')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I24', 'Other acute ischaemic heart diseases    (Excludes:  angina pectoris (I20)) (Includes: Unspecified acute ischaemic/ischemic heart diseases, coronary thrombosis not resulting in myocardial infarction, Dressler''s syndrome, acute coronary syndrome (ACS))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I250', 'Atherosclerotic cardiovascular disease, so described')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I251', 'Atherosclerotic heart disease  (Includes:  Coronary (artery):  atheroma, atherosclerosis, disease, sclerosis, CAD)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I252', 'Old myocardial infarction  (Includes:  Healed myocardial infarction, past myocardial infarction by ECG or other special investigation, but currently presenting no symptoms)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I253', 'Aneurysm of heart  (Includes:  Aneurysm mural, Aneurysm ventricular)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I254', 'Coronary artery aneurysm  (Includes:  Coronary arteriovenous fistula, acquired)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I255', 'Ischaemic cardiomyopathy  (Includes: Ischemic cardiomyopathy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I256', 'Silent myocardial ischaemia  (Includes: Silent myocardial ischemia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I258', 'Other forms of chronic ischaemic heart disease  (Includes:  Any condition in (I21-I22) and (I24) specified as chronic or with a stated duration of more than 4 weeks (more than 28 days) from onset.  [Old MI])')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I259', 'Chronic ischaemic heart disease, unspecified  (Includes:  Ischaemic/Ischemic heart disease (chronic) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I260', 'Pulmonary embolism with mention of acute cor pulmonale (Includes:  Acute cor pulmonale NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I269', 'Pulmonary embolism without mention of acute cor pulmonale  (Includes:  Pulmonary embolism NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I270', 'Primary pulmonary hypertension')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I271', 'Kyphoscoliotic heart disease')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I272', 'Other secondary pulmonary hypertension')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I278', 'Other specified pulmonary heart diseases')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I279', 'Pulmonary heart disease, unspecified  (Includes:  Chronic cardiopulmonary disease, Cor pulmonale (chronic) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I28', 'Other diseases of pulmonary vessels  (Includes:  Arteriovenous fistula of pulmonary vessels, Aneurysm of pulmonary artery, Other (Rupture of pulmonary vessel, stenosis of pulmonary vessel, stricture of pulmonary vessel) and uspecified diseases of pulmonary vessels)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I30', 'Acute pericarditis  (Includes: Infective pericarditis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I31', 'Other diseases of pericardium (Includes:  Cardiac tamponade, unspecified diseases of pericardium, pericarditis (chronic) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I33', 'Acute and subacute endocarditis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I340', 'Mitral (valve) insufficiency (Includes:  Mitral (valve):  Incompetence NOS or of specified cause, except rheumatic, regurgitation NOS or of specified cause, except rheumatic)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I341', 'Mitral (valve) prolapse (Includes:  Floppy mitral valve syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I342', 'Nonrheumatic mitral (valve) stenosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I348', 'Other nonrheumatic mitral valve disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I349', 'Nonrheumatic mitral valve disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I350', 'Aortic (valve) stenosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I351', 'Aortic (valve) insufficiency  (Includes:  Aortic (valve):  Incompetence NOS or of specified cause, except rheumatic, regurgitation NOS or of specified cause, except rheumatic)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I352', 'Aortic (valve) stenosis with insufficiency')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I358', 'Other aortic valve disorders  (Includes: Aneurysm of aortic valve, murmur of aortic (valve))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I359', 'Aortic valve disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I361', 'Nonrheumatic tricuspid (valve) insufficiency  (Includes:  Tricuspid (valve) incompetence of specified cause, except rheumatic, regurgitation of specified cause, except rheumatic)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I369', 'Nonrheumatic tricuspid valve disorder, unspecified   (Includes: Other nonrheumatic tricuspid valve disorders, Nonrheumatic tricuspid (valve) stenosis with or without insufficiency)  (Excludes: Specified as rheumatic (See I07)).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I37', 'Pulmonary valve disorders  (Includes: Stenosis with or without insufficiency, incompetence NOS or specified cause, except rheumatic, regurgitation NOS or of specified cause, except rheumatic, other and unspecified pulmonary valve disorders)  (Excludes: Rheumatic pulmonary valve disorder (See I09))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I38', 'Endocarditis, valve unspecified  (Includes: Endocarditis (chronic) NOS, Valvular incompetence, insufficiency, regurgitation and stenosis of unspecified valve, NOS. Valvulitis (chronic) of specified or unspecified valve, NOS) (Excludes: When endocarditis of unspecified valve is specified as congenital or endocardial fibroelastosis (I42) or specified as rheumatic (I09))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I40', 'Acute myocarditis   (Includes: Infective myocarditis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I42', 'Cardiomyopathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I44', 'Atrioventricular and left bundle-branch block (Includes:  Complete heart block)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I45', 'Other conduction disorders  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I460', 'Cardiac arrest with successful resuscitation  (Excludes:  With conduction disorder code (I44 - I45), or myocardial infarction code (I21 - I22))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I461', 'Sudden cardiac death, so described')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I469', 'Cardiac arrest, unspecified  (Excludes: Cardiorespiratory failure (See R09.2))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I470', 'Re-entry ventricular arrhythmia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I471', 'Supraventricular tachycardia  (Includes:  Paroxysmal tachycardia:  atrial, atrioventricular [AV], junctional, nodal)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I472', 'Ventricular tachycardia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I479', 'Paroxysmal tachycardia, unspecified  (Includes:  Bouveret(-Hoffman) syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I480', 'Atrial fibrillation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I4891', 'Atrial flutter, unspecified  (Includes:  Typical atrial flutter, atypical atrial flutter)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I4900', 'Ventricular fibrillation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I4901', 'Ventricular flutter')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I491', 'Atrial premature depolarization  (Includes:  Atrial premature beats)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I492', 'Junctional premature depolarization')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I493', 'Ventricular premature depolarization')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I494', 'Other and unspecified premature depolarization  (Includes:  Ectopic beats, extrasystoles, extrasystolic arrhythmias, premature beats NOS, premature contractions)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I495', 'Sick sinus syndrome  (Includes:  Tachycardia-bradycardia syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I498', 'Other specified cardiac arrhythmias  (Includes:  Long QT syndrome, and rhythm disorders:  Coronary sinus, ectopic, nodal)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I499', 'Cardiac arrhythmia, unspecified  (Includes:  Arrhythmia (cardiac) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I500', 'Congestive heart failure  (Includes: Right ventricular failure)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I501', 'Left ventricular failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I509', 'Heart failure, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I510', 'Cardiac septal defect, acquired  (Includes:  Acquired septal defect (old):  atrial, auricular, ventricular)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I511', 'Rupture of chordae tendineae, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I512', 'Rupture of papillary muscle, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I513', 'Intracardiac thrombosis, not elsewhere classified  (Includes:  Thrombosis (old):  apical, atrial, auricular, ventricular)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I514', 'Myocarditis, unspecified  (Includes:  Myocardial fibrosis, myocarditis:   NOS, chronic (interstitial))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I515', 'Myocardial degeneration  (Includes:  Degeneration of heart or myocardium:  fatty, senile, myocardial disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I516', 'Cardiovascular disease, unspecified  (Includes:  Cardiovascular accident NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I517', 'Cardiomegaly  (Includes:  Cardiac:  dilatation, hypertrophy, ventricular dilatation)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I518', 'Other ill-defined heart diseases  (Includes:  Carditis (acute) (chronic), Pancarditis (acute) (chronic))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I519', 'Heart disease, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I60', 'Subarachnoid haemorrhage  (Includes:  Rupture of cerebral arteriovenous malformation, subarachnoid hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I61', 'Intracerebral haemorrhage  (Excludes:  Sequelae of intracerebral haemorrhage/hemorrhage (I69.1))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I620', 'Subdural haemorrhage (acute)(nontraumatic) (Includes: Subdural hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I621', 'Nontraumatic extradural haemorrhage  (Includes:  Nontraumatic epidural haemorrhage/hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I629', 'Intracranial haemorrhage (nontraumatic), unspecified  (Includes: Intracranial hemorrhage (nontraumatic), unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I630', 'Cerebral infarction due to thrombosis of precerebral arteries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I631', 'Cerebral infarction due to embolism of precerebral arteries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I632', 'Cerebral infarction due to unspecified occlusion or stenosis of precerebral arteries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I633', 'Cerebral infarction due to thrombosis of cerebral arteries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I634', 'Cerebral infarction due to embolism of cerebral arteries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I635', 'Cerebral infarction due to unspecified occlusion or stenosis of cerebral arteries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I636', 'Cerebral infarction due to cerebral venous thrombosis, nonpyogenic')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I638', 'Other cerebral infarction')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I639', 'Cerebral infarction, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I64', 'Stroke, not specified as haemorrhage or infarction  (Includes:  Cerebrovascular accident (CVA) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I65', 'Occlusion and stenosis of precerebral arteries, not resulting in cerebral infarction  (Includes:  Embolism, narrowing obstruction (complete)(partial), thrombosis of basilar, carotid or vertebral arteries, not resulting in cerebral infarction)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I66', 'Occlusion and stenosis of cerebral arteries, not resulting in cerebral infarction  (Includes:  Embolism, narrowing, obstruction (complete) (partial), thrombosis of middle, anterior and posterior cerebral arteries, and cerebellar arteries, not resulting in cerebral infarction)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I670', 'Dissection of cerebral arteries, nonruptured')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I671', 'Cerebral aneurysm, nonruptured  (Includes:  Cerebral:  aneurysm NOS, arteriovenous fistula, acquired)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I672', 'Cerebral atherosclerosis  (Includes:  Atheroma of cerebral arteries)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I673', 'Progressive vascular leukoencephalopathy ( Includes:  Binswanger''s disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I674', 'Hypertensive encephalopathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I675', 'Moyamoya disease')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I676', 'Nonpyogenic thrombosis of intracranial venous system  (Includes:  Nonpyogenic thrombosis of:  cerebral vein, intracranial venous sinus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I677', 'Cerebral arteritis, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I678', 'Other specified cerebrovascular diseases  (Includes:  Acute cerebrovascular insufficiency NOS, cerebral ischaemia (chronic))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I679', 'Cerebrovascular disease, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I690', 'Sequelae of subarachnoid haemorrhage  (Code if present one year or more after onset of the causal condition.) (Includes: Sequelae of subarachnoid hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I691', 'Sequelae of intracerebral haemorrhage   (Code if present one year or more after onset of the causal condition.) (Includes: Sequelae of intracerebral hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I692', 'Sequelae of other nontraumatic intracranial haemorrhage   (Code if present one year or more after onset of the causal condition.) (Includes: Sequelae of other nontraumatic intracranial hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I693', 'Sequelae of cerebral infarction   (Code if present one year or more after onset of the causal condition.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I694', 'Sequelae of stroke, not specified as haemorrhage or infarction   (Code if present one year or more after onset of the causal condition.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I70', 'Atherosclerosis  (Includes: Arteriosclerosis, peripheral vascular disease of extremities) (Excludes: peripheral vascular disease, NOS (See I73.9))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I710', 'Dissection of aorta [any part]    (Includes:  Dissecting aneurysm of aorta (ruptured) [any part])')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I711', 'Thoracic aortic aneurysm, ruptured')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I712', 'Thoracic aortic aneurysm, without mention of rupture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I713', 'Abdominal aortic aneurysm, ruptured')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I714', 'Abdominal aortic aneurysm, without mention of rupture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I715', 'Thoracoabdominal aortic aneurysm, ruptured')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I716', 'Thoracoabdominal aortic aneurysm, without mention of rupture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I718', 'Aortic aneurysm of unspecified site, ruptured  (Includes:  Rupture of aorta NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I719', 'Aortic aneurysm of unspecified site, without mention of rupture (Includes:  Aneurysm of aorta, dilatation of aorta, hyaline necrosis of aorta)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I72', 'Other aneurysm and dissection  (Includes:  Aneurysm (cirsoid) (false)(ruptured))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I730', 'Raynaud''s syndrome  (Includes:  Raynaud''s disease, Raynaud''s gangrene, Raynaud''s phenomenon (secondary))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I738', 'Other specified peripheral vascular diseases  (Includes:  Acrocyanosis, acroparaesthesia: simple [Schultze''s type], or vasomotor [Nothnagel''s type], erythrocyanosis, erythromelalgia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I739', 'Peripheral vascular disease, unspecified  (Includes:  Intermittent claudication, Spasm of artery) (Excludes: Atherosclerosis, arteriosclerosis, peripheral vascular disease of extremities (See I70))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I74', 'Arterial embolism and thrombosis  (Includes:  Infarction:  embolic, thrombotic, Occlusion:  embolic, thrombotic)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I77', 'Other disorders of arteries and arterioles    (Includes: Unspecified disorders of arteries and arterioles)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I80', 'Phlebitis and thrombophlebitis  (Includes:  endophlebitis, inflammation, vein, periphlebitis, suppurative phlebitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I81', 'Portal vein thrombosis  (Includes:  Portal (vein) obstruction)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I82', 'Other venous embolism and thrombosis  (Includes: Embolism and thrombosis of other and unspecified vein, Budd-Chiari Syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I86', 'Varicose veins of other sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I87', 'Other disorders of veins (Includes: Venous insufficiency (chronic) (peripheral), unspecified disorders of veins)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I88', 'Nonspecific lymphadenitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I89', 'Other noninfective disorders of lymphatic vessels and lymph nodes (Includes: Lymphoedema, not elsewhere classified,  disease of lymphatic vessels NOS, Lymphangitis (NOS, chronic, subacute))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I950', 'Idiopathic hypotension')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I952', 'Hypotension due to drugs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I958', 'Other hypotension  (Includes:  Chronic hypotension)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I959', 'Hypotension, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I970', 'Postcardiotomy syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I971', 'Other functional disturbances following cardiac surgery  (Includes:  Cardiac insufficiency following cardiac surgery or due to presence of cardiac prosthesis, Heart failure cardiac insufficiency following cardiac surgery or due to presence of cardiac prosthesis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I972', 'Postmastectomy lymphoedema syndrome  (Includes:  Elephantiasis due to mastectomy, obliteration of lymphatic vessels due to mastectomy, Postmastectomy lymphedema syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I978', 'Other postprocedural disorders of circulatory system, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I979', 'Postprocedural disorder of circulatory system, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('I99', 'Other and unspecified disorders of circulatory system')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J00', 'Acute nasopharyngitis [common cold]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J01', 'Acute sinusitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J02', 'Acute pharyngitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J03', 'Acute tonsillitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J04', 'Acute laryngitis and tracheitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J05', 'Acute obstructive laryngitis [croup] and epiglottitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J06', 'Acute upper respiratory infections of multiple and unspecified sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J09', 'Influenza due to identified zoonotic or pandemic influenza virus (Note: For use of this category, reference should be made to the guidelines of the Global Influenza Programme (GIP,http://www.who.int/influenza/) of WHO and access the Disease Outbreak News.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J10', 'Influenza due to identified seasonal influenza virus ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J11', 'Influenza, virus not identified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J120', 'Adenoviral pneumonia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J121', 'Respiratory syncytial virus pneumonia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J122', 'Parainfluenza virus pneumonia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J123', 'Human metapneumovirus pneumonia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J128', 'Other viral pneumonia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J129', 'Viral pneumonia, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J13', 'Pneumonia due to Streptococcus pneumoniae')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J14', 'Pneumonia due to Haemophilus influenzae')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J16', 'Pneumonia due to other infectious organisms, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J18', 'Pneumonia, organism unspecified (Excludes: Aspiration pneumonia (see J69))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J20', 'Acute bronchitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J21', 'Acute bronchiolitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J38', 'Diseases of vocal cords and larynx, not elsewhere classified (Includes: Paralysis of vocal cords and larynx, nodules of vocal cords, edema of larynx, abscess of vocal cords)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J39', 'Other diseases of upper respiratory tract  (Includes: Unspecified diseases of upper respiratory tract)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J40', 'Bronchitis, not specified as acute or chronic')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J41', 'Simple and mucopurulent chronic bronchitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J42', 'Unspecified chronic bronchitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J43', 'Emphysema')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J440', 'Chronic obstructive pulmonary disease with acute lower respiratory infection')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J441', 'Chronic obstructive pulmonary disease with acute exacerbation, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J448', 'Other specified chronic obstructive pulmonary disease')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J449', 'Chronic obstructive pulmonary disease, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J45', 'Asthma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J47', 'Bronchiectasis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J61', 'Pneumoconiosis due to asbestos and other mineral fibres')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J62', 'Pneumoconiosis due to dust containing silica')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J63', 'Pneumoconiosis due to other inorganic dusts')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J64', 'Unspecified pneumoconiosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J65', 'Pneumoconiosis associated with tuberculosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J66', 'Airway disease due to specific organic dust')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J67', 'Hypersensitivity pneumonitis due to organic dust')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J68', 'Respiratory conditions due to inhalation of chemicals, gases, fumes and vapours')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J69', 'Pneumonitis due to solids and liquids (Includes: Aspiration pneumonia) ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J70', 'Respiratory conditions due to other external agents  (Includes: Respiratory conditions due to unspecified external agents)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J81', 'Pulmonary oedema  (Includes: Pulmonary edema)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J82', 'Pulmonary eosinophilia, not elsewhere classified (Includes:  Eosinophilic asthma, Loffler''s pneumonia, Tropical (pulmonary) eosinophilia, pulmonary eosinophilia NOS.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J841', 'Other interstitial pulmonary diseases with fibrosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J848', 'Other specified interstitial pulmonary diseases')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J849', 'Interstitial pulmonary disease, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J850', 'Gangrene and necrosis of lung')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J851', 'Abscess of lung with pneumonia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J852', 'Abscess of lung without pneumonia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J853', 'Abscess of mediastinum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J90', 'Pleural effusion, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J93', 'Pneumothorax')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J94', 'Other pleural conditions  (Includes: Unspecified pleural conditions, hemothorax, hemopneumothorax)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9500 ', 'Haemorrhage from tracheostomy stoma  (Includes: Hemorrhage from tracheostomy stoma)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9501 ', 'Infection of tracheostomy stoma  (Includes:  Sepsis of tracheostomy stoma)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9502 ', 'Malfunction of tracheostomy stoma  (Includes:  Obstruction of tracheostomy airway)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9503 ', 'Tracheo-esophageal fistula following tracheostomy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9508 ', 'Other tracheostomy complication')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J951', 'Acute pulmonary insufficiency following thoracic surgery')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J952', 'Acute pulmonary insufficiency following nonthoracic surgery')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J953', 'Chronic pulmonary insufficiency following surgery')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J954', 'Mendelson''s syndrome  (Includes:  Chemical pneumonitis due to anaesthesia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J955', 'Postprocedural subglottic stenosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9580 ', 'Postprocedural pneumothorax')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9581', 'Transfusion related acute lung injury (TRALI)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9588 ', 'Other postprocedural respiratory disorders (Includes:  Ventilator-associated pneumonia (VAP))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J959', 'Postprocedural respiratory disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J960', 'Acute respiratory failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J961', 'Chronic respiratory failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J969', 'Respiratory failure, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J980', 'Diseases of bronchus, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9810', 'Atelectasis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J9818', 'Other pulmonary collapse   (Includes:  Collapse of lung)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J982', 'Interstitial emphysema')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J983', 'Compensatory emphysema')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J984', 'Other disorders of lung')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J985', 'Diseases of mediastinum, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J986', 'Disorders of diaphragm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J988', 'Other specified respiratory disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('J989', 'Respiratory disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K076', 'Temporomandibular joint (TMJ) disorders')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K08', 'Other disorders of teeth and supporting structures  (Includes: Unspecified disorders of teeth and supporting structures)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K21', 'Gastro-oesophageal reflux disease  (Includes: GERD, Gastro-esophageal reflux disease, reflux esophagitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K25', 'Gastric ulcer')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K26', 'Duodenal ulcer')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K27', 'Peptic ulcer, site unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K28', 'Gastrojejunal ulcer')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K29', 'Gastritis and duodenitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K30', 'Dyspepsia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K31', 'Other diseases of stomach and duodenum  (Includes:  Unspecified diseases of stomach and duodenum)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K35', 'Acute appendicitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K40', 'Inguinal hernia  (Includes:  Scrotal hernia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K41', 'Femoral hernia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K42', 'Umbilical hernia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K43', 'Ventral hernia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K44', 'Diaphragmatic hernia  (Includes:  Hiatus hernia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K45', 'Other abdominal hernia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K46', 'Unspecified abdominal hernia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K50', 'Crohn''s disease [regional enteritis]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K51', 'Ulcerative colitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K52', 'Other noninfective gastroenteritis and colitis   (Includes:  Unspecified noninfective gastroenteritis and colitis). (Excludes: infectious or unspecified origin (A09))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K56', 'Paralytic ileus and intestinal obstruction without hernia  (Includes:  Intussusception, volvulus, paralysis of intestine)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K57', 'Diverticular disease of intestine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K58', 'Irritable bowel syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K590', 'Constipation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K63', 'Other diseases of intestine  (Includes: Unspecified diseases of intestine, Abscess/perforation/fistula/ulcer of intestine, polyp of colon)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K64', 'Haemorrhoids and perianal venous thrombosis  (Includes:  Hemorrhoids and perianal venous thrombosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K65', 'Peritonitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K66', 'Other disorders of peritoneum   (Includes: Peritoneal adhesions, unspecified disorders of peritoneum)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K70', 'Alcoholic liver disease (Includes: Alcoholic hepatitis, alcoholic cirrhosis of liver, alcoholic hepatic failure)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K71', 'Toxic liver disease')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K72', 'Hepatic failure, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K73', 'Chronic hepatitis, not elsewhere classified  (Excludes:  Alcoholic (chronic) hepatitis (See K70))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K74', 'Fibrosis and cirrhosis of liver  (Excludes: Alcoholic cirrhosis of liver (See K70))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K75', 'Other inflammatory liver diseases  (Includes:  Unspecified inflammatory liver diseases, abscess of liver)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K76', 'Other diseases of liver   (Includes:  Unspecified diseases of liver, portal hypertension)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K80', 'Cholelithiasis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K81', 'Cholecystitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K82', 'Other diseases of gallbladder  (Includes: Unspecified diseases of gallbladder, cholesterolosis of gallbladder, obstruction of gallbladder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K83', 'Other diseases of biliary tract  (Includes: Unspecified diseases of biliary tract, cholangitis, obstruction of bile duct without calculus (With calculus see K80))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K85', 'Acute pancreatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K86', 'Other diseases of pancreas  (Includes: Unspecified diseases of pancreas, chronic pancreatitis, alcohol-induced chronic pancreatitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K90', 'Intestinal malabsorption  (Includes: Celiac disease, Whipple''s disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K910', 'Vomiting following gastrointestinal surgery')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K911', 'Postgastric surgery syndromes  (Includes:  Syndrome: dumping, postgastrectomy, postvagotomy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K912', 'Postsurgical malabsorption, not elsewhere classified  (Includes:  Postsurgical blind loop syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K913', 'Postoperative intestinal obstruction  (Includes:  postoperative ileus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K9142 ', 'Malfunction of colostomy stoma, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K9145 ', 'Enterostomy malfunction, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K915', 'Postcholecystectomy syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K9162', 'Gastrostomy malfunction, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K918', 'Other postprocedural disorders of digestive system, not elsewhere  (Includes: Afferent loop syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K919', 'Postprocedural disorder of digestive system, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('K92', 'Other diseases of digestive system  (Includes: Unspecified diseases of digestive system, GI haemorrhage/hemorrhage unspecified, melaena/melena, haematemesis/hematemesis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L01', 'Impetigo')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L020', 'Cutaneous abscess, furuncle and carbuncle of face')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L021', 'Cutaneous abscess, furuncle and carbuncle of neck')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L022', 'Cutaneous abscess, furuncle and carbuncle of trunk')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L023', 'Cutaneous abscess, furuncle and carbuncle of buttock')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L024', 'Cutaneous abscess, furuncle and carbuncle of limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L028', 'Cutaneous abscess, furuncle and carbuncle of other sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L029', 'Cutaneous abscess, furuncle and carbuncle, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0300', 'Cellulitis of finger')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0301', 'Cellulitis of toe')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0310', 'Cellulitis of upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0311', 'Cellulitis of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L032', 'Cellulitis of face')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0330', 'Cellulitis of chest wall')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0331', 'Cellulitis of abdominal wall')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0332', 'Cellulitis of umbilicus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0333', 'Cellulitis of groin')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0334', 'Cellulitis of back [any part except buttock]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0335', 'Cellulitis of buttock')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0336', 'Cellulitis of perineum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L0339', 'Cellulitis of trunk, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L038', 'Cellulitis of other sites (Includes: Head [any part, except face], Scalp)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L039', 'Cellulitis, unspecified  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L04', 'Acute lymphadenitis  (Includes: abscess (acute) of any lymph node, except mesenteric (See I88))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L05', 'Pilonidal cyst')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L08', 'Other local infections of skin and subcutaneous tissue  (Includes: Unspecified local infections of skin and subcutaneous tissue, pyoderma)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L13', 'Other bullous disorders (Includes: Dermatitis herpetiformis, Duhring''s disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L20', 'Atopic dermatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L21', 'Seborrhoeic dermatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L23', 'Allergic contact dermatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L24', 'Irritant contact dermatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L25', 'Unspecified contact dermatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L26', 'Exfoliative dermatitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L27', 'Dermatitis due to substances taken internally')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L28', 'Lichen simplex chronicus and prurigo')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L29', 'Pruritus  (Includes:  Itch NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L30', 'Other dermatitis (Includes:  Eczema NOS, unspecified dermatitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L40', 'Psoriasis   (Excludes:  Arthropathic psoriasis (L40.5))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L405', 'Arthropathic psoriasis (Note:  Code also the appropriate M code (M07.0, M07.1, M07.2, M07.3, M09.0) when applicable.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L44', 'Other  papulosquamous disorders  (Includes:  Unspecified papulosquamous disorder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L50', 'Urticaria')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L51', 'Erythema multiforme')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L52', 'Erythema nodosum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L53', 'Other erythematous conditions  (Includes:  Unspecified erythematous conditions)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L56', 'Other acute skin changes due to ultraviolet radiation  (Includes:  Unspecified acute skin changes due to ultraviolet radiation)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L59', 'Other disorders of skin and subcutaneous tissue related to radiation  (Includes:  Unspecified disorders of skin and subcutaneous tissue related to radiation)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L60', 'Nail disorders  (Includes:  Ingrown nail)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L81', 'Other disorders of pigmentation  (Includes:  Unspecified disorders of pigmentation)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L84', 'Corns and callosities  (Includes:  Callus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L890', 'Stage I decubitus [pressure] ulcer and pressure area  (Note: The ulcer appears as a defined area of persistent redness (erythema) in lightly pigmented skin, whereas in darker skin tones, the ulcer may appear with persistent red, blue or purple hues, without skin loss.)  (Includes:  Decubitus [pressure] ulcer limited to erythema [redness] only, without skin breakdown)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L891', 'Stage II decubitus [pressure] ulcer (Includes:  Decubitus [pressure] ulcer with: abrasion, blister, partial thickness skin loss involving epidermis and/or dermis, skin loss NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L892', 'Stage III decubitus [pressure] ulcer  (Note: Decubitus [pressure] ulcer with full thickness skin loss involving damage or necrosis of subcutaneous tissue extending to, but not through, underlying fascia.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L893', 'Stage IV decubitus [pressure] ulcer (Note: Decubitus [pressure] ulcer with necrosis of muscle, bone or supporting structures (i.e. tendon or joint capsule).)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L898', 'Decubitus [pressure] ulcer, unstageable  (Note: Decubitus [pressure] ulcer with full thickness tissue loss in which the base of the ulcer is covered by slough/eschar and therefore, cannot be accurately staged.  Decubitus ulcer with necrosis involving muscle or bone (Stage X))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L899', 'Decubitus ulcer and pressure area, unspecified  (Includes:  Decubitus [pressure] ulcer without mention of stage or severity)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L905', 'Scar conditions and fibrosis of skin (Includes: Adherent scar, cicatrix, scar NOS)  (Excludes:  Keloid scar  (L91))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L91', 'Hypertrophic disorders of skin (Includes:  Keloid scar)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L92', 'Granulomatous disorders of skin and subcutaneous tissue')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L93', 'Lupus erythematosus (Excludes:  Systemic lupus erythematosus (M32) and scleroderma (M34))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L94', 'Other localized connective tissue disorders  (Includes: Unspecified localized connective tissue disorder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L95', 'Vasculitis limited to skin, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L97', 'Ulcer of lower limb, not elsewhere classified   (Includes:  Chronic skin ulcer of leg and foot)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('L98', 'Other disorders of skin and subcutaneous tissue, not elsewhere classified  (Includes: Unspecified disorders of skin and subcutaneous tissue, chronic ulcer NEC, ulcer of skin NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M000', 'Staphylococcal arthritis and polyarthritis  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M008', 'Arthritis and polyarthritis due to other specified bacterial agents  (Includes: Pneumococcal arthritis and polyarthritis, other streptococcal arthritis and polyarthritis).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M009', 'Pyogenic arthritis, unspecified  (Includes:  Infective arthritis NOS  )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M011', 'Tuberculous arthritis  (Note: Code also tuberculosis of bones and joints (A18.0) when applicable.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M018', 'Arthritis in other infectious and parasitic diseases classified elsewhere  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M02', 'Reactive arthropathies   (Includes:  Reiter''s disease, other and unspecified reactive arthropathies).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M05', 'Seropositive rheumatoid arthritis ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M06', 'Other rheumatoid arthritis  (Includes:  Adult-onset Still''s disease, rheumatoid arthritis unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M070', 'Distal interphalangeal psoriatic arthropathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M071', 'Arthritis mutilans')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M072', 'Psoriatic spondylitis ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M073', 'Other psoriatic arthropathies')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M080', 'Juvenile rheumatoid arthritis  (Includes:  Juvenile rheumatoid arthritis with or without rheumatoid factor.  Note: Arthritis in children with onset before 16th birthday and lasting longer than 3 months.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M081', 'Juvenile ankylosing spondylitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M089', 'Juvenile arthritis, unspecified site   (Includes: Other juvenile arthritis, pauciarticular juvenile arthritis, juvenile arthritis with systemic onset (Still''s disease NOS), juvenile polyarthritis (seronegative), chronic juvenile polyarthritis).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M090', 'Juvenile arthritis in psoriasis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1090', 'Gout, unspecified, multiple sites  (Includes:  Specified gout, multiple sites)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1091', 'Gout, unspecified, shoulder region  (Includes:  Specified gout, shoulder region)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1092', 'Gout, unspecified, upper arm  (Includes:  Specified gout, upper arm)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1093', 'Gout, unspecified, forearm   (Includes:  Specified gout, forearm)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1094', 'Gout, unspecified, hand  (Includes:  Specified gout, hand)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1095', 'Gout, unspecified, pelvic region and thigh  (Includes:  Specified gout, pelvic region and thigh)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1096', 'Gout, unspecified, lower leg  (Includes:  Specified gout, lower leg)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1097', 'Gout, unspecified, ankle and foot  (Includes:  Specified gout, ankle and foot)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1098', 'Gout, unspecified, other site  (Includes:  Specified gout, other site)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M1099', 'Gout, unspecified, unspecified site  (Includes:  Specified gout, unspecified site)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M11', 'Other crystal arthropathies  (Includes: Hydroxyapatite deposition disease, familial chondrocalcinosis, chrondrocalcinosis NOS, other and unspecified crystal arthropathies)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M12', 'Other specific arthropathies (Includes:  Chronic postrheumatic arthropathy [Jaccoud], Kaschin-Beck disease, vilonodular synovitis (pigmented), palindromic rheumatism, intermittent hydrarthrosis (intermittent joint effusions), traumatic arthropathy, and other arthropathies NEC, transient arthropathy) (Excludes: Arthropathy NOS (see M13.9), arthrosis (see M15-M19)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M130', 'Polyarthritis, unspecified  (Excludes:  Inflammatory polyarthropathy (M06))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M131', 'Monoarthritis, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M138', 'Other specified arthritis  (Includes:  Allergic arthritis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M139', 'Arthritis, unspecified  (Includes:  Arthropathy NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M150', 'Primary generalized (osteo)arthrosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M153', 'Secondary multiple arthrosis  (Includes:  Post -traumatic polyarthrosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M158', 'Other polyarthrosis (Includes:  Polyarthrosis, unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M16', 'Coxarthrosis [arthrosis of hip] (Includes:  Osteoarthritis of hip)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M17', 'Gonarthrosis [arthrosis of knee]  (Includes:  Osteoarthritis of knee)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M19', 'Other arthrosis  of other joints')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M201', 'Hallux valgus (acquired)  (Includes:  Bunion)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M202', 'Hallux rigidus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M203', 'Other deformity of hallux (acquired)  (Includes:  Hallux varus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M204', 'Other hammer toe(s) (acquired)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M205', 'Other deformities of toe(s) (acquired)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M206', 'Acquired deformity of toe(s), unspecified  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M210', 'Valgus deformity, not elsewhere classified  (Excludes:  Metatarsus valgus (Q66), talipes calcaneovalgus (Q66))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M211', 'Varus deformity, not elsewhere classified  (Excludes:  Metatarsus varus (Q66), tibia vara (M92))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M212', 'Flexion deformity')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M213', 'Wrist or foot drop (acquired)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M214', 'Flat foot [pes planus] (acquired)  (Excludes:  Congenital pes planus (Q66)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M215', 'Acquired clawhand, clubhand, clawfoot and clubfoot  (Excludes:  Clubfoot, not specified as acquired (Q66))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M216', 'Other acquired deformities of ankle and foot  (Excludes:  Deformities of toe (acquired) (M20.1 - M20.6))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M217', 'Unequal limb length (acquired)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M218', 'Other specified acquired deformities of limbs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M219', 'Acquired deformity of limb, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M22', 'Disorders of patella   (Includes:  Recurrent dislocation of patella, patellofemoral disorders, chondromalacia of patella)  (Excludes: Dislocation of patella (see S83.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M234', 'Loose body in knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M235', 'Chronic instability of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M236', 'Other spontaneous disruption of ligament(s) of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M241', 'Other articular cartilage disorders    (Includes:  Degeneration of articular cartilage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M242', 'Disorder of ligament   (Includes:  Instability secondary to old ligament injury, Ligamentous laxity NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2439', 'Pathological dislocation and subluxation of joint, not elsewhere classified, unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M244', 'Recurrent dislocation and subluxation of joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2453', 'Contracture of joint, forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2456', 'Contracture of joint, lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2458', 'Contracture of joint, other site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2459', 'Contracture of joint, unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2462', 'Ankylosis of joint, upper arm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2465', 'Ankylosis of joint, pelvic region and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2467', 'Ankylosis of joint, ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2468', 'Ankylosis of joint, other site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M2469', 'Ankylosis of joint, unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M247', 'Protrusio acetabuli')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M248', 'Other specific joint derangements, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M251', 'Fistula of joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M252', 'Flail joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M253', 'Other instability of joint  (Includes: Unstable joint)  (Excludes:  Instability of joint secondary to: old ligament injury (M24.2), removal of joint prosthesis (M96.8))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M254', 'Effusion of joint  (Includes: Fluid of joint, hydrarthrosis, swelling of joint)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M255', 'Pain in joint  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M256', 'Stiffness of joint, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M257', 'Osteophyte')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M258', 'Other specified joint disorders  (Includes: Calcification of joint)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M259', 'Joint disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M30', 'Polyarteritis nodosa and related conditions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M31', 'Other necrotizing vasculopathies  (Includes:  Aortic arch syndrome [Takayasu], giant cell arteritis, Wegener''s granulomatosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M32', 'Systemic lupus erythematosus  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M330', 'Juvenile dermatomyositis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M331', 'Other dermatomyositis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M332', 'Polymyositis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M339', 'Dermatopolymyositis, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M34', 'Systemic sclerosis  (Includes:  Scleroderma)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M353', 'Polymyalgia rheumatica  (Excludes:  Polymyalgia rheumatica with giant cell arteritis (M31))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M359', 'Systemic involvement of connective tissue, unspecified site (Includes:  Autoimmune disease (systemic) NOS, collagen (vascular) disease NOS, other specified systemic involvement of connective tissue, hypermobility syndrome, familial ligamentous laxity, relapsing panniculitis [Weber-Christian], multifocal fibrosclerosis, diffuse (eosinophilic) fasciitis, Behet''s disease, other overlap syndromes, Sicca syndrome [Sjgren])')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M400', 'Postural kyphosis  (Excludes:  Osteochondrosis of spine (M42)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M401', 'Other secondary kyphosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M402', 'Other and unspecified kyphosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M403', 'Flatback syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M404', 'Other lordosis  (Includes:  Lordosis acquired, postural)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M405', 'Lordosis, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M418', 'Other forms of scoliosis  (Includes: Infantile idiopathic scoliosis, juvenile idiopathic scoliosis, other idiopathic scoliosis, thoracogenic scoliosis, neuromuscular scoliosis, scoliosis secondary to cerebral palsy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M419', 'Scoliosis, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M42', 'Spinal osteochondrosis   (Includes: Juvenile and adult osteochondrosis of spine, Calv''s disease, Scheuermann''s disease, spinal osteochondrosis unspecified).   (Excludes: Postural kyphosis (See M40.0), Other osteochrondropathies (See M93))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M430', 'Spondylolysis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M431', 'Spondylolisthesis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M432', 'Other fusion of spine  (Includes:  Ankylosis of spinal joint)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M435', 'Other recurrent vertebral subluxation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M436', 'Torticollis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M438', 'Other specified deforming dorsopathies  (Excludes:  Kyphosis and lordosis (M40.-), scoliosis (M41.-))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M439', 'Deforming dorsopathy, unspecified  (Includes:  Curvature of spine NOS  )')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M45', 'Ankylosing Spondylitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M46', 'Other inflammatory spondylopathies  (Includes: Other infective spondylopathies, inflammatory spondylopathy unspecified, spinal enthesopathy, osteomyelitis of vertebra, infection of intervertebral disc (pyogenic), discitis, unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M471', 'Other spondylosis with myelopathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M472', 'Other spondylosis with radiculopathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M478', 'Other spondylosis (Includes:  Cervical spondylosis, lumbosacral spondylosis, thoracic spondylosis without myelopathy or radiculopathy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M479', 'Spondylosis, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4800', 'Spinal stenosis, multiple sites in spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4801', 'Spinal stenosis, occipito-atlanto-axial region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4802', 'Spinal stenosis, cervical region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4803', 'Spinal stenosis, cervicothoracic region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4804', 'Spinal stenosis, thoracic region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4805', 'Spinal stenosis, thoracolumbar region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4806', 'Spinal stenosis, lumbar region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4807', 'Spinal stenosis, lumbosacral region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4808', 'Spinal stenosis, sacral and sacrococcygeal region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M4809', 'Spinal stenosis, unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M481', 'Ankylosing hyperostosis [Forestier]  (Includes:  Diffuse idiopathic skeletal hyperostosis [DISH])')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M482', 'Kissing spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M483', 'Traumatic spondylopathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M484', 'Fatigue fracture of vertebra  (Includes:  Stress fracture of vertebra)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M485', 'Collapsed vertebra, not elsewhere classified  (Includes:  Collapsed vertebra NOS, wedging of vertebra NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M488', 'Other specified spondylopathies  (Includes:  ossification of posterior longitudinal ligament)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M489', 'Spondylopathy, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M495', 'Collapsed vertebra in diseases classified elsewhere  (Note: Code also secondary malignant neoplasm of bone and bone marrow (C79.5), when applicable.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M50', 'Cervical disc disorder with myelopathy    (Includes:  Cervical disc disorders with cervicalgia, cervicothoracic disc disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M51', 'Other intervertebral disc disorders ( Includes:  Thoracic, thoracolumbar and lumbosacral disorders)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M532', 'Spinal instabilities')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M53  ', 'Other dorsopathies, not elsewhere classified  (Includes: Coccygodynia, sacrococcygeal disorders NEC)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M541', 'Radiculopathy  (Includes:  Neuritis or radiculitis:  brachial NOS, lumbar NOS,  thoracic NOS, Radiculitis NOS) (Excludes:  Neuralgia and neuritis NOS (M79.2), radiculopathy with:  cervical disc disorder (M50), lumbar and other intervertebral disc disorder (M51), spondylosis (M47.8))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M542', 'Cervicalgia  (Includes:  Neck pain cervical)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M543', 'Sciatica  (Excludes: Lesion of sciatic nerve (see G57.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M544', 'Lumbago with sciatica')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M545', 'Low back pain  (Includes:  Loin pain, low back strain, lumbago NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M546', 'Pain in thoracic spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M548', 'Other dorsalgia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M549', 'Dorsalgia, unspecified site  (Includes:  Backache NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M600', 'Infective myositis  (Includes:  Tropical pyomyositis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M61', 'Calcification and ossification of muscle  (Includes: Myositis ossificans traumatica, myositis/fibrodysplasia ossificans progressiva, paralytic calcification and ossification of muscle, myositis ossificans associated with quadriplegia or paraplegia, other and unspecified ossification of muscle)  (Excludes: Calcific tendinitis ( M65.2), of shoulder (M75.3))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M62', 'Other disorders of muscle  (Includes:  Muscle (sheath) hernia, rhabdomyolysis) (Excludes: Traumatic rhabdomyolysis: See T79.6)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M620', 'Diastasis of muscle')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M621', 'Other rupture of muscle (nontraumatic)  (Excludes:  Rupture of tendon (M66.0-M66.4), traumatic rupture of muscle - see injury of muscle by body region)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M623', 'Immobility syndrome (paraplegic)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M624', 'Contracture of muscle  (Excludes:  Contracture of joint (M24.53-M24.59))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M625', 'Muscle wasting and atrophy, not elsewhere classified  (Includes:  Disuse atrophy NEC)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M650', 'Abscess of tendon sheath')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M651', 'Other infective (teno)synovitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M652', 'Calcific tendinitis  (Excludes:  Of shoulder (M75.3))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M653', 'Trigger finger  (Includes:  Nodular tendinous disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M658', 'Other synovitis and tenosynovitis (Includes:  Irritable hip, synovitis and tenosynovitis unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M660', 'Rupture of popliteal cyst')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M661', 'Rupture of synovium  (Includes:  Rupture of synovial cyst)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M662', 'Spontaneous rupture of extensor tendons')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M664', 'Spontaneous rupture of other tendons')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M670', 'Short Achilles tendon (acquired)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M671', 'Other contracture of tendon (sheath)  (Excludes:  With contracture of joint (M24.53-M24.59))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M672', 'Synovial hypertrophy, not elsewhere classified ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M673', 'Transient synovitis  (Includes:  Toxic synovitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M674', 'Ganglion    (Includes:  Ganglion of joint or tendon (sheath))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M702', 'Olecranon bursitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M703', 'Other bursitis of elbow')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M704', 'Prepatellar bursitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M706', 'Trochanteric bursitis  (Includes:  Trochanteric tendinitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M707', 'Other bursitis of hip (Includes:  Ischial bursitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M708', 'Other soft tissue disorders related to use, overuse and pressure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M711', 'Other infective bursitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M712', 'Synovial cyst of popliteal space [Baker]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M713', 'Other bursal cyst  (Includes:  Synovial cyst NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M714', 'Calcium deposit in bursa  (Excludes:  Of shoulder (M75.3))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M715', 'Other bursitis, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M720', 'Palmar fascial fibromatosis [Dupuytren]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M721', 'Knuckle pads')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M722', 'Plantar fascial fibromatosis  (Includes:  Plantar fasciitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M724', 'Pseudosarcomatous fibromatosis  (Includes:  Nodular fasciitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7260', 'Necrotizing fasciitis, multiple sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7261', 'Necrotizing fasciitis, shoulder region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7262', 'Necrotizing fasciitis, upper arm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7263', 'Necrotizing fasciitis, forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7264', 'Necrotizing fasciitis, hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7265', 'Necrotizing fasciitis, pelvic region and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7266', 'Necrotizing fasciitis, lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7267', 'Necrotizing fasciitis, ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7268', 'Necrotizing fasciitis, other site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7269', 'Necrotizing fasciitis, unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M728', 'Other fibroblastic disorders  (Includes:  Abscess of fascia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M729', 'Fibroblastic disorder, unspecified  (Includes:  Fasciitis NOS, fibromatosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M750', 'Adhesive capsulitis of shoulder  (Includes:  Frozen shoulder, periarthritis of shoulder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M751', 'Rotator cuff syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M752', 'Bicipital tendinitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M753', 'Calcific tendinitis of shoulder  (Includes:  Calcified bursa of shoulder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M754', 'Impingement syndrome of shoulder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M755', 'Bursitis of shoulder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M758', 'Other shoulder lesions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M759', 'Shoulder lesion, unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M76', 'Enthesopathies of lower limb, excluding foot  (Includes: Gluteal tendinitis, psoas tendinitis, iliotibial band syndrome, tibial collateral bursitis [Pellegrini-Stieda], patellar tendinitis, peroneal tendinitis, other enthesopathies of lower limb, excluding foot, anterior tibial syndrome, posterior tibial tendinitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M77', 'Other enthesopathies  (Includes: Medial and lateral epicondylitis, tennis elbow, periarthritis of wrist, metatarsalgia, other and unspecified enthesopathies, bone spur NOS, capsulitis NOS, periarthritis NOS, tendinitis NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M791', 'Myalgia   (Excludes:  Myositis (M60.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M792', 'Neuralgia and neuritis, unspecified  (Excludes:  Radiculitis:  NOS (M54.1), brachial  NOS (M54.1), lumbosacral NOS (M54.1), sciatica (M54.3 - M54.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7960', 'Pain in upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7961', 'Pain in lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M7969', 'Pain in unspecified limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M797', 'Fibromyalgia  (Includes:  Fibromyositis, fibrositis, myofibrositis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8080', 'Other osteoporosis with pathological fracture, multiple sites (Includes: Pathological fracture of multiple sites with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, multiple sites)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8081', 'Other osteoporosis with pathological fracture, shoulder region (Includes: Pathological fracture of shoulder region with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, shoulder region)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8082', 'Other osteoporosis with pathological fracture, upper arm (Includes: Pathological fracture of upper arm with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, upper arm)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8083', 'Other osteoporosis with pathological fracture, forearm (Includes: Pathological fracture of forearm with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, forearm)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8084', 'Other osteoporosis with pathological fracture, hand (Includes: Pathological fracture of hand with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, hand)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8085', 'Other osteoporosis with pathological fracture, pelvic region and thigh (Includes: Pathological fracture of pelvic region and thigh with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, pelvic region and thigh)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8086', 'Other osteoporosis with pathological fracture, lower leg (Includes: Pathological fracture of lower leg with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, lower leg)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8087', 'Other osteoporosis with pathological fracture, ankle and foot (Includes: Pathological fracture of ankle and foot with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, ankle and foot)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8088', 'Other osteoporosis with pathological fracture, other site (Includes: Pathological fracture of other site with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, other site)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8089', 'Other osteoporosis with pathological fracture, unspecified site (Includes: Pathological fracture of unspecified site with postmenopausal/postoophorectomy/postsurgical malabsorption/drug-induced/idiopathic osteoporosis, and osteoporosis of disuse with pathological fracture, unspecified site)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8090', 'Unspecified osteoporosis with pathological fracture, multiple sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8091', 'Unspecified osteoporosis with pathological fracture, shoulder region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8092', 'Unspecified osteoporosis with pathological fracture, upper arm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8093', 'Unspecified osteoporosis with pathological fracture, forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8094', 'Unspecified osteoporosis with pathological fracture, hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8095', 'Unspecified osteoporosis with pathological fracture, pelvic region and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8096', 'Unspecified osteoporosis with pathological fracture, lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8097', 'Unspecified osteoporosis with pathological fracture, ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8098', 'Unspecified osteoporosis with pathological fracture, other site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8099', 'Unspecified osteoporosis with pathological fracture, unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M81', 'Osteoporosis without pathological fracture ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M83', 'Adult osteomalacia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M840', 'Malunion of fracture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8410', 'Nonunion of fracture [pseudarthrosis], multiple sites')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8411', 'Nonunion of fracture [pseudarthrosis], shoulder region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8412', 'Nonunion of fracture [pseudarthrosis], upper arm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8413', 'Nonunion of fracture [pseudarthrosis], forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8414', 'Nonunion of fracture [pseudarthrosis], hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8415', 'Nonunion of fracture [pseudarthrosis], pelvic region and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8416', 'Nonunion of fracture [pseudarthrosis], lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8417', 'Nonunion of fracture [pseudarthrosis], ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8418', 'Nonunion of fracture [pseudarthrosis], other site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8419', 'Nonunion of fracture [pseudarthrosis], unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M842', 'Delayed union of fracture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M843', 'Stress fracture, not elsewhere classified  (Includes:  Stress fracture NOS)  (Excludes:  Stress fracture of vertebra (M48.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M844', 'Pathological fracture, not elsewhere classified  (Includes:  Pathological fracture, NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M848', 'Other disorders of continuity of bone')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M849', 'Disorder of continuity of bone, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M860', 'Acute haematogenous osteomyelitis  (Includes: Acute hematogenous osteomyelitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M861', 'Other acute osteomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M862', 'Subacute osteomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M863', 'Chronic multifocal osteomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M864', 'Chronic osteomyelitis with draining sinus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M865', 'Other chronic haematogenous osteomyelitis  (Includes: Other chronic hematogenous osteomyelitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M866', 'Other chronic osteomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M868', 'Other osteomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M869', 'Osteomyelitis, unspecified  (Includes:  Infection of bone NOS, periostitis without mention of osteomyelitis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M87', 'Osteonecrosis ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M88', 'Paget''s disease of bone [osteitis deformans]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8900', 'Complex Regional Pain Syndrome I [CRPS I], upper limb  (Includes: Sympathetic reflex dystrophy, upper limb, shoulder-hand syndrome, Sudeck''s atrophy, upper limb)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8901', 'Complex Regional Pain Syndrome I [CRPS I], lower limb  (Includes: Sympathetic reflex dystrophy, lower limb,  Sudeck''s atrophy)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8902', 'Complex Regional Pain Syndrome I [CRPS I], other and unspecified site')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M8909', 'Algoneurodystrophy, NOS')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M892', 'Other disorders of bone development and growth')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M893', 'Hypertrophy of bone')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M895', 'Osteolysis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M896', 'Osteopathy after poliomyelitis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M899', 'Disorder of bone, unspecified  (Includes: Other specified disorders of bone)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M907', 'Fracture of bone in neoplastic disease (Code also C14-D48 for the neoplasm when known)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M910', 'Juvenile osteochondrosis of pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M92', 'Other juvenile osteochondrosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M93', 'Other osteochondropathies  (Includes: Osteochondritis dissecans, other and unspecified osteochondropathies; apophysitis, epiphysitis, osteochondritis, osteochondrosis not specified as adult or juvenile of unspecified site)  (Excludes: Osteochondrosis of spine (See M42))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M94', 'Other disorders of cartilage   (Includes: Chondrocostal junction syndrome [Tietze], costochondritis, relapsing polychondritis, chondromalcia, chondrolysis, other and unspecified disorders of cartilage)   (Excludes: Chondromalacia of patella (See M22))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M95', 'Other acquired deformities of musculoskeletal system and connective tissue')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M960', 'Pseudarthrosis after fusion or arthrodesis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M961', 'Postlaminectomy syndrome, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M962', 'Postradiation kyphosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M963', 'Postlaminectomy kyphosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M964', 'Postsurgical lordosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M965', 'Postradiation scoliosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M9660', 'Fracture of bone following insertion of joint prosthesis (Use an additional code from Chapter XIX - to identify the site of the fracture) (Note:  This code is to be used for periprosthetic fractures that occur at any time while the device is in-situ. A fracture that occurs during the insertion of an implant, joint prosthesis or bone plate is classified to  fracture by site.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M9668', 'Fracture of bone following insertion of other and unspecified orthopaedic implant (For example: bone plate) (Use an additional code from Chapter XIX - to identify the site of the fracture) (Note:  This code is to be used for periprosthetic fractures that occur at any time while the device is in-situ. A fracture that occurs during the insertion of an implant, joint prosthesis or bone plate is classified to fracture by site.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M968', 'Other postprocedural musculoskeletal disorders  (Includes:  Instability of joint secondary to removal of joint prosthesis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M969', 'Postprocedural musculoskeletal disorder, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('M99', 'Biomechanical lesions, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N17', 'Acute renal failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N181', 'Chronic kidney disease, stage 1  (Includes:  Kidney damage with normal or increased GFR (>90 mL/min))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N182', 'Chronic kidney disease, stage 2  (Includes:  Kidney damage with mild decreased GFR (60-89 mL/min))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N183', 'Chronic kidney disease, stage 3  (Includes:  Kidney damage with moderately decreased GFR (30-59 mL/min))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N184', 'Chronic kidney disease, stage 4  (Includes:  Kidney damage with severely decreased GFR (15-29 mL/min))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N185', 'Chronic kidney disease, stage 5  (Includes:  Chronic uraemia, chronic uremia, end stage kidney disease: NOS, in allograft failure, on dialysis, without dialysis or transplant) ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N189', 'Chronic kidney disease, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N19', 'Unspecified renal failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N20', 'Calculus of kidney and ureter  (Includes:  Urinary calculus unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N210', 'Calculus in bladder')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N211', 'Calculus in urethra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N219', 'Calculus of lower urinary tract, unspecified  (Includes:  Other lower urinary tract calculus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N23', 'Unspecified renal colic')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N30', 'Cystitis  (Includes:  Other and unspecified cystitis, Interstitial cystitis [chronic], Trigonitis, Irradiation cystitis, acute cystitis, abscess of bladder, cystitis cystica (glandularis))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N310', 'Uninhibited neuropathic bladder, not elsewhere classified  (Excludes:  Cord bladder (G95.8), due to spinal cord injury (G95.8), neurogenic bladder due to cauda equina (G83.4), urinary incontinence (R32, N39.30 - N39.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N311', 'Reflex neuropathic bladder, not elsewhere classified  (Excludes:  Cord bladder (G95.8), due to spinal cord injury (G95.8), neurogenic bladder due to cauda equina (G83.4), urinary incontinence (R32, N39.30 - N39.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N312', 'Flaccid neuropathic bladder, not elsewhere classified (Excludes:  Cord bladder (G95.8), due to spinal cord injury (G95.8), neurogenic bladder due to cauda equina (G83.4), urinary incontinence (R32, N39.30 - N39.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N318', 'Other neuromuscular dysfunction of bladder   (Excludes:  Cord bladder (G95.8), due to spinal cord injury (G95.8), neurogenic bladder due to cauda equina (G83.4), urinary incontinence (R32, N39.30 - N39.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N319', 'Neuromuscular dysfunction of bladder, unspecified   (Excludes:  Cord bladder (G95.8), due to spinal cord injury (G95.8), neurogenic bladder due to cauda equina (G83.4), urinary incontinence (R32, N39.30 - N39.4))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N32', 'Other disorders of bladder  (Includes:  Bladder neck obstruction)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N34', 'Urethritis and urethral syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N36', 'Other disorders of urethra  (Includes:  Urethral fistula, prolapse of urethra)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N39', 'Other disorders of urinary system')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N390', 'Urinary tract infection, site not specified   (Includes:  UTI, site not specified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N3930', 'Mixed incontinence  (Includes:  Stress incontinence with urge incontinence)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N3939', 'Stress incontinence')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N394', 'Other specified urinary incontinence  (Includes: Urge incontinence)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N42', 'Other disorders of prostate')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N50', 'Other disorders of male genital organs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N64', 'Other disorders of breast  (Includes: Fat necrosis of breast, galactocele, mastodynia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N73', 'Other female pelvic inflammatory diseases')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N80', 'Endometriosis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N94', 'Pain and other conditions associated with female genital organs and menstrual cycle')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N99', 'Postprocedural disorders of genitourinary system, not elsewhere classified  (Includes:  Postprocedural renal failure, postprocedural urethral stricture, postprocedural pelvic peritoneal adhesions, haemorrahge/hemorrhage from external stoma of urinary tract, infection of external stoma of urinary tract, other malfunction of external stoma of urinary tract)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N998', 'Other postprocedural disorder of genitourinary system')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('N999', 'Postprocedural disorder of genitourinary system, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q03', 'Congenital hydrocephalus (Excludes:  Arnold-Chiari syndrome (Q07.0))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q04', 'Other congenital malformations of brain  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q05', 'Spina bifida  (Includes:  hydromeningocele (spinal), meningocele (spinal), meningomyelocele, myelocele, myelomeningocele, rachischisis, spina bifida (aperta) (cystica), syringomyelocele)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q06', 'Other congenital malformations of spinal cord  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q070', 'Arnold-Chiari syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q078', 'Other specified congenital malformations of nervous system  (Includes:  Unspecified congenital malformations of nervous system, agensis of nerve, displacement of brachial plexus, jaw-winking syndrome, Marcus Gunn''s syndrome)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q21', 'Congenital malformations of cardiac septa (Includes: Ventricular septal defect, atrial septal defect and other congenital malformations of cardiac septa)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q23', 'Congenital malformations of aortic and mitral valves')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q24', 'Other congenital malformations of heart ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q652', 'Congenital dislocation of hip, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q655', 'Congenital subluxation of hip, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q656', 'Unstable hip  (Includes:  Dislocatable hip, subluxatable hip)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q658', 'Other congenital deformities of hip  (Includes:  Anteversion of femoral neck, Congenital:  acetabular dysplasia, coxa:  valga, vara)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q659', 'Congenital deformity of hip, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q66', 'Congenital deformities of feet  (Includes: Talipes equinovarus, talipes calcaneovarus, metatarsus varus, other congenital varus deformities of feet, talipes calcaneovalgus, congenital pes planus, flat foot (congenital, rigid, spastic), metatarsus valgus, clubfoot, hammer toe, talipes NOS, vertical talus,  other and unspecified congenital deformities of feet)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q675', 'Congenital deformity of spine  (Includes:  Congenital Scoliosis NOS, Congenital scoliosis postural)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q678', 'Other congenital deformities of chest  (Includes:  Congenital deformity of chest wall NOS, other congenital deformities of skull, face and jaw, congenital deviation of nasal septum, pectus excavatum, Congenital funnel chest, pectus carinatum, congenital pigeon chest)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q688', 'Other specified congenital musculoskeletal deformities  (Includes:  Congenital:  Deformity of clavicle, elbow, forearm, scapula, or dislocation of elbow or shoulder)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q699', 'Polydactyly, unspecified  (Includes:  Supernumerary digit (s) NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q70', 'Syndactyly  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q71', 'Reduction defects of upper limb  [absence of upper limb]  (Includes: Congenital complete absence of upper limb(s), congenital absence of upper arm and forearm with hand present, congenital absence of both forearm and hand, congenital absence of hand and finger(s), unspecified reduction defect of upper limb).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q72', 'Reduction defects of lower limb  [absence of lower limb]   (Includes: Congenital complete absence of lower limb(s), congenital absence of thigh and lower leg with foot present, congenital absence of both lower leg and foot, congenital absence of foot and toe(s), unspecified reduction defect of lower limb).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q730', 'Congenital absence of unspecified limb(s)  (Includes:  Amelia NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q74', 'Other congenital malformations of limb(s)   (Includes: Arthrogryposis multiplex congenita, Unspecified congenital malformation of limb(s))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q75', 'Other congenital malformations of skull and face bones  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q76', 'Congenital malformations of spine and bony thorax  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q77', 'Osteochondrodysplasia with defects of growth of tubular bones and spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q78', 'Other osteochondrodysplasias')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q79', 'Congenital malformations of the musculoskeletal system, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q850', 'Neurofibromatosis (nonmalignant)  (Includes:  Von Recklinghausen''s disease)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q851', 'Tuberous sclerosis  (Includes:  Bourneville''s disease, epiloia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q87', 'Other specified congenital malformation syndromes affecting multiple systems')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q89', 'Other congenital malformations, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q90', 'Down''s syndrome')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Q99', 'Other chromosome abnormalities, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R000', 'Tachycardia, unspecified  (Includes:  Rapid heart beat, Tachycardia sinoauricular NOS,  sinus [sinusal] NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R001', 'Bradycardia, unspecified  (Includes:  Bradycardia:  sinoatrial, sinus, vagal, Slow heart beat)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R002', 'Palpitations  (Includes:  Awareness of heart beat)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R003', 'Pulseless electrical activity, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R008', 'Other and unspecified abnormalities of heart beat')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R01', 'Cardiac murmurs and other cardiac sounds')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R02', 'Gangrene, not elsewhere classified  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R03', 'Abnormal blood-pressure reading, without diagnosis  (Excludes: Hypotension (See I95.-))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R040', 'Epistaxis (Includes:  Haemorrhage/hemorrhage from nose, Nosebleed)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R041', 'Haemorrhage from throat (Includes:  Hemorrhage from throat)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R042', 'Haemoptysis  (Includes:  Blood-stained sputum, cough with haemorrhage/hemorrhage, hemoptysis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R048', 'Haemorrhage from other sites in respiratory passages   (Includes: Pulmonary haemorrhage/hemorrhage NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R049', 'Haemorrhage from respiratory passages, unspecified   (Includes: Hemorrhage from respiratory passages, unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R05', 'Cough')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R060', 'Dyspnoea  (Includes:  Orthopnoea/orthopnea, shortness of breath [SOB], dyspnea)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R062', 'Wheezing')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R068', 'Other and unspecified abnormalities of breathing  (Includes:  Apnoea/apnea NOS, breath holding (spells), choking sensation, sighing, stridor, periodic breathing, Cheyne-Stokes breathing, hyperventilation, mouth breathing, snoring, hiccough, sneezing)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R070', 'Pain in throat')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R071', 'Chest pain on breathing  (Includes:  Painful respiration)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R072', 'Precordial pain')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R073', 'Other chest pain  (Includes:  Anterior chest-wall pain NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R074', 'Chest pain, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R090', 'Asphyxia, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R091', 'Pleurisy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R092', 'Respiratory arrest  (Includes:  Cardiorespiratory failure) (Excludes: Cardiorespiratory arrest (See I46.9))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R093', 'Abnormal sputum  (Includes:  Abnormal:  amount, colour, odour of sputum, Excessive)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R098', 'Other specified symptoms and signs involving the circulatory and respiratory systems  (Includes:  Bruit (arterial), chest:  abnormal percussion, friction sounds, tympany, rales, weak pulse)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R100', 'Acute abdomen   (Includes:  Severe abdominal pain (generalized) (localized) (with abnormal rigidity))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R101', 'Pain localized to upper abdomen')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R102', 'Pelvic and perineal pain')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R103 ', 'Pain localized to other parts of lower abdomen')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R104', 'Other and unspecified abdominal pain  (Includes:  Abdominal tenderness NOS, Colic NOS, Colic infantile)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R110 ', 'Projectile vomiting')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R111 ', 'Nausea alone')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R112 ', 'Vomiting alone')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R113 ', 'Nausea with vomiting')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R12', 'Heartburn')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R130 ', 'Oropharyngeal dysphagia  (Includes:  Neurogenic esophageal dysphagia, obstructive esophageal dysphagia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R132 ', 'Esophageal dysphagia  (Includes:  Neurogenic oropharyngeal dysphagia, obstructive oropharyngeal dysphagia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R138 ', 'Other and unspecified dysphagia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R14', 'Flatulence and related conditions  (Includes:  Abdominal distension (gaseous), bloating, eructation, gas pain, tympanites (abdominal) (intestinal))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R15', 'Faecal incontinence  (Includes:  Encopresis NOS; fecal incontinence)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R16', 'Hepatomegaly and splenomegaly, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R17', 'Unspecified jaundice')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R18', 'Ascites  (Includes:  Fluid in peritoneal cavity)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R19', 'Other symptoms and signs involving the digestive system and abdomen')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R20', 'Disturbances of skin sensation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R21', 'Rash and other nonspecific skin eruption')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R22', 'Localized swelling, mass and lump of skin and subcutaneous tissue')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R23', 'Other skin changes')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R250', 'Abnormal head movements')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R251', 'Tremor, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R252', 'Cramp and spasm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R253', 'Fasciculation  (Includes:  Twitching NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R258', 'Other and unspecified abnormal involuntary movements')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R260', 'Ataxic gait  (Includes:  Staggering gait)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R261', 'Paralytic gait  (Includes:  Spastic gait)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R262', 'Difficulty in walking, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R263', 'Immobility  (Includes:  Bedfast or chairfast)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R2682 ', 'Unsteadiness on feet')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R2688 ', 'Other and unspecified abnormalities of gait and mobility  (Includes:  Antalgic gait)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R270', 'Ataxia, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R278', 'Other and unspecified lack of coordination')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R296', 'Tendency to fall, not elsewhere classified  (Includes:  Tendency to fall because of old age or other unclear health problems)  (Excludes:  Difficulty in walking (R26.2), dizziness and giddiness (R42) falls due to diseases classified elsewhere syncope and collapse (R55))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R298', 'Other and unspecified symptoms and signs involving the nervous and musculoskeletal systems  (Includes: Tetany, carpopedal spasm, meningismus, abnormal reflex, abnormal posture, clicking hip)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R30', 'Pain associated with micturition')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R31', 'Unspecified haematuria  (Includes:  Essential hematuria, unspecified hematuria)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R32', 'Unspecified urinary incontinence')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R33', 'Retention of urine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R34', 'Anuria and oliguria')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R350 ', 'Nocturia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R358 ', 'Other and unspecified polyuria  (Includes: Frequency of micturition NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R36', 'Urethral discharge  (Includes:  Penile discharge, urethrorrhoea, urethrorrhea)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R39', 'Other symptoms and signs involving the urinary system')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R400', 'Somnolence  (Includes:  Drowsiness)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R401', 'Stupor  (Includes:  Semicoma)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R402', 'Coma, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R410', 'Disorientation, unspecified  (Includes:  Confusion NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R411', 'Anterograde amnesia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R412', 'Retrograde amnesia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R413', 'Other amnesia  (Includes:  Amnesia NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R416', 'Neurological neglect syndrome  (Includes: Asomatognosia, hemi-akinesia, hemi-inattention, hemispatial neglect, left-sided neglect, sensory extinction, sensory neglect, and visuospatial neglect)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R4180 ', 'Transient alteration of awareness')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R4188 ', 'Other and unspecified symptoms and signs involving cognitive functions and awareness')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R42', 'Dizziness and giddiness  (Includes:  Light-headedness, vertigo NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R443', 'Hallucinations, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R448', 'Other and unspecified symptoms and signs involving general sensations and perceptions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R450', 'Nervousness  (Includes:  Nervous tension)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R451', 'Restlessness and agitation')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R452', 'Unhappiness    (Includes:  Depression, not clinically diagnosed feeling depressed, Sadness, Worries NOS) (Excludes:  depression, diagnosis confirmed clinically (See F32)).  (Note: Please see Mental Health Chapter.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R453', 'Demoralization and apathy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R454', 'Irritability and anger')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R455', 'Hostility')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R456', 'Physical violence')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R457', 'State of emotional shock and stress, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R458', 'Other symptoms and signs involving emotional state   (Includes:  Suicidal ideation (tendencies))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R4680 ', 'Obsessive-compulsive behaviour   (Excludes:  Obsessive-compulsive disorder (F42))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R4688 ', 'Other symptoms and signs involving appearance and behaviour   (Includes:  Concern about body image, difficult patient, feeling senile, feeling violent, hostile behaviour)  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R470', 'Dysphasia and aphasia  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R471', 'Dysarthria and anarthria')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R478', 'Other and unspecified speech disturbances')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R480', 'Dyslexia and alexia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R481', 'Agnosia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R482', 'Apraxia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R488', 'Other and unspecified symbolic dysfunctions  (Includes:  Acalculia, agraphia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R490', 'Dysphonia  (Includes:  Hoarseness)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R491', 'Aphonia  (Includes:  Loss of voice)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R498', 'Other and unspecified voice disturbances')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R50', 'Fever of other and unknown origin (Includes:  Drug-induced fever, fever with chills, fever with rigors, persistent fever, hyperpyrexia NOS, pyrexia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R51', 'Headache   (Includes:  Facial Pain NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R520', 'Acute pain')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R521', 'Chronic intractable pain')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R522', 'Other chronic pain')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R529', 'Pain, unspecified   (Includes:  Generalized pain NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R53', 'Malaise and fatigue  (Includes:  Asthenia NOS, Debility:  NOS, chronic, nervous, general physical deterioration, lethargy, tiredness)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R54', 'Senility    (Includes:  Old age without mention of psychosis, senescence without mention of psychosis, senile:  asthenia, debility)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R55', 'Syncope and collapse  (Includes:  Blackout, Fainting)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R56', 'Convulsions, not elsewhere classified (Includes:  First time, single isolated seizure (no history of previous seizure)) (Excludes:  A previous history of seizure(s) or recurrent seizures, see G40)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R57', 'Shock, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R58', 'Haemorrhage, not elsewhere classified  (Includes:  Haemorrhage/hemorrhage NOS, hemorrhage NEC)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R59', 'Enlarged lymph nodes  (Includes:  Swollen glands)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R60', 'Oedema, not elsewhere classified  (Includes:  Edema, NEC)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R630', 'Anorexia  (Includes:  Aphagia, Loss of appetite)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R631', 'Polydipsia  (Includes:  Excessive thirst)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R632', 'Polyphagia  (Includes:  Excessive eating, Hyperalimentation NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R633', 'Feeding difficulties and mismanagement  (Includes:  Feeding problem NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R634', 'Abnormal weight loss')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R635', 'Abnormal weight gain  (Excludes:  Obesity  (E66))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R636', 'Insufficient intake of food and water due to self neglect')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R638', 'Other symptoms and signs concerning food and fluid intake')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R64', 'Cachexia (Includes:  Adult failure to thrive)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R650', 'Systemic inflammatory response syndrome of infectious origin without organ failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R651', 'Systemic inflammatory response syndrome of infectious origin with acute organ failure  (Includes:  Severe sepsis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R652', 'Systemic inflammatory response syndrome of noninfectious origin without organ failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R653', 'Systemic inflammatory response syndrome of noninfectious origin with acute organ failure')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R659', 'Systemic inflammatory response syndrome, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R688', 'Other specified general symptoms and signs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R69', 'Unknown and unspecified causes of morbidity  (Includes:  Illness NOS, undiagnosed disease, not specified as to the site or system involved)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('R79', 'Other abnormal findings of blood chemistry (Includes:  Abnormality of RBCs, abnormality of WBCs NEC, elevated blood glucose level, proteinemia, abnormal blood gas level, findings of drugs and other substances not normally found in blood)  (Excludes:  Other diseases of blood and blood-forming organs (D75))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S002', 'Other superficial injuries of eyelid and periocular area')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S005', 'Superficial injury of lip and oral cavity')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S007', 'Multiple superficial injuries of head')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S008', 'Superficial injury of other parts of head  (Includes:  Superficial injury of head, part unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S01', 'Open wound of head')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02100', 'Fracture of base of skull, closed')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02101', 'Fracture of base of skull, open')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02200', 'Fracture of nasal bones, closed')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02201', 'Fracture of nasal bones, open')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02300', 'Fracture of orbital floor, closed')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02301', 'Fracture of orbital floor, open')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S024', 'Fracture of malar and maxillary bones')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S025', 'Fracture of tooth')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S026', 'Fracture of mandible ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02700', 'Multiple fractures involving skull and facial bones, closed')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02701', 'Multiple fractures involving skull and facial bones, open')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02900', 'Fracture of skull and facial bones, part unspecified, closed')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S02901', 'Fracture of skull and facial bones, part unspecified, open')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S030', 'Dislocation of jaw')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S034', 'Sprain and strain of jaw (Includes:  Tempero-mandibular joint)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S035', 'Sprain and strain of joints and ligaments of other and unspecified parts of head  (Includes:  Dislocation of septal cartilage of nose, dislocation of tooth, dislocation of other and unspecified parts of head)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S060', 'Concussion')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S061', 'Traumatic cerebral oedema (Includes: Traumatic cerebral edema)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S062', 'Diffuse brain injury   (Includes:  Cerebral contusion NOS, cerebral laceration NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S063', 'Focal brain injury  (Includes: Traumatic intracerebral hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S064', 'Epidural haemorrhage   (Includes:  Traumatic, Epidural hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S065', 'Traumatic subdural haemorrhage (Includes:  Traumatic subdural hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S066', 'Traumatic subarachnoid haemorrhage (Includes:  Traumatic subarachnoid hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S068', 'Other intracranial injuries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S069', 'Intracranial injury, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S10', 'Superficial injury of neck')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S120', 'Fracture of first cervical vertebra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S121', 'Fracture of second cervical vertebra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1220', 'Fracture of C3 - C4 vertebra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1221', 'Fracture of C5 - C7 vertebra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S127', 'Multiple fractures of cervical spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S128', 'Fracture of other parts of neck  (Includes:  Hyoid bone, larynx, thyroid cartilage, trachea)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S129', 'Fracture of neck, part unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S130', 'Traumatic rupture of cervical intervertebral disc')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S131', 'Dislocation of cervical vertebra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S132', 'Dislocation of other and unspecified parts of neck')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S133', 'Multiple dislocations of neck')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1340', 'Whiplash associated disorder [WAD1] with complaint of neck pain, stiffness or tenderness only')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1341', 'Whiplash associated disorder [WAD2] with complaint of neck pain with musculoskeletal signs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1342', 'Whiplash associated disorder [WAD3] with complaint of neck pain with neurological signs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1348', 'Other sprain and strain of cervical spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S135', 'Sprain and strain of thyroid region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S136', 'Sprain and strain of joints and ligaments of other and unspecified parts of neck')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1410', 'Complete lesion of cervical spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1411', 'Central cord lesion of cervical spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1412', 'Anterior cord syndrome of cervical spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1413', 'Posterior cord syndrome of cervical spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1418', 'Other injuries of cervical spinal cord  (Includes:  Incomplete spinal cord lesion)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S1419', 'Unspecified lesion of cervical spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S15', 'Injury of blood vessels at neck level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S16', 'Injury of muscle and tendon at neck level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S200', 'Contusion of breast')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S21', 'Open wound of thorax')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2200', 'Fracture of thoracic vertebra T1 - T6')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2201', 'Fracture of thoracic vertebra T7- T12')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2209', 'Fracture of  unspecified thoracic vertebra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S221', 'Multiple fractures of thoracic spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S222', 'Fracture of sternum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S223', 'Fracture of rib')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2240', 'Multiple fractures of 2 - 4 ribs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2241', 'Multiple fractures of 5 or more ribs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2249', 'Multiple fractures of unspecified number of ribs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S225', 'Flail chest')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S23', 'Dislocation, sprain and strain of joints and ligaments of thorax  (Includes:  Dislocation of thoracic vertebra, dislocation of other and unspecified parts of thorax, sprain and strain of ribs and sternum (costal cartilage), sprain and strain of thoracic spine)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2410', 'Complete lesion of thoracic spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2411', 'Central cord lesion of thoracic spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2412', 'Anterior cord syndrome of thoracic spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2413', 'Posterior cord syndrome of thoracic spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2418', 'Other injuries of thoracic spinal cord   (Includes:  Incomplete spinal cord lesion)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2419', 'Unspecified lesion of thoracic spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S25', 'Injury of blood vessels of thorax')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S26', 'Injury of heart   (Includes:  Contusion and haematoma/hematoma, laceration, puncture)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S271', 'Traumatic haemothorax  (Includes:  Traumatic hemothorax)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S272', 'Traumatic haemopneumothorax (Includes:  Traumatic hemopneumothorax)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2731', 'Laceration and puncture of lung')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S278', 'Injury of other specified intrathoracic organs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2781', 'Laceration of oesophagus  (Includes:  Laceration of esophagus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2784', 'Laceration of other specified intrathoracic organs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2785', 'Other and unspecified injury of diaphragm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S2786', 'Other and unspecified injury of oesophagus (Includes:  Other and unspecified injury of esophagus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S279', 'Injury of unspecified intrathoracic organ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S300', 'Contusion of lower back and pelvis  (Includes:  Buttock)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S301', 'Contusion of abdominal wall  (Includes:  Flank and groin)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S31', 'Open wound of abdomen, lower back and pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3200', 'Fracture of lumbar vertebra, L1 level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3201', 'Fracture of lumbar vertebra, L2  level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3202', 'Fracture of lumbar vertebra, L3 level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3203', 'Fracture of lumbar vertebra, L4 level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3204', 'Fracture of lumbar vertebra, L5 level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3209', 'Fracture of lumbar vertebra, unspecified level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S321', 'Fracture of sacrum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S322', 'Fracture of coccyx')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S323', 'Fracture of ilium')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S324', 'Fracture of acetabulum')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S325', 'Fracture of pubis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S327', 'Multiple fractures of lumbar spine and pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S328', 'Fracture of other and unspecified parts of lumbar spine and pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S331', 'Dislocation of lumbar vertebra')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S332', 'Dislocation of sacroiliac and sacrococcygeal joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S333', 'Dislocation of other and unspecified parts of lumbar spine and pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S335', 'Sprain and strain of lumbar spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S336', 'Sprain and strain of sacroiliac joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3410', 'Complete lesion of lumbar spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3411', 'Central cord lesion of lumbar spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3412', 'Anterior cord syndrome of lumbar spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3413', 'Posterior cord syndrome of lumbar spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3418', 'Other injuries of lumbar spinal cord   (Includes: Incomplete spinal cord lesion)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S3419', 'Unspecified lesion of lumbar spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S343', 'Injury of cauda equina')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S344', 'Injury of lumbosacral plexus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S345', 'Injury of lumbar, sacral and pelvic sympathetic nerves (Includes:  Celiac and mesenteric nerve plexus)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S35', 'Injury of blood vessels at abdomen, lower back and pelvis level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S36', 'Injury of intra-abdominal organs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S37', 'Injury of  urinary and pelvic organs ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S38', 'Crushing injury and traumatic amputation of part of abdomen, lower back and pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S407', 'Multiple superficial injuries of shoulder and upper arm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S41', 'Open wound of shoulder and upper arm  (Excludes:  Traumatic amputation of shoulder/upper arm (S48))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S420', 'Fracture of clavicle  (Includes:  Clavicle (acromial end and shaft), collar bone)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S421', 'Fracture of scapula  (Includes:  Acromial process, acromion, shoulder blade)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4220', 'Fracture of surgical neck of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4221', 'Fracture of anatomical neck of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4222', 'Fracture of greater tuberosity of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4228', 'Fracture of other part of upper end of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4229', 'Fracture of unspecified part of upper end of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4230', 'Fracture of shaft of humerus NOS')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4239', 'Fracture of unspecified part of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4240', 'Supracondylar fracture of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4241', 'Fracture of lateral condyle of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4242', 'Fracture of medial condyle of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4243', 'Fracture of unspecified condyle of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4248', 'Fracture of other part of lower end of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4249', 'Fracture of unspecified part of lower part of humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S427', 'Multiple fractures of clavicle, scapula and humerus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S430', 'Dislocation of shoulder joint  (Includes: Glenohumeral joint)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S431', 'Dislocation of acromioclavicular joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S432', 'Dislocation of sternoclavicular joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4338', 'Dislocation of other parts of shoulder girdle')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S4339', 'Dislocation of unspecified part of shoulder girdle')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S43401', 'Sprain and strain of shoulder joint, rotator cuff capsule')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S43402', 'Sprain and strain of shoulder joint, NOS  (Includes:  Glenohumeral joint, shoulder joint NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S435', 'Sprain and strain of acromioclavicular joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S436', 'Sprain and strain of sternoclavicular joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S440', 'Injury of ulnar nerve at upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S441', 'Injury of median nerve at upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S442', 'Injury of radial nerve at upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S443', 'Injury of axillary nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S444', 'Injury of musculocutaneous nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S445', 'Injury of cutaneous sensory nerve at shoulder and upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S447', 'Injury of multiple nerves at shoulder and upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S448', 'Injury of other nerves at shoulder and upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S449', 'Injury of unspecified nerve at shoulder and upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S45', 'Injury of blood vessels at shoulder and upper arm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S46', 'Injury of muscle and tendon at shoulder and upper arm level  (Excludes:  Injury of muscle and tendon at or below elbow (S56))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S47', 'Crushing injury of shoulder and upper arm  (Excludes:  Crushing injury of elbow (S57))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S480', 'Traumatic amputation at shoulder joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S481', 'Traumatic amputation at level between shoulder and elbow')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S49', 'Other and unspecified injuries of shoulder and upper arm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S50', 'Superficial injury of forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S510', 'Open wound of elbow')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S517', 'Open wound of forearm, multiple')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S520', 'Fracture of upper end of ulna  (Includes: Olecranon process, proximal end, elbow NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S521', 'Fracture of upper end of radius  (Includes:  Head, neck, proximal end)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S522', 'Fracture of shaft of ulna')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S523', 'Fracture of shaft of radius')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S524', 'Fracture of shafts of both ulna and radius')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S5250', 'Colles'' fracture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S5258', 'Other fracture of lower end of radius')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S5259', 'Unspecified fracture of lower end of radius')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S526', 'Fracture of lower end of both ulna and radius')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S527', 'Multiple fractures of forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S528', 'Fracture of other parts of forearm  (Includes: Head and lower end of ulna)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S529', 'Fracture of forearm, part unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S531', 'Dislocation of elbow')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S532', 'Traumatic rupture of radial collateral ligament')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S533', 'Traumatic rupture of ulnar collateral ligament')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S540', 'Injury of ulnar nerve at forearm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S541', 'Injury of median nerve at forearm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S543', 'Injury of cutaneous sensory nerve at forearm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S547', 'Injury of multiple nerves at forearm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S548', 'Injury of other nerves at forearm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S55', 'Injury of blood vessels at forearm level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S57', 'Crushing injury of forearm  (Includes:  Crushing injury of elbow) (Excludes:  Crushing injury of shoulder and upper arm (S47))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S58', 'Traumatic amputation of forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S59', 'Other and unspecified injuries of forearm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S60', 'Superficial injury of wrist and hand  (Includes: Multiple superficial injuries of wrist and hand and fingers, other and unspecified superficial injuries of wrist and hand and fingers)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S61', 'Open wound of wrist and hand  (Includes:  Fingers) (Includes: Multiple open wounds of wrist and hand, open wound of other and unspecified parts of wrist and hand)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S620', 'Fracture of navicular [scaphoid] bone of hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S621', 'Fracture of other carpal bone(s)  (Includes:  Capitate, hamate, lunate, pisiform, trapezium, trapezoid, triquetrum)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S622', 'Fracture of first metacarpal bone  (Includes: Bennett''s fracture)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S623', 'Fracture of other metacarpal bone')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S624', 'Multiple fractures of metacarpal bones')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S625', 'Fracture of thumb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S626', 'Fracture of other finger')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S627', 'Multiple fractures of fingers')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S628', 'Fracture of other and unspecified parts of wrist and hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S630', 'Dislocation of wrist')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S631', 'Dislocation of finger')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S632', 'Multiple dislocations of fingers')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S635', 'Sprain and strain of wrist')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S640', 'Injury of ulnar nerve at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S641', 'Injury of median nerve at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S642', 'Injury of radial nerve at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S643', 'Injury of digital nerve of thumb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S647', 'Injury of multiple nerves at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S648', 'Injury of other nerves at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S649', 'Injury of unspecified nerve at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S65', 'Injury of blood vessels at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S67', 'Crushing injury of wrist and hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S680', 'Traumatic amputation of thumb (complete)(partial)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S682', 'Traumatic amputation of two or more fingers alone (complete)(partial)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S683', 'Combined traumatic amputation of (part of) finger(s) with other parts of wrist and hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S688', 'Traumatic amputation of other parts of wrist and hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S69', 'Other and unspecified injuries of wrist and hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S70 ', 'Superficial injury of hip and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S707', 'Multiple superficial injuries of hip and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S710', 'Open wound of hip')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S711', 'Open wound of thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S717', 'Multiple open wounds of hip and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S720', 'Fracture of neck of femur   (Includes:  Fracture of hip NOS, fracture of head of femur, subcapital fracture of femur, intracapsular fracture of femur, transcervical fracture of femur, cervicotrochanteric)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S7210', 'Intertrochanteric fracture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S7219', 'Unspecified trochanteric fracture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S722', 'Subtrochanteric fracture')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S723', 'Fracture of shaft of femur')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S724', 'Fracture of lower end of femur')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S727', 'Multiple fractures of femur')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S728', 'Fractures of other parts of femur')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S729', 'Fracture of femur, part unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S730', 'Dislocation of hip')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S731', 'Sprain and strain of hip')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S740', 'Injury of sciatic nerve at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S741', 'Injury of femoral nerve at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S742', 'Injury of cutaneous sensory nerve at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S747', 'Injury of multiple nerves at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S748', 'Injury of other nerves at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S749', 'Injury of unspecified nerve at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S75', 'Injury of blood vessels at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S76', 'Injury of muscle and tendon at hip and thigh level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S77', 'Crushing injury of hip and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S780', 'Traumatic amputation at hip joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S781', 'Traumatic amputation at level between hip and knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S789', 'Traumatic amputation of hip and thigh, level unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S79', 'Other and specified injuries of hip and thigh')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S810', 'Open wound of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S817', 'Multiple open wounds of lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S818', 'Open wounds of other parts of lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S819', 'Open wound of lower leg, part unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S820', 'Fracture of patella')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S821', 'Fracture of upper (proximal) end of tibia (with or without fibula)  (Includes:  Condyles, head, proximal end, tuberosity: with or without mention of fracture of fibula)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S822', 'Fracture of shaft of tibia (with or without fibula)   (Includes: With or without mention of fracture of fibula)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S823', 'Fracture of lower (distal) end of tibia (with or without fibula)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S824', 'Fracture of fibula alone')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S825', 'Fracture of medial malleolus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S826', 'Fracture of lateral malleolus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S827', 'Multiple fractures of lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S828', 'Fractures of other parts of lower leg')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S829', 'Fracture of lower leg, part unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S830', 'Dislocation of patella')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S831', 'Dislocation of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S832', 'Tear of meniscus, current')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S833', 'Tear of articular cartilage(s) of knee, current')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S835', 'Sprain and strain involving (anterior)(posterior) cruciate ligament of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S836', 'Sprain and strain of other and unspecified parts of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S837', 'Injury to multiple structures of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S840', 'Injury of (posterior) tibial nerve at lower leg level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S841', 'Injury of peroneal nerve at lower leg level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S842', 'Injury of cutaneous sensory nerve at lower leg level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S848', 'Injury of other nerves at lower leg level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S849', 'Injury of unspecified nerve at lower leg level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S85', 'Injury of blood vessels at lower leg level  (Excludes: Injury of blood vessels at ankle and foot level (S95))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S86', 'Injury of muscle and tendon at lower leg level  (Excludes: Injury of muscle and tendon at or below ankle (S96))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S870', 'Crushing injury of knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S878', 'Crushing injury of other and unspecified parts of lower leg  (Excludes:  Crushing injury of ankle and foot (S97))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S880', 'Traumatic amputation at knee level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S881', 'Traumatic amputation at level between knee and ankle')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S889', 'Traumatic amputation of lower leg, level unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S89', 'Other and unspecified injuries of lower leg  ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S90', 'Superficial injury of ankle and foot   (Includes: Contusion, multiple superficial injuries of ankle and foot and toes, other and unspecified superficial injuries of ankle and foot and toes).')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S910', 'Open wound of ankle')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S911', 'Open wound of toe(s) without damage to nail')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S912', 'Open wound of toe(s) with damage to nail')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S917', 'Multiple open wounds of ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S920', 'Fracture of calcaneus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S921', 'Fracture of talus')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S922', 'Fracture of other tarsal bone(s)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S924', 'Fracture of great toe')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S925', 'Fracture of other toe')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S930', 'Dislocation of ankle joint')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S931', 'Dislocation of toe(s)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S933', 'Dislocation of other and unspecified parts of foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S940', 'Injury of lateral plantar nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S941', 'Injury of medial plantar nerve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S942', 'Injury of deep peroneal nerve at ankle and foot level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S943', 'Injury of cutaneous sensory nerve at ankle and foot level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S947', 'Injury of multiple nerves at ankle and foot level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S948', 'Injury of other nerves at ankle and foot level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S949', 'Injury of unspecified nerve at ankle and foot level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S95', 'Injury of blood vessels at ankle and foot level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S96', 'Injury of muscle and tendon at ankle and foot level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S97', 'Crushing injury of ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S980', 'Traumatic amputation of foot at ankle level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S983', 'Traumatic amputation of other parts of foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('S99', 'Other and unspecified injuries of ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T00', 'Superficial injuries involving multiple body regions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T020', 'Fractures involving head with neck')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T021', 'Fractures involving thorax with lower back and pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T022', 'Fractures involving multiple regions of one upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T023', 'Fractures involving multiple regions of one lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T024', 'Fractures involving multiple regions of both upper limbs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T025', 'Fractures involving multiple regions of both lower limbs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T026', 'Fractures involving multiple regions of upper limb(s)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T027', 'Fractures involving thorax with lower back and pelvis with limb(s)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T028', 'Fractures involving other combinations of body regions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T029', 'Multiple fractures, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T03', 'Dislocations, sprains and strains involving multiple body regions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T041', 'Crushing injuries involving thorax with abdomen, lower back and pelvis (Includes: trunk)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T044', 'Crushing injuries involving multiple regions of upper limb(s) with lower limb(s)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T048', 'Crushing injuries involving other combinations of body regions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T050', 'Traumatic amputation of both hands')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T051', 'Traumatic amputation of one hand and other arm [any level, except hand]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T052', 'Traumatic amputation of both arms [any level]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T053', 'Traumatic amputation of both feet')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T054', 'Traumatic amputation of one foot and other leg [any level, except foot]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T055', 'Traumatic amputation of both legs [any level]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T056', 'Traumatic amputation of upper and lower limbs, any combination [any level]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T058', 'Traumatic amputations involving other combinations of body regions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T059', 'Multiple traumatic amputations, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T07', 'Unspecified multiple injuries')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T08', 'Fracture of spine, level unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T09', 'Other injuries of spine and trunk, level unspecified (Includes:  Spinal plexus NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T10', 'Fracture of upper limb, level unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T111', 'Open wound of upper limb, level unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T130', 'Superficial injury of lower limb, level unspecified (Includes:  Contusion)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T131', 'Open wound of lower limb, level unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T140', 'Superficial injury of unspecified body region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T142', 'Fracture of unspecified body region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T143', 'Dislocation, sprain and strain of unspecified body region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T145', 'Injury of blood vessel(s) of unspecified body region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T20', 'Burn and corrosion of head and neck')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T22', 'Burn and corrosion of shoulder and upper limb, except wrist and hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T23', 'Burn and corrosion of wrist and hand')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T24', 'Burn and corrosion of hip and lower limb, except ankle and foot')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T26', 'Burn and corrosion confined to eye and adnexa')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T27', 'Burn and corrosion of respiratory tract')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T28', 'Burn and corrosion of other internal organs')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T29', 'Burns and corrosions of multiple body regions')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T30', 'Burn and corrosion, body region unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T35', 'Frostbite involving multiple body regions and unspecified frostbite')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T68', 'Hypothermia')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T751', 'Drowning and nonfatal submersion')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T754', 'Effects of electric current (Includes: Electrocution, Shock from electric current)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T792', 'Traumatic secondary and recurrent haemorrhage  (Includes: Traumatic secondary and recurrent hemorrhage)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T793', 'Post-traumatic wound infection, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T794', 'Traumatic shock (Includes: Shock (immediate)(delayed) following injury)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T796', 'Traumatic ischaemia of muscle (Includes: Volkmann''s ischaemic/ischemic contracture, traumatic ischemia of muscle, Traumatic rhabdomyolysis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T797', 'Traumatic subcutaneous emphysema')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T798', 'Other early complications of trauma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T799', 'Unspecified early complication of trauma')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T80', 'Complications following infusion, transfusion and therapeutic injection  (Includes:  Perfusion, air embolism, infection, sepsis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T81', 'Complications of procedures, not elsewhere classified  (Includes: Hemorrhage, hematoma, shock complicating a procedure, wound dehiscence, wound infection)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T82', 'Complications of cardiac and vascular prosthetic devices, implants and grafts')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T83', 'Complications of genitourinary prosthetic devices, implants and grafts')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T84', 'Complications of internal orthopaedic prosthetic devices, implants and grafts (Includes: Other complications of internal orthopedic prosthetic devices, implants and grafts (e.g. pain, embolism, fibrosis, haemorrhage, stenosis, thrombosis) (See also T84.0-T84.6)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T840', 'Mechanical complication of internal joint prosthesis  (Includes: breakdown,  displacement,  malposition,  protrusion)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T842', 'Mechanical complication of internal fixation device of other bones')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T845', 'Infection and inflammatory reaction due to internal joint prosthesis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T846', 'Infection and inflammatory reaction due to internal fixation device [any site]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T85', 'Complications of other internal prosthetic devices, implants and grafts')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T86', 'Failure and rejection of transplanted organs and tissues')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T870', 'Complications of reattached (part of) upper extremity')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T871', 'Complications of reattached (part of) lower extremity')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T872', 'Complications of other reattached body part')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T873', 'Neuroma of amputation stump')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T874', 'Infection of amputation stump')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T875', 'Necrosis of amputation stump')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T876', 'Other and unspecified complications of amputation stump')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T88', 'Other complications of surgical and medical care, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T886', 'Anaphylactic shock due to adverse effect of correct drug or medicament properly administered')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T887', 'Unspecified adverse effect of drug or medicament ')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T900', 'Sequelae of superficial injury of head')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T901', 'Sequelae of open wound of head')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T902', 'Sequelae of fracture of skull and facial bones')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T903', 'Sequelae of injury of cranial nerves')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T904', 'Sequelae of injury of eye and orbit')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T905', 'Sequelae of intracranial injury')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T908', 'Sequelae of other specified injuries of head')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T909', 'Sequelae of unspecified injury of head')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T911', 'Sequelae of fracture of spine')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T912', 'Sequelae of other fracture of thorax and pelvis')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T913', 'Sequelae of injury of spinal cord')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T918', 'Sequelae of other specified injuries of neck and trunk')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T921', 'Sequelae of fracture of arm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T922', 'Sequelae of fracture at wrist and hand level')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T923', 'Sequelae of dislocation, sprain and strain of upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T926', 'Sequelae of crushing injury and traumatic amputation of upper limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T931', 'Sequelae of fracture of femur')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T932', 'Sequelae of other fractures of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T933', 'Sequelae of dislocation, sprain and strain of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T936', 'Sequelae of crushing injury and traumatic amputation of lower limb')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T941', 'Sequelae of injuries, not specified by body region')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('T983', 'Sequelae of complications of surgical and medical care, not elsewhere classified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('X44', 'Accidental poisoning by and exposure to other and unspecified drugs, medicaments and biological substances (prescription) (overdoses).  (Includes:  Medicinal substances used to treat illness). (Note: These medicinal substances can be those prescribed by a physician, but taken incorrectly by the patient, or medicinal substances that are not prescription and are taken incorrectly by the patient.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('X49', 'Accidental poisoning by and exposure to other and unspecified chemicals and noxious substances (Excludes:  Medicinal substances (X44))  (Includes:  All other chemical substances such as soap, paint, glue, cleaning fluids, dyes, etc.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('X64', 'Intentional self-poisoning by and exposure to other and unspecified drugs, medicaments and biological substances. Intentional self harm (overdose) or suicide attempt (prescription)  (Includes:  Medicinal substances used to treat illness)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('X69', 'Intentional self-poisoning by and exposure to other and unspecified chemicals and noxious substances. Intentional self harm (overdose) or suicide (non prescription) (Excludes:  Medicinal substances (X64))  (Includes:  All other chemical substances such as soap, paint, glue, cleaning fluids, dyes, etc.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U04', 'Severe acute respiratory syndrome [SARS]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U071', 'Emergency use of U07.1 (Note: COVID-19, virus identified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U072', 'Emergency use of U07.2 (Note: COVID-19, virus not identified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U073', 'Emergency use of U07.3 (Note: Multisystem inflammatory syndrome associated with COVID-19)  (Includes the following when associated with COVID-19: Cytokine storm, Kawasaki-like syndrome, paediatric inflammatory multisystem syndrome (PIMS) and multisystem inflammatory syndrome in children (MIS-C)) (Excludes: Mucocutaneous lymph node syndrome [Kawasaki] (M30))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U074', 'Emergency use of U07.4 (Note: Post COVID-19 condition)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U075', 'Emergency use of U07.5 (Note: Personal history of COVID-19)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U82', 'Resistance to betalactam antibiotics (Includes: Resistance to: penicillin, methicillin MRSA, carbapenem, ESBL and other betalactam antibiotics)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U83', 'Resistance to other antibiotics (Includes:  VRE, quinolones)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U837', 'Resistance to multiple antibiotics only')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U838', 'Resistance to other single specified antibiotic')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('U839', 'Resistance to unspecified antibiotic')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z21', 'Asymptomatic human immunodeficiency virus [HIV] infection status  (Includes:  HIV positive NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z2230', 'Carrier of drug-resistant micro-organism (Includes: Drug resistant: Staphylococcus, streptococcus, enterococcus, Clostridium difficile, Escherichia coli, other and unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z290', 'Isolation (Note: Isolation of individual after contact with infectious disease.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z34', 'Supervision of normal pregnancy')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z39', 'Postpartum care and examination  (Note:  The postpartum period is defined as the first 42 days after birth of the infant.)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z430', 'Attention to tracheostomy (Excludes:  Artificial opening status only, without need for care (Z93.-))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z434', 'Attention to other artificial openings of digestive tract (Excludes:  Artificial opening status only, without need for care (Z93.-))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z435', 'Attention to cystostomy (Excludes:  Artificial opening status only, without need for care (Z93.-))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z436', 'Attention to other artificial openings of urinary tract  (Includes: Nephrostomy, ureterostomy, and urethrostomy) (Excludes:  Artificial opening status only, without need for care (Z93.-))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z439', 'Attention to unspecified artificial opening  (Includes: Attention to other specified artificial opening NEC, closure, removal of catheter, takedown stoma, toilet or cleansing). (Excludes: Artificial opening status only, without need for care (Z93.-))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z44', 'Fitting and adjustment of external prosthetic device')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z510', 'Radiotherapy session')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z511', 'Chemotherapy session for neoplasm')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z513', 'Blood transfusion (without reporteddiagnosis)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z515', 'Palliative care')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z720', 'Tobacco use')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z721', 'Alcohol use')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z722', 'Drug  use')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z890', 'Acquired absence of finger(s) [including thumb], unilateral')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z891', 'Acquired absence of hand and wrist')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z892', 'Acquired absence of upper limb above wrist  (Includes:  Arm NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z893', 'Acquired absence of both upper limbs [any level]  (Includes:  Acquired absence of finger(s), bilateral)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z894', 'Acquired absence of foot and ankle  (Includes:  Toe(s))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z895', 'Acquired absence of leg at or below knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z896', 'Acquired absence of leg above knee  (Includes:  Leg NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z897', 'Acquired absence of both lower limbs [any level, except toes alone]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z898', 'Acquired absence of upper and lower limbs [any level]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z899', 'Acquired absence of limb, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z902', 'Acquired absence of lung [part of]')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z903', 'Acquired absence of part of stomach   (Includes:  Postoperative or post-traumatic loss of body part NEC)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z904', 'Acquired absence of other parts of digestive tract   (Includes:  Postoperative or post-traumatic loss of body part NEC)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z915', 'Personal history of self-harm  (Includes:  Parasuicide, self-poisoning, suicide attempt)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z930', 'Tracheostomy status (See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z931', 'Gastrostomy status(See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z932', 'Ileostomy status (See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z933', 'Colostomy status ((See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z934', 'Other artificial openings of gastrointestinal tract status (See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z935', 'Cystostomy status (See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z936', 'Other artificial openings of urinary tract status  (Includes:  Nephrostomy, ureterostomy, urethrostomy) (See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z938', 'Other artificial opening status (See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z939', 'Artificial opening status, unspecified (See also Z43.-)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z940', 'Kidney transplant status')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z941', 'Heart transplant status')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z942', 'Lung transplant status')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z943', 'Heart and lungs transplant status')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z944', 'Liver transplant status')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z949', 'Transplanted organ and tissue status, unspecified  (Includes:  Other transplanted organ and tissue status,  bone marrow transplant status, intestine transplant status, pancreas transplant status, stem cell transplant status)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z9500', 'Presence of cardiac pacemaker')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z951', 'Presence of aortocoronary bypass graft')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z952', 'Presence of prosthetic heart valve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z953', 'Presence of xenogenic heart valve')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z954', 'Presence of other heart-valve replacement')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z955', 'Presence of coronary angioplasty implant and graft  (Includes:  Presence of coronary artery prosthesis, status following coronary angioplasty NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z958', 'Presence of other cardiac and vascular implants and grafts  (Includes:  Presence of intravascular prosthesis NEC, status following peripheral angioplasty NOS)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z959', 'Presence of cardiac and vascular implant and graft, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z960', 'Presence of urogenital implants')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z961', 'Presence of intraocular lens  (Includes: Pseudophakia)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z962', 'Presence of otological and audiological implants  (Includes:  Bone-conduction hearing device, Cochlear implant, eustachian tube stent, myringotomy tube(s), stapes replacement)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z963', 'Presence of artificial larynx')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z964', 'Presence of endocrine implants  (Includes:  Insulin pump)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z965', 'Presence of tooth-root and mandibular implants  (Includes:  Maxillary implant)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z9660', 'Presence of artificial hip  (Includes:  Hip joint replacement (partial)(total))')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z9661', 'Presence of artificial knee')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z9668', 'Presence of other orthopaedic joint implants   (Includes:  Finger-joint replacement, presence of other orthopedic joint implants)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z9669', 'Presence of orthopaedic joint implants unspecified  (Includes:  Presence of orthopedic joint implants unspecified)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z967', 'Presence of other bone and tendon implants  (Includes:  Skull plate)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z968', 'Presence of other specified functional implants')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z969', 'Presence of functional implant, unspecified')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z970', 'Presence of artificial eye')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z971', 'Presence of artificial limb (complete)(partial)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z972', 'Presence of dental prosthetic device (complete)(partial)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z973', 'Presence of spectacles and contact lenses')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z974', 'Presence of external hearing-aid')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z975', 'Presence of (intrauterine) contraceptive device')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z978', 'Presence of other specified devices')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z980', 'Intestinal bypass and anastomosis status')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z981', 'Arthrodesis status')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z982', 'Presence of cerebrospinal fluid drainage device  (Includes:  CSF shunt)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z988', 'Other specified postsurgical states')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z990', 'Dependence on aspirator')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z991', 'Dependence on respirator')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z992', 'Dependence on renal dialysis  (Includes:  Presence of arteriovenous shunt for dialysis, Renal dialysis status)')
GO
Insert into zzNRS_CA_2020(CIHIValue, UserDescription) values('Z998', 'Dependence on other enabling machines and devices')
GO
update a
set UserDescription = left(z.UserDescription, 255),
    DefaultDescription  = left(z.UserDescription, 255)
from zzNRS_CA_2020 z
    inner join [dbo].[ICD_DiagFileNRS] a on z.cihivalue = a.cihivalue
where a.DefaultDescription <> left(z.UserDescription, 255)
GO
select z.*, code = identity(int, 1, 1) into zzNRS_CA_2020_new
from zzNRS_CA_2020 z
    left join [dbo].[ICD_DiagFileNRS] a on z.cihivalue = a.cihivalue
where a.cihivalue is null 
order by z.CIHIValue
GO
declare @maxcode int
set @maxcode = isnull((select max(code) from ICD_DiagFileNRS), 0)
Insert into [dbo].[ICD_DiagFileNRS](Code, DisplayCode, UserDescription, DefaultDescription, ShortDescription, CIHIValue, ValidFrom, ValidTo, DiagnosisGender, AgeLow, AgeHigh, InterfaceIn, HospitalID, LUText)
select code + @maxcode, left(cihivalue, 3) + (case when len(z.cihivalue) > 3 then '.' + substring(cihivalue, 4, 10) else '' end),
left(UserDescription, 255), left(UserDescription, 255), left(UserDescription, 60), cihivalue,
'2020/04/01', '2099/03/31', 'A', 0, 130, cihivalue, 0, ''
from zzNRS_CA_2020_new z
GO
if exists (select * from information_schema.tables where table_name = 'zzNRS_CA_2020')
    drop table zzNRS_CA_2020
GO
if exists (select * from information_schema.tables where table_name = 'zzNRS_CA_2020_new')
    drop table zzNRS_CA_2020_new
GO
--2.x-1961
declare @province varchar(10)
declare @maxId int
set @province = (select top 1 p.cihivalue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @province = '5'
begin
    if not exists (select * from lu_institution_10 where cihivalue = '56968')
    begin
        set  @maxid = 91768
        if exists (select * from lu_institution_10 where code = @maxid)
        begin
            set @maxid = (select max(code) from lu_institution_10) + 1
            if isnull(@maxID, 0) < 500001 set @maxid = 500001
        end
        Insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
        select Code = @maxid, 
               DisplayCode = '56968', 
               UserDescription = 'HHS Alternate Health Facility', DefaultDescription = 'HHS Alternate Health Facility', 
               CIHIValue = '56968', ValidFrom = '2020/04/01', ValidTo = '2099/03/31', InterfaceIn = '56968', 
               InstCareType = 'A', HospitalType = 'AT', IsAcute = 1, HospitalID = 0, LUText = '', InstitutionType = '1'
    end
    else
        update [dbo].[LU_Institution_10]
        set InstCareType = 'A', HospitalType = 'AT', IsAcute = 1, InstitutionType = '1'
        where CIHIValue = '56968'
end 
GO
if not exists (select *from [dbo].[LU_Institution_Type] where InstitutionNumber = '56968')
    insert into [dbo].[LU_Institution_Type](Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD)
    select 'ON', '56968', '1', 'Acute inpatient care', 'HHS Alternate Health Facility ', '1'
GO

--2.x-1926 
Update ICD_DiagFile10 set MRDxFlag = 'N', TypeCode = '3' where cihivalue = 'U075'
GO
Update ICD_diagFile10
set UserDescription = 'Vaping-related disorder',
    DefaultDescription = 'Vaping-related disorder',
    ShortDescription = 'Vaping related disorder' 
where code < 500000 and cihivalue = 'U070'
GO
Update ICD_diagFile10
set UserDescription = 'Coronavirus disease 2019 [COVID-19], virus identified',
    DefaultDescription = 'Coronavirus disease 2019 [COVID-19], virus identified',
    ShortDescription = 'COVID-19 virus identified' 
where code < 500000 and cihivalue = 'U071'
GO
Update ICD_diagFile10
set UserDescription = 'Coronavirus disease 2019 [COVID-19], virus not identified',
    DefaultDescription = 'Coronavirus disease 2019 [COVID-19], virus not identified',
    ShortDescription = 'COVID-19 virus not identified' 
where code < 500000 and cihivalue = 'U072'
GO
Update ICD_diagFile10
set UserDescription = 'Multisystem inflammatory syndrome associated with COVID-19',
    DefaultDescription = 'Multisystem inflammatory syndrome associated with COVID-19',
    ShortDescription = 'Multisys inflam syndr assoc w COVID-19' 
where code < 500000 and cihivalue = 'U073'
GO
Update ICD_diagFile10
set UserDescription = 'Post COVID-19 condition',
    DefaultDescription = 'Post COVID-19 condition',
    ShortDescription = 'Post COVID-19 cond' 
where code < 500000 and cihivalue = 'U074'
GO
Update ICD_diagFile10
set UserDescription = 'Personal history of COVID-19',
    DefaultDescription = 'Personal history of COVID-19',
    ShortDescription = 'Personal hx COVID-19' 
where code < 500000 and cihivalue = 'U075'
GO
--2.x-1956 
delete from [dbo].[M_AmcareErrors] where [BatchYear] = 2021
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear])
select [ErrorNumber], [ErrorDescription], [IsError], [BatchYear] = 2021
from M_AmcareErrors 
where BatchYear = 2020
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('4454', 'Main Problem A00-T98 with Main Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('4455', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45a50 ', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45a51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45a52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45b50 ', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45b51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45b52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45c50 ', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45c51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45c52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45d50 ', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45d51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45d52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45e50', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45e51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45e52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45f50', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45f51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45f52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45g50', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45g51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45g52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45h50', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45h51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45h52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45i50', 'Main/Other Problem A00-T98 with Main/Other Problem Prefix 7 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45i51', 'Other Problem U074 is mandatory', 1, 2021)
GO
insert into [dbo].[M_AmcareErrors] ([ErrorNumber], [ErrorDescription], [IsError], [BatchYear]) values('45i52', 'Other Problem A00-T98 with Other Problem Prefix 7 is mandatory', 1, 2021)
GO
--2.x-1958 
if exists (select * from information_schema.tables where table_name = 'zz2021DADError')
    drop table zz2021DADError
GO
create table dbo.zz2021DADError(
	IsError	varchar(500) COLLATE Latin1_General_CI_AS,
    Groupnumber	varchar(500) COLLATE Latin1_General_CI_AS,
    Fieldnumber	varchar(500) COLLATE Latin1_General_CI_AS,
    Errornumber	varchar(500) COLLATE Latin1_General_CI_AS,
    Englisherror	varchar(500) COLLATE Latin1_General_CI_AS,
    Frencherror	varchar(500) COLLATE Latin1_General_CI_AS,
    Associatedfile varchar(500) COLLATE Latin1_General_CI_AS
)
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','09','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','10','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','10','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','12','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','12','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','12','51','CHART NO = MATERNAL/NEWBORN CHART','NO DOS. = DOSSIER MERE/NOUVEAU-N')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','02','02','51','UNABLE TO CALCULATE L O S','INCAPABLE DE CALCULER  D S J')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','02','02','55','CALC LOS LT TOTAL SERV TRANSFER DAYS','DSJ CALC. < TOTAL JRS DE TRANSF.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','02','02','58','LOS > 365 DAYS IN ACUTE INST','DDS > 365 JRS ETABL COURTE DUREE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','02','02','59','LOS > 4999 DAYS IN CHRONIC/REHAB','DDS > 4999 JOURS EN SOINS PROL/READ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','02','02','60','LOS > 99 HOURS IN SDS INST','DS > 99 HEURES EN TABLISSEMENT CDJ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','09','INVALID HEALTH CARE NUMBER','NO. ASS. MALADIE INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','52','INVALID FORMAT FOR OTHER PROV HCN','FORMAT INVALIDE - AUTRE NAM PROV')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','54','HEALTH CARE NUMBER NOT FOR A NEWBORN','NO. ASS. MALADIE NON POUR N-NE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','63','HEALTH CARE # MISMATCH - BIRTHDATE','DATE NAISS INCOMPATIBLE AV # ASS.MAL.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','64','HEALTH CARE # MISMATCH - SEX','SEXE INCOMPATIBLE AVEC NO. ASS. MAL.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','03','01','65','HEALTH CARE # MISMATCH EFFECT. DATE','DATE EN VIGEUR INCOMP.AVEC # ASS.MAL.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','01','67','HEALTH CARE # MISMATCH-SEX/BIRTH YYMM','SEXE/NAIS AAMM INCOMP. AVEC # ASS.MAL')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','02','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','02','11','ALPHA FIELD INCORRECTLY CODED','ZONE ALPHA CODEE INCORRECTEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','02','51','MINI POSTAL CODE IS INVALID','CODE POSTALE MINI EST HORS DE PORTEE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','03','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','04','51','GENDER U BUT ENTRY NOT STILLBORN','SEXE U, SANS ENTREE MORT-NE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','05','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','06','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','08','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','08','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','08','53','ADMIT DATE PRIOR TO BIRTHDATE','DATE ADM. ANTERIEURE DATE NAIS. ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','08','54','BIRTH DATE MUST EQUAL ADMIT DATE','DATE NAIS. DOIT ETRE EGALE DATE ADM.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','11','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','11','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','11','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','11','56','PSYC/ALC UNIT CODED, NO CORR. DX','SERV. PSYC/ANS CODE SANS DX CORR.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','12','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','12','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','12','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','14','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','14','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','15','51','INVALID HIA 14 FLAG','INDICATEUR HIA 14 INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','16','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','20','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','20','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','20','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','21','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','21','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','21','51','DAYS ON SECOND RFP > CALC LOS','JOURS EN SECOND RDP > DSJ CALC.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','22','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','23','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','26','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','28','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','29','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','29','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','29','52','WEIGHT MISSING FOR NB OR AGE < 29 DAY','POIDS MANQ., NOUV-NE OU < 29 JOURS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','03','29','53','INAPPROPRIATE WEIGHT FOR NB/NEONATE','POIDS INAPPROPRIE POUR UN NOUVEAU-NE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','03','29','54','INCONSISTENT WEIGHT/GESTATIONAL AGE','POIDS ET AGE GESTATIONNEL INCOMPAT.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','03','29','57','LOW BIRTHWT NEONATE, NO P07 DIAG','N-NE FAIBLE POIDS SANS DIAG P07')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','01','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','01','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','01','51','SB, ADMIT DATE NOT IN CURRENT PERIOD','M.N., DATE ADM. INEXACTE PR PERIODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','01','52','ADMIT DATE GT CURRENT PERIOD','DATE ADM. > PERIODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','01','53','ADMIT DATE PRIOR TO BIRTHDATE','DATE ADM. ANTERIEURE DATE NAIS.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','01','54','ADMIT DATE MUST EQUAL BIRTHDATE','DATE ADM. DOIT ETRE EGALE DATE NAIS.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','04','21','INVALID HOSPITAL NUMBER','NO  D ETABLISSEMENT INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','04','51','INST FROM CODED, ENTRY CODE N','ETAB. DE PROV. COD., CODE D ENTREE N')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','04','53','XFER FROM INVALID WITH SERV 54 OR 89','PROV DE TRANSF NON VALID SERV 54, 89')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','05','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','04','05','51','UNPLAN. READMIT WITH ELECTIVE ADMIT','READM NON PLANIFIE AVEC ADM ELECTIVE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','05','52','ADMIT CAT. N INCONSISTENT WITH AGE','CAT.ADM EST INCONSISTENT AVEC AGE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','06','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','06','51','ENTRY CODE NOT E,ED DATES CODED','CODE D ENTREE PAS E, DATES URG INS.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','07','51','ADMIT VIA AMBULANCE,ENTRY CODE N OR S','ADM. PAR AMBUL., CODE D ENTREE N OU S')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','08','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','13','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','04','13','04','QUESTIONABLE DATA','DONNEE QUESTIONABLES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','13','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','13','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','13','17','INVALID DATE AND TIME','DATE ET HEURE INVALIDES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','13','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','14','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','14','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','04','15','54','EXCESSIVE WAIT TIME IN ED > 720 HRS','TEMPS ATT EXCESSIF A L URG > 720 H')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','04','15','55','WAIT TIME IN ED > 168 HRS,  < 720 HRS','TEMPS ATT A L URG > 168 H, < 720 H')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','01','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','01','51','DISCHG DATE INVALID FOR THIS PERIOD','DATE SORT. INEXACTE PR PERIODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','01','52','DISCHARGE DATE PRIOR TO ADMIT DATE','DATE SORT. ANTERIEURE DATE ADM.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','02','51','DISCHARGE HOUR PRIOR TO ADMIT HOUR','HRE SORT. INF. HRE ADM.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','04','21','INVALID HOSPITAL NUMBER','NO  D ETABLISSEMENT INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','04','51','INST TO - INVALID WITH DISCHARGE DISP','DEST. - INEXACTE AV. CODE DECES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','05','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','07','01','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','13','SERVICE NUMBER INVALID','NUMERO DE SERVICE INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','51','PAT.SERV. OBS/GYN, BUT GENDER MALE','SERV  PAT OBS/GYN MAIS SEXE MASC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','52','AGE INCONSISTENT WITH PATIENT SERVICE','AGE INCOMPATIBLE AVEC SERV. PT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','54','PATIENT SERVICE 54 BUT AGE > 1 DAY','SERVICE PATIENT 54 MAIS AGE > 1 JOUR')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','55','PATIENT SERV 54 BUT ENTRY CODE NOT N','SERV. PAT. 54, CODE ENT. N EST PAS N')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','01','56','ADMIT CAT N BUT PATIENT SERV NOT 54','CAT. ADM. N, SERV. PAT N EST PAS 54')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','07','01','57','AGE QUESTIONABLE WITH PATIENT SERVICE','AGE SUSPECT POUR CE SERVICE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','07','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','00','51','SERV XFER INVALID WITH PT SERV 99','SV TRANS NON VAL. AVEC SV PT 99')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','08','01','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','01','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','08','01','51','PATIENT SERV AND XFER SERV NOT DIFF','SERV.PT. ET SERV.TRANSF. IDENTIQUES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','01','54','TRANSFER SERVICE 54 BUT AGE > 1 DAY','SERVICE TRANSFERT 54, AGE > 1 JOUR')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','01','55','INCORRECT USE OF PATIENT SERVICE 99','UTILISATION ERRORNEE SERV. PATIENT 99')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','01','56','XFR.SERV. OBS/GYN, BUT GENDER MALE','TRANSF SERV OBS/GYN MAIS SEXE MASC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','01','57','AGE AND XFER SERV INCOMPAT.','AGE ET SERV DE TRANSF INCOMPAT.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','03','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','08','03','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','09','00','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','09','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','09','01','52','DUPLICATE SERV XFER PROVIDER TYPES','TYPE MD EN DOUBLE PR TRANSFERT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','09','01','60','XFER PROVIDER CODED,NO CORRESP XFER','DISP. TRANS. INS., PAS TRANS. CORR.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','09','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','09','02','51','PROVIDER/SERV NOT IN MOH DOCTOR TABLE','MED/SERV NON INCLUS DANS TABLE MSSC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','09','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','51','TYPE 9 DX MISSING, S OR T DX CODED','CODE 9 ABSENT, DX S OU T')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','52','PLACE OF OCCURRENCE DX REQUIRED','LIEU EVENEMENT DIAG REQUIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','54','INCORRECT CODING E10/E11/E13/E14','CODIFIC. INCORR. E10/E11/E13/E14')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','00','60','INCORRECT CODING OF K92.0 -K92.2','CODIFICATION INCORR. K92.0 - K92.2')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','00','62','INCORRECT CODING OF E86.0 DEHYDRATION','CODIFICATION INCORRECTE E86.0')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','00','63','INVALID COMBINATION OF OBS 6TH DIGITS','COMBINAISON INV. SIXIEME CARAC. OBS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','64','T20-T25,T29 CODED, T31 OR T32 MISSING','CODE T20-T25,T29 SANS CODE T31 OU T32')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','00','65','R40.29 CODED WITH E10 - E14','CODE R40.29 INSCRIT AVED E10 - E14')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','00','66','INVALID COMB. O75.071/O66.401/O34.201','COMB. INV. O75.071/O66.401/O34.201')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','67','MULTIPLE J44 COPD DIAGNOSES','DIAGNOSTICS MULTIPLES DE J44 BPCO')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','68','MULTIPLE S02.6 DIAGNOSES','DIAGNOSTICS MULTIPLES DE S02.6')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','69','MULTIPLE T31 DIAGNOSES','DIAGNOSTICS MULTIPLES DE T31')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','70','MULTIPLE T32 DIAGNOSES','DIAGNOSTICS MULTIPLES DE T32')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','71','INCORRECT CODING OF I50/J81','CODIFICATION INCORR. DE I50/J81')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','73','INCORRECT CODING OF E15','CODIFICATION INCORR. DE E15')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','78','I21,I22 OR I240 BUT NO R943 CODED','I21,I22 OU I240 INSCRIT,MAIS PAS R943')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','79','INCORRECT CODING OF P700/P701/P704','CODIF. INC. DE P700, P701, P704')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','00','80','R9430/R9431,NO I21,I22 OR I240 CODED','R9430/R9431,MAIS PAS I21,I22 OU I240')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','01','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','01','51','DIAG PREFIX CODED BUT NO DIAG CODE','PREF. DX CODE SANS CODE DX')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','01','52','DISCHG DISP & DX PREFIX C INCOMPAT.','ETAT SORTIE & PREF. DIAG C INCOMPAT.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','01','53','DX PREFIX AND TYPE INCOMPAT.','PRFIXE ET TYPE DIAG. INCOMPAT.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','01','54','DX PREFIX 5/6/J REQUIRED W INTERV','PRFIXE 5, 6 OU J DU DX REQUIS INTERV ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','01','55','DX PREFIX 5/6 INVALID, NO INTERV','PRFIXE 5 OU 6 DU DX INV. SANS INTERV  ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','07','INVALID ICD10-CA CODE','CODE CIM-10-CA INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','51','DIAGNOSIS NOT VALID AS PRIMARY DX','DIAGNOSTIC PRINCIPAL INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','52','DIAGNOSIS NOT CONSISTENT WITH GENDER','DX INCOMPATIBLE AV. SEXE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','53','DIAGNOSIS NOT CONSISTENT WITH AGE','DX INCOMPATIBLE AV. AGE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','54','DIAG FOR NEWBORN BUT ADMIT CAT  NOT N','DX NOUV-NE, CODE ENTREE PAS N.N.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','55','DIAGNOSIS NOT VALID AS TYPE 6','DIAGNOSTIC INVALIDE COMME TYPE 6')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','56','DIAGNOSIS NOT VALID AS TYPE 9','DIAGNOSTIC INVALIDE COMME TYPE 9')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','57','INCORRECT CODING OF Z370 - Z3791','CODIF. Z370 - Z3791 DX INCORRECTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','59','INCORRECT CODING OF Z38','CODIFICATION Z38 INCORRECTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','60','DEATH WITH ONLY ABORTION/OBS DX CODED','DECES AVEC SEUL. DIAG. AVORT./OBS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','61','SKULL FRACTURE/INTRACRANIAL MISCODED','CODIF INCOR FX CRAN/LESION INTRACRAN')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','02','62','SB DX BUT ENTRY CODE NOT SB','DX M.N. CODE ENTREE PAS M.N.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','63','DEATH DX BUT DEATH NOT CODED','DX DECES SANS CODE DECES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','64','ADMIT DX SAME AS MRDX','DIAG ADM MEME QUE DIAG PRINC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','02','65','ADDITIONAL DX CODE MAY BE REQUIRED','AUTRE CODE DE DIAG PEUT ETRE REQUIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','67','INVALID  CODING AS MR. DX','DX PRINC. INCORRECTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','70','ENTRY CODE N BUT DX BORN OUT OF HOSP','CODE D ENTREE N, DIAG NAISS HORS HOP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','02','74','SECONDARY NEOPLASM CODED, NO PRIMARY','NEOPLASME SECOND CODEE,PAS DE PRIM.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','78','MR DX REJECTED DUE TO ACUTE LOS = 0','DX PRINC REJETE PARCE QUE DDS = 0')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','79','NO MANIFESTATION FOR HIV DISEASE RECD','AUCUNE MANIFEST. DE VIH EST MENTIONNE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','81','DIAGNOSIS MUST BE TYPE 3','DIAGNOSTIC DOIT ETRE TYPE 3')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','82','DIAGNOSIS MUST BE TYPE 3 OR 6','DIAGNOSTIC DOIT ETRE TYPE 3 OU 6')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','02','83','DIAG USUALLY USED WITH AGE LT 29 DAYS','DIAG HABIT UTIL AVEC AGE MS DE 29 JRS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','85','DIAGNOSIS & CADAVER INCOMPATIBLE','DIAGNOSTIC & CADAVRE INCOMPATIBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','86','OBS DELIVERED NEEDS TYPE 3 Z37 DX','ACCOU. OBS EXIGE TYPE 3 DIAG. Z37')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','87','ADMIT CAT NEWBORN NEEDS Z38 DX','CAT. ADMIS. N.-NE EXIGE DIAG. Z38')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','88','B24 CODED WITH INFECT.DISEASE MRDX','B24 CODIF.AV.DIAG PRINC MALADIE INFEC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','89','R75/Z21 CODED WITH B24','R75/Z21 CODIFIE AVEC B24')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','90','R73.0/R73.9 CODED WITH E10 - E14','R73.0/R73.9 CODIFIE AVEC E10 - E14')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','02','91','DIABETES NO COMP WITH OTHER COMP.','DIABETES SANS COMP ET AVEC AUTRE COMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','02','92','TIA INVALID WITH STROKE','AITC INVALIDE AVEC AVC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','93','BOTH ACUTE AND CHRONIC CONDITIONS','PROB. AIGUS ET CHRONIQUES CODIFIES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','94','OTHER DISEASES WITH COPD','AUTRE MALADIE AVEC BPCO')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','95','OTH.RESP.PROBLEM WITH ADULT RESP.DIS','AUT.PROB RESP AVEC DET RESP ADULTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','02','97','MRDX/INTERVENTION MISMATCH','DIAG.RESPONS. ET INTERV. INCOHERENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','02','98','6TH DIGIT NOT 9 WHEN MRDX O00-O08','6E CARAC ET NON 9 & DX PRINC O00-O08')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','03','52','DIAGNOSIS CLUSTER MANDATORY','INDICATEUR DE SRIE OBLIGATOIRE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','03','53','DIAG CLUSTER CODED BUT NO DIAG CODE','GR DIAG CODIFIE, AUCUN CODE DE DIAG')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','03','54','DIAG CLUSTER WITH NO ADDITIONAL DIAG','INDICATEUR DE SRIE SANS DIAG SUPP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','03','55','INVALID USE OF DIAG CLUSTER','ATTRIBUTION INV DE IND. DE SRIE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','03','75','QUESTIONABLE DX CLUSTER','INDICATEUR DE SERIE SEMBLE INCORRECT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','51','DIAGNOSIS INVALID AS A TYPE 2','DIAG INVALIDE COMME TYPE 2')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','10','04','52','DIAGNOSIS QUESTIONABLE AS TYPE 3','DIAGNOSTIC DE TYPE 3 DOUTEUX')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','53','DIAG TYPE CODED BUT NO DIAGNOSIS CODE','TYPE DIAG INS. SANS CODE DIAGNOSTIC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','54','DIAGNOSIS INVALID AS TYPE 2 or 3','DIAGNOSTIC INVALIDE COMME TYPE 2 OU 3')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','59','XFER DIAG CODED, NO CORRESP. XFER','DIAG. TRANS. INS., PAS TRANS. CORR.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','60','DUPLICATE SERVICE XFER DIAG TYPES','TYPE DX DE TRANSF. EN DOUBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','61','INCORRECT TYPING  Z370 - Z377 OR Z379','TYPE INCORRECT POUR Z370-Z377 OU Z379')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','04','62','DX TYPE 6 MUST BE FOR SECOND DX ONLY','TYPE DIAG 6 SEUL POUR DIAG SEC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','07','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','10','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','10','11','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','00','51','PRINCIPAL INTERVENTION MISSING','TRAITEMENT PRINC. MANQUANT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','00','53','OBS DELIVERED,MISSING DELIVERY INTERV','ACCOU./OBS, SANS INTERV. ACCOUCHEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','01','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','01','17','INVALID DATE AND TIME','DATE ET HEURE INVALIDES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','01','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','01','52','DATE MISSING FROM PRIN INTERVENTION','DATE TRAIT. PRINC. MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','01','55','INTERVENTION MUST BE CODED','TRAIT. A CODER AVEC CETTE DONNEE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','02','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','31','INVALID CCI CODE','CODE CCI INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','51','INTERVENTION INCONSISTENT WITH GENDER','TRAITEMENT INCOMPATIBLE AVEC SEXE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','52','INTERVENTION INCONSISTENT WITH AGE','TRAITEMENT INCOMPATIBLE AVEC AGE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','53','INTERVENTION MISSING IN FIRST INTERV.','CODE TRAIT. PRINC. MANQUANT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','02','54','OTHER INTERVENTION USED FOR CMG','AUTRE CODE TRAIT. UTILISE ASSIG. GMA')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11  ','02','56','INTERVENTION INCONSISTENT WITH DX CODE','INTERV. ET CODE DIAGN. NON CORRESP.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','57','INTERVENTION INVALID FOR NON SDS','INTERVENTION INVALIDE, PAS CDJ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','02','58','INCORR.CODING 1SC74/75,1SC80/89','CODIF.INCORR.1SC74/75,1SC80/89')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','59','LOC.ATTRIBUTE ERROR FOR 1SY80','ERREUR ATTRIBUT LIEU POUR 1SY80')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','60','DELIVERY INTERV WITH POST PARTUM DIAG','INTERV.D ACOU. AVEC DIAG. POSTPARTUM')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','02','64','NON OBSTETRICAL INTERV WITH MRDX O00','INTERV NON OBST ET DX PRINC O00')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','65','INDUC. LABOUR WITH TERM. OF PREGNANCY','COD. DECLENCH. TRAVAIL ET AVORTEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','02','66','MISSING CORRESP.REPAIR INTERV. CODE','CODE DINTERV. RPAR. CORR. MANQUANT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','02','67','VAGINAL DELIVERY WITH O34201 DX','ACCOUCHEMENT VAGINAL DIAG O34201')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11 ','02','68','INVALID CCI CODE AS PRE ADMIT','CODE CCI INV POUR INTERV. AV. ADM.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','03','32','INVALID CCI/STATUS COMBINATION','COMBINAISON CCI/SITUATION INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','03','51','STATUS A INVALID ON PRINC INTERV','SITUATION A INVALIDE POUR INTERV.PRIN')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','04','33','INVALID CCI/LOCATION COMBINATION','COMBINAISON CCI/LIEU INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','05','34','INVALID CCI/EXTENT COMBINATION','COMBINAISON CCI/ETENDUE INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','06','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','06','51','INTERV PROV/SERV NOT IN MOH TABLE','CHIRUR/SERV NON INCLUS DANS TBLE MSSC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','06','54','PROV AND SERV MISSING','NO MD ET SERV. MANQ. PR TRAIT.PRINC.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','06','56','NO CORR INTERVENTION OR PREV PROV/SRV','PAS DE TRAIT. OU MD-SERV. CORRESP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','06','57','DUPLICATE PROV/SERV FOR INTERVENTION','NO MD-SERV. DU TRAIT. EN DOUBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','10','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','10','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','11','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','11','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','11','51','ANAES. NOT IN MOH DOCTOR TABLE','ANESTH NON INCLUS DANS TABLE MSSC')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','11','58','NO CORR INTERVENTION OR PREV ANAESTH','AUCUN TRAIT. CORRESP. OU ANESTH. ANT.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','11','59','DUPLICATE ANAESTHETIST FOR INTERVENT.','ANESTHESISTE EN DOUBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','12','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','12','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','12','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','12','51','INVALID ANAES TECHNIQUE WITH OOH','TECH ANES INVALIDE AVEC INDIC HH')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','12','52','INVALID USE OF ANAES TECHNIQUE 0','MAUVAISE UTILI TECH ANES 0')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','12','59','NO CORR INTERVENTION OR PREV TECHNIQ','AUCUN TRAIT. CORRESP. OU NB FOIS ANT.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','13','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','13','52','OOH INDICATOR INVALID WITH SDS','INDICATEUR HH INVALIDE AVEC CDJ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','14','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','14','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','14','52','INVALID INST FOR OUT/INTERVENTION','ETABL. INEXACT POUR INTER. CLIN. EXT.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','15','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','15','51','UNPLANNED RETURN, NO PREV EPISODE','RETOUR IMPREVU, AUC. EPIS. PRECEDENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','16','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','16','51','DTH DUR INTERV, DISCH DISP NOT DIED','DCS INTERV AVEC CODE DE SORTIE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','16','52','DTH DUR INTERV BUT NO INTERVENTIONS',' DCS INTERV SANS CODE INTERV ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','17','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','17','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','17','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','17','55','INTERVENTION MUST BE CODED','TRAIT. A CODER AVEC CETTE DONNEE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','18','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','18','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','18','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','18','17','INVALID DATE AND TIME','DATE ET HEURE INVALIDES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','18','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','18','55','INTERVENTION MUST BE CODED','TRAIT. A CODER AVEC CETTE DONNEE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','19','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','19','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','19','55','INTERVENTION MUST BE CODED','TRAIT. A CODER AVEC CETTE DONNEE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','20','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','21','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','11','21','51','EPISODE DURATION SHOULD BE < 1440 MIN','DUR EPISODE DEVRAIT ETRE < 1440 MIN')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','22','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','22','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','23','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','11','23','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','00','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','01','51','SCU DEATH BUT DISCHG DISP NOT DIED','DECES U.S.S. AVEC CODE DE SORTIE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','01','52','SCU DEATH CODED BUT NO SC UNIT','DECES U.S.S. SANS UNITE DE SOINS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','02','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','02','51','INCONSISTENT CODING, SCU 50,51,52,53','INCOHERENT CODAGE DE USS 50,51,52,53')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','03','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','03','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','03','17','INVALID DATE AND TIME','DATE ET HEURE INVALIDES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','03','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','04','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','05','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','05','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','05','17','INVALID DATE AND TIME','DATE ET HEURE INVALIDES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','05','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','06','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','13','09','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','10','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','11','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','12','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','13','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','14','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','15','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','16','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','17','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','18','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','14','19','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','10','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','10','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','15','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','16','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','17','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','17','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','18','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','15','18','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','00','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','00','51','REPRODUCTIVE CARE PROJ MISSING (311)','SOINS REPINATALS MANQUANTS (311)')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','00','52','REPRODUCTIVE CARE PROJ INVALID (311)','SOINS REPINATALS INVALIDE  (311)')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','00','57','COMPULS. PSYCH PROJ MISSING (303,306)','ETUDE OBLIG PSYCH MANQUANTE (303,306)')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','00','61','PROJECT 100 MANDATORY','ETUDE OBLIG MANQUANTE (100)')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','01','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','01','70','MISSING INTERVENTION LINE NUMBER','NUMERO LIGNE INTERVENTION NON INSCRIT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','01','71','INVALID INTERVENTION LINE NUMBER','NUMERO LIGNE INTERVENTION INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','01','72','NO CORRESPONDING INTERV CODE','AUCUN CODE INTERVENTION CORRESPONDANT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','02','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','03','70','REFERRAL RECEIVED DATE MISSING','DATE DU CHAMP REFERE A NON INSCRITE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','03','71','INVALID REFERRAL RECEIVED DATE','DATE DU CHAMP REFERE A INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','03','72','REFERRAL DATE > INTERV DATE','DATE ORIENTATION > DATE INTERVENTION')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','16','04','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','10','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','11','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','11','70','SEVERITY SCORE TYPE MISSING','TYPE INDICE DE SEVERITE NON INSCRIT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','11','71','INVALID SEVERITY SCORE TYPE','TYPE INDICE DE SEVERITE INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','12','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','12','70','SEVERITY SCORE NOT ALLOWED','MAUVAIS INDICE DE SEVERITE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','12','71','SEVERITY SCORE MISSING','INDICE DE SEVERITE INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','16','13','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','13','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','13','19','INVALID DATE','DATE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','14','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','14','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','15','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','16','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','16','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','16','21','INVALID HOSPITAL NUMBER','NO  D ETABLISSEMENT INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','16','70','INVALID DATE TYPE','INDICE DE DATE INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','16','71','CARDIAC CATH DATE/NOT CARDIAC SURGERY','DATE CATH.CARD,SANS CHIRURGIE CARDIAQ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','17','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','17','70','INVALID OTHER DATE','AUTRE DATE INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','17','71','OTHER DATE > INTERV DATE','AUTRE DATE > DATE INTERVENTION')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','16','17','72','OTHER DATE > 1 YR BEFORE INTERV','AUTRE DATE > 1 AN AVANT INTERVENTION')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','17','73','OTHER DATE NOT ALLOWED','AUTRE DATE NON PERMISE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','17','74','OTHER DATE REQUIRED','AUTRE DATE OBLIGATOIRE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','18','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','18','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','18','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','18','54','PSYCH PROJ DAYS > TOTAL LOS','JRS ETUDE PSYCH > TOTAL JRS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','19','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','20','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','21','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','21','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','21','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','21','54','PSYCH PROJ DAYS > TOTAL LOS','JRS ETUDE PSYCH > TOTAL JRS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','22','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','23','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','24','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','99','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','99','08','NOT VALID FOR THIS HOSPITAL','NON VALIDE POUR CET ETABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','99','50','INVALID PROV/PROJ NUMBER COMBINATION','COMBINAISON PROV/NO DE PROJ INVALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','16','99','51','DUPLICATE PROJECT NUMBER','NUMERO D ETUDE EN DOUBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','08','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','09','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','10','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','11','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','12','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','13','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','14','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','15','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','17','16','05','INVALID DATA','DONNEES INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','01','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','01','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','01','51','PREV TERM DELIV/AGE INCONSISTENCY','ACCOUCHEM ANT/INCONSISTANCE DS AGE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','02','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','02','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','02','51','PREV PRETERM DELIV/AGE INCONSISTENCY','AGE/ACCOU. PREMAT. PRECE. INCOHERENCE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','03','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','03','51','PREV SPONT ABORT/AGE INCONSISTENCY','AVORT SPONT ANT/INCONSISTANCE DS AGE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','03','52','MORE THAN 5 PREV SPONT ABORTIONS','PLUS DE 5 AVORT SPONT ANT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','03','53','PREV SPONT ABORT VAUE QUESTIONABLE','VALEUR DOUTEUSE FAUSS. COU. ANTE.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','04','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','04','51','PREV THER ABORT/AGE INCONSISTENCY','AVORT PROV ANT/INCONSISTANCE DS AGE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','04','52','MORE THAN 5 PREV THER ABORTIONS','PLUS DE 5 AVORT PROV ANT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','04','53','PREV THER ABORT VALUE QUESTIONABLE','VALEUR DOUTEUSE AVORT. THERA. PRECE.')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','05','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','05','51','PREV LIVE BIRTH VALUE QUESTIONABLE','VALEUR DOUTEUSE NAIS. VIVAN. ANTE .')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','18','06','04','QUESTIONABLE DATA','DONNEES SUSPECTES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','06','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','06','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','06','51','GESTATION WEEKS VALUE QUESTIONABLE','VALEUR SEM DE GESTATION DOUTEUSE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','07','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','08','01','INVALID YEAR, MONTH OR DAY','ANNEE, MOIS OU JOUR INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','08','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','08','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','09','10','DATA INAPPROPRIATE IN THIS FIELD','DONNEES INAPPROPRIEES POUR CE CHAMP')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','18','09','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','01','51','VENDOR MCC DIFFERS FROM CIHI','CCP FOURNISSEUR DIFFERENT ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','02','51','VENDOR CMG DIFFERS FROM CIHI','CMG FOURNISSEUR DIFFERENT ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','04','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','04','51','VENDOR CASE WEIGHT DIFFERS FROM CIHI','PONDERATION FOURNIS. DIFFERENTE ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','04','52','VENDOR CACS RIW DIFFERS FROM CIHI','PCR SGCA DU FOURNISSEUR DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','06','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','07','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','07','51','VENDOR AGE CATEGORY DIFFERS FROM CIHI','CAT AGE FOURNISSEUR DIFFERENTE ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','08','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','08','51','VENDOR COMORBIDITY DIFFERS FROM CIHI','COMORBIDITE FOURNISSUER DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','10','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','10','51','VENDOR EVENT COUNT DIFFERS FROM CIHI','NBRE EVENEMENT FOURNISSEUR DIFF ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','11','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','11','51','VENDOR OOH COUNT DIFFERS FROM CIHI','NBRE HH FOURNISSEUR DIFFERENT ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','12','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','12','51','VENDOR RIW ATYPICAL DIFFERS FROM CIHI','RIW ATYPIQUE FOURNISSEUR DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','13','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','13','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','13','51','VENDOR ELOS DAYS DIFFER FROM CIHI','JOURS DPDS FOURNISSEUR DIFFERENT ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','14','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','14','51','VENDOR RI LEVEL DIFFERS FROM CIHI','NIVEAU CONS RES FOURNISSEUR DIFF ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','15','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','15','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','20','51','VENDOR CACS DIFFERS FROM CIHI','SGCA DU FOURNISSEUR DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','21','51','VENDOR MAC DIFFERS FROM CIHI','GAP DU FOURNISSEUR DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','22','51','VENDOR CACS AGE CAT DIFFERS FROM CIHI','CAT AGE SGCA FOURNISSEUR DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','23','51','VENDOR CACS ANES DIFFERS FROM CIHI','ANES SGCA DU FORNISSEUR DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','24','51','VENDOR CACS TECH CNT DIFFER FROM CIHI','NB TECH SGCA FOURNISSEUR DIFFER ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','19','25','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('W','19','25','51','VENDOR FLAGGED INTERV STATUS DIFFERS','ETAT INTERV SIGNAL FOURNISS DIFF ICIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','00','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','02','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','02','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','03','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','04','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','04','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','05','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','05','50','INVALID CEMENT PRODUCT NUMBER','NUM PRODUIT CIMENT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','06','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','06','50','INVALID CEMENT LOT NUMBER','NUM LOT CIMENT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','07','02','INVALID COMPONENT AND STICKERS','COMPOSANT/INFO ETIQUETTES INVALIDES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','07','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','08','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','09','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','09','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','10','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','10','50','INVALID COMPONENT PRODUCT NUMBER','NUM PRODUIT COMPOSANT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20','11','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','20 ','11','50 ','INVALID COMPONENT LOT NUMBER','NUM LOT COMPOSANT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','99','99','15','ABSTRACT CONTAINS MORE THAN 15 ERRORS','ABREGE CONTIENT PLUS DE 15 ERREURS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','00','56','DUPLICATE FILE NAME','NOM DE FICHIER EN DOUBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','52','INSTITUTION NUMBER ON RECORD INCONSISTENT WITH INSTITUTION NUMBER IN FILE NAME','LE NUMRO D''TABLISSEMENT SUR L''ENREGISTREMENT NE CORRESPOND PAS  CELUI QUI FIGURE DANS LE NOM DU FICHIER')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','03','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','27','MORE THAN ONE RECORD FOR INST #','PLUS DUN ENREGISTREMENT POUR LE NUMRO DTABLISSEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','13','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','04','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','06','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','07','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','07','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','08','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','08','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','08','11','ALPHA FIELD INCORRECTLY CODED','ZONE ALPHA CODEE INCORRECTEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','09','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','11','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','12','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','12','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','13','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','13','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','13','11','ALPHA FIELD INCORRECTLY CODED','ZONE ALPHA CODEE INCORRECTEMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','14','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','15','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','15','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','25','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','16','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','17','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','18','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','18','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','26','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','19','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','19','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','20','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','20','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','21','16','COMPULSORY DATA MISSING','DONNEE OBLIGATOIRE MANQUANTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','21','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','22','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','23','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','25','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','26','06','NUMERIC FIELD INCORRECTLY CODED','CHAMP NUMERIQUE MAL CODE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','27','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','27','25','ONLY ALLOWED FOR PAEDIATRIC INST','AUTORIS UNIQUEMENT POUR LES TABLISSEMENTS PDIATRIQUES')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','28','03','CAN ONLY BE SUBMITTED BY ACUTE INST','NE PEUT TRE SOUMIS QUE PAR UN TABLISSEMENT DE SOINS DE COURTE DURE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','28','22','NACRS DS IS Y,DS INST NOT ALLOWED','CHIRURGIE DUN JOUR (SNISA) CORRESPOND  Y, TABLISSEMENT DE CHIRURGIE DUN JOUR NON AUTORIS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','28','21','INVALID HOSPITAL NUMBER','NO  D ETABLISSEMENT INEXACT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','29','05','INVALID DATA','DONNEE INEXACTE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','50','29','03','CAN ONLY BE SUBMITTED BY ACUTE INST','NE PEUT TRE SOUMIS QUE PAR UN TABLISSEMENT DE SOINS DE COURTE DURE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('','','','','','')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','50','ABSTRACT ALREADY EXISTS','LABRG EXISTE DJ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','51','ABSTRACT DOES NOT EXIST','LABRG NEXISTE PAS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','52','DUPLICATE CORRECTION','CORRECTION EN DOUBLE ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','53','DUPLICATE DELETION','SUPPRESSION EN DOUBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','55','CORRECTION REJECTED - WRONG CHART NUMBER','CORRECTION REJETE  MAUVAIS NUMRO DE DOSSIER')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','57','DELETION REJECTED - WRONG CHART NUMBER','SUPPRESSION REJETE  MAUVAIS NUMRO DE DOSSIER')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('','','','','','')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('','','','','','')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','00','42','RECORD SIZE IS INVALID','TAILLE DE LENREGISTREMENT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','00','56','DUPLICATE FILE NAME','NOM DE FICHIER EN DOUBLE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','25','INSTITUTION NUMBER IS NOT ON SUBMITTING INSTITUTION LIST','LE NUMRO DTABLISSEMENT NE FIGURE PAS SUR LA LISTE DES TABLISSEMENTS DCLARANTS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','26','UPDATED DAD INSTITUTION FILE HAS NOT BEEN SUBMITTED FOR CURRENT FISCAL YEAR','LA MISE  JOUR DU DOSSIER DTABLISSEMENT DE LA BDCP NA PAS T SOUMISE POUR LEXERCICE EN COURS')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','41','INSTITUTION NUMBER IS NOT THE SAME AS INSTITUTION NUMBER IN BATCH HEADER','LE NUMRO DTABLISSEMENT EST DIFFRENT DE CELUI QUI FIGURE DANS L''EN-TTE DE LOT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','01','51','INSTITUTION NUMBER ON BATCH HEADER IS NOT THE SAME AS NSTITUTION NUMBER IN FILE NAME','LE NUMRO DTABLISSEMENT DANS LEN-TTE DE LOT EST DIFFRENT DE CELUI QUI FIGURE DANS LE NOM DU FICHIER')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','02','35','BATCH COUNT IS INVALID','NOMBRE DABRGS DU LOT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','02','36','BATCH COUNT IS NOT 001 - 100 FOR A BATCH','LE NOMBRE DABRGS NE CORRESPOND PAS  UNE VALEUR DE 001  100 POUR LE LOTA')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','02','37','BATCH COUNT IS NOT 000 - 100 FOR B BATCH','LE NOMBRE DABRGS NE CORRESPOND PAS  UNE VALEUR DE 000  100 POUR LE LOTB')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','02','38','BATCH COUNT IS GREATER THAN 999 FOR CORRECTION/DELETION BATCH','LE NOMBRE DABRGS EST SUPRIEUR  999 POUR LOT DE CORRECTION/SUPPRESSION')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','02','45','BATCH OUT OF BALANCE - BATCH COUNT IN HEADER XXX, ABSTRACTS IN BATCH XXX','LOT NON CONFORME  NOMBRE DABRGS DU LOT DANS LEN-TTE XXX, ABRGS DANS LE LOT XXX')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','03','27','BATCH YEAR IS INVALID','ANNE DU LOT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','03','43','FISCAL YEAR IS NOT THE SAME AS FISCAL YEAR IN BATCH HEADER','LEXERCICE EST DIFFRENT DE CELUI QUI FIGURE DANS LEN-TTE DE LOT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','04','28','BATCH PERIOD IS INVALID','PRIODE DU LOT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','04','29','BATCH PERIOD IS 00 BUT NOT A CORRECTION/DELETION BATCH','LA PRIODE DU LOT CORRESPOND  00 MAIS IL NE SAGIT PAS DUN LOT DE CORRECTION/SUPPRESSION')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','04','30','BATCH PERIOD IS INVALID FOR PROVINCE','PRIODE DU LOT NON VALIDE POUR LA PROVINCE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','04','48','BATCH PERIOD IS NOT THE SAME AS BATCH PERIOD IN BATCH HEADER','LA PRIODE  DU LOT NE CORRESPOND PAS  CELLE QUI FIGURE DANS LEN-TTE DE LOT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','04','52','BATCH PERIOD ON BATCH HEADER IS NOT THE SAME AS BATCH PERIOD IN FILE NAME','LA PRIODE DU LOT DANS LEN-TTE DE LOT NE CORRESPOND PAS  CELLE QUI FIGURE DANS LE NOM DU FICHIER')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','05','31','BATCH NUMBER IS INVALID','NUMRO DU LOT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','05','32','BATCH NUMBER IS NOT 00 FOR CORRECTION/DELETION BATCH','LE NUMRO DU LOT NE CORRESPOND PAS  00 ET IL SAGIT DUN LOT DE CORRECTION/SUPPRESSION')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','05','33','BATCH NUMBER IS NOT 01 - 99 FOR ORIGINAL BATCH','LE NUMRO DU LOT NE CORRESPOND PAS  UNE VALEUR DE 01  99 POUR LE LOT DORIGINE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','05','49','BATCH NUMBER MUST BE 01 FOR NO SEP BATCH','LE NUMRO DU LOT DOIT TRE 01 POUR LOT AUCUNE SORTIE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','05','50','BATCH NUMBER INCONSISTENT WITH BATCH NUMBER IN BATCH HEADER','LE NUMRO DE LOT NE CORRESPOND PAS  CELUI QUI FIGURE DANS LEN-TTE DE LOT ')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','46','ABSTRACT NUMBER INVALID','NUMRO DABRG NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','47','ABSTRACT NUMBER XXX IS FOLLOWED BY ABSTRACT NUMBER XXX','LE  NUMRO DABRG XXX EST SUIVI DU NUMRO DABRG XXX')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','54','NO SEP FOR PREVIOUSLY SUBMITTED DATA','AUCUNE SORTIE POUR LES DONNES SOUMISES PRCDEMMENT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','06','58','BATCH ID IN BATCH HEADER IS INVALID','IDENTIFICATION DU LOT DANS L''EN-TTE DU LOT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','07','34','INVALID BATCH HEADER FORMAT','FORMAT DEN-TTE DE LOT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','07','44','RECORD ID IS INCONSISTENT WITH BATCH TYPE IN BATCH HEADER','TYPE DENREGISTREMENT INCOMPATIBLE AVEC TYPE DE LOT DANS EN-TTE DE LOT')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','20','39','BATCH TYPE IS INVALID','TYPE DE LOT NON VALIDE')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','20','55','BATCH TYPE IS INCONSISTENT WITHIN THE FILE','TYPE DE LOT INCOHRENT DANS LE FICHIER')
GO
insert into zz2021DADError(IsError,Groupnumber,Fieldnumber,Errornumber,Englisherror,Frencherror) values('E','01','21','40','DATE GENERATED IS INVALID','DATE GNRE NON VALIDE')
GO

delete from zz2021DADError where isnull(iserror, '') = ''
GO
Delete from [dbo].[M_DADErrors] where batchyear = 2021
GO
alter table zz2021DADError add code int identity(1, 1)
GO
Insert into [dbo].[M_DADErrors](BatchYear, ErrorNumber, EnglishDescription, FrenchDescription, IsError)
select BatchYear = 2021, d.ErrorNumber, z.Englisherror, z.Frencherror, IsError = (case when z.IsError = 'W' then 0 else 1 end)
from 
(select ErrorNumber = IsError + Groupnumber + Fieldnumber + isnull(Errornumber, ''), count(*) cc, min(code) mincode
from zz2021DADError
where Englisherror is not null
group by  IsError + Groupnumber + Fieldnumber + isnull(Errornumber, '')
) d
inner join zz2021DADError z on d.mincode = z.code 
GO

if exists (select * from information_schema.tables where table_name = 'zz2021DADError')
    drop table zz2021DADError
GO
delete from [dbo].[SU_StructureList]
where batchyear = 2021
GO
insert into [dbo].[SU_StructureList](SU_type, Province, AppID, BatchYear, GroupID, GroupOrder, GroupDesc, list_id)
select SU_type, Province, AppID, BatchYear = 2021, GroupID, GroupOrder, GroupDesc, list_id + 100
from [dbo].[SU_StructureList]
where batchyear = 2020
GO
--Inst Type 1.8
if exists (select * from information_schema.tables where table_name = 'zzInstType')
    drop table zzInstType
GO
create table zzInstType(
    Province varchar(10), 
    InstitutionNumber varchar(10), 
    InstitutionType varchar(10), 
    InstitutionTypeDescription varchar(100), 
    InstitutionName varchar(100), 
    SubmittingToDAD varchar(10)
)
GO
if exists (select * from information_schema.tables where table_name = 'zzInstNew2020')
    drop table zzInstNew2020
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00004','1','ACUTE INPT','WESTERN MEMORIAL REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00005','1','ACUTE INPT','NOTRE DAME BAY MEMORIAL HEALTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00007','1','ACUTE INPT','BONAVISTA COMMUNITY HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00008','1','ACUTE INPT','BONNE BAY HEALTH CARE CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00009','1','ACUTE INPT','DR. Y.K. JEON KITTIWAKE HEALTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00010','1','ACUTE INPT','CALDER HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00012','1','ACUTE INPT','DR. CHARLES L. LEGROW HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00014','1','ACUTE INPT','FOGO ISLAND HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00016','1','ACUTE INPT','CONNAIGRE PENINSULA HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00018','1','ACUTE INPT','DR. A. A. WILKINSON MEM. HEALTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00019','1','ACUTE INPT','PLACENTIA HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00020','1','ACUTE INPT','GREEN BAY HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00021','1','ACUTE INPT','SIR THOMAS RODDICK HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00025','1','ACUTE INPT','RUFUS GUINCHARD HEALTH CARE CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00026','1','ACUTE INPT','THE CHARLES S. CURTIS MEM. HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00038','1','ACUTE INPT','CENTRAL NEWFOUNDLAND REG. HLTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00039','1','ACUTE INPT','A. M. GUY MEMORIAL HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00049','1','ACUTE INPT','JAMES PATON MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00050','1','ACUTE INPT','BAIE VERTE PENINSULA HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00053','1','ACUTE INPT','DR. WALTER TEMPLEMAN COMM. HLTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00059','1','ACUTE INPT','LABRADOR HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00060','1','ACUTE INPT','CARBONEAR GENERAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00064','1','ACUTE INPT','DR. G. B. CROSS MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00065','1','ACUTE INPT','BURIN PENINSULA HEALTH CARE CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00069','P','HOSPICE/PALTIV','DR. LEONARD A. MILLER CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00080','1','ACUTE INPT','GENERIC OOP NUNAVUT ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00081','1','ACUTE INPT','GENERIC OOP PEI ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00082','1','ACUTE INPT','GENERIC OOP NOVA SCOTIA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00083','1','ACUTE INPT','GENERIC OOP NEW BRUNSWICK ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00084','1','ACUTE INPT','GENERIC OOP QUEBEC ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00085','1','ACUTE INPT','GENERIC OOP ONTARIO ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00086','1','ACUTE INPT','GENERIC OOP MANITOBA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00087','1','ACUTE INPT','GENERIC OOP SASKATCHEWAN ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00088','1','ACUTE INPT','GENERIC OOP ALBERTA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00089','1','ACUTE INPT','GENERIC OOP BRITISH COLUMBIA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00090','1','ACUTE INPT','GENERIC OOP YUKON ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00091','1','ACUTE INPT','GENERIC OOP NWT ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00098','1','ACUTE INPT','GENERIC OUTSIDE CANADA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00214','1','ACUTE INPT','ST. CLARE''S MERCY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00215','1','ACUTE INPT','HEALTH SCIENCES CENTRE ST. JOHN''S','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00216','1','ACUTE INPT','WATERFORD HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00217','1','ACUTE INPT','LABRADOR WEST HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','00344','1','ACUTE INPT','WESTERN LONG TERM CARE HOME','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01004','A','DAY SURGERY','WESTERN MEMORIAL REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01012','A','DAY SURGERY','DR. CHARLES L. LEGROW HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01021','A','DAY SURGERY','SIR THOMAS RODDICK HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01026','A','DAY SURGERY','THE CHARLES S. CURTIS MEM. HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01038','A','DAY SURGERY','CENTRAL NEWFOUNDLAND REG. HLTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01049','A','DAY SURGERY','JAMES PATON MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01059','A','DAY SURGERY','LABRADOR HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01060','A','DAY SURGERY','CARBONEAR GENERAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01064','A','DAY SURGERY','DR. G. B. CROSS MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01065','A','DAY SURGERY','BURIN PENINSULA HEALTH CARE CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01214','A','DAY SURGERY','ST. CLARE''S MERCY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01215','A','DAY SURGERY','HEALTH SCIENCES CENTRE ST. JOHNS','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01216','A','DAY SURGERY','WATERFORD HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','01217','A','DAY SURGERY','LABRADOR WEST HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02004','E','EMERGENCY DPT','WESTERN MEMORIAL REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02005','E','EMERGENCY DPT','NOTRE DAME BAY MEMORIAL HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02007','E','EMERGENCY DPT','BONAVISTA COMMUNITY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02008','E','EMERGENCY DPT','BONNE BAY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02009','E','EMERGENCY DPT','DR. Y.K. JEON KITTIWAKE HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02010','E','EMERGENCY DPT','CALDER HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02012','E','EMERGENCY DPT','DR. CHARLES L. LEGROW HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02014','E','EMERGENCY DPT','FOGO ISLAND HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02015','E','EMERGENCY DPT','DR. S. BECKLEY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02016','E','EMERGENCY DPT','CONNAIGRE PENINSULA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02018','E','EMERGENCY DPT','DR. A. A. WILKINSON MEM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02019','E','EMERGENCY DPT','PLACENTIA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02020','E','EMERGENCY DPT','GREEN BAY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02021','E','EMERGENCY DPT','SIR THOMAS RODDICK HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02022','E','EMERGENCY DPT','U.S. MEMORIAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02023','E','EMERGENCY DPT','DR. HUGH TWOMEY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02025','E','EMERGENCY DPT','RUFUS GUINCHARD HEALTH CARE CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02026','E','EMERGENCY DPT','THE CHARLES S. CURTIS MEM. HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02030','E','EMERGENCY DPT','WHITE BAY CENTRAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02031','E','EMERGENCY DPT','STRAIT OF BELLE ISLE HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02032','E','EMERGENCY DPT','LABRADOR SOUTH HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02038','E','EMERGENCY DPT','CENTRAL NEWFOUNDLAND REG. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02039','E','EMERGENCY DPT','A. M. GUY MEMORIAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02049','E','EMERGENCY DPT','JAMES PATON MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02050','E','EMERGENCY DPT','BAIE VERTE PENINSULA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02053','E','EMERGENCY DPT','DR. WALTER TEMPLEMAN COMM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02059','E','EMERGENCY DPT','LABRADOR HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02060','E','EMERGENCY DPT','CARBONEAR GENERAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02064','E','EMERGENCY DPT','DR. G. B. CROSS MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02065','E','EMERGENCY DPT','BURIN PENINSULA HEALTH CARE CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02115','E','EMERGENCY DPT','NORTH HAVEN MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02174','E','EMERGENCY DPT','DR. WM. H. NEWHOOK COMM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02182','E','EMERGENCY DPT','BAY DESPOIR COMMUNITY HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02214','E','EMERGENCY DPT','ST. CLARE''S MERCY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02215','E','EMERGENCY DPT','HEALTH SCIENCES CENTRE ST. JOHN''S','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02216','E','EMERGENCY DPT','WATERFORD HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','02217','E','EMERGENCY DPT','LABRADOR WEST HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03005','4','LT CARE','NOTRE DAME BAY MEMORIAL HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03008','4','LT CARE','BONNE BAY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03010','4','LT CARE','CALDER HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03012','4','LT CARE','DR. CHARLES L. LEGROW HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03014','4','LT CARE','FOGO ISLAND HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03016','4','LT CARE','CONNAIGRE PENINSULA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03019','4','LT CARE','PLACENTIA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03022','4','LT CARE','U.S. MEMORIAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03023','4','LT CARE','DR. HUGH TWOMEY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03025','4','LT CARE','RUFUS GUINCHARD HEALTH CARE CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03026','4','LT CARE','THE CHARLES S. CURTIS MEM. HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03032','4','LT CARE','LABRADOR SOUTH HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03036','4','LT CARE','ST. PATRICK''S MERCY HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03039','4','LT CARE','A. M. GUY MEMORIAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03050','4','LT CARE','BAIE VERTE PENINSULA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03053','4','LT CARE','DR. WALTER TEMPLEMAN COMM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03054','4','LT CARE','SAINT LUKE''S HOMES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03064','4','LT CARE','DR. G. B. CROSS MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03069','4','LT CARE','DR. LEONARD A. MILLER CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03072','4','LT CARE','GENERIC UNCLASSIFIED NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03100','4','LT CARE','THE AGNES PRATT HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03101','4','LT CARE','BAY ST. GEORGE LONG TERM CARE CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03102','4','LT CARE','BLUE CREST INTERFAITH HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03103','4','LT CARE','BONNEWS LODGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03105','4','LT CARE','CARMELITE HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03108','4','LT CARE','THE SALVATION ARMY GLENBROOK LODGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03110','4','LT CARE','HAPPY VALLEY GOOSE BAY LTC HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03112','4','LT CARE','LAKESIDE HOMES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03115','4','LT CARE','NORTH HAVEN MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03117','4','LT CARE','JOHN M. GRAY CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03197','G','GROUP/SUPPORT','GENERIC COMMUNITY CARE HOMES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03198','G','GROUP/SUPPORT','GENERIC FAMILY CARE HOMES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03199','G','GROUP/SUPPORT','GENERIC PERSONAL CARE HOMES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03200','4','LT CARE','DR. ALBERT O''MAHONY MEMORIAL MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03201','4','LT CARE','VALLEY VISTA SENIOR CITIZEN COMPLEX','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03202','4','LT CARE','GOLDEN HEIGHTS MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03204','4','LT CARE','LIONS MANOR NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03206','4','LT CARE','CORNER BROOK LONG TERM CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03207','4','LT CARE','PLEASANT VIEW TOWERS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03208','4','LT CARE','CORNER BROOK PROTECTIVE COMM. RES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03209','4','LT CARE','LEWISPORTE PROTECTIVE COMM. RES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03210','4','LT CARE','PTE. JOSIAH SQUIBB MEM. PAVILLION','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03211','4','LT CARE','BONAVISTA PROTECTIVE COMM. RES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03216','3','INPT CCC','WATERFORD HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03217','4','LT CARE','LABRADOR WEST HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03219','4','LT CARE','CLARENVILLE PROTECTIVE COMM. RES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03220','C','CORRECTIONAL','GENERIC CORRECTIONAL FACILITY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03221','G','GROUP/SUPPORT','GENERIC GROUP LIVING/SPT HOUSING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03222','H','TRANSIT HOUSE','GENERIC TRANSITIONAL HOUSING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03242','G','GROUP/SUPPORT','ACADIAN VILLAGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03243','G','GROUP/SUPPORT','ADMIRAL''S COAST RETIREMENT CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03244','G','GROUP/SUPPORT','ALDERWOOD ESTATES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03245','G','GROUP/SUPPORT','BACCALIEU RETIREMENT LIVING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03246','G','GROUP/SUPPORT','BARTON''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03247','G','GROUP/SUPPORT','BAY ROBERT''S RETIREMENT CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03248','G','GROUP/SUPPORT','LANES RET. LIV. IRISHTOWNSUMMERSIDE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03249','G','GROUP/SUPPORT','BAYVIEW HEIGHTS MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03250','G','GROUP/SUPPORT','BEACHSIDE MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03251','G','GROUP/SUPPORT','BLOW ME DOWN RETIREMENT CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03252','G','GROUP/SUPPORT','BONAVENTURE RETIREMENT HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03253','G','GROUP/SUPPORT','BONAVISTA RETIREMENT HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03254','G','GROUP/SUPPORT','BRAKE''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03255','G','GROUP/SUPPORT','CALLINGWOOD DOWNS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03256','G','GROUP/SUPPORT','CAMBRIDGE ESTATES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03257','G','GROUP/SUPPORT','CANNING''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03258','G','GROUP/SUPPORT','CARMANVILLE TERRACE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03259','G','GROUP/SUPPORT','CLARENVILLE RETIREMENT HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03260','G','GROUP/SUPPORT','COZY QUARTERS PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03261','G','GROUP/SUPPORT','CRADEA MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03262','G','GROUP/SUPPORT','CROSSWINDS SENIORS RESORT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03263','G','GROUP/SUPPORT','DEER LAKE MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03264','G','GROUP/SUPPORT','EASON''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03265','G','GROUP/SUPPORT','FAHEY''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03266','G','GROUP/SUPPORT','GANDER BAY RETIREMENT HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03267','G','GROUP/SUPPORT','GOLDEN CARE RETIREMENT LIVING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03268','G','GROUP/SUPPORT','GOLDEN YEARS ESTATES - GANDER','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03269','G','GROUP/SUPPORT','GOLDEN YEARS ESTATES - GRAND FALLS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03270','G','GROUP/SUPPORT','GRAND BANK RETIREMENT LIVING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03271','G','GROUP/SUPPORT','GREEN BAY RETIREMENT LIVING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03272','G','GROUP/SUPPORT','GREENWOOD REST HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03273','G','GROUP/SUPPORT','HARBOURVIEW MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03274','G','GROUP/SUPPORT','HILLCREST ESTATE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03275','G','GROUP/SUPPORT','HILLCREST MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03276','G','GROUP/SUPPORT','HILLTOP MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03277','G','GROUP/SUPPORT','HOLLETT''S RETIREMENT CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03278','G','GROUP/SUPPORT','ISLANDSIDE MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03279','G','GROUP/SUPPORT','IVY DURLEY PLACE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03280','G','GROUP/SUPPORT','KARWOOD RETIREMENT RETREAT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03281','G','GROUP/SUPPORT','KATHERINE HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03282','G','GROUP/SUPPORT','KELLY''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03283','G','GROUP/SUPPORT','KILLICK RETIREMENT HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03284','G','GROUP/SUPPORT','LEWIS'' PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03285','G','GROUP/SUPPORT','LINDA''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03286','G','GROUP/SUPPORT','LOHNES COMPLEX','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03287','G','GROUP/SUPPORT','LANES RETIREMENT LIVING CARBONEAR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03288','G','GROUP/SUPPORT','MAIN RIVER RETIREMENT HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03289','G','GROUP/SUPPORT','MARYSTOWN RETIREMENT CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03290','G','GROUP/SUPPORT','MEADOW CREEK RETIREMENT CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03291','G','GROUP/SUPPORT','MIRAQUINN HILLTOP MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03292','G','GROUP/SUPPORT','MJ PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03293','G','GROUP/SUPPORT','MOUNT MARGARET MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03294','G','GROUP/SUPPORT','MOUNTAIN HOPE MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03295','G','GROUP/SUPPORT','MOUNTAIN VIEW RETIREMENT CENTER','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03296','G','GROUP/SUPPORT','MOUNTAINVIEW HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03297','G','GROUP/SUPPORT','MURPHY''S SHADY REST LODGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03298','G','GROUP/SUPPORT','NIGHTINGALE MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03299','G','GROUP/SUPPORT','NORTH POND MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03300','G','GROUP/SUPPORT','LANES RET. LIVING PORT SAUNDERS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03301','G','GROUP/SUPPORT','ESSENTIAL PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03302','G','GROUP/SUPPORT','OCEANSIDE HOME CARE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03303','G','GROUP/SUPPORT','ORAM''S BAYWATCH MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03304','G','GROUP/SUPPORT','ORAM''S BIRCHVIEW MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03305','G','GROUP/SUPPORT','ORAM''S EMMANUEL MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03306','G','GROUP/SUPPORT','OTTERBURY MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03307','G','GROUP/SUPPORT','PEARL HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03308','G','GROUP/SUPPORT','PLEASANTVIEW MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03309','G','GROUP/SUPPORT','RIVERHEAD MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03310','G','GROUP/SUPPORT','ROBINSON''S PERSONAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03311','G','GROUP/SUPPORT','RODDICKTON HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03312','G','GROUP/SUPPORT','RUBY MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03313','G','GROUP/SUPPORT','SHAG ROCK MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03314','G','GROUP/SUPPORT','SHIRLEY''S HAVEN','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03315','G','GROUP/SUPPORT','SHIRLEY''S HAVEN #2','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03316','G','GROUP/SUPPORT','SIVERWOOD MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03317','G','GROUP/SUPPORT','SPRINGDALE RETIREMENT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03318','G','GROUP/SUPPORT','SUNSET MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03319','G','GROUP/SUPPORT','TOBIN''S GUEST HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03320','G','GROUP/SUPPORT','TWILIGHT MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03321','G','GROUP/SUPPORT','TWIN TOWN MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03322','G','GROUP/SUPPORT','WHITE''S FAMILY CARE RESIDENCE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03323','G','GROUP/SUPPORT','WINTER HOLME MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03324','G','GROUP/SUPPORT','WOODFORD''S COMFORT MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03325','G','GROUP/SUPPORT','XAVIER HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03331','G','GROUP/SUPPORT','CHANCELLOR PARK','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03332','G','GROUP/SUPPORT','HERITAGE SQUARE RETIREMENT LIVING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03338','G','GROUP/SUPPORT','WHITEBAY RETIREMENT LIVING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03339','G','GROUP/SUPPORT','KINGSWAY LIVING (LANE RET. LIVING)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03340','G','GROUP/SUPPORT','LANES RETIREMENT LIVING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03341','G','GROUP/SUPPORT','WESTMOUNT ESTATES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03342','G','GROUP/SUPPORT','ORAMS BETHESDA MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03344','4','LT CARE','WESTERN LONG TERM CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03346','G','GROUP/SUPPORT','WINSLOWE RIDGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','03347','G','GROUP/SUPPORT','LANES RET. LIV. ST. JOHNS A.H','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05004','N','AMBULATORY CAR','WESTERN MEMORIAL REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05005','N','AMBULATORY CAR','NOTRE DAME BAY MEMORIAL HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05007','N','AMBULATORY CAR','BONAVISTA COMMUNITY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05008','N','AMBULATORY CAR','BONNE BAY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05009','N','AMBULATORY CAR','DR. Y.K. JEON KITTIWAKE HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05010','N','AMBULATORY CAR','CALDER HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05012','N','AMBULATORY CAR','DR. CHARLES L. LEGROW HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05014','N','AMBULATORY CAR','FOGO ISLAND HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05015','N','AMBULATORY CAR','DR. S. BECKLEY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05016','N','AMBULATORY CAR','CONNAIGRE PENINSULA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05018','N','AMBULATORY CAR','DR. A. A. WILKINSON MEM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05019','N','AMBULATORY CAR','PLACENTIA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05020','N','AMBULATORY CAR','GREEN BAY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05021','N','AMBULATORY CAR','SIR THOMAS RODDICK HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05025','N','AMBULATORY CAR','RUFUS GUINCHARD HEALTH CARE CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05026','N','AMBULATORY CAR','THE CHARLES S. CURTIS MEM. HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05027','0','COMMUNITY CLIN','CARTWRIGHT COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05028','0','COMMUNITY CLIN','MANI ASHINI HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05030','N','AMBULATORY CAR','WHITE BAY CENTRAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05031','N','AMBULATORY CAR','STRAIT OF BELLE ISLE HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05032','N','AMBULATORY CAR','LABRADOR SOUTH HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05033','0','COMMUNITY CLIN','MARY''S HARBOUR COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05035','0','COMMUNITY CLIN','NAIN COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05038','N','AMBULATORY CAR','CENTRAL NEWFOUNDLAND REG. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05039','N','AMBULATORY CAR','A. M. GUY MEMORIAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05045','0','COMMUNITY CLIN','HOPEDALE COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05047','0','COMMUNITY CLIN','MAKKOVIK COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05049','N','AMBULATORY CAR','JAMES PATON MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05050','N','AMBULATORY CAR','BAIE VERTE PENINSULA HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05053','N','AMBULATORY CAR','DR. WALTER TEMPLEMAN COMM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05057','N','AMBULATORY CAR','CHURCHILL FALLS COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05059','N','AMBULATORY CAR','LABRADOR HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05060','N','AMBULATORY CAR','CARBONEAR GENERAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05064','N','AMBULATORY CAR','DR. G. B. CROSS MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05065','N','AMBULATORY CAR','BURIN PENINSULA HEALTH CARE CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05066','0','COMMUNITY CLIN','GROSSWATER BAY COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05067','0','COMMUNITY CLIN','BLACK TICKLE COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05074','8','HOME CARE','GENERIC HOME CARE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05079','U','UNKNOWN','GENERIC UNK NL HEALTH CLINIC/AGENCY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05084','N','AMBULATORY CAR','GENERIC OOP QUEBEC NON-ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05092','0','COMMUNITY CLIN','ST. LEWIS COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05093','0','COMMUNITY CLIN','POSTVILLE COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05094','0','COMMUNITY CLIN','CHARLOTTETOWN COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05096','0','COMMUNITY CLIN','NATUASHISH COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05097','0','COMMUNITY CLIN','PORT HOPE SIMPSON COMMUNITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05151','0','COMMUNITY CLIN','CARMANVILLE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05152','0','COMMUNITY CLIN','CENTREVILLE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05153','0','COMMUNITY CLIN','CODROY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05154','0','COMMUNITY CLIN','COW HEAD CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05155','0','COMMUNITY CLIN','DANIEL''S HARBOUR CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05156','0','COMMUNITY CLIN','DEGRAS CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05157','0','COMMUNITY CLIN','EASTPORT CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05158','0','COMMUNITY CLIN','FRANCOIS CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05159','0','COMMUNITY CLIN','GAMBO CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05160','0','COMMUNITY CLIN','GANDER BAY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05161','0','COMMUNITY CLIN','GLOVERTOWN CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05164','0','COMMUNITY CLIN','GREY RIVER CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05166','0','COMMUNITY CLIN','HARE BAY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05167','0','COMMUNITY CLIN','HERMITAGE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05168','0','COMMUNITY CLIN','JEFFREY''S CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05169','0','COMMUNITY CLIN','LASCIE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05170','0','COMMUNITY CLIN','LEWISPORTE HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05171','0','COMMUNITY CLIN','LOURDES CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05172','0','COMMUNITY CLIN','MOSE AMBROSE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05173','0','COMMUNITY CLIN','MUSGRAVE HARBOUR CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05174','N','AMBULATORY CAR','DR. WM. H. NEWHOOK COMM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05175','0','COMMUNITY CLIN','PARKERS COVE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05176','0','COMMUNITY CLIN','PARSON''S POND CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05177','0','COMMUNITY CLIN','PETITE FORTE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05178','0','COMMUNITY CLIN','PETITES AND LA POILE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05179','0','COMMUNITY CLIN','RAMEA CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05180','0','COMMUNITY CLIN','ROSE BLANCHE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05181','0','COMMUNITY CLIN','SOUTHEAST BIGHT CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05182','0','COMMUNITY CLIN','BAY D''ESPOIR CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05183','0','COMMUNITY CLIN','ST. BRENDAN''S CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05184','0','COMMUNITY CLIN','ST. GEORGE''S CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05185','0','COMMUNITY CLIN','STEPHENVILLE CROSSING CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05186','0','COMMUNITY CLIN','VIRGIN ARM CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05189','0','COMMUNITY CLIN','WOODY POINT CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05191','0','COMMUNITY CLIN','TRINITY CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05214','N','AMBULATORY CAR','ST. CLARE''S MERCY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05215','N','AMBULATORY CAR','HEALTH SCIENCES CENTRE ST. JOHN''S','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05216','N','AMBULATORY CAR','WATERFORD HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05217','N','AMBULATORY CAR','LABRADOR WEST HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05223','0','COMMUNITY CLIN','BAY ST. GEORGE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05224','0','COMMUNITY CLIN','PLACENTIA WEST MEDICAL CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05225','0','COMMUNITY CLIN','CHANGE ISLAND CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05226','0','COMMUNITY CLIN','DEER LAKE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05227','0','COMMUNITY CLIN','FERRYLAND CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05228','0','COMMUNITY CLIN','HAMPDEN CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05229','0','COMMUNITY CLIN','JACKSON''S ARM CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05230','0','COMMUNITY CLIN','MCCALLUM CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05231','0','COMMUNITY CLIN','MOUNT CARMEL CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05232','0','COMMUNITY CLIN','RENCONTRE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05233','0','COMMUNITY CLIN','SHEA HEIGHTS CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05234','0','COMMUNITY CLIN','SOPS ARM CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05235','0','COMMUNITY CLIN','ST. MARY''S CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05236','0','COMMUNITY CLIN','TERRENCEVILLE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05237','0','COMMUNITY CLIN','TROUT RIVER CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05238','0','COMMUNITY CLIN','WESTERN MEMORIAL HEALTH CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05239','M','COMM MH ADDICT','GENERIC COMM. BASED MH & ADDICTION','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05240','0','COMMUNITY CLIN','GENERIC COMMUNITY BASED SERVICES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05241','J','OTH NON-HEALTH','GENERIC NON-HEALTH FACILITY/SERVICE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05326','0','COMMUNITY CLIN','CHOICES FOR YOUTH','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05327','0','COMMUNITY CLIN','GATHERING PLACE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05328','0','COMMUNITY CLIN','NEW HOPE CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05329','0','COMMUNITY CLIN','SHOP (SAFE HARBOUR OUTREACH PRGM)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','05330','0','COMMUNITY CLIN','COISH PLACE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','06203','T','MH/ADDICT RX','HUMBERWOOD CENTRE(RESIDENTIAL CARE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','06205','T','MH/ADDICT RX','RECOVERY CENTRE (RESIDENTIAL CARE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','06212','T','MH/ADDICT RX','HOPE VALLEY CTR (RESIDENTIAL CARE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','06213','T','MH/ADDICT RX','TUCKAMORE CENTRE (RESIDENTIAL CARE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','06218','T','MH/ADDICT RX','THE GRACE CENTRE (RESIDENTIAL CARE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','08069','2','INPT REHAB','DR. LEONARD A. MILLER CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','08206','2','INPT REHAB','CORNER BROOK LONG TERM CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','08344','2','INPT REHAB','WESTERN LONG TERM CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL','09215','N','AMBULATORY CAR','HEALTH SCIENCE CENTRE - ST.JOHN''S','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','10001','1','ACUTE INPT','QUEEN ELIZABETH HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','10003','1','ACUTE INPT','PRINCE COUNTY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','10004','1','ACUTE INPT','WESTERN HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','10005','1','ACUTE INPT','KINGS COUNTY MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','10006','1','ACUTE INPT','COMMUNITY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','10007','1','ACUTE INPT','SOURIS HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','12015','2','INPT REHAB','PRINCE EDWARD HOME RESTORATIVE CARE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14008','4','LT CARE','STEWART MEMORIAL HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14014','4','LT CARE','BEACH GROVE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14015','4','LT CARE','PRINCE EDWARD HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14016','4','LT CARE','WEDGEWOOD MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14017','4','LT CARE','SUMMERSET MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14018','4','LT CARE','MAPLEWOOD MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14019','4','LT CARE','COLVILLE MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14020','4','LT CARE','RIVERVIEW MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14021','4','LT CARE','GARDEN HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14022','4','LT CARE','WHISPERWOOD VILLA','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14025','4','LT CARE','ATLANTIC BAPTIST NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14028','4','LT CARE','CLINTON VIEW LODGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14029','4','LT CARE','DR. JOHN GILLIS MEMORIAL LODGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14030','4','LT CARE','SOUTH SHORE VILLA','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14031','4','LT CARE','SHERWOOD HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14035','G','GROUP/SUPPORT','GENERIC COMMUNITY CARE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14036','4','LT CARE','MARGARET STEWART ELLIS HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14156','4','LT CARE','ANDREW''S LODGE CHARLOTTETOWN','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14170','4','LT CARE','ANDREW''S LODGE SUMMERSIDE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14189','4','LT CARE','ANDREW''S OF STRATFORD','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14190','4','LT CARE','PARK WEST LODGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','14998','4','LT CARE','THE MOUNT CONTINUING CARE COMMUNITY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15002','5','INPT MENTAL','HILLSBOROUGH HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15003','M','COMM MH ADDICT','PCH COMMUNITY MH & ADDICTIONS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15007','M','COMM MH ADDICT','SOURIS HOSPITAL MH SERVICES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15011','T','MH/ADDICT RX','PROVINCIAL ADDICTIONS TREATMENT FAC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15933','T','MH/ADDICT RX','LACEY HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15934','T','MH/ADDICT RX','TALBOT HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15935','T','MH/ADDICT RX','ST. ELEANORS HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15936','T','MH/ADDICT RX','DEACON HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15937','T','MH/ADDICT RX','YOUTH RECOVERY CTR STRENGTH PROGRAM','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15938','T','MH/ADDICT RX','LENNON HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15941','M','COMM MH ADDICT','MCGILL COMMUNITY MENTAL HEALTH','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15942','M','COMM MH ADDICT','RICHMOND CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15944','M','COMM MH ADDICT','ALBERTON MENTAL HEALTH SERVICES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15945','M','COMM MH ADDICT','O''LEARY MENTAL HEALTH SERVICES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','15946','T','MH/ADDICT RX','MONTAGUE MENTAL HEALTH SERVICES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16009','P','HOSPICE/PALTIV','PROV. PALLIATIVE CARE CTR HOSPICE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16032','C','CORRECTIONAL','PROVINCIAL CORRECTIONAL CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16033','C','CORRECTIONAL','PRINCE COUNTY CORRECTIONAL CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16034','C','CORRECTIONAL','PEI YOUTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16939','8','HOME CARE','GENERIC HOME CARE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16940','8','HOME CARE','GENERIC INTEG PALLIATIVE CARE PRGM','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16948','G','GROUP/SUPPORT','GENERIC GROUP HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','16950','G','GROUP/SUPPORT','ANDERSON HOUSE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','17001','N','AMBULATORY CAR','QUEEN ELIZABETH HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','17003','N','AMBULATORY CAR','PRINCE COUNTY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','17004','N','AMBULATORY CAR','WESTERN HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','17005','N','AMBULATORY CAR','KINGS COUNTY MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','17006','N','AMBULATORY CAR','COMMUNITY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','17007','N','AMBULATORY CAR','SOURIS HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18051','1','ACUTE INPT','GENERIC OOP  MONCTON HOSPITAL ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18052','1','ACUTE INPT','GENERIC OOP DR. G. L. DUMONT ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18053','1','ACUTE INPT','GENERIC OOP ST. JOHN REG HOSP ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18103','A','DAY SURGERY','GENERIC OOP IWK HEALTH CENTRE DS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18114','A','DAY SURGERY','GENERIC OOP QELL HLTH SCI CTR DS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18151','A','DAY SURGERY','GENERIC OOP MONCTON HOSPITAL DS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18152','A','DAY SURGERY','GENERIC OOP DR. G.L. DUMONT DS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18153','A','DAY SURGERY','GENERIC OOP ST. JOHN REG HOSP DS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18203','1','ACUTE INPT','GENERIC OOP IWK HEALTH CTR ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18214','1','ACUTE INPT','GENERIC OOP QELL HLTH SCI CTR ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18910','1','ACUTE INPT','GENERIC CANADA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18911','1','ACUTE INPT','GENERIC UNITED STATES ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18916','1','ACUTE INPT','GENERIC OOP NOVA SCOTIA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18917','1','ACUTE INPT','GENERIC OOP NEW BRUNSWICK ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18918','1','ACUTE INPT','GENERIC OOP NL ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18919','1','ACUTE INPT','GENERIC OOP ONTARIO ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18920','1','ACUTE INPT','GENERIC OOP MANITOBA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18921','1','ACUTE INPT','GENERIC OOP SASKATCHEWAN ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18922','1','ACUTE INPT','GENERIC OOP ALBERTA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18923','1','ACUTE INPT','GENERIC OOP BRITISH COLUMBIA ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18924','1','ACUTE INPT','GENERIC OOP QUEBEC ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18925','1','ACUTE INPT','GENERIC OOP NWT ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18926','1','ACUTE INPT','GENERIC OOP NUNAVUT ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18927','1','ACUTE INPT','GENERIC OOP YUKON ACUTE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18928','2','INPT REHAB','GENERIC OOP STAN CASSIDY REHAB CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18929','5','INPT MENTAL','GENERIC OOP INPT MH PORTAGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18930','5','INPT MENTAL','GENERIC OOP INPT MH PEEL CHILD CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18931','5','INPT MENTAL','GENERIC OOP INPT MH HOMEWOOD HLTH','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','18932','5','INPT MENTAL','GENERIC OOP INPT MH BELLWOOD HLTH','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE','19009','1','ACUTE INPT','PROVINCIAL PALLIATIVE CARE CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20002','1','ACUTE INPT','OOP/OOC ACUTE INPATIENT CARE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20011','1','ACUTE INPT','ABERDEEN HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20012','1','ACUTE INPT','ALL SAINT''S SPRINGHILL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20013','1','ACUTE INPT','ANNAPOLIS COMMUNITY HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20014','1','ACUTE INPT','SOUTH SHORE REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20015','1','ACUTE INPT','BUCHANAN MEMORIAL COMM. HLTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20018','1','ACUTE INPT','COLCHESTER EAST HANTS HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20020','1','ACUTE INPT','DIGBY GENERAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20022','1','ACUTE INPT','EASTERN MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20023','1','ACUTE INPT','EASTERN SHORE MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20027','1','ACUTE INPT','GUYSBOROUGH MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20030','1','ACUTE INPT','CUMBERLAND REGIONAL HEALTH CARE CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20032','1','ACUTE INPT','LILLIAN FRASER MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20033','1','ACUTE INPT','MUSQUODOBOIT VALLEY MEMORIAL HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20034','1','ACUTE INPT','INVERNESS CONSOLIDATED MEM. HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20035','1','ACUTE INPT','NORTH CUMBERLAND MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20037','1','ACUTE INPT','HANTS COMMUNITY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20038','1','ACUTE INPT','QUEEN''S GENERAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20039','1','ACUTE INPT','ROSEWAY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20043','1','ACUTE INPT','ST. MARTHA''S REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20045','1','ACUTE INPT','ST. MARY''S MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20047','1','ACUTE INPT','SACRED HEART COMMUNITY HEALTH CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20048','1','ACUTE INPT','SOLDIERS'' MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20049','1','ACUTE INPT','SOUTH CUMBERLAND COMM. CARE CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20052','1','ACUTE INPT','TWIN OAKS MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20053','1','ACUTE INPT','VICTORIA COUNTY MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20056','1','ACUTE INPT','YARMOUTH REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20058','3','INPT CCC','BAYVIEW MEMORIAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20065','1','ACUTE INPT','DARTMOUTH GENERAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20067','1','ACUTE INPT','VALLEY REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20068','1','ACUTE INPT','STRAIT RICHMOND HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20077','1','ACUTE INPT','NOVA SCOTIA HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20085','1','ACUTE INPT','QUEEN ELIZABETH II HEALTH SC. CTR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20086','1','ACUTE INPT','IWK HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20087','1','ACUTE INPT','CAPE BRETON HEALTH CARE COMPLEX','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','20114','1','ACUTE INPT','FISHERMEN''S MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','22071','5','INPT MENTAL','EAST COAST FORENSIC HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','22086','5','INPT MENTAL','IWK HLTH CNTR - SECURE CARE UNIT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','23077','5','INPT MENTAL','MEMORY LANE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','24012','2','INPT REHAB','ALL SAINT''S SPRINGHILL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','24043','2','INPT REHAB','ST. MARTHA''S REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','24050','2','INPT REHAB','SUTHERLAND HARRIS MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','24085','2','INPT REHAB','QUEEN ELIZABETH II HEALTH SC. CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','24087','3','INPT CCC','CAPE BRETON HEALTH CARE COMPLEX','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','24114','2','INPT REHAB','FISHERMEN''S MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25043','4','LT CARE','ST. MARTHA''S REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25048','4','LT CARE','SOLDIERS MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25050','4','LT CARE','SUTHERLAND HARRIS MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25056','4','LT CARE','YARMOUTH REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25058','4','LT CARE','BAYVIEW MEMORIAL HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25085','4','LT CARE','QUEEN ELIZABETH II HEALTH SC. CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25087','4','LT CARE','CAPE BRETON HEALTH CARE COMPLEX','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','25114','4','LT CARE','FISHERMEN''S MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29002','U','UNKNOWN','OOP/OOC NON-ACUTE INSTITUTION','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29003','4','LT CARE','LTC 24HR NURSING CARE IN NS','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29011','N','AMBULATORY CAR','ABERDEEN HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29012','N','AMBULATORY CAR','ALL SAINT''S SPRINGHILL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29013','N','AMBULATORY CAR','ANNAPOLIS COMMUNITY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29014','N','AMBULATORY CAR','SOUTH SHORE REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29015','N','AMBULATORY CAR','BUCHANAN MEMORIAL COMM. HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29018','N','AMBULATORY CAR','COLCHESTER EAST HANTS HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29020','N','AMBULATORY CAR','DIGBY GENERAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29021','N','AMBULATORY CAR','EASTERN KINGS MEMORIAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29022','N','AMBULATORY CAR','EASTERN MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29023','N','AMBULATORY CAR','EASTERN SHORE MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29027','N','AMBULATORY CAR','GUYSBOROUGH MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29030','N','AMBULATORY CAR','CUMBERLAND REGIONAL HEALTH CARE CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29032','N','AMBULATORY CAR','LILLIAN FRASER MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29033','N','AMBULATORY CAR','MUSQUODOBOIT VALLEY MEMORIAL HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29034','N','AMBULATORY CAR','INVERNESS CONSOLIDATED MEM. HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29035','N','AMBULATORY CAR','NORTH CUMBERLAND MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29037','N','AMBULATORY CAR','HANTS COMMUNITY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29038','N','AMBULATORY CAR','QUEEN''S GENERAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29039','N','AMBULATORY CAR','ROSEWAY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29040','4','LT CARE','ST. ANNE COMMUNITY&NURSING CARE CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29043','N','AMBULATORY CAR','ST. MARTHA''S REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29045','N','AMBULATORY CAR','ST. MARY''S MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29047','N','AMBULATORY CAR','SACRED HEART COMMUNITY HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29048','N','AMBULATORY CAR','SOLDIERS MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29049','N','AMBULATORY CAR','SOUTH CUMBERLAND COMMUNITY CARE CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29052','N','AMBULATORY CAR','TWIN OAKS MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29053','N','AMBULATORY CAR','VICTORIA COUNTY MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29055','N','AMBULATORY CAR','WESTERN KINGS MEMORIAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29056','N','AMBULATORY CAR','YARMOUTH REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29061','N','AMBULATORY CAR','COBEQUID COMMUNITY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29065','N','AMBULATORY CAR','DARTMOUTH GENERAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29067','N','AMBULATORY CAR','VALLEY REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29068','N','AMBULATORY CAR','STRAIT RICHMOND HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29077','N','AMBULATORY CAR','NOVA SCOTIA HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29085','N','AMBULATORY CAR','QUEEN ELIZABETH II HEALTH SC. CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29086','N','AMBULATORY CAR','IWK HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29087','N','AMBULATORY CAR','CAPE BRETON HEALTH CARE COMPLEX','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29089','8','HOME CARE','HOME CARE SERVICES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29114','N','AMBULATORY CAR','FISHERMEN''S MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29800','0','COMMUNITY CLIN','GENERIC COMMUNITY BASED CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29802','F','OTHER HEALTH','GENERIC OTHER HEALTH FACILITY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29803','J','OTH NON-HEALTH','GENERIC OTHER NON-HEALTH FACILITY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29804','U','UNKNOWN','GENERIC UNKNOWN FACILITY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29805','4','LT CARE','GENERIC VETERAN''S AFFAIRS - LTC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29991','P','HOSPICE/PALTIV','HOSPICE/PALLIATIVE CARE FACILITY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29992','T','MH/ADDICT RX','MENTAL HLTH/ADDICTION TREATMENT CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29993','M','COMM MH ADDICT','COMMUNITY MENTAL HEALTH SERVICES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29994','G','GROUP/SUPPORT','GROUP LIVING/SUPPORTIVE HOUSING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29995','H','TRANSIT HOUSE','TRANSITIONAL HOUSING','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS','29996','C','CORRECTIONAL','CORRECTIONAL FACILITY','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30001','1','ACUTE INPT','DR. EVERETT CHALMERS REGIONAL HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30005','1','ACUTE INPT','HPITAL RGIONAL DE CAMPBELLTON','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30009','1','ACUTE INPT','HPITAL RGIONAL D''EDMUNDSTON','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30016','1','ACUTE INPT','GRAND MANAN HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30018','1','ACUTE INPT','HPITAL DE LAMQUE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30020','1','ACUTE INPT','THE MONCTON HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30022','1','ACUTE INPT','MIRAMICHI REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30023','1','ACUTE INPT','HOTEL-DIEU OF ST. JOSEPH','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30026','1','ACUTE INPT','SACKVILLE MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30029','1','ACUTE INPT','SAINT JOHN REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30031','1','ACUTE INPT','ST. JOSEPH''S HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30032','1','ACUTE INPT','HOTEL-DIEU ST-JOSEPH DE ST-QUENTIN','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30033','1','ACUTE INPT','CHARLOTTE COUNTY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30034','1','ACUTE INPT','SUSSEX HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30035','1','ACUTE INPT','HPITAL DE TRACADIE-SHEILA','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30039','1','ACUTE INPT','HPITAL RGIONAL CHALEUR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30041','1','ACUTE INPT','HPITAL DE L''ENFANT-JSUS RHSJ','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30042','1','ACUTE INPT','HPITAL GNRAL DE GRAND-SAULT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30045','1','ACUTE INPT','HPITAL DE STELLA-MARIS-DE-KENT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30046','1','ACUTE INPT','OROMOCTO PUBLIC HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30048','1','ACUTE INPT','CHU DR-GEORGES-L.-DUMONT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30049','1','ACUTE INPT','UPPER RIVER VALLEY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30050','1','ACUTE INPT','GENERIC QC FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30060','1','ACUTE INPT','GENERIC ON FACILITIES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30065','1','ACUTE INPT','GENERIC NS FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30070','1','ACUTE INPT','GENERIC PE FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30074','1','ACUTE INPT','GENERIC NL FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30075','1','ACUTE INPT','GENERIC MB FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30076','1','ACUTE INPT','GENERIC SK FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30077','1','ACUTE INPT','GENERIC AB FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30078','1','ACUTE INPT','GENERIC BC FACILITIES (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30079','1','ACUTE INPT','GENERIC YK,NT,NU FACILITIES(ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30080','1','ACUTE INPT','GENERIC FACILITIES IN USA (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','30090','1','ACUTE INPT','GENERIC OTHER COUNTRIES FAC (ACUTE)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31001','A','DAY SURGERY','DR. EVERETT CHALMERS REGIONAL HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31005','A','DAY SURGERY','HPITAL RGIONAL DE CAMPBELLTON','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31009','A','DAY SURGERY','HPITAL RGIONAL D''EDMUNDSTON','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31020','A','DAY SURGERY','THE MONCTON HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31022','A','DAY SURGERY','MIRAMICHI REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31026','A','DAY SURGERY','SACKVILLE MEMORIAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31029','A','DAY SURGERY','SAINT JOHN REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31031','A','DAY SURGERY','ST. JOSEPH''S HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31033','A','DAY SURGERY','CHARLOTTE COUNTY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31034','A','DAY SURGERY','SUSSEX HEALTH CENTRE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31039','A','DAY SURGERY','HPITAL RGIONAL CHALEUR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31042','A','DAY SURGERY','HPITAL GNRAL DE GRAND-SAULT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31046','A','DAY SURGERY','OROMOCTO PUBLIC HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31048','A','DAY SURGERY','CHU DR-GEORGES-L.-DUMONT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31049','A','DAY SURGERY','UPPER RIVER VALLEY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31050','A','DAY SURGERY','QUEBEC FACILITIES, (DAY SURGERY)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31065','A','DAY SURGERY','GENERIC NS FACILITIES (DS)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','31080','A','DAY SURGERY','GENERIC FACILITIES IN USA(DS)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32001','N','AMBULATORY CAR','DR. EVERETT CHALMERS REGIONAL HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32005','N','AMBULATORY CAR','HPITAL RGIONAL DE CAMPBELLTON','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32009','N','AMBULATORY CAR','HPITAL RGIONAL D''EDMUNDSTON','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32016','N','AMBULATORY CAR','GRAND MANAN HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32018','N','AMBULATORY CAR','HPITAL DE LAMQUE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32020','A','DAY SURGERY','THE MONCTON HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32022','N','AMBULATORY CAR','MIRAMICHI REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32023','N','AMBULATORY CAR','HOTEL-DIEU OF ST. JOSEPH','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32026','N','AMBULATORY CAR','SACKVILLE MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32029','A','DAY SURGERY','SAINT JOHN REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32031','A','DAY SURGERY','ST. JOSEPH''S HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32032','N','AMBULATORY CAR','HOTEL-DIEU ST-JOSEPH DE ST-QUENTIN','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32033','N','AMBULATORY CAR','CHARLOTTE COUNTY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32034','N','AMBULATORY CAR','SUSSEX HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32035','N','AMBULATORY CAR','HPITAL DE TRACADIE-SHEILA','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32039','N','AMBULATORY CAR','CHALEUR REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32041','N','AMBULATORY CAR','HPITAL DE L''ENFANT-JSUS RHSJ','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32042','A','DAY SURGERY','HPITAL GNRAL DE GRAND-SAULT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32045','N','AMBULATORY CAR','HPITAL DE STELLA-MARIS-DE-KENT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32046','N','AMBULATORY CAR','OROMOCTO PUBLIC HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32048','A','DAY SURGERY','CHU DR-GEORGES-L.-DUMONT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','32049','N','AMBULATORY CAR','UPPER RIVER VALLEY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33001','3','INPT CCC','DR. EVERETT CHALMERS REGIONAL HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33005','3','INPT CCC','HPITAL RGIONAL DE CAMPBELLTON','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33009','3','INPT CCC','HPITAL RGIONAL D''EDMUNDSTON','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33020','3','INPT CCC','THE MONCTON HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33022','3','INPT CCC','MIRAMICHI REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33029','3','INPT CCC','SAINT JOHN REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33031','3','INPT CCC','ST. JOSEPH''S HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33033','3','INPT CCC','CHARLOTTE COUNTY HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33039','3','INPT CCC','HPITAL RGIONAL CHALEUR','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33046','3','INPT CCC','OROMOCTO PUBLIC HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33048','3','INPT CCC','CHU DR-GEORGES-L.-DUMONT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33050','3','INPT CCC','QUEBEC FACILITIES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33301','4','LT CARE','YORK MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33302','4','LT CARE','THEKENNETHE.SPENCERNURSINGHOMEINC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33303','4','LT CARE','UNITEDCHURCHHOMEFORSRCITIZENSINC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33304','4','LT CARE','FOREST DALE HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33305','4','LT CARE','FOYER SAINT-ANTOINE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33306','4','LT CARE','FOYERSTTHOMASDELAVALLEDEMEMRAMCOOK','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33307','4','LT CARE','JORDAN LIFECARE CENTRE INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33308','4','LT CARE','MANOIR SAINT-JEAN BAPTISTE INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33309','4','LT CARE','REXTON LIONS NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33310','4','LT CARE','SHANNEX RLC LTD. MONARCH HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33311','4','LT CARE','THE SALVATION ARMY LAKEVIEW MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33312','4','LT CARE','VILLA DU REPOS INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33313','4','LT CARE','VILLA MARIA INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33314','4','LT CARE','VILLA PROVIDENCE SHDIAC INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33315','4','LT CARE','WESTFORD NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33316','4','LT CARE','CAMPOBELLO LODGE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33317','4','LT CARE','CARLETON KIRK NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33318','4','LT CARE','CHURCH OF ST JOHN & ST STEPHEN HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33319','4','LT CARE','DR. V. A. SNOW CENTRE INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33320','4','LT CARE','FUNDY NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33321','4','LT CARE','GRAND MANAN NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33322','4','LT CARE','KENNEBEC MANOR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33323','4','LT CARE','KINGS WAY CARE CENTRE INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33324','4','LT CARE','KIWANIS NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33325','4','LT CARE','LINCOURT MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33326','4','LT CARE','LOCH LOMOND VILLA INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33327','4','LT CARE','PASSAMAQUODDY LODGE INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33328','4','LT CARE','ROCMAURA INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33329','4','LT CARE','SHANNEX RLC LTD. EMBASSY HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33330','4','LT CARE','TURNBULL NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33331','4','LT CARE','CARLETON MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33332','4','LT CARE','CENTRAL CARLETON NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33333','4','LT CARE','CENTRAL NEW BRUNSWICK NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33334','4','LT CARE','ORCHARD VIEW','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33335','4','LT CARE','MILL COVE NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33336','4','LT CARE','NASHWAAK VILLA INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33337','4','LT CARE','PINE GROVE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33338','4','LT CARE','RIVER VIEW MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33339','4','LT CARE','SHANNEX RLC LTD. THOMAS HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33340','4','LT CARE','TOBIQUE VALLEY MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33341','4','LT CARE','VICTORIA GLEN MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33342','4','LT CARE','WAUKLEHEGAN MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33343','4','LT CARE','WHITE RAPIDS MANOR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33344','4','LT CARE','W. G. BISHOP NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33345','4','LT CARE','FOYER NOTRE-DAME DE SAINT-LONARD','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33347','4','LT CARE','FOYER STE. ELIZABETH INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33348','4','LT CARE','GRANDFALLSMANORINC.MANOIRDESCHUTES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33349','4','LT CARE','RSIDENCE MGR. MELANSON INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33352','4','LT CARE','CAMPBELLTON NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33353','4','LT CARE','DALHOUSIE NURSING HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33354','4','LT CARE','VILLA SORMANY INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33355','4','LT CARE','ROBERTI.KNOWLESVETERANSUNITVILLACHA','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33356','4','LT CARE','FOYER NOTRE-DAME-DE-LOURDES INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33357','4','LT CARE','FOYER ASSOMPTION','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33358','4','LT CARE','MIRAMICHI SENIOR CITIZENS HOME INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33359','4','LT CARE','MOUNT SAINT JOSEPH OF CHATHAM, N.B.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33361','4','LT CARE','TABUSINTAC NURSING HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33362','4','LT CARE','RSIDENCES INKERMAN INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33363','4','LT CARE','RSIDENCES LUCIEN SAINDON INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33364','4','LT CARE','RSIDENCES MGR. CHIASSON INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33366','4','LT CARE','MANOIR DITH B. PINET','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33367','4','LT CARE','VILLA BEAUSJOUR INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33368','4','LT CARE','VILLA SAINT-JOSEPH INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33369','4','LT CARE','LES RSIDENCES JODIN INC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33371','4','LT CARE','LE COMPLEXE RENDEZ-VOUS INC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33372','4','LT CARE','SHANNEX RLC LTD. - FREDERICK HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33373','4','LT CARE','SHANNEX RLC LTD. - TUCKER HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33381','4','LT CARE','PAVILLON RICHARD','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33382','4','LT CARE','SHANNEX RLC LTD.  LOSIER HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33383','4','LT CARE','SHANNEX RLC LTD.  BRIDGEVIEW HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','33384','4','LT CARE','SHANNEX RLC LTD. PAV. NEILL HALL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','34001','3','INPT CCC','DR. EVERETT CHALMERS REGIONAL HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','34005','3','INPT CCC','HPITAL RGIONAL DE CAMPBELLTON','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','34029','3','INPT CCC','SAINT JOHN REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','34048','3','INPT CCC','CHU DR-GEORGES-L.-DUMONT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','35001','2','INPT REHAB','DR. EVERETT CHALMERS REGIONAL HOSP.','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','35012','2','INPT REHAB','THESTANCASSIDYCTREFORREHABILITATION','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','35020','2','INPT REHAB','THE MONCTON HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','35022','2','INPT REHAB','MIRAMICHI REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','35029','2','INPT REHAB','SAINT JOHN REGIONAL HOSPITAL','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','35048','2','INPT REHAB','CHU DR-GEORGES-L.-DUMONT','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','35050','2','INPT REHAB','GENERIC QUEBEC FACILITY (REHAB)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36700','8','HOME CARE','VITALITE&HORIZONHLTHNET EMP UNSPEC.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36711','8','HOME CARE','BLANCHE BOURGEOIS EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36712','8','HOME CARE','SHDIAC EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36713','8','HOME CARE','KENT EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36721','8','HOME CARE','SAINT JOHN EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36722','8','HOME CARE','ST. STEPHEN EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36723','8','HOME CARE','EASTERN CHARLOTTE EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36725','8','HOME CARE','SUSSEX EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36726','8','HOME CARE','KENNEBECASIS EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36731','8','HOME CARE','WOODSTOCK EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36732','8','HOME CARE','PERTH EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36733','8','HOME CARE','FREDERICTON EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36734','8','HOME CARE','OROMOCTO EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36736','8','HOME CARE','BOIESTOWN EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36741','8','HOME CARE','GRAND FALLS EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36742','8','HOME CARE','EDMUNSTON EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36743','8','HOME CARE','KEDGWICK EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36751','8','HOME CARE','RESTIGOUCHE EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36761','8','HOME CARE','BATHURST EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36762','8','HOME CARE','PNINS. ACADIENNE TRACADIE EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36763','8','HOME CARE','PNINS. ACADIENNE CARAQUET EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36764','8','HOME CARE','PNINS. ACADIENNE LAMQUE EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36771','8','HOME CARE','MIRAMICHI EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36772','8','HOME CARE','NGUAC EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36773','8','HOME CARE','BLACKVILLE EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36781','8','HOME CARE','DRISCOLL EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','36782','8','HOME CARE','TANTRAMAR EMP UNIT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37001','8','HOME CARE','THE EVERETT CHALMERS REGIONAL HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37003','0','COMMUNITY CLIN','FUNDY HEALTH CENTREBLACKS HARBOUR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37008','0','COMMUNITY CLIN','CTR DE SANT COMM. ST-JOSEPH','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37017','0','COMMUNITY CLIN','HARVEY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37018','0','COMMUNITY CLIN','HPITAL DE LAMQUE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37019','0','COMMUNITY CLIN','QUEENS NORTH COMMUNITY HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37024','0','COMMUNITY CLIN','TOBIQUE VALLEY COMMUNITY HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37028','0','COMMUNITY CLIN','STANLEY HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37031','0','COMMUNITY CLIN','ST. JOSEPH''S HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37033','0','COMMUNITY CLIN','CHARLOTTE COUNTY WELLNESS CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37038','0','COMMUNITY CLIN','ALBERT COUNTY HEALTH & WELLNESS CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37044','0','COMMUNITY CLIN','MCADAM HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37051','0','COMMUNITY CLIN','CENTREDESANTNOREEN-RICHARDHLTHCTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37052','0','COMMUNITY CLIN','MDISANT SAINT-JEAN','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37053','0','COMMUNITY CLIN','CTR DE SANT COMM. DE ST-ISADORE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37057','0','COMMUNITY CLIN','GIBSON HEALTH CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37058','0','COMMUNITY CLIN','CENTRAL MIRAMICHI COMM. HEALTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37062','0','COMMUNITY CLIN','OROMOCTO HEALTH CLINIC','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37063','0','COMMUNITY CLIN','FREDERICTON DOWNTOWN COMM. HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37481','P','HOSPICE/PALTIV','BOBBY''S HOSPICE - SAINT JOHN','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37482','P','HOSPICE/PALTIV','HOSPICE HOUSE - FREDERICTON','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37601','F','OTHER HEALTH','MIDWIFERY SERV. DRCHALMERSREG.HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37605','F','OTHER HEALTH','MIDWIFERYSERV.HP.RG.DECAMPBELLTON','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37609','F','OTHER HEALTH','MIDWIFERY SERV.HP.RG.D''EDMUNDSTON','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37620','F','OTHER HEALTH','MIDWIFERY SERV. THE MONCTON HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37622','F','OTHER HEALTH','MIDWIFERY SERV. MIRAMICHI REG.HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37629','F','OTHER HEALTH','MIDWIFERY SERV. ST JOHN REG. HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37639','F','OTHER HEALTH','MIDWIFERY SERV. HP. RG. CHALEUR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37648','F','OTHER HEALTH','MIDWIFERYSERV.CHUDR.GEORGESL.DUMONT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','37649','F','OTHER HEALTH','MIDWIFERYSERV.UPPERRIVERVALLEYHOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','38011','5','INPT MENTAL','CENTRE HOSPITALIER RESTIGOUCHE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','38015','5','INPT MENTAL','CENTRACARE','Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39001','E','EMERGENCY DPT','DR. EVERETT CHALMERS REGIONAL HOSP.','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39005','E','EMERGENCY DPT','HPITAL RGIONAL DE CAMPBELLTON','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39009','E','EMERGENCY DPT','HPITAL RGIONAL D''EDMUNDSTON','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39016','E','EMERGENCY DPT','GRAND MANAN HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39018','E','EMERGENCY DPT','HPITAL DE LAMQUE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39020','E','EMERGENCY DPT','THE MONCTON HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39022','E','EMERGENCY DPT','MIRAMICHI REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39023','E','EMERGENCY DPT','HOTEL-DIEU OF ST. JOSEPH','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39026','E','EMERGENCY DPT','SACKVILLE MEMORIAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39029','E','EMERGENCY DPT','SAINT JOHN REGIONAL HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39031','E','EMERGENCY DPT','ST. JOSEPH''S HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39032','E','EMERGENCY DPT','HOTEL-DIEU ST-JOSEPH DE ST-QUENTIN','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39033','E','EMERGENCY DPT','CHARLOTTE COUNTY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39034','E','EMERGENCY DPT','SUSSEX HEALTH CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39035','E','EMERGENCY DPT','HPITAL DE TRACADIE-SHEILA','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39039','E','EMERGENCY DPT','HPITAL RGIONAL CHALEUR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39041','E','EMERGENCY DPT','HPITAL DE L''ENFANT-JSUS RHSJ','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39042','E','EMERGENCY DPT','HPITAL GNRAL DE GRAND-SAULT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39045','E','EMERGENCY DPT','HPITAL DE STELLA-MARIS-DE-KENT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39046','E','EMERGENCY DPT','OROMOCTO PUBLIC HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39048','E','EMERGENCY DPT','CHU DR-GEORGES-L.-DUMONT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39049','E','EMERGENCY DPT','UPPER RIVER VALLEY HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39065','E','EMERGENCY DPT','ER-ANY NS HOSPITAL','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39070','E','EMERGENCY DPT','GENERIC NUMBER - ED','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39080','E','EMERGENCY DPT','GENERIC FAC IN USA (ED)','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39974','M','COMM MH ADDICT','GENERIC COMMUNITY MENTAL HLTH CTR','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39976','T','MH/ADDICT RX','GENERIC ADDICTION TREATMENT CENTRE','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39978','H','TRANSIT HOUSE','GENERIC HOMELESS&TRANSITIONSHELTER','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39996','C','CORRECTIONAL','CORRECTIONAL FACILITIES','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39998','8','HOME CARE','GENERIC HOME WITH SUPPORT','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB','39999','G','GROUP/SUPPORT','GENERIC SPECIAL CARE HOME','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40001','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40002','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40003','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40004','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40005','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40009','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40010','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40011','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40012','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40013','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40014','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40015','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40017','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40018','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40019','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40020','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40021','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40022','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40023','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40024','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40025','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40026','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40027','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40028','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40029','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40035','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40036','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40037','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40038','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40039','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40040','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40041','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40042','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40043','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40044','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40045','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40046','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40047','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40048','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40049','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40050','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40051','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40052','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40053','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40054','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40055','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40056','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40057','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40058','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40059','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40060','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40061','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40062','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40063','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40064','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40065','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40066','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40067','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40068','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40069','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40070','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40071','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40072','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40073','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40074','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40075','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40076','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40077','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40078','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40079','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40080','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40081','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40082','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40083','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40084','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40085','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40086','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40087','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40088','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40089','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40094','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40097','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40098','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40099','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40100','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40101','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40102','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40103','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40104','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40105','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40106','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40107','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40108','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40109','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40110','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40111','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40112','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40113','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40114','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40115','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40116','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40117','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40118','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40119','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40120','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40121','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40122','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40123','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40124','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40125','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40126','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40127','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40128','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40129','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40130','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40131','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40132','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40133','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40134','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40135','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40136','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40137','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40138','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40139','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40140','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40141','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40142','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40143','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40144','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40145','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40146','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40147','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40148','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40149','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40150','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40151','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40152','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40153','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40154','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40155','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40156','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40157','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40158','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40160','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40161','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40162','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40163','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40164','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40165','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40166','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40167','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40168','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40169','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40170','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40171','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40172','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40173','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40174','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40175','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40176','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40177','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40178','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40180','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40185','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40186','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40187','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40188','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40189','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40191','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40192','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40193','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40194','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40195','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40196','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40197','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40198','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40199','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40200','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40202','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40203','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40204','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40205','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40206','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40207','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40208','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','40209','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','41405','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42000','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42001','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42002','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42004','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42006','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42008','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42010','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42012','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42014','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42016','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42017','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42019','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42021','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42022','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42024','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42025','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42027','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42029','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42031','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42033','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42035','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42037','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42038','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42040','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42042','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42043','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42044','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42045','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42046','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42048','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42050','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42052','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42054','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42056','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42058','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42059','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42061','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42063','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42064','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42066','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42068','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42070','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42072','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42073','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42075','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42076','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42081','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42083','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42085','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42087','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42089','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42091','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42093','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42095','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42097','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42099','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42101','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42102','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42104','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42106','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42108','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42110','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42111','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42113','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42114','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42116','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42118','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42119','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42121','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42123','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42125','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42126','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42128','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42130','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42132','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42133','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42134','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42135','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42136','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42138','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42140','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42141','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42143','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42145','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42147','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42149','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42151','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42153','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42157','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42158','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42159','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42161','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42163','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42165','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42167','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42169','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42171','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42173','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42175','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42178','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42180','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42182','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42184','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42186','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42188','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42190','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42194','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42196','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42197','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42199','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42201','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42202','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42204','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42206','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42208','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42209','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42211','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42213','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42215','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42216','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42217','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42219','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42221','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42223','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42227','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42229','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42231','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42232','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42234','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42236','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42238','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42240','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42242','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42244','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42246','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42248','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42250','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42252','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42254','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42256','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42257','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42259','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42261','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42262','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42264','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42265','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42267','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42269','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42271','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42272','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42274','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42275','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42277','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42279','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42281','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42283','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42285','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42287','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42289','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42290','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42292','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42294','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42296','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42300','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42302','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42304','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42305','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42309','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42311','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42313','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42314','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42316','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42317','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42321','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42323','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42325','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42400','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42401','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42402','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42403','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42405','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42406','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42407','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','42408','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43001','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43002','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43003','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43004','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43005','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43006','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43009','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43010','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43011','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43012','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43013','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43014','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43016','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43017','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43018','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43019','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43020','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43021','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43022','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43023','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43024','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43025','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43026','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43027','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43028','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43029','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43030','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43031','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43032','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43033','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43034','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43035','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43036','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43037','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43038','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43039','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43040','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43041','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43042','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43043','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43044','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43045','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43047','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43048','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43049','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43050','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43051','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43052','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43053','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43054','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43055','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43056','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43057','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43058','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43059','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43060','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43061','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43062','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43063','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43064','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43065','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43066','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43067','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43068','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43069','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43070','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43071','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43072','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43073','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43074','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43075','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43076','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43077','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43078','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43079','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43080','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43081','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43082','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43083','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43084','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43085','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43086','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43087','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43088','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43089','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43090','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43091','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43092','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43097','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43100','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43101','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43102','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43103','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43104','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43105','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43106','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43107','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43108','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43109','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43110','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43111','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43112','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43113','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43114','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43115','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43116','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43117','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43118','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43119','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43120','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43121','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43122','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43123','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43124','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43125','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43126','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43127','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43128','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43129','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43130','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43131','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43132','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43133','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43134','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43135','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43136','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43137','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43138','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43139','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43140','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43141','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43142','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43143','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43144','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43145','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43146','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43147','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43148','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43149','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43150','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43151','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43152','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43153','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43154','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43155','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43156','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43157','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43158','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43159','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43160','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43161','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43162','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43163','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43164','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43165','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43166','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43168','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43169','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43171','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43172','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43175','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43176','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43177','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43178','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43179','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43180','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43181','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43182','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43183','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43184','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43185','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43186','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43187','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43188','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43189','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43190','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43191','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43192','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43193','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43194','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43195','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43196','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43197','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43198','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43199','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43200','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43201','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43202','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43203','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43204','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43205','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43206','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43207','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43208','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43209','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43210','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43211','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43212','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43213','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43214','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43215','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43216','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43217','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43218','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43219','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43220','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43221','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43222','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43223','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43224','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43225','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43226','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43227','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43228','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43229','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43230','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43231','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43232','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43233','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43234','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43235','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43236','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43237','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43238','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43239','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43240','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43241','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43242','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43243','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43244','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43245','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43246','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43247','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43248','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43249','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43250','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43251','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43253','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43254','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43255','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43256','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43257','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43258','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43259','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43260','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43261','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43262','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43263','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43264','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43265','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43266','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43267','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43268','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43269','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43270','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43272','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43273','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43274','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43275','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43276','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43277','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43278','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43279','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43280','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43281','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43282','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43283','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43284','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43285','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43286','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43287','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43288','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43289','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43290','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43291','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43292','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43293','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43294','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43295','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43296','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43297','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43298','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43299','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43300','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43301','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43302','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43303','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43304','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43305','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43306','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43307','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43308','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43309','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43310','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43311','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43312','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43313','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43314','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43315','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43316','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43317','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43318','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43319','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43320','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43321','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43322','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43323','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43324','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43325','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43326','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43327','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43330','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43335','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43338','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43346','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43347','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43348','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43353','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43354','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43361','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43367','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43368','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43369','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43370','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43371','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43372','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43374','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43375','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43376','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43377','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43378','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43379','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43380','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43381','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43382','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43383','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43384','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43385','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43386','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43387','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43388','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43389','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43390','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43391','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43392','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43393','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43394','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43395','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43396','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43397','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43398','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43399','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43400','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43401','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43402','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43403','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43404','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43405','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43406','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43407','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43408','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43409','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43410','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43411','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43412','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43413','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43414','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43415','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43416','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43417','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43418','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43419','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43420','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43421','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43422','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43423','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43424','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43425','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43426','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43427','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43428','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43429','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43430','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43431','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43432','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43433','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43434','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43435','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43436','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43437','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43438','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43439','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43440','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43441','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43442','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43443','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43444','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43445','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43446','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43447','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43448','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43449','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43450','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43451','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43452','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43453','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43454','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43455','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43456','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43457','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43458','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43460','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43461','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43462','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43463','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43464','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43465','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43466','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43467','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43468','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43469','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43470','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43471','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43472','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43473','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43474','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43475','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43476','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43477','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43478','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43479','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43480','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43481','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43482','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43483','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43484','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43485','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43486','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43487','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43488','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43489','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43490','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43491','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43492','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43493','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43494','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43495','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43496','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43497','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43498','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43499','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43500','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43501','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43502','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43503','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43504','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43505','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43506','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43507','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43508','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43509','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43510','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43511','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43512','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43513','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43514','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43515','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43516','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43517','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43518','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43519','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43520','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43521','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43522','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43523','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43524','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43525','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43526','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43527','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43528','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43529','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43530','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43531','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43532','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43533','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43534','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43535','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43536','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43537','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43538','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43539','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43540','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43541','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43542','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43543','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43544','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43545','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43546','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43547','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43548','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43549','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43550','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43551','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43552','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43553','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43554','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43555','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43556','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43557','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43558','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43559','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43560','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43561','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43562','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43563','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43564','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43565','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43566','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43567','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43568','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43569','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43570','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43571','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43572','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43573','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43574','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43575','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43576','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43577','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43578','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43579','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43580','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43581','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43582','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43583','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43584','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43585','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43586','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43587','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43588','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43589','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43590','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43591','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43592','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43593','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43594','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43595','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43596','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43597','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43598','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43599','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43600','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43601','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43602','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43603','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43604','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43605','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43606','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43607','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43608','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43609','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43610','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43611','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43612','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43613','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43614','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43615','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43616','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43617','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43618','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43619','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43620','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43621','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43622','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43623','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43624','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43625','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43626','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43627','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43628','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43629','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43630','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43631','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43632','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43633','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43634','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43635','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43636','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43637','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43638','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43639','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43640','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43641','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43642','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43643','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43644','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43645','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43646','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43647','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43648','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43649','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43650','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43651','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43652','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43653','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43654','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43655','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43656','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43657','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43658','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43659','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43660','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43661','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43662','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43663','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43664','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43665','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43666','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43667','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43668','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43669','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43670','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43671','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43672','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43673','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43674','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43675','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43676','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43677','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43678','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43679','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43680','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43681','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43682','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43683','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43684','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43685','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43686','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43687','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43688','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43689','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43690','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43691','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43692','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43693','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43694','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43695','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43696','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43697','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43698','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43699','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43700','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43701','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43702','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43703','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43704','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43705','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43706','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43707','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43708','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43709','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43710','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43711','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43712','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43713','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43714','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43715','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43716','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43717','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43718','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43719','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43720','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43721','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43722','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43723','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43724','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43725','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43726','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43727','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43728','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43729','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43730','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43731','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43732','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43733','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43734','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43735','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43736','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43737','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43738','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43739','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43740','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43741','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43742','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43743','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43744','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43745','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43746','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43747','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43748','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43749','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43750','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43751','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43752','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43753','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43754','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43755','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43756','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43757','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43758','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43759','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43760','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43761','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43762','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43763','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43764','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43765','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43766','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43767','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43768','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43769','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43770','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43771','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43772','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43773','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43774','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43775','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43776','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43777','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43778','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43779','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43780','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43781','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43782','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43783','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43784','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43785','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43786','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43787','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43788','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43789','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43790','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43791','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43792','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43793','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43794','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43795','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43796','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43797','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43798','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43799','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43800','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43801','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43802','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43803','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43804','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43805','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43806','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43807','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43808','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43809','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43810','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43811','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43812','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43813','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43814','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43815','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43816','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43817','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43818','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43819','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43820','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43821','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43822','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43823','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43824','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43825','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43826','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43827','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43828','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43829','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43830','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43831','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43832','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43833','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43834','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43835','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43836','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43837','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43838','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43839','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43840','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43841','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43842','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43843','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43844','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43845','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43846','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43847','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43848','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43849','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43850','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43851','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43852','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43853','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43854','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43855','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43856','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43857','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43858','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43859','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43860','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43861','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43862','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43863','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43864','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43865','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43866','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43867','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43868','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43869','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43870','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43871','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43872','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43873','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43874','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43875','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43876','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43877','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43878','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43879','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43880','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43881','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43882','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43883','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43884','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43885','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43886','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43887','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43888','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43889','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43890','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43891','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43892','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43893','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43894','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43895','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43896','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43897','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43898','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43899','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43900','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43901','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43902','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43903','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43904','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43905','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43906','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43907','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43908','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43909','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43910','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43911','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43912','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43913','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43914','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43915','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43916','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43917','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43918','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43919','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43920','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43921','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43922','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43923','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43924','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43925','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43926','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43927','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43928','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43929','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43930','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43931','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43932','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43933','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43934','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43935','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43936','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43937','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43938','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43939','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43940','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43941','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43942','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43943','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43944','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43945','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43946','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43947','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43948','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43949','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43950','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43951','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43952','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43953','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43954','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43955','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43956','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43957','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43958','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43959','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43960','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43961','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43962','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43963','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43964','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43965','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43966','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43967','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43968','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43969','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43970','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43971','1','ACUTE INPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43972','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43973','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43974','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43975','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43976','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43977','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43978','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43979','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43980','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43981','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43982','3','INPT CCC','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43983','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43984','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43986','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43987','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43988','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43989','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43990','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43992','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43993','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43994','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43995','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43996','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43997','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43998','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','43999','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44000','E','EMERGENCY DPT','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44002','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44003','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44005','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44006','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44007','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44008','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44009','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44010','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44011','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44012','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44013','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44014','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44015','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44016','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44017','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44018','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44019','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44020','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44021','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44023','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44024','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44025','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44026','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44027','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44028','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44029','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44030','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44031','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44032','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44033','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44034','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44035','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44036','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44037','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44038','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44039','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44040','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44041','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44042','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44043','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44044','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44045','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44046','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44048','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44049','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44050','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44051','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44052','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44053','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44054','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44055','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44056','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44057','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44058','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44059','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44060','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44061','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44062','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44063','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44064','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44065','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44066','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44067','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44068','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44069','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44071','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44072','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44073','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44074','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44075','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44076','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44077','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44078','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44079','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44080','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44081','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44082','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44083','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44084','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44085','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44086','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44087','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44088','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44089','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44090','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44091','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44092','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44093','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44094','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44095','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44096','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44097','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44098','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44099','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44100','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44101','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44102','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44103','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44104','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44105','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44106','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44107','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44108','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44109','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44111','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44113','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44114','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44115','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44116','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44117','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44118','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44119','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44120','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44121','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44122','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44123','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44124','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44125','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44126','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44127','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44128','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44129','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44130','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44131','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44132','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44133','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44134','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44135','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44136','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44137','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44138','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44139','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44140','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44141','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44142','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44143','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44144','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44145','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44146','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44147','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44148','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44149','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44150','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44151','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44152','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44153','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44154','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44155','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44156','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44157','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44158','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44159','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44160','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44161','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44162','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44163','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44164','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44165','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44166','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44167','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44168','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44169','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44170','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44171','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44172','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44173','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44174','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44175','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44176','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44177','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44178','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44179','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44180','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44181','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44182','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44183','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44185','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44186','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44188','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44189','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44190','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44191','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44192','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44193','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44194','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44195','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44196','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44197','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44198','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44199','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44200','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44201','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44202','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44203','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44204','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44205','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44206','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44207','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44208','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44209','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44210','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44211','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44212','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44213','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44214','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44215','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44216','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44217','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44218','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44219','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44220','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44221','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44222','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44223','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44224','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44225','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44226','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44227','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44228','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44229','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44230','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44231','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44232','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44233','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44234','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44235','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44236','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44237','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44238','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44239','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44240','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44241','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44242','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44243','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44244','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44245','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44246','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44247','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44248','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44249','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44250','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44251','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44252','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44253','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44254','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44255','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44256','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44257','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44258','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44259','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44260','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44261','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44262','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44263','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44264','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44265','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44266','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44267','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44268','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44269','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44270','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44271','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44272','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44273','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44275','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44276','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44277','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44278','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44279','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44280','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44281','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44282','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44285','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44286','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44287','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44288','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44290','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44291','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44292','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44293','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44294','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44295','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44296','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44297','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44298','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44299','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44300','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44301','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44302','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44304','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44306','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44308','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44309','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44310','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44311','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44312','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44313','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44314','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44315','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44316','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44317','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44318','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44319','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44320','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44321','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44322','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44323','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44324','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44325','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44326','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44327','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44328','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44331','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44333','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44334','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44335','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44336','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44337','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44339','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44340','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44341','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44342','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44343','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44344','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44345','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44346','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44347','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44348','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44349','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44350','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44351','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44352','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44353','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44354','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44355','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44356','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44357','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44358','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44359','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44360','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44361','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44362','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44363','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44364','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44365','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44366','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44367','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44371','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44372','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44373','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44374','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44375','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44376','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44378','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44381','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44383','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44384','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44385','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44386','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44387','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44388','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44389','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44390','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44391','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44392','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44393','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44394','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44395','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44396','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44397','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44398','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44399','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44401','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44402','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44403','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44404','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44405','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44407','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44408','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44409','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44410','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44411','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44412','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44413','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44414','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44415','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44416','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44417','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44418','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44419','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44420','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44421','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44422','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44423','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44425','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44426','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44427','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44428','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44429','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44430','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44431','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44432','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44433','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44435','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44436','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44437','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44438','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44439','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44440','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44441','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44442','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44443','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44444','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44445','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44446','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44447','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44448','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44450','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44451','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44452','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44453','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44454','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44455','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44456','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44457','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44458','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44459','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44460','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44461','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44463','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44464','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44465','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44466','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44467','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44468','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44469','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44470','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44471','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44472','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44473','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44474','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44475','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44476','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44478','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44479','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44480','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44481','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44482','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44483','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44484','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44485','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44486','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44487','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44488','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44489','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44490','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44492','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44493','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44494','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44495','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44496','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44497','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44498','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44499','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44500','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44501','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44503','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44504','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44505','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44506','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44507','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44508','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44509','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44510','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44511','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44512','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44513','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44514','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44515','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44516','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44517','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44518','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44519','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44520','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44521','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44522','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44523','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44524','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44525','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44526','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44527','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44528','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44529','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44531','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44532','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44534','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44540','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44541','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44542','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44543','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44544','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44545','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44547','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44548','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44549','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44550','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44551','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44552','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44553','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44554','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44555','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44556','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44557','A','DAY SURGERY','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44558','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44559','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44560','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44561','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44562','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44563','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44564','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44565','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44567','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44568','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44569','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44570','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44571','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44572','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44573','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44574','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44575','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44576','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44577','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44578','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44579','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44580','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44581','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44583','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44584','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44585','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44586','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44587','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44588','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44589','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44590','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44591','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44593','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44595','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44596','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44597','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44598','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44599','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44600','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44601','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44602','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44603','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44604','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44605','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44606','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44607','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44609','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44611','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44612','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44613','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44614','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44615','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44616','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44618','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44619','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44620','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44621','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44622','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44623','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44624','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44625','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44626','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44627','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44628','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44630','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44631','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44632','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44633','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44634','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44635','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44636','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44637','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44638','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44639','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44640','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44641','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44642','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44643','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44644','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44645','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44646','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44647','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44648','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44649','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44650','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44651','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44652','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44653','4','LT CARE','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44654','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44655','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44656','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44657','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44658','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44659','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44660','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44661','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44662','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44663','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44664','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44665','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44666','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44667','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44668','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44669','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44670','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44671','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44672','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44673','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44675','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44676','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44677','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44678','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44679','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44680','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44681','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44682','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44683','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44684','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44685','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44686','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44687','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44688','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44689','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44690','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44691','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44692','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44693','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44694','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44696','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44697','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44698','0','COMMUNITY CLIN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44699','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44700','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44701','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44702','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44703','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44704','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44705','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44706','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44707','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44708','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44709','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44711','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44712','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44713','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44714','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44715','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44716','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44717','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44718','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44719','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44720','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44721','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44722','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44723','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44724','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44725','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44726','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44727','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44728','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44729','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44730','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44731','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44733','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44734','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44735','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44736','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44737','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44739','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44740','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44741','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44742','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44743','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44744','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44745','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44746','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44747','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44748','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44749','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44750','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44751','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44753','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44754','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44756','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44757','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44758','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44760','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44761','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44762','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44763','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44764','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44765','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44766','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44767','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44768','2','INPT REHAB','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44769','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC','44770','U','UNKNOWN','','N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC