
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EMT_Edits_VR_AND_Conditions]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[EMT_Edits_VR_AND_Conditions]
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[MDS20_TempCalculating_VR]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[MDS20_TempCalculating_VR]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE View [dbo].[MDS20_TempCalculating_VR]
as
select 
CCRS.LinkID as zzLinkID, ChartNumber as zzChartNumber, ccrs.AdmitDate as zzAdmitDate, 
I.DisplayCode as zzInstitutionNumber,    I.UserDescription as zzInstitutionDesc,
zzLastAssessmentType = 
    (case when DischargeAssessment.LinkID is null
            and QuarterAssessment.LinkID is null and AnnualAssessment.LinkID is null
            and FullAssessment.LinkID is null and ReEntryAssessment.LinkID is null
        then '0'
        when ReEntryAssessment.LinkID is not null 
        then (case when QuarterAssessment.LinkID is null and AnnualAssessment.LinkID is null and FullAssessment.LinkID is null
                   then '0' 
                   when ReEntryAssessment.AssessmentDate > isnull(QuarterAssessment.AssessmentDate, '1950/01/01')
                   then (case when ReEntryAssessment.AssessmentDate > isnull(AnnualAssessment.AssessmentDate, '1950/01/01')
                              then (case when ReEntryAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                                         then '9'    --Reentry
                                         else '1'    --Full
                                    end)
                              else (case when AnnualAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                                         then '2'    --Annual
                                         else '1'    --Full
                                    end)
                        end)
                   else (case when QuarterAssessment.AssessmentDate > isnull(AnnualAssessment.AssessmentDate, '1950/01/01')
                              then (case when QuarterAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                                         then '5'    --Quarter
                                         else (case when AnnualAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                                                    then '2'    --Annual
                                                    else '1'    --Full
                                               end)
                                    end)
                              else (case when AnnualAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                                         then '2'    --Annual
                                         else '1'    --Full
                                    end)
                        end)
             end)
        when QuarterAssessment.LinkID is null
        then (case when FullAssessment.LinkID is null --and AnnualAssessment.AssessmentDate is null 
                   then '0'     --Admit
                   else '1'     --Full A
             end)
        when QuarterAssessment.AssessmentDate > isnull(AnnualAssessment.AssessmentDate, '1950/01/01')
        then (case when QuarterAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                   then '5' --Quarter
                   else '1'
             end)
        else (case when AnnualAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                   then '2' --Annual
                   else '1'
             end)
    end), 
zzLastAssessmentDate = 
    (case when DischargeAssessment.LinkID is null and QuarterAssessment.LinkID is null and AnnualAssessment.LinkID is null
            and FullAssessment.LinkID is null and ReEntryAssessment.LinkID is null
        then CCRS.AdmitDate     --Admit
        when ReEntryAssessment.LinkID is not null 
            and QuarterAssessment.AssessmentDate is null and FullAssessment.AssessmentDate is null and AnnualAssessment.AssessmentDate is null
        then CCRS.AdmitDate --Admit
        --then (case when ReEntryAssessment.AssessmentDate > isnull(QuarterAssessment.AssessmentDate, '1950/01/01')
        --           then (case when ReEntryAssessment.AssessmentDate > isnull(AnnualAssessment.AssessmentDate, '1950/01/01')
        --                      then (case when ReEntryAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
        --                                 then ReEntryAssessment.AssessmentDate    --Reentry
        --                                 else FullAssessment.AssessmentDate       --Full
        --                            end)
        --                      else (case when AnnualAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
        --                                 then AnnualAssessment.AssessmentDate    --Annual
        --                                 else FullAssessment.AssessmentDate      --Full
        --                            end)
        --                end)
        --           else (case when QuarterAssessment.AssessmentDate > isnull(AnnualAssessment.AssessmentDate, '1950/01/01')
        --                      then (case when QuarterAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
        --                                 then QuarterAssessment.AssessmentDate    --Quarter
        --                                 else FullAssessment.AssessmentDate       --Full
        --                            end)
        --                      else (case when AnnualAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
        --                                 then AnnualAssessment.AssessmentDate    --Annual
        --                                 else FullAssessment.AssessmentDate      --Full
        --                            end)
        --                end)
        --     end)
        when QuarterAssessment.AssessmentDate is null
        then (case when FullAssessment.AssessmentDate is null --and AnnualAssessment.AssessmentDate is null 
                   then CCRS.AdmitDate                   --Admit
                   else FullAssessment.AssessmentDate    --Full 
             end)
        when QuarterAssessment.AssessmentDate > isnull(AnnualAssessment.AssessmentDate, '1950/01/01')
        then (case when QuarterAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                   then QuarterAssessment.AssessmentDate  --Quarter
                   else (case when isnull(AnnualAssessment.AssessmentDate, '1950/01/01') > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                              then AnnualAssessment.AssessmentDate --Annual
                              else FullAssessment.AssessmentDate   --Full
                         end)
             end)
        else (case when isnull(AnnualAssessment.AssessmentDate, '1950/01/01') > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                   then AnnualAssessment.AssessmentDate --Annual
                   else FullAssessment.AssessmentDate   --Full
             end)
    end), 
zzLastFullAssessment = 
    (case when FullAssessment.LinkID is null and AnnualAssessment.LinkID is null and ReEntryAssessment.LinkID is null 
          then CCRS.AdmitDate     --Admit
          else (case when AnnualAssessment.AssessmentDate is not null
                     then (case when AnnualAssessment.AssessmentDate > isnull(FullAssessment.AssessmentDate, '1950/01/01')
                                then AnnualAssessment.AssessmentDate --Annual
                                else FullAssessment.AssessmentDate   --Full
                           end)
                     else FullAssessment.AssessmentDate
                end)
    end)
from 
CRS_Demographic CCRS with (nolock)
inner join H_InstitutionProfile I with (nolock) on CCRS.InstitutionNumber = I.Code
left join 
	(select Max(A3) as AssessmentDate, LinkID
	 from CRS_Demographic CCRS with (nolock) inner join LU_CodeFile LU_AA8 with (nolock) on CCRS.AA8 = LU_AA8.Code
	 where AbstractID <> LinkID and LU_AA8.CIHIValue = '01'
	 group by LinkID
	 having Max(A3) is not null ) FullAssessment on CCRS.LinkID = FullAssessment.LinkID

left join 
	(select Max(A3) as AssessmentDate, LinkID
	 from CRS_Demographic CCRS with (nolock) inner join LU_CodeFile LU_AA8 with (nolock) on CCRS.AA8 = LU_AA8.Code
	 where AbstractID <> LinkID and LU_AA8.CIHIValue in ('02')
	 group by LinkID
	 having Max(A3) is not null ) AnnualAssessment on CCRS.LinkID = AnnualAssessment.LinkID
left join  
	(select Max(A3) as AssessmentDate, LinkID
	 from CRS_Demographic CCRS with (nolock) inner join LU_CodeFile LU_AA8 with (nolock) on CCRS.AA8 = LU_AA8.Code
	 where AbstractID <> LinkID and LU_AA8.CIHIValue in ('05')
	 group by LinkID
	 having Max(A3) is not null ) QuarterAssessment on CCRS.LinkID = QuarterAssessment.LinkID
left join  
	(select Max(DischargeDate) as DischargeDate, LinkID, max(AdmitDate) as AdmitDate
	 from CRS_Demographic CCRS with (nolock) inner join LU_CodeFile LU_AA8 with (nolock) on CCRS.AA8 = LU_AA8.Code
	 where AbstractID <> LinkID and LU_AA8.CIHIValue in ('06', '07', '08')
	 group by LinkID
	 having Max(DischargeDate) is not null ) DischargeAssessment on CCRS.LinkID = DischargeAssessment.LinkID
left join 
	(select Max(AdmitDate) as AssessmentDate, LinkID
	 from CRS_Demographic CCRS with (nolock) inner join LU_CodeFile LU_AA8 with (nolock) on CCRS.AA8 = LU_AA8.Code
	 where AbstractID <> LinkID and LU_AA8.CIHIValue in ('09')
	 group by LinkID
	 having Max(AdmitDate) is not null ) ReEntryAssessment on CCRS.LinkID = ReEntryAssessment.LinkID

where CCRS.AbstractID = CCRS.LinkID and (DischargeAssessment.LinkID is null 
or (DischargeAssessment.DischargeDate < ReEntryAssessment.AssessmentDate )
or (DischargeAssessment.DischargeDate = ReEntryAssessment.AssessmentDate and DischargeAssessment.AdmitDate < ReEntryAssessment.AssessmentDate))



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

---------------------------------------------  Central_Patient_Index_VR
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Index_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Index_VR]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Index_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE    VIEW [dbo].[Central_Patient_Index_VR]
AS
SELECT dbo.CM_CPI.AlternateAddress, dbo.CM_CPI.AlternatePhone AS AlternatePhoneNumber, dbo.CM_CPI.BirthDate, dbo.CM_CPI.ChartNumber, 
    dbo.CM_CPI.CellPhone, dbo.CM_Notes.PatientNotes AS CPINotes, dbo.CM_CPI.DeathDate AS DatePatientDied, 
    LU_DeathIndicator.DisplayCode AS DeathIndicator, LU_DeathIndicator.UserDescription AS DeathIndicatorDesc, 
    LU_DiagMethod.DisplayCode AS DiagnosisMethod, LU_DiagMethod.UserDescription AS DiagnosisMethodDesc, dbo.CM_CPI.DuplicateChart, 
    Lookup1.DisplayCode AS Education, Lookup1.UserDescription AS EducationDesc, dbo.CM_CPI.EMail, dbo.CM_CPI.EmployerAddress, 
    dbo.CM_CPI.EmployerName, dbo.CM_CPI.EmployerFax, dbo.CM_CPI.EmployerPhone AS EmployerPhoneNumber, 
    dbo.CM_CPI.PhysicianAddress AS FamilyPhysicianAddress, dbo.CM_CPI.PhysicianNumber AS FamilyPhysicianName, 
    dbo.CM_CPI.PhysicianPhone AS FamilyPhysicianPhoneNumber, dbo.CM_CPI.FaxNumber, dbo.CM_CPI.FirstDiagDate AS FirstDiagnosisDate, 
    dbo.CM_CPI.FirstName, dbo.CM_CPI.FixedChartNumber,
    dbo.CM_CPI.FutureDate, Lookup2.DisplayCode AS Gender, Lookup2.UserDescription AS GenderDesc, 
    dbo.CM_CPI.GroupNum1 AS GroupInsuranceNumber1, dbo.CM_CPI.GroupNum2 AS GroupInsuranceNumber2, Lookup3.DisplayCode AS HCNProvince, 
    Lookup3.UserDescription AS HCNProvinceDesc, dbo.CM_CPI.HCNVersion, dbo.CM_CPI.HealthCareNumber, 
    
    LU_HighRisk.DisplayCode AS HighRisk,     LU_HighRisk.UserDescription AS HighRiskDesc, 
    
    LU_Hospital.DisplayCode AS Hospital,     LU_Hospital.UserDescription AS HospitalDesc, 
    IAR_AssessmentConsentFlag = LU_IAR_ConsentFlag.DisplayCode, IAR_AssessmentConsentFlagDesc = LU_IAR_ConsentFlag.UserDescription,

    dbo.CM_CPI.EmergAddress AS InEmergencyAddress, dbo.CM_CPI.EmergContact AS InEmergencyName,
    dbo.CM_CPI.EmergPhone AS InEmergencyPhoneNumber, Lookup4.DisplayCode AS InEmergencyRelationship, 
    Lookup4.UserDescription AS InEmergencyRelationshipDesc, dbo.LU_InsuranceCompany.DisplayCode AS InsuranceCompany1, 
    dbo.LU_InsuranceCompany.UserDescription AS InsuranceCompany1Desc, LU_InsuranceCompany_1.DisplayCode AS InsuranceCompany2, 
    LU_InsuranceCompany_1.UserDescription AS InsuranceCompany2Desc, dbo.CM_CPI.InsurPolicy1 AS InsurancePolicy1, 
    dbo.CM_CPI.InsurPolicy2 AS InsurancePolicy2, Lookup5.DisplayCode AS IsBirthdateEstimated, Lookup5.UserDescription AS IsBirthdateEstimatedDesc,
    LU_PrintLabel.DisplayCode AS LabelPrinted, LU_PrintLabel.UserDescription AS LabelPrintedDesc, Lookup6.DisplayCode AS [Language], 
    Lookup6.UserDescription AS LanguageDesc, dbo.CM_CPI.LastName, dbo.CM_CPI.LastVisitDate, dbo.LU_Provider.DisplayCode AS LinkedProvider, 
    dbo.LU_Provider.UserDescription AS LinkedProviderDesc, Lookup7.DisplayCode AS LivingArrangement, Lookup7.UserDescription AS LivingArrangementDesc, 
    LU_LockedChart.DisplayCode AS LockedChart, LU_LockedChart.UserDescription AS LockedChartDesc, 
    dbo.CM_CPI.MaidenName, Lookup8.DisplayCode AS MaritalStatus, 
    Lookup8.UserDescription AS MaritalStatusDesc, CM_CPI_1.ChartNumber AS MasterChart, dbo.CM_CPI.MedReferralDate AS MedicalReferralDate, 
    dbo.CM_CPI.MiddleName, dbo.CM_CPI.MothersChart, dbo.CM_CPI.BirthName AS NameAtBirth, ISNULL(dbo.CM_CPI.LastName, '' '') 
    + '', '' + ISNULL(dbo.CM_CPI.FirstName, '' '') + '' '' + ISNULL(dbo.CM_CPI.MiddleName, '''') AS NameFull, dbo.CM_CPI.NextKinAddress AS NextofKinAddress, 
    dbo.CM_CPI.NextKin AS NextofKinName, dbo.CM_CPI.NextKinPhone AS NextofKinPhoneNumber, Lookup9.DisplayCode AS NextofKinRelationship, 
    Lookup9.UserDescription AS NextofKinRelationshipDesc, Lookup10.DisplayCode AS Occupation, Lookup10.UserDescription AS OccupationDesc, 
    dbo.LU_CPIOption1.DisplayCode AS OptionField1, dbo.LU_CPIOption1.UserDescription AS OptionField1Desc, 
    dbo.LU_CPIOption2.DisplayCode AS OptionField2, dbo.LU_CPIOption2.UserDescription AS OptionField2Desc, dbo.CM_CPI.BirthPlace AS PlaceofBirth, 
    dbo.CM_CPI.PrevAddress AS PreviousAddress, dbo.CM_CPI.PrevPhone AS PreviousPhone, dbo.CM_CPI.PostalCode, dbo.CM_CPI.PrimaryAddress, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.CM_CPI.PostalCode, ''''), getdate()) AS PostalCodeDesc, -- ED - 01682

    dbo.CM_CPI.PrimaryAddress2, dbo.CM_CPI.City AS PrimaryCity, dbo.LU_CPI_Country.DisplayCode AS PrimaryCountry, 
    dbo.LU_CPI_Country.UserDescription AS PrimaryCountryDesc, dbo.LU_CPI_Province.DisplayCode AS PrimaryProvince, 
    dbo.LU_CPI_Province.UserDescription AS PrimaryProvinceDesc, dbo.CM_CPI.PrimaryPhone AS PrimaryPhoneNumber, 
    dbo.CM_CPI.RadReferralDate AS RadiationReferralDate, 
    --pr - 03389
    dbo.LU_Region.DisplayCode AS RegionCode, dbo.LU_Region.UserDescription AS RegionCodeDesc, 
    Lookup12.DisplayCode AS ResidenceCode, Lookup12.UserDescription AS ResidenceCodeDesc, 
    Lookup13.DisplayCode AS ResidenceType, Lookup13.UserDescription AS ResidenceTypeDesc, 
    CM_CPI.ROILegalComments,
    dbo.CM_CPI.Salutation, Lookup14.DisplayCode AS SecretVIPPatient, Lookup14.UserDescription AS SecretVIPPatientDesc, 
    LU_CodeFile_1.DisplayCode AS SensitivityLevel, LU_CodeFile_1.UserDescription AS SensitivityLevelDesc, 
    dbo.CM_CPI.SocialInsurNumber AS SocialInsuranceNumber, dbo.CM_CPI.SupCareReferralDate AS SupportiveCareReferralDate, 
    dbo.CM_CPI.UniqiueLifetimeID, dbo.CM_CPI.WSIB, 
    dbo.CM_CPI.PatientID AS zzPatientLink,
    dbo.CM_CPI.RegionalPatientID as zzRegionalPatientID 
FROM dbo.CM_CPI with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_1 with (nolock) ON dbo.CM_CPI.SensitivityLevel = LU_CodeFile_1.Code LEFT OUTER JOIN
    dbo.LU_InsuranceCompany LU_InsuranceCompany_1 with (nolock) ON dbo.CM_CPI.InsurCompany2 = LU_InsuranceCompany_1.Code LEFT OUTER JOIN
    dbo.LU_InsuranceCompany with (nolock) ON dbo.CM_CPI.InsurCompany1 = dbo.LU_InsuranceCompany.Code LEFT OUTER JOIN
    dbo.LU_CPI_Country with (nolock) ON dbo.CM_CPI.Country = dbo.LU_CPI_Country.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_DeathIndicator with (nolock) ON dbo.CM_CPI.DeathIndicator = LU_DeathIndicator.Code LEFT OUTER JOIN
    dbo.CM_CPI CM_CPI_1 with (nolock) ON dbo.CM_CPI.MasterChart = CM_CPI_1.PatientID LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_PrintLabel with (nolock) ON dbo.CM_CPI.LabelPrinted = LU_PrintLabel.Code LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) ON dbo.CM_CPI.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_DiagMethod with (nolock) ON dbo.CM_CPI.DiagMethod = LU_DiagMethod.Code LEFT OUTER JOIN
    dbo.LU_CPI_Province with (nolock) ON dbo.CM_CPI.Province = dbo.LU_CPI_Province.Code LEFT OUTER JOIN
    dbo.LU_CPIOption1 with (nolock) ON dbo.CM_CPI.OptionField1 = dbo.LU_CPIOption1.Code LEFT OUTER JOIN
    dbo.LU_CPIOption2 with (nolock) ON dbo.CM_CPI.OptionField2 = dbo.LU_CPIOption2.Code LEFT OUTER JOIN
    dbo.LU_Provider with (nolock) ON dbo.CM_CPI.LinkProviderNumber = dbo.LU_Provider.Code LEFT OUTER JOIN
    dbo.CM_Notes with (nolock) ON dbo.CM_CPI.PatientID = dbo.CM_Notes.PatientID LEFT OUTER JOIN
    dbo.LU_Education Lookup1 with (nolock) ON dbo.CM_CPI.EducationLevel = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup2 with (nolock) ON dbo.CM_CPI.Gender = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup3 with (nolock) ON dbo.CM_CPI.HCNProvince = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_Relationship Lookup4 with (nolock) ON dbo.CM_CPI.EmergRelation = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup5 with (nolock) ON dbo.CM_CPI.BirthDateEstimated = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_Language Lookup6 with (nolock) ON dbo.CM_CPI.LanguageCode = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_LivingArrangement Lookup7 with (nolock) ON dbo.CM_CPI.LivingArrangement = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_MaritalStatus Lookup8 with (nolock) ON dbo.CM_CPI.MaritalStatus = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_Relationship Lookup9 with (nolock) ON dbo.CM_CPI.NextKinRelation = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_Occupation Lookup10 with (nolock) ON dbo.CM_CPI.Occupation = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup12 with (nolock) ON dbo.CM_CPI.ResidenceCode = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_ResidenceType Lookup13 with (nolock) ON dbo.CM_CPI.ResidenceType = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup14 with (nolock) ON dbo.CM_CPI.Secret = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_YesBlank LU_LockedChart with (nolock) ON dbo.CM_CPI.LockedChart = LU_LockedChart.Code LEFT OUTER JOIN
    --PR - 03389
    dbo.LU_Region with (nolock) ON Lookup12.RegionCode = dbo.LU_Region.Code left OUTER JOIN
    --PR - 05833
    dbo.LU_CodeFile LU_IAR_ConsentFlag with (nolock) ON dbo.CM_CPI.IAR_ConsentFlag = LU_IAR_ConsentFlag.Code left join
    dbo.LU_CodeFile LU_HighRisk with (nolock) ON dbo.CM_CPI.HighRisk = LU_HighRisk.Code 
    
--QA - 00032 disable the domain securite issue
----PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CM_CPI.HospitalID is null or CM_CPI.HospitalID = 0
--    --EN - 00666
--    or Is_Member(nullif(ReportGroup, '''')) = 1
----    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CM_CPI.HospitalID, 0))



' 
GO



---Others views
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[WorkloadMeasurement_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[WorkloadMeasurement_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[VisitHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[VisitHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ViewsStructure_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ViewsStructure_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[View_Report_Dictionary]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[View_Report_Dictionary]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UserProfile_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[UserProfile_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UserProfile_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[UserProfile_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UD_RelOI_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[UD_RelOI_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UD_I9_AbstractingMB_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[UD_I9_AbstractingMB_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UD_Central_Patient_Index_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[UD_Central_Patient_Index_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[UD_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Signature_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Signature_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_SubmissionRecord_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_SubmissionRecord_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_SubmissionAudit]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_SubmissionAudit]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_SearchDetailCPI_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_SearchDetailCPI_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_SearchDetail_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_SearchDetail_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_Search_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_Search_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_ReportHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_ReportHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_Purged_Information_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_Purged_Information_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_LoginAudit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_LoginAudit_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_EncoderLog_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_EncoderLog_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Sec_AbstractAudit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Sec_AbstractAudit_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[RelOIUpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[RelOIUpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[RelOISentItems_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[RelOISentItems_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[RelOIPayments_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[RelOIPayments_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[RelOIActions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[RelOIActions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ReIOIMain_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ReIOIMain_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ReIOIDocument_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ReIOIDocument_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[RehabErrorsWarnings_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[RehabErrorsWarnings_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[RehabAdmissionFIM_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[RehabAdmissionFIM_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[RehabAdmission_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[RehabAdmission_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_UD_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_RPG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_RPG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_RecordInformation_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_RecordInformation_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_Providers_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_Providers_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_Projects_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_Notes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_Notes_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_Interventions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_Interrupt_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_Interrupt_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_InHospital_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_InHospital_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_FIM_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_FIM_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_BasicOption_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_BasicOption_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Rehab_Ancillary_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Rehab_Ancillary_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Purged_Record_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Purged_Record_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[PAC10_CACS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[PAC10_CACS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRSErrorsWarnings_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRSErrorsWarnings_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRSbyElementID_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRSbyElementID_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_UD_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_Serv_Interrupt_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_Serv_Interrupt_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_SCIPP_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_SCIPP_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_RoleRelations_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_RoleRelations_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_ResDischarge_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_ResDischarge_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_ReferenceDate_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_ReferenceDate_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_RecordInformation_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_RecordInformation_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_QualityIndicators_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_QualityIndicators_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_Providers_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_Providers_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_Projects_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_Notes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_Notes_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_MHAPS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_MHAPS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_Medication_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_Medication_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_MedicalDiagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_MedicalDiagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_Interventions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_InHospital_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_InHospital_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_IAR_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_IAR_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_DSM_Diag_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_DSM_Diag_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_DSM_Diag_AxisII_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_DSM_Diag_AxisII_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_DSM_5_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_DSM_5_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_CIHIErrors_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_CIHIErrors_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_BasicOption_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_BasicOption_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[OMHRS_AncillaryField_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[OMHRS_AncillaryField_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Messages_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Messages_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Merge_Volume_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Merge_Volume_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Merge_ROI_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Merge_ROI_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Merge_Records_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Merge_Records_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Merge_Main_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Merge_Main_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Merge_Deficiency_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Merge_Deficiency_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_UD_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Signature_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Signature_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Shared_5_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Shared_5_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Shared_4_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Shared_4_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Shared_3_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Shared_3_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Shared_2_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Shared_2_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Shared_1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Shared_1_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_RUGS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_RUGS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_RUGS_Plus_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_RUGS_Plus_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_RUGS_34_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_RUGS_34_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_RAP_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_RAP_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Quality_Indicators_Detail_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Quality_Indicators_Detail_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_PURS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_PURS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Outcome_Scales]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Outcome_Scales]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Out_Hospital_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Out_Hospital_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Notes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Notes_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Next_Assessment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Next_Assessment_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Medication_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Medication_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Last_Submitted_Assessment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Last_Submitted_Assessment_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Last_Assessment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Last_Assessment_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_In_Hospital_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_In_Hospital_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Hobic_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Hobic_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_General_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_General_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_FULL_2_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_FULL_2_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_FULL_1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_FULL_1_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_First_Assessment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_First_Assessment_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_ErrorsWarnings_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_ErrorsWarnings_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_CAP_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_CAP_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_BasicOption_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_BasicOption_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_Admission_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_Admission_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDS20_2010_QI_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDS20_2010_QI_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDAS_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDAS_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[MDAS_AuditTrail_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[MDAS_AuditTrail_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[M_DatabaseUpdates_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[M_DatabaseUpdates_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LUProviderSuspension_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LUProviderSuspension_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_ProviderUnavailable_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_ProviderUnavailable_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_ProviderSpecialties_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_ProviderSpecialties_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_ProviderServices_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_ProviderServices_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_ProviderLog_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_ProviderLog_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_Provider_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_Provider_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_PostalCode_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_PostalCode_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_LookUpTableName_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_LookUpTableName_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_InterventionCat_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_InterventionCat_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_Intervention_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_Intervention_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_DiagnosisCat_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_DiagnosisCat_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[LU_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[LU_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Submissions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Submissions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_SpecialCareUnits_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_SpecialCareUnits_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_QBP_Flag]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_QBP_Flag]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Provider_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Provider_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_Question_24_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_Question_24_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_740_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_740_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_640_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_640_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_340_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_340_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_316_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_316_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_315_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_315_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_250_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_250_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_202_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_202_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_150_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_150_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_100_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_100_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_065_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_065_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Projects_060_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Projects_060_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_PatientService_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_PatientService_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Obstetrics_Newborn_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Obstetrics_Newborn_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_TransferWorksheet_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_MB_TransferWorksheet_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_ReproductiveNewborn_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_MB_ReproductiveNewborn_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_NonALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_MB_NonALC_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_FacilityStudy_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_MB_FacilityStudy_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_ALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_MB_ALC_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Interventions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_InterventionReplicate_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_InterventionReplicate_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_HIG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_HIG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_DPG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_DPG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_DiagnosisToICD9cm_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_DiagnosisToICD9cm_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CRS_General_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_CRS_General_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMGOntPerc2002_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_CMGOntPerc2002_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMGAverages_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_CMGAverages_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_CMG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMG_NonComplex_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_CMG_NonComplex_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMG_2002Percentile]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_CMG_2002Percentile]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_BasicOption_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_BasicOption_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmcareRecordKey_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AmcareRecordKey_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmcareGeneral_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AmcareGeneral_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmcareCIHIErrors]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AmcareCIHIErrors]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting_BC_2009]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_statistic_Reporting_BC_2009]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting_BC]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_statistic_Reporting_BC]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting_2009]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_statistic_Reporting_2009]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_statistic_Reporting]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Providers_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Providers_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_Question_24_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_Question_24_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_966_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_966_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_965_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_965_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_964_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_964_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_963_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_963_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_962_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_962_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_961_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_961_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_960_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_960_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_740_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_740_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_640_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_640_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_340_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_340_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_316_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_316_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_315_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_315_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_250_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_250_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_202_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_202_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_150_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_150_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_100_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_100_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_065_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_065_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_060_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Projects_060_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Profile_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Profile_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_PresentingComplaint]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_PresentingComplaint]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_MIS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_MIS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Level1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Level1_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Interventions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_InterventionReplication_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_InterventionReplication_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_EDInvestigativeTechnology_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_EDInvestigativeTechnology_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_EDInterventionPicklist_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_EDInterventionPicklist_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_DischargeDiagnosis]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_DischargeDiagnosis]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Consult_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Amcare_Consult_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmCare_CCM_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AmCare_CCM_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmCare_CCM_SystemicDrug_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AmCare_CCM_SystemicDrug_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmCare_CACS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AmCare_CACS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AllAbstractingGeneral1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AllAbstractingGeneral1_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractNotes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AbstractNotes_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingRecordKey_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AbstractingRecordKey_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingInterventionReplicate_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AbstractingInterventionReplicate_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingGeneral_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AbstractingGeneral_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingBasics1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AbstractingBasics1_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstracting_Profile_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Abstracting_Profile_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstracting]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Abstracting]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractCIHIErrors_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_AbstractCIHIErrors_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstract_CJRR_Parts]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Abstract_CJRR_Parts]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstract_CJRR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Abstract_CJRR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstract_CACS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[I10_Abstract_CACS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Grouper_Audit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Grouper_Audit_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[EMT_Logical_Conditions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[EMT_Logical_Conditions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[EMT_FieldConditions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[EMT_FieldConditions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[EMT_Edits_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[EMT_Edits_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_SpecialCareUnits_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_SpecialCareUnits_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Provider_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_Provider_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_Projects_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_PatientService_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_PatientService_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_MB_NonALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_MB_NonALC_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_MB_FacilityStudy_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_MB_FacilityStudy_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_MB_ALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_MB_ALC_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_Interventions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_DPG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_DPG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_CMG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_CMG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[DAD_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CMG_Benchmarks_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CMG_Benchmarks_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_UD_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_TibialInsert_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_TibialInsert_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_TibialComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_TibialComponent_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_PatellarComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_PatellarComponent_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_FemoralHead_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_FemoralHead_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_FemoralComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_FemoralComponent_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_ErrorsWarnings_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_ErrorsWarnings_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_Cement_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_Cement_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_AcetabularInsert_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_AcetabularInsert_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_AcetabularComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CJRR_AcetabularComponent_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartVisitHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ChartVisitHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartNumberMasked_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ChartNumberMasked_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocatorCurrentAct_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ChartLocatorCurrentAct_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ChartLocator_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ChartLocator_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_PullList_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ChartLocator_PullList_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_PullList_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[ChartLocator_PullList_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_DeficiencyStatusbyVisit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Chart_DeficiencyStatusbyVisit_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Chart_Deficiency_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Chart_Deficiency_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_Transfer_History_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Chart_Deficiency_Transfer_History_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_Current_Transfer_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Chart_Deficiency_Current_Transfer_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Volume_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Volume_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Volume_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Volume_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_RiskFactors_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_RiskFactors_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_MergeChart_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_MergeChart_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_LinkedChart_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_LinkedChart_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Index_Notes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Index_Notes_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Index_Alias_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Index_Alias_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Contacts_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Contacts_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_BabyChart_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_BabyChart_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Alias_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Alias_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Alerts_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Central_Patient_Alerts_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_UpdateHistory_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_UD_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_NDFP_Enrollment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_NDFP_Enrollment_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_HealthCareProfessional_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_HealthCareProfessional_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_SysDrugDelivery_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_Entity_SysDrugDelivery_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_RadPlanTreatActivity_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_Entity_RadPlanTreatActivity_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_Patient_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_Entity_Patient_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_NDFP_Enrollment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_Entity_NDFP_Enrollment_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_Healthcare_Professional_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_Entity_Healthcare_Professional_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_Disease_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_Entity_Disease_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_ClinicVisit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_Entity_ClinicVisit_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_AbstractNotes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[CCM_AbstractNotes_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Providers_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_Providers_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_Projects_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_MIS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_MIS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_Interventions_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_DPG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_DPG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_Diagnosis_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_CACS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_CACS_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[Amcare_Abstracting_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[AbstractQueue_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[AbstractQueue_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[AbstractQueue_LOG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[AbstractQueue_LOG_VR]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[AbstractingErrorsWarnings_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[AbstractingErrorsWarnings_VR]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[AbstractingErrorsWarnings_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AbstractingErrorsWarnings_VR]
AS
SELECT 
    CIHI_ElementID = U_UsersFields.CIHI_ID,
    FieldName = U_UsersFields.Header_User, 
    --ErrorMessage = dbo.MG_Messages.MessageText, 
    MessageLevel = CASE AB_ErrorMessages.MessageType WHEN 1 THEN ''Warning'' 
                                    WHEN 2 THEN ''Error'' 
                                    WHEN 3 THEN ''Critical'' 
                                    WHEN 0 THEN ''Information'' 
                                    WHEN 5 THEN ''Question'' 
									WHEN 4 THEN ''Custom Warning'' 
									WHEN 8 THEN ''Custom Critical'' 
									WHEN 9 THEN ''Custom Error'' 
									WHEN 10 THEN ''Custom Information'' 
					END, 
    MessageType = CASE when AB_ErrorMessages.MessageType in (4, 8, 9, 10) THEN ''EMT'' ELSE '''' END, 
    AB_ErrorMessages.MessageText, 
    AB_ErrorMessages.SaveDate, 
    AB_ErrorMessages.AbstractID AS zzAbstractLink
FROM dbo.AB_ErrorMessages with (nolock)
    --left join dbo.MG_Messages with (nolock)
    --    on dbo.AB_ErrorMessages.MessageKey = dbo.MG_Messages.MessageKey
    left join dbo.AB_ErrorMessageFields with (nolock)
        on dbo.AB_ErrorMessages.AppID = dbo.AB_ErrorMessageFields.AppID
            and dbo.AB_ErrorMessages.AbstractID = dbo.AB_ErrorMessageFields.AbstractID 
            and dbo.AB_ErrorMessages.MessageKey = dbo.AB_ErrorMessageFields.MessageKey
    left join dbo.U_UsersFields with (nolock) 
        on UserID = 1 and dbo.AB_ErrorMessages.AppID = dbo.U_UsersFields.AppID and 
        (case when isnumeric(replace(dbo.AB_ErrorMessageFields.FieldKey, ''FK'', '''')) = 1 
              then replace(dbo.AB_ErrorMessageFields.FieldKey, ''FK'', '''')
              else 0 end) = dbo.U_UsersFields.FieldID 
Where AB_ErrorMessages.appid in (100,101,102,200,201,202,301,401)



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[AbstractQueue_LOG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE view  [dbo].[AbstractQueue_LOG_VR] 
as
select
    AB_Abstract.AdmitDate, 
    AB_Abstract.AdmitTime, 
    LU_AssignedBy.DisplayCode as AssignedBy,     LU_AssignedBy.UserDescription as AssignedByDesc, 
    AssignedTime,
    AB_Abstract.ChartNumber,
    LU_Coder.DisplayCode as Coder,     LU_Coder.UserDescription as CoderDesc, 
    (case when AB_AbstractQueueLog.IsCompleted = ''Y'' then LU_CompletedBy.DisplayCode else null end) as CompletedBy,     
    (case when AB_AbstractQueueLog.IsCompleted = ''Y'' then LU_CompletedBy.UserDescription else null end) as CompletedByDesc, 
    dbo.AB_AbstractQueueLog.CompletedTime,
    (case AB_Abstract.CareType when 1 then ''Inpatient'' when 2 then ''SDS'' when 5 then ''Amcare'' else '''' end) as CareType ,
    --LoanLU_Location.DisplayCode as CurrentLocation,     LoanLU_Location.UserDescription as CurrentLocationDesc, 
    AB_Abstract.DischargeDate, 
    AB_Abstract.DischargeTime, 
    AB_Abstract.FirstName,
    H_InstitutionProfile.Displaycode as InstitutionNumber,     H_InstitutionProfile.UserDescription as InstitutionNumberDesc,
    (case when AB_AbstractQueueLog.IsCompleted = ''Y'' then ''Yes'' else ''No'' end) as IsCompleted,
    LU_MISCode.DisplayCode as MISCode,     LU_MISCode.UserDescription as MISCodeDesc, 
    AB_Abstract.LastName,
    AB_Abstract.EncounterNumber as RegistrationNumber,
    (case when AB_AbstractQueueLog.IsCompleted = ''N'' then LU_CompletedBy.DisplayCode else null end) as UnassignedBy,     
    (case when AB_AbstractQueueLog.IsCompleted = ''N'' then LU_CompletedBy.UserDescription else null end) as UnassignedByDesc, 
    AB_AbstractQueueLog.AbstractID as zzAbstractLink
from dbo.AB_AbstractQueueLog with (nolock) 
    inner join AB_Abstract with (nolock) on AB_AbstractQueueLog.AbstractID = AB_Abstract.AbstractID
    inner join H_InstitutionProfile with (nolock) on H_InstitutionProfile.Code = AB_Abstract.InstitutionNumber
    left join LU_MISCode with (nolock) on LU_MISCode.Code = AB_Abstract.MISCode
    left join U_Users LU_Coder with (nolock) on LU_Coder.Code = AB_AbstractQueueLog.Coder
    left join U_Users LU_AssignedBy with (nolock) on LU_AssignedBy.Code = AB_AbstractQueueLog.AssignedBy
    left join U_Users LU_CompletedBy with (nolock) on LU_CompletedBy.Code = AB_AbstractQueueLog.CompletedBy
    --left join CM_CPI_Volume with (nolock) on CM_CPI_Volume.VolumeID = AB_Abstract.VolumeID
    --left join LoanLU_Location with (nolock) on CM_CPI_Volume.CLCurrentLocation = LoanLU_Location.Code
    

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[AbstractQueue_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE view [dbo].[AbstractQueue_VR] 
as
select
    AB_Abstract.AdmitDate, 
    AB_Abstract.AdmitTime, 
    LU_AssignedBy.DisplayCode as AssignedBy,     LU_AssignedBy.UserDescription as AssignedByDesc, 
    AssignedTime,
    AB_Abstract.ChartNumber,
    LU_Coder.DisplayCode as Coder,     LU_Coder.UserDescription as CoderDesc, 
    (case AB_Abstract.CareType when 1 then ''Inpatient'' when 2 then ''SDS'' when 5 then ''Amcare'' else '''' end) as CareType ,
    LoanLU_Location.DisplayCode as CurrentLocation,     LoanLU_Location.UserDescription as CurrentLocationDesc, 
    AB_Abstract.DischargeDate, 
    AB_Abstract.DischargeTime, 
    AB_Abstract.FirstName,
    H_InstitutionProfile.Displaycode as InstitutionNumber,     H_InstitutionProfile.UserDescription as InstitutionNumberDesc, 
    LU_MISCode.DisplayCode as MISCode,     LU_MISCode.UserDescription as MISCodeDesc, 
    AB_Abstract.LastName,
    AB_Abstract.EncounterNumber as RegistrationNumber,
    CM_CPI_Volume.VolumeNumber, 
    AB_AbstractQueue.AbstractID as zzAbstractLink,
    AB_Abstract.VolumeID as zzVolumeLink
from dbo.AB_AbstractQueue with (nolock) 
    inner join AB_Abstract with (nolock) on AB_AbstractQueue.AbstractID = AB_Abstract.AbstractID
    inner join H_InstitutionProfile with (nolock) on H_InstitutionProfile.Code = AB_Abstract.InstitutionNumber
    left join LU_MISCode with (nolock) on LU_MISCode.Code = AB_Abstract.MISCode
    left join U_Users LU_Coder with (nolock) on LU_Coder.Code = AB_AbstractQueue.Coder
    left join U_Users LU_AssignedBy with (nolock) on LU_AssignedBy.Code = AB_AbstractQueue.AssignedBy
    left join CM_CPI_Volume with (nolock) on CM_CPI_Volume.VolumeID = AB_Abstract.VolumeID
    left join LoanLU_Location with (nolock) on CM_CPI_Volume.CLCurrentLocation = LoanLU_Location.Code
where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[Amcare_Abstracting_VR]
AS
SELECT     
    dbo.AB_ReproductiveCare.PrevPreTermDelivery AS [#ofPreviousPreTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevSpontAbortions AS [#ofPrevSpontaneousAbortions], 
    dbo.AB_ReproductiveCare.PrevTermDelivery AS [#ofPreviousTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevInduceAbortions AS [#ofPrevTherapeuticAbortions], 
    Lookup1.DisplayCode AS AWOL, Lookup1.UserDescription AS AWOLDesc, 
    dbo.AB_ReproductiveCare.AbortionDate AS AbortDate, 
    dbo.AB_Abstract.AbstractNumber, 
    LU_AbstractOverflow.DisplayCode as AbstractOverflow, LU_AbstractOverflow.UserDescription as AbstractOverflowDesc,
    dbo.AB_Abstract.InjuryActivityDescription AS ActivityDescription, 
    Lookup2.DisplayCode AS ActivityWhenInjured, Lookup2.UserDescription AS ActivityWhenInjuredDesc, 
    dbo.AB_Abstract.AcuteLOS AS ActueLOS, 
    Lookup3.DisplayCode AS AdmitbyAmbulance, Lookup3.UserDescription AS AdmitbyAmbulanceDesc, 
    dbo.AB_Abstract.AdmitCategory, dbo.AB_Abstract.AdmittingDiagnosis AS AdmitDiagnosis, 
    dbo.AB_Abstract.AdmittingNurseArea AS AdmitNursingArea, 
    --dbo.AB_DeathInformation.DeathAfterAdmit AS AfterAdmit, 
    Lookup4.DisplayCode AS AgeCode, Lookup4.UserDescription AS AgeCodeDesc, 
    dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, 
    Lookup5.DisplayCode AS Albumin, Lookup5.UserDescription AS AlbuminDesc, 
    Lookup6.DisplayCode AS AlbuminCrossMatched, Lookup6.UserDescription AS AlbuminCrossMatchedDesc, 
    Lookup7.DisplayCode AS AlbuminTyped, Lookup7.UserDescription AS AlbuminTypedDesc, 
    dbo.AB_Blood.AlbuminUnits, dbo.AB_Abstract.ALCLOS, dbo.AB_Abstract.AmbulanceReportNumber, 
    Lookup8.DisplayCode AS AncillaryField1,   Lookup8.UserDescription AS AncillaryField1Desc, 
    Lookup9.DisplayCode AS AncillaryField10,  Lookup9.UserDescription AS AncillaryField10Desc, 
    Lookup10.DisplayCode AS AncillaryField11, Lookup10.UserDescription AS AncillaryField11Desc, 
    Lookup11.DisplayCode AS AncillaryField12, Lookup11.UserDescription AS AncillaryField12Desc, 
    dbo.AB_Ancillary.AncillaryField13 AS AncillaryField13, 
    dbo.AB_Ancillary.AncillaryField14 AS AncillaryField14, 
    dbo.AB_Ancillary.AncillaryField15 AS AncillaryField15, 
    dbo.AB_Ancillary.AncillaryField16 AS AncillaryField16, 
    dbo.AB_Ancillary.AncillaryField17 AS AncillaryField17, 
    Lookup12.DisplayCode AS AncillaryField2,  Lookup12.UserDescription AS AncillaryField2Desc, 
    Lookup13.DisplayCode AS AncillaryField3,  Lookup13.UserDescription AS AncillaryField3Desc, 
    Lookup14.DisplayCode AS AncillaryField4,  Lookup14.UserDescription AS AncillaryField4Desc, 
    Lookup15.DisplayCode AS AncillaryField5,  Lookup15.UserDescription AS AncillaryField5Desc, 
    Lookup16.DisplayCode AS AncillaryField6,  Lookup16.UserDescription AS AncillaryField6Desc, 
    Lookup17.DisplayCode AS AncillaryField7,  Lookup17.UserDescription AS AncillaryField7Desc, 
    Lookup18.DisplayCode AS AncillaryField8,  Lookup18.UserDescription AS AncillaryField8Desc, 
    Lookup19.DisplayCode AS AncillaryField9,  Lookup19.UserDescription AS AncillaryField9Desc, 
    dbo.AB_Abstract.ArrivalDate, 
    Lookup22.DisplayCode AS ArrivalMode, Lookup22.UserDescription AS ArrivalModeDesc, 
    dbo.AB_Abstract.ArrivalTime, 
    dbo.AB_Abstract.ArrivalTriageDifference AS ArrivaltoTriageTime, 
    dbo.AB_Abstract.AssessmentDate, dbo.AB_Abstract.AssessmentTime, 
    Lookup159.DisplayCode AS AssessmentTimeUnknown, Lookup159.UserDescription AS AssessmentTimeUnknownDesc, 
    dbo.AB_Abstract.AttendingPhysician, 
    Lookup23.DisplayCode AS AutoTransfusion, Lookup23.UserDescription AS AutoTransfusionDesc, 
    Lookup24.DisplayCode AS AutopsyPerformed, Lookup24.UserDescription AS AutopsyPerformedDesc, 
    Lookup25.DisplayCode AS BasicOption1,  Lookup25.UserDescription AS BasicOption1Desc, 
    Lookup26.DisplayCode AS BasicOption10, Lookup26.UserDescription AS BasicOption10Desc, 
    Lookup27.DisplayCode AS BasicOption11, Lookup27.UserDescription AS BasicOption11Desc, 
    Lookup28.DisplayCode AS BasicOption12, Lookup28.UserDescription AS BasicOption12Desc, 
    Lookup29.DisplayCode AS BasicOption13, Lookup29.UserDescription AS BasicOption13Desc, 
    Lookup30.DisplayCode AS BasicOption14, Lookup30.UserDescription AS BasicOption14Desc, 
    Lookup31.DisplayCode AS BasicOption15, Lookup31.UserDescription AS BasicOption15Desc, 
    Lookup32.DisplayCode AS BasicOption16, Lookup32.UserDescription AS BasicOption16Desc, 
    Lookup33.DisplayCode AS BasicOption17, Lookup33.UserDescription AS BasicOption17Desc, 
    Lookup34.DisplayCode AS BasicOption18, Lookup34.UserDescription AS BasicOption18Desc, 
    Lookup35.DisplayCode AS BasicOption19, Lookup35.UserDescription AS BasicOption19Desc, 
    Lookup36.DisplayCode AS BasicOption2,  Lookup36.UserDescription AS BasicOption2Desc, 
    Lookup37.DisplayCode AS BasicOption3,  Lookup37.UserDescription AS BasicOption3Desc, 
    Lookup38.DisplayCode AS BasicOption4,  Lookup38.UserDescription AS BasicOption4Desc, 
    Lookup39.DisplayCode AS BasicOption5,  Lookup39.UserDescription AS BasicOption5Desc, 
    Lookup40.DisplayCode AS BasicOption6,  Lookup40.UserDescription AS BasicOption6Desc, 
    Lookup41.DisplayCode AS BasicOption7,  Lookup41.UserDescription AS BasicOption7Desc, 
    Lookup42.DisplayCode AS BasicOption8,  Lookup42.UserDescription AS BasicOption8Desc, 
    Lookup43.DisplayCode AS BasicOption9,  Lookup43.UserDescription AS BasicOption9Desc, 
    dbo.AB_Abstract.BatchNumber, 
    Lookup44.DisplayCode AS BatchPeriod, Lookup44.UserDescription AS BatchPeriodDesc, 
    dbo.AB_Abstract.BatchYear, 
    dbo.AB_Abstract.BirthDate, dbo.AB_ReproductiveCare.BreastFeeding, 
    Lookup45.DisplayCode AS ChangeinLegalStatus, Lookup45.UserDescription AS ChangeinLegalStatusDesc, 
    dbo.AB_Abstract.ChartNumber, 
    dbo.AB_Abstract.ChiefComplaint as ChiefComplaintUponAdmission, 
    Lookup46.DisplayCode AS CoderNumber, Lookup46.UserDescription AS CoderNumberDesc, 
    LUCompleteRecord.DisplayCode AS CompleteRecord, LUCompleteRecord.UserDescription AS CompleteRecordDesc, 

    LUComplication.DisplayCode as Complication, LUComplication.UserDescription as ComplicationDesc,

    Lookup47.DisplayCode AS Complication1, Lookup47.UserDescription AS Complication1Desc, 
    Lookup48.DisplayCode AS Complication2, Lookup48.UserDescription AS Complication2Desc, 
    Lookup49.DisplayCode AS Complication3, Lookup49.UserDescription AS Complication3Desc, 
    Lookup50.DisplayCode AS ContactMode,   Lookup50.UserDescription AS ContactModeDesc, 
    Lookup51.DisplayCode AS CoronerCase, Lookup51.UserDescription AS CoronerCaseDesc, 
    Lookup52.DisplayCode AS DataEntryCoder, Lookup52.UserDescription AS DataEntryCoderDesc, 
    dbo.AB_Abstract.DateLeftER, 
    dbo.AB_ReproductiveCare.LastMensesDate AS DateofLastMenses, 
    dbo.AB_Abstract.DateReadyDischarge AS DateReadyforDisch, 
    dbo.AB_Abstract.CIHIDateSent AS DateSenttoCIHI, 
    Lookup53.DisplayCode AS DeathInER, Lookup53.UserDescription AS DeathInERDesc, 
    Lookup54.DisplayCode AS DeathOnArrival, Lookup54.UserDescription AS DeathOnArrivalDesc, 
    dbo.AB_Abstract.DecisionAdmitDifference, 
    dbo.AB_Abstract.DecisionAdmitDate AS DecisiontoAdmitDate, 
    dbo.AB_Abstract.DecisionAdmitTime AS DecisiontoAdmitTime, 
    Lookup158.DisplayCode AS DecisionAdmitTimeUnknown, Lookup158.UserDescription AS DecisionAdmitTimeUnknownDesc, 
    dbo.AB_ReproductiveCare.DeliveryDate, dbo.AB_ReproductiveCare.DeliveryTime, 
    Lookup58.DisplayCode AS DiedDuringIntervention, Lookup58.UserDescription AS DiedDuringInterventionDesc, 
    dbo.AB_Abstract.DischargeNurseArea AS DischNursingArea, 
    Lookup59.DisplayCode AS DischPlanning, Lookup59.UserDescription AS DischPlanningDesc, 
    dbo.AB_Abstract.DischargeAge, 
    Lookup60.DisplayCode AS DischargeDisposition, Lookup60.UserDescription AS DischargeDispositionDesc, 
    dbo.AB_Abstract.DischargeDate AS DispositionDate, 
    dbo.AB_Abstract.DischargeTime AS DispositionTime, 
    Lookup61.DisplayCode AS ECTTreatment, Lookup61.UserDescription AS ECTTreatmentDesc, 
    Lookup64.DisplayCode AS Education, Lookup64.UserDescription AS EducationDesc, 
    Lookup65.DisplayCode AS Employment, Lookup65.UserDescription AS EmploymentDesc, 
    --dbo.AB_Abstract.EntryCode, 
    dbo.AB_Abstract.EstimatedDischargeDate AS EstimateDischDate, 
    --dbo.AB_Abstract.ExitCode, 
    Lookup67.DisplayCode AS FamilyPhysicianFlag, Lookup67.UserDescription AS FamilyPhysicianFlagDesc, 
    Lookup68.DisplayCode AS FinancialSupport, Lookup68.UserDescription AS FinancialSupportDesc, 
    dbo.AB_Abstract.FinishDate, dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, 
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS FullName, 
    Lookup69.DisplayCode AS Gender, Lookup69.UserDescription AS GenderDesc, 
    dbo.AB_ReproductiveCare.GestationalAge AS GestationalAgeinweeks, 
    Lookup157.DisplayCode AS GlasgowScale, Lookup157.UserDescription AS GlasgowScaleDesc, 
    --dbo.AB_DeathInformation.DeathGreaterTenPO AS GreaterTenPO, 
    Lookup70.DisplayCode AS HCNProvince, Lookup70.UserDescription AS HCNProvinceDesc, 
    dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
    LU_Hospital.DisplayCode AS Hospital, LU_Hospital.UserDescription AS HospitalDesc, 
    LUHelmetIndicator.DisplayCode AS HelmetIndicator, LUHelmetIndicator.UserDescription AS HelmetIndicatorDesc, 
    -- dbo.AB_DeathInformation.DeathInSCU AS InSCU, 
    Lookup71.DisplayCode AS InitialOR, Lookup71.UserDescription AS InitialORDesc, 
    dbo.AB_Abstract.InjuryDate, 
    Lookup72.DisplayCode AS Injury, Lookup72.UserDescription AS InjuryDesc, 
    dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
    Lookup73.DisplayCode AS InstitutionFrom, Lookup73.UserDescription AS InstitutionFromDesc, 
    InstitutionFrom9.DisplayCode AS InstitutionFrom9, InstitutionFrom9.UserDescription AS InstitutionFrom9Desc, 
    Lookup73.InstCareType AS InstFromCareType, Lookup73.HospitalType AS InstFromHospType, 

    Lookup74.DisplayCode AS InstitutionNumber, Lookup74.UserDescription AS InstitutionNumberDesc, 

    Lookup75.DisplayCode AS InstitutionTo, Lookup75.UserDescription AS InstitutionToDesc, 
    InstitutionTo9.DisplayCode AS InstitutionTo9, InstitutionTo9.UserDescription AS InstitutionTo9Desc, 
    Lookup75.InstCareType AS InstToCareType, Lookup75.HospitalType AS InstToHospType, 

    dbo.AB_Abstract.InterfaceDate, dbo.AB_Abstract.InterfaceTime, 
    Lookup83.DisplayCode AS IsAbstractCompleted, Lookup83.UserDescription AS IsAbstractCompletedDesc, 
    Lookup84.DisplayCode AS IsAbstractCorrected, Lookup84.UserDescription AS IsAbstractCorrectedDesc, 
    Lookup85.DisplayCode AS IsAbstractDeleted, Lookup85.UserDescription AS IsAbstractDeletedDesc, 
    Lookup86.DisplayCode AS IsAbstractSubmitted, Lookup86.UserDescription AS IsAbstractSubmittedDesc, 
    Lookup87.DisplayCode AS IsAbstractValidated, Lookup87.UserDescription AS IsAbstractValidatedDesc, 
    Lookup88.DisplayCode AS IsBirthdateEstimated, Lookup88.UserDescription AS IsBirthdateEstimatedDesc, 
    dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSTotal AS LOSTime, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LOSMinutes AS LOSTotalMinutes, 
    Lookup89.DisplayCode AS [Language], Lookup89.UserDescription AS LanguageDesc, 
    dbo.AB_Abstract.LastName, 
    -- dbo.AB_DeathInformation.DeathLessTwoPO AS LessTwoPO, 
    Lookup90.DisplayCode AS LivingArrangement, Lookup90.UserDescription AS LivingArrangementDesc, 
    Lookup91.DisplayCode AS LocationofInjury,  Lookup91.UserDescription AS LocationofInjuryDesc, 
    Lookup93.DisplayCode AS MISCode, Lookup93.UserDescription AS MISCodeDesc, 
    dbo.AB_Abstract.MaidenName, 
    Lookup94.DisplayCode AS MaritalStatus, Lookup94.UserDescription AS MaritalStatusDesc, 
    Lookup95.DisplayCode AS MethodofAdmission, Lookup95.UserDescription AS MethodofAdmissionDesc, 
    dbo.AB_Abstract.MiddleName, dbo.AB_Abstract.NewbornChart, 
    dbo.AB_Abstract.NewbornDischargeDate AS NewbornDischDate, 
    dbo.AB_Abstract.NextSchedVisitDate AS NextScheduledVisitDate, 
    dbo.AB_Abstract.NextSchedVisitTime AS NextScheduledVisitTime, 
    dbo.AB_MentalHealth.MentalNumberECT AS NumberofECT, 
    dbo.AB_Abstract.NurseAssessDate AS NursingAssessmentDate, 
    dbo.AB_Abstract.NurseAssessTime AS NursingAssessmentTime, 
    Lookup98.DisplayCode AS Occupation, Lookup98.UserDescription AS OccupationDesc, 
    Lookup99.DisplayCode AS OtherMedicalDeath, Lookup99.UserDescription AS OtherMedicalDeathDesc, 
    Lookup100.DisplayCode AS OtherBlood, Lookup100.UserDescription AS OtherBloodDesc, 
    Lookup101.DisplayCode AS OtherBloodCrossMatched, Lookup101.UserDescription AS OtherBloodCrossMatchedDesc, 
    Lookup102.DisplayCode AS OtherBloodTyped, Lookup102.UserDescription AS OtherBloodTypedDesc, 
    dbo.AB_Blood.OtherBloodUnits, 
    Lookup148.DisplayCode AS PCTASIndicator, Lookup148.UserDescription AS PCTASIndicatorDesc, 
    dbo.AB_Abstract.PhysicianEstimatedLOS AS PhysicianEstLOS, 
    Lookup103.DisplayCode AS Plasma, Lookup103.UserDescription AS PlasmaDesc, 
    Lookup104.DisplayCode AS PlasmaCrossMatched, Lookup104.UserDescription AS PlasmaCrossMatchedDesc, 
    Lookup105.DisplayCode AS PlasmaTyped, Lookup105.UserDescription AS PlasmaTypedDesc, 
    dbo.AB_Blood.PlasmaUnits, 
    Lookup106.DisplayCode AS Platelets, Lookup106.UserDescription AS PlateletsDesc, 
    Lookup107.DisplayCode AS PlateletsCrossMatched, Lookup107.UserDescription AS PlateletsCrossMatchedDesc, 
    Lookup108.DisplayCode AS PlateletsTyped, Lookup108.UserDescription AS PlateletsTypedDesc, 
    dbo.AB_Blood.PlateletsUnits, 
    dbo.AB_Abstract.PostalCode, dbo.AB_Abstract.PostOpDays, dbo.AB_Abstract.PreOpDays, 
    Lookup110.DisplayCode AS PreamditWorkUp, Lookup110.UserDescription AS PreamditWorkUpDesc, 
    Lookup111.DisplayCode AS PregnancyDeath, Lookup111.UserDescription AS PregnancyDeathDesc, 
    dbo.AB_ReproductiveCare.PrevLiveBirths AS PrevLiveBirth, 
    Lookup112.DisplayCode AS PreviousPsychiartricAdmissions, Lookup112.UserDescription AS PreviousPsychiartricAdmDesc, 
    Lookup113.DisplayCode AS Program, Lookup113.UserDescription AS ProgramDesc, 
    Lookup118.DisplayCode AS ProvinceNumber, Lookup118.UserDescription AS ProvinceNumberDesc, 
    -- dbo.AB_Abstract.ReAdmitCode, 
    Lookup132.DisplayCode AS RedBloodCell, Lookup132.UserDescription AS RedBloodCellDesc, 
    Lookup133.DisplayCode AS RedBloodCellCrossMatched, Lookup133.UserDescription AS RedBloodCellCrossMatchedDesc, 
    Lookup134.DisplayCode AS RedBloodCellTyped, Lookup134.UserDescription AS RedBloodCellTypedDesc, 
    dbo.AB_Blood.RedCellUnits AS RedBloodCellUnits, dbo.AB_Abstract.ReferralDate, 
    Lookup135.DisplayCode AS ReferredFrom, Lookup135.UserDescription AS ReferredFromDesc, 
    Lookup136.DisplayCode AS ReferredTo, Lookup136.UserDescription AS ReferredToDesc, 
    dbo.AB_Abstract.RegisterNumber, dbo.AB_Abstract.EncounterNumber AS RegistrationNumber, 
    dbo.AB_Abstract.EncounterSequence AS RegistrationSequenceNumber, 
    dbo.AB_Abstract.AdmitDate AS RegistrationVisitDate, 
    dbo.AB_Abstract.AdmitTime AS RegistrationVisitTime, 
    dbo.AB_ReproductiveCare.ReprodComments AS ReproductiveCareComments, 
    dbo.AB_Abstract.Reserved AS ReserveField, 
    Lookup138.DisplayCode AS ResidenceCode, Lookup138.UserDescription AS ResidenceCodeDesc, 
    Lookup139.DisplayCode AS ResidenceType, Lookup139.UserDescription AS ResidenceTypeDesc, 
    Lookup140.DisplayCode AS ResponsiblityForPayment, Lookup140.UserDescription AS ResponsiblityForPaymentDesc, 
    Lookup153.DisplayCode AS SchedEDVisit, Lookup153.UserDescription AS SchedEDVisitDesc, 
    Lookup156.DisplayCode AS SeatbeltIndicator, Lookup156.UserDescription AS SeatbeltIndicatorDesc, 
    dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup141.DisplayCode AS SecretVIPPatient, Lookup141.UserDescription AS SecretVIPPatientDesc, 
    Lookup142.DisplayCode AS SiteNumber, Lookup142.UserDescription AS SiteNumberDesc, 
    Lookup143.DisplayCode AS SocialService, Lookup143.UserDescription AS SocialServiceDesc, 
    Lookup144.DisplayCode AS SourceofReferral, Lookup144.UserDescription AS SourceofReferralDesc, 
    LU_StakeholderType.DisplayCode AS StakeholderType, LU_StakeholderType.UserDescription AS StakeholderTypeDesc, 

    Lookup145.DisplayCode AS Sterilization, 
    Lookup145.UserDescription AS SterilizationDesc, 

    Lookup146.DisplayCode AS SubsequentOR, Lookup146.UserDescription AS SubsequentORDesc, 
    Lookup147.DisplayCode AS Suicide, Lookup147.UserDescription AS SuicideDesc, 

    LUSurgicalCase.DisplayCode as SurgicalCase, LUSurgicalCase.UserDescription as SurgicalCaseDesc,

    dbo.AB_Abstract.TimeLeftER, dbo.AB_Abstract.TransferOverloadDate, 
    dbo.AB_Abstract.TransferOverloadTime, dbo.AB_Abstract.TransferOverloadDifference AS TransferOverloadTimeDifference, 
    Lookup149.DisplayCode AS TransfusionGiven, Lookup149.UserDescription AS TransfusionGivenDesc, 
    Lookup150.DisplayCode AS Trauma, Lookup150.UserDescription AS TraumaDesc, 
    dbo.AB_Abstract.TriageDate, 
    Lookup151.DisplayCode AS TriageLevel, Lookup151.UserDescription AS TriageLevelDesc, 
    dbo.AB_Abstract.TriageTime, 
    Lookup152.DisplayCode AS TSICoder, Lookup152.UserDescription AS TSICoderDesc, 
    dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, 
    -- dbo.AB_DeathInformation.DeathTwoTenPO AS TwoTenPO, 
    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, 
    --dbo.AB_Abstract.UnplanReAdmit AS UnplannedReadmit, 
    Lookup154.DisplayCode AS VisitStatus, Lookup154.UserDescription AS VisitStatusDesc, 
    Lookup155.DisplayCode AS VisitType, Lookup155.UserDescription AS VisitTypeDesc, 
    dbo.AB_Abstract.WaitTimeER AS WaitTimeinER, 
    dbo.AB_Abstract.WaitAssessmentDifference AS WaittoAssessmentinMinutes, 
    dbo.AB_Abstract.NurseAssessDiff AS WaittoNursingAssessmentDiff, 
    dbo.AB_Abstract.Weight, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
    dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile LU_StakeholderType with (nolock) ON dbo.AB_Abstract.StakeHolder = LU_StakeholderType.Code LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) ON dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LUCompleteRecord with (nolock) ON dbo.AB_Abstract.CompleteRecord = LUCompleteRecord.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LUHelmetIndicator with (nolock) ON dbo.AB_Abstract.HelmetIndicator = LUHelmetIndicator.Code LEFT OUTER JOIN
    dbo.LU_InjuryActivity Lookup2 with (nolock) ON dbo.AB_Abstract.InjuryActivity = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) ON dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup4 with (nolock) ON dbo.AB_Abstract.AgeCode = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_ArrivalMode Lookup22 with (nolock) ON dbo.AB_Abstract.ArrivalMode = Lookup22.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup44 with (nolock) ON dbo.AB_Abstract.BatchPeriod = Lookup44.Code LEFT OUTER JOIN
    dbo.U_Users Lookup46 with (nolock) ON dbo.AB_Abstract.CoderNumber = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_ContactMode Lookup50 with (nolock) ON dbo.AB_Abstract.ContactMode = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup52 with (nolock) ON dbo.AB_Abstract.DataEntryCoder = Lookup52.Code LEFT OUTER JOIN
    dbo.LU_TherDischPlan Lookup59 with (nolock) ON dbo.AB_Abstract.DischargePlanning = Lookup59.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_A Lookup60 with (nolock) ON dbo.AB_Abstract.DispositionCode = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_Education Lookup64 with (nolock) ON dbo.AB_Abstract.EducationLevel = Lookup64.Code LEFT OUTER JOIN
    dbo.LU_FamilyPhysician Lookup67 with (nolock) ON dbo.AB_Abstract.FamilyPhysician = Lookup67.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup69 with (nolock) ON dbo.AB_Abstract.Gender = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup70 with (nolock) ON dbo.AB_Abstract.HCNProvince = Lookup70.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup72 with (nolock) ON dbo.AB_Abstract.Injury = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup73 with (nolock) ON dbo.AB_Abstract.InstitutionFrom = Lookup73.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup74 with (nolock) ON dbo.AB_Abstract.InstitutionNumber = Lookup74.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup75 with (nolock) ON dbo.AB_Abstract.InstitutionTo = Lookup75.Code LEFT OUTER JOIN

    dbo.LU_Institution_9 InstitutionFrom9 with (nolock) ON dbo.AB_Abstract.InstitutionFrom = InstitutionFrom9.Code LEFT OUTER JOIN
    dbo.LU_Institution_9 InstitutionTo9 with (nolock) ON dbo.AB_Abstract.InstitutionTo = InstitutionTo9.Code LEFT OUTER JOIN

    dbo.LU_AbstractStatus Lookup83 with (nolock) ON dbo.AB_Abstract.IsCompleted = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup84 with (nolock) ON dbo.AB_Abstract.IsCorrected = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus Lookup85 with (nolock) ON dbo.AB_Abstract.IsDeleted = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup86 with (nolock) ON dbo.AB_Abstract.IsSubmited = Lookup86.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup87 with (nolock) ON dbo.AB_Abstract.IsValidated = Lookup87.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup88 with (nolock) ON dbo.AB_Abstract.BirthDateEstimated = Lookup88.Code LEFT OUTER JOIN
    dbo.LU_Language Lookup89 with (nolock) ON dbo.AB_Abstract.LanguageCode = Lookup89.Code LEFT OUTER JOIN
    dbo.LU_LivingArrangement Lookup90 with (nolock) ON dbo.AB_Abstract.LivingArrangement = Lookup90.Code LEFT OUTER JOIN
    dbo.LU_InjuryLocation Lookup91 with (nolock) ON dbo.AB_Abstract.InjuryLocation = Lookup91.Code LEFT OUTER JOIN
    dbo.LU_MISCode Lookup93 with (nolock) ON dbo.AB_Abstract.MISCode = Lookup93.Code LEFT OUTER JOIN
    dbo.LU_MaritalStatus Lookup94 with (nolock) ON dbo.AB_Abstract.MaritalStatus = Lookup94.Code LEFT OUTER JOIN
    dbo.LU_Occupation Lookup98 with (nolock) ON dbo.AB_Abstract.Occupation = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_TherPreAdmitWorkUp Lookup110 with (nolock) ON dbo.AB_Abstract.PreAdmitWorkUp = Lookup110.Code LEFT OUTER JOIN
    dbo.LU_Program Lookup113 with (nolock) ON dbo.AB_Abstract.Program = Lookup113.Code LEFT OUTER JOIN
    dbo.LU_Province Lookup118 with (nolock) ON dbo.AB_Abstract.ProvinceNumber = Lookup118.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup135 with (nolock) ON dbo.AB_Abstract.ReferredFrom = Lookup135.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup136 with (nolock) ON dbo.AB_Abstract.ReferredTo = Lookup136.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup138 with (nolock) ON dbo.AB_Abstract.ResidenceCode = Lookup138.Code LEFT OUTER JOIN
    dbo.LU_ResidenceType Lookup139 with (nolock) ON dbo.AB_Abstract.ResidenceType = Lookup139.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup140 with (nolock) ON dbo.AB_Abstract.ResponsiblePayment = Lookup140.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup141 with (nolock) ON dbo.AB_Abstract.Secret = Lookup141.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup142 with (nolock) ON dbo.AB_Abstract.SiteNumber = Lookup142.Code LEFT OUTER JOIN
    dbo.LU_TherSocialService Lookup143 with (nolock) ON dbo.AB_Abstract.SocialService = Lookup143.Code LEFT OUTER JOIN
    dbo.LU_TriageLevel Lookup151 with (nolock) ON dbo.AB_Abstract.TriageLevel = Lookup151.Code LEFT OUTER JOIN
    dbo.U_Users Lookup152 with (nolock) ON dbo.AB_Abstract.TSICoder = Lookup152.Code LEFT OUTER JOIN
    dbo.LU_VisitType Lookup154 with (nolock) ON dbo.AB_Abstract.VisitStatus = Lookup154.Code LEFT OUTER JOIN
    dbo.LU_VisitType_10 Lookup155 with (nolock) ON dbo.AB_Abstract.VisitType = Lookup155.Code LEFT OUTER JOIN
    dbo.AB_Ancillary with (nolock) ON dbo.AB_Abstract.AbstractID = dbo.AB_Ancillary.AbstractID LEFT OUTER JOIN
    dbo.LU_Ancillary1 Lookup8 with (nolock) ON dbo.AB_Ancillary.AncillaryField1 = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_Ancillary10 Lookup9 with (nolock) ON dbo.AB_Ancillary.AncillaryField10 = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_Ancillary11 Lookup10 with (nolock) ON dbo.AB_Ancillary.AncillaryField11 = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_Ancillary12 Lookup11 with (nolock) ON dbo.AB_Ancillary.AncillaryField12 = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Ancillary2 Lookup12 with (nolock) ON dbo.AB_Ancillary.AncillaryField2 = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_Ancillary3 Lookup13 with (nolock) ON dbo.AB_Ancillary.AncillaryField3 = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_Ancillary4 Lookup14 with (nolock) ON dbo.AB_Ancillary.AncillaryField4 = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_Ancillary5 Lookup15 with (nolock) ON dbo.AB_Ancillary.AncillaryField5 = Lookup15.Code LEFT OUTER JOIN
    dbo.LU_Ancillary6 Lookup16 with (nolock) ON dbo.AB_Ancillary.AncillaryField6 = Lookup16.Code LEFT OUTER JOIN
    dbo.LU_Ancillary7 Lookup17 with (nolock) ON dbo.AB_Ancillary.AncillaryField7 = Lookup17.Code LEFT OUTER JOIN
    dbo.LU_Ancillary8 Lookup18 with (nolock) ON dbo.AB_Ancillary.AncillaryField8 = Lookup18.Code LEFT OUTER JOIN
    dbo.LU_Ancillary9 Lookup19 with (nolock) ON dbo.AB_Ancillary.AncillaryField9 = Lookup19.Code LEFT OUTER JOIN
    dbo.AB_BasicOption with (nolock) ON dbo.AB_Abstract.AbstractID = dbo.AB_BasicOption.AbstractID LEFT OUTER JOIN
    dbo.LU_BasicOption1 Lookup25 with (nolock) ON dbo.AB_BasicOption.BasicOption1 = Lookup25.Code LEFT OUTER JOIN
    dbo.LU_BasicOption10 Lookup26 with (nolock) ON dbo.AB_BasicOption.BasicOption10 = Lookup26.Code LEFT OUTER JOIN
    dbo.LU_BasicOption11 Lookup27 with (nolock) ON dbo.AB_BasicOption.BasicOption11 = Lookup27.Code LEFT OUTER JOIN
    dbo.LU_BasicOption12 Lookup28 with (nolock) ON dbo.AB_BasicOption.BasicOption12 = Lookup28.Code LEFT OUTER JOIN
    dbo.LU_BasicOption13 Lookup29 with (nolock) ON dbo.AB_BasicOption.BasicOption13 = Lookup29.Code LEFT OUTER JOIN
    dbo.LU_BasicOption14 Lookup30 with (nolock) ON dbo.AB_BasicOption.BasicOption14 = Lookup30.Code LEFT OUTER JOIN
    dbo.LU_BasicOption15 Lookup31 with (nolock) ON dbo.AB_BasicOption.BasicOption15 = Lookup31.Code LEFT OUTER JOIN
    dbo.LU_BasicOption16 Lookup32 with (nolock) ON dbo.AB_BasicOption.BasicOption16 = Lookup32.Code LEFT OUTER JOIN
    dbo.LU_BasicOption17 Lookup33 with (nolock) ON dbo.AB_BasicOption.BasicOption17 = Lookup33.Code LEFT OUTER JOIN
    dbo.LU_BasicOption18 Lookup34 with (nolock) ON dbo.AB_BasicOption.BasicOption18 = Lookup34.Code LEFT OUTER JOIN
    dbo.LU_BasicOption19 Lookup35 with (nolock) ON dbo.AB_BasicOption.BasicOption19 = Lookup35.Code LEFT OUTER JOIN
    dbo.LU_BasicOption2 Lookup36 with (nolock) ON dbo.AB_BasicOption.BasicOption2 = Lookup36.Code LEFT OUTER JOIN
    dbo.LU_BasicOption3 Lookup37 with (nolock) ON dbo.AB_BasicOption.BasicOption3 = Lookup37.Code LEFT OUTER JOIN
    dbo.LU_BasicOption4 Lookup38 with (nolock) ON dbo.AB_BasicOption.BasicOption4 = Lookup38.Code LEFT OUTER JOIN
    dbo.LU_BasicOption5 Lookup39 with (nolock) ON dbo.AB_BasicOption.BasicOption5 = Lookup39.Code LEFT OUTER JOIN
    dbo.LU_BasicOption6 Lookup40 with (nolock) ON dbo.AB_BasicOption.BasicOption6 = Lookup40.Code LEFT OUTER JOIN
    dbo.LU_BasicOption7 Lookup41 with (nolock) ON dbo.AB_BasicOption.BasicOption7 = Lookup41.Code LEFT OUTER JOIN
    dbo.LU_BasicOption8 Lookup42 with (nolock) ON dbo.AB_BasicOption.BasicOption8 = Lookup42.Code LEFT OUTER JOIN
    dbo.LU_BasicOption9 Lookup43 with (nolock) ON dbo.AB_BasicOption.BasicOption9 = Lookup43.Code LEFT OUTER JOIN
    dbo.AB_Blood with (nolock) ON dbo.AB_Abstract.AbstractID = dbo.AB_Blood.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup5 with (nolock) ON dbo.AB_Blood.Albumin = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup6 with (nolock) ON dbo.AB_Blood.AlbuminXMatch = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup7 with (nolock) ON dbo.AB_Blood.AlbuminTyped = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup23 with (nolock) ON dbo.AB_Blood.AutoTransfusion = Lookup23.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup100 with (nolock) ON dbo.AB_Blood.OtherBlood = Lookup100.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup101 with (nolock) ON dbo.AB_Blood.OtherBloodXMatch = Lookup101.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup102 with (nolock) ON dbo.AB_Blood.OtherBloodTyped = Lookup102.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup103 with (nolock) ON dbo.AB_Blood.Plasma = Lookup103.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup104 with (nolock) ON dbo.AB_Blood.PlasmaXMatch = Lookup104.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup105 with (nolock) ON dbo.AB_Blood.PlasmaTyped = Lookup105.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup106 with (nolock) ON dbo.AB_Blood.Platelets = Lookup106.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup107 with (nolock) ON dbo.AB_Blood.PlateletsXMatch = Lookup107.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup108 with (nolock) ON dbo.AB_Blood.PlateletsTyped = Lookup108.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup132 with (nolock) ON dbo.AB_Blood.RedBloodCell = Lookup132.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup133 with (nolock) ON dbo.AB_Blood.RedCellXMatch = Lookup133.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup134 with (nolock) ON dbo.AB_Blood.RedCellTyped = Lookup134.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup149 with (nolock) ON dbo.AB_Blood.TransfusionIndicator = Lookup149.Code LEFT OUTER JOIN
    dbo.AB_DeathInformation with (nolock) ON dbo.AB_Abstract.AbstractID = dbo.AB_DeathInformation.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup24 with (nolock) ON dbo.AB_DeathInformation.AutopsyPerformed = Lookup24.Code LEFT OUTER JOIN
    dbo.LU_CoronerCase Lookup51 with (nolock) ON dbo.AB_DeathInformation.CoronerCase = Lookup51.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup53 with (nolock) ON dbo.AB_DeathInformation.DeathInER = Lookup53.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup54 with (nolock) ON dbo.AB_DeathInformation.DeathOnArrival = Lookup54.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup58 with (nolock) ON dbo.AB_DeathInformation.DeathInOR = Lookup58.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup99 with (nolock) ON dbo.AB_DeathInformation.OtherDeath = Lookup99.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup111 with (nolock) ON dbo.AB_DeathInformation.PregnancyDeath = Lookup111.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup150 with (nolock) ON dbo.AB_DeathInformation.TraumaDeath = Lookup150.Code LEFT OUTER JOIN
    dbo.AB_MentalHealth with (nolock) ON dbo.AB_Abstract.AbstractID = dbo.AB_MentalHealth.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup1 with (nolock) ON dbo.AB_MentalHealth.MentalAWOL = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_MentalLegalStatus Lookup45 with (nolock) ON dbo.AB_MentalHealth.MentalLegalStatus = Lookup45.Code LEFT OUTER JOIN
    dbo.LU_MentalECTTreat Lookup61 with (nolock) ON dbo.AB_MentalHealth.MentalECTTreatment = Lookup61.Code LEFT OUTER JOIN
    dbo.LU_MentalEducation Lookup63 with (nolock) ON dbo.AB_MentalHealth.MentalEducation = Lookup63.Code LEFT OUTER JOIN
    dbo.LU_MentalEmployment Lookup65 with (nolock) ON dbo.AB_MentalHealth.MentalEmployment = Lookup65.Code LEFT OUTER JOIN
    dbo.LU_MentalFinancial Lookup68 with (nolock) ON dbo.AB_MentalHealth.MentalFinancial = Lookup68.Code LEFT OUTER JOIN
    dbo.LU_MentalAdmitMethod Lookup95 with (nolock) ON dbo.AB_MentalHealth.MentalAdmitMethod = Lookup95.Code LEFT OUTER JOIN
    dbo.LU_MentalPrevPsych Lookup112 with (nolock) ON dbo.AB_MentalHealth.MentalPrevPsych = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup137 with (nolock) ON dbo.AB_MentalHealth.MentalReferralTo = Lookup137.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup144 with (nolock) ON dbo.AB_MentalHealth.MentalReferralSource = Lookup144.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup147 with (nolock) ON dbo.AB_MentalHealth.MentalSuicide = Lookup147.Code LEFT OUTER JOIN
    dbo.AB_ReproductiveCare with (nolock) ON dbo.AB_Abstract.AbstractID = dbo.AB_ReproductiveCare.AbstractID LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup47 with (nolock) ON dbo.AB_ReproductiveCare.Complication1 = Lookup47.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup48 with (nolock) ON dbo.AB_ReproductiveCare.Complication2 = Lookup48.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup49 with (nolock) ON dbo.AB_ReproductiveCare.Complication3 = Lookup49.Code LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup71 with (nolock) ON dbo.AB_ReproductiveCare.InitialOR = Lookup71.Code LEFT OUTER JOIN
    dbo.LU_ReprodSterilization Lookup145 with (nolock) ON dbo.AB_ReproductiveCare.Sterilization = Lookup145.Code LEFT OUTER JOIN

    dbo.LU_ReprodOR Lookup146 with (nolock) ON dbo.AB_ReproductiveCare.SubsequentOR = Lookup146.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup148 with (nolock) ON dbo.AB_Abstract.PCTASIndicator = Lookup148.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup153 with (nolock) ON dbo.AB_Abstract.SchedEDVisit = Lookup153.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup156 with (nolock) ON Lookup156.Code = dbo.AB_Abstract.SeatbeltIndicator AND Lookup156.LookupID = 2 LEFT OUTER JOIN
    dbo.LU_Glasgow Lookup157 with (nolock) ON Lookup157.Code = dbo.AB_Abstract.GlasgowComaScale LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup158 with (nolock) ON dbo.AB_Abstract.DecisionAdmitTimeUnknown = Lookup158.Code AND Lookup158.LookupID = 1 LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup159 with (nolock) ON dbo.AB_Abstract.AssessmentTimeUnknown = Lookup159.Code AND Lookup159.LookupID = 1 LEFT OUTER JOIN
    LU_AbstractOverflow with (nolock) ON AB_Abstract.AbstractOverflow = LU_AbstractOverflow.Code LEFT OUTER JOIN
    LU_YesBlank LUSurgicalCase with (nolock) ON dbo.AB_Abstract.SurgicalCase = LUSurgicalCase.Code  LEFT OUTER JOIN
    LU_YesBlank LUComplication with (nolock) ON dbo.AB_Abstract.Complication = LUComplication.Code
WHERE dbo.AB_Abstract.CareType = 5
    --QA - 00032 disable the domain securite issue
 --   --PR - 07485
 --   and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
 --   --EN - 00666
 --       or Is_Member(nullif(ReportGroup, '''')) = 1)
 ----       or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))
   

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_CACS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[Amcare_CACS_VR]
AS
SELECT     
    dbo.AB_CACS.OccurrenceNumber, 
    dbo.AB_CACS.CACS_Year AS CACSYear, 
    dbo.AB_CACS.MAC, 
    dbo.AB_CACS.CACSCell, 
    dbo.AB_CACS.ACW, 
    dbo.AB_CACS.CACSDescription, 
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_ProcFile10.DisplayCode
        when ''9'' then dbo.ICD_ProcFile9.DisplayCode
        when ''C'' then dbo.ICD_ProcFile9cm.DisplayCode
        end) AS InterventionCode, 
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_ProcFile10.UserDescription
        when ''9'' then dbo.ICD_ProcFile9.UserDescription
        when ''C'' then dbo.ICD_ProcFile9cm.UserDescription
        end) AS IntervCodeDescription, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink
FROM dbo.AB_Abstract with (nolock) inner join
    dbo.AB_CACS with (nolock) ON dbo.AB_CACS.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.ICD_ProcFile10 with (nolock) ON dbo.AB_CACS.InterventionCode = dbo.ICD_ProcFile10.Code LEFT OUTER JOIN
    dbo.ICD_ProcFile9 with (nolock) ON dbo.AB_CACS.InterventionCode = dbo.ICD_ProcFile9.Code LEFT OUTER JOIN
    dbo.ICD_ProcFile9cm with (nolock) ON dbo.AB_CACS.InterventionCode = dbo.ICD_ProcFile9cm.Code
WHERE dbo.AB_Abstract.CareType = 5





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[Amcare_Diagnosis_VR]
AS
SELECT     
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_DiagFile10.DisplayCode 
        when ''9'' then dbo.ICD_DiagFile9.DisplayCode 
        when ''C'' then dbo.ICD_DiagFile9cm.DisplayCode 
     end) AS DiagnosisCode, 
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_DiagFile10.UserDescription 
        when ''9'' then dbo.ICD_DiagFile9.UserDescription 
        when ''C'' then dbo.ICD_DiagFile9cm.UserDescription 
     end) AS DiagnosisCodeDesc, 
    ICD_DiagFile10.ShortDescription as DiagnosisCodeShortDesc,
    dbo.ICD_DiagFile10.ICD9 AS DiagnosisICD9Equivalent, 
    dbo.ICD_DiagFile10.ICD9cm AS DiagnosisICD9cmEquivalent, 
    dbo.AB_Diagnosis.DiagnosisOccurrence, 
    Lookup55.DisplayCode AS DiagnosisPrefix, Lookup55.UserDescription AS DiagnosisPrefixDesc, 
    Lookup56.DisplayCode AS DiagnosisSuffix, Lookup56.UserDescription AS DiagnosisSuffixDesc, 
    Lookup57.DisplayCode AS DiagnosisType,   Lookup57.UserDescription AS DiagnosisTypeDesc, 
    dbo.AB_Diagnosis.AbstractID AS zzAbstractLink
FROM dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Diagnosis with (nolock) ON dbo.AB_Diagnosis.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.ICD_DiagFile10 with (nolock) ON dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile10.Code Left OUTER JOIN
    dbo.ICD_DiagFile9 with (nolock) ON dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile9.Code Left OUTER JOIN
    dbo.ICD_DiagFile9cm with (nolock) ON dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile9cm.Code Left OUTER JOIN
    dbo.LU_DiagnosisPrefix Lookup55 with (nolock) ON dbo.AB_Diagnosis.DiagnosisPrefix = Lookup55.Code LEFT OUTER JOIN
    dbo.LU_DiagnosisSuffix Lookup56 with (nolock) ON dbo.AB_Diagnosis.DiagnosisSuffix = Lookup56.Code LEFT OUTER JOIN
    dbo.LU_DiagnosisType Lookup57 with (nolock) ON dbo.AB_Diagnosis.DiagnosisType = Lookup57.Code
WHERE dbo.AB_Abstract.CareType = 5 AND (dbo.AB_Diagnosis.DiagnosisOccurrence IS NOT NULL)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_DPG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE view [dbo].[Amcare_DPG_VR]
as
select 
    DPGOccurrence = dpg.OccurrenceNumber, 
    DPG_Year, 
    DPG, 
    DPG_RIW, 
    DPG_MOH_RIW, 
    DPG_Description, 
    zzAbstractLink = dpg.AbstractID
from AB_DPG dpg  with (nolock)
    Inner join AB_Abstract with (nolock) ON dpg.AbstractID = AB_Abstract.AbstractID
where AB_Abstract.Caretype = 5




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'





CREATE   VIEW [dbo].[Amcare_Interventions_VR]
AS
SELECT 
    Lookup20.DisplayCode AS AnestheticTechnique, 
    Lookup20.UserDescription AS AnestheticTechniqueDesc, 
    Lookup21.DisplayCode AS AnesthetistID, 
    Lookup21.UserDescription AS AnesthetistIDDesc, 
    Lookup62.DisplayCode AS EUL, 
    Lookup62.UserDescription AS EULDesc, 
    Lookup66.DisplayCode AS Extra, 
    Lookup66.UserDescription AS ExtraDesc,
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_ProcFile10.DisplayCode 
        when ''9'' then dbo.ICD_ProcFile9.DisplayCode 
        when ''C'' then dbo.ICD_ProcFile9cm.DisplayCode 
     end) AS InterventionCode, 
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_ProcFile10.UserDescription 
        when ''9'' then dbo.ICD_ProcFile9.UserDescription 
        when ''C'' then dbo.ICD_ProcFile9cm.UserDescription 
     end) AS InterventionCodeDesc, 
    ICD_ProcFile10.ShortDescription as InterventionCodeShortDesc,
    dbo.AB_Intervention.IntervDateIn, dbo.AB_Intervention.IntervDateOut, 
    Lookup77.DisplayCode AS InterventionAttributeExtent, 
    Lookup77.UserDescription AS IntervAttributeExtentDesc, 
    Lookup78.DisplayCode AS InterventionAttributeLocation, 
    Lookup78.UserDescription AS IntervAttributeLocationDesc, 
    Lookup79.DisplayCode AS InterventionAttributeStatus, 
    Lookup79.UserDescription AS IntervAttributeStatusDesc, 
    dbo.AB_Intervention.IntervDate AS InterventionDate, 
    dbo.ICD_ProcFile10.ICD9 AS IntervICD9Equivalent, 
    dbo.ICD_ProcFile10.ICD9cm AS IntervICD9cmEquivalent, 
    Lookup80.DisplayCode AS InterventionLocation, 
    Lookup80.UserDescription AS InterventionLocationDesc, 
    dbo.AB_Intervention.IntervOccurrence AS InterventionOccurrence, 
    Lookup81.DisplayCode AS InterventionProviderNumber, 
    Lookup81.UserDescription AS InterventionProviderNumberDesc, 
    Lookup82.DisplayCode AS InterventionProviderSpecialty, 
    Lookup82.UserDescription AS IntervProviderSpecialtyDesc, 
    Lookup83.DisplayCode AS InterventionSuffix, 
    Lookup83.UserDescription AS InterventionSuffixDesc, 
    dbo.AB_Intervention.IntervTimeIn AS InterventionTimeIn, 
    dbo.AB_Intervention.IntervTimeMinutes AS InterventionTimeinMinutes, 
    dbo.AB_Intervention.IntervTimeOut AS InterventionTimeOut, 
    Lookup97.DisplayCode AS OOHIndicator, 
    Lookup97.UserDescription AS OOHIndicatorDesc, 
    (case when AB_Abstract.ICDType = ''T'' then Lookup98.DisplayCode
          else LU_Institution_9.DisplayCode end) AS OOHInstitutionNumber, 
    (case when AB_Abstract.ICDType = ''T'' then Lookup98.UserDescription
          else LU_Institution_9.UserDescription end) AS OOHInstitutionNumberDesc, 
    Lookup149.DisplayCode AS TissueCode, 
    Lookup149.UserDescription AS TissueCodeDesc, 
    Lookup154.DisplayCode AS UnplannedReturntoOR, 
    Lookup154.UserDescription AS UnplannedReturntoORDesc, 
    dbo.AB_Intervention.AbstractID AS zzAbstractLink
FROM       
    dbo.AB_Abstract  with (nolock) inner JOIN
    dbo.AB_Intervention with (nolock) ON dbo.AB_Intervention.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.ICD_ProcFile10 with (nolock) ON dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile10.Code LEFT OUTER JOIN
    dbo.ICD_ProcFile9 with (nolock) ON dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile9.Code LEFT OUTER JOIN
    dbo.ICD_ProcFile9cm with (nolock) ON dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile9cm.Code LEFT OUTER JOIN
    dbo.LU_AnaestTechnique Lookup20 with (nolock) ON dbo.AB_Intervention.IntervAnaestTechnique = Lookup20.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup21 with (nolock) ON dbo.AB_Intervention.IntervAnaestID = Lookup21.Code LEFT OUTER JOIN
    dbo.LU_IntervEUL Lookup62 with (nolock) ON dbo.AB_Intervention.IntervEUL = Lookup62.Code LEFT OUTER JOIN
    dbo.LU_IntervExtra Lookup66 with (nolock) ON dbo.AB_Intervention.IntervExtra = Lookup66.Code LEFT OUTER JOIN
    dbo.LU_IntervAttExtent Lookup77 with (nolock) ON dbo.AB_Intervention.IntervAttribExtent = Lookup77.Code LEFT OUTER JOIN
    dbo.LU_IntervAttLocation Lookup78 with (nolock) ON dbo.AB_Intervention.IntervAttribLocation = Lookup78.Code LEFT OUTER JOIN
    dbo.LU_IntervAttStatus Lookup79 with (nolock) ON dbo.AB_Intervention.IntervAttribStatus = Lookup79.Code LEFT OUTER JOIN
    dbo.LU_IntervLocation_AI Lookup80 with (nolock) ON dbo.AB_Intervention.IntervLocation = Lookup80.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup81 with (nolock) ON dbo.AB_Intervention.IntervProviderNumber = Lookup81.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty Lookup82 with (nolock) ON dbo.AB_Intervention.IntervProviderService = Lookup82.Code LEFT OUTER JOIN
    dbo.LU_IntervSuffix Lookup83 with (nolock) ON dbo.AB_Intervention.IntervSuffix = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup97 with (nolock) ON dbo.AB_Intervention.IntervOOHIndicator = Lookup97.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup98 with (nolock) ON dbo.AB_Intervention.IntervOOHInstitution = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_Institution_9 with (nolock) ON dbo.AB_Intervention.IntervOOHInstitution = LU_Institution_9.Code LEFT OUTER JOIN
    dbo.LU_IntervTissue Lookup149 with (nolock) ON dbo.AB_Intervention.IntervTissueCode = Lookup149.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup154 with (nolock) ON dbo.AB_Intervention.IntervUnplanReturn = Lookup154.Code
WHERE (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_Intervention.IntervOccurrence IS NOT NULL)







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_MIS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[Amcare_MIS_VR]
AS
SELECT     
    dbo.AB_MIS.DirectCost AS DirectCosts, 
    dbo.AB_MIS.IndirectCost AS IndirectCosts, 
    dbo.LU_MISCode.DisplayCode AS MISCode, 
    dbo.LU_MISCode.UserDescription AS MISCodeDesc, 
    dbo.AB_MIS.MISOccurrence, 
    dbo.AB_MIS.SupplyCost AS SupplyCosts, 
    dbo.AB_MIS.AbstractID AS zzAbstractLink
FROM  dbo.AB_Abstract with (nolock) inner JOIN
    AB_MIS with (nolock) ON dbo.AB_MIS.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_MISCode with (nolock) ON dbo.AB_MIS.MISCode = dbo.LU_MISCode.Code
WHERE (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_MIS.MISOccurrence IS NOT NULL)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[Amcare_Projects_VR]
AS
SELECT 
    Lookup115.DisplayCode AS ProjectNumber, Lookup115.UserDescription AS ProjectNumberDesc, 
    dbo.AB_Project.ProjectOccurrence, 
    Lookup120.DisplayCode AS Question1,   Lookup120.UserDescription AS Question1Desc, 
    Lookup121.DisplayCode AS Question10,  Lookup121.UserDescription AS Question10Desc, 
    Lookup122.DisplayCode AS Question11,  Lookup122.UserDescription AS Question11Desc, 
    Lookup123.DisplayCode AS Question12,  Lookup123.UserDescription AS Question12Desc, 
    Lookup124.DisplayCode AS Question13,  Lookup124.UserDescription AS Question13Desc, 
    dbo.AB_Project.Question14, dbo.AB_Project.Question15, 
    dbo.AB_Project.Question16, dbo.AB_Project.Question17, 
    Lookup125.DisplayCode AS Question2,   Lookup125.UserDescription AS Question2Desc, 
    Lookup126.DisplayCode AS Question3,   Lookup126.UserDescription AS Question3Desc, 
    Lookup127.DisplayCode AS Question4,   Lookup127.UserDescription AS Question4Desc, 
    Lookup128.DisplayCode AS Question5,   Lookup128.UserDescription AS Question5Desc, 
    Lookup129.DisplayCode AS Question6,   Lookup129.UserDescription AS Question6Desc, 
    Lookup130.DisplayCode AS Question7,   Lookup130.UserDescription AS Question7Desc, 
    Lookup131.DisplayCode AS Question8,   Lookup131.UserDescription AS Question8Desc, 
    Lookup132.DisplayCode AS Question9,   Lookup132.UserDescription AS Question9Desc, 
    dbo.AB_Project.AbstractID AS zzAbstractLink
FROM dbo.AB_Abstract with (nolock) Inner join
    AB_Project with (nolock) ON dbo.AB_Project.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_Project Lookup115 with (nolock) ON dbo.AB_Project.ProjectNumber = Lookup115.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1 Lookup120 with (nolock) ON dbo.AB_Project.Question1 = Lookup120.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 Lookup121 with (nolock) ON dbo.AB_Project.Question10 = Lookup121.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 Lookup122 with (nolock) ON dbo.AB_Project.Question11 = Lookup122.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 Lookup123 with (nolock) ON dbo.AB_Project.Question12 = Lookup123.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 Lookup124 with (nolock) ON dbo.AB_Project.Question13 = Lookup124.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2 Lookup125 with (nolock) ON dbo.AB_Project.Question2 = Lookup125.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3 Lookup126 with (nolock) ON dbo.AB_Project.Question3 = Lookup126.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4 Lookup127 with (nolock) ON dbo.AB_Project.Question4 = Lookup127.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5 Lookup128 with (nolock) ON dbo.AB_Project.Question5 = Lookup128.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6 Lookup129 with (nolock) ON dbo.AB_Project.Question6 = Lookup129.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7 Lookup130 with (nolock) ON dbo.AB_Project.Question7 = Lookup130.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8 Lookup131 with (nolock) ON dbo.AB_Project.Question8 = Lookup131.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9 Lookup132 with (nolock) ON dbo.AB_Project.Question9 = Lookup132.Code
WHERE (dbo.AB_Abstract.CareType = 5)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Amcare_Providers_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[Amcare_Providers_VR]
AS
SELECT    
    dbo.AB_Provider.ProviderArriveDate AS ProviderArrivedDate, 
    dbo.AB_Provider.ProviderArriveTime AS ProviderArrivedTime, 
    dbo.AB_Provider.ProviderCallDate AS ProviderCalledDate, 
    dbo.AB_Provider.ProviderCallTime AS ProviderCalledTime, 
    Lookup116.DisplayCode AS ProviderNumber, 
    Lookup116.UserDescription AS ProviderNumberDesc, dbo.AB_Provider.ProviderOccurrence, 
    Lookup117.DisplayCode AS ProviderSpecialty, 
    Lookup117.UserDescription AS ProviderSpecialtyDesc, 
    dbo.AB_Provider.ProviderTotalTime, 
    Lookup118.DisplayCode AS ProviderType, 
    Lookup118.UserDescription AS ProviderTypeDesc, 
    dbo.AB_Provider.AbstractID AS zzAbstractLink
FROM dbo.AB_Provider with (nolock) inner JOIN
    dbo.AB_Abstract with (nolock) ON dbo.AB_Provider.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_Provider Lookup116 with (nolock) ON dbo.AB_Provider.ProviderNumber = Lookup116.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty Lookup117 with (nolock) ON dbo.AB_Provider.ProviderSpecialty = Lookup117.Code LEFT OUTER JOIN
    dbo.LU_ProviderType Lookup118 with (nolock) ON dbo.AB_Provider.ProviderType = Lookup118.Code
WHERE (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_Provider.ProviderOccurrence IS NOT NULL)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_AbstractNotes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[CCM_AbstractNotes_VR]
AS
SELECT     
   RecordID AS zzAbstractLink,
   LogNote  as AbstractNotes,
   LogDate  as DateLogged,
   LogTime  as TimeLogged,
   U.DisplayCode as CreateBy,
   U.UserDescription as CreatorName        
from dbo.REC_Notes r with (nolock) left join U_users U  with (nolock) ON r.LogCoder=u.code
where AppID in ( 675, 676 )



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_ClinicVisit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[CCM_Entity_ClinicVisit_VR]
AS
SELECT     
    patient_chart_number = dbo.CC_Demographic.ChartNumber, 
    visit_hospital_number = right(H_InstitutionProfile_visit.CIHIValue, 4), 
    submitting_hospital_number = right(H_InstitutionProfile_submit.CIHIValue, 4), 
    visit_date = isnull(convert(varchar(20), AB_Abstract.AdmitDate, 112), ''''),
    visit_time = isnull(left(replace(convert(varchar(20),  AB_Abstract.AdmitTime, 114), '':'', ''''), 4), ''''),
    --0092 do not zero fill- it looks like client issue to use the old one
    hcp_number = isnull(right(Replicate(''0'', 15) + LU_Provider.CIHIValue, 15), ''''),
    --hcp_number = (case when isnumeric(LU_Provider.CIHIValue) = 1 then isnull(right(Replicate(''0'', 15) + LU_Provider.CIHIValue, 15), '''') else LU_Provider.CIHIValue end),
    visit_program_code = isnull(LU_VisitProgramCode.CIHIValue, ''''),
    mis_functional_centre = isnull(LU_MISCode.CIHIValue, ''''),
    radiation_review_flag = isnull(LU_RadiationReviewFlag.CIHIValue, ''''),
    inpatient_flag = isnull(LU_InpatientFlag.CIHIValue, ''''),
    registration_date = isnull(convert(varchar(10), dbo.CC_DiseaseRegister.RegisterDate, 112), ''''),
    disease_sequence_number = isnull(dbo.CC_DiseaseRegister.DiseaseSequenceNum, 0),
    patient_postal_code = isnull(AB_Abstract.PostalCode, ''''),
    patient_mohltc_residence_code = isnull(LU_ResidenceCode.CIHIValue, ''''),
    visit_type = isnull(LU_CCMVisitType.CIHIValue, ''''),


    dbo.AB_CCM_CancerCareInformation.AbstractID as zzNACRSLink,
    dbo.CC_Demographic.AbstractID as zzCCMDiseaseLink
FROM
    dbo.AB_ABstract with (nolock) inner join 
    dbo.H_InstitutionProfile H_InstitutionProfile_visit with (nolock) ON H_InstitutionProfile_visit.Code = dbo.AB_Abstract.InstitutionNumber inner JOIN
    dbo.AB_CCM_CancerCareInformation with (nolock) ON dbo.AB_ABstract.AbstractId = dbo.AB_CCM_CancerCareInformation.AbstractID inner join
    AB_Main with (nolock) ON dbo.AB_CCM_CancerCareInformation.CancerCareVisit = AB_Main.UniversalID inner join
    dbo.CC_Demographic with (nolock) ON AB_Main.AbstractID = dbo.CC_Demographic.AbstractID inner join 
    dbo.CC_DiseaseRegister with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_DiseaseRegister.AbstractID LEFT OUTER JOIN
    dbo.H_InstitutionProfile H_InstitutionProfile_submit with (nolock) ON H_InstitutionProfile_submit.Code = dbo.CC_Demographic.InstitutionNumber LEFT OUTER JOIN

    dbo.LU_MISCode with (nolock) ON dbo.AB_ABstract.MISCode = lu_MISCode.Code left join
    dbo.LU_ResidenceCode with (nolock) ON dbo.AB_ABstract.ResidenceCode = LU_ResidenceCode.Code left join
    dbo.LU_CodeFile LU_VisitProgramCode with (nolock) ON dbo.AB_CCM_CancerCareInformation.VisitProgramCode = LU_VisitProgramCode.Code left join
    dbo.LU_CodeFile LU_CCMVisitType with (nolock) ON dbo.AB_CCM_CancerCareInformation.CCMVisitType = LU_CCMVisitType.Code left join
    dbo.LU_YesNoAlpha LU_InpatientFlag with (nolock) ON dbo.AB_CCM_CancerCareInformation.InpatientFlag = LU_InpatientFlag.Code Left join
    dbo.LU_CodeFile LU_RadiationReviewFlag with (nolock) ON dbo.AB_CCM_CancerCareInformation.RadiationReviewFlag = LU_RadiationReviewFlag.Code Left join
    dbo.LU_Provider with (nolock) ON dbo.AB_CCM_CancerCareInformation.HealthCareProviderNumber = LU_Provider.Code 
where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_Disease_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[CCM_Entity_Disease_VR]
AS
SELECT     
    dbo.CC_Demographic.ChartNumber AS patient_chart_number, 
    --RIGHT(dbo.H_InstitutionProfile.CIHIValue, 3) 
    --(select top 1 FacilityNumber from dbo.H_HospitalProfile where isnull(dbo.H_InstitutionProfile.HospitalID, 0) in (0, dbo.H_HospitalProfile.Code) order by FacilityNumber desc)
    --''0930'' AS submitting_hospital_number, 
    right(''0'' + dbo.H_InstitutionProfile.CIHIValue, 4) as submitting_hospital_number, --ED - 02336 0930 is just for GR
    isnull(dbo.ICD_DiagFile10.CIHIValue, '''') AS diagnosis_code, 
    10 as diagnosis_code_version,
    isnull(dbo.LU_CC_Topography.CIHIValue, '''') AS topography_code, 
    (case when LU_TopoMorphVersion.CIHIValue = ''2'' 
          then isnull(dbo.LU_CC_Morphology_O2.CIHIValue, '''') 
          else isnull(dbo.LU_CC_Morphology_O3.CIHIValue, '''') end) AS morphology_code, 
    isnull(LU_TopoMorphVersion.CIHIValue, '''') AS topography_morphology_version, 
    isnull(LU_BasisDiag.CIHIValue, '''') AS basis_of_diagnosis, 
    isnull(convert(varchar(10), dbo.CC_DiseaseRegister.InitalDiagDate, 112), '''') AS date_of_initial_diagnosis, 
    isnull(right(dbo.LU_Institution_10.CIHIValue, 4), '''') AS diagnosis_hospital_number, 
    isnull(dbo.CC_DiseaseRegister.DiagHospitalChartNum , '''')AS diagnosis_hospital_chart_numbe, --PR - 03330
    isnull(dbo.CC_Demographic.PostalCode, '''') AS patient_postal_code_at_diag, 

    dbo.GetPostalDescription(isnull(dbo.CC_Demographic.PostalCode, ''''), isnull(dbo.CC_DiseaseRegister.RegisterDate, getdate())) AS postal_code_desc, -- ED - 01682

    isnull(right(dbo.LU_ResidenceCode.CIHIValue, 4), '''') AS patient_mohltc_resid_at_diag, 
    isnull(convert(varchar(10), dbo.CC_DiseaseRegister.RegisterDate, 112), '''') AS registration_date, 
    isnull(dbo.CC_DiseaseRegister.DiseaseSequenceNum, 0) AS disease_sequence_number, 
    isnull(LU_FirstSurgTreatFlag.CIHIValue, '''') AS surgical_treatment_flag, 
    isnull(convert(varchar(10), dbo.CC_DiseaseRegister.FirstSurgTreatDate, 112), '''') AS surgical_treatment_date, 

    isnull(LU_ClinStageDiag.STAGE, '''') AS clinical_stage_at_diag, 

    isnull(left(dbo.CC_CancerStageDiag.ClinStageDiag_T, 15), '''') AS clinical_stage_t_at_diag, 
    isnull(LU_ClinStageDiag_T_S.CIHIValue, '''') AS clinical_stage_t_suffix_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.ClinStageDiag_N, 15), '''') AS clinical_stage_n_at_diag, 
    isnull(LU_ClinStageDiag_N_S.CIHIValue, '''') AS clinical_stage_n_suffix_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.ClinStageDiag_M, 15), '''') AS clinical_stage_m_at_diag, 

    isnull(LU_PathStageDiag.STAGE, '''') AS path_stage_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.PathStageDiag_T, 15), '''') AS path_stage_t_at_diag, 
    isnull(LU_PathStageDiag_T_S.CIHIValue, '''') AS path_stage_t_suffix_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.PathStageDiag_N, 15), '''') AS path_stage_n_at_diag, 
    isnull(LU_PathStageDiag_N_S.CIHIValue, '''') AS path_stage_n_suffix_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.PathStageDiag_M, 15), '''') AS path_stage_m_at_diag, 

    isnull(LU_PostTherapyStage.STAGE, '''') AS post_therapy_stage_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.PostTherapyStage_T, 15), '''') AS post_therapy_t_at_diag, 
    isnull(LU_PostTherapyStage_T_S.CIHIValue, '''') AS post_therapy_t_suffix_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.PostTherapyStage_N, 15), '''') AS post_therapy_n_at_diag, 
    isnull(LU_PostTherapyStage_N_S.CIHIValue, '''') AS post_therapy_n_suffix_at_diag, 
    isnull(left(dbo.CC_CancerStageDiag.PostTherapyStage_M, 15), '''') AS post_therapy_m_at_diag, 

    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_cTNM, 10), '''') AS extent_disease_cTNM_at_pres, 
    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_cT, 10), '''') AS extent_disease_cT_at_pres, 
    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_cN, 10), '''') AS extent_disease_cN_at_pres, 
    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_cM, 10), '''') AS extent_disease_cM_at_pres, 
    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_pTNM, 10), '''') AS extent_disease_pTNM_at_pres, 
    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_pT, 10), '''') AS extent_disease_pT_at_pres, 
    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_pN, 10), '''') AS extent_disease_pN_at_pres, 
    isnull(left(dbo.CC_CancerStageDiag.ExtentDisease_pM, 10), '''') AS extent_disease_pM_at_pres, 
    LU_StagingVersion.CIHIValue AS staging_version,
    isnull(LU_AnalyticFlag.CIHIValue, '''') as analytic_flag,  --PR - 03587
    isnull(convert(varchar(10), dbo.CC_ReferralDate.MedicalOncologistRefDate, 112), '''') AS date_referral_med_oncologist, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.RadiationOncologistRefDate, 112), '''') AS date_referral_rad_oncologist, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.SurgicalOncologistRefDate, 112), '''') AS date_referral_surg_oncologist, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.PalliativeRefDate, 112), '''') AS date_referral_pall_prog, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.SocialWorkCareRefDate, 112), '''') AS date_referral_social_work, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.NutritionalRefDate, 112), '''') AS date_referral_nutri_therapy, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.PhysiotherapyRefDate, 112), '''') AS date_referral_physio, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.PsychiatryRefDate, 112), '''') AS date_referral_psychiatry, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.PsychologyRefDate, 112), '''') AS date_referral_psychology, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.OccupationalRefDate, 112), '''') AS date_referral_ot, 
    isnull(convert(varchar(10), dbo.CC_ReferralDate.SpeechRefDate, 112), '''') AS date_referral_speech_lang_path, 
    isnull(LU_Laterality.CIHIValue, '''') AS Laterality,

    dbo.CC_Demographic.AbstractID as zzAbstractLink
FROM         
    dbo.CC_Demographic with (nolock) LEFT OUTER JOIN
    dbo.H_InstitutionProfile with (nolock) ON dbo.H_InstitutionProfile.Code = dbo.CC_Demographic.InstitutionNumber LEFT OUTER JOIN
    dbo.CC_ReferralDate with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_ReferralDate.AbstractID LEFT OUTER JOIN
    dbo.LU_ResidenceCode with (nolock) ON dbo.CC_Demographic.ResidenceCode = dbo.LU_ResidenceCode.Code LEFT OUTER JOIN
    dbo.CC_CancerStageDiag with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_CancerStageDiag.AbstractID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_StagingVersion with (nolock) ON LU_StagingVersion.Code = dbo.CC_CancerStageDiag.StagingVersion LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Laterality with (nolock) ON LU_Laterality.Code = dbo.CC_CancerStageDiag.Laterality FULL OUTER JOIN
    dbo.CC_DiseaseRegister with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_DiseaseRegister.AbstractID LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_FirstSurgTreatFlag with (nolock) ON LU_FirstSurgTreatFlag.Code = dbo.CC_DiseaseRegister.FirstSurgTreatFlag LEFT OUTER JOIN
    dbo.LU_Institution_10 with (nolock) ON dbo.CC_DiseaseRegister.DiagHospitalNum = dbo.LU_Institution_10.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_BasisDiag with (nolock) ON dbo.CC_DiseaseRegister.BasisDiag = LU_BasisDiag.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TopoMorphVersion with (nolock) ON dbo.CC_DiseaseRegister.TopoMorphVersion = LU_TopoMorphVersion.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile10 with (nolock) ON dbo.ICD_DiagFile10.Code = dbo.CC_DiseaseRegister.DiagnosisCode LEFT OUTER JOIN
    dbo.LU_CC_Morphology_O2 with (nolock) ON dbo.CC_DiseaseRegister.MorphologyCodeO2 = dbo.LU_CC_Morphology_O2.Code LEFT OUTER JOIN
    dbo.LU_CC_Morphology_O3 with (nolock) ON dbo.CC_DiseaseRegister.MorphologyCodeO3 = dbo.LU_CC_Morphology_O3.Code LEFT OUTER JOIN
    dbo.LU_CC_Topography with (nolock) ON dbo.CC_DiseaseRegister.TopographyCode = dbo.LU_CC_Topography.Code LEFT OUTER JOIN
    dbo.LLU_CC_STAGE_VALUE LU_ClinStageDiag with (nolock) ON dbo.CC_CancerStageDiag.ClinStageDiag = LU_ClinStageDiag.Code LEFT OUTER JOIN
    dbo.LLU_CC_STAGE_VALUE LU_PathStageDiag with (nolock) ON dbo.CC_CancerStageDiag.PathStageDiag = LU_PathStageDiag.Code LEFT OUTER JOIN
--PR - 03587
    dbo.LU_CodeFile LU_AnalyticFlag with (nolock) ON dbo.CC_DiseaseRegister.AnalyticFlag = LU_AnalyticFlag.Code LEFT OUTER JOIN
    --2.x-1503
    dbo.LU_CodeFile LU_ClinStageDiag_T_S with (nolock) ON dbo.CC_CancerStageDiag.ClinStageDiag_T_S = LU_ClinStageDiag_T_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_ClinStageDiag_N_S with (nolock) ON dbo.CC_CancerStageDiag.ClinStageDiag_N_S = LU_ClinStageDiag_N_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PathStageDiag_T_S with (nolock) ON dbo.CC_CancerStageDiag.PathStageDiag_T_S = LU_PathStageDiag_T_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PathStageDiag_N_S with (nolock) ON dbo.CC_CancerStageDiag.PathStageDiag_N_S = LU_PathStageDiag_N_S.Code LEFT OUTER JOIN
    dbo.LLU_CC_STAGE_VALUE LU_PostTherapyStage with (nolock) ON dbo.CC_CancerStageDiag.PostTherapyStage = LU_PostTherapyStage.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PostTherapyStage_T_S with (nolock) ON dbo.CC_CancerStageDiag.PostTherapyStage_T_S = LU_PostTherapyStage_T_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PostTherapyStage_N_S with (nolock) ON dbo.CC_CancerStageDiag.PostTherapyStage_N_S = LU_PostTherapyStage_N_S.Code 

where dbo.CC_Demographic.AppID = 675 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_Healthcare_Professional_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[CCM_Entity_Healthcare_Professional_VR]
AS
SELECT distinct
    --ED - 02336
    --submitting_hospital_number = ''0930'', -- (select top 1 FacilityNumber from dbo.H_HospitalProfile where isnull((select top 1 HospitalID from dbo.H_InstitutionProfile where AssociationID = 8 and getdate() between validfrom and validto), 0) in (0, dbo.H_HospitalProfile.Code) order by FacilityNumber desc), 
    submitting_hospital_number = right((select top 1 ''0'' + CIHIValue from dbo.H_InstitutionProfile where associationid = 8), 4), 
    hcp_number = isnull(right(REPLICATE(''0'', 15) + ltrim(rtrim(LU_Provider.CIHIValue)), 15), ''''), 
    hcp_specialty_code = (select top 1 isnull(dbo.LU_ProviderSpecialty.CIHIValue, '''') 
                          from llu_ProviderSpecialty llu inner join dbo.LU_ProviderSpecialty on llu.code = dbo.LU_ProviderSpecialty.code
                          where  llu.AssociationID = LU_Provider.code   --PR - 05381 remove llu.Type = 1 and
                          order by llu.[Type], llu.Validto desc), 
    cco_program_code = isnull(LU_HCPProgramCode.CIHIValue, ''''), 
    hcp_surname = isnull(left(LU_Provider.ProvdrSurName, 20), ''''), 
    hcp_first_name = isnull(left(LU_Provider.ProvdrFirstName, 15), ''''), 
    hcp_status = isnull(LU_HCPStatus.CIHIValue, ''''), 
    host_hospital_hcp_number = isnull(right(REPLICATE(''0'', 15) + ltrim(rtrim(LU_Provider.CIHIValue)), 15), ''''), --isnull(right(REPLICATE(''0'', 15) + LU_HostHCPNumber.CIHIValue, 15), '''') AS , 
    DateStamp = m.LastUpdate
from dbo.LU_Provider LU_Provider with (nolock) 
    inner join (select RecordID, max(Updated) LastUpdate from dbo.H_UpdateHistory  with (nolock) where appid = 1104 group by RecordID) m
        on LU_Provider.Code = m.RecordID
    inner join LU_CodeFile LU_HCPProgramCode  with (nolock) ON LU_Provider.HCPProgramCode = LU_HCPProgramCode.Code
    inner join LU_CodeFile LU_HCPStatus with (nolock) ON LU_Provider.HCPStatus = LU_HCPStatus.Code
where exists (select * from dbo.llu_ProviderSpecialty s with (nolock) where AssociationID = LU_Provider.code and s.code > 0) --PR - 05381 remove and s.Type = 1)
    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or LU_Provider.HospitalID is null or LU_Provider.HospitalID = 0
    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(LU_Provider.HospitalID, 0)))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_NDFP_Enrollment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[CCM_Entity_NDFP_Enrollment_VR]
AS
SELECT     
    dbo.CC_Demographic.ChartNumber AS patient_chart_number, 
    isnull(right(dbo.LU_Institution_10.CIHIValue, 4), '''') AS visit_hospital_number, 
    --(select top 1 FacilityNumber from dbo.H_HospitalProfile where isnull(dbo.H_InstitutionProfile.HospitalID, 0) in (0, dbo.H_HospitalProfile.Code) order by FacilityNumber desc)  
    --''0930'' As submitting_hospital_number, 
    right(''0'' + H_InstitutionProfile.CIHIValue, 4) as submitting_hospital_number,   --ED - 02336
    isnull(dbo.CC_NDFP.NDFPNumber, '''') AS ndfp_form_number, 
    isnull(dbo.CC_NDFP.NDFPVersion, '''') AS ndfp_form_version_number, 
    isnull(right(replicate(''0'', 15) + dbo.LU_Provider.CIHIValue, 15), '''') AS hcp_number, 
    isnull(convert(varchar(10), dbo.CC_NDFP.FirstTreatDate, 112), '''') AS date_of_first_treatment, 
    isnull(dbo.CC_NDFP.Height, '''') AS height, 
    isnull(dbo.CC_NDFP.Weight, '''') AS weight, 
    isnull(dbo.CC_NDFP.BodySurfaceArea, '''') AS body_surface_area, 
    isnull(LU_Intent.CIHIValue, '''') as intent,
    isnull(left(dbo.CC_NDFP.EligAnswr1, 1), '''') AS eligibility_answer_1, 
    isnull(left(dbo.CC_NDFP.EligAnswr2, 1), '''') AS eligibility_answer_2, 
    isnull(left(dbo.CC_NDFP.EligAnswr3, 1), '''') AS eligibility_answer_3, 
    isnull(left(dbo.CC_NDFP.EligAnswr4, 1), '''') AS eligibility_answer_4, 
    isnull(left(dbo.CC_NDFP.EligAnswr5, 1), '''') AS eligibility_answer_5, 
    isnull(left(dbo.CC_NDFP.EligAnswr6, 1), '''') AS eligibility_answer_6, 
    isnull(left(dbo.CC_NDFP.EligAnswr7, 1), '''') AS eligibility_answer_7, 
    isnull(left(dbo.CC_NDFP.EligAnswr8, 1), '''') AS eligibility_answer_8, 
    isnull(left(dbo.CC_NDFP.EligAnswr9, 1), '''') AS eligibility_answer_9, 
    isnull(left(dbo.CC_NDFP.EligAnswr10, 1), '''') AS eligibility_answer_10, 
    isnull(left(dbo.CC_NDFP.EligAnswr11, 1), '''') AS eligibility_answer_11, 
    isnull(left(dbo.CC_NDFP.EligAnswr12, 1), '''') AS eligibility_answer_12, 
    isnull(left(dbo.CC_NDFP.EligAnswr13, 1), '''') AS eligibility_answer_13, 
    isnull(left(dbo.CC_NDFP.EligAnswr14, 1), '''') AS eligibility_answer_14, 
    isnull(left(dbo.CC_NDFP.EligAnswr15, 1), '''') AS eligibility_answer_15, 
    isnull(left(dbo.CC_NDFP.EligAnswr16, 1), '''') AS eligibility_answer_16, 
    isnull(left(dbo.CC_NDFP.EligAnswr17, 1), '''') AS eligibility_answer_17, 
    isnull(left(dbo.CC_NDFP.EligAnswr18, 1), '''') AS eligibility_answer_18, 
    isnull(left(dbo.CC_NDFP.EligAnswr19, 1), '''') AS eligibility_answer_19, 
    isnull(left(dbo.CC_NDFP.EligAnswr20, 1), '''') AS eligibility_answer_20, 
    isnull(left(dbo.CC_NDFP.EligAnswr21, 40), '''') AS eligibility_answer_21, 
    isnull(left(dbo.CC_NDFP.EligAnswr22, 40), '''') AS eligibility_answer_22, 
    isnull(left(dbo.CC_NDFP.EligAnswr23, 40), '''') AS eligibility_answer_23, 
    isnull(left(dbo.CC_NDFP.EligAnswr24, 40), '''') AS eligibility_answer_24, 
    isnull(left(dbo.CC_NDFP.EligAnswr25, 40), '''') AS eligibility_answer_25, 
    isnull(left(dbo.CC_NDFP.EligAnswr26, 40), '''') AS eligibility_answer_26, 
    isnull(left(dbo.CC_NDFP.EligAnswr27, 40), '''') AS eligibility_answer_27, 
    isnull(left(dbo.CC_NDFP.EligAnswr28, 40), '''') AS eligibility_answer_28, 
    isnull(left(dbo.CC_NDFP.EligAnswr29, 40), '''') AS eligibility_answer_29, 
    isnull(left(dbo.CC_NDFP.EligAnswr30, 40), '''') AS eligibility_answer_30,
    dbo.CC_Demographic.AbstractID as zzAbstractLink,
    dbo.CC_Demographic.LinkID as zzLinkID
FROM   
    dbo.CC_NDFP with (nolock) INNER JOIN
    dbo.CC_Demographic with (nolock) ON dbo.CC_NDFP.AbstractID = dbo.CC_Demographic.AbstractID 
    INNER JOIN    dbo.H_InstitutionProfile with (nolock) ON dbo.CC_Demographic.InstitutionNumber = dbo.H_InstitutionProfile.Code 
    LEFT OUTER JOIN dbo.LU_Institution_10 with (nolock) ON dbo.CC_NDFP.VisitHospitalNum = dbo.LU_Institution_10.Code 
    LEFT OUTER JOIN dbo.CC_HealthCareProf with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_HealthCareProf.AbstractID AND dbo.CC_HealthCareProf.Occurrence = 1 
    left JOIN dbo.LU_Provider with (nolock) ON dbo.CC_HealthCareProf.HCPNumber = dbo.LU_Provider.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_Intent with (nolock) ON dbo.CC_NDFP.Intent = LU_Intent.Code
where dbo.CC_Demographic.AppID = 676
    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CC_Demographic.HospitalID is null or CC_Demographic.HospitalID = 0
    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CC_Demographic.HospitalID, 0)))





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_Patient_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[CCM_Entity_Patient_VR]
AS
SELECT     
    --(select top 1 FacilityNumber from dbo.H_HospitalProfile where isnull(dbo.H_InstitutionProfile.HospitalID, 0) in (0, dbo.H_HospitalProfile.Code) order by FacilityNumber desc) 
    dbo.CC_Demographic.ChartNumber AS patient_chart_number, 
    --''0930'' AS submitting_hospital_number, 
    right(''0'' + dbo.H_InstitutionProfile.CIHIValue, 4) as submitting_hospital_number, --ED - 02336 0930 is just for GR
    isnull(left(dbo.CC_Demographic.LastName, 50), '''') AS patient_surname, 
    isnull(left(dbo.CC_Demographic.MaidenName, 50), '''') AS patient_maiden_name, 
    isnull(left(dbo.CC_Demographic.FirstName, 40), '''') AS patient_first_name, 
    isnull(left(dbo.CC_Demographic.MiddleName, 40), '''') AS patient_middle_name, 
    isnull(dbo.LU_Gender_I.CIHIValue, '''') AS patient_gender, 
    isnull(convert(varchar(10), dbo.CC_Demographic.BirthDate, 112), '''') AS patient_birth_date, 
    isnull(convert(varchar(10), dbo.CC_Demographic.DeathDate, 112), '''') AS patient_death_date, 
    isnull(dbo.CC_Demographic.HealthCareNumber, '''') AS health_card_number, 
    isnull(dbo.CC_Demographic.HCNVersion, '''') AS health_card_version, 
    isnull(dbo.LU_HCNProvince.CIHIValue, '''') AS province_issuing_health_card, 
    isnull(dbo.LU_RespPayment.CIHIValue, '''') AS responsibility_for_payment, 
    --isnull(dbo.CC_Demographic.HostChartNumber, '''') 
    dbo.CC_Demographic.ChartNumber AS host_hospital_patient_chart_nu, --PR-03328
    dbo.CC_DiseaseRegister.RegisterDate as RegistrationDate, 
    dbo.CC_Demographic.AbstractID AS zzAbstractLink, dbo.CC_Demographic.LinkID AS zzLinkID
FROM dbo.CC_Demographic with (nolock) inner join
    (select InstitutionNumber, ChartNumber, max(DiseaseSequenceNum) as MaxSeq
     from dbo.CC_Demographic D  with (nolock) 
        inner join dbo.CC_DiseaseRegister R with (nolock) ON D.AbstractID = R.AbstractID
        left  join dbo.CC_RecordInfo I with (nolock) ON D.AbstractID = I.AbstractID
     where D.AppID = 675 and InstitutionNumber > 0 and isnull(I.IsDeleted, 0) in (0, 2)
     group by InstitutionNumber, ChartNumber) M on dbo.CC_Demographic.ChartNumber = m.ChartNumber and dbo.CC_Demographic.InstitutionNumber = M.InstitutionNumber inner JOIN
    dbo.CC_DiseaseRegister with (nolock) ON dbo.CC_DiseaseRegister.AbstractID = dbo.CC_Demographic.AbstractID and M.MaxSeq = dbo.CC_DiseaseRegister.DiseaseSequenceNum LEFT OUTER JOIN
    dbo.LU_RespPayment with (nolock) ON dbo.LU_RespPayment.Code = dbo.CC_Demographic.ResponsiblePayment LEFT OUTER JOIN
    dbo.LU_HCNProvince with (nolock) ON dbo.CC_Demographic.HCNProvince = dbo.LU_HCNProvince.Code LEFT OUTER JOIN
    dbo.LU_Gender_I with (nolock) ON dbo.CC_Demographic.Gender = dbo.LU_Gender_I.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile with (nolock) ON dbo.CC_Demographic.InstitutionNumber = dbo.H_InstitutionProfile.Code
where dbo.CC_Demographic.AppID = 675
    --and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CC_Demographic.HospitalID is null or CC_Demographic.HospitalID = 0
    --or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CC_Demographic.HospitalID, 0)))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_RadPlanTreatActivity_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[CCM_Entity_RadPlanTreatActivity_VR]
AS
SELECT     
    patient_chart_number = dbo.CC_Demographic.ChartNumber, 
    visit_hospital_number = right(H_InstitutionProfile_visit.CIHIValue, 4), 
    submitting_hospital_number = right(H_InstitutionProfile_submit.CIHIValue, 4), 
    mis_functional_centre = isnull(LU_MISCode.CIHIValue, ''''),
    visit_date = isnull(convert(varchar(20), AB_Abstract.AdmitDate, 112), ''''),
    visit_time = isnull(left(replace(convert(varchar(20),  AB_Abstract.AdmitTime, 114), '':'', ''''), 4), ''''),
    rt_protocol = left(isnull(LU_CC_RT_PROTOCOL.CIHIVAlue, ''''), 40),
    course_of_radiation_treatment = isnull(cast(dbo.AB_CCM_Radiation.CourseOfRadiationTreatment as varchar(10)), ''''),
    course_complete_flag = isnull(LU_CourseCompleteFlag.CIHIValue, ''''),
    nhpip_code = isnull(LU_CCM_NHPIP_Code.CIHIValue, ''''),
    body_region_code = isnull(LU_CCM_BodyRegion.CIHIValue, ''''),
    dose_per_fraction = isnull(dbo.AB_CCM_Radiation.DosePerFraction, ''''),
    intent_of_radiation_treatment = isnull(LU_IntentOfRadiationTreatment.CIHIValue, ''''),
    inpatient_flag = isnull(LU_InpatientFlag.CIHIValue, ''''),
    chemo_flag = isnull(LU_ChemoFlag.CIHIValue, ''''),
    clinical_trial_flag = isnull(LU_ClinicalTrialFlag.CIHIValue, ''''),
    
    registration_date = isnull(convert(varchar(10), dbo.CC_DiseaseRegister.RegisterDate, 112), ''''),
    disease_sequence_number = isnull(dbo.CC_DiseaseRegister.DiseaseSequenceNum, 0),
    hcp_number = isnull(right(Replicate(''0'', 15) + LU_Provider.CIHIValue, 15), ''''),

    decision_to_treat_date = isnull(convert(varchar(20), dbo.AB_CCM_Radiation.DecisionToTreatDate, 112), ''''),
    ready_to_treat_date = isnull(convert(varchar(20), dbo.AB_CCM_Radiation.ReadyToTreatDate, 112), ''''),
    urgency_category = isnull(LU_UrgencyCategory.CIHIValue, ''''),

    patient_postal_code = isnull(AB_Abstract.PostalCode, ''''),
    patient_mohltc_residence_code = isnull(LU_ResidenceCode.CIHIValue, ''''),
    
    trt_unit_name = isnull(dbo.AB_CCM_Radiation.TreatmentUnitName, ''''),

    dbo.AB_CCM_CancerCareInformation.AbstractID as zzNACRSLink,
    dbo.CC_Demographic.AbstractID as zzCCMDiseaseLink
FROM
    dbo.AB_ABstract with (nolock) inner join 
    dbo.H_InstitutionProfile H_InstitutionProfile_visit with (nolock) ON H_InstitutionProfile_visit.Code = dbo.AB_Abstract.InstitutionNumber inner JOIN
    dbo.AB_CCM_CancerCareInformation with (nolock) ON dbo.AB_ABstract.AbstractId = dbo.AB_CCM_CancerCareInformation.AbstractID inner join
    AB_Main with (nolock) ON dbo.AB_CCM_CancerCareInformation.CancerCareVisit = AB_Main.UniversalID inner join
    dbo.AB_CCM_Radiation with (nolock) ON dbo.AB_CCM_CancerCareInformation.AbstractID = dbo.AB_CCM_Radiation.AbstractID inner join
    dbo.CC_Demographic with (nolock) ON AB_Main.AbstractID = dbo.CC_Demographic.AbstractID inner join 
    dbo.CC_DiseaseRegister with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_DiseaseRegister.AbstractID LEFT OUTER JOIN
    dbo.H_InstitutionProfile H_InstitutionProfile_submit with (nolock) ON H_InstitutionProfile_submit.Code = dbo.CC_Demographic.InstitutionNumber LEFT OUTER JOIN

    dbo.LU_MISCode with (nolock) ON dbo.AB_ABstract.MISCode = lu_MISCode.Code left join
    dbo.LU_ResidenceCode with (nolock) ON dbo.AB_ABstract.ResidenceCode = LU_ResidenceCode.Code left join

    --dbo.LU_CodeFile LU_VisitProgramCode with (nolock) ON dbo.AB_CCM_CancerCareInformation.VisitProgramCode = LU_VisitProgramCode.Code left join
    --dbo.LU_CodeFile LU_CCMVisitType with (nolock) ON dbo.AB_CCM_CancerCareInformation.CCMVisitType = LU_CCMVisitType.Code left join
    dbo.LU_CodeFile LU_RadiationReviewFlag with (nolock) ON dbo.AB_CCM_CancerCareInformation.RadiationReviewFlag = LU_RadiationReviewFlag.Code Left join

    dbo.LU_YesNoAlpha LU_InpatientFlag with (nolock) ON dbo.AB_CCM_CancerCareInformation.InpatientFlag = LU_InpatientFlag.Code Left join
    dbo.LU_YesNoAlpha LU_ChemoFlag with (nolock) ON dbo.AB_CCM_CancerCareInformation.ChemoFlag = LU_ChemoFlag.Code Left join
    dbo.LU_YesNoAlpha LU_ClinicalTrialFlag with (nolock) ON dbo.AB_CCM_CancerCareInformation.ClinicalTrialFlag = LU_ClinicalTrialFlag.Code Left join
    dbo.LU_Provider with (nolock) ON dbo.AB_CCM_CancerCareInformation.HealthCareProviderNumber = LU_Provider.Code left join
    
    dbo.LU_YesNoAlpha LU_CourseCompleteFlag with (nolock) ON dbo.AB_CCM_Radiation.CourseCompleteFlag = LU_CourseCompleteFlag.Code left join
    dbo.LU_CCM_NHPIP_Code with (nolock) ON dbo.AB_CCM_Radiation.NHPIPCode = LU_CCM_NHPIP_Code.Code left join
    dbo.LU_CCM_BodyRegion with (nolock) ON dbo.AB_CCM_Radiation.BodyRegionCode = LU_CCM_BodyRegion.code left join
    dbo.LU_CodeFile LU_IntentOfRadiationTreatment with (nolock) ON dbo.AB_CCM_Radiation.IntentOfRadiationTreatment = LU_IntentOfRadiationTreatment.Code left join
    dbo.LU_CodeFile LU_UrgencyCategory with (nolock) ON dbo.AB_CCM_Radiation.UrgencyCategory = LU_UrgencyCategory.Code left join
    LU_CC_RT_PROTOCOL with (nolock) ON dbo.AB_CCM_Radiation.RTProtocol = LU_CC_RT_PROTOCOL.Code

where   LU_RadiationReviewFlag.CIHIValue = ''R''  
    --and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
    --or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0)))

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_Entity_SysDrugDelivery_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[CCM_Entity_SysDrugDelivery_VR]
AS
SELECT     
    patient_chart_number = dbo.CC_Demographic.ChartNumber, 
    visit_hospital_number = right(H_InstitutionProfile_visit.CIHIValue, 4), 
    submitting_hospital_number = right(H_InstitutionProfile_submit.CIHIValue, 4), 
    mis_functional_centre = isnull(LU_MISCode.CIHIValue, ''''),
    visit_date = isnull(convert(varchar(20), AB_Abstract.AdmitDate, 112), ''''),
    visit_time = isnull(left(replace(convert(varchar(20),  AB_Abstract.AdmitTime, 114), '':'', ''''), 4), ''''),

    cco_regimen = isnull(LU_CCORegimen.CIHIValue, ''''),
    cco_drug_code = isnull(dbo.AB_CCM_SystemicDrug.CCODrugCode, ''''),
    din = isnull(dbo.AB_CCM_SystemicDrug.CCMDIN, ''''),
    drug_origin_flag = isnull(LU_DrugOriginFlag.CIHIValue, ''''),
    body_surface_area = isnull(cast(dbo.AB_CCM_SystemicDrug.BodySurfaceArea as varchar(20)), ''''),
    dose_administered = isnull(cast(dbo.AB_CCM_SystemicDrug.DoseAdministered as varchar(20)), ''''),
    measurement_unit = isnull(LU_MeasurementUnit.CIHIValue, ''''),
    route = isnull(LU_Route.CIHIValue, ''''),
    intent_of_systemic_treatment = isnull(LU_IntentOfSystemicTreatment.CIHIValue, ''''),
    line_of_therapy = isnull(cast(dbo.AB_CCM_SystemicDrug.LineOfTherapy as varchar(10)), ''''),

    inpatient_flag = isnull(LU_InpatientFlag.CIHIValue, ''''),
    clinical_trial_flag = isnull(LU_ClinicalTrialFlag.CIHIValue, ''''),
    arrived_but_not_treated = isnull(LU_ArrivedByNotTreatedFlag.CIHIValue, ''''),
    
    cmir_severity = isnull(LU_CMIRSeverity.CIHIValue, ''''),

    registration_date = isnull(convert(varchar(10), dbo.CC_DiseaseRegister.RegisterDate, 112), ''''),
    disease_sequence_number = isnull(dbo.CC_DiseaseRegister.DiseaseSequenceNum, 0),
    hcp_number = isnull(right(Replicate(''0'', 15) + LU_Provider.CIHIValue, 15), ''''),
    patient_postal_code = isnull(AB_Abstract.PostalCode, ''''),
    patient_mohltc_residence_code = isnull(LU_ResidenceCode.CIHIValue, ''''),
    
    dbo.AB_CCM_SystemicDrug.Occurrence as zzDrugOccurrence,
    dbo.AB_CCM_CancerCareInformation.AbstractID as zzNACRSLink,
    dbo.CC_Demographic.AbstractID as zzCCMDiseaseLink
FROM
    dbo.AB_ABstract inner join 
    dbo.H_InstitutionProfile H_InstitutionProfile_visit ON H_InstitutionProfile_visit.Code = dbo.AB_Abstract.InstitutionNumber inner JOIN
    dbo.AB_CCM_CancerCareInformation on dbo.AB_ABstract.AbstractId = dbo.AB_CCM_CancerCareInformation.AbstractID inner join
	-- '' PR 05464 2011-07-20, use LEFT OUTER JOIN (below) to include records with no SystemicDrug entries...
    AB_Main on dbo.AB_CCM_CancerCareInformation.CancerCareVisit = AB_Main.UniversalID LEFT OUTER JOIN -- inner join 
    dbo.AB_CCM_SystemicDrug on dbo.AB_CCM_CancerCareInformation.AbstractID = dbo.AB_CCM_SystemicDrug.AbstractID inner join
    dbo.CC_Demographic on AB_Main.AbstractID = dbo.CC_Demographic.AbstractID inner join 
    dbo.CC_DiseaseRegister ON dbo.CC_Demographic.AbstractID = dbo.CC_DiseaseRegister.AbstractID LEFT OUTER JOIN
    dbo.H_InstitutionProfile H_InstitutionProfile_submit ON H_InstitutionProfile_submit.Code = dbo.CC_Demographic.InstitutionNumber LEFT OUTER JOIN

    dbo.LU_MISCode on dbo.AB_ABstract.MISCode = lu_MISCode.Code left join
    dbo.LU_ResidenceCode on dbo.AB_ABstract.ResidenceCode = LU_ResidenceCode.Code left join

    dbo.LU_CodeFile LU_VisitProgramCode on dbo.AB_CCM_CancerCareInformation.VisitProgramCode = LU_VisitProgramCode.Code left join
    dbo.LU_CodeFile LU_CCMVisitType on dbo.AB_CCM_CancerCareInformation.CCMVisitType = LU_CCMVisitType.Code left join
    dbo.LU_CodeFile LU_RadiationReviewFlag on dbo.AB_CCM_CancerCareInformation.RadiationReviewFlag = LU_RadiationReviewFlag.Code Left join

    dbo.LU_YesNoAlpha LU_InpatientFlag on dbo.AB_CCM_CancerCareInformation.InpatientFlag = LU_InpatientFlag.Code Left join
    dbo.LU_YesNoAlpha LU_ChemoFlag on dbo.AB_CCM_CancerCareInformation.ChemoFlag = LU_ChemoFlag.Code Left join
     dbo.LU_YesNoAlpha LU_ClinicalTrialFlag on dbo.AB_CCM_CancerCareInformation.ClinicalTrialFlag = LU_ClinicalTrialFlag.Code Left join
    dbo.LU_Provider on dbo.AB_CCM_CancerCareInformation.HealthCareProviderNumber = LU_Provider.Code left join
    dbo.LU_YesNoAlpha LU_ArrivedByNotTreatedFlag on dbo.AB_CCM_CancerCareInformation.ArrivedByNotTreatedFlag = LU_ArrivedByNotTreatedFlag.Code left join
    
    dbo.LU_CodeFile LU_CCORegimen on dbo.AB_CCM_SystemicDrug.CCORegimen = LU_CCORegimen.Code left join
    dbo.LU_YesNoAlpha LU_DrugOriginFlag on dbo.AB_CCM_SystemicDrug.DrugOriginFlag = LU_DrugOriginFlag.Code left join
    dbo.LU_CodeFile LU_MeasurementUnit on dbo.AB_CCM_SystemicDrug.MeasurementUnit = LU_MeasurementUnit.Code left join
    dbo.LU_CodeFile LU_Route on dbo.AB_CCM_SystemicDrug.[Route] = LU_Route.Code left join
    dbo.LU_CodeFile LU_IntentOfSystemicTreatment on dbo.AB_CCM_SystemicDrug.IntentOfSystemicTreatment = LU_IntentOfSystemicTreatment.Code left join
    dbo.LU_CodeFile LU_CMIRSeverity on dbo.AB_CCM_SystemicDrug.CMIRSeverity = LU_CMIRSeverity.Code 
where AB_CCM_CancerCareInformation.CancerCareVisit > 0 and AB_CCM_SystemicDrug.CCORegimen > 0  --   LU_ChemoFlag.CIHIValue = ''Y'' 

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_HealthCareProfessional_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[CCM_HealthCareProfessional_VR]
AS
SELECT     dbo.CC_HealthCareProf.FirstName AS HCPFirstName, dbo.CC_HealthCareProf.Occurrence AS HCPOccurrence, 
    LU_HCPNumber.DisplayCode AS HCPNumber, LU_HCPNumber.UserDescription AS HCPNumberDesc, 
    LU_ProgramCode.DisplayCode AS HCPProgramCode, LU_ProgramCode.UserDescription AS HCPProgramCodeDesc, 
    dbo.LU_ProviderSpecialty.DisplayCode AS HCPSpecialtyCode, dbo.LU_ProviderSpecialty.UserDescription AS HCPSpecialtyCodeDesc, 
    LU_Status.DisplayCode AS HCPStatus, LU_Status.UserDescription AS HCPStatusDesc, dbo.CC_HealthCareProf.SurName AS HCPSurname, 
    LU_HostHCPNumber.DisplayCode AS HostHCPNumber, LU_HostHCPNumber.UserDescription AS HostHCPNumberDesc, 
    dbo.CC_HealthCareProf.AbstractID AS zzAbstractLink
FROM         dbo.CC_HealthCareProf with (nolock) LEFT OUTER JOIN
    dbo.LU_Provider LU_HostHCPNumber with (nolock) ON dbo.CC_HealthCareProf.HostHCPNumber = LU_HostHCPNumber.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Status with (nolock) ON dbo.CC_HealthCareProf.Status = LU_Status.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty with (nolock) ON dbo.CC_HealthCareProf.SpecialtyCode = dbo.LU_ProviderSpecialty.Code LEFT OUTER JOIN
    dbo.LU_Provider LU_HCPNumber with (nolock) ON dbo.CC_HealthCareProf.HCPNumber = LU_HCPNumber.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_ProgramCode with (nolock) ON dbo.CC_HealthCareProf.ProgramCode = LU_ProgramCode.Code
where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or LU_HostHCPNumber.HospitalID is null or LU_HostHCPNumber.HospitalID = 0
    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(LU_HostHCPNumber.HospitalID, 0))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_NDFP_Enrollment_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[CCM_NDFP_Enrollment_VR]
AS
SELECT     
    VisitHospitalNumber = dbo.LU_Institution_10.DisplayCode, VisitHospitalNumberDesc = dbo.LU_Institution_10.UserDescription, 

    NDFPFormNumber = dbo.CC_NDFP.NDFPNumber, 
    NDFPFormVersionNumber = dbo.CC_NDFP.NDFPVersion, 
    dbo.CC_NDFP.FirstTreatDate, 

    dbo.CC_NDFP.Height, 
    dbo.CC_NDFP.Weight,  
    dbo.CC_NDFP.BodySurfaceArea, 
    Intent = LU_Intent.DisplayCode, IntentDesc = LU_Intent.UserDescription, 
    EligibilityAnswer1  = dbo.CC_NDFP.EligAnswr1, 
    EligibilityAnswer2  = dbo.CC_NDFP.EligAnswr2,
    EligibilityAnswer3  = dbo.CC_NDFP.EligAnswr3, 
    EligibilityAnswer4  = dbo.CC_NDFP.EligAnswr4, 
    EligibilityAnswer5  = dbo.CC_NDFP.EligAnswr5, 
    EligibilityAnswer6  = dbo.CC_NDFP.EligAnswr6, 
    EligibilityAnswer7  = dbo.CC_NDFP.EligAnswr7, 
    EligibilityAnswer8  = dbo.CC_NDFP.EligAnswr8, 
    EligibilityAnswer9  = dbo.CC_NDFP.EligAnswr9, 
    EligibilityAnswer10 = dbo.CC_NDFP.EligAnswr10, 
    EligibilityAnswer11 = dbo.CC_NDFP.EligAnswr11, 
    EligibilityAnswer12 = dbo.CC_NDFP.EligAnswr12, 
    EligibilityAnswer13 = dbo.CC_NDFP.EligAnswr13, 
    EligibilityAnswer14 = dbo.CC_NDFP.EligAnswr14, 
    EligibilityAnswer15 = dbo.CC_NDFP.EligAnswr15, 
    EligibilityAnswer16 = dbo.CC_NDFP.EligAnswr16, 
    EligibilityAnswer17 = dbo.CC_NDFP.EligAnswr17, 
    EligibilityAnswer18 = dbo.CC_NDFP.EligAnswr18, 
    EligibilityAnswer19 = dbo.CC_NDFP.EligAnswr19, 
    EligibilityAnswer20 = dbo.CC_NDFP.EligAnswr20, 
    EligibilityAnswer21 = dbo.CC_NDFP.EligAnswr21, 
    EligibilityAnswer22 = dbo.CC_NDFP.EligAnswr22, 
    EligibilityAnswer23 = dbo.CC_NDFP.EligAnswr23, 
    EligibilityAnswer24 = dbo.CC_NDFP.EligAnswr24, 
    EligibilityAnswer25 = dbo.CC_NDFP.EligAnswr25, 
    EligibilityAnswer26 = dbo.CC_NDFP.EligAnswr26, 
    EligibilityAnswer27 = dbo.CC_NDFP.EligAnswr27, 
    EligibilityAnswer28 = dbo.CC_NDFP.EligAnswr28, 
    EligibilityAnswer29 = dbo.CC_NDFP.EligAnswr29, 
    EligibilityAnswer30 = dbo.CC_NDFP.EligAnswr30, 
    dbo.CC_NDFP.AbstractID as zzAbstractLink
FROM   
    dbo.CC_NDFP with (nolock) 
    LEFT OUTER JOIN dbo.LU_Institution_10  with (nolock) ON dbo.CC_NDFP.VisitHospitalNum = dbo.LU_Institution_10.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_Intent with (nolock) ON dbo.CC_NDFP.Intent = LU_Intent.Code




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[CCM_UD_Abstracting_VR]
AS
SELECT
    dbo.CC_UserDefined.UDDate1 AS Date1UD, 
    dbo.CC_UserDefined.UDDate2 AS Date2UD, 
    dbo.CC_UserDefined.UDDate3 AS Date3UD, 
    dbo.CC_UserDefined.UDDate4 AS Date4UD, 
    dbo.CC_UserDefined.UDDate5 AS Date5UD, 
    dbo.CC_UDFieldsDate.UDDate6  AS Date6UD, 
    dbo.CC_UDFieldsDate.UDDate7  AS Date7UD, 
    dbo.CC_UDFieldsDate.UDDate8  AS Date8UD, 
    dbo.CC_UDFieldsDate.UDDate9  AS Date9UD, 
    dbo.CC_UDFieldsDate.UDDate10 AS Date10UD, 
    dbo.CC_UDFieldsDate.UDDate11 AS Date11UD, 
    dbo.CC_UDFieldsDate.UDDate12 AS Date12UD, 
    dbo.CC_UDFieldsDate.UDDate13 AS Date13UD, 
    dbo.CC_UDFieldsDate.UDDate14 AS Date14UD, 
    dbo.CC_UDFieldsDate.UDDate15 AS Date15UD, 
    dbo.CC_UDFieldsDate.UDDate16 AS Date16UD, 
    dbo.CC_UDFieldsDate.UDDate17 AS Date17UD, 
    dbo.CC_UDFieldsDate.UDDate18 AS Date18UD, 
    dbo.CC_UDFieldsDate.UDDate19 AS Date19UD, 
    dbo.CC_UDFieldsDate.UDDate20 AS Date20UD, 
    dbo.CC_UDFieldsDate.UDDate21 AS Date21UD, 
    dbo.CC_UDFieldsDate.UDDate22 AS Date22UD, 
    dbo.CC_UDFieldsDate.UDDate23 AS Date23UD, 
    dbo.CC_UDFieldsDate.UDDate24 AS Date24UD, 
    dbo.CC_UDFieldsDate.UDDate25 AS Date25UD, 
    
    LU_UD_01.DisplayCode AS Lookup1UD,     LU_UD_01.UserDescription AS Lookup1UDDesc, 
    LU_UD_02.DisplayCode AS Lookup2UD,     LU_UD_02.UserDescription AS Lookup2UDDesc, 
    LU_UD_03.DisplayCode AS Lookup3UD,     LU_UD_03.UserDescription AS Lookup3UDDesc, 
    LU_UD_04.DisplayCode AS Lookup4UD,     LU_UD_04.UserDescription AS Lookup4UDDesc, 
    LU_UD_05.DisplayCode AS Lookup5UD,     LU_UD_05.UserDescription AS Lookup5UDDesc, 
    LU_UD_06.DisplayCode AS Lookup6UD,     LU_UD_06.UserDescription AS Lookup6UDDesc, 
    LU_UD_07.DisplayCode AS Lookup7UD,     LU_UD_07.UserDescription AS Lookup7UDDesc, 
    LU_UD_08.DisplayCode AS Lookup8UD,     LU_UD_08.UserDescription AS Lookup8UDDesc, 
    LU_UD_09.DisplayCode AS Lookup9UD,     LU_UD_09.UserDescription AS Lookup9UDDesc, 
    LU_UD_10.DisplayCode AS Lookup10UD,    LU_UD_10.UserDescription AS Lookup10UDDesc, 
    LU_UD_11.DisplayCode AS Lookup11UD,     LU_UD_11.UserDescription AS Lookup11UDDesc, 
    LU_UD_12.DisplayCode AS Lookup12UD,     LU_UD_12.UserDescription AS Lookup12UDDesc, 
    LU_UD_13.DisplayCode AS Lookup13UD,     LU_UD_13.UserDescription AS Lookup13UDDesc, 
    LU_UD_14.DisplayCode AS Lookup14UD,     LU_UD_14.UserDescription AS Lookup14UDDesc, 
    LU_UD_15.DisplayCode AS Lookup15UD,     LU_UD_15.UserDescription AS Lookup15UDDesc, 
    LU_UD_16.DisplayCode AS Lookup16UD,     LU_UD_16.UserDescription AS Lookup16UDDesc, 
    LU_UD_17.DisplayCode AS Lookup17UD,     LU_UD_17.UserDescription AS Lookup17UDDesc, 
    LU_UD_18.DisplayCode AS Lookup18UD,     LU_UD_18.UserDescription AS Lookup18UDDesc, 
    LU_UD_19.DisplayCode AS Lookup19UD,     LU_UD_19.UserDescription AS Lookup19UDDesc, 
    LU_UD_20.DisplayCode AS Lookup20UD,     LU_UD_20.UserDescription AS Lookup20UDDesc, 
    LU_UD_21.DisplayCode AS Lookup21UD,     LU_UD_21.UserDescription AS Lookup21UDDesc, 
    LU_UD_22.DisplayCode AS Lookup22UD,     LU_UD_22.UserDescription AS Lookup22UDDesc, 
    LU_UD_23.DisplayCode AS Lookup23UD,     LU_UD_23.UserDescription AS Lookup23UDDesc, 
    LU_UD_24.DisplayCode AS Lookup24UD,     LU_UD_24.UserDescription AS Lookup24UDDesc, 
    LU_UD_25.DisplayCode AS Lookup25UD,     LU_UD_25.UserDescription AS Lookup25UDDesc, 

    dbo.CC_UserDefined.UDInteger1 AS Numeric1UD, 
    dbo.CC_UserDefined.UDInteger2 AS Numeric2UD, 
    dbo.CC_UserDefined.UDInteger3 AS Numeric3UD, 
    dbo.CC_UserDefined.UDInteger4 AS Numeric4UD, 
    dbo.CC_UserDefined.UDInteger5 AS Numeric5UD, 
    dbo.CC_UDFieldsInteger.UDInteger6  AS Numeric6UD, 
    dbo.CC_UDFieldsInteger.UDInteger7  AS Numeric7UD, 
    dbo.CC_UDFieldsInteger.UDInteger8  AS Numeric8UD, 
    dbo.CC_UDFieldsInteger.UDInteger9  AS Numeric9UD, 
    dbo.CC_UDFieldsInteger.UDInteger10 AS Numeric10UD, 
    dbo.CC_UDFieldsInteger.UDInteger11 AS Numeric11UD, 
    dbo.CC_UDFieldsInteger.UDInteger12 AS Numeric12UD, 
    dbo.CC_UDFieldsInteger.UDInteger13 AS Numeric13UD, 
    dbo.CC_UDFieldsInteger.UDInteger14 AS Numeric14UD, 
    dbo.CC_UDFieldsInteger.UDInteger15 AS Numeric15UD, 
    dbo.CC_UDFieldsInteger.UDInteger16 AS Numeric16UD, 
    dbo.CC_UDFieldsInteger.UDInteger17 AS Numeric17UD, 
    dbo.CC_UDFieldsInteger.UDInteger18 AS Numeric18UD, 
    dbo.CC_UDFieldsInteger.UDInteger19 AS Numeric19UD, 
    dbo.CC_UDFieldsInteger.UDInteger20 AS Numeric20UD, 
    dbo.CC_UDFieldsInteger.UDInteger21 AS Numeric21UD, 
    dbo.CC_UDFieldsInteger.UDInteger22 AS Numeric22UD, 
    dbo.CC_UDFieldsInteger.UDInteger23 AS Numeric23UD, 
    dbo.CC_UDFieldsInteger.UDInteger24 AS Numeric24UD, 
    dbo.CC_UDFieldsInteger.UDInteger25 AS Numeric25UD, 

    dbo.CC_UserDefined.UDText1 AS Notes1UD, 
    dbo.CC_UserDefined.UDText2 AS Notes2UD, 
    dbo.CC_UserDefined.UDText3 AS Notes3UD, 
    dbo.CC_UserDefined.UDText4 AS Notes4UD, 
    dbo.CC_UserDefined.UDText5 AS Notes5UD, 
    dbo.CC_UDFieldsText.UDText6 AS Notes6UD, 
    dbo.CC_UDFieldsText.UDText7 AS Notes7UD, 
    dbo.CC_UDFieldsText.UDText8 AS Notes8UD, 
    dbo.CC_UDFieldsText.UDText9 AS Notes9UD, 
    dbo.CC_UDFieldsText.UDText10 AS Notes10UD, 
    dbo.CC_UDFieldsText.UDText11 AS Notes11UD, 
    dbo.CC_UDFieldsText.UDText12 AS Notes12UD, 
    dbo.CC_UDFieldsText.UDText13 AS Notes13UD, 
    dbo.CC_UDFieldsText.UDText14 AS Notes14UD, 
    dbo.CC_UDFieldsText.UDText15 AS Notes15UD, 
    dbo.CC_UDFieldsText.UDText16 AS Notes16UD, 
    dbo.CC_UDFieldsText.UDText17 AS Notes17UD, 
    dbo.CC_UDFieldsText.UDText18 AS Notes18UD, 
    dbo.CC_UDFieldsText.UDText19 AS Notes19UD, 
    dbo.CC_UDFieldsText.UDText20 AS Notes20UD, 
    dbo.CC_UDFieldsText.UDText21 AS Notes21UD, 
    dbo.CC_UDFieldsText.UDText22 AS Notes22UD, 
    dbo.CC_UDFieldsText.UDText23 AS Notes23UD, 
    dbo.CC_UDFieldsText.UDText24 AS Notes24UD, 
    dbo.CC_UDFieldsText.UDText25 AS Notes25UD, 

    dbo.CC_UserDefined.UDSmallText1 AS Text1UD, 
    dbo.CC_UserDefined.UDSmallText2 AS Text2UD, 
    dbo.CC_UserDefined.UDSmallText3 AS Text3UD, 
    dbo.CC_UserDefined.UDSmallText4 AS Text4UD, 
    dbo.CC_UserDefined.UDSmallText5 AS Text5UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText6 AS Text6UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText7 AS Text7UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText8 AS Text8UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText9 AS Text9UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText10 AS Text10UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText11 AS Text11UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText12 AS Text12UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText13 AS Text13UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText14 AS Text14UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText15 AS Text15UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText16 AS Text16UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText17 AS Text17UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText18 AS Text18UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText19 AS Text19UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText20 AS Text20UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText21 AS Text21UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText22 AS Text22UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText23 AS Text23UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText24 AS Text24UD, 
    dbo.CC_UDFieldsSmallText.UDSmallText25 AS Text25UD, 

    dbo.CC_UserDefined.UDTime1 AS Time1UD, 
    dbo.CC_UserDefined.UDTime2 AS Time2UD, 
    dbo.CC_UserDefined.UDTime3 AS Time3UD, 
    dbo.CC_UserDefined.UDTime4 AS Time4UD, 
    dbo.CC_UserDefined.UDTime5 AS Time5UD, 
    dbo.CC_UDFieldsTime.UDTime6 AS Time6UD, 
    dbo.CC_UDFieldsTime.UDTime7 AS Time7UD, 
    dbo.CC_UDFieldsTime.UDTime8 AS Time8UD, 
    dbo.CC_UDFieldsTime.UDTime9 AS Time9UD, 
    dbo.CC_UDFieldsTime.UDTime10 AS Time10UD, 
    dbo.CC_UDFieldsTime.UDTime11 AS Time11UD, 
    dbo.CC_UDFieldsTime.UDTime12 AS Time12UD, 
    dbo.CC_UDFieldsTime.UDTime13 AS Time13UD, 
    dbo.CC_UDFieldsTime.UDTime14 AS Time14UD, 
    dbo.CC_UDFieldsTime.UDTime15 AS Time15UD, 
    dbo.CC_UDFieldsTime.UDTime16 AS Time16UD, 
    dbo.CC_UDFieldsTime.UDTime17 AS Time17UD, 
    dbo.CC_UDFieldsTime.UDTime18 AS Time18UD, 
    dbo.CC_UDFieldsTime.UDTime19 AS Time19UD, 
    dbo.CC_UDFieldsTime.UDTime20 AS Time20UD, 
    dbo.CC_UDFieldsTime.UDTime21 AS Time21UD, 
    dbo.CC_UDFieldsTime.UDTime22 AS Time22UD, 
    dbo.CC_UDFieldsTime.UDTime23 AS Time23UD, 
    dbo.CC_UDFieldsTime.UDTime24 AS Time24UD, 
    dbo.CC_UDFieldsTime.UDTime25 AS Time25UD, 

    dbo.CC_Demographic.Abstractid AS zzAbstractLink
FROM  [dbo].[CC_Demographic] with (nolock) LEFT OUTER JOIN      
    dbo.CC_UserDefined with (nolock) on CC_Demographic.AbstractID = CC_UserDefined.AbstractID LEFT OUTER JOIN
    [dbo].[CC_UDFieldsDate] with (nolock) on CC_Demographic.AbstractID = CC_UDFieldsDate.AbstractID LEFT OUTER JOIN
    [dbo].[CC_UDFieldsInteger] with (nolock) on CC_Demographic.AbstractID = CC_UDFieldsInteger.AbstractID LEFT OUTER JOIN
    [dbo].[CC_UDFieldsLookUp] with (nolock) on CC_Demographic.AbstractID = CC_UDFieldsLookUp.AbstractID LEFT OUTER JOIN
    [dbo].[CC_UDFieldsSmallText] with (nolock) on CC_Demographic.AbstractID = CC_UDFieldsSmallText.AbstractID LEFT OUTER JOIN
    [dbo].[CC_UDFieldsText] with (nolock) on CC_Demographic.AbstractID = CC_UDFieldsText.AbstractID LEFT OUTER JOIN
    [dbo].[CC_UDFieldsTime] with (nolock) on CC_Demographic.AbstractID = CC_UDFieldsTime.AbstractID LEFT OUTER JOIN

    dbo.LU_CodeFile LU_UD_01 with (nolock) ON dbo.CC_UserDefined.UDLookup1 = LU_UD_01.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_02 with (nolock) ON dbo.CC_UserDefined.UDLookup2 = LU_UD_02.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_03 with (nolock) ON dbo.CC_UserDefined.UDLookup3 = LU_UD_03.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_04 with (nolock) ON dbo.CC_UserDefined.UDLookup4 = LU_UD_04.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_05 with (nolock) ON dbo.CC_UserDefined.UDLookup5 = LU_UD_05.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_06 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup6  = LU_UD_06.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_07 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup7  = LU_UD_07.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_08 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup8  = LU_UD_08.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_09 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup9  = LU_UD_09.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_10 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup10 = LU_UD_10.Code LEFT OUTER JOIN

    dbo.LU_CodeFile LU_UD_11 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup11 = LU_UD_11.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_12 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup12 = LU_UD_12.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_13 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup13 = LU_UD_13.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_14 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup14 = LU_UD_14.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_15 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup15 = LU_UD_15.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_16 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup16 = LU_UD_16.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_17 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup17 = LU_UD_17.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_18 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup18 = LU_UD_18.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_19 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup19 = LU_UD_19.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_20 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup20 = LU_UD_20.Code LEFT OUTER JOIN

    dbo.LU_CodeFile LU_UD_21 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup21 = LU_UD_21.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_22 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup22 = LU_UD_22.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_23 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup23 = LU_UD_23.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_24 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup24 = LU_UD_24.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_UD_25 with (nolock) ON dbo.CC_UDFieldsLookUp.UDLookup25 = LU_UD_25.Code 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[CCM_UpdateHistory_VR]
AS
SELECT     dbo.H_HospitalProfile.DisplayCode AS Hospital, dbo.H_HospitalProfile.UserDescription AS HospitalDesc, dbo.U_Users.DisplayCode AS UpdateCoder, 
                      dbo.U_Users.UserDescription AS UpdateCoderDesc, dbo.CC_UpdateHistory.Updated AS UpdateDate, dbo.CC_UpdateHistory.UpdateType, 
                      dbo.CC_UpdateHistory.AbstractID AS zzAbstractLink
FROM         dbo.CC_UpdateHistory with (nolock) LEFT OUTER JOIN
                      dbo.H_HospitalProfile with (nolock) ON dbo.H_HospitalProfile.Code = dbo.CC_UpdateHistory.HospitalID LEFT OUTER JOIN
                      dbo.U_Users with (nolock) ON dbo.CC_UpdateHistory.Coder = dbo.U_Users.Code




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CCM_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE View [dbo].[CCM_VR]
as
SELECT     

AbstractType = Lu_Application.DisplayCode, AbstractTypeDesc = Lu_Application.UserDescription,
--PR - 03587
LU_AnalyticFlag.DisplayCode as AnalyticCaseFlag, LU_AnalyticFlag.UserDescription as AnalyticCaseFlagDesc, 

LU_BasisOfDiagnosis.DisplayCode as BasisOfDiagnosis, LU_BasisOfDiagnosis.UserDescription as BasisOfDiagnosisDesc, 
dbo.CC_Demographic.BirthDate, 

dbo.CC_Demographic.ChartNumber, 

LU_ClinStageDiag.STAGE  as ClinicalStageAtDiagnosis,
dbo.CC_CancerStageDiag.ClinStageDiag_M  as ClinicalStageAtDiagnosis_M, 
dbo.CC_CancerStageDiag.ClinStageDiag_N  as ClinicalStageAtDiagnosis_N, 
LU_ClinStageDiag_N_S.Displaycode AS ClinicalStageAtDiagnosis_N_Suffix, LU_ClinStageDiag_N_S.UserDescription AS ClinicalStageAtDiagnosis_N_SuffixDesc, 
dbo.CC_CancerStageDiag.ClinStageDiag_T  as ClinicalStageAtDiagnosis_T,
LU_ClinStageDiag_T_S.Displaycode AS ClinicalStageAtDiagnosis_T_Suffix, LU_ClinStageDiag_T_S.UserDescription AS ClinicalStageAtDiagnosis_T_SuffixDesc, 


dbo.CC_CollaborateStageDiag.Extension as CSExtension,
LU_CSLymphNodes.DisplayCode as CSLymphNodes, LU_CSLymphNodes.UserDescription as CSLymphNodesDesc,
dbo.CC_CollaborateStageDiag.MetastasesDiag as CSMetastasesAtDiagnosis, 
dbo.CC_CollaborateStageDiag.MetastasesEval as CSMetastasesEvaluated, 
LU_CSRegionalNodesEvaluation.DisplayCode as CSRegionalNodesEvaluation, LU_CSRegionalNodesEvaluation.UserDescription as CSRegionalNodesEvaluationDesc, 
dbo.CC_CollaborateStageDiag.RegionNodeExamined as CSRegionalNodesExamined, 
LU_CSRegionalNodesPositive.DisplayCode as CSRegionalNodesPositive, LU_CSRegionalNodesPositive.UserDescription as CSRegionalNodesPositiveDesc, 
dbo.CC_CollaborateStageDiag.SiteSpecFactor1 as CSSiteSpecificFactor1,
dbo.CC_CollaborateStageDiag.SiteSpecFactor2 as CSSiteSpecificFactor2,
dbo.CC_CollaborateStageDiag.SiteSpecFactor3 as CSSiteSpecificFactor3,
dbo.CC_CollaborateStageDiag.SiteSpecFactor4 as CSSiteSpecificFactor4,
dbo.CC_CollaborateStageDiag.SiteSpecFactor5 as CSSiteSpecificFactor5,
dbo.CC_CollaborateStageDiag.SiteSpecFactor6 as CSSiteSpecificFactor6,
dbo.CC_CollaborateStageDiag.TumourExtensionEval as CSTumourExtensionEvaluation, 
dbo.CC_CollaborateStageDiag.TumourSize as CSTumourSize, 
dbo.CC_CollaborateStageDiag.Version as CSVersion, 

LU_DataEntryCoderNumber.DisplayCode as DataEntryCoderNumber, LU_DataEntryCoderNumber.UserDescription as DataEntryCoderNumberDesc, 
dbo.CC_Demographic.DeathDate AS DatePatientDied, 
LU_DeathIndicator.DisplayCode as DeathIndicator, LU_DeathIndicator.UserDescription as DeathIndicatorDesc, 
LU_DiagnosisCode.DisplayCode as DiagnosisCode, LU_DiagnosisCode.UserDescription as DiagnosisCodeDesc, 
dbo.CC_DiseaseRegister.DiagHospitalChartNum as DiagnosisHospitalChartNumber, 
LU_DiagnosisHospitalNumber.DisplayCode as DiagnosisHospitalNumber, LU_DiagnosisHospitalNumber.UserDescription as DiagnosisHospitalNumberDesc,
dbo.CC_DiseaseRegister.DiagnosisVersion,

dbo.CC_DischargeInfo.DischargeAge,
LU_DischargeAgeCode.DisplayCode as DischargeAgeCode, LU_DischargeAgeCode.UserDescription as DischargeAgeCodeDesc,
dbo.CC_DischargeInfo.DischargeDate, 
dbo.CC_DiseaseRegister.DiseaseSequenceNum as DiseaseSequenceNumber,
LU_DispositionCode.DisplayCode as DispositionCode, LU_DispositionCode.UserDescription as DispositionCodeDesc, 

dbo.CC_DiseaseRegister.DurationDiseaseReg as DurationSinceDiseaseRegistry, 
dbo.CC_DiseaseRegister.DurationInitDiag as DurationSinceInitialDiagnosis,
dbo.CC_DischargeInfo.DurationInMonths, 
dbo.CC_ReferralDate.DurationPalliativeCare,


dbo.CC_CancerStageDiag.ExtentDisease_cM  as ExtentDisease_cM, 
dbo.CC_CancerStageDiag.ExtentDisease_cN  as ExtentDisease_cN, 
dbo.CC_CancerStageDiag.ExtentDisease_cT  as ExtentDisease_cT, 
dbo.CC_CancerStageDiag.ExtentDisease_cTNM  as  ExtentDisease_cTNM, 
dbo.CC_CancerStageDiag.ExtentDisease_pM  as ExtentDisease_pM,  
dbo.CC_CancerStageDiag.ExtentDisease_pN  as ExtentDisease_pN, 
dbo.CC_CancerStageDiag.ExtentDisease_pT  as ExtentDisease_pT, 
dbo.CC_CancerStageDiag.ExtentDisease_pTNM  as ExtentDisease_pTNM, 

--(select top 1 FacilityNumber from dbo.H_HospitalProfile where isnull(dbo.H_InstitutionProfile.HospitalID, 0) in (0, dbo.H_HospitalProfile.Code) order by FacilityNumber desc) AS FacilityNumber, 

dbo.CC_RecordInfo.CCRegFileDate as FileRunDate,
LU_FileRunBy.DisplayCode as FileRunBy, LU_FileRunBy.UserDescription as FileRunByDesc, 
dbo.CC_Demographic.FirstName, 
LU_FirstSurgicalTreatFlag.DisplayCode as FirstSurgicalTreatFlag, LU_FirstSurgicalTreatFlag.UserDescription as FirstSurgicalTreatFlagDesc, 
dbo.CC_DiseaseRegister.FirstSurgTreatDate as FirstSurgicalTreatmentDate, 
FixedChartNumber,

LU_Gender_I.DisplayCode as Gender, LU_Gender_I.UserDescription as GenderDesc, 

LU_HCNProvince.DisplayCode as HCNProvince, LU_HCNProvince.UserDescription as HCNProvinceDesc, 
dbo.CC_Demographic.HCNVersion, 
dbo.CC_Demographic.HealthCareNumber, 
H_HospitalProfile.DisplayCode as Hospital, H_HospitalProfile.UserDescription as HospitalDesc,  
--dbo.CC_Demographic.HostChartNumber as HostHospitalChartNumber, 
dbo.CC_Demographic.ChartNumber as HostHospitalChartNumber, 
HospitalAccountRecord,
LU_InitialDiagnosisAgeCode.DisplayCode as InitialDiagnosisAgeCode, LU_InitialDiagnosisAgeCode.UserDescription as InitialDiagnosisAgeCodeDesc, 
dbo.CC_DiseaseRegister.DiagAgeNumber as InitialDiagnosisAgeNumber,
dbo.CC_DiseaseRegister.InitalDiagDate as InitalDiagnosisDate,
H_InstitutionProfile.DisplayCode as InstitutionNumber, H_InstitutionProfile.UserDescription as InstitutionNumberDesc,  
dbo.CC_RecordInfo.InputDate, dbo.CC_RecordInfo.InputTime,
LU_IsCompleted.DisplayCode as IsCompleted, LU_IsCompleted.UserDescription as IsCompletedDesc, 
LU_CIHICorrect.DisplayCode as IsCorrected, LU_CIHICorrect.UserDescription as IsCorrectedDesc, 
LU_IsDeleted.DisplayCode as IsDeleted, LU_IsDeleted.UserDescription as IsDeletedDesc,
LU_IsSubmited.DisplayCode as IsSubmited, LU_IsSubmited.UserDescription as IsSubmitedDesc, 
LU_IsValidated.DisplayCode as IsValidated, LU_IsValidated.UserDescription as IsValidatedDesc, 

dbo.CC_Demographic.LastName, 
LU_Laterality.DisplayCode as Laterality, LU_Laterality.UserDescription as LateralityDesc,  

dbo.CC_Demographic.MaidenName, 
dbo.CC_ReferralDate.MedicalOncologistRefDate, dbo.CC_ReferralDate.DurationMedicalOncologist AS MedicalOncologistWaitTime, 
dbo.CC_Demographic.MiddleName,

dbo.CC_ReferralDate.NutritionalRefDate as NutritionalTherapyReferralDate,
dbo.CC_ReferralDate.DurationNutritional as NutritionalTherapyWaitTime,

LU_CC_Morphology_O2.DisplayCode as MorphologyCode_O2, LU_CC_Morphology_O2.UserDescription as MorphologyCode_O2Desc, 
LU_CC_Morphology_O3.DisplayCode as MorphologyCode_O3, LU_CC_Morphology_O2.UserDescription as MorphologyCode_O3Desc, 
LU_MorphologyCodeVersion.DisplayCode as MorphologyCodeVersion, LU_MorphologyCodeVersion.UserDescription as MorphologyCodeVersionDesc, 

dbo.CC_ReferralDate.OccupationalRefDate as OccupationalTherapyReferralDate,
dbo.CC_ReferralDate.DurationOccupational as OccupationalTherapyWaitTime,

dbo.CC_ReferralDate.PalliativeRefDate,

LU_PathStageDiag.STAGE  as PathologicalStageAtDiagnosis,
dbo.CC_CancerStageDiag.PathStageDiag_M  as PathologicalStageAtDiagnosis_M, 
dbo.CC_CancerStageDiag.PathStageDiag_N  as PathologicalStageAtDiagnosis_N, 
LU_PathStageDiag_N_S.Displaycode AS PathologicalStageAtDiagnosis_N_Suffix, LU_PathStageDiag_N_S.UserDescription AS PathologicalStageAtDiagnosis_N_SuffixDesc, 
dbo.CC_CancerStageDiag.PathStageDiag_T  as PathologicalStageAtDiagnosis_T, 
LU_PathStageDiag_T_S.Displaycode AS PathologicalStageAtDiagnosis_T_Suffix, LU_PathStageDiag_T_S.UserDescription AS PathologicalStageAtDiagnosis_T_SuffixDesc, 

dbo.CC_Demographic.PostalCode, 
dbo.GetPostalDescription(isnull(dbo.CC_Demographic.PostalCode, ''''), isnull(dbo.CC_DiseaseRegister.RegisterDate, getdate())) AS PostalCodeDesc, -- ED - 01682

LU_PostTherapyStage.STAGE  as PostTherapyStage,
dbo.CC_CancerStageDiag.PostTherapyStage_M  as PostTherapyStage_M, 
dbo.CC_CancerStageDiag.PostTherapyStage_N  as PostTherapyStage_N, 
LU_PostTherapyStage_N_S.Displaycode AS PostTherapyStage_N_Suffix, LU_PostTherapyStage_N_S.UserDescription AS PostTherapyStage_N_SuffixDesc, 
dbo.CC_CancerStageDiag.PostTherapyStage_T  as PostTherapyStage_T, 
LU_PostTherapyStage_T_S.Displaycode AS PostTherapyStage_T_Suffix, LU_PostTherapyStage_T_S.UserDescription AS PostTherapyStage_T_SuffixDesc, 

LU_Province.DisplayCode as ProvinceNumber, LU_Province.UserDescription as ProvinceNumberDesc, 

LU_PhysicianCompletedForm.DisplayCode as PhysicianCompletedForm, LU_PhysicianCompletedForm.UserDescription as PhysicianCompletedFormDesc, 

dbo.CC_ReferralDate.PhysiotherapyRefDate as PhysiotherapyReferralDate,
dbo.CC_ReferralDate.DurationPhysiotherapy as PhysiotherapyWaitTime,
dbo.CC_ReferralDate.PsychiatryRefDate as PsychiatryReferralDate,
dbo.CC_ReferralDate.DurationPsychiatry as PsychiatryWaitTime,
dbo.CC_ReferralDate.PsychologyRefDate as PsychologyReferralDate,
dbo.CC_ReferralDate.DurationPsychology as PsychologyWaitTime,

dbo.CC_ReferralDate.RadiationOncologistRefDate, dbo.CC_ReferralDate.DurationRadiationOncologist AS RadiationOncologistWaitTime, 
dbo.CC_DiseaseRegister.RegisterDate as RegistrationDate, 
LU_ReportingMonth.DisplayCode as ReportingMonth, LU_ReportingMonth.UserDescription as ReportingMonthDesc, 

LU_ResidenceCode.DisplayCode as ResidenceCode, LU_ResidenceCode.UserDescription as ResidenceCodeDesc, 
LU_RespPayment.DisplayCode as ResponsiblityForPayment, LU_RespPayment.UserDescription as ResponsiblityForPaymentDesc, 

dbo.CC_ReferralDate.SocialWorkCareRefDate as SocialWorkCareReferralDate,
dbo.CC_ReferralDate.DurationSocialWorkCare as SocialWorkCareWaitTime,

LU_SourceOfInfo.DisplayCode as SourceOfInfo, LU_SourceOfInfo.UserDescription as SourceOfInfoDesc, 

dbo.CC_ReferralDate.SpeechRefDate as SpeechLanguagePathologyReferralDate,
dbo.CC_ReferralDate.DurationSpeech as SpeechLanguagePathologyWaitTime,

LU_StagingComplete.DisplayCode as StagingComplete, LU_StagingComplete.UserDescription as StagingCompleteDesc, 

LU_STAGEABLE.STAGEABLE as StagingRequired, 
LU_StagingVersion.DisplayCode as StagingVersion, LU_StagingVersion.UserDescription as StagingVersionDesc, 
dbo.CC_ReferralDate.SupportCareRefDate, dbo.CC_ReferralDate.DurationSupportCare AS SupportCareWaitTime, 
dbo.CC_ReferralDate.SurgicalOncologistRefDate, dbo.CC_ReferralDate.DurationSurgicalOncologist AS SurgicalOncologistWaitTime,


LU_CC_Topography.DisplayCode as TopographyCode, LU_CC_Topography.UserDescription as TopographyCodeDesc, 
UniversalEpisodeIdentifier,
dbo.CC_Demographic.AbstractID as zzAbstractLink, dbo.CC_Demographic.LinkID as zzLinkID

FROM         
dbo.CC_Demographic with (nolock) LEFT OUTER JOIN
LU_Province with (nolock) ON dbo.CC_Demographic.ProvinceNumber = LU_Province.Code  LEFT OUTER JOIN
H_HospitalProfile with (nolock) ON dbo.CC_Demographic.HospitalID = H_HospitalProfile.Code  LEFT OUTER JOIN
H_InstitutionProfile with (nolock) ON dbo.CC_Demographic.InstitutionNumber = H_InstitutionProfile.Code  LEFT OUTER JOIN
LU_Gender_I with (nolock) ON dbo.CC_Demographic.Gender = LU_Gender_I.Code  LEFT OUTER JOIN
LU_ResidenceCode with (nolock) ON dbo.CC_Demographic.ResidenceCode = LU_ResidenceCode.Code  LEFT OUTER JOIN
LU_YesNoSystem LU_DeathIndicator with (nolock) ON dbo.CC_Demographic.DeathIndicator = LU_DeathIndicator.Code  LEFT OUTER JOIN
LU_HCNProvince with (nolock) ON dbo.CC_Demographic.HCNProvince = LU_HCNProvince.Code  LEFT OUTER JOIN
LU_RespPayment with (nolock) ON dbo.CC_Demographic.ResponsiblePayment = LU_RespPayment.Code  LEFT OUTER JOIN

dbo.CC_DiseaseRegister with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_DiseaseRegister.AbstractID LEFT OUTER JOIN
dbo.U_Users LU_DataEntryCoderNumber with (nolock) ON dbo.CC_DiseaseRegister.CoderNumber = LU_DataEntryCoderNumber.Code  LEFT OUTER JOIN
LU_Institution_10 LU_DiagnosisHospitalNumber with (nolock) ON dbo.CC_DiseaseRegister.DiagHospitalNum = LU_DiagnosisHospitalNumber.Code  LEFT OUTER JOIN
LU_AgeCode LU_InitialDiagnosisAgeCode with (nolock) ON dbo.CC_DiseaseRegister.DiagAgeCode = LU_InitialDiagnosisAgeCode.Code  LEFT OUTER JOIN
LU_CodeFile LU_BasisOfDiagnosis with (nolock) ON dbo.CC_DiseaseRegister.BasisDiag = LU_BasisOfDiagnosis.Code  LEFT OUTER JOIN
LU_YesNoAlpha LU_FirstSurgicalTreatFlag with (nolock) ON dbo.CC_DiseaseRegister.FirstSurgTreatFlag = LU_FirstSurgicalTreatFlag.Code  LEFT OUTER JOIN
ICD_DiagFile10 LU_DiagnosisCode with (nolock) ON dbo.CC_DiseaseRegister.DiagnosisCode = LU_DiagnosisCode.Code  LEFT OUTER JOIN
LU_CC_Topography with (nolock) ON dbo.CC_DiseaseRegister.TopographyCode = LU_CC_Topography.Code  LEFT OUTER JOIN
LU_CodeFile LU_MorphologyCodeVersion with (nolock) ON dbo.CC_DiseaseRegister.TopoMorphVersion = LU_MorphologyCodeVersion.Code  LEFT OUTER JOIN
LU_CC_Morphology_O2 with (nolock) ON dbo.CC_DiseaseRegister.MorphologyCodeO2 = LU_CC_Morphology_O2.Code  LEFT OUTER JOIN
LU_CC_Morphology_O3 with (nolock) ON dbo.CC_DiseaseRegister.MorphologyCodeO3 = LU_CC_Morphology_O3.Code  LEFT OUTER JOIN
--PR - 03587
dbo.LU_CodeFile LU_AnalyticFlag with (nolock) ON dbo.CC_DiseaseRegister.AnalyticFlag = LU_AnalyticFlag.Code  LEFT OUTER JOIN

dbo.CC_CancerStageDiag with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_CancerStageDiag.AbstractID LEFT OUTER JOIN
LU_CodeFile LU_StagingVersion with (nolock) ON dbo.CC_CancerStageDiag.StagingVersion = LU_StagingVersion.Code  LEFT OUTER JOIN
LU_CodeFile LU_Laterality with (nolock) ON dbo.CC_CancerStageDiag.Laterality = LU_Laterality.Code  LEFT OUTER JOIN


dbo.CC_ReferralDate with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_ReferralDate.AbstractID LEFT OUTER JOIN
dbo.CC_RecordInfo with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_RecordInfo.AbstractID LEFT OUTER JOIN
dbo.LU_AbstractStatus LU_IsValidated with (nolock) ON dbo.CC_RecordInfo.IsValidated = LU_IsValidated.Code LEFT OUTER JOIN
dbo.LU_AbstractStatus LU_IsCompleted with (nolock) ON dbo.CC_RecordInfo.IsCompleted = LU_IsCompleted.Code LEFT OUTER JOIN
dbo.LU_YesNoAlpha LU_CompleteRecord with (nolock) ON  dbo.CC_RecordInfo.CompleteRecord = LU_CompleteRecord.Code LEFT OUTER JOIN
dbo.LU_YesNoSystem LU_IsSubmited with (nolock) ON dbo.CC_RecordInfo.IsSubmited = LU_IsSubmited.Code LEFT OUTER JOIN
dbo.U_Users LU_FileRunBy with (nolock) ON dbo.CC_RecordInfo.CCRegFileCoder = LU_FileRunBy.Code LEFT OUTER JOIN
dbo.LU_DeleteStatus LU_IsDeleted with (nolock) ON dbo.CC_RecordInfo.IsDeleted = LU_IsDeleted.Code  LEFT OUTER JOIN
dbo.LU_CIHICorrect with (nolock) ON dbo.CC_RecordInfo.IsCorrected = LU_CIHICorrect.Code  LEFT OUTER JOIN

dbo.CC_CollaborateStageDiag with (nolock) ON dbo.CC_Demographic.AbstractID = dbo.CC_CollaborateStageDiag.AbstractID LEFT OUTER JOIN
LU_CodeFile LU_CSLymphNodes with (nolock) ON dbo.CC_CollaborateStageDiag.LymphNodes = LU_CSLymphNodes.Code  LEFT OUTER JOIN
LU_CodeFile LU_CSRegionalNodesEvaluation with (nolock) ON dbo.CC_CollaborateStageDiag.RegionNodeEval = LU_CSRegionalNodesEvaluation.Code  LEFT OUTER JOIN
LU_CodeFile LU_CSRegionalNodesPositive with (nolock) ON dbo.CC_CollaborateStageDiag.RegionNodePositive = LU_CSRegionalNodesPositive.Code  LEFT OUTER JOIN

dbo.LLU_CC_STAGE_VALUE LU_ClinStageDiag with (nolock) ON dbo.CC_CancerStageDiag.ClinStageDiag = LU_ClinStageDiag.Code LEFT OUTER JOIN
dbo.LLU_CC_STAGE_VALUE LU_PathStageDiag with (nolock) ON dbo.CC_CancerStageDiag.PathStageDiag = LU_PathStageDiag.Code LEFT OUTER JOIN
dbo.LLU_CC_SITE_GROUP LU_STAGEABLE with (nolock) ON LU_DiagnosisCode.CIHIValue = LU_STAGEABLE.ICD10CA LEFT OUTER JOIN
dbo.LU_AppIDs LU_Application with (nolock) ON dbo.CC_Demographic.AppID = LU_Application.Code LEFT OUTER JOIN
dbo.LU_BatchPeriod LU_ReportingMonth with (nolock) ON dbo.CC_DiseaseRegister.ReportingMonth = LU_ReportingMonth.Code LEFT OUTER JOIN
dbo.LU_CodeFile LU_StagingComplete with (nolock) ON dbo.CC_CancerStageDiag.StagingComplete = LU_StagingComplete.Code LEFT OUTER JOIN
dbo.LU_CodeFile LU_SourceOfInfo with (nolock) ON dbo.CC_CancerStageDiag.SourceOfInfo = LU_SourceOfInfo.Code LEFT OUTER JOIN
dbo.LU_Provider LU_PhysicianCompletedForm with (nolock) ON dbo.CC_CancerStageDiag.PhysicianCompletedForm = LU_PhysicianCompletedForm.Code LEFT OUTER JOIN
dbo.CC_DischargeInfo with (nolock) ON dbo.CC_DischargeInfo.AbstractID = dbo.CC_Demographic.AbstractID LEFT OUTER JOIN 
dbo.LU_DispositionCode_I LU_DispositionCode with (nolock) ON dbo.CC_DischargeInfo.DispositionCode = LU_DispositionCode.Code LEFT OUTER JOIN
dbo.LU_AgeCode LU_DischargeAgeCode with (nolock) ON dbo.CC_DischargeInfo.DischargeAgeCode = LU_DischargeAgeCode.Code LEFT OUTER JOIN
    --2.x-1503
    dbo.LU_CodeFile LU_ClinStageDiag_T_S with (nolock) ON dbo.CC_CancerStageDiag.ClinStageDiag_T_S = LU_ClinStageDiag_T_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_ClinStageDiag_N_S with (nolock) ON dbo.CC_CancerStageDiag.ClinStageDiag_N_S = LU_ClinStageDiag_N_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PathStageDiag_T_S with (nolock) ON dbo.CC_CancerStageDiag.PathStageDiag_T_S = LU_PathStageDiag_T_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PathStageDiag_N_S with (nolock) ON dbo.CC_CancerStageDiag.PathStageDiag_N_S = LU_PathStageDiag_N_S.Code LEFT OUTER JOIN
    dbo.LLU_CC_STAGE_VALUE LU_PostTherapyStage with (nolock) ON dbo.CC_CancerStageDiag.PostTherapyStage = LU_PostTherapyStage.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PostTherapyStage_T_S with (nolock) ON dbo.CC_CancerStageDiag.PostTherapyStage_T_S = LU_PostTherapyStage_T_S.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PostTherapyStage_N_S with (nolock) ON dbo.CC_CancerStageDiag.PostTherapyStage_N_S = LU_PostTherapyStage_N_S.Code 


/*
LU_CodeFile LU_ on dbo.CC_Demographic. = LU_.Code  LEFT OUTER JOIN
LU_CodeFile LU_ on dbo.CC_Demographic. = LU_.Code  LEFT OUTER JOIN
LU_CodeFile LU_ on dbo.CC_Demographic. = LU_.Code  LEFT OUTER JOIN
LU_CodeFile LU_ on dbo.CC_Demographic. = LU_.Code  LEFT OUTER JOIN
LU_CodeFile LU_ on dbo.CC_Demographic. = LU_.Code  LEFT OUTER JOIN
*/
--QA - 00032 disable the domain securite issue
----PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CC_Demographic.HospitalID is null or CC_Demographic.HospitalID = 0
--    --EN - 00666
--    or Is_Member(nullif(ReportGroup, '''')) = 1
----    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CC_Demographic.HospitalID, 0))



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Alerts_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'




CREATE  VIEW [dbo].[Central_Patient_Alerts_VR]
AS
SELECT     
AlertAllergyCode       = Lookup1.DisplayCode, 
AlertAllergyCodeDesc   = Lookup1.UserDescription, 
AlertAllergyNote       = dbo.CM_Alert.AlertNote, 
AlertAllergyOccurance  = dbo.CM_Alert.AlertOccurrence, 
zzPatientLink          = dbo.CM_Alert.PatientID
FROM      dbo.CM_Alert  with (nolock) 
LEFT JOIN dbo.LU_Alert Lookup1 with (nolock) ON dbo.CM_Alert.AlertCode = Lookup1.Code








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Alias_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[Central_Patient_Alias_VR]
AS
SELECT     
    AlternateFirstName      = FirstAlias, 
    AlternateLastName       = LastAlias, 
    AlternateMaidenName     = MaidenAlias, 
    AlternateMiddleName     = MiddleAlias, 
    AlternateNamesOccurance = AliasOccurrence, 
    zzPatientLink           = PatientID
FROM dbo.CM_Alias  with (nolock) 







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_BabyChart_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[Central_Patient_BabyChart_VR]
AS
SELECT     
BabyChartNumber    = REPLACE(SPACE(10 - LEN(BabyChartNumber)) + BabyChartNumber, '' '', ''0''), 
BabyChartOccurance = BabyChartOccurrence, 
zzPatientLink      = PatientID
FROM dbo.CM_BabyChart with (nolock)







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Contacts_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[Central_Patient_Contacts_VR]
AS
SELECT     dbo.CM_Address.Address1 AS CAddress1, dbo.CM_Address.Address2 AS CAddress2, dbo.CM_Address.CellPhone AS CCellPhone, 
                      dbo.CM_Address.City AS CCity, dbo.LU_CPI_Country.DisplayCode AS CCountry, dbo.LU_CPI_Country.UserDescription AS CCountryDesc, 
                      dbo.CM_Address.EMail AS CEMail, dbo.CM_Address.FaxNumber AS CFaxNumber, dbo.CM_Address.ContactName AS CName, 
                      dbo.CM_Address.Occurrence AS COccurrence, dbo.CM_Address.PhoneNumber1 AS CPhoneNumber1, 
                      dbo.CM_Address.PhoneNumber2 AS CPhoneNumber2, dbo.CM_Address.PostalCode AS CPostalCode, dbo.LU_CPI_Province.DisplayCode AS CProvince,
                       dbo.LU_CPI_Province.UserDescription AS CProvinceDesc, dbo.LU_Relationship.DisplayCode AS CRelationship, 
                      dbo.LU_Relationship.UserDescription AS CRelationshipDesc, dbo.LU_CodeFile.DisplayCode AS CType, 
                      dbo.LU_CodeFile.UserDescription AS CTypeDesc, dbo.CM_Address.PatientID AS zzPatientLink
FROM         dbo.CM_Address with (nolock) LEFT OUTER JOIN
    dbo.LU_Relationship with (nolock) ON dbo.CM_Address.Relationship = dbo.LU_Relationship.Code LEFT OUTER JOIN
    dbo.LU_CPI_Country with (nolock) ON dbo.CM_Address.Country = dbo.LU_CPI_Country.Code LEFT OUTER JOIN
    dbo.LU_CPI_Province with (nolock) ON dbo.CM_Address.Province = dbo.LU_CPI_Province.Code LEFT OUTER JOIN
    dbo.LU_CodeFile with (nolock) ON dbo.CM_Address.ContactType = dbo.LU_CodeFile.Code







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Index_Alias_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[Central_Patient_Index_Alias_VR]
AS
SELECT     AliasOccurrence, FirstAlias AS FirstNameAlias, LastAlias AS LastNameAlias, MaidenAlias AS MaidenNameAlias, MiddleAlias AS MiddleNameAlias, 
                      PatientID AS zzPatientLink
FROM         dbo.CM_Alias with (nolock) 






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Index_Notes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE view [dbo].[Central_Patient_Index_Notes_VR]
as
SELECT     
   RecordID AS zzPatientLink,
   LogNote  as CPINotes,
   LogDate  as DateLogged,
   LogTime  as TimeLogged,
   U.DisplayCode as CreateBy,
   U.UserDescription as CreatorName        
from dbo.REC_Notes r with (nolock) left join U_users U with (nolock) ON r.LogCoder=u.code
where AppID = 0



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_LinkedChart_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[Central_Patient_LinkedChart_VR]
AS
SELECT     dbo.CM_ChartLink.LinkChartNumber, dbo.CM_ChartLink.LinkChartOccurrence, dbo.LU_ChartLinkType.DisplayCode AS LinkChartType, 
                      dbo.LU_ChartLinkType.UserDescription AS LinkChartTypeDesc, dbo.CM_ChartLink.PatientID AS zzPatientLink
FROM         dbo.CM_ChartLink with (nolock) LEFT OUTER JOIN
                      dbo.LU_ChartLinkType with (nolock) on dbo.CM_ChartLink.LinkType = dbo.LU_ChartLinkType.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_MergeChart_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[Central_Patient_MergeChart_VR]
AS
SELECT     dbo.U_Users.DisplayCode AS CoderNumber, dbo.U_Users.UserDescription AS CoderNumberDesc, dbo.CM_CPI_Merge.DateMerged AS MergedDate, 
                      dbo.CM_CPI_Merge.ChartNumberTo AS NewChartNumber, dbo.CM_CPI_Merge.ChartNumberFrom AS OldChartNumber, 
                      dbo.CM_CPI_Merge.PatientIDTo AS zzNewPatientLink, dbo.CM_CPI_Merge.PatientIDFrom AS zzOldPatientLink
FROM         dbo.CM_CPI_Merge with (nolock) LEFT OUTER JOIN
                      dbo.U_Users with (nolock) on dbo.CM_CPI_Merge.CoderNumber = dbo.U_Users.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_RiskFactors_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[Central_Patient_RiskFactors_VR]
as
select
    RiskOccurrence = Occurrence,
    RiskFactor = LU_RiskFactor.DisplayCode, LU_RiskFactorDesc = LU_RiskFactor.UserDescription,
    Exposure = LU_Exposure.DisplayCode, ExposureDesc = LU_Exposure.UserDescription, 
    dbo.CM_RiskFactors.StartDate,
    AgeOfOnset = dbo.CM_RiskFactors.AgeAtOnset,
    dbo.CM_RiskFactors.EndDate,
    RiskNotes = dbo.CM_RiskFactors.Notes,
    zzPatientLink = PatientID
from dbo.CM_RiskFactors with (nolock) 
    left join lu_codefile LU_RiskFactor with (nolock) on dbo.CM_RiskFactors.RiskFactor = LU_RiskFactor.Code
    left join lu_codefile LU_Exposure with (nolock) on dbo.CM_RiskFactors.Exposure = LU_Exposure.Code


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[Central_Patient_UpdateHistory_VR]
AS
SELECT
    U_Users.DisplayCode as UpdateCoder,
    U_Users.UserDescription as UpdateCoderDesc, 
    CM_UpdateHistory.Updated as UpdateDate,  
    CM_UpdateHistory.UpdateType, 
    CM_UpdateHistory.PatientID AS zzPatientLink
FROM       CM_UpdateHistory with (nolock)  
    inner join U_Users with (nolock) On CM_UpdateHistory.Coder = U_Users.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Volume_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[Central_Patient_Volume_UpdateHistory_VR]
AS
SELECT     dbo.U_Users.DisplayCode AS UpdateCoder, dbo.U_Users.UserDescription AS UpdateCoderDescription, dbo.CM_Volume_UpdateHistory.Updated, 
                      dbo.CM_Volume_UpdateHistory.UpdateType, dbo.CM_Volume_UpdateHistory.VolumeID AS zzVolumeLink
FROM         dbo.CM_Volume_UpdateHistory with (nolock) LEFT OUTER JOIN
                      dbo.U_Users with (nolock) On dbo.CM_Volume_UpdateHistory.Coder = dbo.U_Users.Code


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Central_Patient_Volume_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[Central_Patient_Volume_VR]
AS
SELECT 
dbo.CM_CPI_Volume.CLBoxNumber AS BoxNumber, dbo.CM_CPI_Volume.CLComments AS Comments, 
--LU_YesNoSystem_4.DisplayCode AS ContainsAmcareData, LU_YesNoSystem_4.UserDescription AS ContainsAmcareDataDesc, 
(case dbo.CM_CPI_Volume.CLAmcare when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS ContainsAmcareData, 
(case dbo.CM_CPI_Volume.CLAmcare when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS ContainsAmcareDataDesc, 

--LU_YesNoSystem_1.DisplayCode AS ContainsInpatientData, LU_YesNoSystem_1.UserDescription AS ContainsInpatientDataDesc, 
(case dbo.CM_CPI_Volume.CLInpatient when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS ContainsInpatientData, 
(case dbo.CM_CPI_Volume.CLInpatient when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS ContainsInpatientDataDesc, 

--LU_YesNoSystem_11.DisplayCode AS ContainsMicrofilm, LU_YesNoSystem_11.UserDescription AS ContainsMicrofilmDesc, 
(case dbo.CM_CPI_Volume.CLMicroFilm when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS ContainsMicrofilm, 
(case dbo.CM_CPI_Volume.CLMicroFilm when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS ContainsMicrofilmDesc, 

LU_YesNoSystem_5.DisplayCode AS ContainsOptional1Data, LU_YesNoSystem_5.UserDescription AS ContainsOptional1DataDesc, 
LU_YesNoSystem_6.DisplayCode AS ContainsOptional2Data, LU_YesNoSystem_6.UserDescription AS ContainsOptional2DataDesc, 
LU_YesNoSystem_8.DisplayCode AS ContainsOptional3Data, LU_YesNoSystem_9.UserDescription AS ContainsOptional4DataDesc, 
LU_YesNoSystem_9.DisplayCode AS ContainsOptional4Data, LU_YesNoSystem_8.UserDescription AS ContainsOptional3DataDesc, 
--LU_YesNoSystem_3.DisplayCode AS ContainsOutpatientData, LU_YesNoSystem_3.UserDescription AS ContainsOutpatientDataDesc, 
(case dbo.CM_CPI_Volume.CLOutpatient when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS ContainsOutpatientData, 
(case dbo.CM_CPI_Volume.CLOutpatient when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS ContainsOutpatientDataDesc, 
--LU_YesNoSystem_2.DisplayCode AS ContainsSDSData, LU_YesNoSystem_2.UserDescription AS ContainsSDSDataDesc, 
(case dbo.CM_CPI_Volume.CLSDS when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS ContainsSDSData, 
(case dbo.CM_CPI_Volume.CLSDS when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS ContainsSDSDataDesc, 


LU_CurrLocation.DisplayCode AS CurrentLocation, LU_CurrLocation.UserDescription AS CurrentLocationDesc, 
LU_CurrLocationType.DisplayCode AS CurrentLocationType, LU_CurrLocationType.UserDescription AS CurrentLocationTypeDesc, 
--LU_CurrHealthDepartment.DisplayCode as CurrentLocInRecordDepartment, LU_CurrHealthDepartment.UserDescription as CurrentLocInRecordDeparDesc,
(case LU_CurrLocation.InHospital when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS CurrentLocInRecordDepartment, 
(case LU_CurrLocation.InHospital when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS CurrentLocInRecordDeparDesc, 

LoanLU_LocationType_1.DisplayCode AS CurrentTransactionType, LoanLU_LocationType_1.UserDescription AS CurrentTransactionTypeDesc, 

dbo.CM_CPI_Volume.DestructionDate,  --''2.x-1854
--TS-222
LU_DigitalIndicator.DisplayCode AS DigitallyAvailable, LU_DigitalIndicator.UserDescription AS DigitallyAvailableDesc, 


dbo.H_HospitalProfile.DisplayCode AS Hospital, dbo.H_HospitalProfile.UserDescription AS HospitalName, 
--LU_PrintLabel.DisplayCode AS LabelPrinted, LU_PrintLabel.UserDescription AS LabelPrintedDesc, 
(case dbo.CM_CPI_Volume.LabelPrinted when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS LabelPrinted, 
(case dbo.CM_CPI_Volume.LabelPrinted when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS LabelPrintedDesc, 

LU_LinkToVolume.VolumeNumber AS LinkedToVolume, 
dbo.CM_CPI_Volume.CLMircoFilmNum AS MicroFilmNumber, 

LU_PermLocation.DisplayCode AS PermLocation, LU_PermLocation.UserDescription AS PermLocationDesc, 
LU_PermLocationType.DisplayCode AS PermLocationType, LU_PermLocationType.UserDescription AS PermLocationTypeDesc, 
--LU_PermHealthDepartment.DisplayCode AS PermLocInRecordDepartment, LU_PermHealthDepartment.UserDescription AS PermLocInRecordDepartmentDesc, 
(case LU_PermLocation.InHospital when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS PermLocInRecordDepartment, 
(case LU_PermLocation.InHospital when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS PermLocInRecordDepartmentDesc, 


LU_PreviousLocation.DisplayCode AS PreviousLocation, LU_PreviousLocation.UserDescription AS PreviousLocationDesc, 
LU_PrevLocationType.DisplayCode AS PrevLocationType, LU_PrevLocationType.UserDescription AS PrevLocationTypeDesc, 

--LU_PrevHealthDepartment.DisplayCode AS PrevLocInRecordDepartment, LU_PrevHealthDepartment.UserDescription AS PrevLocInRecordDepartmentDesc,
(case LU_PreviousLocation.InHospital when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS PrevLocInRecordDepartment, 
(case LU_PreviousLocation.InHospital when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS PrevLocInRecordDepartmentDesc, 

--LU_YesNoSystem_10.DisplayCode AS SubVolume, LU_YesNoSystem_10.UserDescription AS SubVolumeDesc, 
(case dbo.CM_CPI_Volume.SubVolume when 1 then LU_Yes.DisplayCode when 2 then LU_No.DisplayCode end) AS SubVolume, 
(case dbo.CM_CPI_Volume.SubVolume when 1 then LU_Yes.UserDescription when 2 then LU_No.UserDescription end) AS SubVolumeDesc, 

dbo.CM_CPI_Volume.VolumeDateFrom, 
dbo.CM_CPI_Volume.VolumenDateTo AS VolumeDateTo, dbo.CM_CPI_Volume.VolumeNumber, LU_VolumeType.DisplayCode AS VolumeType, 
LU_VolumeType.UserDescription AS VolumeTypeDesc, dbo.CM_CPI_Volume.BarCodeVolume AS UniqueBarCodeVolume, 
dbo.CM_CPI_Volume.CLActivityID AS zzCLLink, dbo.CM_CPI_Volume.PatientID AS zzPatientLink, dbo.CM_CPI_Volume.VolumeID AS zzVolumeLink, 
dbo.CM_CPI_Volume.UniversalID AS zzLatestVH_UniversalLink
FROM         
dbo.CM_CPI_Volume with (nolock) LEFT OUTER JOIN
dbo.LoanLU_Type LoanLU_LocationType_1 with (nolock) ON LoanLU_LocationType_1.Code = dbo.CM_CPI_Volume.ActivityType LEFT OUTER JOIN
dbo.LoanLU_VolumeType LU_VolumeType with (nolock) ON dbo.CM_CPI_Volume.VolumeType = LU_VolumeType.Code LEFT OUTER JOIN
dbo.CM_CPI_Volume LU_LinkToVolume with (nolock) ON dbo.CM_CPI_Volume.CLLinkedVolume = LU_LinkToVolume.VolumeID LEFT OUTER JOIN
dbo.H_HospitalProfile with (nolock) ON dbo.CM_CPI_Volume.HospitalID = dbo.H_HospitalProfile.Code LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_PrintLabel with (nolock) ON dbo.CM_CPI_Volume.LabelPrinted = LU_PrintLabel.Code LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_YesNoSystem_10 with (nolock) ON dbo.CM_CPI_Volume.SubVolume = LU_YesNoSystem_10.Code LEFT OUTER JOIN

dbo.LU_CodeFile LU_YesNoSystem_9 with (nolock) ON dbo.CM_CPI_Volume.CLOption4 = LU_YesNoSystem_9.Code LEFT OUTER JOIN
dbo.LU_CodeFile LU_YesNoSystem_8 with (nolock) ON dbo.CM_CPI_Volume.CLOption3 = LU_YesNoSystem_8.Code LEFT OUTER JOIN
dbo.LU_CodeFile LU_YesNoSystem_6 with (nolock) ON dbo.CM_CPI_Volume.CLOption2 = LU_YesNoSystem_6.Code LEFT OUTER JOIN
dbo.LU_CodeFile LU_YesNoSystem_5 with (nolock) ON dbo.CM_CPI_Volume.CLOption1 = LU_YesNoSystem_5.Code LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_YesNoSystem_4 with (nolock) ON dbo.CM_CPI_Volume.CLAmcare = LU_YesNoSystem_4.Code LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_YesNoSystem_3 with (nolock) ON dbo.CM_CPI_Volume.CLOutpatient = LU_YesNoSystem_3.Code LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_YesNoSystem_2 with (nolock) ON dbo.CM_CPI_Volume.CLSDS = LU_YesNoSystem_2.Code LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_YesNoSystem_1 with (nolock) ON LU_YesNoSystem_1.Code = dbo.CM_CPI_Volume.CLInpatient LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_YesNoSystem_11 with (nolock) ON LU_YesNoSystem_11.Code = dbo.CM_CPI_Volume.CLMicroFilm LEFT OUTER JOIN

dbo.LoanLU_Location LU_PermLocation with (nolock) ON dbo.CM_CPI_Volume.PermLocation = LU_PermLocation.Code LEFT OUTER JOIN
dbo.LoanLU_LocationType LU_PermLocationType  with (nolock) ON LU_PermLocationType.Code = LU_PermLocation.LocationType LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_PermHealthDepartment with (nolock) ON LU_PermLocation.InHospital = LU_PermHealthDepartment.Code LEFT OUTER JOIN

dbo.LoanLU_Location LU_CurrLocation with (nolock) ON dbo.CM_CPI_Volume.CLCurrentLocation = LU_CurrLocation.Code LEFT OUTER JOIN
dbo.LoanLU_LocationType LU_CurrLocationType with (nolock) ON LU_CurrLocationType.Code = LU_CurrLocation.LocationType LEFT OUTER JOIN
--dbo.LU_YesNoSystem LU_CurrHealthDepartment with (nolock) ON LU_CurrLocation.InHospital = LU_CurrHealthDepartment.Code LEFT OUTER JOIN

dbo.LoanLU_Location LU_PreviousLocation with (nolock) ON dbo.CM_CPI_Volume.CLPreviousLocation = LU_PreviousLocation.Code LEFT OUTER JOIN
dbo.LoanLU_LocationType LU_PrevLocationType with (nolock) ON LU_PrevLocationType.Code = LU_PreviousLocation.LocationType LEFT OUTER JOIN
-- dbo.LU_YesNoSystem LU_PrevHealthDepartment with (nolock) ON LU_PreviousLocation.InHospital = LU_PrevHealthDepartment.Code 
--TS-222
dbo.LoanLU_DigitalIndicator LU_DigitalIndicator with (nolock) ON dbo.CM_CPI_Volume.DigitalIndicator = LU_DigitalIndicator.Code --LEFT OUTER JOIN

cross join (select DisplayCode, UserDescription from LU_YesNoSystem where code = 1) LU_Yes
Cross join (select DisplayCode, UserDescription from LU_YesNoSystem where code = 2) LU_No
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_Current_Transfer_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[Chart_Deficiency_Current_Transfer_VR]
AS
SELECT     T.DefNewStartDate AS DeficiencyNewStartDate, T.DefStartDate AS DeficiencyOldStartDate, T.DefeciencyID AS HeaderReferenceIDNumber, 
                      T.NewDetailID AS NewDeficiencyDetailID, F.DisplayCode AS TransferFirstCoder, F.UserDescription AS TransferFirstCoderName, 
                      T.DefTransferDate AS TransferFirstDate, C.DisplayCode AS TransferLatestCoder, C.UserDescription AS TransferLatestCoderName, 
                      T.DefTransferStatusDate AS TransferLatestDate, DF.DisplayCode AS TransferProviderFrom, DF.UserDescription AS TransferProviderFromName, 
                      DT.DisplayCode AS TransferProviderTo, DT.UserDescription AS TransferProviderToName, S.DisplayCode AS TransferStatus, 
                      S.UserDescription AS TransferStatusDesc, T.DefID AS zzDefLink
FROM         dbo.Def_Transfer T with (nolock) INNER JOIN
                      dbo.DefLU_TransferStatus S with (nolock) ON T.DefTransferStatus = S.Code LEFT OUTER JOIN
                      dbo.U_Users C with (nolock) ON T.DefTransferStatusCoder = C.Code LEFT OUTER JOIN
                      dbo.U_Users F with (nolock) ON T.DefTransferCoder = F.Code INNER JOIN
                      dbo.LU_Provider DF with (nolock) ON T.DefDrNumberFrom = DF.Code INNER JOIN
                      dbo.LU_Provider DT ON T.DefDrNumberTo = DT.Code INNER JOIN
                          (SELECT     MAX(DefTransferID) MaxID, DefeciencyID
                            FROM          Def_Transfer MT with (nolock) INNER JOIN
                                                   DefLU_TransferStatus MS with (nolock) On MT.DefTransferStatus = MS.Code
                            WHERE      MS.DisplayCode NOT IN (''U'', ''T'')
                            GROUP BY DefeciencyID) M ON M.MaxID = T.DefTransferID

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_Transfer_History_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE     VIEW [dbo].[Chart_Deficiency_Transfer_History_VR]
AS
SELECT     
    T.DefNewStartDate AS DeficiencyNewStartDate, T.DefeciencyID AS DetailReferenceIDFrom, 
    T.NewDetailID AS DetailReferenceIDTo, 
    cast(T.DefeciencyID / 100 as varchar(10)) + ''00'' AS HeaderReferenceIDFrom, 
    cast(T.NewDetailID / 100 as varchar(10)) + ''00'' AS HeaderReferenceIDTo, 
    TC.DisplayCode AS TransferCoder, 
    TC.UserDescription AS TransferCoderName, TS.DisplayCode AS TransferCurrentStatus, TS.UserDescription AS TransferCurrentStatusDesc, 
    H.DefTransferStatusDate AS TransferDate, LS.DisplayCode AS TransferLastStatus, LS.UserDescription AS TransferLastStatusDesc, 
    DF.DisplayCode AS TransferProviderFrom, DF.UserDescription AS TransferProviderFromName, DT.DisplayCode AS TransferProviderTo, 
    DT.UserDescription AS TransferProviderToName, dbo.Def_SlipMain.DefAbstractID AS zzUniversalLink, 
    Def_SlipMain.DefID as zzDefLink
FROM 
    dbo.Def_SlipMain with (nolock) INNER JOIN
    dbo.Def_Transfer AS T with (nolock) ON dbo.Def_SlipMain.DefID = T.DefID INNER JOIN --dbo.Def_SlipMain.DefeciencyID = LEFT(T.NewDetailID, 6) + ''00''
    dbo.LU_Provider AS DF with (nolock) ON DF.Code = T.DefDrNumberFrom INNER JOIN
    dbo.LU_Provider AS DT with (nolock) ON T.DefDrNumberTo = DT.Code INNER JOIN
    dbo.Def_Transfer_History AS H with (nolock) ON H.DefTransferID = T.DefTransferID LEFT OUTER JOIN
    dbo.DefLU_TransferStatus AS TS with (nolock) ON TS.Code = H.DefTransferCurrStatus left OUTER JOIN
    dbo.U_Users AS TC with (nolock) ON H.DefTransferStatusCoder = TC.Code LEFT OUTER JOIN
    dbo.DefLU_TransferStatus AS LS with (nolock) ON H.DefTransferLastStatus = LS.Code 
    --inner join dbo.CheckLogin() login 
    --    ON login.HospitalID in (0, isnull(dbo.Def_SlipMain.HospitalID, login.HospitalID))  
    --        or isnull(dbo.Def_SlipMain.HospitalID, 0) in (0, login.HospitalID)


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[Chart_Deficiency_UpdateHistory_VR]
AS
SELECT     
	dbo.Def_UpdateHistory.DefeciencyID AS HeaderReferenceIDNumber, 
	dbo.U_Users.DisplayCode AS UpdateCoder, dbo.U_Users.UserDescription AS UpdateCoderDesc, 
	U_Users_1.DisplayCode AS UpdateCoderHospital, U_Users_1.UserDescription AS UpdateCoderHospitalDesc, 
	dbo.Def_UpdateHistory.Updated AS UpdateDate, 
	dbo.Def_UpdateHistory.UpdateType, 
    dbo.Def_UpdateHistory.DefID AS zzDefLink
FROM         dbo.Def_UpdateHistory with (nolock) LEFT OUTER JOIN
                      dbo.H_HospitalProfile U_Users_1 with (nolock) On dbo.Def_UpdateHistory.HospitalID = U_Users_1.Code LEFT OUTER JOIN
                      dbo.U_Users with (nolock) On dbo.Def_UpdateHistory.Coder = dbo.U_Users.Code
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_Deficiency_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE    VIEW [dbo].[Chart_Deficiency_VR]
AS
SELECT 
    dbo.AB_Main.AdmitDate, dbo.AB_Main.AdmitTime, dbo.Def_SlipMain.DefBirthDate AS BirthDate, LU_CareType.DisplayCode AS CareType, 
    LU_CareType.UserDescription AS CareTypeDesc, dbo.Central_Patient_Index_VR.ChartNumber, Lookup1.DisplayCode AS ColourCode, 
    Lookup1.UserDescription AS ColourCodeDesc, Lookup2.DisplayCode AS CompletedBy, Lookup2.UserDescription AS CompletedByDesc, 
    Lookup3.DisplayCode AS DeficiencyCode, Lookup3.UserDescription AS DeficiencyCodeDesc, Lookup4.DisplayCode AS DeficiencyCodeType, 
    Lookup4.UserDescription AS DeficiencyCodeTypeDesc, dbo.Def_SlipMain.DefDays AS DeficiencyDays, 
    dbo.Def_Activity.DefDays AS DeficiencyDetailDays, dbo.Def_Activity.DefEndDate AS DeficiencyDetailEndDate, 
    dbo.Def_Activity.DefStartDate AS DeficiencyDetailStartDate, dbo.Def_SlipMain.DefEndDate AS DeficiencyEndDate, 
    dbo.Def_Activity.DefOccurrence AS DeficiencyOccurrence, dbo.Def_SlipMain.DefStartDate AS DeficiencyStartDate, 
    dbo.Def_SlipMain.DefTotalDays as DeficiencyTotalDays,
    dbo.Def_Activity.DefNote AS DetailComments, dbo.Def_Activity.JobNumber AS DetailJobNumber, 
    dbo.Def_Activity.DefeciencyID AS DetailReferenceIDNumber, Lookup5.DisplayCode AS DetailStatus, Lookup5.UserDescription AS DetailStatusDesc, 
    dbo.AB_Main.DischargeDate, dbo.AB_Main.DischargeTime, dbo.AB_Main.EncounterNumber, dbo.AB_Main.EncounterSequence, 
    dbo.Def_SlipMain.DefMainNote AS HeaderNotes, dbo.Def_SlipMain.DefeciencyID AS HeaderReferenceIDNumber, 
    Lookup6.DisplayCode AS HeaderStatus, Lookup6.UserDescription AS HeaderStatusDesc, dbo.Def_SlipMain.DefHoldDays AS HoldDays, 
    dbo.Def_SlipMain.DefHoldEndDate AS HoldEndDate, dbo.Def_SlipMain.DefHoldStartDate AS HoldStartDate, 
    isnull(LU_Hospital.DisplayCode, '''') AS Hospital, 
    isnull(LU_Hospital.UserDescription, '''') AS HospitalDesc, 
    Lookup7.DisplayCode AS InstitutionNumber, Lookup7.UserDescription AS InstitutionNumberDesc, 
    dbo.Def_SlipMain.DefManualDays AS ManualDays, Lookup8.DisplayCode AS MessageBox, Lookup8.UserDescription AS MessageBoxDesc, 
    dbo.Def_SlipMain.DefPatFirstName AS PatientFirstName, dbo.Def_SlipMain.DefPatLastName AS PatientLastName, 
    Lookup9.ProvdrAddress AS ProviderAddress, Lookup9.ProvdrCity AS ProviderCity, Lookup9.ProvdrCredentials AS ProviderCredentials, 
    Lookup9.ProvdrEMail AS ProviderEmail, Lookup9.ProvdrFax AS ProviderFAX, LUProviderLanguage.DisplayCode AS ProviderLanguage, 
    Lookup9.DisplayCode AS ProviderNumber, Lookup9.UserDescription AS ProviderNumberDesc, Lookup9.ProvdrCellPhone AS ProviderPhoneCell, 
    Lookup9.ProvdrHomePhone AS ProviderPhoneHome, Lookup9.ProvdrHospitalPhone AS ProviderPhoneHospital, 
    Lookup9.ProvdrOfficePhone AS ProviderPhoneOffice, Lookup9.ProvdrPostal AS ProviderPostalCode, Lookup9.ProvdrProvince AS ProviderProvince, 
    dbo.LU_ProviderService.DisplayCode AS ProviderService, dbo.LU_ProviderService.UserDescription AS ProviderServiceDesc, 
    dbo.LU_ProviderSpecialty.DisplayCode AS ProviderSpecialty, dbo.LU_ProviderSpecialty.UserDescription AS ProviderSpecialtyDesc, 
    dbo.Def_SlipMain.DefDrStatus AS ProviderStatus, Lookup9.ProvdrTitle AS ProviderTitle, Lookup10.DisplayCode AS Resident, 
    Lookup10.UserDescription AS ResidentDesc, Lookup11.DisplayCode AS SiteNumber, Lookup11.UserDescription AS SiteNumberDesc, 
    dbo.Def_SlipMain.DefSuspensionDays AS SuspensionDays, dbo.Def_SlipMain.DefVacationDays AS VacationDays, 
    dbo.CM_CPI_Volume.VolumeNumber, dbo.Central_Patient_Index_VR.AlternateAddress, dbo.Central_Patient_Index_VR.AlternatePhoneNumber, 
    dbo.Central_Patient_Index_VR.CPINotes, dbo.Central_Patient_Index_VR.DatePatientDied, dbo.Central_Patient_Index_VR.DuplicateChart, 
    dbo.Central_Patient_Index_VR.Education, dbo.Central_Patient_Index_VR.EducationDesc, dbo.Central_Patient_Index_VR.EmployerAddress, 
    dbo.Central_Patient_Index_VR.EmployerName, dbo.Central_Patient_Index_VR.EmployerPhoneNumber, 
    dbo.Central_Patient_Index_VR.FamilyPhysicianAddress, dbo.Central_Patient_Index_VR.FamilyPhysicianName, 
    dbo.Central_Patient_Index_VR.FamilyPhysicianPhoneNumber, dbo.Central_Patient_Index_VR.FirstName, dbo.Central_Patient_Index_VR.Gender, 
    dbo.Central_Patient_Index_VR.GenderDesc, dbo.Central_Patient_Index_VR.HCNProvince, dbo.Central_Patient_Index_VR.HCNProvinceDesc, 
    dbo.Central_Patient_Index_VR.HCNVersion, dbo.Central_Patient_Index_VR.HealthCareNumber, dbo.Central_Patient_Index_VR.InEmergencyAddress, 
    dbo.Central_Patient_Index_VR.InEmergencyName, dbo.Central_Patient_Index_VR.InEmergencyPhoneNumber, 
    dbo.Central_Patient_Index_VR.InEmergencyRelationship, dbo.Central_Patient_Index_VR.InEmergencyRelationshipDesc, 
    dbo.Central_Patient_Index_VR.InsuranceCompany1, dbo.Central_Patient_Index_VR.InsuranceCompany2, 
    dbo.Central_Patient_Index_VR.InsurancePolicy1, dbo.Central_Patient_Index_VR.InsurancePolicy2, 
    dbo.Central_Patient_Index_VR.IsBirthdateEstimated, dbo.Central_Patient_Index_VR.IsBirthdateEstimatedDesc, 
    dbo.Central_Patient_Index_VR.[Language], dbo.Central_Patient_Index_VR.LanguageDesc, dbo.Central_Patient_Index_VR.LastName, 
    dbo.Central_Patient_Index_VR.LivingArrangement, dbo.Central_Patient_Index_VR.LivingArrangementDesc, 
    dbo.Central_Patient_Index_VR.MaidenName, dbo.Central_Patient_Index_VR.MaritalStatus, dbo.Central_Patient_Index_VR.MaritalStatusDesc, 
    dbo.Central_Patient_Index_VR.MiddleName, dbo.Central_Patient_Index_VR.MothersChart, dbo.Central_Patient_Index_VR.NextofKinAddress, 
    dbo.Central_Patient_Index_VR.NextofKinName, dbo.Central_Patient_Index_VR.NextofKinPhoneNumber, 
    dbo.Central_Patient_Index_VR.NextofKinRelationship, dbo.Central_Patient_Index_VR.NextofKinRelationshipDesc, 
    dbo.Central_Patient_Index_VR.Occupation, dbo.Central_Patient_Index_VR.OccupationDesc, dbo.Central_Patient_Index_VR.PlaceofBirth, 
    dbo.Central_Patient_Index_VR.PostalCode, dbo.Central_Patient_Index_VR.PrimaryAddress, dbo.Central_Patient_Index_VR.PrimaryPhoneNumber, 
    dbo.Central_Patient_Index_VR.ResidenceCode, dbo.Central_Patient_Index_VR.ResidenceCodeDesc, dbo.Central_Patient_Index_VR.ResidenceType, 
    dbo.Central_Patient_Index_VR.ResidenceTypeDesc, dbo.Central_Patient_Index_VR.SecretVIPPatient, 
    dbo.Central_Patient_Index_VR.SecretVIPPatientDesc, dbo.Central_Patient_Index_VR.SocialInsuranceNumber, 
    (Case when AB_Main.AppType in (1, 2) then DischargeDate else AdmitDate end) as VisitDate,
    dbo.Central_Patient_Index_VR.zzPatientLink, dbo.Def_SlipMain.DefAbstractID AS zzUniversalLink, dbo.AB_Main.AbstractID AS zzAbstractLink, 
    dbo.Def_SlipMain.DefVolumeID AS zzVolumeLink, dbo.Def_SlipMain.DefID AS zzDefLink
FROM dbo.Def_SlipMain with (nolock)  LEFT OUTER JOIN
    dbo.Def_Activity with (nolock) ON dbo.Def_SlipMain.DefID = dbo.Def_Activity.DefID LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty with (nolock) ON dbo.Def_SlipMain.ProviderSpecialty = dbo.LU_ProviderSpecialty.Code LEFT OUTER JOIN
    dbo.LU_ProviderService with (nolock) ON dbo.Def_SlipMain.ProviderService = dbo.LU_ProviderService.Code LEFT OUTER JOIN
    
    dbo.H_HospitalProfile LU_Hospital with (nolock) ON dbo.Def_SlipMain.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.Central_Patient_Index_VR with (nolock) ON dbo.Def_SlipMain.DefPatientID = dbo.Central_Patient_Index_VR.zzPatientLink LEFT OUTER JOIN
    dbo.AB_Main with (nolock) ON dbo.Def_SlipMain.DefAbstractID = dbo.AB_Main.UniversalID LEFT OUTER JOIN
    dbo.CM_CPI_Volume with (nolock) ON dbo.Def_SlipMain.DefVolumeID = dbo.CM_CPI_Volume.VolumeID LEFT OUTER JOIN
    dbo.U_Users Lookup2 with (nolock) ON dbo.Def_Activity.DefCompletedBy = Lookup2.Code LEFT OUTER JOIN
    dbo.DefLU_DeficiencyCode Lookup3 with (nolock) ON dbo.Def_Activity.DefCode = Lookup3.Code LEFT OUTER JOIN
    dbo.DefLU_DeficiencyType Lookup4 with (nolock) ON dbo.Def_Activity.DefCodeType = Lookup4.Code LEFT OUTER JOIN
    dbo.DefLU_ChartStatus Lookup5 with (nolock) ON dbo.Def_Activity.DefStatus = Lookup5.Code LEFT OUTER JOIN
    dbo.DefLU_Messages Lookup8 with (nolock) ON dbo.Def_Activity.DefMessage = Lookup8.Code LEFT OUTER JOIN
    dbo.DefLU_Resident Lookup10 with (nolock) ON dbo.Def_Activity.DefResident = Lookup10.Code LEFT OUTER JOIN
    dbo.DefLU_DocColourCode Lookup1 with (nolock) ON dbo.Def_SlipMain.DefColour = Lookup1.Code LEFT OUTER JOIN
    dbo.DefLU_ChartStatus Lookup6 with (nolock) ON dbo.Def_SlipMain.DefMainStatus = Lookup6.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup7 with (nolock) ON dbo.Def_SlipMain.DefInstNumber = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup9 with (nolock) ON dbo.Def_SlipMain.DefDrNumber = Lookup9.Code LEFT OUTER JOIN
    dbo.LLU_Provider_Language LUProviderLanguage with (nolock) ON Lookup9.ProvdrLanguage = LUProviderLanguage.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup11 with (nolock) ON dbo.Def_SlipMain.DefSiteNumber = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_CareType LU_CareType with (nolock) ON Lookup7.AssociationID = LU_CareType.Code
--QA - 00032 disable the domain securite issue
----PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or Def_SlipMain.HospitalID is null or Def_SlipMain.HospitalID = 0
--    --EN - 00666
--    or Is_Member(nullif(ReportGroup, '''')) = 1
----    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(Def_SlipMain.HospitalID, 0))

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Chart_DeficiencyStatusbyVisit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[Chart_DeficiencyStatusbyVisit_VR]
as
select
    zzUniversalLink = DefAbstractID,
    MinimumDeficiencyStartDate = min(DefStartDate),
    MaximumDeficiencyEndDate = max(DefEndDate),
    TotalHeaderCount = count(*),
    TotalHeaderCompleted = sum((case when DefMainStatus = 8 then 1 else 0 end)),
    TotalHeaderNotCompleted = sum((case when DefMainStatus = 8 then 0 else 1 end))
from dbo.Def_SlipMain with (nolock)
where DefAbstractID > 0
group by DefAbstractID


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_PullList_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[ChartLocator_PullList_UpdateHistory_VR]
AS
SELECT     
    dbo.CL_PullListUpdateHistory.PullListID, 
    dbo.U_Users.DisplayCode AS UpdateCoder, dbo.U_Users.UserDescription AS UpdateCoderDesc, 
    dbo.CL_PullListUpdateHistory.Updated AS UpdateDate, 
    dbo.CL_PullListUpdateHistory.UpdateType, 
    CL_PullListUpdateHistory.PullID as zzPullListLink,
    dbo.CL_PullListUpdateHistory.VolumeID AS zzVolumeLink
FROM         dbo.CL_PullListUpdateHistory with (nolock) LEFT OUTER JOIN
                      dbo.U_Users with (nolock) on dbo.CL_PullListUpdateHistory.Coder = dbo.U_Users.Code


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_PullList_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ChartLocator_PullList_VR]
AS
SELECT     
    CM_CPI_Volume.BarCodeVolume,    
    dbo.CL_PullList.PullOutDate AS ActualOutDate, dbo.CL_PullList.PullOutTime AS ActualOutTime, dbo.CM_CPI.ChartNumber, 
    dbo.CL_PullList.LoanNote AS ChartNote, LoanLU_Location_2.UserDescription AS CurrentLocation, 
    LoanLU_Location_2.DisplayCode AS CurrentLocationCode, dbo.CM_CPI.FirstName, 
    dbo.H_HospitalProfile.DisplayCode as Hospital, dbo.H_HospitalProfile.UserDescription as HospitalDesc,
    LU_YesNoSystem.DisplayCode as IsReturned, LU_YesNoSystem.UserDescription as IsReturnedDesc, 
    dbo.CM_CPI.LastName, LoanDate, LoanTime, 
    LoanLU_Location_3.UserDescription AS PullLocation, LoanLU_Location_3.DisplayCode AS PullLocationCode, 
    LU_LocationType.UserDescription AS PullLocationType, LU_LocationType.DisplayCode AS PullLocationTypeCode, 
    LoanLU_Location_1.UserDescription AS PermLocation, LoanLU_Location_1.DisplayCode AS PermLocationCode, 
    dbo.LoanLU_Borrower.UserDescription AS Puller, dbo.LoanLU_Borrower.DisplayCode AS PullerCode, dbo.CL_PullList.PullDate, 
    dbo.CL_PullList.PullListID, dbo.CL_PullList.PullNotes, 
    PullListStatus = (CASE WHEN isnull(dbo.CL_PullList.PullListStatus, 0) = 0 THEN '''' ELSE ''Loaned'' END), 
    dbo.CL_PullList.PullTime, PurgeDate = NULL, PurgeTime = NULL, 
    dbo.LoanLU_RequestPriority.UserDescription AS PullRequestPriority, dbo.LoanLU_RequestPriority.DisplayCode AS PullRequestPriorityCode, 
    dbo.CL_PullList.LoanReason as ReasonForLoan,
    dbo.CM_CPI_Volume.VolumeNumber, 
    LoanLU_VolumeType.DisplayCode as VolumeType, LoanLU_VolumeType.UserDescription as VolumeTypeDesc,
    dbo.CL_PullList.PullID as zzPullListLink,
    dbo.CM_CPI_Volume.PatientID as zzPatientLink,
    dbo.CL_PullList.VolumeID AS zzVolumeLink
FROM dbo.CM_CPI with (nolock) RIGHT OUTER JOIN
    dbo.CM_CPI_Volume with (nolock) on dbo.CM_CPI.PatientID = dbo.CM_CPI_Volume.PatientID LEFT OUTER JOIN
    dbo.LoanLU_Location LoanLU_Location_2 with (nolock) on dbo.CM_CPI_Volume.CLCurrentLocation = LoanLU_Location_2.Code LEFT OUTER JOIN
    dbo.LoanLU_Location LoanLU_Location_1 with (nolock) on dbo.CM_CPI_Volume.PermLocation = LoanLU_Location_1.Code RIGHT OUTER JOIN
    dbo.CL_PullList with (nolock) on dbo.CM_CPI_Volume.VolumeID = dbo.CL_PullList.VolumeID LEFT OUTER JOIN
    dbo.LoanLU_Location LoanLU_Location_3 with (nolock) on dbo.CL_PullList.PullLocation = LoanLU_Location_3.Code LEFT OUTER JOIN
    dbo.LoanLU_LocationType LU_LocationType with (nolock) on LoanLU_Location_3.LocationType = LU_LocationType.Code LEFT OUTER JOIN
    dbo.LoanLU_Borrower with (nolock) on dbo.CL_PullList.Puller = dbo.LoanLU_Borrower.Code LEFT OUTER JOIN
    dbo.LoanLU_RequestPriority with (nolock) on dbo.CL_PullList.CLRequestPriority = dbo.LoanLU_RequestPriority.Code LEFT OUTER JOIN
    dbo.LoanLU_VolumeType with (nolock) on CM_CPI_Volume.VolumeType = LoanLU_VolumeType.Code LEFT OUTER JOIN 
    dbo.LU_YesNoSystem with (nolock) on CL_PullList.IsReturned = LU_YesNoSystem.Code LEFT JOIN
    dbo.H_HospitalProfile with (nolock) on dbo.CL_PullList.HospitalID = dbo.H_HospitalProfile.Code
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CL_PullList.HospitalID is null or CL_PullList.HospitalID = 0
--    --EN - 00666
--    or Is_Member(nullif(ReportGroup, '''')) = 1
----    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CL_PullList.HospitalID, 0))
----PR - 04528
----    inner join dbo.CheckLogin() login 
----        with (nolock) on login.HospitalID in (0, isnull(dbo.CL_PullList.HospitalID, login.HospitalID))  
----            or isnull(dbo.CL_PullList.HospitalID, 0) in (0, login.HospitalID)
UNION ALL
SELECT 
    CM_CPI_Volume.BarCodeVolume,    
    dbo.CL_PullList_Purged.PullOutDate AS ActualPullDate, dbo.CL_PullList_Purged.PullOutTime AS ActualPullTime, dbo.CM_CPI.ChartNumber, 
    dbo.CL_PullList_Purged.LoanNote AS ChartNote, LoanLU_Location_2.UserDescription AS CurrentLocation, 
    LoanLU_Location_2.DisplayCode AS CurrentLocationCode, dbo.CM_CPI.FirstName, 
    dbo.H_HospitalProfile.DisplayCode as Hospital, dbo.H_HospitalProfile.UserDescription as HospitalDesc,
    LU_YesNoSystem.DisplayCode as IsReturned, LU_YesNoSystem.UserDescription as IsReturnedDesc, 
    dbo.CM_CPI.LastName, LoanDate = NULL, LoanTime = NULL, 
    LoanLU_Location_3.UserDescription AS PullLocation, LoanLU_Location_3.DisplayCode AS PullLocationCode, 
    LU_LocationType.UserDescription AS PullLocationType, LU_LocationType.DisplayCode AS PullLocationTypeCode, 
    LoanLU_Location_1.UserDescription AS PermLocation, LoanLU_Location_1.DisplayCode AS PermLocationCode, 
    dbo.LoanLU_Borrower.UserDescription AS Puller, dbo.LoanLU_Borrower.DisplayCode AS PullerCode, dbo.CL_PullList_Purged.PullDate, 
    dbo.CL_PullList_Purged.PullListID, dbo.CL_PullList_Purged.PullNotes, PullListStatus = ''Deleted'', dbo.CL_PullList_Purged.PullTime, 
    PurgeDate = LoanDate, PurgeTime = LoanTime, dbo.LoanLU_RequestPriority.UserDescription AS PullRequestPriority, 
    dbo.LoanLU_RequestPriority.DisplayCode AS PullRequestPriorityCode, 
    dbo.CL_PullList_Purged.LoanReason as ReasonForLoan,
    dbo.CM_CPI_Volume.VolumeNumber, 
    LoanLU_VolumeType.DisplayCode as VolumeType, LoanLU_VolumeType.UserDescription as VolumeTypeDesc,
    dbo.CL_PullList_Purged.PullID as zzPullListLink,
    dbo.CM_CPI_Volume.PatientID as zzPatientLink,
    dbo.CL_PullList_Purged.VolumeID AS zzVolumeLink
FROM dbo.CM_CPI with (nolock) RIGHT OUTER JOIN
    dbo.CM_CPI_Volume with (nolock) on dbo.CM_CPI.PatientID = dbo.CM_CPI_Volume.PatientID LEFT OUTER JOIN
    dbo.LoanLU_Location LoanLU_Location_2 with (nolock) on dbo.CM_CPI_Volume.CLCurrentLocation = LoanLU_Location_2.Code LEFT OUTER JOIN
    dbo.LoanLU_Location LoanLU_Location_1 with (nolock) on dbo.CM_CPI_Volume.PermLocation = LoanLU_Location_1.Code RIGHT OUTER JOIN
    dbo.CL_PullList_Purged with (nolock) on dbo.CM_CPI_Volume.VolumeID = dbo.CL_PullList_Purged.VolumeID LEFT OUTER JOIN
    dbo.LoanLU_Location LoanLU_Location_3 with (nolock) on dbo.CL_PullList_Purged.PullLocation = LoanLU_Location_3.Code LEFT OUTER JOIN
    dbo.LoanLU_LocationType LU_LocationType with (nolock) on LoanLU_Location_3.LocationType = LU_LocationType.Code LEFT OUTER JOIN
    dbo.LoanLU_Borrower with (nolock) on dbo.CL_PullList_Purged.Puller = dbo.LoanLU_Borrower.Code LEFT JOIN
    dbo.LoanLU_RequestPriority with (nolock) on dbo.CL_PullList_Purged.CLRequestPriority = dbo.LoanLU_RequestPriority.Code LEFT OUTER JOIN
    dbo.LoanLU_VolumeType with (nolock) on CM_CPI_Volume.VolumeType = LoanLU_VolumeType.Code LEFT OUTER JOIN 
    dbo.LU_YesNoSystem with (nolock) on CL_PullList_Purged.IsReturned = LU_YesNoSystem.Code LEFT JOIN
    dbo.H_HospitalProfile with (nolock) on dbo.CL_PullList_Purged.HospitalID = dbo.H_HospitalProfile.Code
----PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CL_PullList_Purged.HospitalID is null or CL_PullList_Purged.HospitalID = 0
--    --EN - 00666
--    or Is_Member(nullif(ReportGroup, '''')) = 1
----    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CL_PullList_Purged.HospitalID, 0))

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ChartLocator_UpdateHistory_VR]
AS
SELECT     dbo.U_Users.DisplayCode AS UpdateCoder, dbo.U_Users.UserDescription AS UpdateCoderDesc, 
                      dbo.CL_ActivityUpdateHistory.Updated AS UpdateDate, dbo.CL_ActivityUpdateHistory.UpdateType, 
                      dbo.CL_ActivityUpdateHistory.CLActivityID AS zzCLLink
FROM         dbo.CL_ActivityUpdateHistory with (nolock) LEFT OUTER JOIN
                      dbo.U_Users with (nolock) on dbo.CL_ActivityUpdateHistory.Coder = dbo.U_Users.Code




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocator_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[ChartLocator_VR]
AS
SELECT
LU_ActivityLocation.UserDescription AS ActivityLocation, LU_ActivityLocation.DisplayCode AS ActivityLocationCode, 
LU_ActLocationType.DisplayCode AS ActivityLocationType, LU_ActLocationType.UserDescription AS ActivityLocationTypeDesc, 
LU_ActiveInHealthDepartment.DisplayCode AS ActivityLocInRecordDepartment, LU_ActiveInHealthDepartment.UserDescription AS ActivityLocInRecordDepartDesc, 

dbo.CL_Activity.ActivityNotes, dbo.LoanLU_Type.UserDescription AS ActivityType, dbo.LoanLU_Type.DisplayCode AS ActivityTypeCode, 
dbo.CL_Activity.CLPullOutDate AS ActualPullDate, dbo.CL_Activity.CLPullOutTime AS ActualPullTime, dbo.CM_CPI_Volume.BarCodeVolume, 
dbo.LoanLU_Borrower.UserDescription AS Borrower, dbo.LoanLU_Borrower.DisplayCode AS BorrowerCode, dbo.LoanLU_Borrower.BorrowerAddress, 
dbo.LoanLU_Borrower.BorrowerCity, dbo.LoanLU_Borrower.BorrowerContact, dbo.LoanLU_Borrower.BorrowerPhone, 
dbo.LoanLU_Borrower.BorrowerPostal, dbo.LoanLU_Borrower.BorrowerProvince, dbo.CM_CPI_Volume.CLBoxNumber AS BoxNumber, 
dbo.CM_CPI.ChartNumber, U_Users_1.UserDescription AS CoderIn, U_Users_1.DisplayCode AS CoderInCode, 
dbo.U_Users.UserDescription AS CoderOut, dbo.U_Users.DisplayCode AS CoderOutCode, dbo.CL_Activity.ActivityDateIn AS DateIn, 
dbo.CL_Activity.ActivityDateOut AS DateOut, dbo.CL_Activity.ActivityExpectedReturn AS ExpectedReturnDate, dbo.CM_CPI.DeathDate AS ExpiredDate, 
LU_Hospital.DisplayCode AS Hospital, LU_Hospital.UserDescription AS HospitalDesc, LUNewLocation.DisplayCode AS NewPermanentLocation, 
LUNewLocation.UserDescription AS NewPermanentLocationDesc, dbo.CM_CPI.FirstName AS PatientFirstName, 
dbo.CM_CPI.LastName AS PatientLastName, 

LU_PreviousLocation.UserDescription AS PreviousLocation, LU_PreviousLocation.DisplayCode AS PreviousLocationCode, 
LU_PrevLocationType.DisplayCode AS PreviousLocationType, LU_PrevLocationType.UserDescription AS PreviousLocationTypeDesc, 
LU_PreviousInHealthDepartment.DisplayCode AS PreviousLocInRecordDepartment, LU_PreviousInHealthDepartment.UserDescription AS PreviousLocInRecordDepartDesc, 

dbo.LoanLU_RequestPriority.UserDescription AS RequestPriority, 
dbo.LoanLU_RequestPriority.DisplayCode AS RequestPriorityCode, dbo.CL_Activity.CLPullDate AS RequiredDate, 
dbo.CL_Activity.CLPullTime AS RequiredTime, dbo.CL_Activity.LoanReason AS ReasonOfLoan, dbo.CL_Activity.ActivityTimeIn AS TimeIn, 
dbo.CL_Activity.ActivityTimeOut AS TimeOut, dbo.CM_CPI_Volume.VolumeNumber, dbo.LoanLU_VolumeType.DisplayCode AS VolumeType, 
dbo.LoanLU_VolumeType.UserDescription AS VolumeTypeDesc, dbo.CL_Activity.CLActivityID AS zzCLLink, 
dbo.CL_Activity.VolumeID AS zzVolumeLink
FROM
dbo.CL_Activity with (nolock) LEFT OUTER JOIN
dbo.LoanLU_Location LUNewLocation with (nolock) on dbo.CL_Activity.CLNewPermLocation = LUNewLocation.Code LEFT OUTER JOIN
dbo.LoanLU_RequestPriority with (nolock) on dbo.CL_Activity.CLRequestPriority = dbo.LoanLU_RequestPriority.Code LEFT OUTER JOIN
dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.CL_Activity.HospitalID = LU_Hospital.Code LEFT OUTER JOIN

dbo.CM_CPI_Volume with (nolock) on dbo.CM_CPI_Volume.VolumeID = dbo.CL_Activity.VolumeID LEFT OUTER JOIN
dbo.U_Users U_Users_1 with (nolock) on U_Users_1.Code = dbo.CL_Activity.ActivityCoderIn LEFT OUTER JOIN
dbo.U_Users with (nolock) on dbo.CL_Activity.ActivityCoderOut = dbo.U_Users.Code LEFT OUTER JOIN

dbo.LoanLU_Location LU_PreviousLocation with (nolock) on LU_PreviousLocation.Code = dbo.CL_Activity.ActivityPrevLocation LEFT OUTER JOIN
dbo.LoanLU_LocationType LU_PrevLocationType with (nolock) on LU_PrevLocationType.Code = LU_PreviousLocation.LocationType LEFT OUTER JOIN

dbo.LoanLU_Type with (nolock) on dbo.LoanLU_Type.Code = dbo.CL_Activity.ActivityType LEFT OUTER JOIN
dbo.LoanLU_Location LU_ActivityLocation with (nolock) on dbo.CL_Activity.ActivityLocation = LU_ActivityLocation.Code LEFT OUTER JOIN
dbo.LoanLU_LocationType LU_ActLocationType with (nolock) on LU_ActLocationType.Code = LU_ActivityLocation.LocationType  LEFT OUTER JOIN
dbo.LoanLU_Borrower with (nolock) on dbo.CL_Activity.ActivityBorrower = dbo.LoanLU_Borrower.Code LEFT OUTER JOIN
dbo.CM_CPI with (nolock) on dbo.CM_CPI_Volume.PatientID = dbo.CM_CPI.PatientID LEFT OUTER JOIN
dbo.LoanLU_VolumeType with (nolock) on dbo.CM_CPI_Volume.VolumeType = dbo.LoanLU_VolumeType.Code LEFT OUTER JOIN

dbo.LU_YesNoSystem LU_ActiveInHealthDepartment with (nolock) on LU_ActivityLocation.InHospital = LU_ActiveInHealthDepartment.Code LEFT OUTER JOIN
dbo.LU_YesNoSystem LU_PreviousInHealthDepartment with (nolock) on LU_PreviousLocation.InHospital = LU_PreviousInHealthDepartment.Code
--QA - 00032 disable the domain securite issue
----PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CL_Activity.HospitalID is null or CL_Activity.HospitalID = 0
--    --EN - 00666
--    or Is_Member(nullif(ReportGroup, '''')) = 1
----    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CL_Activity.HospitalID, 0))

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartLocatorCurrentAct_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ChartLocatorCurrentAct_VR]
as
select VolumeID as zzVolumeLink, CLActivityID as zzCLLink
from dbo.CM_CPI_Volume with (nolock)

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartNumberMasked_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ChartNumberMasked_VR]
AS
SELECT     dbo.CM_CPI.ChartNumber AS ChartNumber, dbo.CM_Terminal.MaskChart, dbo.CM_Terminal.TerminalChart,
    zzPatientLink = dbo.CM_CPI.PatientID
FROM         dbo.CM_Terminal with (nolock) INNER JOIN
                      dbo.CM_CPI with (nolock) on dbo.CM_Terminal.PatientID = dbo.CM_CPI.PatientID
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ChartVisitHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE View [dbo].[ChartVisitHistory_VR]
as
select 
    AB.AdmitDate, AB.AdmitTime, 
    AdmitAgeCode = LA.DisplayCode, AdmitAgeCodeDesc = LA.UserDescription, 
    AdmitAgeNumber = AB.AgeNumber, 
    AdmitCategory = LAC.DisplayCode, AdmitCategoryDesc = LAC.UserDescription, 
    AssessmentType = null, AssessmentTypeDesc = null, 
    CM.BirthDate, 
    CM.ChartNumber, 
    CareType = CT.DisplayCode, CareTypeDesc = CT.UserDescription, 
    DiagnosisCode = (case ICDType 
                            when ''9'' then D9.DisplayCode 
                            when ''C'' then DC.DisplayCode 
                            when ''T'' then DT.DisplayCode end), 
    DiagnosisCodeDesc = (case ICDType  
                            when ''9'' then D9.UserDescription 
                            when ''C'' then DC.UserDescription 
                            when ''T'' then DT.UserDescription end), 
    AB.DischargeDate, AB.DischargeTime, 
    AB.EncounterNumber, AB.EncounterSequence, 
    CM.FirstName, CM.LastName, CM.MiddleName, 
    Gender = LG.DisplayCode, GenderDesc = LG.UserDescription, 
    InstitutionNumber = H.DisplayCode, InstitutionNumberDesc = H.UserDescription, 
    InterventionCode = (case ICDType 
                            when ''9'' then P9.DisplayCode 
                            when ''C'' then PC.DisplayCode 
                            when ''T'' then PT.DisplayCode end), 
    InterventionCodeDesc = (case ICDType 
                            when ''9'' then P9.UserDescription 
                            when ''C'' then PC.UserDescription 
                            when ''T'' then PT.UserDescription end), 
    ICDType, 
    ProviderNumber = LP.DisplayCode, 
    ProviderNumberDesc = LP.UserDescription, 
    PSCodeOrMISCode = (case when CareType = 5 then LM.DisplayCode else LPS.DisplayCode end),
    PSCodeOrMISCodeDesc = (case when CareType = 5 then LM.UserDescription else LPS.UserDescription end),

    zzAbstractLink = AB.AbstractID, zzPatientLink = CM.PatientID 
from CM_CPI CM with (nolock)
    inner join AB_Abstract AB with (nolock) on CM.ChartNumber = AB.ChartNumber and (isnull(CM.HospitalID, 0) = isnull(AB.HospitalID, 0) or isnull(CM.HospitalID, 0) = 0)
    inner join LU_CareType CT with (nolock) on AB.CareType = CT.Code
    inner join H_InstitutionProfile H with (nolock) on AB.InstitutionNumber = H.Code
    left  join AB_PatientService PS with (nolock) on AB.AbstractID = PS.AbstractID and ServiceOccurrence = 1
    left  join AB_Diagnosis D with (nolock) on AB.AbstractID = D.AbstractID and D.DiagnosisOccurrence = 1
    left  join AB_Intervention I with (nolock) on AB.AbstractID = I.AbstractID and I.IntervOccurrence = 1
    left  join AB_Provider P with (nolock) on AB.AbstractID = P.AbstractID and P.ProviderOccurrence = 1
    left  join ICD_DiagFile9 D9 with (nolock) on D.DiagnosisCode = D9.Code
    left  join ICD_DiagFile9cm DC with (nolock) on D.DiagnosisCode = DC.Code
    left  join ICD_DiagFile10 DT with (nolock) on D.DiagnosisCode = DT.Code
    left  join ICD_ProcFile9 P9 with (nolock) on I.IntervCode = P9.Code
    left  join ICD_ProcFile9cm PC with (nolock) on I.IntervCode = PC.Code
    left  join ICD_ProcFile10 PT with (nolock) on I.IntervCode = PT.Code
    left  join LU_PatientService LPS with (nolock) on PS.PatientService = LPS.Code
    left  join LU_Provider LP with (nolock) on P.ProviderNumber = LP.Code
    left  join LU_Gender_I LG with (nolock) on CM.Gender = LG.Code
    left  join LU_MisCode LM with (nolock) on AB.MisCode = LM.Code
    left  join LU_AgeCode LA with (nolock) on AB.AgeCode = LA.Code
    left  join LU_AdmitCategory LAC with (nolock) on AB.AdmitCategory = LAC.Code
--PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB.HospitalID is null or AB.HospitalID = 0
--    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB.HospitalID, 0))
Union
select 
    AB.AdmitDate, AdmitTime = null, 
    AdmitAgeCode = LA.DisplayCode, AdmitAgeCodeDesc = LA.UserDescription, 
    AdmitAgeNumber = RD.AgeNumber, 
    AdmitCategory = null, AdmitCategoryDesc = null, 
    AssessmentType = A.DisplayCode, AssessmentTypeDesc = A.UserDescription, 
    CM.BirthDate, 
    CM.ChartNumber, 
    CareType = CT.DisplayCode, CareTypeDesc = CT.UserDescription, 
    DiagnosisCode = DT.DisplayCode,    DiagnosisCodeDesc = DT.UserDescription, 
    DischargeDate = (case when A.CIHIValue = ''3'' then AB.FollowUpDate else AB.DischargeDate end), 
    DischargeTime = null, 

    AB.EncounterNumber, EncounterSequence = null, 
    CM.FirstName, CM.LastName, CM.MiddleName, 
    Gender = LG.DisplayCode, GenderDesc = LG.UserDescription, 
    InstitutionNumber = H.DisplayCode, InstitutionNumberDesc = H.UserDescription, 
    InterventionCode = null,  InterventionCodeDesc = null, 
    ICDType, 
    ProviderNumber = LP.DisplayCode, ProviderNumberDesc = LP.UserDescription, 
    PSCodeOrMISCode = null,
    PSCodeOrMISCodeDesc = null,

    zzAbstractLink = AB.AbstractID, zzPatientLink = CM.PatientID 
from CM_CPI CM with (nolock)
    inner join RH_ClientInfo AB with (nolock) on CM.ChartNumber = AB.ChartNumber and (isnull(CM.HospitalID, 0) = isnull(AB.HospitalID, 0) or isnull(CM.HospitalID, 0) = 0)
    inner join RH_Demographic RD with (nolock) on AB.AbstractID = RD.AbstractID
    inner join LU_CareType CT with (nolock) on AB.CareType = CT.Code
    inner join H_InstitutionProfile H with (nolock) on AB.InstitutionNumber = H.Code
    left  join RH_Diagnosis D with (nolock) on AB.AbstractID = D.AbstractID and D.DiagnosisOccurrence = 1
    left  join RH_Provider P with (nolock) on AB.AbstractID = P.AbstractID and P.ProviderOccurrence = 1
    left  join ICD_DiagFile10 DT with (nolock) on D.DiagnosisCode = DT.Code
    left  join LU_Provider LP with (nolock) on P.ProviderNumber = LP.Code
    left  join LU_Gender_I LG with (nolock) on CM.Gender = LG.Code
    left  join LU_AgeCode LA with (nolock) on RD.AgeCode = LA.Code
    left  join LU_CodeFile A with (nolock) on AB.AssessmentType = A.Code
--PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB.HospitalID is null or AB.HospitalID = 0
--    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB.HospitalID, 0))
union
select 
    AB.AdmitDate, AdmitTime = null, 
    AdmitAgeCode = (select top 1 DisplayCode from lu_Agecode LAC where LAC.CIHIValue = ''Y''), 
    AdmitAgeCodeDesc = (select top 1 UserDescription from lu_Agecode LAC where LAC.CIHIValue = ''Y''), 
    AdmitAgeNumber = datediff(year, CM.BirthDate, AB.AdmitDate), 
    AdmitCategory = null, AdmitCategoryDesc = null, 
    AssessmentType = A.DisplayCode, AssessmentTypeDesc = A.UserDescription, 
    CM.BirthDate, 
    CM.ChartNumber, 
    CareType = CT.DisplayCode, CareTypeDesc = CT.UserDescription, 
    DiagnosisCode = DT.DisplayCode,    DiagnosisCodeDesc = DT.UserDescription, 
    DischargeDate = (case when A.CIHIValue in ( ''06'', ''07'', ''08'') then AB.DischargeDate
                          when A.CIHIValue = ''00'' then AB.Z7
                          when A.CIHIValue = ''09'' then AB.AB1b
                          else AB.A3 
                    end),
    DischargeTime = null, 
    EncounterNumber = AB.AA1, EncounterSequence = null, 
    CM.FirstName, CM.LastName, CM.MiddleName, 
    Gender = LG.DisplayCode, GenderDesc = LG.UserDescription, 
    InstitutionNumber = H.DisplayCode, InstitutionNumberDesc = H.UserDescription, 
    InterventionCode = null,  InterventionCodeDesc = null, 
    ICDType = ''T'', 
    ProviderNumber = LP.DisplayCode, ProviderNumberDesc = LP.UserDescription, 
    PSCodeOrMISCode = null,
    PSCodeOrMISCodeDesc = null,
    zzAbstractLink = AB.AbstractID, zzPatientLink = CM.PatientID 
from CM_CPI CM with (nolock) 
    inner join CRS_Demographic AB with (nolock) on CM.ChartNumber = AB.ChartNumber and (isnull(CM.HospitalID, 0) = isnull(AB.HospitalID, 0) or isnull(CM.HospitalID, 0) = 0)
    inner join H_InstitutionProfile H with (nolock) on AB.InstitutionNumber = H.Code
    inner join LU_CareType CT with (nolock) on H.AssociationID = CT.Code
    left  join CRS_Diagnosis D with (nolock) on AB.AbstractID = D.AbstractID 
    left  join CRS_Signature P with (nolock) on AB.AbstractID = P.AbstractID and P.ProviderOccurrence = 1
    left  join ICD_DiagFile10 DT with (nolock) on D.I3a = DT.Code
    left  join LU_Provider LP with (nolock) on P.ProviderNumber = LP.Code
    left  join LU_Gender_I LG with (nolock) on CM.Gender = LG.Code
    left  join LU_CodeFile A with (nolock) on AB.AA8 = A.Code
--PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB.HospitalID is null or AB.HospitalID = 0
--    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB.HospitalID, 0))
union
select 
    AB.AdmitDate, AB.AdmitTime, 
    AdmitAgeCode = (select top 1 DisplayCode from lu_Agecode LAC where LAC.CIHIValue = ''Y''), 
    AdmitAgeCodeDesc = (select top 1 UserDescription from lu_Agecode LAC where LAC.CIHIValue = ''Y''), 
    AdmitAgeNumber = datediff(year, CM.BirthDate, AB.AdmitDate), 
    AdmitCategory = null, AdmitCategoryDesc = null, 
    AssessmentType = null, AssessmentTypeDesc = null, 
    CM.BirthDate, 
    CM.ChartNumber, 
    CareType = CT.DisplayCode, CareTypeDesc = CT.UserDescription, 
    DiagnosisCode = null,    DiagnosisCodeDesc = null, 
    AB.DischargeDate, AB.DischargeTime, 
    AB.EncounterNumber, AB.EncounterSequence, 
    CM.FirstName, CM.LastName, CM.MiddleName, 
    Gender = LG.DisplayCode, GenderDesc = LG.UserDescription, 
    InstitutionNumber = H.DisplayCode, InstitutionNumberDesc = H.UserDescription, 
    InterventionCode = null,  InterventionCodeDesc = null, 
    ICDType = null, 
    ProviderNumber = null, ProviderNumberDesc = null, 
    PSCodeOrMISCode = null,
    PSCodeOrMISCodeDesc = null,
    zzAbstractLink = AB.AbstractID, zzPatientLink = CM.PatientID 
from CM_CPI CM with (nolock)
    inner join AB_Main AB with (nolock) on CM.ChartNumber = AB.ChartNumber and (isnull(CM.HospitalID, 0) = isnull(AB.HospitalID, 0) or isnull(CM.HospitalID, 0) = 0)
    inner join H_InstitutionProfile H with (nolock) on AB.InstitutionNumber = H.Code
    inner join LU_CareType CT with (nolock) on H.AssociationID = CT.Code
    left  join LU_Gender_I LG with (nolock) on CM.Gender = LG.Code
where AB.AppID <> 0 and AB.AppType = 9
--PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB.HospitalID is null or AB.HospitalID = 0
--    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB.HospitalID, 0)))
union
select 
    AdmitDate = AB.AdmitDate, AdmitTime = null, 
    AdmitAgeCode = (select top 1 DisplayCode from lu_Agecode LAC where LAC.CIHIValue = ''Y''), 
    AdmitAgeCodeDesc = (select top 1 UserDescription from lu_Agecode LAC where LAC.CIHIValue = ''Y''), 
    AdmitAgeNumber = datediff(year, CM.BirthDate, AB.AdmitDate), 
    AdmitCategory = null,  
    AdmitCategoryDesc = null, 
    AssessmentType = ASS.DisplayCode, 
    AssessmentTypeDesc = Ass.UserDescription, 
    CM.BirthDate, 
    CM.ChartNumber, 
    CareType = CT.DisplayCode, CareTypeDesc = CT.UserDescription, 
    DiagnosisCode = DT.DisplayCode, 
    DiagnosisCodeDesc = DT.UserDescription, 
    DischargeDate = S.X80, DischargeTime = null, 
    EncounterNumber = null, EncounterSequence = null, 
    CM.FirstName, CM.LastName, CM.MiddleName, 
    Gender = LG.DisplayCode, GenderDesc = LG.UserDescription, 
    InstitutionNumber = H.DisplayCode, InstitutionNumberDesc = H.UserDescription, 
    InterventionCode = PT.DisplayCode, 
    InterventionCodeDesc = PT.UserDescription, 
    ICDType = null, 
    ProviderNumber = LP.DisplayCode, 
    ProviderNumberDesc = LP.UserDescription, 
    PSCodeOrMISCode = null, 
    PSCodeOrMISCodeDesc = null, 
    zzAbstractLink = AB.AbstractID, zzPatientLink = CM.PatientID 
from CM_CPI CM with (nolock)
    inner join OMHRS_SecAA AB with (nolock) on CM.ChartNumber = AB.ChartNumber and (isnull(CM.HospitalID, 0) = isnull(AB.HospitalID, 0) or isnull(CM.HospitalID, 0) = 0)
    inner join OMHRS_SecA A with (nolock) on AB.AbstractID = A.AbstractID
    inner join LU_CodeFile Ass with (nolock) on A.A2 = Ass.Code
    inner join H_InstitutionProfile H with (nolock) on AB.InstitutionNumber = H.Code
    inner join LU_CareType CT with (nolock) on H.AssociationID = CT.Code
    left  join OMHRS_SecS S with (nolock) on AB.AbstractID = S.AbstractID
    left  join OMHRS_DSM_Diag D with (nolock) on AB.AbstractID = D.AbstractID and D.Occurrence = 1
    left  join OMHRS_Intervention I with (nolock) on AB.AbstractID = I.AbstractID and I.IntervOccurrence = 1
    left  join OMHRS_Provider P with (nolock) on AB.AbstractID = P.AbstractID and P.ProviderOccurrence = 1
    left  join ICD_DiagFile10 DT with (nolock) on D.Q2 = DT.Code
    left  join ICD_ProcFile10 PT with (nolock) on I.IntervCode = PT.Code
    left  join LU_Provider LP with (nolock) on P.ProviderNumber = LP.Code
    left  join LU_Gender_I LG with (nolock) on CM.Gender = LG.Code
--PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB.HospitalID is null or AB.HospitalID = 0
--    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB.HospitalID, 0))
--    --EN - 00666
--    or Is_Member(nullif((select top 1 ReportGroup from h_hospitalprofile where code = AB.HospitalID), '''')) = 1

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_AcetabularComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_AcetabularComponent_VR]
as
select
      CJRR_AcetabularComponent.RecordID as zzCJRR_Link
      ,AcetabularComponentHOccurrence = Occurrence
      ,AcetabularComponentStickerCode = LU_CJRR_AcetabularComponentH.DisplayCode, AcetabularComponentStickerCodeDesc = LU_CJRR_AcetabularComponentH.UserDescription
      ,AcetabularComponentManufacturer = LU_Manufacturer.DisplayCode, AcetabularComponentManufacturerDesc = LU_Manufacturer.UserDescription
      ,AcetabularComponentOtherManufacturer = CJRR_AcetabularComponent.OtherManufacturer
      ,AcetabularComponentCatalogueNumber = CJRR_AcetabularComponent.CatalogueNumber
      ,AcetabularComponentLotNumber = CJRR_AcetabularComponent.LotNumber
from dbo.CJRR_AcetabularComponent
    left join LU_CJRR_AcetabularComponentH on CJRR_AcetabularComponent.StickerCode = LU_CJRR_AcetabularComponentH.Code
    left join LU_CodeFile LU_Manufacturer on CJRR_AcetabularComponent.Manufacturer = LU_Manufacturer.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_AcetabularInsert_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_AcetabularInsert_VR]
as
select
      CJRR_AcetabularInsert.RecordID as zzCJRR_Link
      ,AcetabularInsertOccurrence = Occurrence
      ,AcetabularInsertStickerCode = LU_CJRR_AcetabularInsertH.DisplayCode, AcetabularInsertStickerCodeDesc = LU_CJRR_AcetabularInsertH.UserDescription
      ,AcetabularInsertManufacturer = LU_Manufacturer.DisplayCode, AcetabularInsertManufacturerDesc = LU_Manufacturer.UserDescription
      ,AcetabularInsertOtherManufacturer = CJRR_AcetabularInsert.OtherManufacturer
      ,AcetabularInsertCatalogueNumber = CJRR_AcetabularInsert.CatalogueNumber
      ,AcetabularInsertLotNumber = CJRR_AcetabularInsert.LotNumber
from dbo.CJRR_AcetabularInsert
    left join LU_CJRR_AcetabularInsertH on CJRR_AcetabularInsert.StickerCode = LU_CJRR_AcetabularInsertH.Code
    left join LU_CodeFile LU_Manufacturer on CJRR_AcetabularInsert.Manufacturer = LU_Manufacturer.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_Cement_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_Cement_VR]
as
select
      CJRR_Cement.RecordID as zzCJRR_Link
      ,CementOccurrence = Occurrence
      ,CementStickerCode = (case when AppID = 40000 then LU_CJRR_CementDetailsK.DisplayCode
                                 when AppID = 40001 then LU_CJRR_CementDetailsH.DisplayCode
                            end)
      ,CementStickerCodeDesc = (case when AppID = 40000 then LU_CJRR_CementDetailsK.UserDescription
                                     when AppID = 40001 then LU_CJRR_CementDetailsH.UserDescription
                                end)
      ,CementName = LU_Name.DisplayCode, CementNameDesc = LU_Name.UserDescription
      ,CementOtherName = CJRR_Cement.OtherName
      ,CementCatalogueNumber = CJRR_Cement.CatalogueNumber
      ,CementLotNumber = CJRR_Cement.LotNumber
from CJRR_Abstract 
    inner join dbo.CJRR_Cement on CJRR_Abstract.RecordID = CJRR_Cement.RecordID
    left join LU_CJRR_CementDetailsK on CJRR_Cement.StickerCode = LU_CJRR_CementDetailsK.Code
    left join LU_CJRR_CementDetailsH on CJRR_Cement.StickerCode = LU_CJRR_CementDetailsH.Code
    left join LU_CodeFile LU_Name on CJRR_Cement.Name = LU_Name.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_ErrorsWarnings_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[CJRR_ErrorsWarnings_VR]
AS
SELECT 
    CIHI_ElementID = U_UsersFields.CIHI_ID,
    FieldName = U_UsersFields.Header_User, 
    --ErrorMessage = dbo.MG_Messages.MessageText, 
    MessageLevel = CASE AB_ErrorMessages.MessageType WHEN 1 THEN ''Warning'' 
                                    WHEN 2 THEN ''Error'' 
                                    WHEN 3 THEN ''Critical'' 
                                    WHEN 0 THEN ''Information'' 
                                    WHEN 5 THEN ''Question'' END, 
    AB_ErrorMessages.MessageText, 
    AB_ErrorMessages.SaveDate, 
    AB_ErrorMessages.AbstractID AS zzCJRR_Link
FROM dbo.AB_ErrorMessages with (nolock)
    --left join dbo.MG_Messages with (nolock)
    --    on dbo.AB_ErrorMessages.MessageKey = dbo.MG_Messages.MessageKey
    left join dbo.AB_ErrorMessageFields with (nolock)
        on dbo.AB_ErrorMessages.AppID = dbo.AB_ErrorMessageFields.AppID
            and dbo.AB_ErrorMessages.AbstractID = dbo.AB_ErrorMessageFields.AbstractID 
            and dbo.AB_ErrorMessages.MessageKey = dbo.AB_ErrorMessageFields.MessageKey
    left join dbo.U_UsersFields with (nolock) 
        on UserID = 1 and dbo.AB_ErrorMessages.AppID = dbo.U_UsersFields.AppID and 
        (case when isnumeric(replace(dbo.AB_ErrorMessageFields.FieldKey, ''FK'', '''')) = 1 
              then replace(dbo.AB_ErrorMessageFields.FieldKey, ''FK'', '''')
              else 0 end) = dbo.U_UsersFields.FieldID 
Where AB_ErrorMessages.appid in (40000, 40001)


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_FemoralComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_FemoralComponent_VR]
as
select
       CJRR_FemoralComponent.RecordID as zzCJRR_Link
      ,FemoralComponentOccurrence = Occurrence
      ,FemoralComponentStickerCode = (case when AppID = 40000 then LU_CJRR_FemoralComponentK.DisplayCode
                                           when AppID = 40001 then LU_CJRR_FemoralComponentH.DisplayCode
                                      end)
      ,FemoralComponentStickerCodeDesc = (case when AppID = 40000 then LU_CJRR_FemoralComponentK.UserDescription
                                           when AppID = 40001 then LU_CJRR_FemoralComponentH.UserDescription
                                      end)
      ,Manufacturer = LU_Manufacturer.DisplayCode, ManufacturerDesc = LU_Manufacturer.UserDescription
      ,CJRR_FemoralComponent.OtherManufacturer as FemoralComponentOtherManufacturer
      ,CJRR_FemoralComponent.CatalogueNumber as FemoralComponentCatalogueNumber
      ,CJRR_FemoralComponent.LotNumber as FemoralComponentLotNumber
from CJRR_Abstract 
    inner join dbo.CJRR_FemoralComponent on CJRR_Abstract.RecordID = CJRR_FemoralComponent.RecordID
    left join LU_CJRR_FemoralComponentK on CJRR_FemoralComponent.StickerCode = LU_CJRR_FemoralComponentK.Code
    left join LU_CJRR_FemoralComponentH on CJRR_FemoralComponent.StickerCode = LU_CJRR_FemoralComponentH.Code
    left join LU_CodeFile LU_Manufacturer on CJRR_FemoralComponent.Manufacturer = LU_Manufacturer.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_FemoralHead_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_FemoralHead_VR]
as
select
      CJRR_FemoralHead.RecordID as zzCJRR_Link
      ,FemoralHeadOccurrence = Occurrence
      ,FemoralHeadStickerCode = LU_CJRR_FemoralHeadH.DisplayCode, FemoralHeadStickerCodeDesc = LU_CJRR_FemoralHeadH.UserDescription
      ,FemoralHeadManufacturer = LU_Manufacturer.DisplayCode, FemoralHeadManufacturerDesc = LU_Manufacturer.UserDescription
      ,FemoralHeadOtherManufacturer = CJRR_FemoralHead.OtherManufacturer
      ,FemoralHeadCatalogueNumber = CJRR_FemoralHead.CatalogueNumber
      ,FemoralHeadLotNumber = CJRR_FemoralHead.LotNumber
from dbo.CJRR_FemoralHead
    left join LU_CJRR_FemoralHeadH on CJRR_FemoralHead.StickerCode = LU_CJRR_FemoralHeadH.Code
    left join LU_CodeFile LU_Manufacturer on CJRR_FemoralHead.Manufacturer = LU_Manufacturer.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_PatellarComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_PatellarComponent_VR]
as
select
      CJRR_PatellarComponent.RecordID as zzCJRR_Link
      ,PatellarComponentOccurrence = Occurrence
      ,PatellarComponentStickerCode = LU_CJRR_PatellarComponentK.DisplayCode, PatellarComponentStickerCodeDesc = LU_CJRR_PatellarComponentK.UserDescription
      ,PatellarComponentManufacturer = LU_Manufacturer.DisplayCode, PatellarComponentManufacturerDesc = LU_Manufacturer.UserDescription
      ,PatellarComponentOtherManufacturer = CJRR_PatellarComponent.OtherManufacturer
      ,PatellarComponentCatalogueNumber = CJRR_PatellarComponent.CatalogueNumber
      ,PatellarComponentLotNumber = CJRR_PatellarComponent.LotNumber
from CJRR_PatellarComponent
    left join LU_CJRR_PatellarComponentK on CJRR_PatellarComponent.StickerCode = LU_CJRR_PatellarComponentK.Code
    left join LU_CodeFile LU_Manufacturer on CJRR_PatellarComponent.Manufacturer = LU_Manufacturer.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_TibialComponent_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_TibialComponent_VR]
as
select
      CJRR_TibialComponent.RecordID as zzCJRR_Link
      ,TibialComponentOccurrence = Occurrence
      ,TibialComponentStickerCode = LU_CJRR_TibialComponentK.DisplayCode, TibialComponentStickerCodeDesc = LU_CJRR_TibialComponentK.UserDescription
      ,TibialComponentManufacturer = LU_Manufacturer.DisplayCode, TibialComponentManufacturerDesc = LU_Manufacturer.UserDescription
      ,TibialComponentOtherManufacturer	= CJRR_TibialComponent.OtherManufacturer
      ,TibialComponentCatalogueNumber = CJRR_TibialComponent.CatalogueNumber
      ,TibialComponentLotNumber = CJRR_TibialComponent.LotNumber
from CJRR_TibialComponent
    left join LU_CJRR_TibialComponentK on CJRR_TibialComponent.StickerCode = LU_CJRR_TibialComponentK.Code
    left join LU_CodeFile LU_Manufacturer on CJRR_TibialComponent.Manufacturer = LU_Manufacturer.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_TibialInsert_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_TibialInsert_VR]
as
select
      CJRR_TibialInsert.RecordID as zzCJRR_Link
      ,TibialInsertOccurrence  = Occurrence
      ,TibialInsertStickerCode = LU_CJRR_TibialInsertK.DisplayCode, TibialInsertStickerCodeDesc = LU_CJRR_TibialInsertK.UserDescription
      ,TibialInserttManufacturer = LU_Manufacturer.DisplayCode, TibialInsertManufacturerDesc = LU_Manufacturer.UserDescription
      ,TibialInsertOtherManufacturer = CJRR_TibialInsert.OtherManufacturer
      ,TibialInsertCatalogueNumber = CJRR_TibialInsert.CatalogueNumber
      ,TibialInsertLotNumber = CJRR_TibialInsert.LotNumber
From CJRR_TibialInsert
    left join LU_CJRR_TibialInsertK on CJRR_TibialInsert.StickerCode = LU_CJRR_TibialInsertK.Code
    left join LU_CodeFile LU_Manufacturer on CJRR_TibialInsert.Manufacturer = LU_Manufacturer.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_UD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[CJRR_UD_Abstracting_VR]
AS
SELECT
    dbo.CJRR_UDFieldsDate.UDDate1 AS Date1UD,    dbo.CJRR_UDFieldsDate.UDDate2 AS Date2UD, 
    dbo.CJRR_UDFieldsDate.UDDate3 AS Date3UD,    dbo.CJRR_UDFieldsDate.UDDate4 AS Date4UD,
    dbo.CJRR_UDFieldsDate.UDDate5 AS Date5UD,    dbo.CJRR_UDFieldsDate.UDDate6 AS Date6UD,
    dbo.CJRR_UDFieldsDate.UDDate7 AS Date7UD,    dbo.CJRR_UDFieldsDate.UDDate8 AS Date8UD,
    dbo.CJRR_UDFieldsDate.UDDate9 AS Date9UD,    dbo.CJRR_UDFieldsDate.UDDate10 AS Date10UD,
    dbo.CJRR_UDFieldsDate.UDDate11 AS Date11UD,  dbo.CJRR_UDFieldsDate.UDDate12 AS Date12UD,
    dbo.CJRR_UDFieldsDate.UDDate13 AS Date13UD,  dbo.CJRR_UDFieldsDate.UDDate14 AS Date14UD,
    dbo.CJRR_UDFieldsDate.UDDate15 AS Date15UD,  dbo.CJRR_UDFieldsDate.UDDate16 AS Date16UD,
    dbo.CJRR_UDFieldsDate.UDDate17 AS Date17UD,  dbo.CJRR_UDFieldsDate.UDDate18 AS Date18UD,
    dbo.CJRR_UDFieldsDate.UDDate19 AS Date19UD,  dbo.CJRR_UDFieldsDate.UDDate20 AS Date20UD,
    dbo.CJRR_UDFieldsDate.UDDate21 AS Date21UD,  dbo.CJRR_UDFieldsDate.UDDate22 AS Date22UD,
    dbo.CJRR_UDFieldsDate.UDDate23 AS Date23UD,  dbo.CJRR_UDFieldsDate.UDDate24 AS Date24UD,
    dbo.CJRR_UDFieldsDate.UDDate25 AS Date25UD,  
    
    LU_CodeFile_1.DisplayCode AS Lookup1UD, LU_CodeFile_1.UserDescription AS Lookup1UDDesc, 
    LU_CodeFile_2.DisplayCode AS Lookup2UD, LU_CodeFile_2.UserDescription AS Lookup2UDDesc, 
    LU_CodeFile_3.DisplayCode AS Lookup3UD, LU_CodeFile_3.UserDescription AS Lookup3UDDesc, 
    LU_CodeFile_4.DisplayCode AS Lookup4UD, LU_CodeFile_4.UserDescription AS Lookup4UDDesc, 
    LU_CodeFile_5.DisplayCode AS Lookup5UD, LU_CodeFile_5.UserDescription AS Lookup5UDDesc, 
    LU_CodeFile_6.DisplayCode AS Lookup6UD, LU_CodeFile_6.UserDescription AS Lookup6UDDesc, 
    LU_CodeFile_7.DisplayCode AS Lookup7UD, LU_CodeFile_7.UserDescription AS Lookup7UDDesc, 
    LU_CodeFile_8.DisplayCode AS Lookup8UD, LU_CodeFile_8.UserDescription AS Lookup8UDDesc, 
    LU_CodeFile_9.DisplayCode AS Lookup9UD, LU_CodeFile_9.UserDescription AS Lookup9UDDesc, 
    LU_CodeFile_10.DisplayCode AS Lookup10UD, LU_CodeFile_10.UserDescription AS Lookup10UDDesc, 
    LU_CodeFile_11.DisplayCode AS Lookup11UD, LU_CodeFile_11.UserDescription AS Lookup11UDDesc, 
    LU_CodeFile_12.DisplayCode AS Lookup12UD, LU_CodeFile_12.UserDescription AS Lookup12UDDesc, 
    LU_CodeFile_13.DisplayCode AS Lookup13UD, LU_CodeFile_13.UserDescription AS Lookup13UDDesc, 
    LU_CodeFile_14.DisplayCode AS Lookup14UD, LU_CodeFile_14.UserDescription AS Lookup14UDDesc, 
    LU_CodeFile_15.DisplayCode AS Lookup15UD, LU_CodeFile_15.UserDescription AS Lookup15UDDesc, 
    LU_CodeFile_16.DisplayCode AS Lookup16UD, LU_CodeFile_16.UserDescription AS Lookup16UDDesc, 
    LU_CodeFile_17.DisplayCode AS Lookup17UD, LU_CodeFile_17.UserDescription AS Lookup17UDDesc, 
    LU_CodeFile_18.DisplayCode AS Lookup18UD, LU_CodeFile_18.UserDescription AS Lookup18UDDesc, 
    LU_CodeFile_19.DisplayCode AS Lookup19UD, LU_CodeFile_19.UserDescription AS Lookup19UDDesc, 
    LU_CodeFile_20.DisplayCode AS Lookup20UD, LU_CodeFile_20.UserDescription AS Lookup20UDDesc, 
    LU_CodeFile_21.DisplayCode AS Lookup21UD, LU_CodeFile_21.UserDescription AS Lookup21UDDesc, 
    LU_CodeFile_22.DisplayCode AS Lookup22UD, LU_CodeFile_22.UserDescription AS Lookup22UDDesc, 
    LU_CodeFile_23.DisplayCode AS Lookup23UD, LU_CodeFile_23.UserDescription AS Lookup23UDDesc, 
    LU_CodeFile_24.DisplayCode AS Lookup24UD, LU_CodeFile_24.UserDescription AS Lookup24UDDesc, 
    LU_CodeFile_25.DisplayCode AS Lookup25UD, LU_CodeFile_25.UserDescription AS Lookup25UDDesc, 
    
    dbo.CJRR_UDFieldsInteger.UDInteger1 AS Numeric1UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger2 AS Numeric2UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger3 AS Numeric3UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger4 AS Numeric4UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger5 AS Numeric5UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger6 AS Numeric6UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger7 AS Numeric7UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger8 AS Numeric8UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger9 AS Numeric9UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger10 AS Numeric10UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger11 AS Numeric11UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger12 AS Numeric12UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger13 AS Numeric13UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger14 AS Numeric14UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger15 AS Numeric15UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger16 AS Numeric16UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger17 AS Numeric17UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger18 AS Numeric18UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger19 AS Numeric19UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger20 AS Numeric20UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger21 AS Numeric21UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger22 AS Numeric22UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger23 AS Numeric23UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger24 AS Numeric24UD, 
    dbo.CJRR_UDFieldsInteger.UDInteger25 AS Numeric25UD, 
    
    dbo.CJRR_UDFieldsText.UDText1 AS Notes1UD, 
    dbo.CJRR_UDFieldsText.UDText2 AS Notes2UD, 
    dbo.CJRR_UDFieldsText.UDText3 AS Notes3UD, 
    dbo.CJRR_UDFieldsText.UDText4 AS Notes4UD, 
    dbo.CJRR_UDFieldsText.UDText5 AS Notes5UD, 
    dbo.CJRR_UDFieldsText.UDText6 AS Notes6UD,
    dbo.CJRR_UDFieldsText.UDText7 AS Notes7UD,
    dbo.CJRR_UDFieldsText.UDText8 AS Notes8UD,
    dbo.CJRR_UDFieldsText.UDText9 AS Notes9UD,
    dbo.CJRR_UDFieldsText.UDText10 AS Notes10UD,
    dbo.CJRR_UDFieldsText.UDText11 AS Notes11UD,
    dbo.CJRR_UDFieldsText.UDText12 AS Notes12UD,
    dbo.CJRR_UDFieldsText.UDText13 AS Notes13UD,
    dbo.CJRR_UDFieldsText.UDText14 AS Notes14UD,
    dbo.CJRR_UDFieldsText.UDText15 AS Notes15UD,
    dbo.CJRR_UDFieldsText.UDText16 AS Notes16UD,
    dbo.CJRR_UDFieldsText.UDText17 AS Notes17UD,
    dbo.CJRR_UDFieldsText.UDText18 AS Notes18UD,
    dbo.CJRR_UDFieldsText.UDText19 AS Notes19UD,
    dbo.CJRR_UDFieldsText.UDText20 AS Notes20UD,
    dbo.CJRR_UDFieldsText.UDText21 AS Notes21UD,
    dbo.CJRR_UDFieldsText.UDText22 AS Notes22UD,
    dbo.CJRR_UDFieldsText.UDText23 AS Notes23UD,
    dbo.CJRR_UDFieldsText.UDText24 AS Notes24UD,
    dbo.CJRR_UDFieldsText.UDText25 AS Notes25UD,
    
    dbo.CJRR_UDFieldsSmallText.UDSmallText1 AS Text1UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText2 AS Text2UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText3 AS Text3UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText4 AS Text4UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText5 AS Text5UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText6 AS Text6UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText7 AS Text7UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText8 AS Text8UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText9 AS Text9UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText10 AS Text10UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText11 AS Text11UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText12 AS Text12UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText13 AS Text13UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText14 AS Text14UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText15 AS Text15UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText16 AS Text16UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText17 AS Text17UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText18 AS Text18UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText19 AS Text19UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText20 AS Text20UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText21 AS Text21UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText22 AS Text22UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText23 AS Text23UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText24 AS Text24UD, 
    dbo.CJRR_UDFieldsSmallText.UDSmallText25 AS Text25UD, 
    
    dbo.CJRR_UDFieldsTime.UDTime1 AS Time1UD, 
    dbo.CJRR_UDFieldsTime.UDTime2 AS Time2UD, 
    dbo.CJRR_UDFieldsTime.UDTime3 AS Time3UD, 
    dbo.CJRR_UDFieldsTime.UDTime4 AS Time4UD, 
    dbo.CJRR_UDFieldsTime.UDTime5 AS Time5UD, 
    dbo.CJRR_UDFieldsTime.UDTime6 AS Time6UD, 
    dbo.CJRR_UDFieldsTime.UDTime7 AS Time7UD, 
    dbo.CJRR_UDFieldsTime.UDTime8 AS Time8UD, 
    dbo.CJRR_UDFieldsTime.UDTime9 AS Time9UD, 
    dbo.CJRR_UDFieldsTime.UDTime10 AS Time10UD, 
    dbo.CJRR_UDFieldsTime.UDTime11 AS Time11UD, 
    dbo.CJRR_UDFieldsTime.UDTime12 AS Time12UD, 
    dbo.CJRR_UDFieldsTime.UDTime13 AS Time13UD, 
    dbo.CJRR_UDFieldsTime.UDTime14 AS Time14UD, 
    dbo.CJRR_UDFieldsTime.UDTime15 AS Time15UD, 
    dbo.CJRR_UDFieldsTime.UDTime16 AS Time16UD, 
    dbo.CJRR_UDFieldsTime.UDTime17 AS Time17UD, 
    dbo.CJRR_UDFieldsTime.UDTime18 AS Time18UD, 
    dbo.CJRR_UDFieldsTime.UDTime19 AS Time19UD, 
    dbo.CJRR_UDFieldsTime.UDTime20 AS Time20UD, 
    dbo.CJRR_UDFieldsTime.UDTime21 AS Time21UD, 
    dbo.CJRR_UDFieldsTime.UDTime22 AS Time22UD, 
    dbo.CJRR_UDFieldsTime.UDTime23 AS Time23UD, 
    dbo.CJRR_UDFieldsTime.UDTime24 AS Time24UD, 
    dbo.CJRR_UDFieldsTime.UDTime25 AS Time25UD, 
       
    dbo.CJRR_Abstract.RecordID AS zzRehabLink
FROM         
    dbo.CJRR_Abstract with (nolock) LEFT OUTER JOIN

    dbo.CJRR_UDFieldsDate with (nolock) ON dbo.CJRR_Abstract.RecordID = dbo.CJRR_UDFieldsDate.RecordID LEFT OUTER JOIN
    dbo.CJRR_UDFieldsInteger with (nolock) ON dbo.CJRR_Abstract.RecordID = dbo.CJRR_UDFieldsInteger.RecordID LEFT OUTER JOIN
    dbo.CJRR_UDFieldsLookUp with (nolock) ON dbo.CJRR_Abstract.RecordID = dbo.CJRR_UDFieldsLookUp.RecordID LEFT OUTER JOIN
    dbo.CJRR_UDFieldsSmallText with (nolock) ON dbo.CJRR_Abstract.RecordID = dbo.CJRR_UDFieldsSmallText.RecordID LEFT OUTER JOIN
    dbo.CJRR_UDFieldsText with (nolock) ON dbo.CJRR_Abstract.RecordID = dbo.CJRR_UDFieldsText.RecordID LEFT OUTER JOIN
    dbo.CJRR_UDFieldsTime with (nolock) ON dbo.CJRR_Abstract.RecordID = dbo.CJRR_UDFieldsTime.RecordID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_1 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup1 = LU_CodeFile_1.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_2 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup2 = LU_CodeFile_2.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_3 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup3 = LU_CodeFile_3.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_4 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup4 = LU_CodeFile_4.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_5 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup5 = LU_CodeFile_5.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_6 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup6 = LU_CodeFile_6.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_7 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup7 = LU_CodeFile_7.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_8 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup8 = LU_CodeFile_8.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_9 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup9 = LU_CodeFile_9.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_10 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup10 = LU_CodeFile_10.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_11 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup11 = LU_CodeFile_11.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_12 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup12 = LU_CodeFile_12.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_13 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup13 = LU_CodeFile_13.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_14 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup14 = LU_CodeFile_14.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_15 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup15 = LU_CodeFile_15.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_16 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup16 = LU_CodeFile_16.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_17 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup17 = LU_CodeFile_17.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_18 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup18 = LU_CodeFile_18.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_19 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup19 = LU_CodeFile_19.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_20 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup20 = LU_CodeFile_20.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_21 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup21 = LU_CodeFile_21.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_22 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup22 = LU_CodeFile_22.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_23 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup23 = LU_CodeFile_23.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_24 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup24 = LU_CodeFile_24.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_25 with (nolock) ON dbo.CJRR_UDFieldsLookUp.UDLookup25 = LU_CodeFile_25.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_UpdateHistory_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
Create View [dbo].[CJRR_UpdateHistory_VR]
as
select
	CJRR_UpdateHistory.RecordID as zzCJRR_Link
	,Coder = U_Users.DisplayCode, CoderDesc = U_Users.UserDescription
	,Updated
	,UpdateType
	,Hospital = H_HospitalProfile.DisplayCode, HospitalDesc = H_HospitalProfile.UserDescription
from CJRR_UpdateHistory
    left join U_Users on Coder = U_Users.Code
    left join H_HospitalProfile on CJRR_UpdateHistory.HospitalID = H_HospitalProfile.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CJRR_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE View [dbo].[CJRR_VR] 
as
select
      CJRR_Abstract.BirthDate
      ,CJRR_Abstract.ChartNumber
      ,CIHIDateSent
      ,U_Users.DisplayCode as CoderNumber, U_Users.UserDescription as CoderNumberDesc
      ,LU_DiagnosisGrouping.DisplayCode as DiagnosisGrouping, LU_DiagnosisGrouping.UserDescription as DiagnosisGroupingDesc
      ,CJRR_Abstract.FirstName
      ,FiscalSurgeryYear
      ,CJRR_Abstract.FixedChartNumber
      ,LU_Gender.DisplayCode as Gender, LU_Gender.UserDescription as GenderDesc
      ,CJRR_Abstract.HealthCareNumber
      ,LU_HCNProvince.DisplayCode as HCNProvince, LU_HCNProvince.UserDescription as HCNProvinceDesc
      ,HCNVersion
      ,H_HospitalProfile.DisplayCode as Hospital, H_HospitalProfile.UserDescription as HospitalDesc
      ,LU_HospitalProvinceCode.DisplayCode as HospitalProvinceCode, LU_HospitalProvinceCode.UserDescription as HospitalProvinceCodeDesc
      ,H_InstitutionProfile.DisplayCode as InstitutionNumber, H_InstitutionProfile.UserDescription as InstitutionNumberDesc
      ,InterventionCIHI
      ,ICD_ProcFile10.DisplayCode as InterventionCode, ICD_ProcFile10.UserDescription as InterventionCodeDesc

      ,LU_IsCompleted.DisplayCode as IsCompleted, LU_IsCompleted.UserDescription as IsCompletedDesc
      ,LU_CIHICorrect.DisplayCode as IsCorrected, LU_CIHICorrect.UserDescription as IsCorrectedDesc
	  ,LU_CustomStatus.DisplayCode AS IsCustomValidated, LU_CustomStatus.UserDescription AS IsCustomValidatedDesc
      ,LU_DeleteStatus.DisplayCode as IsDeleted, LU_DeleteStatus.UserDescription as IsDeletedDesc
      ,LU_IsValidated.DisplayCode as IsValidated, LU_IsValidated.UserDescription as IsValidatedDesc
      ,LU_IsSubmited.DisplayCode as IsSubmited, LU_IsSubmited.UserDescription as IsSubmitedDesc

      ,ICD_DiagFile10.DisplayCode as MainDiagnosisCode, ICD_DiagFile10.UserDescription as MainDiagnosisCodeDesc
      ,CJRR_Abstract.LastName
      ,CJRR_Abstract.MaidenName
      ,CJRR_Abstract.MiddleName
      ,LU_AppIDs.DisplayCode as Module, LU_AppIDs.UserDescription as ModuleDesc
      ,CJRR_Abstract.PostalCode
      ,LU_PrimaryProcedureType.DisplayCode as PrimaryProcedureType, LU_PrimaryProcedureType.UserDescription as PrimaryProcedureTypeDesc
      ,LU_ReplacementType.DisplayCode as ReplacementType, LU_ReplacementType.UserDescription as ReplacementTypeDesc
      ,LU_RecordSubmitObjective.DisplayCode as RecordSubmitObjective, LU_RecordSubmitObjective.UserDescription as RecordSubmitObjectiveDesc
      ,LU_RecordType.DisplayCode as RecordType, LU_RecordType.UserDescription as RecordTypeDesc
      ,LU_RevisionReason.DisplayCode as RevisionReason, LU_RevisionReason.UserDescription as RevisionReasonDesc
      ,LU_SideLocation.DisplayCode as SideLocation, LU_SideLocation.UserDescription as SideLocationDesc
      ,SurgeonID
      ,SurgeonFirstName
      ,SurgeonLastName
      ,SurgeryDate
      ,CJRR_Abstract.LinkID as zzUniversalLink
      ,AB_Main.AbstractID as zzAbstractLink
      ,CJRR_Abstract.RecordID as zzCJRR_Link
      ,CJRR_Abstract.VolumeID as zzVolumeLink
      
from CJRR_Abstract with (nolock)
    left join AB_Main with (nolock) on CJRR_Abstract.LinkID = AB_Main.UniversalID
    left join LU_AppIDs with (nolock) on CJRR_Abstract.AppID = LU_AppIDs.Code
    left join H_HospitalProfile with (nolock) on CJRR_Abstract.HospitalID = H_HospitalProfile.Code
    left join ICD_DiagFile10 with (nolock) on MainDiagnosisCode = ICD_DiagFile10.Code
    left join ICD_ProcFile10 with (nolock) on CJRR_Abstract.InterventionCode = ICD_ProcFile10.Code
    left join LU_CodeFile LU_RecordType with (nolock) on CJRR_Abstract.RecordType = LU_RecordType.Code
    left join LU_CodeFile LU_HospitalProvinceCode with (nolock) on CJRR_Abstract.HospitalProvinceCode = LU_HospitalProvinceCode.Code 
    left join LU_CodeFile LU_RecordSubmitObjective with (nolock) on CJRR_Abstract.RecordSubmitObjective = LU_RecordSubmitObjective.Code 
    left join H_InstitutionProfile with (nolock) on CJRR_Abstract.InstitutionNumber = H_InstitutionProfile.Code
    left join LU_Provider with (nolock) on CJRR_Abstract.ProviderNumber = LU_Provider.Code
    left join LU_CodeFile LU_HCNProvince with (nolock) on CJRR_Abstract.HCNProvince = LU_HCNProvince.Code 
    left join LU_CodeFile LU_Gender with (nolock) on CJRR_Abstract.Gender = LU_Gender.Code 
    left join LU_CodeFile LU_SideLocation with (nolock) on CJRR_Abstract.SideLocation = LU_SideLocation.Code 
    left join LU_CodeFile LU_ReplacementType with (nolock) on CJRR_Abstract.ReplacementType = LU_ReplacementType.Code 
    left join LU_CodeFile LU_PrimaryProcedureType with (nolock) on CJRR_Abstract.PrimaryProcedureType = LU_PrimaryProcedureType.Code 
    left join LU_CodeFile LU_DiagnosisGrouping with (nolock) on CJRR_Abstract.DiagnosisGrouping = LU_DiagnosisGrouping.Code 
    left join LU_CodeFile LU_RevisionReason with (nolock) on CJRR_Abstract.RevisionReason = LU_RevisionReason.Code 
    left join U_Users with (nolock) on CJRR_Abstract.CoderNumber = U_Users.Code 
    left join LU_DeleteStatus with (nolock) on CJRR_Abstract.IsDeleted = LU_DeleteStatus.Code 
    left join LU_AbstractStatus LU_IsValidated with (nolock) on CJRR_Abstract.IsValidated = LU_IsValidated.Code 
    left join LU_AbstractStatus LU_IsCompleted with (nolock) on CJRR_Abstract.IsCompleted = LU_IsCompleted.Code 
    left join dbo.LU_CustomStatus with (nolock) on dbo.CJRR_Abstract.IsCustomValidated = LU_CustomStatus.Code
    left join LU_YesNoSystem LU_IsSubmited with (nolock) on CJRR_Abstract.IsSubmited = LU_IsSubmited.Code 
    left join LU_CIHICorrect with (nolock) on CJRR_Abstract.IsCorrected = LU_CIHICorrect.Code 
--QA - 00032 disable the domain securite issue
----PR - 07485
--where Suser_Sname() in (''MED2020Main'', ''WinRecs'') or CJRR_Abstract.HospitalID is null or CJRR_Abstract.HospitalID = 0
--    --EN - 00666
--    or Is_Member(nullif(ReportGroup, '''')) = 1
----    or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(CJRR_Abstract.HospitalID, 0))



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CMG_Benchmarks_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[CMG_Benchmarks_VR]
AS
SELECT     GrouperYear, FiscalYear, CMG, CMGDescription, 
    (CASE WHEN GrouperYear < 2007 THEN Complexity ELSE NULL END) AS Complexity, 
    (CASE WHEN GrouperYear > 2006 THEN Complexity ELSE NULL END) AS InpatientRILevel, CMGAgeCategory, 
    AgeGroup, 
    AgeGroupDesc = (case when GrouperYear > 2006 and isnull(CMGAgeCategory, '''') = ''''
						 then (case when AgeGroup = 1 then ''Age 0 - 17'' 
									when AgeGroup = 2 then ''Age 18 - 59'' 
									when AgeGroup = 3 then ''Age 60 - 79'' 
									when AgeGroup = 4 then ''Age 80+'' 
									else null end)
						 else null end),
    BestTotalCases, BestELOS, 
    BestReference, Best10Percentile, Best25Percentile, Best50Percentile, 
    LevelOfCare as LevelOfCareIndicator, 
    ProvTotalCases, ProvELOS, Prov10Percentile, Prov25Percentile, 
    Prov50Percentile, RegionTotalCases, RegionELOS, Region10Percentile, Region25Percentile, Region50Percentile, TargetTotalCases, TargetELOS, 
    TargetReference, Target10Percentile, Target25Percentile, Target50Percentile
FROM         dbo.CMG_Statistics



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Abstracting_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE   VIEW [dbo].[DAD_Abstracting_VR]
AS
SELECT     
    dbo.AB_ReproductiveCare.PrevTermDelivery AS [#ofPreviousDeliveries], dbo.AB_ReproductiveCare.PrevLiveBirths AS [#ofPreviousLiveBirths], 
    dbo.AB_ReproductiveCare.PrevPreTermDelivery AS [#ofPreviousPreTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevSpontAbortions AS [#ofPrevSpontaneousAbortions], 
    dbo.AB_ReproductiveCare.PrevInduceAbortions AS [#ofPrevTherapueticAbortions], '''' AS AbstractNotes, dbo.AB_Abstract.AbstractNumber, 
    Lookup2.DisplayCode AS AbstractOverflow, Lookup2.UserDescription AS AbstractOverflowDesc, LU_AbstractType.DisplayCode AS AbstractType, 
    LU_AbstractType.UserDescription AS AbstractTypeDesc, dbo.AB_Abstract.AcuteLOS, dbo.AB_Abstract.AdmitDate AS AdmissionDate, 
    dbo.AB_Abstract.AdmitTime AS AdmissionTime, Lookup3.DisplayCode AS AdmitbyAmbulance, Lookup3.UserDescription AS AdmitbyAmbulanceDesc, 
    Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, Lookup5.DisplayCode AS AdmitNursingAreaUnitLocation, 
    Lookup5.UserDescription AS AdmittingNursingAreaUnitLDesc, Lookup6.DisplayCode AS AgeCode, Lookup6.UserDescription AS AgeCodeDesc, 
    dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, dbo.AB_Abstract.DischargeAge AS AgeUponDischarge, 
    Lookup7.DisplayCode AS AgeUponDischargeCode, Lookup7.UserDescription AS AgeUponDischargeCodeDesc, Lookup8.DisplayCode AS Albumin, 
    Lookup9.DisplayCode AS AlbuminCrossMatched, Lookup9.UserDescription AS AlbuminCrossMatchedDesc, Lookup8.UserDescription AS AlbuminDesc, 
    Lookup10.DisplayCode AS AlbuminTyped, Lookup10.UserDescription AS AlbuminTypedDesc, dbo.AB_Blood.AlbuminUnits, dbo.AB_Abstract.ALCLOS, 
    LU_AlcoholDuringPregnancy.DisplayCode AS AlcoholDuringPregnancy, LU_AlcoholDuringPregnancy.UserDescription AS AlcoholDuringPregnancyDesc, 
    Lookup11.DisplayCode AS AncillaryField1, Lookup11.UserDescription AS AncillaryField1Desc, Lookup12.DisplayCode AS AncillaryField10, 
    Lookup12.UserDescription AS AncillaryField10Desc, Lookup13.DisplayCode AS AncillaryField11, Lookup13.UserDescription AS AncillaryField11Desc, 
    Lookup14.DisplayCode AS AncillaryField12, Lookup14.UserDescription AS AncillaryField12Desc, Lookup15.DisplayCode AS AncillaryField13, 
    Lookup15.UserDescription AS AncillaryField13Desc, Lookup16.DisplayCode AS AncillaryField14, Lookup16.UserDescription AS AncillaryField14Desc, 
    Lookup17.DisplayCode AS AncillaryField15, Lookup17.UserDescription AS AncillaryField15Desc, Lookup18.DisplayCode AS AncillaryField16, 
    Lookup18.UserDescription AS AncillaryField16Desc, Lookup19.DisplayCode AS AncillaryField17, Lookup19.UserDescription AS AncillaryField17Desc, 
    Lookup20.DisplayCode AS AncillaryField2, Lookup20.UserDescription AS AncillaryField2Desc, Lookup21.DisplayCode AS AncillaryField3, 
    Lookup21.UserDescription AS AncillaryField3Desc, Lookup22.DisplayCode AS AncillaryField4, Lookup22.UserDescription AS AncillaryField4Desc, 
    Lookup23.DisplayCode AS AncillaryField5, Lookup23.UserDescription AS AncillaryField5Desc, Lookup24.DisplayCode AS AncillaryField6, 
    Lookup24.UserDescription AS AncillaryField6Desc, Lookup25.DisplayCode AS AncillaryField7, Lookup25.UserDescription AS AncillaryField7Desc, 
    Lookup26.DisplayCode AS AncillaryField8, Lookup26.UserDescription AS AncillaryField8Desc, Lookup27.DisplayCode AS AncillaryField9, 
    Lookup27.UserDescription AS AncillaryField9Desc, dbo.AB_Manitoba.Apgar1Min, dbo.AB_Manitoba.Apgar5Min, 
    dbo.AB_Abstract.ArrivalDate AS ArrivalDateInER, dbo.AB_Abstract.ArrivalTime AS ArrivalTimeInER, Lookup28.DisplayCode AS AttendingPhysician, 
    Lookup28.UserDescription AS AttendingPhysicianDesc, Lookup30.DisplayCode AS AutopsyPerformed, 
    Lookup30.UserDescription AS AutopsyPerformedDesc, Lookup29.DisplayCode AS AutoTransfusion, 
    Lookup29.UserDescription AS AutoTransfusionDesc, Lookup1.DisplayCode AS AWOL, Lookup1.UserDescription AS AWOLDesc, 
    LU_BagVentilation.DisplayCode AS BagVentilation, LU_BagVentilation.UserDescription AS BagVentilationDesc, 
    Lookup31.DisplayCode AS BasicOption1, Lookup31.UserDescription AS BasicOption1Desc, Lookup32.DisplayCode AS BasicOption10, 
    Lookup32.UserDescription AS BasicOption10Desc, Lookup33.DisplayCode AS BasicOption11, Lookup33.UserDescription AS BasicOption11Desc, 
    Lookup34.DisplayCode AS BasicOption12, Lookup34.UserDescription AS BasicOption12Desc, Lookup35.DisplayCode AS BasicOption13, 
    Lookup35.UserDescription AS BasicOption13Desc, Lookup36.DisplayCode AS BasicOption14, Lookup36.UserDescription AS BasicOption14Desc, 
    Lookup37.DisplayCode AS BasicOption15, Lookup37.UserDescription AS BasicOption15Desc, Lookup38.DisplayCode AS BasicOption16, 
    Lookup38.UserDescription AS BasicOption16Desc, Lookup39.DisplayCode AS BasicOption17, Lookup39.UserDescription AS BasicOption17Desc, 
    Lookup40.DisplayCode AS BasicOption18, Lookup40.UserDescription AS BasicOption18Desc, Lookup41.DisplayCode AS BasicOption19, 
    Lookup41.UserDescription AS BasicOption19Desc, Lookup42.DisplayCode AS BasicOption2, Lookup42.UserDescription AS BasicOption2Desc, 
    Lookup43.DisplayCode AS BasicOption3, Lookup43.UserDescription AS BasicOption3Desc, Lookup44.DisplayCode AS BasicOption4, 
    Lookup44.UserDescription AS BasicOption4Desc, Lookup45.DisplayCode AS BasicOption5, Lookup45.UserDescription AS BasicOption5Desc, 
    Lookup46.DisplayCode AS BasicOption6, Lookup46.UserDescription AS BasicOption6Desc, Lookup47.DisplayCode AS BasicOption7, 
    Lookup47.UserDescription AS BasicOption7Desc, Lookup48.DisplayCode AS BasicOption8, Lookup48.UserDescription AS BasicOption8Desc, 
    Lookup49.DisplayCode AS BasicOption9, Lookup49.UserDescription AS BasicOption9Desc, dbo.AB_Abstract.BatchNumber, 
    Lookup50.DisplayCode AS BatchPeriod, Lookup50.UserDescription AS BatchPeriodDesc, dbo.AB_Abstract.BatchYear, 
    Lookup51.DisplayCode AS Between210DaysPostOp, Lookup51.UserDescription AS Between210DaysPostOpDesc, dbo.AB_Abstract.BirthDate, 
    Lookup52.DisplayCode AS BreastFeedingonDischarge, Lookup52.UserDescription AS BreastFeedingonDischargeDesc, 
    dbo.LU_CareType.DisplayCode AS CareType, dbo.LU_CareType.UserDescription AS CareTypeDesc, Lookup53.DisplayCode AS ChangeinLegalStatus, 
    Lookup53.UserDescription AS ChangeinLegalStatusDesc, dbo.AB_Abstract.ChartNumber, LU_ChestCompressions.DisplayCode AS ChestCompressions,
    LU_ChestCompressions.UserDescription AS ChestCompressionsDesc, dbo.AB_Abstract.ChiefComplaint AS ChiefComplaintUponAdmission, 
    dbo.AB_CancerStaging.ClinicalMetastasis, dbo.AB_CancerStaging.ClinicalNode, dbo.AB_CancerStaging.ClinicalTumor, 
    Lookup54.DisplayCode AS CoderNumber, Lookup54.UserDescription AS CoderNumberDesc, Lookup55.DisplayCode AS Complication, 
    Lookup55.UserDescription AS ComplicationDesc, Lookup56.DisplayCode AS Complication1, Lookup56.UserDescription AS Complication1Desc, 
    Lookup57.DisplayCode AS Complication2, Lookup57.UserDescription AS Complication2Desc, Lookup58.DisplayCode AS Complication3, 
    Lookup58.UserDescription AS Complication3Desc, Lookup58.DefaultDescription AS Complication3Desc_D, Lookup59.DisplayCode AS CoronerCase, 
    Lookup59.UserDescription AS CoronerCaseDesc, Lookup60.DisplayCode AS DataEntryCoder, Lookup60.UserDescription AS DataEntryCoderDesc, 
    dbo.AB_ReproductiveCare.LastMensesDate AS DateofLastMenses, dbo.AB_Abstract.DateReadyDischarge AS DateReadyForDischarge, 
    dbo.AB_Abstract.CIHIDateSent AS DateSenttoCIHI, LU_Days_WeekAlcoholConsumed.DisplayCode AS Days_WeekAlcoholConsumed, 
    LU_Days_WeekAlcoholConsumed.UserDescription AS Days_WeekAlcoholConsumedDesc, Lookup61.DisplayCode AS DeathInOR, 
    Lookup61.UserDescription AS DeathInORDesc, Lookup62.DisplayCode AS DeathInSCU, Lookup62.UserDescription AS DeathInSCUDesc, 
    dbo.AB_Manitoba.DeclarationNumber, dbo.AB_ReproductiveCare.DeliveryDate, dbo.AB_ReproductiveCare.DeliveryTime, 
    dbo.AB_Abstract.DischargeDate, 
    isnull(Lookup63.DisplayCode, LU_ExitCode.DisplayCode) AS DischargeDisposition, 
    isnull(Lookup63.UserDescription, LU_ExitCode.UserDescription) AS DischargeDispositionDesc, 
    Lookup64.DisplayCode AS DischNursingAreaUnitLocation, Lookup64.UserDescription AS DischargeNursingAreaUnitDesc, 
    Lookup65.DisplayCode AS DischargePlanning, Lookup65.UserDescription AS DischargePlanningDesc, dbo.AB_Abstract.DischargeTime, 
    dbo.AB_Manitoba.DrinksPerday, Lookup66.DisplayCode AS ECTTreatment, Lookup66.UserDescription AS ECTTreatmentDesc, 
    Lookup67.DisplayCode AS Education, Lookup67.UserDescription AS EducationDesc, LU_Elopements.DisplayCode AS Elopements, 
    LU_Elopements.UserDescription AS ElopementsDesc, dbo.AB_Manitoba.EmployerName, Lookup68.DisplayCode AS Employment, 
    Lookup68.UserDescription AS EmploymentDesc, dbo.AB_Abstract.EncounterNumber, Lookup69.DisplayCode AS EntryCode, 
    Lookup69.UserDescription AS EntryCodeDesc, dbo.AB_Abstract.DateLeftER AS ERDatePatientLeft, 
    dbo.AB_Abstract.DecisionAdmitDate AS ERDecisiontoAdmitDate, dbo.AB_Abstract.DecisionAdmitTime AS ERDecisiontoAdmitTime, 
    
    dbo.AB_Abstract.TimeLeftER AS ERTimePatientLeft, 
    LU_TimeLeftERUnknown.DisplayCode as ERTimePatientLeftUnknown, LU_TimeLeftERUnknown.UserDescription as ERTimePatientLeftUnknownDesc,
    
    LU_Feeding.DisplayCode AS Feeding, LU_Feeding.UserDescription AS FeedingDesc, 
    Lookup70.DisplayCode AS FinancialSupport, Lookup70.UserDescription AS FinancialSupportDesc, dbo.AB_Abstract.FinishDate, 
    dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, Lookup71.DisplayCode AS FirstOptionalTherapy, 
    Lookup71.UserDescription AS FirstOptionalTherapyDesc, dbo.AB_Therapeutic.FirstOptionUnits AS FirstOptionalUnits, 
    dbo.AB_Manitoba.FirstStageDuration, LU_FreeFlowOxygen.DisplayCode AS FreeFlowOxygen, 
    LU_FreeFlowOxygen.UserDescription AS FreeFlowOxygenDesc, Lookup72.DisplayCode AS Gender, Lookup72.UserDescription AS GenderDesc, 
    dbo.AB_Manitoba.Gestation, dbo.AB_ReproductiveCare.GestationalAge AS GestationalAgeinweeks, Lookup73.DisplayCode AS GlasgowComaScale, 
    Lookup73.UserDescription AS GlasgowComaScaleDesc, dbo.AB_Manitoba.Gravida, Lookup74.DisplayCode AS Greaterthan10DaysPostOp, 
    Lookup74.UserDescription AS Greaterthan10DaysPostOpDesc, Lookup75.DisplayCode AS HCNProvince, 
    Lookup75.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
    dbo.H_HospitalProfile.DisplayCode AS Hospital, dbo.H_HospitalProfile.UserDescription AS HospitalDesc, dbo.AB_Abstract.ICDType, 
    Lookup76.DisplayCode AS InitialOR, Lookup76.UserDescription AS InitialORDesc, dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
    Lookup77.InstCareType AS InstFromCareType, Lookup77.HospitalType AS InstFromHospType, 
    
    (case when AB_Abstract.ICDType = ''T'' then Lookup77.DisplayCode else LU_InstFrom_9.DisplayCode end) AS InstitutionFrom, 
    (case when AB_Abstract.ICDType = ''T'' then Lookup77.UserDescription else LU_InstFrom_9.UserDescription end) AS InstitutionFromDesc, 
    (case when AB_Abstract.ICDType = ''T'' then Lookup78.DisplayCode else LU_InstTo_9.DisplayCode end) AS InstitutionTo, 
    (case when AB_Abstract.ICDType = ''T'' then Lookup78.UserDescription else LU_InstTo_9.UserDescription end) AS InstitutionToDesc, 

    Lookup78.InstCareType AS InstToCareType, Lookup78.HospitalType AS InstToHospType, Lookup79.DisplayCode AS InterfaceCoder, 
    Lookup79.UserDescription AS InterfaceCoderDesc, dbo.AB_Abstract.InterfaceDate, dbo.AB_Abstract.InterfaceTime, 
    LU_IntubationNotMeconium.DisplayCode AS IntubationNotMeconium, LU_IntubationNotMeconium.UserDescription AS IntubationNotMeconiumDesc, 
    Lookup80.DisplayCode AS IsAbstractCompleted, Lookup80.UserDescription AS IsAbstractCompletedDesc, 
    Lookup81.DisplayCode AS IsAbstractCorrected, Lookup81.UserDescription AS IsAbstractCorrectedDesc, Lookup82.DisplayCode AS IsAbstractDeleted, 
    Lookup82.UserDescription AS IsAbstractDeletedDesc, Lookup83.DisplayCode AS IsAbstractSubmited, 
    Lookup83.UserDescription AS IsAbstractSubmitedDesc, Lookup84.DisplayCode AS IsAbstractValidated, 
    Lookup84.UserDescription AS IsAbstractValidatedDesc, Lookup85.DisplayCode AS IsBirthdateEstimated, 
    Lookup85.UserDescription AS IsBirthdateEstimatedDesc, dbo.AB_Abstract.LastName, LU_LeaveCertificates.DisplayCode AS LeaveCertificates, 
    LU_LeaveCertificates.UserDescription AS LeaveCertificatesDesc, Lookup86.DisplayCode AS Lessthan2DaysAfterAdmission, 
    Lookup86.UserDescription AS Lessthan2DaysAfterAdmitDesc, Lookup87.DisplayCode AS Lessthan2DaysPostOp, 
    Lookup87.UserDescription AS Lessthan2DaysPostOpDesc, dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.MaidenName, Lookup88.DisplayCode AS MaritalStatus, 
    Lookup88.UserDescription AS MaritalStatusDesc, dbo.AB_Abstract.NewbornChart AS MaternalNewbornChartNumber, 
    dbo.AB_Abstract.NewbornDischargeDate AS MaternalNewbornDischargeDate, LU_MB_Autopsy.DisplayCode AS MB_Autopsy, 
    LU_MB_Autopsy.UserDescription AS MB_AutopsyDesc, dbo.AB_Manitoba.MB_Weight, LU_MBEducation.DisplayCode AS MBEducation, 
    LU_MBEducation.UserDescription AS MBEducationDesc, LU_Meconium.DisplayCode AS Meconium, 
    LU_Meconium.UserDescription AS MeconiumDesc, LU_MedicationResuscitation.DisplayCode AS MedicationResuscitation, 
    LU_MedicationResuscitation.UserDescription AS MedicationResuscitationDesc, Lookup89.DisplayCode AS MethodofAdmission, 
    Lookup89.UserDescription AS MethodofAdmissionDesc, LU_MHInstFrom.DisplayCode AS MHFacilityTransferFrom, 
    LU_MHInstFrom.UserDescription AS MHFacilityTransferFromDesc, LU_MHInstTo.DisplayCode AS MHFacilityTransferTo, 
    LU_MHInstTo.UserDescription AS MHFacilityTransferToDesc, dbo.AB_Abstract.MiddleName, dbo.AB_Manitoba.MotherPHIN, 
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, 
    LU_NarconMaloxone.DisplayCode AS NarconMaloxone, LU_NarconMaloxone.UserDescription AS NarconMaloxoneDesc, 
    dbo.AB_MentalHealth.MentalNumberECT AS NumberofECT, Lookup90.DisplayCode AS OccupationalTherapy, 
    Lookup90.UserDescription AS OccupationalTherapyDesc, dbo.AB_Therapeutic.OccupationalUnits, Lookup92.DisplayCode AS OtherBlood, 
    Lookup92.UserDescription AS OtherBloodDesc, Lookup93.DisplayCode AS OtherBloodCrossMatched, 
    
    Lookup93.UserDescription AS OtherBloodCrossMatchedDesc, Lookup94.DisplayCode AS OtherBloodTyped, 
    Lookup94.UserDescription AS OtherBloodTypedDesc, dbo.AB_Blood.OtherBloodUnits, Lookup91.DisplayCode AS OtherMedicalDeath, 
    Lookup91.UserDescription AS OtherMedicalDeathDesc, dbo.AB_Manitoba.Parity, dbo.AB_CancerStaging.PathMetastasis AS PathologicalMetastasis, 
    dbo.AB_CancerStaging.PathNode AS PathologicalNode, dbo.AB_CancerStaging.PathTumor AS PathologicalTumor, 
    Lookup95.DisplayCode AS Physiotherapy, Lookup95.UserDescription AS PhysiotherapyDesc, dbo.AB_Therapeutic.PhysioUnits, 
    Lookup96.DisplayCode AS Plasma, Lookup96.UserDescription AS PlasmaDesc, Lookup97.DisplayCode AS PlasmaCrossMatched, 
    Lookup97.UserDescription AS PlasmaCrossMatchedDesc, Lookup98.DisplayCode AS PlasmaTyped, Lookup98.UserDescription AS PlasmaTypedDesc, 
    dbo.AB_Blood.PlasmaUnits, Lookup99.DisplayCode AS Platelets, Lookup99.UserDescription AS PlateletsDesc, 
    Lookup100.DisplayCode AS PlateletsCrossMatched, Lookup100.UserDescription AS PlateletsCrossMatchedDesc, 
    Lookup101.DisplayCode AS PlateletsTyped, Lookup101.UserDescription AS PlateletsTypedDesc, dbo.AB_Blood.PlateletsUnits, 
    dbo.AB_Abstract.PostalCode, LU_PostConceptionalFolicAcid.DisplayCode AS PostConceptionalFolicAcid, 
    LU_PostConceptionalFolicAcid.UserDescription AS PostConceptionalFolicAcidDesc, dbo.AB_Abstract.PostOpDays, 
    Lookup103.DisplayCode AS PreAdmitWorkup, Lookup103.UserDescription AS PreAdmitWorkupDesc, 
    LU_PreConceptionalFolicAcid.DisplayCode AS PreConceptionalFolicAcid, 
    LU_PreConceptionalFolicAcid.UserDescription AS PreConceptionalFolicAcidDesc, Lookup104.DisplayCode AS Pregnancy, 
    Lookup104.UserDescription AS PregnancyDesc, dbo.AB_Manitoba.PrenatalVisitDate, 
    LU_PrenatalVisitDateUnknown.DisplayCode AS PrenatalVisitDateUnknown, 
    LU_PrenatalVisitDateUnknown.UserDescription AS PrenatalVisitDateUnknownDesc, dbo.AB_Manitoba.NumberPrenatalVisits AS PrenatalVisitsNumber, 
    dbo.AB_Abstract.PreOpDays, LU_Presentation.DisplayCode AS Presentation, LU_Presentation.UserDescription AS PresentationDesc, 
    dbo.AB_Manitoba.PreviousName, Lookup105.DisplayCode AS PreviousPsychiartricAdmission, 
    Lookup105.UserDescription AS PreviousPsychiartricAdmDesc, dbo.AB_Manitoba.PrimaryAddress, dbo.AB_Manitoba.PrimaryAddress2, 
    dbo.AB_Manitoba.PrimaryPhone, 
    LU_Province.DisplayCode AS ProvinceNumber, LU_Province.UserDescription AS ProvinceNumberDesc,
    Lookup106.DisplayCode AS ReAdmitCode, Lookup106.UserDescription AS ReAdmitCodeDesc, 
    Lookup107.DisplayCode AS RedBloodCell, Lookup107.UserDescription AS RedBloodCellDesc, 
    Lookup108.DisplayCode AS RedBloodCellCrossMatched, Lookup108.UserDescription AS RedBloodCellCrossMatchedDesc, 
    Lookup109.DisplayCode AS RedBloodCellTyped, Lookup109.UserDescription AS RedBloodCellTypedDesc, 
    dbo.AB_Blood.RedCellUnits AS RedBloodCellUnits, Lookup110.DisplayCode AS ReferredTo, Lookup110.UserDescription AS ReferredToDesc, 
    dbo.AB_Abstract.RegisterNumber, dbo.AB_Manitoba.RegistrantFirstName AS RegistrantGivenName, 
    dbo.AB_Manitoba.RegistrantLastName AS RegistrantSurname, Lookup111.DisplayCode AS ReportingProvInstNumber, 
    Lookup111.UserDescription AS ReportingProvInstNumberDesc, dbo.AB_ReproductiveCare.ReprodComments AS ReproductiveCareComments, 
    Lookup112.DisplayCode AS ResidenceCode, Lookup112.UserDescription AS ResidenceCodeDesc, Lookup113.DisplayCode AS RespiratoryTherapy, 
    Lookup113.UserDescription AS RespiratoryTherapyDesc, dbo.AB_Therapeutic.RespiratoryUnits, Lookup114.DisplayCode AS ResponsiblityForPayment,
    Lookup114.UserDescription AS ResponsiblityForPaymentDesc, LU_RoutineCare.DisplayCode AS RoutineCare, 
    LU_RoutineCare.UserDescription AS RoutineCareDesc, dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup115.DisplayCode AS SecondOptionalTherapy, Lookup115.UserDescription AS SecondOptionalTherapyDesc, 
    dbo.AB_Therapeutic.SecondOptionUnits AS SecondOptionalUnits, dbo.AB_Manitoba.SecondStageDuration, 
    Lookup116.DisplayCode AS SecretVIPPatient, Lookup116.UserDescription AS SecretVIPPatientDesc, Lookup117.DisplayCode AS SiteNumber, 
    Lookup117.UserDescription AS SiteNumberDesc, dbo.AB_Manitoba.SmokingPerDay, dbo.AB_Manitoba.SmokingQuitDate, 
    LU_SmokingQuitDateUnknown.DisplayCode AS SmokingQuitDateUnknown, 
    LU_SmokingQuitDateUnknown.UserDescription AS SmokingQuitDateUnknownDesc, Lookup118.DisplayCode AS SocialServices, 
    Lookup118.UserDescription AS SocialServicesDesc, Lookup119.DisplayCode AS SourceofReferral, 
    Lookup119.UserDescription AS SourceofReferralDesc, Lookup120.DisplayCode AS SpeechTherapy, 
    Lookup120.UserDescription AS SpeechTherapyDesc, dbo.AB_Therapeutic.SpeechUnits, LU_CodeFile_1.DisplayCode AS StakeholderType, 
    LU_CodeFile_1.UserDescription AS StakeholderTypeDesc, dbo.AB_Manitoba.FirstStageDate AS StartFirstStageDate, 
    LU_FirstStageDateUnknown.DisplayCode AS StartFirstStageDateUnknown, 
    LU_FirstStageDateUnknown.UserDescription AS StartFirstStageDateUnknownDes, dbo.AB_Manitoba.FirstStageTime AS StartFirstStageTime, 
    dbo.AB_Manitoba.SecondStageDate AS StartSecondStageDate, LU_SecondStageDateUnknown.DisplayCode AS StartSecondStageDateUnknown, 
    LU_SecondStageDateUnknown.UserDescription AS StartSecondStageDateUnknown_D, dbo.AB_Manitoba.SecondStageTime AS StartSecondStageTime, 

    Lookup121.DisplayCode AS Sterilization, 
    Lookup121.UserDescription AS SterilizationDesc, 

    dbo.AB_Abstract.RecordType AS SubmissionType, 
    Lookup122.DisplayCode AS SubsequentOR, Lookup122.UserDescription AS SubsequentORDesc, Lookup123.DisplayCode AS Suicide, 
    Lookup123.UserDescription AS SuicideDesc, dbo.AB_CancerStaging.SummaryStage, Lookup124.DisplayCode AS SurgicalCase, 
    Lookup124.UserDescription AS SurgicalCaseDesc, 
    Lookup125.DisplayCode AS TransfusionGiven, 
    Lookup125.UserDescription AS TransfusionGivenDesc, Lookup126.DisplayCode AS Trauma, Lookup126.UserDescription AS TraumaDesc, 
    Lookup127.DisplayCode AS TSICoder, Lookup127.UserDescription AS TSICoderDesc, dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, 
    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, Lookup128.DisplayCode AS UnplannedReadmission, 
    Lookup128.UserDescription AS UnplannedReadmissionDesc, 
    dbo.AB_Abstract.WaitTimeER as WaitTimeInEmerg, dbo.AB_Abstract.Weight AS Weightingrams, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         
     dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_1 with (nolock) on LU_CodeFile_1.Code = dbo.AB_Abstract.StakeHolder LEFT OUTER JOIN
    dbo.AB_Manitoba with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Manitoba.AbstractID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Meconium with (nolock) on LU_Meconium.Code = dbo.AB_Manitoba.Meconium LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Feeding with (nolock) on dbo.AB_Manitoba.Feeding = LU_Feeding.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_ChestCompressions with (nolock) on dbo.AB_Manitoba.ChestCompressions = LU_ChestCompressions.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_NarconMaloxone with (nolock) on dbo.AB_Manitoba.NarconMaloxone = LU_NarconMaloxone.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_MedicationResuscitation with (nolock) on dbo.AB_Manitoba.MedicationResuscitation = LU_MedicationResuscitation.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_IntubationNotMeconium with (nolock) on dbo.AB_Manitoba.IntubationNotMeconium = LU_IntubationNotMeconium.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_BagVentilation with (nolock) on dbo.AB_Manitoba.BagVentilation = LU_BagVentilation.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_FreeFlowOxygen with (nolock) on dbo.AB_Manitoba.FreeFlowOxygen = LU_FreeFlowOxygen.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_RoutineCare with (nolock) on dbo.AB_Manitoba.RoutineCare = LU_RoutineCare.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Presentation with (nolock) on dbo.AB_Manitoba.Presentation = LU_Presentation.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_SecondStageDateUnknown with (nolock) on dbo.AB_Manitoba.SecondStageDateUnknown = LU_SecondStageDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_FirstStageDateUnknown with (nolock) on dbo.AB_Manitoba.FirstStageDateUnknown = LU_FirstStageDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PostConceptionalFolicAcid with (nolock) on dbo.AB_Manitoba.PostConceptionalFolicAcid = LU_PostConceptionalFolicAcid.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PreConceptionalFolicAcid with (nolock) on dbo.AB_Manitoba.PreConceptionalFolicAcid = LU_PreConceptionalFolicAcid.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Days_WeekAlcoholConsumed with (nolock) on dbo.AB_Manitoba.Days_WeekAlcoholConsumed = LU_Days_WeekAlcoholConsumed.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AlcoholDuringPregnancy with (nolock) on dbo.AB_Manitoba.AlcoholDuringPregnancy = LU_AlcoholDuringPregnancy.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_SmokingQuitDateUnknown with (nolock) on dbo.AB_Manitoba.SmokingQuitDateUnknown = LU_SmokingQuitDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MBEducation with (nolock) on dbo.AB_Manitoba.ObsEducation = LU_MBEducation.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PrenatalVisitDateUnknown with (nolock) on dbo.AB_Manitoba.PrenatalVisitDateUnknown = LU_PrenatalVisitDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_LeaveCertificates with (nolock) on dbo.AB_Manitoba.LeaveCertificates = LU_LeaveCertificates.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_Elopements with (nolock) on dbo.AB_Manitoba.Elopements = LU_Elopements.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MB_Autopsy with (nolock) on dbo.AB_Manitoba.MB_Autopsy = LU_MB_Autopsy.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MHInstTo with (nolock) on dbo.AB_Manitoba.MHInstTo = LU_MHInstTo.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MHInstFrom with (nolock) on dbo.AB_Manitoba.MHInstFrom = LU_MHInstFrom.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AbstractType with (nolock) on dbo.AB_Manitoba.AbstractType = LU_AbstractType.Code LEFT OUTER JOIN 
    dbo.LU_CareType with (nolock) on dbo.AB_Abstract.CareType = dbo.LU_CareType.Code LEFT OUTER JOIN
    dbo.LU_AbstractOverflow Lookup2 with (nolock) on dbo.AB_Abstract.AbstractOverflow = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_NurseArea Lookup5 with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup6 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup7 with (nolock) on dbo.AB_Abstract.DischargeAgeCode = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup28 with (nolock) on dbo.AB_Abstract.AttendingPhysician = Lookup28.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup50 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup54 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup54.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup55 with (nolock) on dbo.AB_Abstract.Complication = Lookup55.Code LEFT OUTER JOIN
    dbo.U_Users Lookup60 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_I Lookup63 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup63.Code LEFT OUTER JOIN
    dbo.LU_NurseArea Lookup64 with (nolock) on dbo.AB_Abstract.DischargeNurseArea = Lookup64.Code LEFT OUTER JOIN
    dbo.LU_TherDischPlan Lookup65 with (nolock) on dbo.AB_Abstract.DischargePlanning = Lookup65.Code LEFT OUTER JOIN
    dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup73 with (nolock) on dbo.AB_Abstract.GlasgowComaScale = Lookup73.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN

    dbo.LU_Institution_10 Lookup77 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup77.Code LEFT OUTER JOIN
    dbo.LU_Institution_9 LU_InstFrom_9 with (nolock) on dbo.AB_Abstract.InstitutionFrom = LU_InstFrom_9.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup78 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup78.Code LEFT OUTER JOIN
    dbo.LU_Institution_9 LU_InstTo_9 with (nolock) on dbo.AB_Abstract.InstitutionTo = LU_InstTo_9.Code LEFT OUTER JOIN

    dbo.U_Users Lookup79 with (nolock) on dbo.AB_Abstract.InterfaceCoder = Lookup79.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup80 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup80.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup81 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup81.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup82 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup82.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup83 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup84 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup85 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_MaritalStatus Lookup88 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup88.Code LEFT OUTER JOIN
    dbo.LU_TherPreAdmitWorkUp Lookup103 with (nolock) on dbo.AB_Abstract.PreAdmitWorkUp = Lookup103.Code LEFT OUTER JOIN
    dbo.LU_ReAdmitCode Lookup106 with (nolock) on dbo.AB_Abstract.ReAdmitCode = Lookup106.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup111 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup111.Code LEFT OUTER JOIN

    dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup116 with (nolock) on dbo.AB_Abstract.Secret = Lookup116.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup117 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup117.Code LEFT OUTER JOIN
    dbo.LU_TherSocialService Lookup118 with (nolock) on dbo.AB_Abstract.SocialService = Lookup118.Code LEFT OUTER JOIN
    dbo.LU_SurgicalCode Lookup124 with (nolock) on dbo.AB_Abstract.SurgicalCase = Lookup124.Code LEFT OUTER JOIN
    dbo.U_Users Lookup127 with (nolock) on dbo.AB_Abstract.TSICoder = Lookup127.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup128 with (nolock) on dbo.AB_Abstract.UnplanReAdmit = Lookup128.Code LEFT OUTER JOIN
    dbo.AB_Ancillary with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Ancillary.AbstractID LEFT OUTER JOIN
    dbo.LU_Ancillary1 Lookup11 with (nolock) on dbo.AB_Ancillary.AncillaryField1 = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Ancillary10 Lookup12 with (nolock) on dbo.AB_Ancillary.AncillaryField10 = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_Ancillary11 Lookup13 with (nolock) on dbo.AB_Ancillary.AncillaryField11 = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_Ancillary12 Lookup14 with (nolock) on dbo.AB_Ancillary.AncillaryField12 = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_Ancillary13 Lookup15 with (nolock) on dbo.AB_Ancillary.AncillaryField13 = Lookup15.Code LEFT OUTER JOIN
    dbo.LU_Ancillary14 Lookup16 with (nolock) on dbo.AB_Ancillary.AncillaryField14 = Lookup16.Code LEFT OUTER JOIN
    dbo.LU_Ancillary15 Lookup17 with (nolock) on dbo.AB_Ancillary.AncillaryField15 = Lookup17.Code LEFT OUTER JOIN
    dbo.LU_Ancillary16 Lookup18 with (nolock) on dbo.AB_Ancillary.AncillaryField16 = Lookup18.Code LEFT OUTER JOIN
    dbo.LU_Ancillary17 Lookup19 with (nolock) on dbo.AB_Ancillary.AncillaryField17 = Lookup19.Code LEFT OUTER JOIN
    dbo.LU_Ancillary2 Lookup20 with (nolock) on dbo.AB_Ancillary.AncillaryField2 = Lookup20.Code LEFT OUTER JOIN
    dbo.LU_Ancillary3 Lookup21 with (nolock) on dbo.AB_Ancillary.AncillaryField3 = Lookup21.Code LEFT OUTER JOIN
    dbo.LU_Ancillary4 Lookup22 with (nolock) on dbo.AB_Ancillary.AncillaryField4 = Lookup22.Code LEFT OUTER JOIN
    dbo.LU_Ancillary5 Lookup23 with (nolock) on dbo.AB_Ancillary.AncillaryField5 = Lookup23.Code LEFT OUTER JOIN
    dbo.LU_Ancillary6 Lookup24 with (nolock) on dbo.AB_Ancillary.AncillaryField6 = Lookup24.Code LEFT OUTER JOIN
    dbo.LU_Ancillary7 Lookup25 with (nolock) on dbo.AB_Ancillary.AncillaryField7 = Lookup25.Code LEFT OUTER JOIN
    dbo.LU_Ancillary8 Lookup26 with (nolock) on dbo.AB_Ancillary.AncillaryField8 = Lookup26.Code LEFT OUTER JOIN
    dbo.LU_Ancillary9 Lookup27 with (nolock) on dbo.AB_Ancillary.AncillaryField9 = Lookup27.Code LEFT OUTER JOIN
    dbo.AB_BasicOption with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_BasicOption.AbstractID LEFT OUTER JOIN
    dbo.LU_BasicOption1 Lookup31 with (nolock) on dbo.AB_BasicOption.BasicOption1 = Lookup31.Code LEFT OUTER JOIN
    dbo.LU_BasicOption10 Lookup32 with (nolock) on dbo.AB_BasicOption.BasicOption10 = Lookup32.Code LEFT OUTER JOIN
    dbo.LU_BasicOption11 Lookup33 with (nolock) on dbo.AB_BasicOption.BasicOption11 = Lookup33.Code LEFT OUTER JOIN
    dbo.LU_BasicOption12 Lookup34 with (nolock) on dbo.AB_BasicOption.BasicOption12 = Lookup34.Code LEFT OUTER JOIN
    dbo.LU_BasicOption13 Lookup35 with (nolock) on dbo.AB_BasicOption.BasicOption13 = Lookup35.Code LEFT OUTER JOIN
    dbo.LU_BasicOption14 Lookup36 with (nolock) on dbo.AB_BasicOption.BasicOption14 = Lookup36.Code LEFT OUTER JOIN
    dbo.LU_BasicOption15 Lookup37 with (nolock) on dbo.AB_BasicOption.BasicOption15 = Lookup37.Code LEFT OUTER JOIN
    dbo.LU_BasicOption16 Lookup38 with (nolock) on dbo.AB_BasicOption.BasicOption16 = Lookup38.Code LEFT OUTER JOIN
    dbo.LU_BasicOption17 Lookup39 with (nolock) on dbo.AB_BasicOption.BasicOption17 = Lookup39.Code LEFT OUTER JOIN
    dbo.LU_BasicOption18 Lookup40 with (nolock) on dbo.AB_BasicOption.BasicOption18 = Lookup40.Code LEFT OUTER JOIN
    dbo.LU_BasicOption19 Lookup41 with (nolock) on dbo.AB_BasicOption.BasicOption19 = Lookup41.Code LEFT OUTER JOIN
    dbo.LU_BasicOption2 Lookup42 with (nolock) on dbo.AB_BasicOption.BasicOption2 = Lookup42.Code LEFT OUTER JOIN
    dbo.LU_BasicOption3 Lookup43 with (nolock) on dbo.AB_BasicOption.BasicOption3 = Lookup43.Code LEFT OUTER JOIN
    dbo.LU_BasicOption4 Lookup44 with (nolock) on dbo.AB_BasicOption.BasicOption4 = Lookup44.Code LEFT OUTER JOIN
    dbo.LU_BasicOption5 Lookup45 with (nolock) on dbo.AB_BasicOption.BasicOption5 = Lookup45.Code LEFT OUTER JOIN
    dbo.LU_BasicOption6 Lookup46 with (nolock) on dbo.AB_BasicOption.BasicOption6 = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_BasicOption7 Lookup47 with (nolock) on dbo.AB_BasicOption.BasicOption7 = Lookup47.Code LEFT OUTER JOIN
    dbo.LU_BasicOption8 Lookup48 with (nolock) on dbo.AB_BasicOption.BasicOption8 = Lookup48.Code LEFT OUTER JOIN
    dbo.LU_BasicOption9 Lookup49 with (nolock) on dbo.AB_BasicOption.BasicOption9 = Lookup49.Code LEFT OUTER JOIN
    dbo.AB_Blood with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Blood.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup8 with (nolock) on dbo.AB_Blood.Albumin = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup9 with (nolock) on dbo.AB_Blood.AlbuminXMatch = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup10 with (nolock) on dbo.AB_Blood.AlbuminTyped = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup29 with (nolock) on dbo.AB_Blood.AutoTransfusion = Lookup29.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup92 with (nolock) on dbo.AB_Blood.OtherBlood = Lookup92.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup93 with (nolock) on dbo.AB_Blood.OtherBloodXMatch = Lookup93.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup94 with (nolock) on dbo.AB_Blood.OtherBloodTyped = Lookup94.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup96 with (nolock) on dbo.AB_Blood.Plasma = Lookup96.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup97 with (nolock) on dbo.AB_Blood.PlasmaXMatch = Lookup97.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup98 with (nolock) on dbo.AB_Blood.PlasmaTyped = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup99 with (nolock) on dbo.AB_Blood.Platelets = Lookup99.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup100 with (nolock) on dbo.AB_Blood.PlateletsXMatch = Lookup100.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup101 with (nolock) on dbo.AB_Blood.PlateletsTyped = Lookup101.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup107 with (nolock) on dbo.AB_Blood.RedBloodCell = Lookup107.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup108 with (nolock) on dbo.AB_Blood.RedCellXMatch = Lookup108.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup109 with (nolock) on dbo.AB_Blood.RedCellTyped = Lookup109.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup125 with (nolock) on dbo.AB_Blood.TransfusionIndicator = Lookup125.Code LEFT OUTER JOIN
    dbo.AB_DeathInformation with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_DeathInformation.AbstractID LEFT OUTER JOIN
    dbo.LU_AutopsyDeath Lookup30 with (nolock) on dbo.AB_DeathInformation.AutopsyPerformed = Lookup30.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup51 with (nolock) on dbo.AB_DeathInformation.DeathTwoTenPO = Lookup51.Code LEFT OUTER JOIN
    dbo.LU_CoronerCase Lookup59 with (nolock) on dbo.AB_DeathInformation.CoronerCase = Lookup59.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup61 with (nolock) on dbo.AB_DeathInformation.DeathInOR = Lookup61.Code LEFT OUTER JOIN
    dbo.LU_SCU_Death Lookup62 with (nolock) on dbo.AB_DeathInformation.DeathInSCU = Lookup62.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup74 with (nolock) on dbo.AB_DeathInformation.DeathGreaterTenPO = Lookup74.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup86 with (nolock) on dbo.AB_DeathInformation.DeathAfterAdmit = Lookup86.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup87 with (nolock) on Lookup87.Code = dbo.AB_DeathInformation.DeathLessTwoPO LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup91 with (nolock) on dbo.AB_DeathInformation.OtherDeath = Lookup91.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup104 with (nolock) on Lookup104.Code = dbo.AB_DeathInformation.PregnancyDeath LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup126 with (nolock) on dbo.AB_DeathInformation.TraumaDeath = Lookup126.Code LEFT OUTER JOIN
    dbo.AB_MentalHealth with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_MentalHealth.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup1 with (nolock) on dbo.AB_MentalHealth.MentalAWOL = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_MentalLegalStatus Lookup53 with (nolock) on dbo.AB_MentalHealth.MentalLegalStatus = Lookup53.Code LEFT OUTER JOIN
    dbo.LU_YesNoNumeric Lookup66 with (nolock) on Lookup66.Code = dbo.AB_MentalHealth.MentalECTTreatment LEFT OUTER JOIN
    dbo.LU_MentalEducation Lookup67 with (nolock) on dbo.AB_MentalHealth.MentalEducation = Lookup67.Code LEFT OUTER JOIN
    dbo.LU_MentalEmployment Lookup68 with (nolock) on dbo.AB_MentalHealth.MentalEmployment = Lookup68.Code LEFT OUTER JOIN
    dbo.LU_MentalFinancial Lookup70 with (nolock) on Lookup70.Code = dbo.AB_MentalHealth.MentalFinancial LEFT OUTER JOIN
    dbo.LU_MentalAdmitMethod Lookup89 with (nolock) on dbo.AB_MentalHealth.MentalAdmitMethod = Lookup89.Code LEFT OUTER JOIN
    dbo.LU_MentalPrevPsych Lookup105 with (nolock) on dbo.AB_MentalHealth.MentalPrevPsych = Lookup105.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup110 with (nolock) on dbo.AB_MentalHealth.MentalReferralTo = Lookup110.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup119 with (nolock) on dbo.AB_MentalHealth.MentalReferralSource = Lookup119.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup123 with (nolock) on dbo.AB_MentalHealth.MentalSuicide = Lookup123.Code LEFT OUTER JOIN 
    dbo.AB_Therapeutic with (nolock) on dbo.AB_Therapeutic.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_TherOption1 Lookup71 with (nolock) on dbo.AB_Therapeutic.FirstOptionTherapy = Lookup71.Code LEFT OUTER JOIN
    dbo.LU_TherOccupation Lookup90 with (nolock) on dbo.AB_Therapeutic.OccupationalTherapy = Lookup90.Code LEFT OUTER JOIN
    dbo.LU_TherPhysio Lookup95 with (nolock) on dbo.AB_Therapeutic.PhysioTherapy = Lookup95.Code LEFT OUTER JOIN
    dbo.LU_TherRespiratory Lookup113 with (nolock) on dbo.AB_Therapeutic.RespiratoryTherapy = Lookup113.Code LEFT OUTER JOIN
    dbo.LU_TherOption2 Lookup115 with (nolock) on dbo.AB_Therapeutic.SecondOptionTherapy = Lookup115.Code LEFT OUTER JOIN
    dbo.LU_TherSpeech Lookup120 with (nolock) on Lookup120.Code = dbo.AB_Therapeutic.SpeechTherapy LEFT OUTER JOIN
    dbo.AB_ReproductiveCare with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_ReproductiveCare.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup52 with (nolock) on dbo.AB_ReproductiveCare.BreastFeeding = Lookup52.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup56 with (nolock) on dbo.AB_ReproductiveCare.Complication1 = Lookup56.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup57 with (nolock) on dbo.AB_ReproductiveCare.Complication2 = Lookup57.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup58 with (nolock) on dbo.AB_ReproductiveCare.Complication3 = Lookup58.Code LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup76 with (nolock) on Lookup76.Code = dbo.AB_ReproductiveCare.InitialOR LEFT OUTER JOIN

    dbo.LU_ReprodSterilization Lookup121 with (nolock) on Lookup121.Code = dbo.AB_ReproductiveCare.Sterilization LEFT OUTER JOIN

    dbo.LU_ReprodOR Lookup122 with (nolock) on dbo.AB_ReproductiveCare.SubsequentOR = Lookup122.Code LEFT OUTER JOIN
    dbo.AB_CancerStaging with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_CancerStaging.AbstractID LEFT OUTER JOIN
    dbo.H_HospitalProfile with (nolock) on dbo.AB_Abstract.HospitalID = dbo.H_HospitalProfile.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TimeLeftERUnknown with (nolock) on dbo.AB_Abstract.TimeLeftERUnknown = LU_TimeLeftERUnknown.Code LEFT OUTER JOIN
    dbo.LU_ExitCode with (nolock) on LU_ExitCode.Code = AB_Abstract.ExitCode LEFT OUTER JOIN
    dbo.LU_Province with (nolock) on LU_Province.Code = AB_Abstract.ProvinceNumber
Where AB_Abstract.CareType in (1, 2)
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_CMG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE   VIEW [dbo].[DAD_CMG_VR]
AS
SELECT     
    dbo.AB_CMG.AcuteQuartile AS Acute_Quartile, 
    dbo.AB_CMG.CMG, 
    dbo.AB_CMG.CMG_Description, 
    dbo.AB_CMG.CMG_ELOS, 
    dbo.AB_CMG.CMG_Split, 
    dbo.AB_CMG.CMG_Year, 
    dbo.AB_CMG.Complexity, 
    dbo.CMG_LU_Complexity.UserDescription AS Complexity_Description, 
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_DiagFile10.DisplayCode
                              when ''9'' then dbo.ICD_DiagFile9.DisplayCode
                              when ''C'' then dbo.ICD_DiagFile9cm.DisplayCode
     end) AS Diagnosis_Code, 
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_DiagFile10.UserDescription
                              when ''9'' then dbo.ICD_DiagFile9.UserDescription
                              when ''C'' then dbo.ICD_DiagFile9cm.UserDescription
     end) AS Diagnosis_Description, 
    ICD_DiagFile10.ShortDescription as Diagnosis_CodeShortDesc,
    dbo.LU_DiagnosisType.DisplayCode AS Diagnosis_Type, 
    dbo.LU_DiagnosisType.UserDescription AS Diagnosis_Type_Desc, 
    dbo.AB_CMG.CMGFiftiethPercent AS FiftiethPercentile, 
    dbo.AB_CMG.ICD_Type, 
    dbo.AB_CMG.MCC, 
    dbo.CMG_LU_MCCDescription.UserDescription AS MCC_Description, 
    dbo.AB_CMG.MCC_Surg, 
    dbo.AB_CMG.CMGModelType AS ModelType, 
    dbo.AB_CMG.MOHQuartile AS MOH_Quartile, 
    dbo.AB_CMG.MOH_Dollar, dbo.AB_CMG.MOH_RIW, 
    dbo.AB_CMG.OccurrenceNumber AS Occurrence_Number, 
    dbo.AB_CMG.CMG_RIW AS RIW, 
    dbo.AB_CMG.RIW_Dollar, 
    dbo.AB_CMG.CMGTenthPercent AS TenthPercentile, 
    dbo.AB_CMG.CMG_Trim AS [Trim], 
    dbo.AB_CMG.CMGTwentyFifthPercent AS TwentyFifthPercentile, 
    dbo.AB_CMG.AbstractID AS zzAbstractLink
FROM AB_Abstract with (nolock) inner join 
    dbo.AB_CMG with (nolock) on AB_Abstract.AbstractID = AB_CMG.AbstractID LEFT JOIN 
    dbo.CMG_LU_Complexity with (nolock) on dbo.CMG_LU_Complexity.DisplayCode = dbo.AB_CMG.Complexity LEFT OUTER JOIN
    dbo.CMG_LU_MCCDescription with (nolock) on dbo.AB_CMG.MCC = dbo.CMG_LU_MCCDescription.DisplayCode LEFT OUTER JOIN
    dbo.ICD_DiagFile10 with (nolock) on dbo.AB_CMG.Diagnosis_Code = dbo.ICD_DiagFile10.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile9 with (nolock) on dbo.AB_CMG.Diagnosis_Code = dbo.ICD_DiagFile9.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile9cm with (nolock) on dbo.AB_CMG.Diagnosis_Code = dbo.ICD_DiagFile9cm.Code LEFT OUTER JOIN
    dbo.LU_DiagnosisType with (nolock) on dbo.AB_CMG.Diagnosis_Type = dbo.LU_DiagnosisType.Code
Where AB_Abstract.CareType = 1 







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE     VIEW [dbo].[DAD_Diagnosis_VR]
AS
SELECT  
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_DiagFile10.DisplayCode 
        when ''9'' then dbo.ICD_DiagFile9.DisplayCode 
        when ''C'' then dbo.ICD_DiagFile9cm.DisplayCode 
     end) AS DiagnosisCode, 
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_DiagFile10.UserDescription 
        when ''9'' then dbo.ICD_DiagFile9.UserDescription 
        when ''C'' then dbo.ICD_DiagFile9cm.UserDescription 
     end) AS DiagnosisCodeDesc, 
    ICD_DiagFile10.ShortDescription as DiagnosisCodeShortDesc,
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_DiagFile10.ICD9cm end) AS DiagnosisICD9cmEquivalent, 
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_DiagFile10.ICD9 end) AS DiagnosisICD9Equivalent, 
    dbo.AB_Diagnosis.DiagnosisOccurrence, 
    Lookup1.DisplayCode AS DiagnosisPrefix, 
    Lookup1.UserDescription AS DiagnosisPrefixDesc, 
    Lookup2.DisplayCode AS DiagnosisType, 
    Lookup2.UserDescription AS DiagnosisTypeDesc, 
    dbo.AB_Diagnosis.AbstractID AS zzAbstractLink
FROM dbo.AB_Diagnosis with (nolock) INNER JOIN
    dbo.AB_Abstract with (nolock) on dbo.AB_Diagnosis.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.ICD_DiagFile10 with (nolock) on dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile10.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile9 with (nolock) on dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile9.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile9cm with (nolock) on dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile9cm.Code LEFT OUTER JOIN
    dbo.LU_DiagnosisPrefix Lookup1 with (nolock) on dbo.AB_Diagnosis.DiagnosisPrefix = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_DiagnosisType Lookup2 with (nolock) on dbo.AB_Diagnosis.DiagnosisType = Lookup2.Code
Where AB_Abstract.CareType in (1, 2)

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_DPG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  view [dbo].[DAD_DPG_VR]
as
select 
    DPGOccurrence = dpg.OccurrenceNumber, 
    DPG_Year, 
    DPG, 
    DPG_RIW, 
    DPG_MOH_RIW, 
    DPG_Description, 
    zzAbstractLink = dpg.AbstractID
from AB_DPG dpg with (nolock) 
    Inner join AB_Abstract with (nolock) on dpg.AbstractID = AB_Abstract.AbstractID
where AB_Abstract.Caretype = 2

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE    VIEW [dbo].[DAD_Interventions_VR]
AS
SELECT     
    Lookup1.DisplayCode AS AnaestheticTechnique, 
    Lookup1.UserDescription AS AnaestheticTechniqueDesc, 
    Lookup2.DisplayCode AS AnaesthetistID, 
    Lookup2.UserDescription AS AnaesthetistIDDesc, 
    Lookup3.DisplayCode AS EUL, 
    Lookup3.UserDescription AS EULDesc, 
    Lookup4.DisplayCode AS Extra, 
    Lookup4.UserDescription AS ExtraDesc, 
    Lookup5.DisplayCode AS IntervAttribExtent, 
    Lookup5.UserDescription AS IntervAttribExtentDesc, 
    Lookup6.DisplayCode AS IntervAttribLocation, 
    Lookup6.UserDescription AS IntervAttribLocationDesc, 
    Lookup7.DisplayCode AS IntervAttribStatus, 
    Lookup7.UserDescription AS IntervAttribStatusDesc, 
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_ProcFile10.DisplayCode 
        when ''9'' then dbo.ICD_ProcFile9.DisplayCode 
        when ''C'' then dbo.ICD_ProcFile9CM.DisplayCode 
     end) AS IntervCode, 
    (case AB_Abstract.ICDType 
        when ''T'' then dbo.ICD_ProcFile10.UserDescription 
        when ''9'' then dbo.ICD_ProcFile9.UserDescription 
        when ''C'' then dbo.ICD_ProcFile9CM.UserDescription 
     end) AS IntervCodeDesc, 
    ICD_ProcFile10.ShortDescription as IntervCodeShortDesc,
    dbo.AB_Intervention.IntervDate, 
    dbo.AB_Intervention.IntervDateIn, 
    dbo.AB_Intervention.IntervDateOut, 
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_ProcFile10.ICD9 end) AS IntervICD9Equivalent, 
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_ProcFile10.ICD9cm end) AS IntervICD9cmEquivalent, 
    Lookup8.DisplayCode AS IntervLocation, 
    Lookup8.UserDescription AS IntervLocationDesc, 
    dbo.AB_Intervention.IntervOccurrence, 
    Lookup9.DisplayCode AS IntervProviderNumber, 
    Lookup9.UserDescription AS IntervProviderNumberDesc, 
    Lookup15.DisplayCode AS IntervProviderService, 
    Lookup15.UserDescription AS IntervProviderServiceDesc, 
    Lookup10.DisplayCode AS IntervProviderSpecialty, 
    Lookup10.UserDescription AS IntervProviderSpecialtyDesc, 
    dbo.AB_Intervention.IntervTimeIn, 
    dbo.AB_Intervention.IntervTimeMinutes AS IntervTimeinMinutes, 
    dbo.AB_Intervention.IntervTimeOut, 
    Lookup11.DisplayCode AS OOHIndicator, 
    Lookup11.UserDescription AS OOHIndicatorDesc, 
    (case when AB_Abstract.ICDType = ''T'' then Lookup12.DisplayCode 
          else LU_Institution_9.DisplayCode end) AS OOHInstitutionNumber, 
    (case when AB_Abstract.ICDType = ''T'' then Lookup12.UserDescription 
          else LU_Institution_9.UserDescription end) AS OOHInstitutionNumberDesc, 
    Lookup13.DisplayCode AS TissueCode, 
    Lookup13.UserDescription AS TissueCodeDesc, 
    Lookup14.DisplayCode AS UnplannedReturntoOR, 
    Lookup14.UserDescription AS UnplannedReturntoORDesc, 
    dbo.AB_Intervention.AbstractID AS zzAbstractLink
FROM  AB_Abstract with (nolock) inner join        
    dbo.AB_Intervention with (nolock) on AB_Abstract.AbstractID = AB_Intervention.AbstractID LEFT OUTER JOIN
    dbo.ICD_ProcFile10 with (nolock) on dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile10.Code LEFT OUTER JOIN
    dbo.ICD_ProcFile9 with (nolock) on dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile9.Code LEFT OUTER JOIN
    dbo.ICD_ProcFile9cm with (nolock) on dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile9cm.Code LEFT OUTER JOIN
    dbo.LU_AnaestTechnique Lookup1 with (nolock) on dbo.AB_Intervention.IntervAnaestTechnique = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup2 with (nolock) on dbo.AB_Intervention.IntervAnaestID = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_IntervEUL Lookup3 with (nolock) on dbo.AB_Intervention.IntervEUL = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_IntervExtra Lookup4 with (nolock) on dbo.AB_Intervention.IntervExtra = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_IntervAttExtent Lookup5 with (nolock) on dbo.AB_Intervention.IntervAttribExtent = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_IntervAttLocation Lookup6 with (nolock) on dbo.AB_Intervention.IntervAttribLocation = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_IntervAttStatus Lookup7 with (nolock) on dbo.AB_Intervention.IntervAttribStatus = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_IntervLocation_AI Lookup8 with (nolock) on dbo.AB_Intervention.IntervLocation = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup9 with (nolock) on dbo.AB_Intervention.IntervProviderNumber = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty Lookup10 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup11 with (nolock) on dbo.AB_Intervention.IntervOOHIndicator = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup12 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_Institution_9 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = LU_Institution_9.Code LEFT OUTER JOIN
    dbo.LU_IntervTissue Lookup13 with (nolock) on dbo.AB_Intervention.IntervTissueCode = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup14 with (nolock) on dbo.AB_Intervention.IntervUnplanReturn = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_ProviderService Lookup15 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup15.Code
Where   AB_Abstract.CareType in (1, 2)  









' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_MB_ALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[DAD_MB_ALC_VR]
AS 
SELECT     
    dbo.AB_MB_ALC.ALCDays, 
    dbo.AB_MB_ALC.Occurrence AS ALCOccurrence, 
    dbo.LU_CodeFile.DisplayCode AS ALCReasonCode, 
    dbo.LU_CodeFile.UserDescription AS ALCReasonCodeDesc, 
    dbo.AB_MB_ALC.DateDesignatedALC, dbo.AB_MB_ALC.DateReassignedAcute, 
    dbo.AB_MB_ALC.AbstractID AS zzAbstractLink
FROM dbo.AB_MB_ALC with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile with (nolock) on dbo.AB_MB_ALC.ALCReasonCode = dbo.LU_CodeFile.Code







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_MB_FacilityStudy_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[DAD_MB_FacilityStudy_VR]
AS 
SELECT     
    FacilityDateStudy, 
    FacilityStudyCode, 
    Occurrence AS FacilityStudyOccurrence, 
    AbstractID AS zzAbstractLink
FROM         dbo.AB_MB_FacilityStudy with (nolock)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_MB_NonALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[DAD_MB_NonALC_VR]
AS 
SELECT     
    dbo.AB_MB_NonALC.DaysNonALCDelay, 
    dbo.LU_CodeFile.DisplayCode AS NonALCDelayReason, 
    dbo.LU_CodeFile.UserDescription AS NonALCDelayReasonDesc, 
    dbo.AB_MB_NonALC.Occurrence AS NonALCOccurrence, 
    dbo.AB_MB_NonALC.AbstractID AS zzAbstractLink
FROM dbo.AB_MB_NonALC with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile with (nolock) ON dbo.AB_MB_NonALC.NonALCDelayReason = dbo.LU_CodeFile.Code







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_PatientService_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[DAD_PatientService_VR]
AS
SELECT     
    LEFT(Lookup1.DisplayCode, 2) AS PatientService, 
    Lookup1.DisplayCode AS PatientServiceSubService, 
    Lookup1.UserDescription AS PatientServiceSubServiceDesc, 
    dbo.AB_PatientService.ServiceDays AS PatientServiceDays, 
    dbo.AB_PatientService.ServiceOccurrence AS PatientServiceOccurrence, 
    Lookup2.DisplayCode AS PatientServiceType, 
    Lookup2.UserDescription AS PatientServiceTypeDesc, 
    Lookup3.DisplayCode AS ServiceNurseAreaUnitLoc, 
    Lookup3.UserDescription AS ServiceNursAreaUnitLocDesc, 
    dbo.AB_PatientService.ServiceNursingUnits, 
    dbo.AB_PatientService.ServiceTransferInDate AS TransferInDate, 
    dbo.AB_PatientService.ServiceTransferInTime AS TransferInTime, 
    dbo.AB_PatientService.ServiceTransferOutDate AS TransferOutDate, 
    dbo.AB_PatientService.ServiceTransferOutTime AS TransferOutTime, 
    dbo.AB_PatientService.AbstractID AS zzAbstractLink
FROM AB_Abstract with (nolock) inner join
    dbo.AB_PatientService with (nolock) on AB_PatientService.AbstractID = Ab_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_PatientService Lookup1 with (nolock) on dbo.AB_PatientService.PatientService = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_PatientServiceType Lookup2 with (nolock) on dbo.AB_PatientService.ServiceType = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_NurseArea Lookup3 with (nolock) on dbo.AB_PatientService.ServiceNursingArea = Lookup3.Code
Where AB_Abstract.CareType in (1, 2)






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'





CREATE   VIEW [dbo].[DAD_Projects_VR]
AS
SELECT     
    Lookup1.DisplayCode AS ProjectNumber, 
    Lookup1.UserDescription AS ProjectNumberDesc, 
    dbo.AB_Project.ProjectOccurrence, 
    Lookup2.DisplayCode AS Question1,  Lookup2.UserDescription AS Question1Desc, 
    Lookup3.DisplayCode AS Question10, Lookup3.UserDescription AS Question10Desc, 
    Lookup4.DisplayCode AS Question11, Lookup4.UserDescription AS Question11Desc, 
    Lookup5.DisplayCode AS Question12, Lookup5.UserDescription AS Question12Desc, 
    Lookup6.DisplayCode AS Question13, Lookup6.UserDescription AS Question13Desc, 
    dbo.AB_Project.Question14, dbo.AB_Project.Question15, 
    dbo.AB_Project.Question16, dbo.AB_Project.Question17, 
    Lookup7.DisplayCode AS Question2,  Lookup7.UserDescription AS Question2Desc, 
    Lookup8.DisplayCode AS Question3,  Lookup8.UserDescription AS Question3Desc, 
    Lookup9.DisplayCode AS Question4,  Lookup9.UserDescription AS Question4Desc, 
    Lookup10.DisplayCode AS Question5, Lookup10.UserDescription AS Question5Desc, 
    Lookup11.DisplayCode AS Question6, Lookup11.UserDescription AS Question6Desc, 
    Lookup12.DisplayCode AS Question7, Lookup12.UserDescription AS Question7Desc, 
    Lookup13.DisplayCode AS Question8, Lookup13.UserDescription AS Question8Desc, 
    Lookup14.DisplayCode AS Question9, Lookup14.UserDescription AS Question9Desc, 
    dbo.AB_Project.AbstractID AS zzAbstractLink
FROM AB_Abstract with (nolock) inner join 
    dbo.AB_Project with (nolock) on AB_Abstract.AbstractID = AB_Project.AbstractID LEFT OUTER JOIN
    dbo.LU_Project Lookup1 with (nolock) on dbo.AB_Project.ProjectNumber = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1 Lookup2 with (nolock) on dbo.AB_Project.Question1 = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 Lookup3 with (nolock) on dbo.AB_Project.Question10 = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 Lookup4 with (nolock) on dbo.AB_Project.Question11 = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 Lookup5 with (nolock) on dbo.AB_Project.Question12 = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 Lookup6 with (nolock) on dbo.AB_Project.Question13 = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2 Lookup7 with (nolock) on dbo.AB_Project.Question2 = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3 Lookup8 with (nolock) on dbo.AB_Project.Question3 = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4 Lookup9 with (nolock) on dbo.AB_Project.Question4 = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5 Lookup10 with (nolock) on dbo.AB_Project.Question5 = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6 Lookup11 with (nolock) on dbo.AB_Project.Question6 = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7 Lookup12 with (nolock) on dbo.AB_Project.Question7 = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8 Lookup13 with (nolock) on dbo.AB_Project.Question8 = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9 Lookup14 with (nolock) on dbo.AB_Project.Question9 = Lookup14.Code
where AB_Abstract.CareType in (1, 2)






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_Provider_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[DAD_Provider_VR]
AS
SELECT     
    Lookup1.DisplayCode AS ProviderNumber, 
    Lookup1.UserDescription AS ProviderNumberDesc, 
    dbo.AB_Provider.ProviderOccurrence, 
    dbo.LU_ProviderService.DisplayCode AS ProviderService, 
    dbo.LU_ProviderService.UserDescription AS ProviderServiceDesc, 
    Lookup3.DisplayCode AS ProviderType, 
    Lookup3.UserDescription AS ProviderTypeDesc, 
    dbo.AB_Provider.AbstractID AS zzAbstractLink
FROM AB_Abstract with (nolock) inner join         
    dbo.AB_Provider with (nolock) on AB_Abstract.AbstractID = AB_Provider.AbstractID LEFT OUTER JOIN
    dbo.LU_ProviderService with (nolock) on dbo.AB_Provider.ProviderService = dbo.LU_ProviderService.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup1 with (nolock) on dbo.AB_Provider.ProviderNumber = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_ProviderType Lookup3 with (nolock) on dbo.AB_Provider.ProviderType = Lookup3.Code
Where AB_Abstract.CareType in (1, 2)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DAD_SpecialCareUnits_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[DAD_SpecialCareUnits_VR]
AS
SELECT     
    dbo.AB_SpecialCareUnit.SCUAdmitDate AS SCUAdmissionDate, 
    dbo.AB_SpecialCareUnit.SCUAdmitTime AS SCUAdmissionTime, 
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_DiagFile10.DisplayCode 
                              when ''9'' then dbo.ICD_DiagFile10.DisplayCode 
                              when ''C'' then dbo.ICD_DiagFile10.DisplayCode 
     end) AS SCUDiagnosis, 
    (case AB_Abstract.ICDType when ''T'' then dbo.ICD_DiagFile10.UserDescription 
                              when ''9'' then dbo.ICD_DiagFile10.UserDescription 
                              when ''C'' then dbo.ICD_DiagFile10.UserDescription 
     end) AS SCUDiagnosisDesc, 
    ICD_DiagFile10.ShortDescription as DiagnosisCodeShortDesc,
    dbo.AB_SpecialCareUnit.SCUDischDate AS SCUDischargeDate, 
    dbo.AB_SpecialCareUnit.SCUDischTime AS SCUDischargeTime, 
    dbo.AB_SpecialCareUnit.SCULOS, dbo.AB_SpecialCareUnit.SCUHours, 
    Lookup1.DisplayCode AS SCUNumber, 
    Lookup1.UserDescription AS SCUNumberDesc, 
    dbo.AB_SpecialCareUnit.SCUOccurrence, 
    dbo.AB_SpecialCareUnit.AbstractID AS zzAbstractLink
FROM AB_Abstract with (nolock) inner join
    dbo.AB_SpecialCareUnit with (nolock) on AB_Abstract.AbstractID = AB_SpecialCareUnit.AbstractID LEFT OUTER JOIN
    dbo.ICD_DiagFile10 with (nolock) on dbo.AB_SpecialCareUnit.SCUDiagCode = dbo.ICD_DiagFile10.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile9 with (nolock) on dbo.AB_SpecialCareUnit.SCUDiagCode = dbo.ICD_DiagFile9.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile9cm with (nolock) on dbo.AB_SpecialCareUnit.SCUDiagCode = dbo.ICD_DiagFile9cm.Code LEFT OUTER JOIN
    dbo.LU_SCUNumber Lookup1 with (nolock) on dbo.AB_SpecialCareUnit.SCUNumber = Lookup1.Code
Where AB_Abstract.CareType in (1, 2)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[EMT_Edits_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[EMT_Edits_VR]
AS 
select 
  [Edit Name] = e.EditName
, Module = CASE WHEN e.ModuleID IS NOT NULL THEN  dbo.EMT_GetModuleDescription(e.ModuleID) ELSE '''' END
, [Edit Rule severity] = CASE WHEN e.EditType IS NOT NULL THEN dbo.EMT_GetRuleSeverity(e.EditType) ELSE '''' END
, [Condition type to evaluate edit] = CASE WHEN e.RuleType IS NOT NULL Then dbo.EMT_GetConditionComparisonType(e.RuleType) ELSE '''' END
, [Message content] = e.MessageText
, [Valid From] =  e.ValidFrom
, [Valid To] = e.ValidTo
, zzEditLink = e.RuleID
from ENGN_Edit e with (nolock)
left join ENGN_FieldCondition fc on e.RuleID = fc.RecordID 
where e.IsDelete <> 1 and e.ModuleID in (200, 201, 202, 401) and e.RuleType = 1 --FieldConditions
union
select 
  [Edit Name] = e.EditName
, Module = CASE WHEN e.ModuleID IS NOT NULL THEN  dbo.EMT_GetModuleDescription(e.ModuleID) ELSE '''' END
, [Edit Rule severity] =  CASE WHEN e.EditType IS NOT NULL THEN dbo.EMT_GetRuleSeverity(e.EditType) ELSE '''' END
, [Condition type to evaluate edit] =  CASE WHEN e.RuleType IS NOT NULL Then dbo.EMT_GetConditionComparisonType(e.RuleType) ELSE '''' END
, [Message content] = e.MessageText
, [Valid From] =  e.ValidFrom
, [Valid To] = e.ValidTo
, zzEditLink = e.RuleID
from ENGN_Edit e with (nolock)
left join ENGN_LogicalCondition lc on e.RuleID = lc.RecordID 
where e.IsDelete <> 1 and e.ModuleID in (200, 201, 202, 401) and e.RuleType = 2 --LogicalConditions' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[EMT_FieldConditions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[EMT_FieldConditions_VR]
AS 
SELECT  
zzConditionLink = fc.RecordID
, Module = CASE WHEN fc.ModuleID IS NOT NULL THEN dbo.EMT_GetModuleDescription(fc.ModuleID) ELSE '''' END
, [Field Condition Name] = fc.EditName
, [Field 1] = CASE WHEN fc.Field1 IS NOT NULL AND isnumeric(replace(fc.Field1, ''FK'', '''')) = 1 THEN field1.Header_User
                           WHEN fc.Field1 IS NOT NULL AND isnumeric(replace(fc.Field1, ''FK'', '''')) = 0 THEN  dbo.EMT_GetGrouperHeader(fc.Field1)
                           ELSE '''' END
, [Use Field 1 occurrence] = CASE WHEN fc.OccType1 IS NOT NULL THEN dbo.EMT_GetFieldOccurrence (fc.OccType1) ELSE '''' END
, [Field 1 Occurrence Number] = CASE WHEN fc.OccType1 IS NOT NULL AND fc.OccType1 = 623 THEN convert(varchar, fc.Occurrence1, 50) ELSE ''n/a'' END
, [Field condition operator] =  CASE WHEN fc.OperatorType IS NOT NULL THEN dbo.EMT_GetFieldConditionOperator(fc.OperatorType) ELSE '''' END
, [Comparison Type] = CASE WHEN fc.CompareType IS NOT NULL THEN dbo.EMT_GetFieldComparisonType (fc.CompareType) ELSE '''' END
, [Field 1 Value] = fv.[FieldValue]
, [Field 1 Value Description] = fv.[FieldDescription]

, Field2 =    CASE WHEN fc.Field1  IS NOT NULL AND isnumeric(replace(fc.Field2, ''FK'', '''')) = 1 THEN field2.Header_User
                           WHEN field1.Header_User IS NOT NULL AND isnumeric(replace(fc.Field2, ''FK'', '''')) = 0 THEN dbo.EMT_GetGrouperHeader(fc.Field2)              
                     END
, [Use Field 2 occurence] = CASE WHEN fc.OccType2 IS NOT NULL THEN dbo.EMT_GetFieldOccurrence (fc.OccType2) ELSE '''' END
, [Field 2 Occurrence Number] = CASE WHEN fc.OccType2 IS NOT NULL AND fc.OccType1 = 623 THEN convert(varchar, fc.Occurrence2, 50) ELSE ''n/a'' END
, [Between From] = BetweenFrom
, [Between To] = BetweenTo 
from ENGN_FieldCondition fc with (nolock) 
left join ENGN_FieldValues fv on fc.RecordID = fv.RecordID and fc.ModuleID in (200, 201, 202, 401) 
left join dbo.U_UsersFields field1 with (nolock) 
        on field1.UserID = 1 and fc.ModuleID = field1.AppID and 
        (case when isnumeric(replace(fc.Field1, ''FK'', '''')) = 1 
              then replace(fc.Field1, ''FK'', '''')
              else 0 end) = field1.FieldID 
left join dbo.U_UsersFields field2 with (nolock) 
        on field2.UserID = 1 and fc.ModuleID = field2.AppID and 
        (case when isnumeric(replace(fc.Field2, ''FK'', '''')) = 1 
              then replace(fc.Field2, ''FK'', '''')
              else 0 end) = field2.FieldID 
where fc.IsDelete <> 1

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[EMT_Logical_Conditions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[EMT_Logical_Conditions_VR]
as
SELECT 
zzEditLink = lr.RecordID
, zzConditionLink = lr.RuleID
--, RegionID
--, HospitalID
, Module = CASE WHEN lc.ModuleID IS NOT NULL THEN dbo.EMT_GetModuleDescription(lc.ModuleID) ELSE '''' END
, [Logical Condition Name] = lc.EditName
, [Logical Operator] = CASE WHEN lc.OperatorType IS NOT NULL THEN convert(varchar, dbo.EMT_GetLogicalConditionOperator(lc.OperatorType), 50) ELSE '''' END
, [Same Occurrence (MultiForms)] = CASE WHEN lc.MultipleIndex IS NOT NULL THEN dbo.EMT_GetSameOccurrenceMultiFormDescription(lc.MultipleIndex, lc.ModuleID) ELSE NULL END
, [Condition Type] = CASE lr.RuleType 
						WHEN ''1'' THEN ''FLD''
						WHEN ''2'' THEN ''LOG''
					 END
, [Valid MultiForm Condition] = CASE WHEN lc.MultipleIndex IS NOT NULL THEN ''Y'' ELSE '''' END
, [Name] = fc.EditName
from ENGN_LogicalCondition lc with (nolock)
join ENGN_LogicalRules lr with (nolock) on lc.RecordID = lr.RecordID
join ENGN_FieldCondition fc with (nolock) on lr.RuleID = fc.RecordID
WHERE lc.IsDelete <> 1 and fc.IsDelete <> 1 and lc.ModuleID in (200, 201, 202, 401) 
union 
SELECT 
zzEditLink = lr.RuleID
,zzConditionLink = lr.RuleID
--, RegionID
--, HospitalID
, Module = CASE WHEN lc.ModuleID IS NOT NULL THEN dbo.EMT_GetModuleDescription(lc.ModuleID) ELSE '''' END
, [Logical Condition Name] = lc.EditName
, [Logical Operator] = CASE WHEN lc.OperatorType IS NOT NULL THEN convert(varchar, dbo.EMT_GetLogicalConditionOperator(lc.OperatorType), 50) ELSE '''' END
, [Same Occurrence (MultiForms)] = CASE WHEN lc.MultipleIndex IS NOT NULL THEN dbo.EMT_GetSameOccurrenceMultiFormDescription(lc.MultipleIndex, lc.ModuleID) ELSE NULL END
, [Condition Type] = CASE lr.RuleType 
						WHEN ''1'' THEN ''FLD''
						WHEN ''2'' THEN ''LOG''
					 END
, [Valid MultiForm Condition] = CASE WHEN lc.MultipleIndex IS NOT NULL THEN ''Y'' ELSE '''' END
, [Name] = lc2.EditName
from ENGN_LogicalCondition lc with (nolock)
join ENGN_LogicalRules lr with (nolock) on lc.RecordID = lr.RecordID
join ENGN_LogicalCondition lc2 with (nolock) on lr.RuleID = lc2.RecordID
WHERE lc.IsDelete <> 1 and lc2.IsDelete <> 1 and lc.ModuleID in (200, 201, 202, 401)

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Grouper_Audit_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[Grouper_Audit_VR]
AS
SELECT     DateGrouped, FieldChanged, GroupingYear, OldValue AS ValueOld, NewValue AS ValueNew, AbstractID AS zzAbstractLink
FROM         dbo.AB_GrouperAudit with (nolock)





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstract_CACS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[I10_Abstract_CACS_VR]
AS
SELECT     dbo.AB_CACS.OccurrenceNumber, 
	dbo.AB_CACS.BatchGroupDate,
	dbo.AB_CACS.CACS_Year AS CACSYear, dbo.AB_CACS.MAC, 
        (case when dbo.AB_CACS.CACS_Year < 2011
              then
                  (CASE dbo.AB_CACS.MAC 
                        WHEN 1 THEN ''Diseases and Disorders of the Nervous System'' 
                        WHEN 2 THEN ''Diseases and Disorders of the Eye'' 
                        WHEN 3 THEN ''Diseases and Disorders of the Ear, Nose, Mouth and Throat'' 
                        WHEN 4 THEN ''Diseases and Disorders of the Respiratory System'' 
                        WHEN 5 THEN ''Diseases and Disorders of the Circulatory System'' 
                        WHEN 6 THEN ''Diseases and Disorders of the Digestive System'' 
                        WHEN 7 THEN ''Diseases and Disorders of the Hepatobiliary System and Pancreas''
                        WHEN 8 THEN ''Diseases and Disorders of the Musculoskeletal System and Connective Tissue'' 
                        WHEN 9 THEN ''Diseases and Disorders of the Skin and Subcutaneous Tissue and Breast''
                        WHEN 10 THEN ''Endocrine, Nutritional, and Metabolic Diseases and Disorders'' 
                        WHEN 11 THEN ''Diseases and Disorders of Kidney and Genitourinary Tract''
                        WHEN 14 THEN ''Pregnancy, Childbirth, Newborns and Neonates'' 
                        WHEN 16 THEN ''Haematology Including Lymphoma, Leukaemia and Unspecified Site Neoplasms''
                        WHEN 17 THEN ''Oncological Diseases and Disorders'' 
                        WHEN 18 THEN ''Systemic Infections Including HIV'' 
                        WHEN 19 THEN ''Mental Diseases and Disorders''
                        WHEN 20 THEN ''Examination and Other Health Factors'' 
                        WHEN 21 THEN ''Trauma, Coma and Toxic Effects'' 
                        WHEN 99 THEN ''Ungroupable'' ELSE '''' END)
              else 
                (select top 1 mac_long_e_desc from dbo.tGrouper_CACS_MAC where tGrouper_CACS_MAC.methodology_year = dbo.AB_CACS.CACS_Year and dbo.AB_CACS.MAC = tGrouper_CACS_MAC.mac_code)
              end) AS MACDescription, 
        dbo.AB_CACS.CACSCell, dbo.AB_CACS.ACW, dbo.AB_CACS.CACSDescription, 
        dbo.ICD_ProcFile10.DisplayCode AS InterventionCode, dbo.ICD_ProcFile10.UserDescription AS IntervCodeDescription, 
        dbo.ICD_ProcFile10.ShortDescription AS InterventionCodeShortDesc, 
        dbo.AB_CACS.AgeCategory, dbo.tGrouper_CACS_Age_Category.cacs_age_category_e_desc as AgeCategoryDesc,
        dbo.AB_CACS.AnaestheticCategory, dbo.tGrouper_CACS_Aanaesthetic.cacs_anaesthetic_e_desc as AnaestheticCategoryDesc,
        dbo.AB_CACS.MITTotalCount AS InvestigativeTechnologyTotalCount,
        ACW_HBAM as CACSHBAM,
        ACW_Base as CACSBaseRIW,
        CACSPartition, 
        MIT_Category_01 as InvestigativeTechnologyCategory_01, MIT_Category_Count_01 as InvestigativeTechnologyCategoryCount_01, 
        MIT_Category_02 as InvestigativeTechnologyCategory_02, MIT_Category_Count_02 as InvestigativeTechnologyCategoryCount_02, 
        MIT_Category_03 as InvestigativeTechnologyCategory_03, MIT_Category_Count_03 as InvestigativeTechnologyCategoryCount_03, 
        MIT_Category_04 as InvestigativeTechnologyCategory_04, MIT_Category_Count_04 as InvestigativeTechnologyCategoryCount_04, 
        MIT_Category_05 as InvestigativeTechnologyCategory_05, MIT_Category_Count_05 as InvestigativeTechnologyCategoryCount_05, 
        MIT_Category_06 as InvestigativeTechnologyCategory_06, MIT_Category_Count_06 as InvestigativeTechnologyCategoryCount_06, 
        MIT_Category_07 as InvestigativeTechnologyCategory_07, MIT_Category_Count_07 as InvestigativeTechnologyCategoryCount_07, 
        MIT_Category_08 as InvestigativeTechnologyCategory_08, MIT_Category_Count_08 as InvestigativeTechnologyCategoryCount_08, 
        MIT_Category_09 as InvestigativeTechnologyCategory_09, MIT_Category_Count_09 as InvestigativeTechnologyCategoryCount_09, 
        MIT_Category_10 as InvestigativeTechnologyCategory_10, MIT_Category_Count_10 as InvestigativeTechnologyCategoryCount_10,
        
        dbo.AB_Abstract.AbstractID AS zzAbstractLink
FROM    dbo.AB_CACS with (nolock) inner JOIN
		dbo.AB_Abstract with (nolock) ON dbo.AB_CACS.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
		dbo.ICD_ProcFile10 with (nolock) ON dbo.AB_CACS.InterventionCode = dbo.ICD_ProcFile10.Code LEFT OUTER JOIN
		dbo.tGrouper_CACS_Age_Category with (nolock) ON dbo.AB_CACS.AgeCategory = dbo.tGrouper_CACS_Age_Category.cacs_age_category_code
						and dbo.AB_CACS.CACS_Year = dbo.tGrouper_CACS_Age_Category.methodology_year LEFT OUTER JOIN
		dbo.tGrouper_CACS_Aanaesthetic with (nolock) ON dbo.AB_CACS.AnaestheticCategory = dbo.tGrouper_CACS_Aanaesthetic.cacs_anaesthetic_code
						and dbo.AB_CACS.CACS_Year = dbo.tGrouper_CACS_Aanaesthetic.methodology_year LEFT OUTER JOIN
        dbo.AB_CACS_Investigative with (nolock) ON 	AB_CACS.AbstractID = AB_CACS_Investigative.AbstractID
						and AB_CACS.OccurrenceNumber = AB_CACS_Investigative.OccurrenceNumber 
						and AB_CACS.CACS_Year = AB_CACS_Investigative.CACS_Year
WHERE  dbo.AB_Abstract.DischargeDate > ''2006/03/31'' AND (dbo.AB_Abstract.CareType = 2) AND (dbo.AB_CACS.OccurrenceNumber = 1)

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstract_CJRR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE view [dbo].[I10_Abstract_CJRR]
as
select
    Cement, LU_CJRR_Cement.UserDescription as CementDesc,
    CementOther, 
    CementProductNumber, 
    CementLotNumber,
    Occurrence as CJRROccurrence,      
    Component1, LU_CJRR_Component1.UserDescription as Component1Desc,
    Component2, LU_CJRR_Component2.UserDescription as Component2Desc,
    Component3, LU_CJRR_Component3.UserDescription as Component3Desc,
    JointIdentifier, 
    Side,  LU_CJRR_Side.UserDescription as SideDesc,
    AB_CJRR.AbstractID as zzAbstractLink
from dbo.AB_CJRR with (nolock)
    left join LU_CJRR_Side with (nolock) on AB_CJRR.Side = LU_CJRR_Side.CIHIValue
    left join LU_CJRR_Component LU_CJRR_Component1 with (nolock) on AB_CJRR.Component1 = LU_CJRR_Component1.CIHIValue
    left join LU_CJRR_Component LU_CJRR_Component2 with (nolock) on AB_CJRR.Component2 = LU_CJRR_Component2.CIHIValue
    left join LU_CJRR_Component LU_CJRR_Component3 with (nolock) on AB_CJRR.Component3 = LU_CJRR_Component3.CIHIValue
    left join LU_CJRR_Cement with (nolock) on AB_CJRR.Cement = LU_CJRR_Cement.CIHIValue
    

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstract_CJRR_Parts]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'create view [dbo].[I10_Abstract_CJRR_Parts]
as
select
    AB_CJRR_Parts.CJRROccurrence,
    AB_CJRR_Parts.ComponentOccurrence, 
    AB_CJRR_Parts.PartOccurrence,
    AB_CJRR_Parts.Manufacturer, LU_CJRR_Manufacturer.UserDescription as ManufacturerDesc,
    AB_CJRR_Parts.ManufacturerOther, 
    AB_CJRR_Parts.ProductNumber as ManufacturerProductNumber,
    AB_CJRR_Parts.LotNumber  as ManufacturerLotNumber,

    AB_CJRR_Parts.AbstractID as zzAbstractLink

from dbo.AB_CJRR_Parts with (nolock)
    left join LU_CJRR_Manufacturer with (nolock) on AB_CJRR_Parts.Manufacturer = LU_CJRR_Manufacturer.CIHIValue' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractCIHIErrors_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[I10_AbstractCIHIErrors_VR]
AS
SELECT     AbstractNumber, BatchNumber, FiscalPeriod AS BatchPeriod, FiscalYear AS BatchYear, ChartNumber, CoderNumber, DischargeDate, ErrorFileName, 
                      ErrorMessage, ErrorNumber, FacilityNumber AS InstitutionNumber, GroupFieldOcc, ImportDateTime, OriginalData, TypeOfAbstract, TypeOfError, 
                      AbstractID AS zzAbstractLink
FROM         dbo.AB_CIHIErrors with (nolock)




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstracting]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[I10_Abstracting]
AS
SELECT     dbo.AB_ReproductiveCare.PrevTermDelivery AS [#ofPreviousDeliveries], 
    dbo.AB_ReproductiveCare.PrevLiveBirths AS [#ofPreviousLiveBirths], 
    dbo.AB_ReproductiveCare.PrevPreTermDelivery AS [#ofPreviousPreTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevSpontAbortions AS [#ofPrevSpontaneousAbortions], 
    dbo.AB_ReproductiveCare.PrevInduceAbortions AS [#ofPrevTherapueticAbortions], 
    --'''' AS AbstractNotes, PR - 05199
    dbo.AB_Abstract.AbstractNumber, 
    Lookup2.DisplayCode AS AbstractOverflow, Lookup2.UserDescription AS AbstractOverflowDesc, LU_AbstractType.DisplayCode AS AbstractType, 
    LU_AbstractType.UserDescription AS AbstractTypeDesc, dbo.AB_Abstract.AcuteLOS, dbo.AB_Abstract.AdmitDate AS AdmissionDate, 
    dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
    --PR - 05489
    LU_AdmitTimeUnknown.DisplayCode as AdmissionTimeUnknown, LU_AdmitTimeUnknown.UserDescription as AdmissionTimeUnknownDesc,
    Lookup3.DisplayCode AS AdmitbyAmbulance, Lookup3.UserDescription AS AdmitbyAmbulanceDesc, 
    Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, Lookup5.DisplayCode AS AdmitNursingAreaUnitLocation, 
    Lookup5.UserDescription AS AdmittingNursingAreaUnitLDesc, Lookup6.DisplayCode AS AgeCode, Lookup6.UserDescription AS AgeCodeDesc, 
    dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, dbo.AB_Abstract.DischargeAge AS AgeUponDischarge, 
    Lookup7.DisplayCode AS AgeUponDischargeCode, Lookup7.UserDescription AS AgeUponDischargeCodeDesc, Lookup8.DisplayCode AS Albumin, 
    Lookup9.DisplayCode AS AlbuminCrossMatched, Lookup9.UserDescription AS AlbuminCrossMatchedDesc, Lookup8.UserDescription AS AlbuminDesc, 
    Lookup10.DisplayCode AS AlbuminTyped, Lookup10.UserDescription AS AlbuminTypedDesc, dbo.AB_Blood.AlbuminUnits, dbo.AB_Abstract.ALCLOS, 
    LU_AlcoholDuringPregnancy.DisplayCode AS AlcoholDuringPregnancy, LU_AlcoholDuringPregnancy.UserDescription AS AlcoholDuringPregnancyDesc, 
    AlcoholQuitDate,
    LU_AlcoholQuitDateUnknown.DisplayCode AS AlcoholQuitDateUnknown, LU_AlcoholQuitDateUnknown.UserDescription AS AlcoholQuitDateUnknownDesc, 
    Lookup11.DisplayCode AS AncillaryField1, Lookup11.UserDescription AS AncillaryField1Desc, Lookup12.DisplayCode AS AncillaryField10, 
    Lookup12.UserDescription AS AncillaryField10Desc, Lookup13.DisplayCode AS AncillaryField11, Lookup13.UserDescription AS AncillaryField11Desc, 
    Lookup14.DisplayCode AS AncillaryField12, Lookup14.UserDescription AS AncillaryField12Desc, Lookup15.DisplayCode AS AncillaryField13, 
    Lookup15.UserDescription AS AncillaryField13Desc, Lookup16.DisplayCode AS AncillaryField14, Lookup16.UserDescription AS AncillaryField14Desc, 
    Lookup17.DisplayCode AS AncillaryField15, Lookup17.UserDescription AS AncillaryField15Desc, Lookup18.DisplayCode AS AncillaryField16, 
    Lookup18.UserDescription AS AncillaryField16Desc, Lookup19.DisplayCode AS AncillaryField17, Lookup19.UserDescription AS AncillaryField17Desc, 
    Lookup20.DisplayCode AS AncillaryField2, Lookup20.UserDescription AS AncillaryField2Desc, Lookup21.DisplayCode AS AncillaryField3, 
    Lookup21.UserDescription AS AncillaryField3Desc, Lookup22.DisplayCode AS AncillaryField4, Lookup22.UserDescription AS AncillaryField4Desc, 
    Lookup23.DisplayCode AS AncillaryField5, Lookup23.UserDescription AS AncillaryField5Desc, Lookup24.DisplayCode AS AncillaryField6, 
    Lookup24.UserDescription AS AncillaryField6Desc, Lookup25.DisplayCode AS AncillaryField7, Lookup25.UserDescription AS AncillaryField7Desc, 
    Lookup26.DisplayCode AS AncillaryField8, Lookup26.UserDescription AS AncillaryField8Desc, Lookup27.DisplayCode AS AncillaryField9, 
    Lookup27.UserDescription AS AncillaryField9Desc,
    --ED - 01750
    LU_AnestheticLabor.DisplayCode as AnalgesicAnestheticDuringLabor, LU_AnestheticLabor.UserDescription as AnalgesicAnestheticDuringLaborDesc,
    dbo.AB_Manitoba.Apgar1Min, dbo.AB_Manitoba.Apgar5Min, 
    dbo.AB_Abstract.ArrivalDate AS ArrivalDateInER, dbo.AB_Abstract.ArrivalTime AS ArrivalTimeInER, Lookup28.DisplayCode AS AttendingPhysician, 
    Lookup28.UserDescription AS AttendingPhysicianDesc, Lookup30.DisplayCode AS AutopsyPerformed, 
    Lookup30.UserDescription AS AutopsyPerformedDesc, Lookup29.DisplayCode AS AutoTransfusion, 
    Lookup29.UserDescription AS AutoTransfusionDesc, Lookup1.DisplayCode AS AWOL, Lookup1.UserDescription AS AWOLDesc, 
    LU_BagVentilation.DisplayCode AS BagVentilation, LU_BagVentilation.UserDescription AS BagVentilationDesc, 
    Lookup31.DisplayCode AS BasicOption1, Lookup31.UserDescription AS BasicOption1Desc, Lookup32.DisplayCode AS BasicOption10, 
    Lookup32.UserDescription AS BasicOption10Desc, Lookup33.DisplayCode AS BasicOption11, Lookup33.UserDescription AS BasicOption11Desc, 
    Lookup34.DisplayCode AS BasicOption12, Lookup34.UserDescription AS BasicOption12Desc, Lookup35.DisplayCode AS BasicOption13, 
    Lookup35.UserDescription AS BasicOption13Desc, Lookup36.DisplayCode AS BasicOption14, Lookup36.UserDescription AS BasicOption14Desc, 
    Lookup37.DisplayCode AS BasicOption15, Lookup37.UserDescription AS BasicOption15Desc, Lookup38.DisplayCode AS BasicOption16, 
    Lookup38.UserDescription AS BasicOption16Desc, Lookup39.DisplayCode AS BasicOption17, Lookup39.UserDescription AS BasicOption17Desc, 
    Lookup40.DisplayCode AS BasicOption18, Lookup40.UserDescription AS BasicOption18Desc, Lookup41.DisplayCode AS BasicOption19, 
    Lookup41.UserDescription AS BasicOption19Desc, Lookup42.DisplayCode AS BasicOption2, Lookup42.UserDescription AS BasicOption2Desc, 
    Lookup43.DisplayCode AS BasicOption3, Lookup43.UserDescription AS BasicOption3Desc, Lookup44.DisplayCode AS BasicOption4, 
    Lookup44.UserDescription AS BasicOption4Desc, Lookup45.DisplayCode AS BasicOption5, Lookup45.UserDescription AS BasicOption5Desc, 
    Lookup46.DisplayCode AS BasicOption6, Lookup46.UserDescription AS BasicOption6Desc, Lookup47.DisplayCode AS BasicOption7, 
    Lookup47.UserDescription AS BasicOption7Desc, Lookup48.DisplayCode AS BasicOption8, Lookup48.UserDescription AS BasicOption8Desc, 
    Lookup49.DisplayCode AS BasicOption9, Lookup49.UserDescription AS BasicOption9Desc, dbo.AB_Abstract.BatchNumber, 
    Lookup50.DisplayCode AS BatchPeriod, Lookup50.UserDescription AS BatchPeriodDesc, 

	LU_AntithrombinIII.DisplayCode AS Blood_AntithrombinIII, LU_AntithrombinIII.UserDescription AS Blood_AntithrombinIIIDesc,
	LU_C1Inhibitor.DisplayCode AS Blood_C1Inhibitor, LU_C1Inhibitor.UserDescription AS Blood_C1InhibitorDesc,
	LU_CryoprecipitatePlasma.DisplayCode AS Blood_CryoprecipitatePlasma, LU_CryoprecipitatePlasma.UserDescription AS Blood_CryoprecipitatePlasmaDesc,
	LU_CryosupernatantPlasma.DisplayCode AS Blood_CryosupernatantPlasma, LU_CryosupernatantPlasma.UserDescription AS Blood_CryosupernatantPlasmaDesc,
	LU_FEIBA.DisplayCode AS Blood_FEIBA, LU_FEIBA.UserDescription AS Blood_FEIBADesc,
	LU_Fibrinogen.DisplayCode AS Blood_Fibrinogen, LU_Fibrinogen.UserDescription AS Blood_FibrinogenDesc,
	LU_IVIG_SCIG.DisplayCode AS Blood_IVIG_SCIG, LU_IVIG_SCIG.UserDescription AS Blood_IVIG_SCIGDesc,
	LU_PCC.DisplayCode AS Blood_PCC, LU_PCC.UserDescription AS Blood_PCCDesc,
	LU_ProteinC_OtherFactors.DisplayCode AS Blood_ProteinC_OtherFactors, LU_ProteinC_OtherFactors.UserDescription AS Blood_ProteinC_OtherFactorsDesc,



    --PR - 06087
    BatchPeriod_BC = (case when left(Lookup111.CIHIValue, 1) <> ''9'' then null
                         when Lookup50.DisplayCode is not null then Lookup50.DisplayCode 
                         when DischargeDate is null then null
                         else (select top 1 DisplayCode from LU_BatchPeriod where DischargeDate between CIHIDateFrom and CIHIDateTo)
                    end),
    dbo.AB_Abstract.BatchYear, 
    Lookup51.DisplayCode AS Between210DaysPostOp, Lookup51.UserDescription AS Between210DaysPostOpDesc, dbo.AB_Abstract.BirthDate, 
    Lookup52.DisplayCode AS BreastFeedingonDischarge, Lookup52.UserDescription AS BreastFeedingonDischargeDesc, 
    dbo.LU_CareType.DisplayCode AS CareType, dbo.LU_CareType.UserDescription AS CareTypeDesc, Lookup53.DisplayCode AS ChangeinLegalStatus, 
    Lookup53.UserDescription AS ChangeinLegalStatusDesc, dbo.AB_Abstract.ChartNumber, LU_ChestCompressions.DisplayCode AS ChestCompressions,
    LU_ChestCompressions.UserDescription AS ChestCompressionsDesc, dbo.AB_Abstract.ChiefComplaint AS ChiefComplaintUponAdmission, 
    dbo.AB_CancerStaging.ClinicalMetastasis, dbo.AB_CancerStaging.ClinicalNode, dbo.AB_CancerStaging.ClinicalTumor, 
    Lookup54.DisplayCode AS CoderNumber, Lookup54.UserDescription AS CoderNumberDesc, Lookup55.DisplayCode AS Comorbidity, 
    Lookup55.UserDescription AS ComorbidityDesc, Lookup55.DisplayCode AS Complication, Lookup55.UserDescription AS ComplicationDesc, 
    Lookup56.DisplayCode AS Complication1, Lookup56.UserDescription AS Complication1Desc, Lookup57.DisplayCode AS Complication2, 
    Lookup57.UserDescription AS Complication2Desc, Lookup58.DisplayCode AS Complication3, Lookup58.UserDescription AS Complication3Desc, 
    Lookup58.DefaultDescription AS Complication3Desc_D, Lookup59.DisplayCode AS CoronerCase, Lookup59.UserDescription AS CoronerCaseDesc, 
    Lookup60.DisplayCode AS DataEntryCoder, Lookup60.UserDescription AS DataEntryCoderDesc, 
    dbo.AB_ReproductiveCare.LastMensesDate AS DateofLastMenses, dbo.AB_Abstract.DateReadyDischarge AS DateReadyForDischarge, 
    dbo.AB_Abstract.CIHIDateSent AS DateSenttoCIHI, LU_Days_WeekAlcoholConsumed.DisplayCode AS Days_WeekAlcoholConsumed, 
    LU_Days_WeekAlcoholConsumed.UserDescription AS Days_WeekAlcoholConsumedDesc, Lookup61.DisplayCode AS DeathInOR, 
    Lookup61.UserDescription AS DeathInORDesc, Lookup62.DisplayCode AS DeathInSCU, Lookup62.UserDescription AS DeathInSCUDesc, 
    dbo.AB_Manitoba.DeclarationNumber, dbo.AB_ReproductiveCare.DeliveryDate, dbo.AB_ReproductiveCare.DeliveryTime, 
    dbo.AB_Abstract.DischargeDate, Lookup63.DisplayCode AS DischargeDisposition, Lookup63.UserDescription AS DischargeDispositionDesc, 
    Lookup64.DisplayCode AS DischNursingAreaUnitLocation, Lookup64.UserDescription AS DischargeNursingAreaUnitDesc, 
    Lookup65.DisplayCode AS DischargePlanning, Lookup65.UserDescription AS DischargePlanningDesc, 
    dbo.AB_Abstract.DischargeTime, 
    --PR - 05489
    LU_DischargeTimeUnknown.DisplayCode AS DischargeTimeUnknown, LU_DischargeTimeUnknown.UserDescription AS DischargeTimeUnknownDesc, 

    dbo.AB_Manitoba.DrinksPerday, dbo.AB_Manitoba.ALC_TotalDays AS DurationALCDays, Lookup66.DisplayCode AS ECTTreatment, 
    Lookup66.UserDescription AS ECTTreatmentDesc, Lookup67.DisplayCode AS Education, Lookup67.UserDescription AS EducationDesc, 
    LU_Elopements.DisplayCode AS Elopements, LU_Elopements.UserDescription AS ElopementsDesc, dbo.AB_Manitoba.EmployerName, 
    Lookup68.DisplayCode AS Employment, Lookup68.UserDescription AS EmploymentDesc, dbo.AB_Abstract.EncounterNumber, 
    Lookup69.DisplayCode AS EntryCode, Lookup69.UserDescription AS EntryCodeDesc, dbo.AB_Abstract.DateLeftER AS ERDatePatientLeft, 
    dbo.AB_Abstract.DecisionAdmitDate AS ERDecisiontoAdmitDate, dbo.AB_Abstract.DecisionAdmitTime AS ERDecisiontoAdmitTime, 
    LU_DecAdmitTimeUnknown.DisplayCode AS ERDecisionAdmitTimeUnknown, 
    LU_DecAdmitTimeUnknown.UserDescription AS ERDecisionAdmitTimeUnknownDesc, dbo.AB_Abstract.TimeLeftER AS ERTimePatientLeft, 
    LU_TimeLeftERUnknown.DisplayCode AS ERTimePatientLeftUnknown, LU_TimeLeftERUnknown.UserDescription AS ERTimePatientLeftUnknownDesc, 
    LU_Feeding.DisplayCode AS Feeding, LU_Feeding.UserDescription AS FeedingDesc, Lookup70.DisplayCode AS FinancialSupport, 
    Lookup70.UserDescription AS FinancialSupportDesc, dbo.AB_Abstract.FinishDate, dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, 
    Lookup71.DisplayCode AS FirstOptionalTherapy, Lookup71.UserDescription AS FirstOptionalTherapyDesc, 
    dbo.AB_Therapeutic.FirstOptionUnits AS FirstOptionalUnits, dbo.AB_Manitoba.FirstStageDuration, 
    FixedChartNumber,
    LU_FreeFlowOxygen.DisplayCode AS FreeFlowOxygen, LU_FreeFlowOxygen.UserDescription AS FreeFlowOxygenDesc, 
    Lookup72.DisplayCode AS Gender, Lookup72.UserDescription AS GenderDesc, dbo.AB_Manitoba.Gestation, 
    dbo.AB_ReproductiveCare.GestationalAge AS GestationalAgeinweeks, Lookup73.DisplayCode AS GlasgowComaScale, 
    Lookup73.UserDescription AS GlasgowComaScaleDesc, dbo.AB_Manitoba.Gravida, Lookup74.DisplayCode AS Greaterthan10DaysPostOp, 
    Lookup74.UserDescription AS Greaterthan10DaysPostOpDesc, Lookup75.DisplayCode AS HCNProvince, 
    Lookup75.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
	AB_Abstract.Height,
    dbo.H_HospitalProfile.DisplayCode AS Hospital, dbo.H_HospitalProfile.UserDescription AS HospitalDesc, 
    dbo.AB_Abstract.HospitalAccountRecord,
    dbo.AB_Abstract.ICDType, 
    Lookup76.DisplayCode AS InitialOR, Lookup76.UserDescription AS InitialORDesc, dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
    
	Lookup77.InstCareType AS InstFromCareType, Lookup77.HospitalType AS InstFromHospType, 
	Lookup77.DisplayCode AS InstitutionFrom, Lookup77.UserDescription AS InstitutionFromDesc, 
	LU_InstitutionFrom_Type.DisplayCode AS InstitutionFromType, LU_InstitutionFrom_Type.UserDescription AS InstitutionFromTypeDesc, 

	Lookup78.DisplayCode AS InstitutionTo, Lookup78.UserDescription AS InstitutionToDesc, 
	LU_InstitutionTo_Type.DisplayCode AS InstitutionToType, LU_InstitutionTo_Type.UserDescription AS InstitutionToTypeDesc, 
    Lookup78.InstCareType AS InstToCareType, Lookup78.HospitalType AS InstToHospType, 
	
	Lookup79.DisplayCode AS InterfaceCoder, 
    Lookup79.UserDescription AS InterfaceCoderDesc, dbo.AB_Abstract.InterfaceDate, dbo.AB_Abstract.InterfaceTime, 
    LU_IntubationNotMeconium.DisplayCode AS IntubationNotMeconium, LU_IntubationNotMeconium.UserDescription AS IntubationNotMeconiumDesc, 
    Lookup80.DisplayCode AS IsAbstractCompleted, Lookup80.UserDescription AS IsAbstractCompletedDesc, 
    Lookup81.DisplayCode AS IsAbstractCorrected, Lookup81.UserDescription AS IsAbstractCorrectedDesc, Lookup82.DisplayCode AS IsAbstractDeleted, 
    Lookup82.UserDescription AS IsAbstractDeletedDesc, Lookup83.DisplayCode AS IsAbstractSubmited, 
    Lookup83.UserDescription AS IsAbstractSubmitedDesc, Lookup84.DisplayCode AS IsAbstractValidated, 
    Lookup84.UserDescription AS IsAbstractValidatedDesc, 
	Lookup85.DisplayCode AS IsBirthdateEstimated,  Lookup85.UserDescription AS IsBirthdateEstimatedDesc, 
	LU_CustomStatus.DisplayCode AS IsCustomValidated, LU_CustomStatus.UserDescription AS IsCustomValidatedDesc, 

	dbo.AB_Abstract.LastName, LU_LeaveCertificates.DisplayCode AS LeaveCertificates, 
    LU_LeaveCertificates.UserDescription AS LeaveCertificatesDesc, Lookup86.DisplayCode AS Lessthan2DaysAfterAdmission, 
    Lookup86.UserDescription AS Lessthan2DaysAfterAdmitDesc, Lookup87.DisplayCode AS Lessthan2DaysPostOp, 
    Lookup87.UserDescription AS Lessthan2DaysPostOpDesc, dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.MaidenName, Lookup88.DisplayCode AS MaritalStatus, 
    Lookup88.UserDescription AS MaritalStatusDesc, dbo.AB_Abstract.NewbornChart AS MaternalNewbornChartNumber, 
    dbo.AB_Abstract.NewbornDischargeDate AS MaternalNewbornDischargeDate, LU_MB_Autopsy.DisplayCode AS MB_Autopsy, 
    LU_MB_Autopsy.UserDescription AS MB_AutopsyDesc, 
	dbo.AB_Manitoba.MB_Weight, 
	LU_MBEducation.DisplayCode AS MBEducation, 
    LU_MBEducation.UserDescription AS MBEducationDesc, LU_Meconium.DisplayCode AS Meconium, 
    LU_Meconium.UserDescription AS MeconiumDesc, LU_MedicationResuscitation.DisplayCode AS MedicationResuscitation, 
    LU_MedicationResuscitation.UserDescription AS MedicationResuscitationDesc, 
	
	LU_MentalLegalStatusUponArrivalED.DisplayCode as MentalHealth_LegalStatusUponArrivaltoED, 
	LU_MentalLegalStatusUponArrivalED.UserDescription as MentalHealth_LegalStatusUponArrivaltoEDDesc,
	LU_MentalLegalStatusAdmission.DisplayCode as MentalHealth_LegalStatusAtAdmission, 
	LU_MentalLegalStatusAdmission.UserDescription as MentalHealth_LegalStatusAtAdmissionDesc,
	LU_MentalTypeRestraint_1.DisplayCode as MentalHealth_TypeOfRestraint_01,
	LU_MentalTypeRestraint_1.UserDescription as MentalHealth_TypeOfRestraint_01Desc,
	LU_MentalTypeRestraint_2.DisplayCode as MentalHealth_TypeOfRestraint_02,
	LU_MentalTypeRestraint_2.UserDescription as MentalHealth_TypeOfRestraint_02Desc,
	LU_MentalTypeRestraint_3.DisplayCode as MentalHealth_TypeOfRestraint_03,
	LU_MentalTypeRestraint_3.UserDescription as MentalHealth_TypeOfRestraint_03Desc,
	LU_MentalTypeRestraint_4.DisplayCode as MentalHealth_TypeOfRestraint_04,
	LU_MentalTypeRestraint_4.UserDescription as MentalHealth_TypeOfRestraint_04Desc,
	LU_MentalFrequencyRestraintUse_1.DisplayCode as MentalHealth_FrequencyOfRestraint_01,
	LU_MentalFrequencyRestraintUse_1.UserDescription as MentalHealth_FrequencyOfRestraint_01Desc,
	LU_MentalFrequencyRestraintUse_2.DisplayCode as MentalHealth_FrequencyOfRestraint_02,
	LU_MentalFrequencyRestraintUse_2.UserDescription as MentalHealth_FrequencyOfRestraint_02Desc,
	LU_MentalFrequencyRestraintUse_3.DisplayCode as MentalHealth_FrequencyOfRestraint_03,
	LU_MentalFrequencyRestraintUse_3.UserDescription as MentalHealth_FrequencyOfRestraint_03Desc,
	LU_MentalFrequencyRestraintUse_4.DisplayCode as MentalHealth_FrequencyOfRestraint_04,
	LU_MentalFrequencyRestraintUse_4.UserDescription as MentalHealth_FrequencyOfRestraint_04Desc,

	Lookup89.DisplayCode AS MethodofAdmission, Lookup89.UserDescription AS MethodofAdmissionDesc, LU_MHInstFrom.DisplayCode AS MHFacilityTransferFrom, 
    LU_MHInstFrom.UserDescription AS MHFacilityTransferFromDesc, LU_MHInstTo.DisplayCode AS MHFacilityTransferTo, 
    LU_MHInstTo.UserDescription AS MHFacilityTransferToDesc, dbo.AB_Abstract.MiddleName, dbo.AB_Manitoba.MotherPHIN, 
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, 
    LU_NarconMaloxone.DisplayCode AS NarconMaloxone, LU_NarconMaloxone.UserDescription AS NarconMaloxoneDesc, 
    dbo.AB_MentalHealth.MentalNumberECT AS NumberofECT, Lookup90.DisplayCode AS OccupationalTherapy, 
    Lookup90.UserDescription AS OccupationalTherapyDesc, dbo.AB_Therapeutic.OccupationalUnits, Lookup92.DisplayCode AS OtherBlood, 
    Lookup92.UserDescription AS OtherBloodDesc, Lookup93.DisplayCode AS OtherBloodCrossMatched, 
    Lookup93.UserDescription AS OtherBloodCrossMatchedDesc, Lookup94.DisplayCode AS OtherBloodTyped, 
    Lookup94.UserDescription AS OtherBloodTypedDesc, dbo.AB_Blood.OtherBloodUnits, Lookup91.DisplayCode AS OtherMedicalDeath, 
    Lookup91.UserDescription AS OtherMedicalDeathDesc, 
    dbo.AB_Manitoba.HCNExpiredDate  as OutProvinceHealthInsuranceExpiryDate,
    dbo.AB_Manitoba.Parity, dbo.AB_CancerStaging.PathMetastasis AS PathologicalMetastasis, 
    dbo.AB_CancerStaging.PathNode AS PathologicalNode, dbo.AB_CancerStaging.PathTumor AS PathologicalTumor, 
    Lookup95.DisplayCode AS Physiotherapy, Lookup95.UserDescription AS PhysiotherapyDesc, dbo.AB_Therapeutic.PhysioUnits, 
    Lookup96.DisplayCode AS Plasma, Lookup96.UserDescription AS PlasmaDesc, Lookup97.DisplayCode AS PlasmaCrossMatched, 
    Lookup97.UserDescription AS PlasmaCrossMatchedDesc, Lookup98.DisplayCode AS PlasmaTyped, Lookup98.UserDescription AS PlasmaTypedDesc, 
    dbo.AB_Blood.PlasmaUnits, Lookup99.DisplayCode AS Platelets, Lookup99.UserDescription AS PlateletsDesc, 
    Lookup100.DisplayCode AS PlateletsCrossMatched, Lookup100.UserDescription AS PlateletsCrossMatchedDesc, 
    Lookup101.DisplayCode AS PlateletsTyped, Lookup101.UserDescription AS PlateletsTypedDesc, dbo.AB_Blood.PlateletsUnits, 
    dbo.AB_Abstract.PostalCode, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), isnull(dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.AdmitDate)) AS PostalCodeDesc, -- ED - 01682

    --PR - 03622
    LU_PositionDelviery.DisplayCode as PositionatDelivery, LU_PositionDelviery.UserDescription as PositionatDeliveryDesc, 

    LU_PostConceptionalFolicAcid.DisplayCode AS PostConceptionalFolicAcid, 
    LU_PostConceptionalFolicAcid.UserDescription AS PostConceptionalFolicAcidDesc, dbo.AB_Abstract.PostOpDays, 
    Lookup103.DisplayCode AS PreAdmitWorkup, Lookup103.UserDescription AS PreAdmitWorkupDesc, 
    LU_PreConceptionalFolicAcid.DisplayCode AS PreConceptionalFolicAcid, 
    LU_PreConceptionalFolicAcid.UserDescription AS PreConceptionalFolicAcidDesc, Lookup104.DisplayCode AS Pregnancy, 
    Lookup104.UserDescription AS PregnancyDesc, dbo.AB_Manitoba.PrenatalVisitDate, 
    LU_PrenatalVisitDateUnknown.DisplayCode AS PrenatalVisitDateUnknown, 
    LU_PrenatalVisitDateUnknown.UserDescription AS PrenatalVisitDateUnknownDesc, 
    --ED - 01702
    -- dbo.AB_Manitoba.NumberPrenatalVisits AS PrenatalVisitsNumber, 
    (case when isnull(DischargeDate, AdmitDate) < ''2008/04/01'' then dbo.AB_Manitoba.NumberPrenatalVisits else dbo.AB_Manitoba.NumberPrenatal end) AS PrenatalVisitsNumber, 

    dbo.AB_Abstract.PreOpDays, LU_Presentation.DisplayCode AS Presentation, LU_Presentation.UserDescription AS PresentationDesc, 
    --PR - 03622
    LU_PresentDelivery.DisplayCode as PresentationatDelivery, LU_PresentDelivery.UserDescription as PresentationatDeliveryDesc, 

    dbo.AB_Manitoba.PreviousName, Lookup105.DisplayCode AS PreviousPsychiartricAdmissions, 
    Lookup105.UserDescription AS PreviousPsychiartricAdmDesc, dbo.AB_Manitoba.PrimaryAddress, dbo.AB_Manitoba.PrimaryAddress2, 
    dbo.AB_Manitoba.PrimaryPhone, Lookup106.DisplayCode AS ReAdmitCode, Lookup106.UserDescription AS ReAdmitCodeDesc, 
    --PR - 04577
    LU_ReciprocalBillingStatus.DisplayCode AS ReciprocalBillingStatus, LU_ReciprocalBillingStatus.UserDescription AS ReciprocalBillingStatusDesc,

    Lookup107.DisplayCode AS RedBloodCell, Lookup107.UserDescription AS RedBloodCellDesc, 
    Lookup108.DisplayCode AS RedBloodCellCrossMatched, Lookup108.UserDescription AS RedBloodCellCrossMatchedDesc, 
    Lookup109.DisplayCode AS RedBloodCellTyped, Lookup109.UserDescription AS RedBloodCellTypedDesc, 
    dbo.AB_Blood.RedCellUnits AS RedBloodCellUnits, Lookup110.DisplayCode AS ReferredTo, Lookup110.UserDescription AS ReferredToDesc, 
    LU_RefProvider.DisplayCode AS ReferringProvider, LU_RefProvider.UserDescription AS ReferringProviderDesc, dbo.AB_Abstract.RegisterNumber, 
    dbo.AB_Manitoba.RegistrantFirstName AS RegistrantGivenName, dbo.AB_Manitoba.RegistrantLastName AS RegistrantSurname, 
    Lookup111.DisplayCode AS ReportingProvInstNumber, Lookup111.UserDescription AS ReportingProvInstNumberDesc, 
    dbo.AB_ReproductiveCare.ReprodComments AS ReproductiveCareComments, Lookup112.DisplayCode AS ResidenceCode, 
    Lookup112.UserDescription AS ResidenceCodeDesc, LUResidenceProvince.DisplayCode AS ResidenceProvince, 
    LUResidenceProvince.UserDescription AS ResidenceProvinceDesc, LUResidenceRegion.DisplayCode AS ResidenceRegion, 
    LUResidenceRegion.UserDescription AS ResidenceRegionDesc, Lookup113.DisplayCode AS RespiratoryTherapy, 
    Lookup113.UserDescription AS RespiratoryTherapyDesc, dbo.AB_Therapeutic.RespiratoryUnits, Lookup114.DisplayCode AS ResponsiblityForPayment,
    Lookup114.UserDescription AS ResponsiblityForPaymentDesc, LU_RoutineCare.DisplayCode AS RoutineCare, 
    LU_RoutineCare.UserDescription AS RoutineCareDesc, dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup115.DisplayCode AS SecondOptionalTherapy, Lookup115.UserDescription AS SecondOptionalTherapyDesc, 
    dbo.AB_Therapeutic.SecondOptionUnits AS SecondOptionalUnits, dbo.AB_Manitoba.SecondStageDuration, 
    Lookup116.DisplayCode AS SecretVIPPatient, Lookup116.UserDescription AS SecretVIPPatientDesc, Lookup117.DisplayCode AS SiteNumber, 
    Lookup117.UserDescription AS SiteNumberDesc, 
    LU_SmokingInPregnancy.DisplayCode AS SmokingInPregnancy, LU_SmokingInPregnancy.UserDescription AS SmokingInPregnancyDesc, 
    dbo.AB_Manitoba.SmokingPerDay, dbo.AB_Manitoba.SmokingQuitDate, 
    LU_SmokingQuitDateUnknown.DisplayCode AS SmokingQuitDateUnknown, 
    LU_SmokingQuitDateUnknown.UserDescription AS SmokingQuitDateUnknownDesc, Lookup118.DisplayCode AS SocialServices, 
    Lookup118.UserDescription AS SocialServicesDesc, Lookup119.DisplayCode AS SourceofReferral, 
    Lookup119.UserDescription AS SourceofReferralDesc, Lookup120.DisplayCode AS SpeechTherapy, 
    Lookup120.UserDescription AS SpeechTherapyDesc, dbo.AB_Therapeutic.SpeechUnits, LU_CodeFile_1.DisplayCode AS StakeholderType, 
    LU_CodeFile_1.UserDescription AS StakeholderTypeDesc, dbo.AB_Manitoba.FirstStageDate AS StartFirstStageDate, 
    LU_FirstStageDateUnknown.DisplayCode AS StartFirstStageDateUnknown, 
    LU_FirstStageDateUnknown.UserDescription AS StartFirstStageDateUnknownDes, dbo.AB_Manitoba.FirstStageTime AS StartFirstStageTime, 
    dbo.AB_Manitoba.SecondStageDate AS StartSecondStageDate, LU_SecondStageDateUnknown.DisplayCode AS StartSecondStageDateUnknown, 
    LU_SecondStageDateUnknown.UserDescription AS StartSecondStageDateUnknown_D, dbo.AB_Manitoba.SecondStageTime AS StartSecondStageTime, 
    Lookup121.DisplayCode AS Sterilization, Lookup121.UserDescription AS SterilizationDesc, dbo.AB_Abstract.RecordType AS SubmissionType, 
    Lookup122.DisplayCode AS SubsequentOR, Lookup122.UserDescription AS SubsequentORDesc, Lookup123.DisplayCode AS Suicide, 
    Lookup123.UserDescription AS SuicideDesc, dbo.AB_CancerStaging.SummaryStage, Lookup124.DisplayCode AS SurgicalCase, 
    Lookup124.UserDescription AS SurgicalCaseDesc, Lookup125.DisplayCode AS TransfusionGiven, 
    Lookup125.UserDescription AS TransfusionGivenDesc, Lookup126.DisplayCode AS Trauma, Lookup126.UserDescription AS TraumaDesc, 
    Lookup127.DisplayCode AS TSICoder, Lookup127.UserDescription AS TSICoderDesc, dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, 
    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, Lookup128.DisplayCode AS UnplannedReadmission, 
    Lookup128.UserDescription AS UnplannedReadmissionDesc, 
	dbo.AB_Abstract.UniversalEpisodeIdentifier,
    dbo.AB_Abstract.WaitTimeER AS WaitTimeInEmerg, 
    dbo.AB_Abstract.WaitTimeERHour AS WaitTimeInEmergHour, 
    dbo.AB_Abstract.Weight AS Weightingrams, 
	(case when isnumeric(replace(AB_Abstract.WeightKilo, '','', ''.'')) = 1 then cast(replace(AB_Abstract.WeightKilo, '','', ''.'') as dec(7, 3)) else null end) as WeightKG,
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID,
    dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_Provider LU_RefProvider with (nolock) on dbo.AB_Abstract.RefPhysician = LU_RefProvider.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_DecAdmitTimeUnknown with (nolock) on dbo.AB_Abstract.DecisionAdmitTimeUnknown = LU_DecAdmitTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_1 with (nolock) on dbo.AB_Abstract.StakeHolder = LU_CodeFile_1.Code LEFT OUTER JOIN
    dbo.AB_Manitoba with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Manitoba.AbstractID left join
    dbo.LU_CodeFile LU_Meconium with (nolock) on LU_Meconium.Code = dbo.AB_Manitoba.Meconium LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Feeding with (nolock) on dbo.AB_Manitoba.Feeding = LU_Feeding.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_ChestCompressions with (nolock) on dbo.AB_Manitoba.ChestCompressions = LU_ChestCompressions.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_NarconMaloxone with (nolock) on dbo.AB_Manitoba.NarconMaloxone = LU_NarconMaloxone.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_MedicationResuscitation with (nolock) on 
    dbo.AB_Manitoba.MedicationResuscitation = LU_MedicationResuscitation.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_IntubationNotMeconium with (nolock) on dbo.AB_Manitoba.IntubationNotMeconium = LU_IntubationNotMeconium.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_BagVentilation with (nolock) on dbo.AB_Manitoba.BagVentilation = LU_BagVentilation.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_FreeFlowOxygen with (nolock) on dbo.AB_Manitoba.FreeFlowOxygen = LU_FreeFlowOxygen.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_RoutineCare with (nolock) on dbo.AB_Manitoba.RoutineCare = LU_RoutineCare.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Presentation with (nolock) on dbo.AB_Manitoba.Presentation = LU_Presentation.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_SecondStageDateUnknown with (nolock) on 
    dbo.AB_Manitoba.SecondStageDateUnknown = LU_SecondStageDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_FirstStageDateUnknown with (nolock) on dbo.AB_Manitoba.FirstStageDateUnknown = LU_FirstStageDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PostConceptionalFolicAcid with (nolock) on 
    dbo.AB_Manitoba.PostConceptionalFolicAcid = LU_PostConceptionalFolicAcid.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PreConceptionalFolicAcid with (nolock) on dbo.AB_Manitoba.PreConceptionalFolicAcid = LU_PreConceptionalFolicAcid.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Days_WeekAlcoholConsumed with (nolock) on 
    dbo.AB_Manitoba.Days_WeekAlcoholConsumed = LU_Days_WeekAlcoholConsumed.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AlcoholDuringPregnancy with (nolock) on dbo.AB_Manitoba.AlcoholDuringPregnancy = LU_AlcoholDuringPregnancy.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_SmokingQuitDateUnknown with (nolock) on 
    dbo.AB_Manitoba.SmokingQuitDateUnknown = LU_SmokingQuitDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MBEducation with (nolock) on dbo.AB_Manitoba.ObsEducation = LU_MBEducation.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PrenatalVisitDateUnknown with (nolock) on 
    dbo.AB_Manitoba.PrenatalVisitDateUnknown = LU_PrenatalVisitDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_LeaveCertificates with (nolock) on dbo.AB_Manitoba.LeaveCertificates = LU_LeaveCertificates.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_Elopements with (nolock) on dbo.AB_Manitoba.Elopements = LU_Elopements.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MB_Autopsy with (nolock) on dbo.AB_Manitoba.MB_Autopsy = LU_MB_Autopsy.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MHInstTo with (nolock) on dbo.AB_Manitoba.MHInstTo = LU_MHInstTo.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MHInstFrom with (nolock) on dbo.AB_Manitoba.MHInstFrom = LU_MHInstFrom.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AbstractType with (nolock) on dbo.AB_Manitoba.AbstractType = LU_AbstractType.Code LEFT OUTER JOIN
    dbo.LU_CareType with (nolock) on dbo.AB_Abstract.CareType = dbo.LU_CareType.Code LEFT OUTER JOIN
    dbo.LU_AbstractOverflow Lookup2 with (nolock) on dbo.AB_Abstract.AbstractOverflow = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_NurseArea Lookup5 with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup6 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup7 with (nolock) on dbo.AB_Abstract.DischargeAgeCode = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup28 with (nolock) on dbo.AB_Abstract.AttendingPhysician = Lookup28.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup50 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup54 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup54.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup55 with (nolock) on dbo.AB_Abstract.Complication = Lookup55.Code LEFT OUTER JOIN
    dbo.U_Users Lookup60 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_I Lookup63 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup63.Code LEFT OUTER JOIN
    dbo.LU_NurseArea Lookup64 with (nolock) on dbo.AB_Abstract.DischargeNurseArea = Lookup64.Code LEFT OUTER JOIN
    dbo.LU_TherDischPlan Lookup65 with (nolock) on dbo.AB_Abstract.DischargePlanning = Lookup65.Code LEFT OUTER JOIN
    dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_Glasgow Lookup73 with (nolock) on dbo.AB_Abstract.GlasgowComaScale = Lookup73.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup77 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup77.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionFrom_Type with (nolock) on dbo.AB_Abstract.InstitutionFromType = LU_InstitutionFrom_Type.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup78 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup78.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionTo_Type with (nolock) on dbo.AB_Abstract.InstitutionToType = LU_InstitutionTo_Type.Code LEFT OUTER JOIN

    dbo.U_Users Lookup79 with (nolock) on dbo.AB_Abstract.InterfaceCoder = Lookup79.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup80 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup80.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup81 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup81.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus Lookup82 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup82.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup83 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup84 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_CustomStatus with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_CustomStatus.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup85 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_MaritalStatus Lookup88 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup88.Code LEFT OUTER JOIN
    dbo.LU_TherPreAdmitWorkUp Lookup103 with (nolock) on dbo.AB_Abstract.PreAdmitWorkUp = Lookup103.Code LEFT OUTER JOIN
    dbo.LU_ReAdmitCode Lookup106 with (nolock) on dbo.AB_Abstract.ReAdmitCode = Lookup106.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup111 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup111.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_Region LUResidenceRegion with (nolock) on Lookup112.RegionCode = LUResidenceRegion.Code LEFT OUTER JOIN
    dbo.LU_Province LUResidenceProvince with (nolock) on Lookup112.ProvinceCode = LUResidenceProvince.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup116 with (nolock) on dbo.AB_Abstract.Secret = Lookup116.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup117 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup117.Code LEFT OUTER JOIN
    dbo.LU_TherSocialService Lookup118 with (nolock) on dbo.AB_Abstract.SocialService = Lookup118.Code LEFT OUTER JOIN
    dbo.LU_SurgicalCode Lookup124 with (nolock) on dbo.AB_Abstract.SurgicalCase = Lookup124.Code LEFT OUTER JOIN
    dbo.U_Users Lookup127 with (nolock) on dbo.AB_Abstract.TSICoder = Lookup127.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup128 with (nolock) on dbo.AB_Abstract.UnplanReAdmit = Lookup128.Code LEFT OUTER JOIN
    dbo.AB_Ancillary with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Ancillary.AbstractID LEFT OUTER JOIN
    dbo.LU_Ancillary1 Lookup11 with (nolock) on dbo.AB_Ancillary.AncillaryField1 = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Ancillary10 Lookup12 with (nolock) on dbo.AB_Ancillary.AncillaryField10 = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_Ancillary11 Lookup13 with (nolock) on dbo.AB_Ancillary.AncillaryField11 = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_Ancillary12 Lookup14 with (nolock) on dbo.AB_Ancillary.AncillaryField12 = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_Ancillary13 Lookup15 with (nolock) on dbo.AB_Ancillary.AncillaryField13 = Lookup15.Code LEFT OUTER JOIN
    dbo.LU_Ancillary14 Lookup16 with (nolock) on dbo.AB_Ancillary.AncillaryField14 = Lookup16.Code LEFT OUTER JOIN
    dbo.LU_Ancillary15 Lookup17 with (nolock) on dbo.AB_Ancillary.AncillaryField15 = Lookup17.Code LEFT OUTER JOIN
    dbo.LU_Ancillary16 Lookup18 with (nolock) on dbo.AB_Ancillary.AncillaryField16 = Lookup18.Code LEFT OUTER JOIN
    dbo.LU_Ancillary17 Lookup19 with (nolock) on dbo.AB_Ancillary.AncillaryField17 = Lookup19.Code LEFT OUTER JOIN
    dbo.LU_Ancillary2 Lookup20 with (nolock) on dbo.AB_Ancillary.AncillaryField2 = Lookup20.Code LEFT OUTER JOIN
    dbo.LU_Ancillary3 Lookup21 with (nolock) on dbo.AB_Ancillary.AncillaryField3 = Lookup21.Code LEFT OUTER JOIN
    dbo.LU_Ancillary4 Lookup22 with (nolock) on dbo.AB_Ancillary.AncillaryField4 = Lookup22.Code LEFT OUTER JOIN
    dbo.LU_Ancillary5 Lookup23 with (nolock) on dbo.AB_Ancillary.AncillaryField5 = Lookup23.Code LEFT OUTER JOIN
    dbo.LU_Ancillary6 Lookup24 with (nolock) on dbo.AB_Ancillary.AncillaryField6 = Lookup24.Code LEFT OUTER JOIN
    dbo.LU_Ancillary7 Lookup25 with (nolock) on dbo.AB_Ancillary.AncillaryField7 = Lookup25.Code LEFT OUTER JOIN
    dbo.LU_Ancillary8 Lookup26 with (nolock) on dbo.AB_Ancillary.AncillaryField8 = Lookup26.Code LEFT OUTER JOIN
    dbo.LU_Ancillary9 Lookup27 with (nolock) on dbo.AB_Ancillary.AncillaryField9 = Lookup27.Code LEFT OUTER JOIN
    dbo.AB_BasicOption with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_BasicOption.AbstractID LEFT OUTER JOIN
    dbo.LU_BasicOption1 Lookup31 with (nolock) on dbo.AB_BasicOption.BasicOption1 = Lookup31.Code LEFT OUTER JOIN
    dbo.LU_BasicOption10 Lookup32 with (nolock) on dbo.AB_BasicOption.BasicOption10 = Lookup32.Code LEFT OUTER JOIN
    dbo.LU_BasicOption11 Lookup33 with (nolock) on dbo.AB_BasicOption.BasicOption11 = Lookup33.Code LEFT OUTER JOIN
    dbo.LU_BasicOption12 Lookup34 with (nolock) on dbo.AB_BasicOption.BasicOption12 = Lookup34.Code LEFT OUTER JOIN
    dbo.LU_BasicOption13 Lookup35 with (nolock) on dbo.AB_BasicOption.BasicOption13 = Lookup35.Code LEFT OUTER JOIN
    dbo.LU_BasicOption14 Lookup36 with (nolock) on dbo.AB_BasicOption.BasicOption14 = Lookup36.Code LEFT OUTER JOIN
    dbo.LU_BasicOption15 Lookup37 with (nolock) on dbo.AB_BasicOption.BasicOption15 = Lookup37.Code LEFT OUTER JOIN
    dbo.LU_BasicOption16 Lookup38 with (nolock) on dbo.AB_BasicOption.BasicOption16 = Lookup38.Code LEFT OUTER JOIN
    dbo.LU_BasicOption17 Lookup39 with (nolock) on dbo.AB_BasicOption.BasicOption17 = Lookup39.Code LEFT OUTER JOIN
    dbo.LU_BasicOption18 Lookup40 with (nolock) on dbo.AB_BasicOption.BasicOption18 = Lookup40.Code LEFT OUTER JOIN
    dbo.LU_BasicOption19 Lookup41 with (nolock) on dbo.AB_BasicOption.BasicOption19 = Lookup41.Code LEFT OUTER JOIN
    dbo.LU_BasicOption2 Lookup42 with (nolock) on dbo.AB_BasicOption.BasicOption2 = Lookup42.Code LEFT OUTER JOIN
    dbo.LU_BasicOption3 Lookup43 with (nolock) on dbo.AB_BasicOption.BasicOption3 = Lookup43.Code LEFT OUTER JOIN
    dbo.LU_BasicOption4 Lookup44 with (nolock) on dbo.AB_BasicOption.BasicOption4 = Lookup44.Code LEFT OUTER JOIN
    dbo.LU_BasicOption5 Lookup45 with (nolock) on dbo.AB_BasicOption.BasicOption5 = Lookup45.Code LEFT OUTER JOIN
    dbo.LU_BasicOption6 Lookup46 with (nolock) on dbo.AB_BasicOption.BasicOption6 = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_BasicOption7 Lookup47 with (nolock) on dbo.AB_BasicOption.BasicOption7 = Lookup47.Code LEFT OUTER JOIN
    dbo.LU_BasicOption8 Lookup48 with (nolock) on dbo.AB_BasicOption.BasicOption8 = Lookup48.Code LEFT OUTER JOIN
    dbo.LU_BasicOption9 Lookup49 with (nolock) on dbo.AB_BasicOption.BasicOption9 = Lookup49.Code LEFT OUTER JOIN
    dbo.AB_Blood with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Blood.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup8 with (nolock) on dbo.AB_Blood.Albumin = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup9 with (nolock) on dbo.AB_Blood.AlbuminXMatch = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup10 with (nolock) on dbo.AB_Blood.AlbuminTyped = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup29 with (nolock) on dbo.AB_Blood.AutoTransfusion = Lookup29.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup92 with (nolock) on dbo.AB_Blood.OtherBlood = Lookup92.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup93 with (nolock) on dbo.AB_Blood.OtherBloodXMatch = Lookup93.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup94 with (nolock) on dbo.AB_Blood.OtherBloodTyped = Lookup94.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup96 with (nolock) on dbo.AB_Blood.Plasma = Lookup96.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup97 with (nolock) on dbo.AB_Blood.PlasmaXMatch = Lookup97.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup98 with (nolock) on dbo.AB_Blood.PlasmaTyped = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup99 with (nolock) on dbo.AB_Blood.Platelets = Lookup99.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup100 with (nolock) on dbo.AB_Blood.PlateletsXMatch = Lookup100.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup101 with (nolock) on dbo.AB_Blood.PlateletsTyped = Lookup101.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup107 with (nolock) on dbo.AB_Blood.RedBloodCell = Lookup107.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup108 with (nolock) on dbo.AB_Blood.RedCellXMatch = Lookup108.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup109 with (nolock) on dbo.AB_Blood.RedCellTyped = Lookup109.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup125 with (nolock) on dbo.AB_Blood.TransfusionIndicator = Lookup125.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_AntithrombinIII with (nolock) on dbo.AB_Blood.AntithrombinIII = LU_AntithrombinIII.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_C1Inhibitor with (nolock) on dbo.AB_Blood.C1Inhibitor = LU_C1Inhibitor.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryoprecipitatePlasma with (nolock) on dbo.AB_Blood.CryoprecipitatePlasma = LU_CryoprecipitatePlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryosupernatantPlasma with (nolock) on dbo.AB_Blood.CryosupernatantPlasma = LU_CryosupernatantPlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_FEIBA with (nolock) on dbo.AB_Blood.FEIBA = LU_FEIBA.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_Fibrinogen with (nolock) on dbo.AB_Blood.Fibrinogen = LU_Fibrinogen.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_IVIG_SCIG with (nolock) on dbo.AB_Blood.IVIG_SCIG = LU_IVIG_SCIG.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_PCC with (nolock) on dbo.AB_Blood.PCC = LU_PCC.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_ProteinC_OtherFactors with (nolock) on dbo.AB_Blood.ProteinC_OtherFactors = LU_ProteinC_OtherFactors.Code LEFT OUTER JOIN


    dbo.AB_DeathInformation with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_DeathInformation.AbstractID LEFT OUTER JOIN
    dbo.LU_AutopsyDeath Lookup30 with (nolock) on dbo.AB_DeathInformation.AutopsyPerformed = Lookup30.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup51 with (nolock) on dbo.AB_DeathInformation.DeathTwoTenPO = Lookup51.Code LEFT OUTER JOIN
    dbo.LU_CoronerCase Lookup59 with (nolock) on dbo.AB_DeathInformation.CoronerCase = Lookup59.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup61 with (nolock) on dbo.AB_DeathInformation.DeathInOR = Lookup61.Code left join
    dbo.LU_SCU_Death Lookup62 with (nolock) on Lookup62.Code = dbo.AB_DeathInformation.DeathInSCU LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup74 with (nolock) on dbo.AB_DeathInformation.DeathGreaterTenPO = Lookup74.Code left join
    dbo.LU_YesBlank Lookup86 with (nolock) on Lookup86.Code = dbo.AB_DeathInformation.DeathAfterAdmit LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup87 with (nolock) on dbo.AB_DeathInformation.DeathLessTwoPO = Lookup87.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup91 with (nolock) on dbo.AB_DeathInformation.OtherDeath = Lookup91.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup104 with (nolock) on dbo.AB_DeathInformation.PregnancyDeath = Lookup104.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup126 with (nolock) on dbo.AB_DeathInformation.TraumaDeath = Lookup126.Code left join
    
	dbo.AB_MentalHealth with (nolock) on dbo.AB_MentalHealth.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup1 with (nolock) on dbo.AB_MentalHealth.MentalAWOL = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_MentalLegalStatus Lookup53 with (nolock) on dbo.AB_MentalHealth.MentalLegalStatus = Lookup53.Code left join
    dbo.LU_YesNoNumeric Lookup66 with (nolock) on Lookup66.Code = dbo.AB_MentalHealth.MentalECTTreatment LEFT OUTER JOIN
    dbo.LU_MentalEducation Lookup67 with (nolock) on dbo.AB_MentalHealth.MentalEducation = Lookup67.Code LEFT OUTER JOIN
    dbo.LU_MentalEmployment Lookup68 with (nolock) on dbo.AB_MentalHealth.MentalEmployment = Lookup68.Code LEFT OUTER JOIN
    dbo.LU_MentalFinancial Lookup70 with (nolock) on dbo.AB_MentalHealth.MentalFinancial = Lookup70.Code LEFT OUTER JOIN
    dbo.LU_MentalAdmitMethod Lookup89 with (nolock) on dbo.AB_MentalHealth.MentalAdmitMethod = Lookup89.Code LEFT OUTER JOIN
    dbo.LU_MentalPrevPsych Lookup105 with (nolock) on dbo.AB_MentalHealth.MentalPrevPsych = Lookup105.Code left join
    dbo.LU_MentalReferral Lookup110 with (nolock) on Lookup110.Code = dbo.AB_MentalHealth.MentalReferralTo LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup119 with (nolock) on dbo.AB_MentalHealth.MentalReferralSource = Lookup119.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup123 with (nolock) on dbo.AB_MentalHealth.MentalSuicide = Lookup123.Code LEFT OUTER JOIN

	dbo.LU_MentalLegalStatusUponArrivalED with (nolock) on dbo.AB_MentalHealth.LegalStatusUponArrivaltoED = LU_MentalLegalStatusUponArrivalED.Code LEFT OUTER JOIN
	dbo.LU_MentalLegalStatusAdmission with (nolock) on dbo.AB_MentalHealth.LegalStatusAtAdmission = LU_MentalLegalStatusAdmission.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_1 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint01 = LU_MentalTypeRestraint_1.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_1 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint01 = LU_MentalFrequencyRestraintUse_1.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_2 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint02 = LU_MentalTypeRestraint_2.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_2 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint02 = LU_MentalFrequencyRestraintUse_2.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_3 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint03 = LU_MentalTypeRestraint_3.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_3 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint03 = LU_MentalFrequencyRestraintUse_3.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_4 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint04 = LU_MentalTypeRestraint_4.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_4 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint04 = LU_MentalFrequencyRestraintUse_4.Code LEFT OUTER JOIN


    dbo.AB_Therapeutic with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Therapeutic.AbstractID LEFT OUTER JOIN
    dbo.LU_TherOption1 Lookup71 with (nolock) on dbo.AB_Therapeutic.FirstOptionTherapy = Lookup71.Code LEFT OUTER JOIN
    dbo.LU_TherOccupation Lookup90 with (nolock) on dbo.AB_Therapeutic.OccupationalTherapy = Lookup90.Code left join
    dbo.LU_TherPhysio Lookup95 with (nolock) on Lookup95.Code = dbo.AB_Therapeutic.PhysioTherapy LEFT OUTER JOIN
    dbo.LU_TherRespiratory Lookup113 with (nolock) on dbo.AB_Therapeutic.RespiratoryTherapy = Lookup113.Code LEFT OUTER JOIN
    dbo.LU_TherOption2 Lookup115 with (nolock) on dbo.AB_Therapeutic.SecondOptionTherapy = Lookup115.Code LEFT OUTER JOIN
    dbo.LU_TherSpeech Lookup120 with (nolock) on dbo.AB_Therapeutic.SpeechTherapy = Lookup120.Code LEFT OUTER JOIN
    dbo.AB_ReproductiveCare with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_ReproductiveCare.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup52 with (nolock) on dbo.AB_ReproductiveCare.BreastFeeding = Lookup52.Code left join
    dbo.LU_ReprodComplication Lookup56 with (nolock) on Lookup56.Code = dbo.AB_ReproductiveCare.Complication1 left join
    dbo.LU_ReprodComplication Lookup57 with (nolock) on Lookup57.Code = dbo.AB_ReproductiveCare.Complication2 LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup58 with (nolock) on dbo.AB_ReproductiveCare.Complication3 = Lookup58.Code LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup76 with (nolock) on dbo.AB_ReproductiveCare.InitialOR = Lookup76.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup121 with (nolock) on dbo.AB_ReproductiveCare.Sterilization = Lookup121.Code LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup122 with (nolock) on dbo.AB_ReproductiveCare.SubsequentOR = Lookup122.Code LEFT OUTER JOIN
    dbo.AB_CancerStaging with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_CancerStaging.AbstractID LEFT OUTER JOIN
    dbo.H_HospitalProfile with (nolock) on dbo.AB_Abstract.HospitalID = dbo.H_HospitalProfile.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TimeLeftERUnknown with (nolock) on dbo.AB_Abstract.TimeLeftERUnknown = LU_TimeLeftERUnknown.Code 
    --PR - 03622
    LEFT OUTER JOIN dbo.LU_CodeFile LU_PresentDelivery with (nolock) on dbo.AB_Manitoba.PresentDelivery = LU_PresentDelivery.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_PositionDelviery with (nolock) on dbo.AB_Manitoba.PositionDelviery = LU_PositionDelviery.Code 
--ED - 01750
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AnestheticLabor with (nolock) on dbo.AB_Manitoba.AnestheticLabor = LU_AnestheticLabor.Code 
--PR - 04577
    LEFT OUTER JOIN dbo.LU_ReciprocalBillingStatus with (nolock) on dbo.AB_Abstract.IsReciprocalBilling = LU_ReciprocalBillingStatus.Code 
--PR - 05489
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AdmitTimeUnknown with (nolock) on dbo.AB_Abstract.AdmitTimeUnknown = LU_AdmitTimeUnknown.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_DischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LU_DischargeTimeUnknown.Code 
    
    LEFT OUTER JOIN dbo.LU_CodeFile LU_SmokingInPregnancy with (nolock) on dbo.AB_Manitoba.SmokingInPregnancy = LU_SmokingInPregnancy.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AlcoholQuitDateUnknown with (nolock) on dbo.AB_Manitoba.AlcoholQuitDateUnknown = LU_AlcoholQuitDateUnknown.Code 
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType IN (1, 2)) 
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
----EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Abstracting_Profile_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[I10_Abstracting_Profile_VR]
AS
SELECT     dbo.AB_ReproductiveCare.PrevTermDelivery AS [#ofPreviousDeliveries], 
    dbo.AB_ReproductiveCare.PrevLiveBirths AS [#ofPreviousLiveBirths], 
    dbo.AB_ReproductiveCare.PrevPreTermDelivery AS [#ofPreviousPreTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevSpontAbortions AS [#ofPrevSpontaneousAbortions], 
    dbo.AB_ReproductiveCare.PrevInduceAbortions AS [#ofPrevTherapueticAbortions], 
    --'''' AS AbstractNotes, PR - 05199
    dbo.AB_Abstract.AbstractNumber, 
    Lookup2.DisplayCode AS AbstractOverflow, Lookup2.UserDescription AS AbstractOverflowDesc, LU_AbstractType.DisplayCode AS AbstractType, 
    LU_AbstractType.UserDescription AS AbstractTypeDesc, dbo.AB_Abstract.AcuteLOS, dbo.AB_Abstract.AdmitDate AS AdmissionDate, 
    dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
    --PR - 05489
    LU_AdmitTimeUnknown.DisplayCode as AdmissionTimeUnknown, LU_AdmitTimeUnknown.UserDescription as AdmissionTimeUnknownDesc,
    Lookup3.DisplayCode AS AdmitbyAmbulance, Lookup3.UserDescription AS AdmitbyAmbulanceDesc, 
    Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, Lookup5.DisplayCode AS AdmitNursingAreaUnitLocation, 
    Lookup5.UserDescription AS AdmittingNursingAreaUnitLDesc, Lookup6.DisplayCode AS AgeCode, Lookup6.UserDescription AS AgeCodeDesc, 
    dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, dbo.AB_Abstract.DischargeAge AS AgeUponDischarge, 
    Lookup7.DisplayCode AS AgeUponDischargeCode, Lookup7.UserDescription AS AgeUponDischargeCodeDesc, Lookup8.DisplayCode AS Albumin, 
    Lookup9.DisplayCode AS AlbuminCrossMatched, Lookup9.UserDescription AS AlbuminCrossMatchedDesc, Lookup8.UserDescription AS AlbuminDesc, 
    Lookup10.DisplayCode AS AlbuminTyped, Lookup10.UserDescription AS AlbuminTypedDesc, dbo.AB_Blood.AlbuminUnits, dbo.AB_Abstract.ALCLOS, 
    LU_AlcoholDuringPregnancy.DisplayCode AS AlcoholDuringPregnancy, LU_AlcoholDuringPregnancy.UserDescription AS AlcoholDuringPregnancyDesc, 
    AlcoholQuitDate,
    LU_AlcoholQuitDateUnknown.DisplayCode AS AlcoholQuitDateUnknown, LU_AlcoholQuitDateUnknown.UserDescription AS AlcoholQuitDateUnknownDesc, 
    Lookup11.DisplayCode AS AncillaryField1, Lookup11.UserDescription AS AncillaryField1Desc, Lookup12.DisplayCode AS AncillaryField10, 
    Lookup12.UserDescription AS AncillaryField10Desc, Lookup13.DisplayCode AS AncillaryField11, Lookup13.UserDescription AS AncillaryField11Desc, 
    Lookup14.DisplayCode AS AncillaryField12, Lookup14.UserDescription AS AncillaryField12Desc, Lookup15.DisplayCode AS AncillaryField13, 
    Lookup15.UserDescription AS AncillaryField13Desc, Lookup16.DisplayCode AS AncillaryField14, Lookup16.UserDescription AS AncillaryField14Desc, 
    Lookup17.DisplayCode AS AncillaryField15, Lookup17.UserDescription AS AncillaryField15Desc, Lookup18.DisplayCode AS AncillaryField16, 
    Lookup18.UserDescription AS AncillaryField16Desc, Lookup19.DisplayCode AS AncillaryField17, Lookup19.UserDescription AS AncillaryField17Desc, 
    Lookup20.DisplayCode AS AncillaryField2, Lookup20.UserDescription AS AncillaryField2Desc, Lookup21.DisplayCode AS AncillaryField3, 
    Lookup21.UserDescription AS AncillaryField3Desc, Lookup22.DisplayCode AS AncillaryField4, Lookup22.UserDescription AS AncillaryField4Desc, 
    Lookup23.DisplayCode AS AncillaryField5, Lookup23.UserDescription AS AncillaryField5Desc, Lookup24.DisplayCode AS AncillaryField6, 
    Lookup24.UserDescription AS AncillaryField6Desc, Lookup25.DisplayCode AS AncillaryField7, Lookup25.UserDescription AS AncillaryField7Desc, 
    Lookup26.DisplayCode AS AncillaryField8, Lookup26.UserDescription AS AncillaryField8Desc, Lookup27.DisplayCode AS AncillaryField9, 
    Lookup27.UserDescription AS AncillaryField9Desc,
    --ED - 01750
    LU_AnestheticLabor.DisplayCode as AnalgesicAnestheticDuringLabor, LU_AnestheticLabor.UserDescription as AnalgesicAnestheticDuringLaborDesc,
    dbo.AB_Manitoba.Apgar1Min, dbo.AB_Manitoba.Apgar5Min, 
    dbo.AB_Abstract.ArrivalDate AS ArrivalDateInER, dbo.AB_Abstract.ArrivalTime AS ArrivalTimeInER, Lookup28.DisplayCode AS AttendingPhysician, 
    Lookup28.UserDescription AS AttendingPhysicianDesc, Lookup30.DisplayCode AS AutopsyPerformed, 
    Lookup30.UserDescription AS AutopsyPerformedDesc, Lookup29.DisplayCode AS AutoTransfusion, 
    Lookup29.UserDescription AS AutoTransfusionDesc, Lookup1.DisplayCode AS AWOL, Lookup1.UserDescription AS AWOLDesc, 
    LU_BagVentilation.DisplayCode AS BagVentilation, LU_BagVentilation.UserDescription AS BagVentilationDesc, 
    Lookup31.DisplayCode AS BasicOption1, Lookup31.UserDescription AS BasicOption1Desc, Lookup32.DisplayCode AS BasicOption10, 
    Lookup32.UserDescription AS BasicOption10Desc, Lookup33.DisplayCode AS BasicOption11, Lookup33.UserDescription AS BasicOption11Desc, 
    Lookup34.DisplayCode AS BasicOption12, Lookup34.UserDescription AS BasicOption12Desc, Lookup35.DisplayCode AS BasicOption13, 
    Lookup35.UserDescription AS BasicOption13Desc, Lookup36.DisplayCode AS BasicOption14, Lookup36.UserDescription AS BasicOption14Desc, 
    Lookup37.DisplayCode AS BasicOption15, Lookup37.UserDescription AS BasicOption15Desc, Lookup38.DisplayCode AS BasicOption16, 
    Lookup38.UserDescription AS BasicOption16Desc, Lookup39.DisplayCode AS BasicOption17, Lookup39.UserDescription AS BasicOption17Desc, 
    Lookup40.DisplayCode AS BasicOption18, Lookup40.UserDescription AS BasicOption18Desc, Lookup41.DisplayCode AS BasicOption19, 
    Lookup41.UserDescription AS BasicOption19Desc, Lookup42.DisplayCode AS BasicOption2, Lookup42.UserDescription AS BasicOption2Desc, 
    Lookup43.DisplayCode AS BasicOption3, Lookup43.UserDescription AS BasicOption3Desc, Lookup44.DisplayCode AS BasicOption4, 
    Lookup44.UserDescription AS BasicOption4Desc, Lookup45.DisplayCode AS BasicOption5, Lookup45.UserDescription AS BasicOption5Desc, 
    Lookup46.DisplayCode AS BasicOption6, Lookup46.UserDescription AS BasicOption6Desc, Lookup47.DisplayCode AS BasicOption7, 
    Lookup47.UserDescription AS BasicOption7Desc, Lookup48.DisplayCode AS BasicOption8, Lookup48.UserDescription AS BasicOption8Desc, 
    Lookup49.DisplayCode AS BasicOption9, Lookup49.UserDescription AS BasicOption9Desc, dbo.AB_Abstract.BatchNumber, 
    Lookup50.DisplayCode AS BatchPeriod, Lookup50.UserDescription AS BatchPeriodDesc, 

	LU_AntithrombinIII.DisplayCode AS Blood_AntithrombinIII, LU_AntithrombinIII.UserDescription AS Blood_AntithrombinIIIDesc,
	LU_C1Inhibitor.DisplayCode AS Blood_C1Inhibitor, LU_C1Inhibitor.UserDescription AS Blood_C1InhibitorDesc,
	LU_CryoprecipitatePlasma.DisplayCode AS Blood_CryoprecipitatePlasma, LU_CryoprecipitatePlasma.UserDescription AS Blood_CryoprecipitatePlasmaDesc,
	LU_CryosupernatantPlasma.DisplayCode AS Blood_CryosupernatantPlasma, LU_CryosupernatantPlasma.UserDescription AS Blood_CryosupernatantPlasmaDesc,
	LU_FEIBA.DisplayCode AS Blood_FEIBA, LU_FEIBA.UserDescription AS Blood_FEIBADesc,
	LU_Fibrinogen.DisplayCode AS Blood_Fibrinogen, LU_Fibrinogen.UserDescription AS Blood_FibrinogenDesc,
	LU_IVIG_SCIG.DisplayCode AS Blood_IVIG_SCIG, LU_IVIG_SCIG.UserDescription AS Blood_IVIG_SCIGDesc,
	LU_PCC.DisplayCode AS Blood_PCC, LU_PCC.UserDescription AS Blood_PCCDesc,
	LU_ProteinC_OtherFactors.DisplayCode AS Blood_ProteinC_OtherFactors, LU_ProteinC_OtherFactors.UserDescription AS Blood_ProteinC_OtherFactorsDesc,



    --PR - 06087
    BatchPeriod_BC = (case when left(Lookup111.CIHIValue, 1) <> ''9'' then null
                         when Lookup50.DisplayCode is not null then Lookup50.DisplayCode 
                         when DischargeDate is null then null
                         else (select top 1 DisplayCode from LU_BatchPeriod where DischargeDate between CIHIDateFrom and CIHIDateTo)
                    end),
    dbo.AB_Abstract.BatchYear, 
    Lookup51.DisplayCode AS Between210DaysPostOp, Lookup51.UserDescription AS Between210DaysPostOpDesc, dbo.AB_Abstract.BirthDate, 
    Lookup52.DisplayCode AS BreastFeedingonDischarge, Lookup52.UserDescription AS BreastFeedingonDischargeDesc, 
    dbo.LU_CareType.DisplayCode AS CareType, dbo.LU_CareType.UserDescription AS CareTypeDesc, Lookup53.DisplayCode AS ChangeinLegalStatus, 
    Lookup53.UserDescription AS ChangeinLegalStatusDesc, dbo.AB_Abstract.ChartNumber, LU_ChestCompressions.DisplayCode AS ChestCompressions,
    LU_ChestCompressions.UserDescription AS ChestCompressionsDesc, dbo.AB_Abstract.ChiefComplaint AS ChiefComplaintUponAdmission, 
    dbo.AB_CancerStaging.ClinicalMetastasis, dbo.AB_CancerStaging.ClinicalNode, dbo.AB_CancerStaging.ClinicalTumor, 
    Lookup54.DisplayCode AS CoderNumber, Lookup54.UserDescription AS CoderNumberDesc, Lookup55.DisplayCode AS Comorbidity, 
    Lookup55.UserDescription AS ComorbidityDesc, Lookup55.DisplayCode AS Complication, Lookup55.UserDescription AS ComplicationDesc, 
    Lookup56.DisplayCode AS Complication1, Lookup56.UserDescription AS Complication1Desc, Lookup57.DisplayCode AS Complication2, 
    Lookup57.UserDescription AS Complication2Desc, Lookup58.DisplayCode AS Complication3, Lookup58.UserDescription AS Complication3Desc, 
    Lookup58.DefaultDescription AS Complication3Desc_D, Lookup59.DisplayCode AS CoronerCase, Lookup59.UserDescription AS CoronerCaseDesc, 
    Lookup60.DisplayCode AS DataEntryCoder, Lookup60.UserDescription AS DataEntryCoderDesc, 
    dbo.AB_ReproductiveCare.LastMensesDate AS DateofLastMenses, dbo.AB_Abstract.DateReadyDischarge AS DateReadyForDischarge, 
    dbo.AB_Abstract.CIHIDateSent AS DateSenttoCIHI, LU_Days_WeekAlcoholConsumed.DisplayCode AS Days_WeekAlcoholConsumed, 
    LU_Days_WeekAlcoholConsumed.UserDescription AS Days_WeekAlcoholConsumedDesc, Lookup61.DisplayCode AS DeathInOR, 
    Lookup61.UserDescription AS DeathInORDesc, Lookup62.DisplayCode AS DeathInSCU, Lookup62.UserDescription AS DeathInSCUDesc, 
    dbo.AB_Manitoba.DeclarationNumber, dbo.AB_ReproductiveCare.DeliveryDate, dbo.AB_ReproductiveCare.DeliveryTime, 
    dbo.AB_Abstract.DischargeDate, Lookup63.DisplayCode AS DischargeDisposition, Lookup63.UserDescription AS DischargeDispositionDesc, 
    Lookup64.DisplayCode AS DischNursingAreaUnitLocation, Lookup64.UserDescription AS DischargeNursingAreaUnitDesc, 
    Lookup65.DisplayCode AS DischargePlanning, Lookup65.UserDescription AS DischargePlanningDesc, 
    dbo.AB_Abstract.DischargeTime, 
    --PR - 05489
    LU_DischargeTimeUnknown.DisplayCode AS DischargeTimeUnknown, LU_DischargeTimeUnknown.UserDescription AS DischargeTimeUnknownDesc, 

    dbo.AB_Manitoba.DrinksPerday, dbo.AB_Manitoba.ALC_TotalDays AS DurationALCDays, Lookup66.DisplayCode AS ECTTreatment, 
    Lookup66.UserDescription AS ECTTreatmentDesc, Lookup67.DisplayCode AS Education, Lookup67.UserDescription AS EducationDesc, 
    LU_Elopements.DisplayCode AS Elopements, LU_Elopements.UserDescription AS ElopementsDesc, dbo.AB_Manitoba.EmployerName, 
    Lookup68.DisplayCode AS Employment, Lookup68.UserDescription AS EmploymentDesc, dbo.AB_Abstract.EncounterNumber, 
    Lookup69.DisplayCode AS EntryCode, Lookup69.UserDescription AS EntryCodeDesc, dbo.AB_Abstract.DateLeftER AS ERDatePatientLeft, 
    dbo.AB_Abstract.DecisionAdmitDate AS ERDecisiontoAdmitDate, dbo.AB_Abstract.DecisionAdmitTime AS ERDecisiontoAdmitTime, 
    LU_DecAdmitTimeUnknown.DisplayCode AS ERDecisionAdmitTimeUnknown, 
    LU_DecAdmitTimeUnknown.UserDescription AS ERDecisionAdmitTimeUnknownDesc, dbo.AB_Abstract.TimeLeftER AS ERTimePatientLeft, 
    LU_TimeLeftERUnknown.DisplayCode AS ERTimePatientLeftUnknown, LU_TimeLeftERUnknown.UserDescription AS ERTimePatientLeftUnknownDesc, 
    LU_Feeding.DisplayCode AS Feeding, LU_Feeding.UserDescription AS FeedingDesc, Lookup70.DisplayCode AS FinancialSupport, 
    Lookup70.UserDescription AS FinancialSupportDesc, dbo.AB_Abstract.FinishDate, dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, 
    Lookup71.DisplayCode AS FirstOptionalTherapy, Lookup71.UserDescription AS FirstOptionalTherapyDesc, 
    dbo.AB_Therapeutic.FirstOptionUnits AS FirstOptionalUnits, dbo.AB_Manitoba.FirstStageDuration, 
    FixedChartNumber,
    LU_FreeFlowOxygen.DisplayCode AS FreeFlowOxygen, LU_FreeFlowOxygen.UserDescription AS FreeFlowOxygenDesc, 
    Lookup72.DisplayCode AS Gender, Lookup72.UserDescription AS GenderDesc, dbo.AB_Manitoba.Gestation, 
    dbo.AB_ReproductiveCare.GestationalAge AS GestationalAgeinweeks, Lookup73.DisplayCode AS GlasgowComaScale, 
    Lookup73.UserDescription AS GlasgowComaScaleDesc, dbo.AB_Manitoba.Gravida, Lookup74.DisplayCode AS Greaterthan10DaysPostOp, 
    Lookup74.UserDescription AS Greaterthan10DaysPostOpDesc, Lookup75.DisplayCode AS HCNProvince, 
    Lookup75.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
	AB_Abstract.Height,
    dbo.H_HospitalProfile.DisplayCode AS Hospital, dbo.H_HospitalProfile.UserDescription AS HospitalDesc, 
    dbo.AB_Abstract.HospitalAccountRecord,
    dbo.AB_Abstract.ICDType, 
    Lookup76.DisplayCode AS InitialOR, Lookup76.UserDescription AS InitialORDesc, dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
    
	Lookup77.InstCareType AS InstFromCareType, Lookup77.HospitalType AS InstFromHospType, 
	Lookup77.DisplayCode AS InstitutionFrom, Lookup77.UserDescription AS InstitutionFromDesc, 
	LU_InstitutionFrom_Type.DisplayCode AS InstitutionFromType, LU_InstitutionFrom_Type.UserDescription AS InstitutionFromTypeDesc, 

	Lookup78.DisplayCode AS InstitutionTo, Lookup78.UserDescription AS InstitutionToDesc, 
	LU_InstitutionTo_Type.DisplayCode AS InstitutionToType, LU_InstitutionTo_Type.UserDescription AS InstitutionToTypeDesc, 
    Lookup78.InstCareType AS InstToCareType, Lookup78.HospitalType AS InstToHospType, 
	
	Lookup79.DisplayCode AS InterfaceCoder, 
    Lookup79.UserDescription AS InterfaceCoderDesc, dbo.AB_Abstract.InterfaceDate, dbo.AB_Abstract.InterfaceTime, 
    LU_IntubationNotMeconium.DisplayCode AS IntubationNotMeconium, LU_IntubationNotMeconium.UserDescription AS IntubationNotMeconiumDesc, 
    Lookup80.DisplayCode AS IsAbstractCompleted, Lookup80.UserDescription AS IsAbstractCompletedDesc, 
    Lookup81.DisplayCode AS IsAbstractCorrected, Lookup81.UserDescription AS IsAbstractCorrectedDesc, Lookup82.DisplayCode AS IsAbstractDeleted, 
    Lookup82.UserDescription AS IsAbstractDeletedDesc, Lookup83.DisplayCode AS IsAbstractSubmited, 
    Lookup83.UserDescription AS IsAbstractSubmitedDesc, Lookup84.DisplayCode AS IsAbstractValidated, 
    Lookup84.UserDescription AS IsAbstractValidatedDesc, 
	Lookup85.DisplayCode AS IsBirthdateEstimated,  Lookup85.UserDescription AS IsBirthdateEstimatedDesc, 
	LU_CustomStatus.DisplayCode AS IsCustomValidated, LU_CustomStatus.UserDescription AS IsCustomValidatedDesc, 

	dbo.AB_Abstract.LastName, LU_LeaveCertificates.DisplayCode AS LeaveCertificates, 
    LU_LeaveCertificates.UserDescription AS LeaveCertificatesDesc, Lookup86.DisplayCode AS Lessthan2DaysAfterAdmission, 
    Lookup86.UserDescription AS Lessthan2DaysAfterAdmitDesc, Lookup87.DisplayCode AS Lessthan2DaysPostOp, 
    Lookup87.UserDescription AS Lessthan2DaysPostOpDesc, dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.MaidenName, Lookup88.DisplayCode AS MaritalStatus, 
    Lookup88.UserDescription AS MaritalStatusDesc, dbo.AB_Abstract.NewbornChart AS MaternalNewbornChartNumber, 
    dbo.AB_Abstract.NewbornDischargeDate AS MaternalNewbornDischargeDate, LU_MB_Autopsy.DisplayCode AS MB_Autopsy, 
    LU_MB_Autopsy.UserDescription AS MB_AutopsyDesc, 
	dbo.AB_Manitoba.MB_Weight, 
	LU_MBEducation.DisplayCode AS MBEducation, 
    LU_MBEducation.UserDescription AS MBEducationDesc, LU_Meconium.DisplayCode AS Meconium, 
    LU_Meconium.UserDescription AS MeconiumDesc, LU_MedicationResuscitation.DisplayCode AS MedicationResuscitation, 
    LU_MedicationResuscitation.UserDescription AS MedicationResuscitationDesc, 
	
	LU_MentalLegalStatusUponArrivalED.DisplayCode as MentalHealth_LegalStatusUponArrivaltoED, 
	LU_MentalLegalStatusUponArrivalED.UserDescription as MentalHealth_LegalStatusUponArrivaltoEDDesc,
	LU_MentalLegalStatusAdmission.DisplayCode as MentalHealth_LegalStatusAtAdmission, 
	LU_MentalLegalStatusAdmission.UserDescription as MentalHealth_LegalStatusAtAdmissionDesc,
	LU_MentalTypeRestraint_1.DisplayCode as MentalHealth_TypeOfRestraint_01,
	LU_MentalTypeRestraint_1.UserDescription as MentalHealth_TypeOfRestraint_01Desc,
	LU_MentalTypeRestraint_2.DisplayCode as MentalHealth_TypeOfRestraint_02,
	LU_MentalTypeRestraint_2.UserDescription as MentalHealth_TypeOfRestraint_02Desc,
	LU_MentalTypeRestraint_3.DisplayCode as MentalHealth_TypeOfRestraint_03,
	LU_MentalTypeRestraint_3.UserDescription as MentalHealth_TypeOfRestraint_03Desc,
	LU_MentalTypeRestraint_4.DisplayCode as MentalHealth_TypeOfRestraint_04,
	LU_MentalTypeRestraint_4.UserDescription as MentalHealth_TypeOfRestraint_04Desc,
	LU_MentalFrequencyRestraintUse_1.DisplayCode as MentalHealth_FrequencyOfRestraint_01,
	LU_MentalFrequencyRestraintUse_1.UserDescription as MentalHealth_FrequencyOfRestraint_01Desc,
	LU_MentalFrequencyRestraintUse_2.DisplayCode as MentalHealth_FrequencyOfRestraint_02,
	LU_MentalFrequencyRestraintUse_2.UserDescription as MentalHealth_FrequencyOfRestraint_02Desc,
	LU_MentalFrequencyRestraintUse_3.DisplayCode as MentalHealth_FrequencyOfRestraint_03,
	LU_MentalFrequencyRestraintUse_3.UserDescription as MentalHealth_FrequencyOfRestraint_03Desc,
	LU_MentalFrequencyRestraintUse_4.DisplayCode as MentalHealth_FrequencyOfRestraint_04,
	LU_MentalFrequencyRestraintUse_4.UserDescription as MentalHealth_FrequencyOfRestraint_04Desc,

	Lookup89.DisplayCode AS MethodofAdmission, Lookup89.UserDescription AS MethodofAdmissionDesc, LU_MHInstFrom.DisplayCode AS MHFacilityTransferFrom, 
    LU_MHInstFrom.UserDescription AS MHFacilityTransferFromDesc, LU_MHInstTo.DisplayCode AS MHFacilityTransferTo, 
    LU_MHInstTo.UserDescription AS MHFacilityTransferToDesc, dbo.AB_Abstract.MiddleName, dbo.AB_Manitoba.MotherPHIN, 
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, 
    LU_NarconMaloxone.DisplayCode AS NarconMaloxone, LU_NarconMaloxone.UserDescription AS NarconMaloxoneDesc, 
    dbo.AB_MentalHealth.MentalNumberECT AS NumberofECT, Lookup90.DisplayCode AS OccupationalTherapy, 
    Lookup90.UserDescription AS OccupationalTherapyDesc, dbo.AB_Therapeutic.OccupationalUnits, Lookup92.DisplayCode AS OtherBlood, 
    Lookup92.UserDescription AS OtherBloodDesc, Lookup93.DisplayCode AS OtherBloodCrossMatched, 
    Lookup93.UserDescription AS OtherBloodCrossMatchedDesc, Lookup94.DisplayCode AS OtherBloodTyped, 
    Lookup94.UserDescription AS OtherBloodTypedDesc, dbo.AB_Blood.OtherBloodUnits, Lookup91.DisplayCode AS OtherMedicalDeath, 
    Lookup91.UserDescription AS OtherMedicalDeathDesc, 
    dbo.AB_Manitoba.HCNExpiredDate  as OutProvinceHealthInsuranceExpiryDate,
    dbo.AB_Manitoba.Parity, dbo.AB_CancerStaging.PathMetastasis AS PathologicalMetastasis, 
    dbo.AB_CancerStaging.PathNode AS PathologicalNode, dbo.AB_CancerStaging.PathTumor AS PathologicalTumor, 
    Lookup95.DisplayCode AS Physiotherapy, Lookup95.UserDescription AS PhysiotherapyDesc, dbo.AB_Therapeutic.PhysioUnits, 
    Lookup96.DisplayCode AS Plasma, Lookup96.UserDescription AS PlasmaDesc, Lookup97.DisplayCode AS PlasmaCrossMatched, 
    Lookup97.UserDescription AS PlasmaCrossMatchedDesc, Lookup98.DisplayCode AS PlasmaTyped, Lookup98.UserDescription AS PlasmaTypedDesc, 
    dbo.AB_Blood.PlasmaUnits, Lookup99.DisplayCode AS Platelets, Lookup99.UserDescription AS PlateletsDesc, 
    Lookup100.DisplayCode AS PlateletsCrossMatched, Lookup100.UserDescription AS PlateletsCrossMatchedDesc, 
    Lookup101.DisplayCode AS PlateletsTyped, Lookup101.UserDescription AS PlateletsTypedDesc, dbo.AB_Blood.PlateletsUnits, 
    dbo.AB_Abstract.PostalCode, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), isnull(dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.AdmitDate)) AS PostalCodeDesc, -- ED - 01682

    --PR - 03622
    LU_PositionDelviery.DisplayCode as PositionatDelivery, LU_PositionDelviery.UserDescription as PositionatDeliveryDesc, 

    LU_PostConceptionalFolicAcid.DisplayCode AS PostConceptionalFolicAcid, 
    LU_PostConceptionalFolicAcid.UserDescription AS PostConceptionalFolicAcidDesc, dbo.AB_Abstract.PostOpDays, 
    Lookup103.DisplayCode AS PreAdmitWorkup, Lookup103.UserDescription AS PreAdmitWorkupDesc, 
    LU_PreConceptionalFolicAcid.DisplayCode AS PreConceptionalFolicAcid, 
    LU_PreConceptionalFolicAcid.UserDescription AS PreConceptionalFolicAcidDesc, Lookup104.DisplayCode AS Pregnancy, 
    Lookup104.UserDescription AS PregnancyDesc, dbo.AB_Manitoba.PrenatalVisitDate, 
    LU_PrenatalVisitDateUnknown.DisplayCode AS PrenatalVisitDateUnknown, 
    LU_PrenatalVisitDateUnknown.UserDescription AS PrenatalVisitDateUnknownDesc, 
    --ED - 01702
    -- dbo.AB_Manitoba.NumberPrenatalVisits AS PrenatalVisitsNumber, 
    (case when isnull(DischargeDate, AdmitDate) < ''2008/04/01'' then dbo.AB_Manitoba.NumberPrenatalVisits else dbo.AB_Manitoba.NumberPrenatal end) AS PrenatalVisitsNumber, 

    dbo.AB_Abstract.PreOpDays, LU_Presentation.DisplayCode AS Presentation, LU_Presentation.UserDescription AS PresentationDesc, 
    --PR - 03622
    LU_PresentDelivery.DisplayCode as PresentationatDelivery, LU_PresentDelivery.UserDescription as PresentationatDeliveryDesc, 

    dbo.AB_Manitoba.PreviousName, Lookup105.DisplayCode AS PreviousPsychiartricAdmissions, 
    Lookup105.UserDescription AS PreviousPsychiartricAdmDesc, dbo.AB_Manitoba.PrimaryAddress, dbo.AB_Manitoba.PrimaryAddress2, 
    dbo.AB_Manitoba.PrimaryPhone, Lookup106.DisplayCode AS ReAdmitCode, Lookup106.UserDescription AS ReAdmitCodeDesc, 
    --PR - 04577
    LU_ReciprocalBillingStatus.DisplayCode AS ReciprocalBillingStatus, LU_ReciprocalBillingStatus.UserDescription AS ReciprocalBillingStatusDesc,

    Lookup107.DisplayCode AS RedBloodCell, Lookup107.UserDescription AS RedBloodCellDesc, 
    Lookup108.DisplayCode AS RedBloodCellCrossMatched, Lookup108.UserDescription AS RedBloodCellCrossMatchedDesc, 
    Lookup109.DisplayCode AS RedBloodCellTyped, Lookup109.UserDescription AS RedBloodCellTypedDesc, 
    dbo.AB_Blood.RedCellUnits AS RedBloodCellUnits, Lookup110.DisplayCode AS ReferredTo, Lookup110.UserDescription AS ReferredToDesc, 
    LU_RefProvider.DisplayCode AS ReferringProvider, LU_RefProvider.UserDescription AS ReferringProviderDesc, dbo.AB_Abstract.RegisterNumber, 
    dbo.AB_Manitoba.RegistrantFirstName AS RegistrantGivenName, dbo.AB_Manitoba.RegistrantLastName AS RegistrantSurname, 
    Lookup111.DisplayCode AS ReportingProvInstNumber, Lookup111.UserDescription AS ReportingProvInstNumberDesc, 
    dbo.AB_ReproductiveCare.ReprodComments AS ReproductiveCareComments, Lookup112.DisplayCode AS ResidenceCode, 
    Lookup112.UserDescription AS ResidenceCodeDesc, LUResidenceProvince.DisplayCode AS ResidenceProvince, 
    LUResidenceProvince.UserDescription AS ResidenceProvinceDesc, LUResidenceRegion.DisplayCode AS ResidenceRegion, 
    LUResidenceRegion.UserDescription AS ResidenceRegionDesc, Lookup113.DisplayCode AS RespiratoryTherapy, 
    Lookup113.UserDescription AS RespiratoryTherapyDesc, dbo.AB_Therapeutic.RespiratoryUnits, Lookup114.DisplayCode AS ResponsiblityForPayment,
    Lookup114.UserDescription AS ResponsiblityForPaymentDesc, LU_RoutineCare.DisplayCode AS RoutineCare, 
    LU_RoutineCare.UserDescription AS RoutineCareDesc, dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup115.DisplayCode AS SecondOptionalTherapy, Lookup115.UserDescription AS SecondOptionalTherapyDesc, 
    dbo.AB_Therapeutic.SecondOptionUnits AS SecondOptionalUnits, dbo.AB_Manitoba.SecondStageDuration, 
    Lookup116.DisplayCode AS SecretVIPPatient, Lookup116.UserDescription AS SecretVIPPatientDesc, Lookup117.DisplayCode AS SiteNumber, 
    Lookup117.UserDescription AS SiteNumberDesc, 
    LU_SmokingInPregnancy.DisplayCode AS SmokingInPregnancy, LU_SmokingInPregnancy.UserDescription AS SmokingInPregnancyDesc, 
    dbo.AB_Manitoba.SmokingPerDay, dbo.AB_Manitoba.SmokingQuitDate, 
    LU_SmokingQuitDateUnknown.DisplayCode AS SmokingQuitDateUnknown, 
    LU_SmokingQuitDateUnknown.UserDescription AS SmokingQuitDateUnknownDesc, Lookup118.DisplayCode AS SocialServices, 
    Lookup118.UserDescription AS SocialServicesDesc, Lookup119.DisplayCode AS SourceofReferral, 
    Lookup119.UserDescription AS SourceofReferralDesc, Lookup120.DisplayCode AS SpeechTherapy, 
    Lookup120.UserDescription AS SpeechTherapyDesc, dbo.AB_Therapeutic.SpeechUnits, LU_CodeFile_1.DisplayCode AS StakeholderType, 
    LU_CodeFile_1.UserDescription AS StakeholderTypeDesc, dbo.AB_Manitoba.FirstStageDate AS StartFirstStageDate, 
    LU_FirstStageDateUnknown.DisplayCode AS StartFirstStageDateUnknown, 
    LU_FirstStageDateUnknown.UserDescription AS StartFirstStageDateUnknownDes, dbo.AB_Manitoba.FirstStageTime AS StartFirstStageTime, 
    dbo.AB_Manitoba.SecondStageDate AS StartSecondStageDate, LU_SecondStageDateUnknown.DisplayCode AS StartSecondStageDateUnknown, 
    LU_SecondStageDateUnknown.UserDescription AS StartSecondStageDateUnknown_D, dbo.AB_Manitoba.SecondStageTime AS StartSecondStageTime, 
    Lookup121.DisplayCode AS Sterilization, Lookup121.UserDescription AS SterilizationDesc, dbo.AB_Abstract.RecordType AS SubmissionType, 
    Lookup122.DisplayCode AS SubsequentOR, Lookup122.UserDescription AS SubsequentORDesc, Lookup123.DisplayCode AS Suicide, 
    Lookup123.UserDescription AS SuicideDesc, dbo.AB_CancerStaging.SummaryStage, Lookup124.DisplayCode AS SurgicalCase, 
    Lookup124.UserDescription AS SurgicalCaseDesc, Lookup125.DisplayCode AS TransfusionGiven, 
    Lookup125.UserDescription AS TransfusionGivenDesc, Lookup126.DisplayCode AS Trauma, Lookup126.UserDescription AS TraumaDesc, 
    Lookup127.DisplayCode AS TSICoder, Lookup127.UserDescription AS TSICoderDesc, dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, 
    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, Lookup128.DisplayCode AS UnplannedReadmission, 
    Lookup128.UserDescription AS UnplannedReadmissionDesc, 
	dbo.AB_Abstract.UniversalEpisodeIdentifier,
    dbo.AB_Abstract.WaitTimeER AS WaitTimeInEmerg, 
    dbo.AB_Abstract.WaitTimeERHour AS WaitTimeInEmergHour, 
    dbo.AB_Abstract.Weight AS Weightingrams, 
	(case when isnumeric(replace(AB_Abstract.WeightKilo, '','', ''.'')) = 1 then cast(replace(AB_Abstract.WeightKilo, '','', ''.'') as dec(7, 3)) else null end) as WeightKG,
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID,
    dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_Provider LU_RefProvider with (nolock) on dbo.AB_Abstract.RefPhysician = LU_RefProvider.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_DecAdmitTimeUnknown with (nolock) on dbo.AB_Abstract.DecisionAdmitTimeUnknown = LU_DecAdmitTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CodeFile_1 with (nolock) on dbo.AB_Abstract.StakeHolder = LU_CodeFile_1.Code LEFT OUTER JOIN
    dbo.AB_Manitoba with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Manitoba.AbstractID left join
    dbo.LU_CodeFile LU_Meconium with (nolock) on LU_Meconium.Code = dbo.AB_Manitoba.Meconium LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Feeding with (nolock) on dbo.AB_Manitoba.Feeding = LU_Feeding.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_ChestCompressions with (nolock) on dbo.AB_Manitoba.ChestCompressions = LU_ChestCompressions.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_NarconMaloxone with (nolock) on dbo.AB_Manitoba.NarconMaloxone = LU_NarconMaloxone.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_MedicationResuscitation with (nolock) on 
    dbo.AB_Manitoba.MedicationResuscitation = LU_MedicationResuscitation.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_IntubationNotMeconium with (nolock) on dbo.AB_Manitoba.IntubationNotMeconium = LU_IntubationNotMeconium.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_BagVentilation with (nolock) on dbo.AB_Manitoba.BagVentilation = LU_BagVentilation.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_FreeFlowOxygen with (nolock) on dbo.AB_Manitoba.FreeFlowOxygen = LU_FreeFlowOxygen.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_RoutineCare with (nolock) on dbo.AB_Manitoba.RoutineCare = LU_RoutineCare.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Presentation with (nolock) on dbo.AB_Manitoba.Presentation = LU_Presentation.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_SecondStageDateUnknown with (nolock) on 
    dbo.AB_Manitoba.SecondStageDateUnknown = LU_SecondStageDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_FirstStageDateUnknown with (nolock) on dbo.AB_Manitoba.FirstStageDateUnknown = LU_FirstStageDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PostConceptionalFolicAcid with (nolock) on 
    dbo.AB_Manitoba.PostConceptionalFolicAcid = LU_PostConceptionalFolicAcid.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PreConceptionalFolicAcid with (nolock) on dbo.AB_Manitoba.PreConceptionalFolicAcid = LU_PreConceptionalFolicAcid.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Days_WeekAlcoholConsumed with (nolock) on 
    dbo.AB_Manitoba.Days_WeekAlcoholConsumed = LU_Days_WeekAlcoholConsumed.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AlcoholDuringPregnancy with (nolock) on dbo.AB_Manitoba.AlcoholDuringPregnancy = LU_AlcoholDuringPregnancy.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_SmokingQuitDateUnknown with (nolock) on 
    dbo.AB_Manitoba.SmokingQuitDateUnknown = LU_SmokingQuitDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MBEducation with (nolock) on dbo.AB_Manitoba.ObsEducation = LU_MBEducation.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_PrenatalVisitDateUnknown with (nolock) on 
    dbo.AB_Manitoba.PrenatalVisitDateUnknown = LU_PrenatalVisitDateUnknown.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_LeaveCertificates with (nolock) on dbo.AB_Manitoba.LeaveCertificates = LU_LeaveCertificates.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_Elopements with (nolock) on dbo.AB_Manitoba.Elopements = LU_Elopements.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MB_Autopsy with (nolock) on dbo.AB_Manitoba.MB_Autopsy = LU_MB_Autopsy.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MHInstTo with (nolock) on dbo.AB_Manitoba.MHInstTo = LU_MHInstTo.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MHInstFrom with (nolock) on dbo.AB_Manitoba.MHInstFrom = LU_MHInstFrom.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AbstractType with (nolock) on dbo.AB_Manitoba.AbstractType = LU_AbstractType.Code LEFT OUTER JOIN
    dbo.LU_CareType with (nolock) on dbo.AB_Abstract.CareType = dbo.LU_CareType.Code LEFT OUTER JOIN
    dbo.LU_AbstractOverflow Lookup2 with (nolock) on dbo.AB_Abstract.AbstractOverflow = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_NurseArea Lookup5 with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup6 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup7 with (nolock) on dbo.AB_Abstract.DischargeAgeCode = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_Provider Lookup28 with (nolock) on dbo.AB_Abstract.AttendingPhysician = Lookup28.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup50 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup54 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup54.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup55 with (nolock) on dbo.AB_Abstract.Complication = Lookup55.Code LEFT OUTER JOIN
    dbo.U_Users Lookup60 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_I Lookup63 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup63.Code LEFT OUTER JOIN
    dbo.LU_NurseArea Lookup64 with (nolock) on dbo.AB_Abstract.DischargeNurseArea = Lookup64.Code LEFT OUTER JOIN
    dbo.LU_TherDischPlan Lookup65 with (nolock) on dbo.AB_Abstract.DischargePlanning = Lookup65.Code LEFT OUTER JOIN
    dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_Glasgow Lookup73 with (nolock) on dbo.AB_Abstract.GlasgowComaScale = Lookup73.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup77 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup77.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionFrom_Type with (nolock) on dbo.AB_Abstract.InstitutionFromType = LU_InstitutionFrom_Type.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup78 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup78.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionTo_Type with (nolock) on dbo.AB_Abstract.InstitutionToType = LU_InstitutionTo_Type.Code LEFT OUTER JOIN

    dbo.U_Users Lookup79 with (nolock) on dbo.AB_Abstract.InterfaceCoder = Lookup79.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup80 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup80.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup81 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup81.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus Lookup82 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup82.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup83 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup84 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_CustomStatus with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_CustomStatus.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup85 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_MaritalStatus Lookup88 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup88.Code LEFT OUTER JOIN
    dbo.LU_TherPreAdmitWorkUp Lookup103 with (nolock) on dbo.AB_Abstract.PreAdmitWorkUp = Lookup103.Code LEFT OUTER JOIN
    dbo.LU_ReAdmitCode Lookup106 with (nolock) on dbo.AB_Abstract.ReAdmitCode = Lookup106.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup111 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup111.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_Region LUResidenceRegion with (nolock) on Lookup112.RegionCode = LUResidenceRegion.Code LEFT OUTER JOIN
    dbo.LU_Province LUResidenceProvince with (nolock) on Lookup112.ProvinceCode = LUResidenceProvince.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup116 with (nolock) on dbo.AB_Abstract.Secret = Lookup116.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup117 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup117.Code LEFT OUTER JOIN
    dbo.LU_TherSocialService Lookup118 with (nolock) on dbo.AB_Abstract.SocialService = Lookup118.Code LEFT OUTER JOIN
    dbo.LU_SurgicalCode Lookup124 with (nolock) on dbo.AB_Abstract.SurgicalCase = Lookup124.Code LEFT OUTER JOIN
    dbo.U_Users Lookup127 with (nolock) on dbo.AB_Abstract.TSICoder = Lookup127.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup128 with (nolock) on dbo.AB_Abstract.UnplanReAdmit = Lookup128.Code LEFT OUTER JOIN
    dbo.AB_Ancillary with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Ancillary.AbstractID LEFT OUTER JOIN
    dbo.LU_Ancillary1 Lookup11 with (nolock) on dbo.AB_Ancillary.AncillaryField1 = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Ancillary10 Lookup12 with (nolock) on dbo.AB_Ancillary.AncillaryField10 = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_Ancillary11 Lookup13 with (nolock) on dbo.AB_Ancillary.AncillaryField11 = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_Ancillary12 Lookup14 with (nolock) on dbo.AB_Ancillary.AncillaryField12 = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_Ancillary13 Lookup15 with (nolock) on dbo.AB_Ancillary.AncillaryField13 = Lookup15.Code LEFT OUTER JOIN
    dbo.LU_Ancillary14 Lookup16 with (nolock) on dbo.AB_Ancillary.AncillaryField14 = Lookup16.Code LEFT OUTER JOIN
    dbo.LU_Ancillary15 Lookup17 with (nolock) on dbo.AB_Ancillary.AncillaryField15 = Lookup17.Code LEFT OUTER JOIN
    dbo.LU_Ancillary16 Lookup18 with (nolock) on dbo.AB_Ancillary.AncillaryField16 = Lookup18.Code LEFT OUTER JOIN
    dbo.LU_Ancillary17 Lookup19 with (nolock) on dbo.AB_Ancillary.AncillaryField17 = Lookup19.Code LEFT OUTER JOIN
    dbo.LU_Ancillary2 Lookup20 with (nolock) on dbo.AB_Ancillary.AncillaryField2 = Lookup20.Code LEFT OUTER JOIN
    dbo.LU_Ancillary3 Lookup21 with (nolock) on dbo.AB_Ancillary.AncillaryField3 = Lookup21.Code LEFT OUTER JOIN
    dbo.LU_Ancillary4 Lookup22 with (nolock) on dbo.AB_Ancillary.AncillaryField4 = Lookup22.Code LEFT OUTER JOIN
    dbo.LU_Ancillary5 Lookup23 with (nolock) on dbo.AB_Ancillary.AncillaryField5 = Lookup23.Code LEFT OUTER JOIN
    dbo.LU_Ancillary6 Lookup24 with (nolock) on dbo.AB_Ancillary.AncillaryField6 = Lookup24.Code LEFT OUTER JOIN
    dbo.LU_Ancillary7 Lookup25 with (nolock) on dbo.AB_Ancillary.AncillaryField7 = Lookup25.Code LEFT OUTER JOIN
    dbo.LU_Ancillary8 Lookup26 with (nolock) on dbo.AB_Ancillary.AncillaryField8 = Lookup26.Code LEFT OUTER JOIN
    dbo.LU_Ancillary9 Lookup27 with (nolock) on dbo.AB_Ancillary.AncillaryField9 = Lookup27.Code LEFT OUTER JOIN
    dbo.AB_BasicOption with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_BasicOption.AbstractID LEFT OUTER JOIN
    dbo.LU_BasicOption1 Lookup31 with (nolock) on dbo.AB_BasicOption.BasicOption1 = Lookup31.Code LEFT OUTER JOIN
    dbo.LU_BasicOption10 Lookup32 with (nolock) on dbo.AB_BasicOption.BasicOption10 = Lookup32.Code LEFT OUTER JOIN
    dbo.LU_BasicOption11 Lookup33 with (nolock) on dbo.AB_BasicOption.BasicOption11 = Lookup33.Code LEFT OUTER JOIN
    dbo.LU_BasicOption12 Lookup34 with (nolock) on dbo.AB_BasicOption.BasicOption12 = Lookup34.Code LEFT OUTER JOIN
    dbo.LU_BasicOption13 Lookup35 with (nolock) on dbo.AB_BasicOption.BasicOption13 = Lookup35.Code LEFT OUTER JOIN
    dbo.LU_BasicOption14 Lookup36 with (nolock) on dbo.AB_BasicOption.BasicOption14 = Lookup36.Code LEFT OUTER JOIN
    dbo.LU_BasicOption15 Lookup37 with (nolock) on dbo.AB_BasicOption.BasicOption15 = Lookup37.Code LEFT OUTER JOIN
    dbo.LU_BasicOption16 Lookup38 with (nolock) on dbo.AB_BasicOption.BasicOption16 = Lookup38.Code LEFT OUTER JOIN
    dbo.LU_BasicOption17 Lookup39 with (nolock) on dbo.AB_BasicOption.BasicOption17 = Lookup39.Code LEFT OUTER JOIN
    dbo.LU_BasicOption18 Lookup40 with (nolock) on dbo.AB_BasicOption.BasicOption18 = Lookup40.Code LEFT OUTER JOIN
    dbo.LU_BasicOption19 Lookup41 with (nolock) on dbo.AB_BasicOption.BasicOption19 = Lookup41.Code LEFT OUTER JOIN
    dbo.LU_BasicOption2 Lookup42 with (nolock) on dbo.AB_BasicOption.BasicOption2 = Lookup42.Code LEFT OUTER JOIN
    dbo.LU_BasicOption3 Lookup43 with (nolock) on dbo.AB_BasicOption.BasicOption3 = Lookup43.Code LEFT OUTER JOIN
    dbo.LU_BasicOption4 Lookup44 with (nolock) on dbo.AB_BasicOption.BasicOption4 = Lookup44.Code LEFT OUTER JOIN
    dbo.LU_BasicOption5 Lookup45 with (nolock) on dbo.AB_BasicOption.BasicOption5 = Lookup45.Code LEFT OUTER JOIN
    dbo.LU_BasicOption6 Lookup46 with (nolock) on dbo.AB_BasicOption.BasicOption6 = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_BasicOption7 Lookup47 with (nolock) on dbo.AB_BasicOption.BasicOption7 = Lookup47.Code LEFT OUTER JOIN
    dbo.LU_BasicOption8 Lookup48 with (nolock) on dbo.AB_BasicOption.BasicOption8 = Lookup48.Code LEFT OUTER JOIN
    dbo.LU_BasicOption9 Lookup49 with (nolock) on dbo.AB_BasicOption.BasicOption9 = Lookup49.Code LEFT OUTER JOIN
    dbo.AB_Blood with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Blood.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup8 with (nolock) on dbo.AB_Blood.Albumin = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup9 with (nolock) on dbo.AB_Blood.AlbuminXMatch = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup10 with (nolock) on dbo.AB_Blood.AlbuminTyped = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup29 with (nolock) on dbo.AB_Blood.AutoTransfusion = Lookup29.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup92 with (nolock) on dbo.AB_Blood.OtherBlood = Lookup92.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup93 with (nolock) on dbo.AB_Blood.OtherBloodXMatch = Lookup93.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup94 with (nolock) on dbo.AB_Blood.OtherBloodTyped = Lookup94.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup96 with (nolock) on dbo.AB_Blood.Plasma = Lookup96.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup97 with (nolock) on dbo.AB_Blood.PlasmaXMatch = Lookup97.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup98 with (nolock) on dbo.AB_Blood.PlasmaTyped = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup99 with (nolock) on dbo.AB_Blood.Platelets = Lookup99.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup100 with (nolock) on dbo.AB_Blood.PlateletsXMatch = Lookup100.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup101 with (nolock) on dbo.AB_Blood.PlateletsTyped = Lookup101.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup107 with (nolock) on dbo.AB_Blood.RedBloodCell = Lookup107.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup108 with (nolock) on dbo.AB_Blood.RedCellXMatch = Lookup108.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup109 with (nolock) on dbo.AB_Blood.RedCellTyped = Lookup109.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup125 with (nolock) on dbo.AB_Blood.TransfusionIndicator = Lookup125.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_AntithrombinIII with (nolock) on dbo.AB_Blood.AntithrombinIII = LU_AntithrombinIII.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_C1Inhibitor with (nolock) on dbo.AB_Blood.C1Inhibitor = LU_C1Inhibitor.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryoprecipitatePlasma with (nolock) on dbo.AB_Blood.CryoprecipitatePlasma = LU_CryoprecipitatePlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryosupernatantPlasma with (nolock) on dbo.AB_Blood.CryosupernatantPlasma = LU_CryosupernatantPlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_FEIBA with (nolock) on dbo.AB_Blood.FEIBA = LU_FEIBA.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_Fibrinogen with (nolock) on dbo.AB_Blood.Fibrinogen = LU_Fibrinogen.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_IVIG_SCIG with (nolock) on dbo.AB_Blood.IVIG_SCIG = LU_IVIG_SCIG.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_PCC with (nolock) on dbo.AB_Blood.PCC = LU_PCC.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_ProteinC_OtherFactors with (nolock) on dbo.AB_Blood.ProteinC_OtherFactors = LU_ProteinC_OtherFactors.Code LEFT OUTER JOIN


    dbo.AB_DeathInformation with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_DeathInformation.AbstractID LEFT OUTER JOIN
    dbo.LU_AutopsyDeath Lookup30 with (nolock) on dbo.AB_DeathInformation.AutopsyPerformed = Lookup30.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup51 with (nolock) on dbo.AB_DeathInformation.DeathTwoTenPO = Lookup51.Code LEFT OUTER JOIN
    dbo.LU_CoronerCase Lookup59 with (nolock) on dbo.AB_DeathInformation.CoronerCase = Lookup59.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup61 with (nolock) on dbo.AB_DeathInformation.DeathInOR = Lookup61.Code left join
    dbo.LU_SCU_Death Lookup62 with (nolock) on Lookup62.Code = dbo.AB_DeathInformation.DeathInSCU LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup74 with (nolock) on dbo.AB_DeathInformation.DeathGreaterTenPO = Lookup74.Code left join
    dbo.LU_YesBlank Lookup86 with (nolock) on Lookup86.Code = dbo.AB_DeathInformation.DeathAfterAdmit LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup87 with (nolock) on dbo.AB_DeathInformation.DeathLessTwoPO = Lookup87.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup91 with (nolock) on dbo.AB_DeathInformation.OtherDeath = Lookup91.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup104 with (nolock) on dbo.AB_DeathInformation.PregnancyDeath = Lookup104.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup126 with (nolock) on dbo.AB_DeathInformation.TraumaDeath = Lookup126.Code left join
    
	dbo.AB_MentalHealth with (nolock) on dbo.AB_MentalHealth.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup1 with (nolock) on dbo.AB_MentalHealth.MentalAWOL = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_MentalLegalStatus Lookup53 with (nolock) on dbo.AB_MentalHealth.MentalLegalStatus = Lookup53.Code left join
    dbo.LU_YesNoNumeric Lookup66 with (nolock) on Lookup66.Code = dbo.AB_MentalHealth.MentalECTTreatment LEFT OUTER JOIN
    dbo.LU_MentalEducation Lookup67 with (nolock) on dbo.AB_MentalHealth.MentalEducation = Lookup67.Code LEFT OUTER JOIN
    dbo.LU_MentalEmployment Lookup68 with (nolock) on dbo.AB_MentalHealth.MentalEmployment = Lookup68.Code LEFT OUTER JOIN
    dbo.LU_MentalFinancial Lookup70 with (nolock) on dbo.AB_MentalHealth.MentalFinancial = Lookup70.Code LEFT OUTER JOIN
    dbo.LU_MentalAdmitMethod Lookup89 with (nolock) on dbo.AB_MentalHealth.MentalAdmitMethod = Lookup89.Code LEFT OUTER JOIN
    dbo.LU_MentalPrevPsych Lookup105 with (nolock) on dbo.AB_MentalHealth.MentalPrevPsych = Lookup105.Code left join
    dbo.LU_MentalReferral Lookup110 with (nolock) on Lookup110.Code = dbo.AB_MentalHealth.MentalReferralTo LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup119 with (nolock) on dbo.AB_MentalHealth.MentalReferralSource = Lookup119.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup123 with (nolock) on dbo.AB_MentalHealth.MentalSuicide = Lookup123.Code LEFT OUTER JOIN

	dbo.LU_MentalLegalStatusUponArrivalED with (nolock) on dbo.AB_MentalHealth.LegalStatusUponArrivaltoED = LU_MentalLegalStatusUponArrivalED.Code LEFT OUTER JOIN
	dbo.LU_MentalLegalStatusAdmission with (nolock) on dbo.AB_MentalHealth.LegalStatusAtAdmission = LU_MentalLegalStatusAdmission.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_1 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint01 = LU_MentalTypeRestraint_1.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_1 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint01 = LU_MentalFrequencyRestraintUse_1.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_2 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint02 = LU_MentalTypeRestraint_2.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_2 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint02 = LU_MentalFrequencyRestraintUse_2.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_3 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint03 = LU_MentalTypeRestraint_3.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_3 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint03 = LU_MentalFrequencyRestraintUse_3.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_4 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint04 = LU_MentalTypeRestraint_4.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_4 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint04 = LU_MentalFrequencyRestraintUse_4.Code LEFT OUTER JOIN


    dbo.AB_Therapeutic with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Therapeutic.AbstractID LEFT OUTER JOIN
    dbo.LU_TherOption1 Lookup71 with (nolock) on dbo.AB_Therapeutic.FirstOptionTherapy = Lookup71.Code LEFT OUTER JOIN
    dbo.LU_TherOccupation Lookup90 with (nolock) on dbo.AB_Therapeutic.OccupationalTherapy = Lookup90.Code left join
    dbo.LU_TherPhysio Lookup95 with (nolock) on Lookup95.Code = dbo.AB_Therapeutic.PhysioTherapy LEFT OUTER JOIN
    dbo.LU_TherRespiratory Lookup113 with (nolock) on dbo.AB_Therapeutic.RespiratoryTherapy = Lookup113.Code LEFT OUTER JOIN
    dbo.LU_TherOption2 Lookup115 with (nolock) on dbo.AB_Therapeutic.SecondOptionTherapy = Lookup115.Code LEFT OUTER JOIN
    dbo.LU_TherSpeech Lookup120 with (nolock) on dbo.AB_Therapeutic.SpeechTherapy = Lookup120.Code LEFT OUTER JOIN
    dbo.AB_ReproductiveCare with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_ReproductiveCare.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup52 with (nolock) on dbo.AB_ReproductiveCare.BreastFeeding = Lookup52.Code left join
    dbo.LU_ReprodComplication Lookup56 with (nolock) on Lookup56.Code = dbo.AB_ReproductiveCare.Complication1 left join
    dbo.LU_ReprodComplication Lookup57 with (nolock) on Lookup57.Code = dbo.AB_ReproductiveCare.Complication2 LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup58 with (nolock) on dbo.AB_ReproductiveCare.Complication3 = Lookup58.Code LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup76 with (nolock) on dbo.AB_ReproductiveCare.InitialOR = Lookup76.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup121 with (nolock) on dbo.AB_ReproductiveCare.Sterilization = Lookup121.Code LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup122 with (nolock) on dbo.AB_ReproductiveCare.SubsequentOR = Lookup122.Code LEFT OUTER JOIN
    dbo.AB_CancerStaging with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_CancerStaging.AbstractID LEFT OUTER JOIN
    dbo.H_HospitalProfile with (nolock) on dbo.AB_Abstract.HospitalID = dbo.H_HospitalProfile.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TimeLeftERUnknown with (nolock) on dbo.AB_Abstract.TimeLeftERUnknown = LU_TimeLeftERUnknown.Code 
    --PR - 03622
    LEFT OUTER JOIN dbo.LU_CodeFile LU_PresentDelivery with (nolock) on dbo.AB_Manitoba.PresentDelivery = LU_PresentDelivery.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_PositionDelviery with (nolock) on dbo.AB_Manitoba.PositionDelviery = LU_PositionDelviery.Code 
--ED - 01750
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AnestheticLabor with (nolock) on dbo.AB_Manitoba.AnestheticLabor = LU_AnestheticLabor.Code 
--PR - 04577
    LEFT OUTER JOIN dbo.LU_ReciprocalBillingStatus with (nolock) on dbo.AB_Abstract.IsReciprocalBilling = LU_ReciprocalBillingStatus.Code 
--PR - 05489
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AdmitTimeUnknown with (nolock) on dbo.AB_Abstract.AdmitTimeUnknown = LU_AdmitTimeUnknown.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_DischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LU_DischargeTimeUnknown.Code 
    
    LEFT OUTER JOIN dbo.LU_CodeFile LU_SmokingInPregnancy with (nolock) on dbo.AB_Manitoba.SmokingInPregnancy = LU_SmokingInPregnancy.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AlcoholQuitDateUnknown with (nolock) on dbo.AB_Manitoba.AlcoholQuitDateUnknown = LU_AlcoholQuitDateUnknown.Code 
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType IN (101, 102)) 
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
----EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingBasics1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[I10_AbstractingBasics1_VR]
AS
SELECT     
	dbo.AB_Abstract.ALCLOS, dbo.AB_Abstract.AbstractNumber, Lookup2.DisplayCode AS AbstractOverflow, 
	Lookup2.UserDescription AS AbstractOverflowDesc, dbo.AB_Abstract.AcuteLOS, dbo.AB_Abstract.AdmitDate AS AdmissionDate, 
	dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
	--PR - 05489
	LU_AdmitTimeUnknown.DisplayCode as AdmissionTimeUnknown, LU_AdmitTimeUnknown.UserDescription as AdmissionTimeUnknownDesc,
                      
	Lookup3.DisplayCode AS AdmitbyAmbulance, Lookup3.UserDescription AS AdmitbyAmbulanceDesc, 
	Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, Lookup5.DisplayCode AS AdmitNursingAreaUnitLocation, 
	Lookup5.UserDescription AS AdmittingNursingAreaUnitLDesc, Lookup6.DisplayCode AS AgeCode, Lookup6.UserDescription AS AgeCodeDesc, 
	dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, dbo.AB_Abstract.DischargeAge AS AgeUponDischarge, 
	Lookup7.DisplayCode AS AgeUponDischargeCode, Lookup7.UserDescription AS AgeUponDischargeCodeDesc, 
	Lookup28.DisplayCode AS AttendingPhysician, Lookup28.UserDescription AS AttendingPhysicianDesc, Lookup30.DisplayCode AS AutopsyPerformed, 
	Lookup30.UserDescription AS AutopsyPerformedDesc, dbo.AB_Abstract.BatchNumber, Lookup50.DisplayCode AS BatchPeriod, 
	Lookup50.UserDescription AS BatchPeriodDesc, dbo.AB_Abstract.BatchYear, Lookup51.DisplayCode AS Between210DaysPostOp, 
	Lookup51.UserDescription AS Between210DaysPostOpDesc, dbo.AB_Abstract.BirthDate, dbo.LU_CareType.DisplayCode AS CareType, 
	dbo.LU_CareType.UserDescription AS CareTypeDesc, dbo.AB_Abstract.ChartNumber, 
	dbo.AB_Abstract.ChiefComplaint AS ChiefComplaintUponAdmission, Lookup54.DisplayCode AS CoderNumber, 
	Lookup54.UserDescription AS CoderNumberDesc, Lookup55.DisplayCode AS Complication, Lookup55.UserDescription AS ComplicationDesc, 
	Lookup59.DisplayCode AS CoronerCase, Lookup59.UserDescription AS CoronerCaseDesc, Lookup60.DisplayCode AS DataEntryCoder, 
	Lookup60.UserDescription AS DataEntryCoderDesc, dbo.AB_Abstract.DateReadyDischarge AS DateReadyForDischarge, 
	dbo.AB_Abstract.CIHIDateSent AS DateSenttoCIHI, Lookup61.DisplayCode AS DeathInOR, Lookup61.UserDescription AS DeathInORDesc, 
	Lookup62.DisplayCode AS DeathInSCU, Lookup62.UserDescription AS DeathInSCUDesc, dbo.AB_Abstract.DischargeDate, 
	Lookup63.DisplayCode AS DischargeDisposition, Lookup63.UserDescription AS DischargeDispositionDesc, 
	Lookup64.DisplayCode AS DischNursingAreaUnitLocation, Lookup64.UserDescription AS DischargeNursingAreaUnitDesc, 
	Lookup65.DisplayCode AS DischargePlanning, Lookup65.UserDescription AS DischargePlanningDesc, dbo.AB_Abstract.DischargeTime, 
	--PR - 05489
	LU_DischargeTimeUnknown.DisplayCode AS DischargeTimeUnknown, LU_DischargeTimeUnknown.UserDescription AS DischargeTimeUnknownDesc, 
                      
	dbo.AB_Abstract.DateLeftER AS ERDatePatientLeft, dbo.AB_Abstract.DecisionAdmitDate AS ERDecisiontoAdmitDate, 
	dbo.AB_Abstract.DecisionAdmitTime AS ERDecisiontoAdmitTime, dbo.AB_Abstract.TimeLeftER AS ERTimePatientLeft, 
	dbo.AB_Abstract.EncounterNumber, Lookup69.DisplayCode AS EntryCode, Lookup69.UserDescription AS EntryCodeDesc, dbo.AB_Abstract.FinishDate, 
	dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, 
	FixedChartNumber,
	Lookup72.DisplayCode AS Gender, Lookup72.UserDescription AS GenderDesc, 
	Lookup73.DisplayCode AS GlasgowComaScale, Lookup73.UserDescription AS GlasgowComaScaleDesc, 
	Lookup74.DisplayCode AS Greaterthan10DaysPostOp, Lookup74.UserDescription AS Greaterthan10DaysPostOpDesc, 
	Lookup75.DisplayCode AS HCNProvince, Lookup75.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, 
	dbo.AB_Abstract.HealthCareNumber, LU_Hospital.DisplayCode AS Hospital, LU_Hospital.UserDescription AS HospitalDesc, dbo.AB_Abstract.ICDType, 
	dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
	
	Lookup77.DisplayCode AS InstitutionFrom, Lookup77.UserDescription AS InstitutionFromDesc, 
	LU_InstitutionFrom_Type.DisplayCode AS InstitutionFromType, LU_InstitutionFrom_Type.UserDescription AS InstitutionFromTypeDesc, 
	Lookup77.InstCareType AS InstFromCareType, Lookup77.HospitalType AS InstFromHospType, 

	Lookup78.DisplayCode AS InstitutionTo, 	Lookup78.UserDescription AS InstitutionToDesc, 
	LU_InstitutionTo_Type.DisplayCode AS InstitutionToType, LU_InstitutionTo_Type.UserDescription AS InstitutionToTypeDesc, 
	Lookup78.InstCareType AS InstToCareType, Lookup78.HospitalType AS InstToHospType, 

	Lookup79.DisplayCode AS InterfaceCoder, Lookup79.UserDescription AS InterfaceCoderDesc, dbo.AB_Abstract.InterfaceDate, 
	dbo.AB_Abstract.InterfaceTime, Lookup80.DisplayCode AS IsAbstractCompleted, Lookup80.UserDescription AS IsAbstractCompletedDesc, 
	Lookup81.DisplayCode AS IsAbstractCorrected, Lookup81.UserDescription AS IsAbstractCorrectedDesc, Lookup82.DisplayCode AS IsAbstractDeleted, 
	Lookup82.UserDescription AS IsAbstractDeletedDesc, Lookup83.DisplayCode AS IsAbstractSubmited, 
	Lookup83.UserDescription AS IsAbstractSubmitedDesc, Lookup84.DisplayCode AS IsAbstractValidated, 
	Lookup84.UserDescription AS IsAbstractValidatedDesc, Lookup85.DisplayCode AS IsBirthdateEstimated, 
	Lookup85.UserDescription AS IsBirthdateEstimatedDesc, 
	LU_CustomStatus.DisplayCode AS IsCustomValidated, LU_CustomStatus.UserDescription AS IsCustomValidatedDesc, 
					  
	dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
	dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LastName, Lookup86.DisplayCode AS Lessthan2DaysAfterAdmission, 
	Lookup86.UserDescription AS Lessthan2DaysAfterAdmitDesc, Lookup87.DisplayCode AS Lessthan2DaysPostOp, 
	Lookup87.UserDescription AS Lessthan2DaysPostOpDesc, dbo.AB_Abstract.MaidenName, Lookup88.DisplayCode AS MaritalStatus, 
	Lookup88.UserDescription AS MaritalStatusDesc, dbo.AB_Abstract.NewbornChart AS MaternalNewbornChartNumber, 
	dbo.AB_Abstract.NewbornDischargeDate AS MaternalNewbornDischargeDate, dbo.AB_Abstract.MiddleName, ISNULL(dbo.AB_Abstract.LastName, '' '') 
	+ '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, 
	Lookup91.DisplayCode AS OtherMedicalDeath, Lookup91.UserDescription AS OtherMedicalDeathDesc, dbo.AB_Abstract.PostalCode, 

	-- ED - 01682
	dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), isnull(dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.AdmitDate)) AS PostalDescription, -- ED - 01682

	dbo.AB_Abstract.PostOpDays, Lookup103.DisplayCode AS PreAdmitWorkup, Lookup103.UserDescription AS PreAdmitWorkupDesc, 
	Lookup104.DisplayCode AS Pregnancy, Lookup104.UserDescription AS PregnancyDesc, dbo.AB_Abstract.PreOpDays, 
	Lookup106.DisplayCode AS ReAdmitCode, Lookup106.UserDescription AS ReAdmitCodeDesc, dbo.AB_Abstract.RegisterNumber, 
	Lookup111.DisplayCode AS ReportingProvInstNumber, Lookup111.UserDescription AS ReportingProvInstNumberDesc, 
	Lookup112.DisplayCode AS ResidenceCode, Lookup112.UserDescription AS ResidenceCodeDesc, 
	Lookup114.DisplayCode AS ResponsiblityForPayment, Lookup114.UserDescription AS ResponsiblityForPaymentDesc, 
	dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, Lookup116.DisplayCode AS SecretVIPPatient, 
	Lookup116.UserDescription AS SecretVIPPatientDesc, Lookup117.DisplayCode AS SiteNumber, Lookup117.UserDescription AS SiteNumberDesc, 
	Lookup118.DisplayCode AS SocialServices, Lookup118.UserDescription AS SocialServicesDesc, 
	LU_StakeholderType.DisplayCode AS StakeholderType, LU_StakeholderType.UserDescription AS StakeholderTypeDesc, 
	dbo.AB_Abstract.RecordType AS SubmissionType, Lookup124.DisplayCode AS SurgicalCase, Lookup124.UserDescription AS SurgicalCaseDesc, 
	Lookup126.DisplayCode AS Trauma, Lookup126.UserDescription AS TraumaDesc, Lookup127.DisplayCode AS TSICoder, 
	Lookup127.UserDescription AS TSICoderDesc, dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, dbo.AB_Abstract.UniqiueLifetimeID AS ULI, 
	Lookup128.DisplayCode AS UnplannedReadmission, Lookup128.UserDescription AS UnplannedReadmissionDesc, 
	dbo.AB_Abstract.Weight AS Weightingrams, 
	dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
	dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID, 
                      dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
	dbo.LU_CodeFile LU_StakeholderType with (nolock) on dbo.AB_Abstract.StakeHolder = LU_StakeholderType.Code LEFT OUTER JOIN
	dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
	dbo.LU_CareType with (nolock) on dbo.AB_Abstract.CareType = dbo.LU_CareType.Code LEFT OUTER JOIN
	dbo.LU_AbstractOverflow Lookup2 with (nolock) on dbo.AB_Abstract.AbstractOverflow = Lookup2.Code LEFT OUTER JOIN
	dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
	dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
	dbo.LU_NurseArea Lookup5 with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = Lookup5.Code LEFT OUTER JOIN
	dbo.LU_AgeCode Lookup6 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup6.Code LEFT OUTER JOIN
	dbo.LU_AgeCode Lookup7 with (nolock) on dbo.AB_Abstract.DischargeAgeCode = Lookup7.Code LEFT OUTER JOIN
	dbo.LU_Provider Lookup28 with (nolock) on dbo.AB_Abstract.AttendingPhysician = Lookup28.Code LEFT OUTER JOIN
	dbo.LU_BatchPeriod Lookup50 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup50.Code LEFT OUTER JOIN
	dbo.U_Users Lookup54 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup54.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup55 with (nolock) on dbo.AB_Abstract.Complication = Lookup55.Code LEFT OUTER JOIN
	dbo.U_Users Lookup60 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup60.Code LEFT OUTER JOIN
	dbo.LU_DispositionCode_I Lookup63 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup63.Code LEFT OUTER JOIN
	dbo.LU_NurseArea Lookup64 with (nolock) on dbo.AB_Abstract.DischargeNurseArea = Lookup64.Code LEFT OUTER JOIN
	dbo.LU_TherDischPlan Lookup65 with (nolock) on dbo.AB_Abstract.DischargePlanning = Lookup65.Code LEFT OUTER JOIN
	dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code LEFT OUTER JOIN
	dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup73 with (nolock) on dbo.AB_Abstract.GlasgowComaScale = Lookup73.Code LEFT OUTER JOIN
	dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN
	
	dbo.LU_Institution_10 Lookup77 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup77.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionFrom_Type with (nolock) on dbo.AB_Abstract.InstitutionFromType = LU_InstitutionFrom_Type.Code LEFT OUTER JOIN
	dbo.LU_Institution_10 Lookup78 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup78.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionTo_Type with (nolock) on dbo.AB_Abstract.InstitutionToType = LU_InstitutionTo_Type.Code LEFT OUTER JOIN

	dbo.U_Users Lookup79 with (nolock) on dbo.AB_Abstract.InterfaceCoder = Lookup79.Code LEFT OUTER JOIN
	dbo.LU_AbstractStatus Lookup80 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup80.Code LEFT OUTER JOIN
	dbo.LU_CIHICorrect Lookup81 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup81.Code LEFT OUTER JOIN
	dbo.LU_YesNoSystem Lookup82 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup82.Code LEFT OUTER JOIN
	dbo.LU_YesNoSystem Lookup83 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup83.Code LEFT OUTER JOIN
	dbo.LU_AbstractStatus Lookup84 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_CustomStatus with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_CustomStatus.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup85 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup85.Code LEFT OUTER JOIN
	dbo.LU_MaritalStatus Lookup88 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup88.Code LEFT OUTER JOIN
	dbo.LU_TherPreAdmitWorkUp Lookup103 with (nolock) on dbo.AB_Abstract.PreAdmitWorkUp = Lookup103.Code LEFT OUTER JOIN
	dbo.LU_ReAdmitCode Lookup106 with (nolock) on dbo.AB_Abstract.ReAdmitCode = Lookup106.Code LEFT OUTER JOIN
	dbo.H_InstitutionProfile Lookup111 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup111.Code LEFT OUTER JOIN
	dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
	dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup116 with (nolock) on dbo.AB_Abstract.Secret = Lookup116.Code LEFT OUTER JOIN
	dbo.LU_Site Lookup117 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup117.Code LEFT OUTER JOIN
	dbo.LU_TherSocialService Lookup118 with (nolock) on dbo.AB_Abstract.SocialService = Lookup118.Code LEFT OUTER JOIN
	dbo.LU_SurgicalCode Lookup124 with (nolock) on dbo.AB_Abstract.SurgicalCase = Lookup124.Code LEFT OUTER JOIN
	dbo.U_Users Lookup127 with (nolock) on dbo.AB_Abstract.TSICoder = Lookup127.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup128 with (nolock) on dbo.AB_Abstract.UnplanReAdmit = Lookup128.Code LEFT OUTER JOIN
	dbo.AB_DeathInformation with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_DeathInformation.AbstractID LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup30 with (nolock) on dbo.AB_DeathInformation.AutopsyPerformed = Lookup30.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup51 with (nolock) on dbo.AB_DeathInformation.DeathTwoTenPO = Lookup51.Code LEFT OUTER JOIN
	dbo.LU_CoronerCase Lookup59 with (nolock) on dbo.AB_DeathInformation.CoronerCase = Lookup59.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup61 with (nolock) on dbo.AB_DeathInformation.DeathInOR = Lookup61.Code LEFT OUTER JOIN
	dbo.LU_SCU_Death Lookup62 with (nolock) on dbo.AB_DeathInformation.DeathInSCU = Lookup62.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup74 with (nolock) on dbo.AB_DeathInformation.DeathGreaterTenPO = Lookup74.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup86 with (nolock) on dbo.AB_DeathInformation.DeathAfterAdmit = Lookup86.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup87 with (nolock) on dbo.AB_DeathInformation.DeathLessTwoPO = Lookup87.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup91 with (nolock) on dbo.AB_DeathInformation.OtherDeath = Lookup91.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup104 with (nolock) on dbo.AB_DeathInformation.PregnancyDeath = Lookup104.Code LEFT OUTER JOIN
	dbo.LU_YesBlank Lookup126 with (nolock) on dbo.AB_DeathInformation.TraumaDeath = Lookup126.Code
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AdmitTimeUnknown with (nolock) on dbo.AB_Abstract.AdmitTimeUnknown = LU_AdmitTimeUnknown.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_DischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LU_DischargeTimeUnknown.Code 
--                       inner join dbo.CheckLogin() login 
--                         with (nolock) on login.HospitalID in (0, isnull(dbo.AB_Abstract.HospitalID, login.HospitalID))  
--                             or isnull(dbo.AB_Abstract.HospitalID, 0) in (0, login.HospitalID)
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType IN (1, 2))
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingGeneral_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[I10_AbstractingGeneral_VR]
AS
SELECT 
    dbo.AB_Abstract.ALCLOS, dbo.AB_Abstract.AcuteLOS, dbo.AB_Abstract.AdmitDate AS AdmissionDate, dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
	--PR - 05489
	LU_AdmitTimeUnknown.DisplayCode as AdmissionTimeUnknown, LU_AdmitTimeUnknown.UserDescription as AdmissionTimeUnknownDesc,
    
    Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, 
    LU_AdmitNurse.DisplayCode as AdmitNurseArea, LU_AdmitNurse.UserDescription as AdmitNurseAreaDesc,
    Lookup6.DisplayCode AS AgeCode,     Lookup6.UserDescription AS AgeCodeDesc, dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, 
    
    LU_BatchPeriod.DisplayCode AS BatchPeriod, LU_BatchPeriod.UserDescription AS BatchPeriodDesc, 
    --PR - 06087
    BatchPeriod_BC = (case when left(H_InstitutionProfile.CIHIValue, 1) <> ''9'' then null
                           when LU_BatchPeriod.DisplayCode is not null then LU_BatchPeriod.DisplayCode 
                           when DischargeDate is null then null
                           else (select top 1 DisplayCode from LU_BatchPeriod where DischargeDate between CIHIDateFrom and CIHIDateTo)
                      end),
    dbo.AB_Abstract.BatchYear, 

    dbo.AB_Abstract.BirthDate, 
    LU_CareType.DisplayCode as CareType, LU_CareType.UserDescription as CareTypeDesc,  dbo.AB_Abstract.ChartNumber, 
    
    Lookup54.DisplayCode AS CoderNumber, Lookup54.UserDescription AS CoderNumberDesc, 
    
    dbo.ICD_DiagFile10.DisplayCode AS DiagnosisMostResp, 
    dbo.ICD_DiagFile10.UserDescription AS DiagnosisMostRespDesc, dbo.AB_Abstract.DischargeDate, Lookup63.DisplayCode AS DischargeDisposition, 
    Lookup63.UserDescription AS DischargeDispositionDesc, dbo.AB_Abstract.DischargeTime, 
	--PR - 05489
	LU_DischargeTimeUnknown.DisplayCode AS DischargeTimeUnknown, LU_DischargeTimeUnknown.UserDescription AS DischargeTimeUnknownDesc, 
    LU_DischargeNurse.DisplayCode as DischNurseArea, LU_DischargeNurse.UserDescription as DischNurseAreaDesc,

    dbo.AB_Abstract.EncounterNumber, 
    Lookup69.DisplayCode AS EntryCode, Lookup69.UserDescription AS EntryCodeDesc, dbo.AB_Abstract.FirstName,
    FixedChartNumber,
    Lookup72.DisplayCode AS Gender, Lookup72.UserDescription AS GenderDesc, 
    Lookup75.DisplayCode AS HCNProvince, Lookup75.UserDescription AS HCNProvinceDesc, 
    dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
    LU_Hospital.DisplayCode AS Hospital,     LU_Hospital.UserDescription AS HospitalDesc, 
    dbo.AB_Abstract.HospitalAccountRecord,
    dbo.AB_Abstract.ICDType, dbo.ICD_ProcFile10.DisplayCode AS InterventionCode, 
    dbo.ICD_ProcFile10.UserDescription AS InterventionCodeDesc, dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LastName, dbo.LU_PatientService.DisplayCode AS MainPatientService, 
    dbo.LU_PatientService.UserDescription AS MainPatientServiceDesc, dbo.AB_Abstract.MiddleName, ISNULL(dbo.AB_Abstract.LastName, '' '') 
    + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, 
    dbo.AB_Manitoba.HCNExpiredDate  as OutProvinceHealthInsuranceExpiryDate,
    dbo.AB_Abstract.PostalCode, 
    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), isnull(dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.AdmitDate)) AS PostalDescription, -- ED - 01682

    dbo.LU_Provider.DisplayCode AS ProviderNumber, dbo.LU_Provider.UserDescription AS ProviderNumberDesc, 
    dbo.LU_ProviderService.DisplayCode AS ProviderService, dbo.LU_ProviderService.UserDescription AS ProviderServiceDesc, 
    --PR - 04577
    LU_ReciprocalBillingStatus.DisplayCode AS ReciprocalBillingStatus, LU_ReciprocalBillingStatus.UserDescription AS ReciprocalBillingStatusDesc,

    AB_Abstract.RegisterNumber,
    dbo.H_InstitutionProfile.DisplayCode AS ReportingProvInstNumber, dbo.H_InstitutionProfile.UserDescription AS ReportingProvInstNumberDesc, 
    Lookup112.DisplayCode AS ResidenceCode, Lookup112.UserDescription AS ResidenceCodeDesc, 
    Lookup114.DisplayCode AS ResponsiblityForPayment, Lookup114.UserDescription AS ResponsiblityForPaymentDesc, 
    --PR - 03606
    dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 

	dbo.AB_Abstract.UniversalEpisodeIdentifier,
    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, 
    dbo.AB_Abstract.WaitTimeER AS WaitTimeInEmerg, 
    dbo.AB_Abstract.WaitTimeERHour AS WaitTimeInEmergHour, 
    dbo.AB_Abstract.Weight AS Weightingrams, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID, 
    dbo.AB_Abstract.VolumeID AS zzVolumeLink, 
    ISNULL(dbo.AB_Diagnosis.DiagnosisOccurrence, 1) 
    AS DiagnosisOccurrence, ISNULL(dbo.AB_Intervention.IntervOccurrence, 1) AS IntervOccurrence, ISNULL(dbo.AB_PatientService.ServiceOccurrence, 1) 
    AS ServiceOccurrence, ISNULL(dbo.AB_Provider.ProviderOccurrence, 1) AS ProviderOccurrence
FROM
     
    dbo.AB_Abstract with (nolock) left join
    dbo.AB_Provider with (nolock) on dbo.AB_Provider.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_ProviderService with (nolock) on dbo.LU_ProviderService.Code = dbo.AB_Provider.ProviderService LEFT OUTER JOIN
    dbo.LU_Provider with (nolock) on dbo.LU_Provider.Code = dbo.AB_Provider.ProviderNumber left OUTER JOIN
    
    dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code left OUTER JOIN
    dbo.H_InstitutionProfile with (nolock) on dbo.H_InstitutionProfile.Code = dbo.AB_Abstract.InstitutionNumber LEFT OUTER JOIN
    dbo.AB_Intervention with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Intervention.AbstractID left join
    dbo.ICD_ProcFile10 with (nolock) on dbo.ICD_ProcFile10.Code = dbo.AB_Intervention.IntervCode LEFT OUTER JOIN

    dbo.AB_PatientService with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_PatientService.AbstractID LEFT OUTER JOIN
    dbo.LU_PatientService with (nolock) on dbo.AB_PatientService.PatientService = dbo.LU_PatientService.Code LEFT OUTER JOIN
    dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup6 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup6.Code left join
    dbo.LU_DispositionCode_I Lookup63 with (nolock) on Lookup63.Code = dbo.AB_Abstract.DispositionCode LEFT OUTER JOIN
    dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
    dbo.AB_Diagnosis with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Diagnosis.AbstractID LEFT OUTER JOIN

    dbo.ICD_DiagFile10 with (nolock) on dbo.ICD_DiagFile10.Code = dbo.AB_Diagnosis.DiagnosisCode  LEFT OUTER JOIN
    dbo.LU_NurseArea LU_AdmitNurse with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurse.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_DischargeNurse with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurse.Code LEFT OUTER JOIN
    dbo.LU_CareType LU_CareType with (nolock) on dbo.AB_Abstract.CareType = LU_CareType.Code 
--PR - 04577
    LEFT OUTER JOIN dbo.LU_ReciprocalBillingStatus with (nolock) on dbo.AB_Abstract.IsReciprocalBilling = LU_ReciprocalBillingStatus.Code 

    LEFT OUTER JOIN dbo.LU_CodeFile LU_AdmitTimeUnknown with (nolock) on dbo.AB_Abstract.AdmitTimeUnknown = LU_AdmitTimeUnknown.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_DischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LU_DischargeTimeUnknown.Code 
    Left OUTER JOIN dbo.AB_Manitoba with (nolock) on dbo.AB_Manitoba.AbstractID = dbo.AB_Abstract.AbstractID
    LEFT OUTER JOIN dbo.LU_BatchPeriod with (nolock) on dbo.AB_Abstract.BatchPeriod = LU_BatchPeriod.Code 
    LEFT OUTER JOIN dbo.U_Users Lookup54 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup54.Code 

WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType IN (1, 2)) AND (ISNULL(dbo.AB_Diagnosis.DiagnosisOccurrence, 1) = 1) AND 
                      (ISNULL(dbo.AB_Intervention.IntervOccurrence, 1) = 1) AND (ISNULL(dbo.AB_PatientService.ServiceOccurrence, 1) = 1) AND 
                      (ISNULL(dbo.AB_Provider.ProviderOccurrence, 1) = 1)
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingInterventionReplicate_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[I10_AbstractingInterventionReplicate_VR]
AS
SELECT 
    dbo.AB_Abstract.ALCLOS, dbo.AB_Abstract.AcuteLOS, dbo.AB_Abstract.AdmitDate AS AdmissionDate, dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
    Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, 
    LU_AdmitNurse.DisplayCode as AdmitNurseArea, LU_AdmitNurse.UserDescription as AdmitNurseAreaDesc,
    dbo.LU_AgeCode.DisplayCode AS AgeCode, dbo.LU_AgeCode.UserDescription AS AgeCodeDesc, 
    dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, dbo.AB_Abstract.BirthDate, 
    LU_CareType.DisplayCode as CareType, LU_CareType.UserDescription as CareTypeDesc,  dbo.AB_Abstract.ChartNumber, 
    
    AB_Intervention_Replicate.IntervJointIdentifier as CJRRJointIdentifier,
    LU_CJRR_RevisionReason.DisplayCode AS CJRRRevisionReason, LU_CJRR_RevisionReason.UserDescription AS CJRRRevisionReasonDesc,

    dbo.ICD_DiagFile10.DisplayCode AS DiagnosisMostResp, 
    dbo.ICD_DiagFile10.UserDescription AS DiagnosisMostRespDesc, dbo.AB_Abstract.DischargeDate, 
    
    dbo.LU_DispositionCode_I.DisplayCode AS DischargeDisposition, dbo.LU_DispositionCode_I.UserDescription AS DischargeDispositionDesc, 
    dbo.AB_Abstract.DischargeTime, 
    LU_DischargeNurse.DisplayCode as DischNurseArea, LU_DischargeNurse.UserDescription as DischNurseAreaDesc,

    dbo.AB_Abstract.EncounterNumber, 
    Lookup69.DisplayCode AS EntryCode, Lookup69.UserDescription AS EntryCodeDesc, dbo.AB_Abstract.FirstName, Lookup72.DisplayCode AS Gender, 
    Lookup72.UserDescription AS GenderDesc, Lookup75.DisplayCode AS HCNProvince, Lookup75.UserDescription AS HCNProvinceDesc, 
    dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, LU_Hospital.DisplayCode AS Hospital, 
    LU_Hospital.UserDescription AS HospitalDesc, dbo.AB_Abstract.ICDType, 
    dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LastName, dbo.LU_PatientService.DisplayCode AS MainPatientService, 
    dbo.LU_PatientService.UserDescription AS MainPatientServiceDesc, dbo.AB_Abstract.MiddleName, ISNULL(dbo.AB_Abstract.LastName, '' '') 
    + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, dbo.AB_Abstract.PostalCode, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), isnull(dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.AdmitDate)) AS PostalDescription, -- ED - 01682

    dbo.LU_Provider.DisplayCode AS ProviderNumber, dbo.LU_Provider.UserDescription AS ProviderNumberDesc, 
    dbo.LU_ProviderService.DisplayCode AS ProviderService, dbo.LU_ProviderService.UserDescription AS ProviderServiceDesc, 
    dbo.H_InstitutionProfile.DisplayCode AS ReportingProvInstNumber, dbo.H_InstitutionProfile.UserDescription AS ReportingProvInstNumberDesc, 
    Lookup112.DisplayCode AS ResidenceCode, Lookup112.UserDescription AS ResidenceCodeDesc, 
    Lookup114.DisplayCode AS ResponsiblityForPayment, Lookup114.UserDescription AS ResponsiblityForPaymentDesc, 
    --PR - 03606
    dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 

    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, dbo.AB_Abstract.WaitTimeER AS WaitTimeInEmerg, dbo.AB_Abstract.Weight AS Weightingrams, 
    ISNULL(dbo.AB_Diagnosis.DiagnosisOccurrence, 1) AS DiagnosisOccurrence, 
    ISNULL(dbo.AB_PatientService.ServiceOccurrence, 1) AS ServiceOccurrence, 
    ISNULL(dbo.AB_Provider.ProviderOccurrence, 1) AS ProviderOccurrence,

    --Intervention Replicate 
    LU_AnaestTechnique.DisplayCode AS AnaestheticTechnique, LU_AnaestTechnique.UserDescription AS AnaestheticTechniqueDesc,
    LU_AnaesthetistID.DisplayCode AS AnaesthetistID, LU_AnaesthetistID.UserDescription AS AnaesthetistIDDesc,
    LU_EUL.DisplayCode AS EUL, LU_EUL.UserDescription AS EULDesc,
    LU_Extra.DisplayCode AS Extra, LU_Extra.UserDescription AS ExtraDesc,
    Lookup5.DisplayCode AS IntervAttribExtent,   Lookup5.UserDescription AS IntervAttribExtentDesc, 
    Lookup6.DisplayCode AS IntervAttribLocation, Lookup6.UserDescription AS IntervAttribLocationDesc, 
    Lookup7.DisplayCode AS IntervAttribStatus,   Lookup7.UserDescription AS IntervAttribStatusDesc, 
    dbo.ICD_ProcFile10.CIHIValue AS IntervCIHIValue, dbo.ICD_ProcFile10.DisplayCode AS IntervCode,
    dbo.ICD_ProcFile10.UserDescription AS IntervCodeDesc, dbo.ICD_ProcFile10.ShortDescription AS IntervCodeShortDesc, 
    AB_Intervention_Replicate.IntervDate, 
    AB_Intervention_Replicate.IntervDateIn, 
    AB_Intervention_Replicate.IntervDateOut, 

    LU_TimeInUnknown.DisplayCode as IntervEpisodeStartTimeUnknown, LU_TimeInUnknown.UserDescription as IntervEpisodeStartTimeUnknownDesc,
    LU_TimeOutUnknown.DisplayCode as IntervEpisodeEndTimeUnknown, LU_TimeOutUnknown.UserDescription as IntervEpisodeEndTimeUnknownDesc,
    LU_Flagged.DisplayCode AS IntervFlaggedCategory, LU_Flagged.UserDescription AS IntervFlaggedCategoryDesc, 
    
    LU_Suffix.DisplayCode as Suffix, LU_Suffix.UserDescription as SuffixDesc,

    LU_IntervLocation.DisplayCode as IntervLocation, LU_IntervLocation.UserDescription as IntervLocationDesc,

    dbo.AB_Intervention_Replicate.IntervOccurrence, 
    
    LU_IntervPreAdmitFlag.DisplayCode as IntervPreAdmitFlag, LU_IntervPreAdmitFlag.UserDescription as IntervPreAdmitFlagDesc, 
    
    
    lp.DisplayCode as IntervProviderNumber, lp.UserDescription as IntervProviderNumberDesc, 
    (case when dbo.AB_Abstract.Caretype = 5 then '''' else lsv.DisplayCode end) as IntervProviderService, 
    (case when dbo.AB_Abstract.Caretype = 5 then '''' else lsv.UserDescription end) as IntervProviderServiceDesc, 
    (case when dbo.AB_Abstract.Caretype = 5 then lsp.DisplayCode else '''' end) as IntervProviderSpecialty, 
    (case when dbo.AB_Abstract.Caretype = 5 then lsp.UserDescription else '''' end) as IntervProviderSpecialtyDesc, 
    
    --PR - 04074
    AB_Intervention_Replicate.IntervTimeIn, 
    AB_Intervention_Replicate.IntervTimeMinutes AS IntervTimeinMinutes, 
    AB_Intervention_Replicate.IntervTimeOut, 

    LU_OOH.DisplayCode AS OOHIndicator, LU_OOH.UserDescription AS OOHIndicatorDesc, 
    LU_OOH_Inst.DisplayCode as OOHInstitutionNumber, LU_OOH_Inst.UserDescription AS OOHInstitutionNumberDesc, 
    AB_Intervention_Replicate.IntervTripNumber as ORTripNumber,  
    
    LU_IntervTissue.DisplayCode as TissueCode, LU_IntervTissue.UserDescription as TissueCodeDesc, 
    LU_IntervTissue.DefaultDescription as TissueCodeDesc_D, 
    LU_IntervUnplanReturn.DisplayCode AS UnplannedReturntoOR, LU_IntervUnplanReturn.UserDescription AS UnplannedReturntoORDesc,
    dbo.ICD_ProcFile10.ICD9 AS ICD9Equivalent, dbo.ICD_ProcFile10.ICD9cm AS ICD9cmEquivalent, 

    dbo.AB_Abstract.AbstractID AS zzAbstractLink, dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.AB_Provider with (nolock) on dbo.AB_Provider.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_Provider with (nolock) on dbo.LU_Provider.Code = dbo.AB_Provider.ProviderNumber Left OUTER JOIN
    dbo.LU_ProviderService with (nolock) on dbo.LU_ProviderService.Code = dbo.AB_Provider.ProviderService LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile with (nolock) on dbo.H_InstitutionProfile.Code = dbo.AB_Abstract.InstitutionNumber LEFT OUTER JOIN
    dbo.AB_PatientService with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_PatientService.AbstractID LEFT OUTER JOIN
    dbo.LU_PatientService with (nolock) on dbo.AB_PatientService.PatientService = dbo.LU_PatientService.Code LEFT OUTER JOIN
    dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_AgeCode with (nolock) on dbo.AB_Abstract.AgeCode = dbo.LU_AgeCode.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_I with (nolock) on dbo.LU_DispositionCode_I.Code = dbo.AB_Abstract.DispositionCode LEFT OUTER JOIN
    dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
    dbo.AB_Diagnosis with (nolock) on  dbo.AB_Abstract.AbstractID = dbo.AB_Diagnosis.AbstractID LEFT OUTER JOIN
    dbo.ICD_DiagFile10 with (nolock) on dbo.ICD_DiagFile10.Code = dbo.AB_Diagnosis.DiagnosisCode left OUTER JOIN
    dbo.LU_NurseArea LU_AdmitNurse with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurse.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_DischargeNurse with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurse.Code LEFT OUTER JOIN
    dbo.LU_CareType LU_CareType with (nolock) on dbo.AB_Abstract.CareType = LU_CareType.Code LEFT OUTER JOIN
    --Intervention Reciplicate
    dbo.AB_Intervention_Replicate with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Intervention_Replicate.AbstractID LEFT OUTER JOIN
    dbo.ICD_ProcFile10 with (nolock) on dbo.ICD_ProcFile10.Code = dbo.AB_Intervention_Replicate.IntervCode LEFT OUTER JOIN
    dbo.LU_IntervAttExtent Lookup5 with (nolock) on dbo.AB_Intervention_Replicate.IntervAttribExtent = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_IntervAttLocation Lookup6 with (nolock) on dbo.AB_Intervention_Replicate.IntervAttribLocation = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_IntervAttStatus Lookup7 with (nolock) on dbo.AB_Intervention_Replicate.IntervAttribStatus = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_IntervPreAdmitFlag with (nolock) on dbo.AB_Intervention_Replicate.IntervPreAdmitFlag = LU_IntervPreAdmitFlag.Code LEFT OUTER JOIN
    
    --Intervention Provider
    dbo.LU_Provider Lp with (nolock) on AB_Intervention_Replicate.IntervProviderNumber = lp.Code Left Join
    --Intervention Provider Service/Specialty
	dbo.LU_ProviderService Lsv with (nolock) on AB_Intervention_Replicate.IntervProviderService = lsv.Code left join
	dbo.LU_ProviderSpecialty Lsp with (nolock) on AB_Intervention_Replicate.IntervProviderService = lsp.Code Left Join 
    --Intervention Tissue Code
    dbo.LU_IntervTissue with (nolock) on AB_Intervention_Replicate.IntervTissueCode = LU_IntervTissue.Code Left Join
    --Intervention Location
    dbo.LU_IntervLocation_AI LU_IntervLocation with (nolock) ON AB_Intervention_Replicate.IntervLocation = LU_IntervLocation.Code Left Join
    --Intervention IntervAnaestID
    dbo.LU_Provider LU_AnaesthetistID with (nolock) ON AB_Intervention_Replicate.IntervAnaestID = LU_AnaesthetistID.Code Left Join
    --Intervention Anaesthetic Technique
     dbo.LU_AnaestTechnique ON AB_Intervention_Replicate.IntervAnaestTechnique = LU_AnaestTechnique.Code Left Join
	--IntervUnplanReturn
    dbo.LU_YesBlankAlpha LU_IntervUnplanReturn with (nolock) ON AB_Intervention_Replicate.IntervUnplanReturn = LU_IntervUnplanReturn.Code Left join
    --Intervention OOH
     dbo.LU_YesBlank LU_OOH with (nolock) ON AB_Intervention_Replicate.IntervOOHIndicator = LU_OOH.Code Left join
     dbo.LU_Institution_10 LU_OOH_Inst ON AB_Intervention_Replicate.IntervOOHInstitution = LU_OOH_Inst.Code Left join

    --Intervention EUL
    dbo.LU_IntervEUL LU_EUL with (nolock) ON AB_Intervention_Replicate.IntervEUL = LU_EUL.Code Left Join
    --Intervention Extra      
    dbo.LU_IntervExtra LU_Extra ON AB_Intervention_Replicate.IntervExtra = LU_Extra.Code Left Join
    dbo.LU_CodeFile LU_TimeInUnknown ON AB_Intervention_Replicate.IntervTimeInUnknown = LU_TimeInUnknown.Code  Left Join

    --Intervention Time Out Unknown -- PR - 04332
    dbo.LU_CodeFile LU_TimeOutUnknown with (nolock) ON AB_Intervention_Replicate.IntervTimeOutUnknown = LU_TimeOutUnknown.Code Left Join

    --Intervention Suffix -- PR - 05248
    dbo.LU_IntervSuffix LU_Suffix ON AB_Intervention_Replicate.IntervSuffix = lU_Suffix.Code left join

    --Intervention PreAdmitFlag -- PR - 05413
    dbo.LU_codeFile LU_PreAdmitFlag with (nolock) ON AB_Intervention_Replicate.IntervPreAdmitFlag = LU_PreAdmitFlag.Code  LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_Flagged with (nolock) on dbo.AB_Intervention_Replicate.FlaggedIntervention = LU_Flagged.Code LEFT OUTER JOIN
    LU_CJRR_RevisionReason with (nolock) on dbo.AB_Intervention_Replicate.IntervRevisionReason = LU_CJRR_RevisionReason.Code

WHERE (dbo.AB_Abstract.DischargeDate > ''2001/03/31'' or dbo.AB_Abstract.AdmitDate > ''2001/03/31'') and
    (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType IN (1, 2)) AND 
    (ISNULL(dbo.AB_Diagnosis.DiagnosisOccurrence, 1) = 1) AND 
    (ISNULL(dbo.AB_PatientService.ServiceOccurrence, 1) = 1) AND 
    (ISNULL(dbo.AB_Provider.ProviderOccurrence, 1) = 1)
----PR - 07485    
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)

/*  Old Logic
SELECT 
    dbo.AB_Abstract.ALCLOS, dbo.AB_Abstract.AcuteLOS, dbo.AB_Abstract.AdmitDate AS AdmissionDate, dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
    Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, 
    LU_AdmitNurse.DisplayCode as AdmitNurseArea, LU_AdmitNurse.UserDescription as AdmitNurseAreaDesc,
    dbo.LU_AgeCode.DisplayCode AS AgeCode, dbo.LU_AgeCode.UserDescription AS AgeCodeDesc, 
    dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, dbo.AB_Abstract.BirthDate, 
    LU_CareType.DisplayCode as CareType, LU_CareType.UserDescription as CareTypeDesc,  dbo.AB_Abstract.ChartNumber, dbo.ICD_DiagFile10.DisplayCode AS DiagnosisMostResp, 
    dbo.ICD_DiagFile10.UserDescription AS DiagnosisMostRespDesc, dbo.AB_Abstract.DischargeDate, 
    
    dbo.LU_DispositionCode_I.DisplayCode AS DischargeDisposition, dbo.LU_DispositionCode_I.UserDescription AS DischargeDispositionDesc, 
    dbo.AB_Abstract.DischargeTime, 
    LU_DischargeNurse.DisplayCode as DischNurseArea, LU_DischargeNurse.UserDescription as DischNurseAreaDesc,

    dbo.AB_Abstract.EncounterNumber, 
    Lookup69.DisplayCode AS EntryCode, Lookup69.UserDescription AS EntryCodeDesc, dbo.AB_Abstract.FirstName, Lookup72.DisplayCode AS Gender, 
    Lookup72.UserDescription AS GenderDesc, Lookup75.DisplayCode AS HCNProvince, Lookup75.UserDescription AS HCNProvinceDesc, 
    dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, LU_Hospital.DisplayCode AS Hospital, 
    LU_Hospital.UserDescription AS HospitalDesc, dbo.AB_Abstract.ICDType, 
    dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LastName, dbo.LU_PatientService.DisplayCode AS MainPatientService, 
    dbo.LU_PatientService.UserDescription AS MainPatientServiceDesc, dbo.AB_Abstract.MiddleName, ISNULL(dbo.AB_Abstract.LastName, '' '') 
    + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, dbo.AB_Abstract.PostalCode, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), isnull(dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.AdmitDate)) AS PostalDescription, -- ED - 01682

    dbo.LU_Provider.DisplayCode AS ProviderNumber, dbo.LU_Provider.UserDescription AS ProviderNumberDesc, 
    dbo.LU_ProviderService.DisplayCode AS ProviderService, dbo.LU_ProviderService.UserDescription AS ProviderServiceDesc, 
    dbo.H_InstitutionProfile.DisplayCode AS ReportingProvInstNumber, dbo.H_InstitutionProfile.UserDescription AS ReportingProvInstNumberDesc, 
    Lookup112.DisplayCode AS ResidenceCode, Lookup112.UserDescription AS ResidenceCodeDesc, 
    Lookup114.DisplayCode AS ResponsiblityForPayment, Lookup114.UserDescription AS ResponsiblityForPaymentDesc, 
    --PR - 03606
    dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 

    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, dbo.AB_Abstract.WaitTimeER AS WaitTimeInEmerg, dbo.AB_Abstract.Weight AS Weightingrams, 
    ISNULL(dbo.AB_Diagnosis.DiagnosisOccurrence, 1) AS DiagnosisOccurrence, 
    ISNULL(dbo.AB_PatientService.ServiceOccurrence, 1) AS ServiceOccurrence, 
    ISNULL(dbo.AB_Provider.ProviderOccurrence, 1) AS ProviderOccurrence,

    --Intervention Replicate 
    at.AnaestheticTechnique, at.AnaestheticTechniqueDesc, 
    a.AnaesthetistID, a.AnaesthetistIDDesc, 
    eul.EUL, eul.EULDesc, 
    ex.Extra, ex.ExtraDesc, 
    Lookup5.DisplayCode AS IntervAttribExtent,   Lookup5.UserDescription AS IntervAttribExtentDesc, 
    Lookup6.DisplayCode AS IntervAttribLocation, Lookup6.UserDescription AS IntervAttribLocationDesc, 
    Lookup7.DisplayCode AS IntervAttribStatus,   Lookup7.UserDescription AS IntervAttribStatusDesc, 
    dbo.ICD_ProcFile10.CIHIValue AS IntervCIHIValue, dbo.ICD_ProcFile10.DisplayCode AS IntervCode,
    dbo.ICD_ProcFile10.UserDescription AS IntervCodeDesc, dbo.ICD_ProcFile10.ShortDescription AS IntervCodeShortDesc, 
    e.IntervDate, 
    --PR - 04074
    DateIn.IntervDateIn, --ISNULL(dbo.AB_Intervention.IntervDateIn, e.IntervDateIn) AS IntervDateIn, 
    DateOut.IntervDateOut, --ISNULL(dbo.AB_Intervention.IntervDateOut, e.IntervDateOut) AS IntervDateOut, 
    --e.IntervDateIn, --ISNULL(dbo.AB_Intervention.IntervDateIn, e.IntervDateIn) AS IntervDateIn, 
    --e.IntervDateOut, --ISNULL(dbo.AB_Intervention.IntervDateOut, e.IntervDateOut) AS IntervDateOut, 

    --PR - 04332
    TimeInUnknown.IntervEpisodeStartTimeUnknown, TimeInUnknown.IntervEpisodeStartTimeUnknownDesc,
    TimeOutUnknown.IntervEpisodeEndTimeUnknown, TimeOutUnknown.IntervEpisodeEndTimeUnknownDesc,
    --PR - 05248
    Suffix.IntervSuffix, Suffix.IntervSuffixDesc, 

    l.IntervLocation, l.IntervLocationDesc, 
    dbo.AB_Intervention.IntervOccurrence, 
    --PR - 05413
    --LU_IntervPreAdmitFlag.DisplayCode as IntervPreAdmitFlag, LU_IntervPreAdmitFlag.UserDescription as IntervPreAdmitFlagDesc, 
    PreAdmit.IntervPreAdmitFlag, PreAdmit.IntervPreAdmitFlagDesc, 
    
    p.IntervProviderNumber, p.IntervProviderNumberDesc, 
    (case when dbo.AB_Abstract.Caretype = 5 then '''' else s.IntervProviderService end) as IntervProviderService, 
    (case when dbo.AB_Abstract.Caretype = 5 then '''' else s.IntervProviderServiceDesc end) as IntervProviderServiceDesc, 
    (case when dbo.AB_Abstract.Caretype = 5 then s.IntervProviderSpecialty else '''' end) as IntervProviderSpecialty, 
    (case when dbo.AB_Abstract.Caretype = 5 then s.IntervProviderSpecialtyDesc else '''' end) as IntervProviderSpecialtyDesc, 
    --PR - 04074
    TimeIn.IntervTimeIn, 
    e.IntervTimeMinutes AS IntervTimeinMinutes, --ISNULL(dbo.AB_Intervention.IntervTimeMinutes, e.IntervTimeMinutes) AS IntervTimeinMinutes, 
    TimeOut.IntervTimeOut, 
    --e.IntervTimeIn, --ISNULL(dbo.AB_Intervention.IntervTimeIn, e.IntervTimeIn) AS IntervTimeIn, 
    --e.IntervTimeOut, --ISNULL(dbo.AB_Intervention.IntervTimeOut, e.IntervTimeOut) AS IntervTimeOut, 

    e.OOHIndicator, --ISNULL(Lookup11.DisplayCode, e.OOHIndicator) AS OOHIndicator, 
    e.OOHIndicatorDesc, --ISNULL(Lookup11.UserDescription, e.OOHIndicatorDesc) AS OOHIndicatorDesc, 
    e.OOHInstitutionNumber, --ISNULL(Lookup12.DisplayCode, e.OOHInstitutionNumber) AS OOHInstitutionNumber, 
    e.OOHInstitutionNumberDesc, --ISNULL(Lookup12.UserDescription, e.OOHInstitutionNumberDesc) AS OOHInstitutionNumberDesc, 
    trip.ORTripNumber,  
    t.TissueCode, t.TissueCodeDesc, t.TissueCodeDesc_D, 
    r.UnplannedReturntoOR, r.UnplannedReturntoORDesc, 
    dbo.ICD_ProcFile10.ICD9 AS ICD9Equivalent, dbo.ICD_ProcFile10.ICD9cm AS ICD9cmEquivalent, 

    dbo.AB_Abstract.AbstractID AS zzAbstractLink, dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.AB_Provider with (nolock) on dbo.AB_Provider.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_Provider with (nolock) on dbo.LU_Provider.Code = dbo.AB_Provider.ProviderNumber Left OUTER JOIN
    dbo.LU_ProviderService with (nolock) on dbo.LU_ProviderService.Code = dbo.AB_Provider.ProviderService LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile with (nolock) on dbo.H_InstitutionProfile.Code = dbo.AB_Abstract.InstitutionNumber LEFT OUTER JOIN
    dbo.AB_PatientService with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_PatientService.AbstractID LEFT OUTER JOIN
    dbo.LU_PatientService with (nolock) on dbo.AB_PatientService.PatientService = dbo.LU_PatientService.Code LEFT OUTER JOIN
    dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_AgeCode with (nolock) on dbo.AB_Abstract.AgeCode = dbo.LU_AgeCode.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_I with (nolock) on dbo.LU_DispositionCode_I.Code = dbo.AB_Abstract.DispositionCode LEFT OUTER JOIN
    dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
    dbo.AB_Diagnosis with (nolock) on  dbo.AB_Abstract.AbstractID = dbo.AB_Diagnosis.AbstractID LEFT OUTER JOIN
    dbo.ICD_DiagFile10 with (nolock) on dbo.ICD_DiagFile10.Code = dbo.AB_Diagnosis.DiagnosisCode left OUTER JOIN
    dbo.LU_NurseArea LU_AdmitNurse with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurse.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_DischargeNurse with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurse.Code LEFT OUTER JOIN
    dbo.LU_CareType LU_CareType with (nolock) on dbo.AB_Abstract.CareType = LU_CareType.Code LEFT OUTER JOIN
    --Intervention Reciplicate
    dbo.AB_Intervention with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Intervention.AbstractID LEFT OUTER JOIN
    dbo.ICD_ProcFile10 with (nolock) on dbo.ICD_ProcFile10.Code = dbo.AB_Intervention.IntervCode LEFT OUTER JOIN
    dbo.LU_IntervAttExtent Lookup5 with (nolock) on dbo.AB_Intervention.IntervAttribExtent = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_IntervAttLocation Lookup6 with (nolock) on dbo.AB_Intervention.IntervAttribLocation = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_IntervAttStatus Lookup7 with (nolock) on dbo.AB_Intervention.IntervAttribStatus = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_IntervPreAdmitFlag with (nolock) on dbo.AB_Intervention.IntervPreAdmitFlag = LU_IntervPreAdmitFlag.Code LEFT OUTER JOIN
    --Intervention Provider
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lp.DisplayCode AS IntervProviderNumber, lp.UserDescription AS IntervProviderNumberDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Provider_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_Provider Lp with (nolock) on p.IntervProviderNumber = lp.Code 
        WHERE      AB_Abstract.ICDType = ''T'' 

      ) p ON dbo.AB_Intervention.AbstractID = p.AbstractID AND dbo.AB_Intervention.IntervOccurrence = p.IntervOccurrence  Left Join
    --Intervention Provider Service/Specialty
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lsv.DisplayCode AS IntervProviderService,   lsv.UserDescription AS IntervProviderServiceDesc,
                 lsp.DisplayCode AS IntervProviderSpecialty, lsp.UserDescription AS IntervProviderSpecialtyDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Service_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_ProviderService Lsv with (nolock) on p.IntervProviderService = lsv.Code left join
             dbo.LU_ProviderSpecialty Lsp with (nolock) on p.IntervProviderService = lsp.Code 
        WHERE      AB_Abstract.ICDType = ''T'' 

      ) s ON dbo.AB_Intervention.AbstractID = s.AbstractID AND dbo.AB_Intervention.IntervOccurrence = s.IntervOccurrence Left Join 
    --Intervention Tissue Code
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS TissueCode, lt.UserDescription AS TissueCodeDesc, lt.DefaultDescription AS TissueCodeDesc_D
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Tissue_VR v with (nolock) on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_IntervTissue Lt with (nolock) on p.IntervTissueCode = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) t ON dbo.AB_Intervention.AbstractID = t.AbstractID AND dbo.AB_Intervention.IntervOccurrence = t.IntervOccurrence Left Join
    --Intervention Location
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS IntervLocation, lt.UserDescription AS IntervLocationDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Location_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_IntervLocation_AI Lt with (nolock) ON p.IntervLocation = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) l ON dbo.AB_Intervention.AbstractID = l.AbstractID AND dbo.AB_Intervention.IntervOccurrence = l.IntervOccurrence Left Join
    --Intervention IntervAnaestID
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS AnaesthetistID, lt.UserDescription AS AnaesthetistIDDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Anaesthetist_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_Provider Lt with (nolock) ON p.IntervAnaestID = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) a ON dbo.AB_Intervention.AbstractID = a.AbstractID AND dbo.AB_Intervention.IntervOccurrence = a.IntervOccurrence Left Join
    --Intervention Anaesthetic Technique
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS AnaestheticTechnique, lt.UserDescription AS AnaestheticTechniqueDesc
        FROM dbo.AB_Intervention p INNER JOIN
             dbo.AB_Abstract on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Technique_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_AnaestTechnique Lt ON p.IntervAnaestTechnique = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) at ON dbo.AB_Intervention.AbstractID = at.AbstractID AND dbo.AB_Intervention.IntervOccurrence = at.IntervOccurrence Left Join
    --Intervention Unplanned Return To OR
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS UnplannedReturntoOR, lt.UserDescription AS UnplannedReturntoORDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_UnplanReturn_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_YesBlankAlpha Lt with (nolock) ON p.IntervUnplanReturn = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) r ON dbo.AB_Intervention.AbstractID = r.AbstractID AND dbo.AB_Intervention.IntervOccurrence = r.IntervOccurrence Left Join
    --Intervention Episode
      (SELECT    p.AbstractID, v.IntervOccurrence, p.IntervDate, p.IntervDateIn, p.IntervTimeIn, p.IntervDateOut, p.IntervTimeOut, p.IntervTimeMinutes,
                 lt.DisplayCode AS OOHIndicator, lt.UserDescription AS OOHIndicatorDesc,
                 i.DisplayCode AS OOHInstitutionNumber, i.UserDescription AS OOHInstitutionNumberDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_YesBlank Lt with (nolock) ON p.IntervOOHIndicator = lt.Code Left join
             dbo.LU_Institution_10 i ON p.IntervOOHInstitution = i.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) e ON dbo.AB_Intervention.AbstractID = e.AbstractID AND dbo.AB_Intervention.IntervOccurrence = e.IntervOccurrence Left Join
    --Intervention EUL
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS EUL, lt.UserDescription AS EULDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_EUL_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_IntervEUL Lt with (nolock) ON p.IntervEUL = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) eul ON dbo.AB_Intervention.AbstractID = eul.AbstractID AND dbo.AB_Intervention.IntervOccurrence = eul.IntervOccurrence Left Join
    --Intervention Extra      
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS Extra, lt.UserDescription AS ExtraDesc
        FROM dbo.AB_Intervention p INNER JOIN
             dbo.AB_Abstract on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Extra_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_IntervExtra Lt ON p.IntervEUL = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) ex ON dbo.AB_Intervention.AbstractID = ex.AbstractID AND dbo.AB_Intervention.IntervOccurrence = ex.IntervOccurrence Left Join
    --Intervention Trip Number      
      (SELECT    p.AbstractID, v.IntervOccurrence, IntervTripNumber as ORTripNumber
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_TripNumber_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  
        WHERE AB_Abstract.ICDType = ''T'' 
      ) trip ON dbo.AB_Intervention.AbstractID = trip.AbstractID AND dbo.AB_Intervention.IntervOccurrence = trip.IntervOccurrence left join
    --Intervention Pre Admit Flag PR - 04313 Intervention Pre Admit Flag is not replicated.
--      (SELECT    p.AbstractID, v.IntervOccurrence, 
--                 lt.DisplayCode AS InterventionPreAdmitFlag, lt.UserDescription AS InterventionPreAdmitFlagDesc
--        FROM dbo.AB_Intervention p INNER JOIN
--             dbo.AB_Abstract on p.AbstractID = AB_Abstract.AbstractID inner join
--             dbo.InterventionEpisode_IntervPreAdmitFlag_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
--             dbo.LU_CodeFile Lt ON p.IntervPreAdmitFlag = lt.Code 
--        WHERE AB_Abstract.ICDType = ''T'' 
--      ) pa ON dbo.AB_Intervention.AbstractID = pa.AbstractID AND dbo.AB_Intervention.IntervOccurrence = pa.IntervOccurrence Left Join
    --Intervention Date In --PR - 04074 CSR want to add this
      (SELECT    p.AbstractID, v.IntervOccurrence, IntervDateIn 
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_IntervDateIn_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  
        WHERE AB_Abstract.ICDType = ''T'' 
      ) DateIn ON dbo.AB_Intervention.AbstractID = DateIn.AbstractID AND dbo.AB_Intervention.IntervOccurrence = DateIn.IntervOccurrence left join
    --Intervention Time In --PR - 04074 CSR want to add this
      (SELECT    p.AbstractID, v.IntervOccurrence, IntervTimeIn 
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_IntervTimeIn_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  
        WHERE AB_Abstract.ICDType = ''T'' 
      ) TimeIn ON dbo.AB_Intervention.AbstractID = TimeIn.AbstractID AND dbo.AB_Intervention.IntervOccurrence = TimeIn.IntervOccurrence left join
    --Intervention Date Out --PR - 04074 CSR want to add this
      (SELECT    p.AbstractID, v.IntervOccurrence, IntervDateOut 
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_IntervDateOut_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  
        WHERE AB_Abstract.ICDType = ''T'' 
      ) DateOut ON dbo.AB_Intervention.AbstractID = DateOut.AbstractID AND dbo.AB_Intervention.IntervOccurrence = DateOut.IntervOccurrence left join
    --Intervention Time Out --PR - 04074 CSR want to add this
      (SELECT    p.AbstractID, v.IntervOccurrence, IntervTimeOut 
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_IntervTimeOut_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  
        WHERE AB_Abstract.ICDType = ''T'' 
      ) TimeOut ON dbo.AB_Intervention.AbstractID = TimeOut.AbstractID AND dbo.AB_Intervention.IntervOccurrence = TimeOut.IntervOccurrence left join
    --Intervention Time In Unknown -- PR - 04332
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS IntervEpisodeStartTimeUnknown, lt.UserDescription AS IntervEpisodeStartTimeUnknownDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_TimeInUnknown_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_CodeFile Lt ON p.IntervTimeInUnknown = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) TimeInUnknown ON dbo.AB_Intervention.AbstractID = TimeInUnknown.AbstractID AND dbo.AB_Intervention.IntervOccurrence = TimeInUnknown.IntervOccurrence Left Join

    --Intervention Time Out Unknown -- PR - 04332
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS IntervEpisodeEndTimeUnknown, lt.UserDescription AS IntervEpisodeEndTimeUnknownDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_TimeOutUnknown_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_CodeFile Lt with (nolock) ON p.IntervTimeOutUnknown = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) TimeOutUnknown ON dbo.AB_Intervention.AbstractID = TimeOutUnknown.AbstractID AND dbo.AB_Intervention.IntervOccurrence = TimeOutUnknown.IntervOccurrence Left Join

    --Intervention Suffix -- PR - 05248
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lt.DisplayCode AS IntervSuffix, lt.UserDescription AS IntervSuffixDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_Suffix_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_IntervSuffix Lt ON p.IntervSuffix = lt.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) Suffix ON dbo.AB_Intervention.AbstractID = Suffix.AbstractID AND dbo.AB_Intervention.IntervOccurrence = Suffix.IntervOccurrence  left join

    --Intervention PreAdmitFlag -- PR - 05413
      (SELECT    p.AbstractID, v.IntervOccurrence, 
                 lp.DisplayCode AS IntervPreAdmitFlag, lp.UserDescription AS IntervPreAdmitFlagDesc
        FROM dbo.AB_Intervention p with (nolock) INNER JOIN
             dbo.AB_Abstract with (nolock) on p.AbstractID = AB_Abstract.AbstractID inner join
             dbo.InterventionEpisode_PreAdmitFlag_VR v on p.AbstractID = v.AbstractID and p.IntervOccurrence = v.IntervOccurrence - v.MinOcc  Left Join
             dbo.LU_codeFile Lp with (nolock) ON p.IntervPreAdmitFlag = lp.Code 
        WHERE AB_Abstract.ICDType = ''T'' 
      ) PreAdmit ON dbo.AB_Intervention.AbstractID = PreAdmit.AbstractID AND dbo.AB_Intervention.IntervOccurrence = PreAdmit.IntervOccurrence  

WHERE (dbo.AB_Abstract.DischargeDate > ''2001/03/31'' or dbo.AB_Abstract.AdmitDate > ''2001/03/31'') and
    (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType IN (1, 2)) AND 
    (ISNULL(dbo.AB_Diagnosis.DiagnosisOccurrence, 1) = 1) AND 
    (ISNULL(dbo.AB_PatientService.ServiceOccurrence, 1) = 1) AND 
    (ISNULL(dbo.AB_Provider.ProviderOccurrence, 1) = 1)
*/    



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractingRecordKey_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE  VIEW [dbo].[I10_AbstractingRecordKey_VR]
AS
SELECT
    dbo.AB_Abstract.AdmitDate AS AdmissionDate, dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
	--PR - 05489
	LU_AdmitTimeUnknown.DisplayCode as AdmissionTimeUnknown, LU_AdmitTimeUnknown.UserDescription as AdmissionTimeUnknownDesc,
	----PR - 06060
	LU_AdmitCategory.DisplayCode AS AdmitCategory, LU_AdmitCategory.UserDescription AS AdmitCategoryDesc, 

	--PR - 07231
	LU_AdmitNurseArea.DisplayCode AS AdmitNurseAreaUnitLoc, LU_AdmitNurseArea.UserDescription AS AdmitNurseAreaUnitLocDesc, 

    dbo.AB_Abstract.ChartNumber, 
	U_Users.DisplayCode AS CoderNumber, U_Users.UserDescription AS CoderNumberDesc, --ED - 02401
    dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.DischargeTime, 
	--PR - 05489
	LU_DischargeTimeUnknown.DisplayCode AS DischargeTimeUnknown, LU_DischargeTimeUnknown.UserDescription AS DischargeTimeUnknownDesc, 
    LU_DispositionCode_I.DisplayCode AS DischargeDisposition, LU_DispositionCode_I.UserDescription AS DischargeDispositionDesc, 

	--PR - 07231
	LU_DischargeNurseArea.DisplayCode AS DischNurseAreaUnitLoc, LU_DischargeNurseArea.UserDescription AS DischNurseAreaUnitLocDesc, 

    dbo.AB_Abstract.EncounterNumber,
    LU_EntryCode.DisplayCode AS EntryCode, LU_EntryCode.UserDescription AS EntryCodeDesc, 
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS FullName,     
    FixedChartNumber,
    dbo.AB_Abstract.HealthCareNumber, 
    H_InstitutionProfile.DisplayCode AS InstitutionNumber, H_InstitutionProfile.UserDescription AS InstitutionNumberDesc, 
    ReAdmitDifferenceDaysForDAD = dbo.CalculateReAdmitDifferenceDaysForDAD(ChartNumber, AdmitDate, AbstractID),
    dbo.AB_Abstract.RegisterNumber,
    dbo.AB_Abstract.AbstractID AS zzAbstractLink,
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID 
FROM         
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.H_InstitutionProfile with (nolock) ON dbo.AB_Abstract.InstitutionNumber = H_InstitutionProfile.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AdmitTimeUnknown with (nolock) on dbo.AB_Abstract.AdmitTimeUnknown = LU_AdmitTimeUnknown.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_DischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LU_DischargeTimeUnknown.Code 
    --ED - 02401
	left join U_Users with (nolock) on AB_Abstract.CoderNumber = U_Users.Code 
	--PR - 06060
	left join dbo.LU_AdmitCategory with (nolock) on dbo.AB_Abstract.AdmitCategory = LU_AdmitCategory.Code 
    left join dbo.LU_EntryCode with (nolock) on dbo.AB_Abstract.EntryCode = LU_EntryCode.Code 
    left join dbo.LU_DispositionCode_I with (nolock) on dbo.AB_Abstract.DispositionCode = LU_DispositionCode_I.Code 
    --PR - 07231
    left join dbo.LU_NurseArea LU_AdmitNurseArea with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurseArea.Code 
    left join dbo.LU_NurseArea LU_DischargeNurseArea with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurseArea.Code 
    left join dbo.H_HospitalProfile with (nolock) on dbo.AB_Abstract.HospitalID = H_HospitalProfile.Code 
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 1)
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AbstractNotes_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[I10_AbstractNotes_VR]
AS
SELECT     
   RecordID AS zzAbstractLink,
   LogNote  as AbstractNotes,
   LogDate  as DateLogged,
   LogTime  as TimeLogged,
   U.DisplayCode as CreateBy,
   U.UserDescription as CreatorName        
from dbo.REC_Notes r with (nolock) left join U_users U with (nolock) on r.LogCoder=u.code
where AppID in ( 200, 201, 202, 401 )


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AllAbstractingGeneral1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[I10_AllAbstractingGeneral1_VR]
AS
SELECT
    dbo.AB_Abstract.AdmitDate AS AdmissionDate, dbo.AB_Abstract.AdmitTime AS AdmissionTime, 
	--PR - 05489
	LU_AdmitTimeUnknown.DisplayCode as AdmissionTimeUnknown, LU_AdmitTimeUnknown.UserDescription as AdmissionTimeUnknownDesc,
    Lookup4.DisplayCode AS AdmitCategory, Lookup4.UserDescription AS AdmitCategoryDesc, 
    LU_AdmitNurse.DisplayCode as AdmitNurseArea, LU_AdmitNurse.UserDescription as AdmitNurseAreaDesc,
    Lookup6.DisplayCode AS AgeCode, 
    Lookup6.UserDescription AS AgeCodeDesc, dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, dbo.AB_Abstract.BatchNumber, 
    Lookup50.DisplayCode AS BatchPeriod, Lookup50.UserDescription AS BatchPeriodDesc, dbo.AB_Abstract.BatchYear, dbo.AB_Abstract.BirthDate, 
    dbo.LU_CareType.DisplayCode AS CareType, dbo.LU_CareType.UserDescription AS CareTypeDesc, dbo.AB_Abstract.ChartNumber, 
    Lookup54.DisplayCode AS CoderNumber, Lookup54.UserDescription AS CoderNumberDesc, Lookup60.DisplayCode AS DataEntryCoder, 
    Lookup60.UserDescription AS DataEntryCoderDesc, dbo.AB_Abstract.CIHIDateSent AS DateSenttoCIHI, 
    LU_DischargeNurse.DisplayCode as DischNurseArea, LU_DischargeNurse.UserDescription as DischNurseAreaDesc,
    dbo.AB_Abstract.DischargeDate, 
    --ED - 02929
    (case when caretype = 5 then LU_DispositionCode_A.DisplayCode else LU_DispositionCode_I.DisplayCode end) AS DischargeDisposition, 
    (case when caretype = 5 then LU_DispositionCode_A.UserDescription else LU_DispositionCode_I.UserDescription end) AS DischargeDispositionDesc, 

    dbo.AB_Abstract.DischargeTime, 
	--PR - 05489
	LU_DischargeTimeUnknown.DisplayCode AS DischargeTimeUnknown, LU_DischargeTimeUnknown.UserDescription AS DischargeTimeUnknownDesc, 
    dbo.AB_Abstract.EncounterNumber, 
    Lookup69.DisplayCode AS EntryCode, Lookup69.UserDescription AS EntryCodeDesc,
    dbo.AB_Abstract.FinishDate, dbo.AB_Abstract.FinishTime, 
    dbo.AB_Abstract.FirstName, Lookup72.DisplayCode AS Gender, Lookup72.UserDescription AS GenderDesc, Lookup75.DisplayCode AS HCNProvince, 
    Lookup75.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
    LU_Hospital.DisplayCode AS Hospital, LU_Hospital.UserDescription AS HospitalDesc, dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
    
	Lookup77.DisplayCode AS InstitutionFrom, Lookup77.UserDescription AS InstitutionFromDesc, 
	LU_InstitutionFrom_Type.DisplayCode AS InstitutionFromType, LU_InstitutionFrom_Type.UserDescription AS InstitutionFromTypeDesc, 
	Lookup78.DisplayCode AS InstitutionTo,     Lookup78.UserDescription AS InstitutionToDesc, 
	LU_InstitutionTo_Type.DisplayCode AS InstitutionToType, LU_InstitutionTo_Type.UserDescription AS InstitutionToTypeDesc, 
	
	Lookup79.DisplayCode AS InterfaceCoder, Lookup79.UserDescription AS InterfaceCoderDesc, 
    
    dbo.AB_Abstract.InterfaceDate, dbo.AB_Abstract.InterfaceTime, 
    
    Lookup80.DisplayCode AS IsAbstractCompleted,                  Lookup80.UserDescription AS IsAbstractCompletedDesc, 
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel1, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel1Desc, 
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel2, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel2Desc, 
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLite,   LU_Level1_Completed.UserDescription AS IsAbstractCompletedLiteDesc, 

    Lookup81.DisplayCode AS IsAbstractCorrected,                   Lookup81.UserDescription AS IsAbstractCorrectedDesc, 
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel1, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel1Desc, 
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel2, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel2Desc, 
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLite,   LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLiteDesc, 

    Lookup82.DisplayCode AS IsAbstractDeleted,       Lookup82.UserDescription AS IsAbstractDeletedDesc, 

    Lookup83.DisplayCode AS IsAbstractSubmited,                    Lookup83.UserDescription AS IsAbstractSubmitedDesc, 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel1, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel1Desc, 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel2, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel2Desc, 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLite,   LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLiteDesc, 

    Lookup84.DisplayCode AS IsAbstractValidated,                   Lookup84.UserDescription AS IsAbstractValidatedDesc, 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel1, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel1Desc, 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel2, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel2Desc, 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLite,   LU_Level1_Validation.UserDescription AS IsAbstractValidatedLiteDesc, 
    
    
    Lookup85.DisplayCode AS IsBirthdateEstimated, 
    Lookup85.UserDescription AS IsBirthdateEstimatedDesc, 
	LU_CustomStatus.DisplayCode AS IsCustomValidated, LU_CustomStatus.UserDescription AS IsCustomValidatedDesc, 
	dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSMinutes, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LastName, dbo.AB_Abstract.MaidenName, Lookup88.DisplayCode AS MaritalStatus, 
    Lookup88.UserDescription AS MaritalStatusDesc, dbo.AB_Abstract.NewbornChart AS MaternalNewbornChartNumber, 
    dbo.AB_Abstract.NewbornDischargeDate AS MaternalNewbornDischargeDate, dbo.AB_Abstract.MiddleName, 
    dbo.LU_MISCode.DisplayCode AS MISCode, dbo.LU_MISCode.UserDescription AS MISCodeDesc, ISNULL(dbo.AB_Abstract.LastName, '' '') 
    + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS NameFull, 
    dbo.AB_Manitoba.HCNExpiredDate  as OutProvinceHealthInsuranceExpiryDate,
    dbo.AB_Abstract.PostalCode, 
    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), isnull(dbo.AB_Abstract.DischargeDate, dbo.AB_Abstract.AdmitDate)) AS PostalDescription, -- ED - 01682

    dbo.AB_Abstract.RegisterNumber, Lookup111.DisplayCode AS ReportingProvInstNumber, 
    Lookup111.UserDescription AS ReportingProvInstNumberDesc, Lookup112.DisplayCode AS ResidenceCode, 
    Lookup112.UserDescription AS ResidenceCodeDesc, Lookup114.DisplayCode AS ResponsiblityForPayment, 
    Lookup114.UserDescription AS ResponsiblityForPaymentDesc, 
    --PR - 03606
    dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup116.DisplayCode AS SecretVIPPatient, 
    Lookup116.UserDescription AS SecretVIPPatientDesc, Lookup117.DisplayCode AS SiteNumber, Lookup117.UserDescription AS SiteNumberDesc, 
    dbo.AB_Abstract.RecordType AS SubmissionType, dbo.AB_Abstract.UniqiueLifetimeID AS ULI, dbo.AB_Abstract.Weight AS Weightingrams, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM        
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.LU_MISCode with (nolock) on dbo.AB_Abstract.MISCode = dbo.LU_MISCode.Code LEFT OUTER JOIN
    dbo.LU_CareType with (nolock) on dbo.AB_Abstract.CareType = dbo.LU_CareType.Code LEFT OUTER JOIN
    dbo.LU_AdmitCategory Lookup4 with (nolock) on dbo.AB_Abstract.AdmitCategory = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup6 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup50 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup54 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup54.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup55 with (nolock) on dbo.AB_Abstract.Complication = Lookup55.Code LEFT OUTER JOIN
    dbo.U_Users Lookup60 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup72 with (nolock) on dbo.AB_Abstract.Gender = Lookup72.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup75 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup75.Code LEFT OUTER JOIN

    dbo.LU_Institution_10 Lookup77 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup77.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionFrom_Type with (nolock) on dbo.AB_Abstract.InstitutionFromType = LU_InstitutionFrom_Type.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup78 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup78.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionTo_Type with (nolock) on dbo.AB_Abstract.InstitutionToType = LU_InstitutionTo_Type.Code LEFT OUTER JOIN

    dbo.U_Users Lookup79 with (nolock) on dbo.AB_Abstract.InterfaceCoder = Lookup79.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup80 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup80.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup81 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup81.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup82 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup82.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup83 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup84 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_CustomStatus with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_CustomStatus.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup85 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_MaritalStatus Lookup88 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup88.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup111 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup111.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup112 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup114 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup114.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup116 with (nolock) on dbo.AB_Abstract.Secret = Lookup116.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup117 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup117.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_AdmitNurse with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurse.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_DischargeNurse with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurse.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_AdmitTimeUnknown with (nolock) on dbo.AB_Abstract.AdmitTimeUnknown = LU_AdmitTimeUnknown.Code 
    LEFT OUTER JOIN dbo.LU_CodeFile LU_DischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LU_DischargeTimeUnknown.Code 
    --ED - 02929
    LEFT OUTER JOIN dbo.LU_DispositionCode_I with (nolock) on LU_DispositionCode_I.Code = dbo.AB_Abstract.DispositionCode 
    LEFT OUTER JOIN dbo.LU_DispositionCode_A with (nolock) on LU_DispositionCode_A.Code = dbo.AB_Abstract.DispositionCode 
    Left OUTER JOIN dbo.AB_Manitoba with (nolock) on dbo.AB_Manitoba.AbstractID = dbo.AB_Abstract.AbstractID
    LEFT OUTER JOIN dbo.LU_CIHICorrect LU_Level1_Correction with (nolock) on dbo.AB_Abstract.IsCorrectLevel1 = LU_Level1_Correction.Code 
    LEFT OUTER JOIN dbo.LU_YesNoSystem LU_Level1_Submission with (nolock) on dbo.AB_Abstract.IsSubmitLevel1 = LU_Level1_Submission.Code 
    LEFT OUTER JOIN dbo.LU_AbstractStatus LU_Level1_Validation with (nolock) on dbo.AB_Abstract.IsValidLevel1 = LU_Level1_Validation.Code 
    LEFT OUTER JOIN dbo.LU_AbstractStatus LU_Level1_Completed with (nolock) on dbo.AB_Abstract.IsCompleteLevel1 = LU_Level1_Completed.Code 
    LEFT OUTER JOIN dbo.LU_EntryCode Lookup69 with (nolock) on dbo.AB_Abstract.EntryCode = Lookup69.Code 
WHERE     (dbo.AB_Abstract.ICDType = ''T'')
--QA - 00032 disable the domain securite issue
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0)))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmCare_CACS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[I10_AmCare_CACS_VR]
AS
SELECT     dbo.AB_CACS.OccurrenceNumber, 
	dbo.AB_CACS.BatchGroupDate,
	dbo.AB_CACS.CACS_Year AS CACSYear, dbo.AB_CACS.MAC, 
        (case when dbo.AB_CACS.CACS_Year < 2011
              then
                  (CASE (case when isnumeric(dbo.AB_CACS.MAC) = 0 then 0 else cast(dbo.AB_CACS.MAC as int) end)
                        WHEN 1 THEN ''Diseases and Disorders of the Nervous System'' 
                        WHEN 2 THEN ''Diseases and Disorders of the Eye'' 
                        WHEN 3 THEN ''Diseases and Disorders of the Ear, Nose, Mouth and Throat'' 
                        WHEN 4 THEN ''Diseases and Disorders of the Respiratory System'' 
                        WHEN 5 THEN ''Diseases and Disorders of the Circulatory System'' 
                        WHEN 6 THEN ''Diseases and Disorders of the Digestive System'' 
                        WHEN 7 THEN ''Diseases and Disorders of the Hepatobiliary System and Pancreas''
                        WHEN 8 THEN ''Diseases and Disorders of the Musculoskeletal System and Connective Tissue'' 
                        WHEN 9 THEN ''Diseases and Disorders of the Skin and Subcutaneous Tissue and Breast''
                        WHEN 10 THEN ''Endocrine, Nutritional, and Metabolic Diseases and Disorders'' 
                        WHEN 11 THEN ''Diseases and Disorders of Kidney and Genitourinary Tract''
                        WHEN 14 THEN ''Pregnancy, Childbirth, Newborns and Neonates'' 
                        WHEN 16 THEN ''Haematology Including Lymphoma, Leukaemia and Unspecified Site Neoplasms''
                        WHEN 17 THEN ''Oncological Diseases and Disorders'' 
                        WHEN 18 THEN ''Systemic Infections Including HIV'' 
                        WHEN 19 THEN ''Mental Diseases and Disorders''
                        WHEN 20 THEN ''Examination and Other Health Factors'' 
                        WHEN 21 THEN ''Trauma, Coma and Toxic Effects'' 
                        WHEN 99 THEN ''Ungroupable'' ELSE '''' END)
              else 
                (select top 1 mac_long_e_desc from dbo.tGrouper_CACS_MAC where tGrouper_CACS_MAC.methodology_year = dbo.AB_CACS.CACS_Year and dbo.AB_CACS.MAC = tGrouper_CACS_MAC.mac_code)
              end) AS MACDescription, 
        dbo.AB_CACS.CACSCell, dbo.AB_CACS.ACW, dbo.AB_CACS.CACSDescription, 
        dbo.ICD_ProcFile10.DisplayCode AS InterventionCode, dbo.ICD_ProcFile10.UserDescription AS IntervCodeDescription, 
        dbo.ICD_ProcFile10.ShortDescription AS InterventionCodeShortDesc, 
        dbo.AB_CACS.AgeCategory, dbo.tGrouper_CACS_Age_Category.cacs_age_category_e_desc as AgeCategoryDesc,
        dbo.AB_CACS.AnaestheticCategory, dbo.tGrouper_CACS_Aanaesthetic.cacs_anaesthetic_e_desc as AnaestheticCategoryDesc,
        dbo.AB_CACS.MITTotalCount AS InvestigativeTechnologyTotalCount,
        ACW_HBAM as CACSHBAM,
        ACW_Base as CACSBaseRIW,
        CACSPartition, 
        MIT_Category_01 as InvestigativeTechnologyCategory_01, MIT_Category_Count_01 as InvestigativeTechnologyCategoryCount_01, 
        MIT_Category_02 as InvestigativeTechnologyCategory_02, MIT_Category_Count_02 as InvestigativeTechnologyCategoryCount_02, 
        MIT_Category_03 as InvestigativeTechnologyCategory_03, MIT_Category_Count_03 as InvestigativeTechnologyCategoryCount_03, 
        MIT_Category_04 as InvestigativeTechnologyCategory_04, MIT_Category_Count_04 as InvestigativeTechnologyCategoryCount_04, 
        MIT_Category_05 as InvestigativeTechnologyCategory_05, MIT_Category_Count_05 as InvestigativeTechnologyCategoryCount_05, 
        MIT_Category_06 as InvestigativeTechnologyCategory_06, MIT_Category_Count_06 as InvestigativeTechnologyCategoryCount_06, 
        MIT_Category_07 as InvestigativeTechnologyCategory_07, MIT_Category_Count_07 as InvestigativeTechnologyCategoryCount_07, 
        MIT_Category_08 as InvestigativeTechnologyCategory_08, MIT_Category_Count_08 as InvestigativeTechnologyCategoryCount_08, 
        MIT_Category_09 as InvestigativeTechnologyCategory_09, MIT_Category_Count_09 as InvestigativeTechnologyCategoryCount_09, 
        MIT_Category_10 as InvestigativeTechnologyCategory_10, MIT_Category_Count_10 as InvestigativeTechnologyCategoryCount_10,
		dbo.AB_Abstract.AbstractID AS zzAbstractLink
FROM         dbo.AB_CACS with (nolock) RIGHT OUTER JOIN
                      dbo.AB_Abstract with (nolock) ON dbo.AB_CACS.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.ICD_ProcFile10 with (nolock) ON dbo.AB_CACS.InterventionCode = dbo.ICD_ProcFile10.Code LEFT OUTER JOIN
		dbo.tGrouper_CACS_Age_Category with (nolock) ON dbo.AB_CACS.AgeCategory = dbo.tGrouper_CACS_Age_Category.cacs_age_category_code
						and dbo.AB_CACS.CACS_Year = dbo.tGrouper_CACS_Age_Category.methodology_year LEFT OUTER JOIN
		dbo.tGrouper_CACS_Aanaesthetic with (nolock) ON dbo.AB_CACS.AnaestheticCategory = dbo.tGrouper_CACS_Aanaesthetic.cacs_anaesthetic_code
						and dbo.AB_CACS.CACS_Year = dbo.tGrouper_CACS_Aanaesthetic.methodology_year LEFT OUTER JOIN
        dbo.AB_CACS_Investigative with (nolock) ON 	AB_CACS.AbstractID = AB_CACS_Investigative.AbstractID
						and AB_CACS.OccurrenceNumber = AB_CACS_Investigative.OccurrenceNumber 
						and AB_CACS.CACS_Year = AB_CACS_Investigative.CACS_Year
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_CACS.OccurrenceNumber = 1)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmCare_CCM_SystemicDrug_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE view [dbo].[I10_AmCare_CCM_SystemicDrug_VR]
AS  
select
    BodySurfaceArea = dbo.AB_CCM_SystemicDrug.BodySurfaceArea,
    CCODrugCode = dbo.AB_CCM_SystemicDrug.CCODrugCode, 
    CCORegimen = LU_CCORegimen.DisplayCode, CCORegimenDesc = LU_CCORegimen.UserDescription,
    CMIRSeverity = LU_CMIRSeverity.DisplayCode, CMIRSeverityDesc = LU_CMIRSeverity.UserDescription,
    DIN = dbo.AB_CCM_SystemicDrug.CCMDIN,
    DoseAdministered = dbo.AB_CCM_SystemicDrug.DoseAdministered,
    DrugOriginFlag = LU_DrugOriginFlag.DisplayCode, DrugOriginFlagDesc = LU_DrugOriginFlag.UserDescription,
    IntentOfSystemicTreatment = LU_IntentOfSystemicTreatment.DisplayCode, IntentOfSystemicTreatmentDesc = LU_IntentOfSystemicTreatment.UserDescription,
    LineOfTherapy = dbo.AB_CCM_SystemicDrug.LineOfTherapy,
    MeasurementUnit = LU_MeasurementUnit.DisplayCode, MeasurementUnitDesc = LU_MeasurementUnit.UserDescription,
    Route = LU_Route.DisplayCode, RouteDesc = LU_Route.UserDescription,

    dbo.AB_CCM_SystemicDrug.Occurrence as DrugOccurrence,
    dbo.AB_CCM_SystemicDrug.AbstractID as zzNACRSLink
from dbo.AB_CCM_SystemicDrug with (nolock) left join
    dbo.LU_CodeFile LU_CCORegimen with (nolock) on dbo.AB_CCM_SystemicDrug.CCORegimen = LU_CCORegimen.Code left join
    dbo.LU_YesNoAlpha LU_DrugOriginFlag with (nolock) on dbo.AB_CCM_SystemicDrug.DrugOriginFlag = LU_DrugOriginFlag.Code left join
    dbo.LU_CodeFile LU_MeasurementUnit with (nolock) on dbo.AB_CCM_SystemicDrug.MeasurementUnit = LU_MeasurementUnit.Code left join
    dbo.LU_CodeFile LU_Route with (nolock) on dbo.AB_CCM_SystemicDrug.[Route] = LU_Route.Code left join
    dbo.LU_CodeFile LU_IntentOfSystemicTreatment with (nolock) on dbo.AB_CCM_SystemicDrug.IntentOfSystemicTreatment = LU_IntentOfSystemicTreatment.Code left join
    dbo.LU_CodeFile LU_CMIRSeverity with (nolock) on dbo.AB_CCM_SystemicDrug.CMIRSeverity = LU_CMIRSeverity.Code 



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmCare_CCM_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[I10_AmCare_CCM_VR]
AS
SELECT     
    ArrivedByNotTreatedFlag = LU_ArrivedByNotTreatedFlag.DisplayCode, ArrivedByNotTreatedFlagDesc = LU_ArrivedByNotTreatedFlag.UserDescription,
    BodyRegionCode = LU_CCM_BodyRegion.DisplayCode, BodyRegionCodeDesc = LU_CCM_BodyRegion.UserDescription,
    CCM_DiseaseSequenceNumber = dbo.CC_DiseaseRegister.DiseaseSequenceNum,
    CCM_Hospital_Number = right(H_InstitutionProfile_submit.CIHIValue, 4), CCM_Hospital_NumberDesc = H_InstitutionProfile_submit.UserDescription,
    CCM_RegistrationDate = dbo.CC_DiseaseRegister.RegisterDate,
    dbo.CC_Demographic.ChartNumber, 
    ChemoFlag = LU_ChemoFlag.DisplayCode, ChemoFlagDesc = LU_ChemoFlag.UserDescription,
    ClinicalTrialFlag = LU_ClinicalTrialFlag.DisplayCode, ClinicalTrialFlagDesc = LU_ClinicalTrialFlag.UserDescription,
    CourseOfRadiationTreatment = dbo.AB_CCM_Radiation.CourseOfRadiationTreatment,
    CourseCompleteFlag = LU_CourseCompleteFlag.DisplayCode, CourseCompleteFlagDesc = LU_CourseCompleteFlag.UserDescription,
    DecisionToTreatDate = dbo.AB_CCM_Radiation.DecisionToTreatDate,
    DosePerFraction = dbo.AB_CCM_Radiation.DosePerFraction, 
    HealthCareProviderNumber = LU_Provider.DisplayCode, HealthCareProviderNumberDesc = LU_Provider.UserDescription, 
    InpatientFlag = LU_InpatientFlag.DisplayCode, InpatientFlagDesc = LU_InpatientFlag.UserDescription,
    InstitutionNumber = H_InstitutionProfile_visit.DisplayCode, InstitutionNumberDesc = H_InstitutionProfile_visit.UserDescription,
    IntentOfRadiationTreatment = LU_IntentOfRadiationTreatment.DisplayCode, IntentOfRadiationTreatmentDesc = LU_IntentOfRadiationTreatment.UserDescription,
    MISFunctionalCentre = LU_MISCode.DisplayCode, MISFunctionalCentreDesc = LU_MISCode.UserDescription,
    NHPIPCode = LU_CCM_NHPIP_Code.DisplayCode, NHPIPCodeDesc = LU_CCM_NHPIP_Code.UserDescription,
    AB_Abstract.PostalCode,
    ReadyToTreatDate = dbo.AB_CCM_Radiation.ReadyToTreatDate, 
    RadiationRreviewFlag = LU_RadiationReviewFlag.DisplayCode, RadiationRreviewFlagDesc = LU_RadiationReviewFlag.UserDescription, 
    RegistrationVisitDate = AB_Abstract.AdmitDate, RegistrationVisitTime = AB_Abstract.AdmitTime,
    ResidenceCode = LU_ResidenceCode.DisplayCode, ResidenceCodeDesc = LU_ResidenceCode.UserDescription,
    AB_CCM_Radiation.RTProtocol,
    TreatmentUnitName = dbo.AB_CCM_Radiation.TreatmentUnitName,
    UrgencyCategory = LU_UrgencyCategory.DisplayCode, UrgencyCategoryDesc = LU_UrgencyCategory.UserDescription,
    VisitProgramCode = LU_VisitProgramCode.DisplayCode, VisitProgramCodeDesc = LU_VisitProgramCode.UserDescription,
    VisitType = LU_CCMVisitType.DisplayCode, VisitTypeDesc = LU_CCMVisitType.UserDescription, 

    dbo.AB_CCM_CancerCareInformation.AbstractID as zzNACRSLink,
    dbo.CC_Demographic.AbstractID as zzCCMDiseaseLink
FROM
    dbo.AB_Abstract with (nolock) inner join 
    dbo.H_InstitutionProfile H_InstitutionProfile_visit with (nolock) on H_InstitutionProfile_visit.Code = dbo.AB_Abstract.InstitutionNumber inner JOIN
    dbo.AB_CCM_CancerCareInformation with (nolock) on dbo.AB_ABstract.AbstractId = dbo.AB_CCM_CancerCareInformation.AbstractID inner join
    AB_Main with (nolock) on dbo.AB_CCM_CancerCareInformation.CancerCareVisit = AB_Main.UniversalID inner join
    dbo.CC_Demographic with (nolock) on AB_Main.AbstractID = dbo.CC_Demographic.AbstractID inner join 
    dbo.CC_DiseaseRegister with (nolock) on dbo.CC_Demographic.AbstractID = dbo.CC_DiseaseRegister.AbstractID LEFT OUTER JOIN
    dbo.H_InstitutionProfile H_InstitutionProfile_submit with (nolock) on H_InstitutionProfile_submit.Code = dbo.CC_Demographic.InstitutionNumber LEFT OUTER JOIN
    dbo.AB_CCM_Radiation with (nolock) on dbo.AB_CCM_CancerCareInformation.AbstractID = dbo.AB_CCM_Radiation.AbstractID left join

    dbo.LU_MISCode with (nolock) on dbo.AB_ABstract.MISCode = lu_MISCode.Code left join
    dbo.LU_ResidenceCode with (nolock) on dbo.AB_ABstract.ResidenceCode = LU_ResidenceCode.Code left join
    dbo.LU_CodeFile LU_VisitProgramCode with (nolock) on dbo.AB_CCM_CancerCareInformation.VisitProgramCode = LU_VisitProgramCode.Code left join
    dbo.LU_CodeFile LU_CCMVisitType with (nolock) on dbo.AB_CCM_CancerCareInformation.CCMVisitType = LU_CCMVisitType.Code left join
    dbo.LU_YesNoAlpha LU_InpatientFlag with (nolock) on dbo.AB_CCM_CancerCareInformation.InpatientFlag = LU_InpatientFlag.Code Left join
    dbo.LU_CodeFile LU_RadiationReviewFlag with (nolock) on dbo.AB_CCM_CancerCareInformation.RadiationReviewFlag = LU_RadiationReviewFlag.Code Left join
    dbo.LU_Provider with (nolock) on dbo.AB_CCM_CancerCareInformation.HealthCareProviderNumber = LU_Provider.Code left join
    dbo.LU_YesNoAlpha LU_ArrivedByNotTreatedFlag with (nolock) on dbo.AB_CCM_CancerCareInformation.ArrivedByNotTreatedFlag = LU_ArrivedByNotTreatedFlag.Code left join

    dbo.LU_YesNoAlpha LU_ChemoFlag with (nolock) on dbo.AB_CCM_CancerCareInformation.ChemoFlag = LU_ChemoFlag.Code Left join
    dbo.LU_YesNoAlpha LU_ClinicalTrialFlag with (nolock) on dbo.AB_CCM_CancerCareInformation.ClinicalTrialFlag = LU_ClinicalTrialFlag.Code Left join

    dbo.LU_YesNoAlpha LU_CourseCompleteFlag with (nolock) on dbo.AB_CCM_Radiation.CourseCompleteFlag = LU_CourseCompleteFlag.Code left join
    dbo.LU_CCM_NHPIP_Code with (nolock) on dbo.AB_CCM_Radiation.NHPIPCode = LU_CCM_NHPIP_Code.Code left join
    dbo.LU_CCM_BodyRegion with (nolock) on dbo.AB_CCM_Radiation.BodyRegionCode = LU_CCM_BodyRegion.code left join
    dbo.LU_CodeFile LU_IntentOfRadiationTreatment with (nolock) on dbo.AB_CCM_Radiation.IntentOfRadiationTreatment = LU_IntentOfRadiationTreatment.Code left join
    dbo.LU_CodeFile LU_UrgencyCategory with (nolock) on dbo.AB_CCM_Radiation.UrgencyCategory = LU_UrgencyCategory.Code 





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Consult_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[I10_Amcare_Consult_VR]
AS
SELECT
    ConsultOccurrence = Occurrence,
    ConsultArrivalDate, ConsultArrivalTime,
    ConsultArrivalTimeUnknown = LU_ConsultArrivalTimeUnknown.DisplayCode, ConsultArrivalTimeUnknownDesc = LU_ConsultArrivalTimeUnknown.UserDescription,
    ConsultNumber = LU_Provider.DisplayCode, ConsultNumberDesc = LU_Provider.UserDescription, 
    ConsultRequestDate, ConsultRequestTime,
    ConsultRequestTimeUnknown = LU_ConsultRequestTimeUnknown.DisplayCode, ConsultRequestTimeUnknownDesc = LU_ConsultRequestTimeUnknown.UserDescription,
    ConsultService = LU_ProviderSpecialty.DisplayCode, ConsultServiceDesc = LU_ProviderSpecialty.UserDescription, 
    dbo.AB_Consult.AbstractID AS zzAbstractLink
FROM dbo.AB_Consult with (nolock)     
    left join dbo.LU_Provider with (nolock) on dbo.AB_Consult.ConsultNumber = LU_Provider.Code
    left join dbo.LU_ProviderSpecialty with (nolock) on dbo.AB_Consult.ConsultService = LU_ProviderSpecialty.Code
    left join dbo.LU_CodeFile LU_ConsultRequestTimeUnknown with (nolock) on dbo.AB_Consult.ConsultRequestTimeUnknown = LU_ConsultRequestTimeUnknown.Code
    left join dbo.LU_CodeFile LU_ConsultArrivalTimeUnknown with (nolock) on dbo.AB_Consult.ConsultArrivalTimeUnknown = LU_ConsultArrivalTimeUnknown.Code
    
    




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[I10_Amcare_Diagnosis_VR]
AS
SELECT  
    dbo.AB_Diagnosis.DiagnosisCluster,
    dbo.ICD_DiagFile10.CIHIValue AS DiagnosisCIHIValue, dbo.ICD_DiagFile10.DisplayCode AS DiagnosisCode, 
    dbo.ICD_DiagFile10.UserDescription AS DiagnosisCodeDesc, dbo.ICD_DiagFile10.ShortDescription AS DiagnosisCodeShortDesc, 
    dbo.ICD_DiagFile10.ICD9 AS DiagnosisICD9Equivalent, dbo.ICD_DiagFile10.ICD9cm AS DiagnosisICD9cmEquivalent, 
    dbo.AB_Diagnosis.DiagnosisOccurrence, Lookup55.DisplayCode AS DiagnosisPrefix, Lookup55.UserDescription AS DiagnosisPrefixDesc, 
    Lookup56.DisplayCode AS DiagnosisSuffix, Lookup56.UserDescription AS DiagnosisSuffixDesc, Lookup57.DisplayCode AS DiagnosisType, 
    Lookup57.UserDescription AS DiagnosisTypeDesc, dbo.AB_Diagnosis.AbstractID AS zzAbstractLink
FROM         dbo.AB_Diagnosis with (nolock) LEFT OUTER JOIN
                      dbo.ICD_DiagFile10 with (nolock) on dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile10.Code RIGHT OUTER JOIN
                      dbo.AB_Abstract with (nolock) on dbo.AB_Diagnosis.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.LU_DiagnosisPrefix Lookup55 with (nolock) on dbo.AB_Diagnosis.DiagnosisPrefix = Lookup55.Code LEFT OUTER JOIN
                      dbo.LU_DiagnosisSuffix Lookup56 with (nolock) on dbo.AB_Diagnosis.DiagnosisSuffix = Lookup56.Code LEFT OUTER JOIN
                      dbo.LU_DiagnosisType Lookup57 with (nolock) on dbo.AB_Diagnosis.DiagnosisType = Lookup57.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_Diagnosis.DiagnosisOccurrence IS NOT NULL)




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_DischargeDiagnosis]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[I10_Amcare_DischargeDiagnosis]
as
select
	AbstractID as zzAbstractLink,
	Occurrence as DischargeDiagnosisOccurrence,
	LU_DischargeDiagnosis.DisplayCode as DischargeDiagnosis,
	LU_DischargeDiagnosis.UserDescription as DischargeDiagnosisDesc
from dbo.AB_DischargeDiagnosis with (nolock)
	left join ICD_DiagFile10 LU_DischargeDiagnosis with (nolock) on DischargeDiagnosis = LU_DischargeDiagnosis.Code


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_EDInterventionPicklist_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE view [dbo].[I10_Amcare_EDInterventionPicklist_VR]
as
select
	LU_EDIntervnetionPickList.DisplayCode as EDIntervnetionPickList, LU_EDIntervnetionPickList.UserDescription as EDIntervnetionPickListDesc, 
	[Occurrence] as EDIntervnetionPickListOccurrence,
	[AbstractID] as zzAbstractLink
from [dbo].[AB_EDInterventionPicklist]
	left join LU_EDIntervnetionPickList on [AB_EDInterventionPicklist].[EDInterventionPickList] = LU_EDIntervnetionPickList.Code
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_EDInvestigativeTechnology_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[I10_Amcare_EDInvestigativeTechnology_VR]
as
select
	LU_EDInvestigativeTechnology.DisplayCode as EDInvestigativeTechnology, LU_EDInvestigativeTechnology.UserDescription as EDInvestigativeTechnologyDesc, 
	[Occurrence] as EDInvestigativeTechnologyOccurrence,
	[NumberInvestigativeTechnologyPerformed] as [NumberEDInvestigativeTechnologyPerformed],
	[AbstractID] as zzAbstractLink
from [dbo].[AB_InvestigativeTechnology]
	left join LU_EDInvestigativeTechnology on [AB_InvestigativeTechnology].[InvestigativeTechnology] = LU_EDInvestigativeTechnology.Code
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_InterventionReplication_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[I10_Amcare_InterventionReplication_VR]
AS
SELECT     ISNULL(Lookup20.DisplayCode, OCC.AnestheticTechnique) AS AnestheticTechnique, ISNULL(Lookup20.UserDescription, 
                      OCC.AnestheticTechniqueDesc) AS AnestheticTechniqueDesc, ISNULL(Lookup21.DisplayCode, OCC.AnesthetistID) AS AnesthetistID, 
                      ISNULL(Lookup21.UserDescription, OCC.AnesthetistIDDesc) AS AnesthetistIDDesc, ISNULL(Lookup62.DisplayCode, OCC.EUL) AS EUL, 
                      ISNULL(Lookup62.UserDescription, OCC.EULDesc) AS EULDesc, ISNULL(Lookup66.DisplayCode, OCC.Extra) AS Extra, 
                      ISNULL(Lookup66.UserDescription, OCC.ExtraDesc) AS ExtraDesc, dbo.ICD_ProcFile10.CIHIValue AS InterventionCIHIValue, 
                      dbo.ICD_ProcFile10.DisplayCode AS InterventionCode, dbo.ICD_ProcFile10.UserDescription AS InterventionCodeDesc, 
                      dbo.ICD_ProcFile10.ShortDescription AS InterventionCodeShortDesc, ISNULL(dbo.AB_Intervention.IntervDateIn, OCC.IntervDateIn) AS IntervDateIn, 
                      ISNULL(dbo.AB_Intervention.IntervDateOut, OCC.IntervDateOut) AS IntervDateOut, Lookup77.DisplayCode AS InterventionAttributeExtent, 
                      Lookup77.UserDescription AS IntervAttribExtentDesc, Lookup78.DisplayCode AS InterventionAttributeLocation, 
                      Lookup78.UserDescription AS IntervAttribLocationDesc, Lookup79.DisplayCode AS InterventionAttributeStatus, 
                      Lookup79.UserDescription AS IntervAttribStatusDesc, ISNULL(dbo.AB_Intervention.IntervDate, OCC.InterventionDate) AS InterventionDate, 
                      ISNULL(Lookup80.DisplayCode, OCC.InterventionLocation) AS InterventionLocation, ISNULL(Lookup80.UserDescription, OCC.InterventionLocationDesc) 
                      AS InterventionLocationDesc, dbo.AB_Intervention.IntervOccurrence AS InterventionOccurrence, ISNULL(Lookup81.DisplayCode, 
                      OCC.InterventionProviderNumber) AS InterventionProviderNumber, ISNULL(Lookup81.UserDescription, OCC.InterventionProviderNumberDesc) 
                      AS InterventionProviderNumberDesc, ISNULL(Lookup82.DisplayCode, OCC.InterventionProviderSpecialty) AS InterventionProviderSpecialty, 
                      ISNULL(Lookup82.UserDescription, OCC.InterventionProviderSpecialtyDesc) AS IntervProviderSpecialtyDesc, ISNULL(Lookup83.DisplayCode, 
                      OCC.InterventionSuffix) AS InterventionSuffix, ISNULL(Lookup83.UserDescription, OCC.InterventionSuffixDesc) AS InterventionSuffixDesc, 
                      ISNULL(dbo.AB_Intervention.IntervTimeIn, OCC.InterventionTimeIn) AS InterventionTimeIn, ISNULL(dbo.AB_Intervention.IntervTimeMinutes, 
                      OCC.InterventionTimeinMinutes) AS InterventionTimeinMinutes, ISNULL(dbo.AB_Intervention.IntervTimeOut, OCC.InterventionTimeOut) 
                      AS InterventionTimeOut, ISNULL(Lookup97.DisplayCode, OCC.OOHIndicator) AS OOHIndicator, ISNULL(Lookup97.UserDescription, 
                      OCC.OOHIndicatorDesc) AS OOHIndicatorDesc, ISNULL(Lookup98.DisplayCode, OCC.OOHInstitutionNumber) AS OOHInstitutionNumber, 
                      ISNULL(Lookup98.UserDescription, OCC.OOHInstitutionNumberDesc) AS OOHInstitutionNumberDesc, ISNULL(Lookup149.DisplayCode, 
                      OCC.TissueCode) AS TissueCode, ISNULL(Lookup149.UserDescription, OCC.TissueCodeDesc) AS TissueCodeDesc, ISNULL(Lookup154.DisplayCode, 
                      OCC.UnplannedReturntoOR) AS UnplannedReturntoOR, ISNULL(Lookup154.UserDescription, OCC.UnplannedReturntoORDesc) 
                      AS UnplannedReturntoORDesc, dbo.ICD_ProcFile10.ICD9 AS ICD9Equivalent, dbo.ICD_ProcFile10.ICD9cm AS ICD9cmEquivalent, 
                      dbo.AB_Intervention.AbstractID AS zzAbstractLink
FROM         dbo.AB_Intervention with (nolock) LEFT OUTER JOIN
                      dbo.ICD_ProcFile10 with (nolock) on dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile10.Code RIGHT OUTER JOIN
                      dbo.AB_Abstract with (nolock) on dbo.AB_Intervention.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.LU_AnaestTechnique Lookup20 with (nolock) on dbo.AB_Intervention.IntervAnaestTechnique = Lookup20.Code LEFT OUTER JOIN
                      dbo.LU_Provider Lookup21 with (nolock) on dbo.AB_Intervention.IntervAnaestID = Lookup21.Code LEFT OUTER JOIN
                      dbo.LU_IntervEUL Lookup62 with (nolock) on dbo.AB_Intervention.IntervEUL = Lookup62.Code LEFT OUTER JOIN
                      dbo.LU_IntervExtra Lookup66 with (nolock) on dbo.AB_Intervention.IntervExtra = Lookup66.Code LEFT OUTER JOIN
                      dbo.LU_IntervAttExtent Lookup77 with (nolock) on dbo.AB_Intervention.IntervAttribExtent = Lookup77.Code LEFT OUTER JOIN
                      dbo.LU_IntervAttLocation Lookup78 with (nolock) on dbo.AB_Intervention.IntervAttribLocation = Lookup78.Code LEFT OUTER JOIN
                      dbo.LU_IntervAttStatus Lookup79 with (nolock) on dbo.AB_Intervention.IntervAttribStatus = Lookup79.Code LEFT OUTER JOIN
                      dbo.LU_IntervLocation_AI Lookup80 with (nolock) on dbo.AB_Intervention.IntervLocation = Lookup80.Code LEFT OUTER JOIN
                      dbo.LU_Provider Lookup81 with (nolock) on dbo.AB_Intervention.IntervProviderNumber = Lookup81.Code LEFT OUTER JOIN
                      dbo.LU_ProviderSpecialty Lookup82 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup82.Code LEFT OUTER JOIN
                      dbo.LU_IntervSuffix Lookup83 with (nolock) on dbo.AB_Intervention.IntervSuffix = Lookup83.Code LEFT OUTER JOIN
                      dbo.LU_YesBlankAlpha Lookup97 with (nolock) on dbo.AB_Intervention.IntervOOHIndicator = Lookup97.Code LEFT OUTER JOIN
                      dbo.LU_Institution_10 Lookup98 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = Lookup98.Code LEFT OUTER JOIN
                      dbo.LU_IntervTissue Lookup149 with (nolock) on dbo.AB_Intervention.IntervTissueCode = Lookup149.Code LEFT OUTER JOIN
                      dbo.LU_YesBlank Lookup154 with (nolock) on dbo.AB_Intervention.IntervUnplanReturn = Lookup154.Code INNER JOIN
                          (SELECT     Lookup20.DisplayCode AS AnestheticTechnique, Lookup20.UserDescription AS AnestheticTechniqueDesc, 
                                                   Lookup21.DisplayCode AS AnesthetistID, Lookup21.UserDescription AS AnesthetistIDDesc, Lookup62.DisplayCode AS EUL, 
                                                   Lookup62.UserDescription AS EULDesc, Lookup66.DisplayCode AS Extra, Lookup66.UserDescription AS ExtraDesc, 
                                                   dbo.AB_Intervention.IntervDateIn, dbo.AB_Intervention.IntervDateOut, dbo.AB_Intervention.IntervDate AS InterventionDate, 
                                                   Lookup80.DisplayCode AS InterventionLocation, Lookup80.UserDescription AS InterventionLocationDesc, 
                                                   dbo.AB_Intervention.IntervOccurrence AS InterventionOccurrence, Lookup81.DisplayCode AS InterventionProviderNumber, 
                                                   Lookup81.UserDescription AS InterventionProviderNumberDesc, Lookup82.DisplayCode AS InterventionProviderSpecialty, 
                                                   Lookup82.UserDescription AS InterventionProviderSpecialtyDesc, Lookup83.DisplayCode AS InterventionSuffix, 
                                                   Lookup83.UserDescription AS InterventionSuffixDesc, dbo.AB_Intervention.IntervTimeIn AS InterventionTimeIn, 
                                                   dbo.AB_Intervention.IntervTimeMinutes AS InterventionTimeinMinutes, dbo.AB_Intervention.IntervTimeOut AS InterventionTimeOut, 
                                                   Lookup97.DisplayCode AS OOHIndicator, Lookup97.UserDescription AS OOHIndicatorDesc, 
                                                   Lookup98.DisplayCode AS OOHInstitutionNumber, Lookup98.UserDescription AS OOHInstitutionNumberDesc, 
                                                   Lookup149.DisplayCode AS TissueCode, Lookup149.UserDescription AS TissueCodeDesc, 
                                                   Lookup154.DisplayCode AS UnplannedReturntoOR, Lookup154.UserDescription AS UnplannedReturntoORDesc, 
                                                   dbo.AB_Intervention.AbstractID
                            FROM          dbo.AB_Intervention with (nolock) RIGHT OUTER JOIN
                                                   dbo.AB_Abstract with (nolock) on dbo.AB_Intervention.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                                                   dbo.LU_AnaestTechnique Lookup20 with (nolock) on dbo.AB_Intervention.IntervAnaestTechnique = Lookup20.Code LEFT OUTER JOIN
                                                   dbo.LU_Provider Lookup21 with (nolock) on dbo.AB_Intervention.IntervAnaestID = Lookup21.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervEUL Lookup62 with (nolock) on dbo.AB_Intervention.IntervEUL = Lookup62.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervExtra Lookup66 with (nolock) on dbo.AB_Intervention.IntervExtra = Lookup66.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervLocation_AI Lookup80 with (nolock) on dbo.AB_Intervention.IntervLocation = Lookup80.Code LEFT OUTER JOIN
                                                   dbo.LU_Provider Lookup81 with (nolock) on dbo.AB_Intervention.IntervProviderNumber = Lookup81.Code LEFT OUTER JOIN
                                                   dbo.LU_ProviderSpecialty Lookup82 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup82.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervSuffix Lookup83 with (nolock) on dbo.AB_Intervention.IntervSuffix = Lookup83.Code LEFT OUTER JOIN
                                                   dbo.LU_YesBlankAlpha Lookup97 with (nolock) on dbo.AB_Intervention.IntervOOHIndicator = Lookup97.Code LEFT OUTER JOIN
                                                   dbo.LU_Institution_10 Lookup98 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = Lookup98.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervTissue Lookup149 with (nolock) on dbo.AB_Intervention.IntervTissueCode = Lookup149.Code LEFT OUTER JOIN
                                                   dbo.LU_YesBlank Lookup154 with (nolock) on dbo.AB_Intervention.IntervUnplanReturn = Lookup154.Code
                            WHERE      (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_Intervention.IntervOccurrence = 1)) OCC ON 
                      dbo.AB_Intervention.AbstractID = OCC.AbstractID
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_Intervention.IntervOccurrence IS NOT NULL)




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[I10_Amcare_Interventions_VR]
AS
SELECT     
    Lookup20.DisplayCode AS AnestheticTechnique, Lookup20.UserDescription AS AnestheticTechniqueDesc, Lookup21.DisplayCode AS AnesthetistID, 
    Lookup21.UserDescription AS AnesthetistIDDesc, Lookup62.DisplayCode AS EUL, Lookup62.UserDescription AS EULDesc, 
    Lookup66.DisplayCode AS Extra, Lookup66.UserDescription AS ExtraDesc, 
    dbo.ICD_ProcFile10.CIHIValue AS InterventionCIHIValue, 
    dbo.ICD_ProcFile10.DisplayCode AS InterventionCode, 
    dbo.ICD_ProcFile10.UserDescription AS InterventionCodeDesc, 
    dbo.ICD_ProcFile10.ShortDescription AS InterventionCodeShortDesc, 
    dbo.ICD_IntervClinicianTitle.CCI_ClinicianTitle as InterventionCodeClinicianTitle,
	IntervComments as InterventionComments,
    dbo.AB_Intervention.IntervDateIn, dbo.AB_Intervention.IntervDateOut, 
    Lookup77.DisplayCode AS InterventionAttributeExtent, Lookup77.UserDescription AS IntervAttributeExtentDesc, 
    Lookup78.DisplayCode AS InterventionAttributeLocation, Lookup78.UserDescription AS IntervAttributeLocationDesc, 
    Lookup79.DisplayCode AS InterventionAttributeStatus, Lookup79.UserDescription AS IntervAttributeStatusDesc, 
    dbo.AB_Intervention.IntervDate AS InterventionDate, dbo.ICD_ProcFile10.ICD9 AS IntervICD9Equivalent, 
    dbo.ICD_ProcFile10.ICD9cm AS IntervICD9cmEquivalent, 
    Lookup80.DisplayCode AS InterventionLocation, Lookup80.UserDescription AS InterventionLocationDesc, 
    dbo.AB_Intervention.IntervOccurrence AS InterventionOccurrence, 
    Lookup81.DisplayCode AS InterventionProviderNumber, Lookup81.UserDescription AS InterventionProviderNumberDesc, 
    Lookup82.DisplayCode AS InterventionProviderSpecialty, Lookup82.UserDescription AS IntervProviderSpecialtyDesc, 
    Lookup83.DisplayCode AS InterventionSuffix, Lookup83.UserDescription AS InterventionSuffixDesc, 

    dbo.AB_Intervention.IntervTimeIn AS InterventionTimeIn, 
    LU_IntervTimeInUnknown.DisplayCode AS InterventionTimeInUnknown, LU_IntervTimeInUnknown.UserDescription AS InterventionTimeInUnknownDesc, 
    dbo.AB_Intervention.IntervTimeMinutes AS InterventionTimeinMinutes, 
    dbo.AB_Intervention.IntervTimeOut AS InterventionTimeOut, 
    LU_IntervTimeOutUnknown.DisplayCode AS InterventionTimeOutUnknown, LU_IntervTimeOutUnknown.UserDescription AS InterventionTimeOutUnknownDesc, 
    
    Lookup97.DisplayCode AS OOHIndicator, Lookup97.UserDescription AS OOHIndicatorDesc, 
    Lookup98.DisplayCode AS OOHInstitutionNumber, Lookup98.UserDescription AS OOHInstitutionNumberDesc, 
    dbo.AB_Intervention.IntervTripNumber AS ORTripNumber, dbo.LU_YesNoSystem.DisplayCode AS SurgicalCode, 
    dbo.LU_YesNoSystem.UserDescription AS SurgicalCodeDesc, Lookup149.DisplayCode AS TissueCode, 
    Lookup149.UserDescription AS TissueCodeDesc, Lookup154.DisplayCode AS UnplannedReturntoOR, 
    Lookup154.UserDescription AS UnplannedReturntoORDesc, dbo.AB_Intervention.AbstractID AS zzAbstractLink
FROM           
    dbo.AB_Abstract with (nolock)  LEFT OUTER JOIN
    dbo.AB_Intervention with (nolock) on dbo.AB_Intervention.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.ICD_ProcFile10 with (nolock) on dbo.ICD_ProcFile10.Code = dbo.AB_Intervention.IntervCode left OUTER JOIN
    dbo.ICD_IntervClinicianTitle with (nolock) on dbo.ICD_IntervClinicianTitle.CCICode = dbo.ICD_ProcFile10.CIHIValue left OUTER JOIN

    dbo.LU_YesNoSystem with (nolock) on dbo.LU_YesNoSystem.Code = dbo.ICD_ProcFile10.SurgicalCode left OUTER JOIN

    dbo.LU_AnaestTechnique AS Lookup20 with (nolock) on dbo.AB_Intervention.IntervAnaestTechnique = Lookup20.Code LEFT OUTER JOIN
    dbo.LU_Provider AS Lookup21 with (nolock) on dbo.AB_Intervention.IntervAnaestID = Lookup21.Code LEFT OUTER JOIN
    dbo.LU_IntervEUL AS Lookup62 with (nolock) on dbo.AB_Intervention.IntervEUL = Lookup62.Code LEFT OUTER JOIN
    dbo.LU_IntervExtra AS Lookup66 with (nolock) on dbo.AB_Intervention.IntervExtra = Lookup66.Code LEFT OUTER JOIN
    dbo.LU_IntervAttExtent AS Lookup77 with (nolock) on dbo.AB_Intervention.IntervAttribExtent = Lookup77.Code LEFT OUTER JOIN
    dbo.LU_IntervAttLocation AS Lookup78 with (nolock) on dbo.AB_Intervention.IntervAttribLocation = Lookup78.Code LEFT OUTER JOIN
    dbo.LU_IntervAttStatus AS Lookup79 with (nolock) on dbo.AB_Intervention.IntervAttribStatus = Lookup79.Code LEFT OUTER JOIN
    dbo.LU_IntervLocation_AI AS Lookup80 with (nolock) on dbo.AB_Intervention.IntervLocation = Lookup80.Code LEFT OUTER JOIN
    dbo.LU_Provider AS Lookup81 with (nolock) on dbo.AB_Intervention.IntervProviderNumber = Lookup81.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty AS Lookup82 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup82.Code LEFT OUTER JOIN
    dbo.LU_IntervSuffix AS Lookup83 with (nolock) on dbo.AB_Intervention.IntervSuffix = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha AS Lookup97 with (nolock) on dbo.AB_Intervention.IntervOOHIndicator = Lookup97.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 AS Lookup98 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_IntervTissue AS Lookup149 with (nolock) on dbo.AB_Intervention.IntervTissueCode = Lookup149.Code LEFT OUTER JOIN
    dbo.LU_YesBlank AS Lookup154 with (nolock) on dbo.AB_Intervention.IntervUnplanReturn = Lookup154.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_IntervTimeInUnknown with (nolock) on dbo.AB_Intervention.IntervTimeInUnknown = LU_IntervTimeInUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_IntervTimeOutUnknown with (nolock) on dbo.AB_Intervention.IntervTimeOutUnknown = LU_IntervTimeOutUnknown.Code 
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_Intervention.IntervOccurrence IS NOT NULL)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Level1_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[I10_Amcare_Level1_VR]
AS
SELECT
    LU_AccessPrimaryHealthCareCode.DisplayCode as AccessPrimaryHealthCareCode,  LU_AccessPrimaryHealthCareCode.UserDescription as AccessPrimaryHealthCareCodeDesc,
    Lookup3.DisplayCode AS AdmitbyAmbulance, Lookup3.UserDescription AS AdmitbyAmbulanceDesc, 
    AmbulanceArrDate as AmbulanceArrivalDate, AmbulanceArrTime as AmbulanceArrivalTime, 
    LU_AmbulanceArrTimeUnknown.DisplayCode as AmbulanceArrivalTimeUnknown,  LU_AmbulanceArrTimeUnknown.UserDescription as AmbulanceArrivalTimeUnknownDesc,
    AmbulanceTranDate as AmbulanceTransferCareDate, AmbulanceTranTime as AmbulanceTransferCareTime,
    LU_AmbulanceTranTimeUnknown.DisplayCode as AmbulanceTransferCareTimeUnknown,  LU_AmbulanceTranTimeUnknown.UserDescription as AmbulanceTransferCareTimeUnknownDesc,
    LU_AmCareGroup.DisplayCode AS AmCareGroup, LU_AmCareGroup.UserDescription AS AmCareGroupDesc, 
    LU_AmCareTypeCode.DisplayCode AS AmcareTypeCode, LU_AmCareTypeCode.UserDescription AS AmcareTypeCodeDesc, 
    dbo.AB_Abstract.ArrivalDate, 
    dbo.AB_Abstract.ArrivalTime, 
    dbo.AB_Abstract.AssessmentDate, dbo.AB_Abstract.AssessmentTime, 
    Lookup159.DisplayCode AS AssessmentTimeUnknown, Lookup159.UserDescription AS AssessmentTimeUnknownDesc, 
    
    dbo.AB_Abstract.BatchNumber, 
    Lookup44.DisplayCode AS BatchPeriod, Lookup44.UserDescription AS BatchPeriodDesc, 
    dbo.AB_Abstract.BatchYear, 
    dbo.AB_Abstract.BirthDate, 
    LU_CDUFlag.Displaycode as ClinicalDecisionUnitFlag,    LU_CDUFlag.UserDescription as ClinicalDecisionUnitFlagDesc,
    CDUArrivalDate as ClinicalDecisionUnitDateIn, CDUArrivalTime as ClinicalDecisionUnitTimeIn,
    LU_CDUInTimeUnknown.Displaycode as ClinicalDecisionUnitTimeInUnknown,    LU_CDUInTimeUnknown.UserDescription as ClinicalDecisionUnitTimeInUnknownDesc,
    CDUOutDate as ClinicalDecisionUnitDateOut, CDUOutTime as ClinicalDecisionUnitTimeOut,
    LU_CDUOutTimeUnknown.Displaycode as ClinicalDecisionUnitTimeOutUnknown,    LU_CDUOutTimeUnknown.UserDescription as ClinicalDecisionUnitTimeOutUnknownDesc,

    dbo.AB_Abstract.ChartNumber, 
    Lookup46.DisplayCode AS CoderNumber, Lookup46.UserDescription AS CoderNumberDesc, 
    dbo.AB_Abstract.DateLeftER, 

    dbo.AB_Abstract.CIHIDateSent AS DateSentToCIHI, 
    Lookup60.DisplayCode AS DischargeDisposition, Lookup60.UserDescription AS DischargeDispositionDesc, 
    dbo.AB_Abstract.DischargeDate AS DispositionDate, 
    dbo.AB_Abstract.DischargeTime AS DispositionTime, 
    LUDischargeTimeUnknown.DisplayCode AS DispositionTimeUnknown, LUDischargeTimeUnknown.UserDescription AS DispositionTimeUnknownDesc, 
    --ED - 02289
    LU_EDVisitIndicator.DisplayCode AS EDVisitIndicator, LU_EDVisitIndicator.UserDescription AS EDVisitIndicatorDesc,
    
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS FullName, 
    Lookup69.DisplayCode AS Gender, Lookup69.UserDescription AS GenderDesc, 
    Lookup70.DisplayCode AS HCNProvince, Lookup70.UserDescription AS HCNProvinceDesc, 
    dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
    Lookup74.DisplayCode AS InstitutionNumber, Lookup74.UserDescription AS InstitutionNumberDesc, 
    dbo.AB_Abstract.InterfaceDate, dbo.AB_Abstract.InterfaceTime, 
    LU_InterfaceInCoder.DisplayCode as InterfaceCoder, LU_InterfaceInCoder.UserDescription as InterfaceCoderDesc, 

    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel1, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel1Desc, 
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel1, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel1Desc, 
    Lookup85.DisplayCode AS IsAbstractDeleted,   Lookup85.UserDescription AS IsAbstractDeletedDesc, 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel1, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel1Desc, 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel1, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel1Desc, 
	LU_IsCustomValidated.DisplayCode AS IsCustomValidated, LU_IsCustomValidated.UserDescription AS IsCustomValidatedDesc, 

    Lookup93.DisplayCode AS MISCode, Lookup93.UserDescription AS MISCodeDesc, 
    
	AB_NACRS.NonPhysicianAssessmentDate, AB_NACRS.NonPhysicianAssessmentTime, 
	LU_NonPhysicianAssessmentTimeUnknown.DisplayCode AS NonPhysicianAssessmentTimeUnknown, LU_NonPhysicianAssessmentTimeUnknown.UserDescription AS NonPhysicianAssessmentTimeUnknownDesc,
	LU_NonPhysicianNumber.DisplayCode AS NonPhysicianNumber, LU_NonPhysicianNumber.UserDescription AS NonPhysicianNumberDesc,
	LU_NonPhysicianService.DisplayCode AS NonPhysicianService, LU_NonPhysicianService.UserDescription AS NonPhysicianServiceDesc,
   
    dbo.AB_Abstract.PostalCode, 
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), dbo.AB_Abstract.AdmitDate) AS PostalCodeDesc, -- ED - 01682
    dbo.AB_Abstract.EncounterNumber AS RegistrationNumber, dbo.AB_Abstract.EncounterSequence AS RegistrationSequenceNumber, 
    dbo.AB_Abstract.AdmitDate AS RegistrationVisitDate, dbo.AB_Abstract.AdmitTime AS RegistrationVisitTime, 
    Lookup138.DisplayCode AS ResidenceCode, Lookup138.UserDescription AS ResidenceCodeDesc, 
    Lookup140.DisplayCode AS ResponsiblityForPayment, Lookup140.UserDescription AS ResponsiblityForPaymentDesc, 
    Lookup153.DisplayCode AS SchedEDVisit, Lookup153.UserDescription AS SchedEDVisitDesc, 

	LU_SpecialistNumber.DisplayCode AS SpecialistNumber, LU_SpecialistNumber.UserDescription AS SpecialistNumberDesc,
	AB_NACRS.SpecialistRequestDate, 
	LU_SpecialistService.DisplayCode AS SpecialistRequestService, LU_SpecialistService.UserDescription AS SpecialistRequestServiceDesc,
	AB_NACRS.SpecialistRequestTime, 
	LU_SpecialistRequestTimeUnknown.DisplayCode AS SpecialistRequestTimeUnknown, LU_SpecialistRequestTimeUnknown.UserDescription AS SpecialistRequestTimeUnknownDesc,
    --ED - 02289
    LU_StatusAfterTriage.DisplayCode as StatusAfterTriage, LU_StatusAfterTriage.UserDescription as StatusAfterTriageDesc,
	
    SubmissionLevel as SubmissionLevelCode, 
    AbstractNumber as SubmissionRecordID,
    dbo.AB_Abstract.TimeLeftER, 
    LU_TimeLeftERUnknown.DisplayCode AS TimeLeftERUnknown, LU_TimeLeftERUnknown.UserDescription AS TimeLeftERUnknownDEsc, 
    dbo.AB_Abstract.TriageDate, 
    Lookup151.DisplayCode AS TriageLevel, Lookup151.UserDescription AS TriageLevelDesc, 
    dbo.AB_Abstract.TriageTime, 
    LU_TriageTimeUnknown.DisplayCode AS TriageTimeUnknown, LU_TriageTimeUnknown.UserDescription AS TriageTimeUnknownDesc, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TriageTimeUnknown with (nolock) on dbo.AB_Abstract.TriageTimeUnknown = LU_TriageTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TimeLeftERUnknown with (nolock) on dbo.AB_Abstract.TimeLeftERUnknown = LU_TimeLeftERUnknown.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup44 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup44.Code LEFT OUTER JOIN
    dbo.U_Users Lookup46 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_A Lookup60 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup69 with (nolock) on dbo.AB_Abstract.Gender = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup70 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup70.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup74 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup74.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus Lookup85 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_MISCode Lookup93 with (nolock) on dbo.AB_Abstract.MISCode = Lookup93.Code LEFT OUTER JOIN
    
    dbo.LU_ResidenceCode Lookup138 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup138.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup140 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup140.Code LEFT OUTER JOIN
    dbo.LU_TriageLevel Lookup151 with (nolock) on dbo.AB_Abstract.TriageLevel = Lookup151.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup153 with (nolock) on dbo.AB_Abstract.SchedEDVisit = Lookup153.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup159 with (nolock) on dbo.AB_Abstract.AssessmentTimeUnknown = Lookup159.Code AND Lookup159.LookupID = 1 LEFT OUTER JOIN
    dbo.LU_CodeFile LUDischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LUDischargeTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AmbulanceArrTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceArrTimeUnknown = LU_AmbulanceArrTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AmbulanceTranTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceTranTimeUnknown = LU_AmbulanceTranTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_AccessPrimaryHealthCareCode with (nolock) on dbo.AB_Abstract.AccessCareCode = dbo.LU_AccessPrimaryHealthCareCode.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_CDUFlag with (nolock) on dbo.AB_Abstract.CDUFlag = LU_CDUFlag.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUInTimeUnknown with (nolock) on dbo.AB_Abstract.CDUInTimeUnknown = LU_CDUInTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUOutTimeUnknown with (nolock) on dbo.AB_Abstract.CDUOutTimeUnknown = LU_CDUOutTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect LU_Level1_Correction with (nolock) on dbo.AB_Abstract.IsCorrectLevel1 = LU_Level1_Correction.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_Level1_Submission with (nolock) on dbo.AB_Abstract.IsSubmitLevel1 = LU_Level1_Submission.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Validation with (nolock) on dbo.AB_Abstract.IsValidLevel1 = LU_Level1_Validation.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_IsCustomValidated with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_IsCustomValidated.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Completed with (nolock) on dbo.AB_Abstract.IsCompleteLevel1 = LU_Level1_Completed.Code 
	left join dbo.AB_NACRS with (nolock) on AB_Abstract.AbstractID = AB_NACRS.AbstractID
	left join dbo.LU_Provider LU_SpecialistNumber with (nolock) on AB_NACRS.SpecialistNumber = LU_SpecialistNumber.Code
	left join dbo.LU_ProviderSpecialty LU_SpecialistService with (nolock) on AB_NACRS.SpecialistService = LU_SpecialistService.Code
	left join dbo.LU_CodeFile LU_SpecialistRequestTimeUnknown with (nolock) on AB_NACRS.SpecialistRequestTimeUnknown = LU_SpecialistRequestTimeUnknown.Code
	left join dbo.LU_Provider LU_NonPhysicianNumber with (nolock) on AB_NACRS.NonPhysicianNumber = LU_NonPhysicianNumber.Code
	left join dbo.LU_ProviderSpecialty LU_NonPhysicianService with (nolock) on AB_NACRS.NonPhysicianService = LU_NonPhysicianService.Code
	left join dbo.LU_CodeFile LU_NonPhysicianAssessmentTimeUnknown with (nolock) on AB_NACRS.NonPhysicianAssessmentTimeUnknown = LU_NonPhysicianAssessmentTimeUnknown.Code
	
	left join dbo.LU_CodeFile LU_AmCareTypeCode with (nolock) on AB_NACRS.AmCareTypeCode = LU_AmCareTypeCode.Code
	left join dbo.LU_CodeFile LU_AmCareGroup with (nolock) on AB_NACRS.AmCareGroup = LU_AmCareGroup.Code
    left join U_Users LU_InterfaceInCoder with (nolock) on AB_Abstract.InterfaceCoder = LU_InterfaceInCoder.code

    --ED - 02298
    left join dbo.LU_YesNoSystem LU_EDVisitIndicator with (nolock) on dbo.AB_NACRS.EDVisitIndicator = LU_EDVisitIndicator.Code
    left join dbo.LU_StatusAfterTriage with (nolock) on dbo.AB_NACRS.StatusAfterTriage = LU_StatusAfterTriage.Code
     
WHERE  ((Lookup93.CIHIValue like ''7_310%'' and Admitdate < ''2010/04/01'') or Lookup93.AmcareGroup = ''ED'')
    and (dbo.AB_Abstract.CareType = 5)
    and ICDType = ''T''
       
--WHERE  ((AdmitDate >= ''2009/04/01'' and Lookup74.CIHIValue not like ''5%'' and Lookup74.LevelCode in (1, 2))
--        or 
--        (AdmitDate >= ''2009/11/01'' and Lookup74.CIHIValue like ''5%'' and Lookup74.LevelCode in (4, 5)
--            and ((Lookup93.CIHIValue like ''7_310%'' and Admitdate < ''2010/04/01'') or Lookup93.AmcareGroup = ''ED''))
--       )




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_MIS_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[I10_Amcare_MIS_VR]
AS
SELECT     dbo.AB_MIS.DirectCost AS DirectCosts, dbo.AB_MIS.IndirectCost AS IndirectCosts, dbo.LU_MISCode.DisplayCode AS MISCode, 
                      dbo.LU_MISCode.UserDescription AS MISCodeDesc, dbo.AB_MIS.MISOccurrence, dbo.AB_MIS.SupplyCost AS SupplyCosts, 
                      dbo.AB_MIS.AbstractID AS zzAbstractLink
FROM         dbo.AB_MIS with (nolock) RIGHT OUTER JOIN
                      dbo.AB_Abstract with (nolock) ON dbo.AB_MIS.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.LU_MISCode with (nolock) ON dbo.AB_MIS.MISCode = dbo.LU_MISCode.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_MIS.MISOccurrence IS NOT NULL)







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_PresentingComplaint]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[I10_Amcare_PresentingComplaint]
as
select
	AbstractID as zzAbstractLink,
	Occurrence as PresentingComplaintOccurrence,
	LU_PresentingComplaint.DisplayCode as PresentingComplaint,
	LU_PresentingComplaint.UserDescription as PresentingComplaintDesc
from dbo.AB_PresentingComplaints with (nolock)
	left join LU_CodeFile LU_PresentingComplaint with (nolock) on PresentingComplaint = LU_PresentingComplaint.Code



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Profile_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[I10_Amcare_Profile_VR]
AS
SELECT
    dbo.AB_ReproductiveCare.PrevPreTermDelivery AS [#ofPreviousPreTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevSpontAbortions AS [#ofPrevSpontaneousAbortions], 
    dbo.AB_ReproductiveCare.PrevTermDelivery AS [#ofPreviousTermDeliveries], 
    --ED - 01910
    LU_AccessPrimaryHealthCareCode.DisplayCode as AccessPrimaryHealthCareCode,  LU_AccessPrimaryHealthCareCode.UserDescription as AccessPrimaryHealthCareCodeDesc,
    AmbulanceArrDate as AmbulanceArrivalDate, AmbulanceArrTime as AmbulanceArrivalTime, 
    LU_AmbulanceArrTimeUnknown.DisplayCode as AmbulanceArrivalTimeUnknown,  LU_AmbulanceArrTimeUnknown.UserDescription as AmbulanceArrivalTimeUnknownDesc,
    AmbulanceTranDate as AmbulanceTransferCareDate, AmbulanceTranTime as AmbulanceTransferCareTime,
    LU_AmbulanceTranTimeUnknown.DisplayCode as AmbulanceTransferCareTimeUnknown,  LU_AmbulanceTranTimeUnknown.UserDescription as AmbulanceTransferCareTimeUnknownDesc,

    dbo.AB_ReproductiveCare.PrevInduceAbortions AS [#ofPrevTherapeuticAbortions], Lookup1.DisplayCode AS AWOL, 
    Lookup1.UserDescription AS AWOLDesc, dbo.AB_ReproductiveCare.AbortionDate AS AbortDate, dbo.AB_Abstract.AbstractNumber, 
    dbo.LU_AbstractOverflow.DisplayCode AS AbstractOverflow, dbo.LU_AbstractOverflow.UserDescription AS AbstractOverflowDesc, 
    dbo.AB_Abstract.InjuryActivityDescription AS ActivityDescription, Lookup2.DisplayCode AS ActivityWhenInjured, 
    Lookup2.UserDescription AS ActivityWhenInjuredDesc, dbo.AB_Abstract.AcuteLOS AS ActueLOS, Lookup3.DisplayCode AS AdmitbyAmbulance, 
    Lookup3.UserDescription AS AdmitbyAmbulanceDesc, dbo.AB_Abstract.AdmitCategory, 
    dbo.AB_Abstract.AdmittingDiagnosis AS AdmitDiagnosis, 
    LU_AdmitNurse.DisplayCode AS AdmitNursingArea, LU_AdmitNurse.UserDescription AS AdmitNursingAreaDesc, 
    dbo.AB_DeathInformation.DeathAfterAdmit AS AfterAdmit, 
    Lookup4.DisplayCode AS AgeCode, Lookup4.UserDescription AS AgeCodeDesc, dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, 
    Lookup5.DisplayCode AS Albumin, Lookup5.UserDescription AS AlbuminDesc, Lookup6.DisplayCode AS AlbuminCrossMatched, 
    Lookup6.UserDescription AS AlbuminCrossMatchedDesc, Lookup7.DisplayCode AS AlbuminTyped, Lookup7.UserDescription AS AlbuminTypedDesc, 
    dbo.AB_Blood.AlbuminUnits, dbo.AB_Abstract.ALCLOS, 
    dbo.AB_Abstract.AmbulanceReportNumber, 
    --ED-02091 & ED - 02130
    isnull(LU_AmCareGroup.DisplayCode, LU_AmCareGroup_FromMISCode.DisplayCode) AS AmCareGroup, 
    isnull(LU_AmCareGroup.UserDescription, LU_AmCareGroup_FromMISCode.UserDescription) AS AmCareGroupDesc, 
    --PR - 03010
    LU_AmCareType.DisplayCode AS AmcareCareType, LU_AmCareType.UserDescription AS AmcareCareTypeDesc, 
    --ED-02091  & ED - 02130
    isnull(LU_AmCareTypeCode.DisplayCode, LU_AmCareTypeCode_FromMISCode.DisplayCode) AS AmcareTypeCode, 
    isnull(LU_AmCareTypeCode.UserDescription, LU_AmCareTypeCode_FromMISCode.UserDescription) AS AmcareTypeCodeDesc, 
    
    dbo.AB_Ancillary.AncillaryField13 AS Ancil13, 
    dbo.AB_Ancillary.AncillaryField14 AS Ancil14, dbo.AB_Ancillary.AncillaryField15 AS Ancil15, dbo.AB_Ancillary.AncillaryField16 AS Ancil16, 
    dbo.AB_Ancillary.AncillaryField17 AS Ancil17, Lookup8.DisplayCode AS AncillaryField1, Lookup8.UserDescription AS AncillaryField1Desc, 
    Lookup9.DisplayCode AS AncillaryField10, Lookup9.UserDescription AS AncillaryField10Desc, Lookup10.DisplayCode AS AncillaryField11, 
    Lookup10.UserDescription AS AncillaryField11Desc, Lookup11.DisplayCode AS AncillaryField12, Lookup11.UserDescription AS AncillaryField12Desc, 
    Lookup12.DisplayCode AS AncillaryField2, Lookup12.UserDescription AS AncillaryField2Desc, Lookup13.DisplayCode AS AncillaryField3, 
    Lookup13.UserDescription AS AncillaryField3Desc, Lookup14.DisplayCode AS AncillaryField4, Lookup14.UserDescription AS AncillaryField4Desc, 
    Lookup15.DisplayCode AS AncillaryField5, Lookup15.UserDescription AS AncillaryField5Desc, Lookup16.DisplayCode AS AncillaryField6, 
    Lookup16.UserDescription AS AncillaryField6Desc, Lookup17.DisplayCode AS AncillaryField7, Lookup17.UserDescription AS AncillaryField7Desc, 
    Lookup18.DisplayCode AS AncillaryField8, Lookup18.UserDescription AS AncillaryField8Desc, Lookup19.DisplayCode AS AncillaryField9, 
    Lookup19.UserDescription AS AncillaryField9Desc, dbo.AB_Abstract.ArrivalDate, Lookup22.DisplayCode AS ArrivalMode, 
    Lookup22.UserDescription AS ArrivalModeDesc, dbo.AB_Abstract.ArrivalTime, dbo.AB_Abstract.ArrivalTriageDifference AS ArrivaltoTriageTime, 
    dbo.AB_Abstract.AssessmentDate, dbo.AB_Abstract.AssessmentTime, Lookup159.DisplayCode AS AssessmentTimeUnknown, 
    Lookup159.UserDescription AS AssessmentTimeUnknownDesc, LU_AttendingPhysician.DisplayCode AS AttendingPhysician, 
    LU_AttendingPhysician.UserDescription AS AttendingPhysicianDesc, Lookup23.DisplayCode AS AutoTransfusion, 
    Lookup23.UserDescription AS AutoTransfusionDesc, Lookup24.DisplayCode AS AutopsyPerformed, 
    Lookup24.UserDescription AS AutopsyPerformedDesc, Lookup25.DisplayCode AS BasicOption1, Lookup25.UserDescription AS BasicOption1Desc, 
    Lookup26.DisplayCode AS BasicOption10, Lookup26.UserDescription AS BasicOption10Desc, Lookup27.DisplayCode AS BasicOption11, 
    Lookup27.UserDescription AS BasicOption11Desc, Lookup28.DisplayCode AS BasicOption12, Lookup28.UserDescription AS BasicOption12Desc, 
    Lookup29.DisplayCode AS BasicOption13, Lookup29.UserDescription AS BasicOption13Desc, Lookup30.DisplayCode AS BasicOption14, 
    Lookup30.UserDescription AS BasicOption14Desc, Lookup31.DisplayCode AS BasicOption15, Lookup31.UserDescription AS BasicOption15Desc, 
    Lookup32.DisplayCode AS BasicOption16, Lookup32.UserDescription AS BasicOption16Desc, Lookup33.DisplayCode AS BasicOption17, 
    Lookup33.UserDescription AS BasicOption17Desc, Lookup34.DisplayCode AS BasicOption18, Lookup34.UserDescription AS BasicOption18Desc, 
    Lookup35.DisplayCode AS BasicOption19, Lookup35.UserDescription AS BasicOption19Desc, Lookup36.DisplayCode AS BasicOption2, 
    Lookup36.UserDescription AS BasicOption2Desc, Lookup37.DisplayCode AS BasicOption3, Lookup37.UserDescription AS BasicOption3Desc, 
    Lookup38.DisplayCode AS BasicOption4, Lookup38.UserDescription AS BasicOption4Desc, Lookup39.DisplayCode AS BasicOption5, 
    Lookup39.UserDescription AS BasicOption5Desc, Lookup40.DisplayCode AS BasicOption6, Lookup40.UserDescription AS BasicOption6Desc, 
    Lookup41.DisplayCode AS BasicOption7, Lookup41.UserDescription AS BasicOption7Desc, Lookup42.DisplayCode AS BasicOption8, 
    Lookup42.UserDescription AS BasicOption8Desc, Lookup43.DisplayCode AS BasicOption9, Lookup43.UserDescription AS BasicOption9Desc, 
    dbo.AB_Abstract.BatchNumber, Lookup44.DisplayCode AS BatchPeriod, Lookup44.UserDescription AS BatchPeriodDesc, 
    --PR - 06087
    BatchPeriod_BC = (case when left(Lookup74.CIHIValue, 1) <> ''9'' then null
                           when Lookup44.DisplayCode is not null then Lookup44.DisplayCode 
                           when AdmitDate is null then null
                           else (select top 1 DisplayCode from LU_BatchPeriod where AdmitDate between CIHIDateFrom and CIHIDateTo)
                      end),
    dbo.AB_Abstract.BatchYear,     dbo.AB_Abstract.BirthDate, 
	
	LU_AntithrombinIII.DisplayCode AS Blood_AntithrombinIII, LU_AntithrombinIII.UserDescription AS Blood_AntithrombinIIIDesc,
	LU_C1Inhibitor.DisplayCode AS Blood_C1Inhibitor, LU_C1Inhibitor.UserDescription AS Blood_C1InhibitorDesc,
	LU_CryoprecipitatePlasma.DisplayCode AS Blood_CryoprecipitatePlasma, LU_CryoprecipitatePlasma.UserDescription AS Blood_CryoprecipitatePlasmaDesc,
	LU_CryosupernatantPlasma.DisplayCode AS Blood_CryosupernatantPlasma, LU_CryosupernatantPlasma.UserDescription AS Blood_CryosupernatantPlasmaDesc,
	LU_FEIBA.DisplayCode AS Blood_FEIBA, LU_FEIBA.UserDescription AS Blood_FEIBADesc,
	LU_Fibrinogen.DisplayCode AS Blood_Fibrinogen, LU_Fibrinogen.UserDescription AS Blood_FibrinogenDesc,
	LU_IVIG_SCIG.DisplayCode AS Blood_IVIG_SCIG, LU_IVIG_SCIG.UserDescription AS Blood_IVIG_SCIGDesc,
	LU_PCC.DisplayCode AS Blood_PCC, LU_PCC.UserDescription AS Blood_PCCDesc,
	LU_ProteinC_OtherFactors.DisplayCode AS Blood_ProteinC_OtherFactors, LU_ProteinC_OtherFactors.UserDescription AS Blood_ProteinC_OtherFactorsDesc,

	dbo.AB_ReproductiveCare.BreastFeeding, 
    --ED - 01910
    LU_CDUFlag.Displaycode as ClinicalDecisionUnitFlag,    LU_CDUFlag.UserDescription as ClinicalDecisionUnitFlagDesc,
    CDUArrivalDate as ClinicalDecisionUnitDateIn, CDUArrivalTime as ClinicalDecisionUnitTimeIn,
    LU_CDUInTimeUnknown.Displaycode as ClinicalDecisionUnitTimeInUnknown,    LU_CDUInTimeUnknown.UserDescription as ClinicalDecisionUnitTimeInUnknownDesc,
    CDUOutDate as ClinicalDecisionUnitDateOut, CDUOutTime as ClinicalDecisionUnitTimeOut,
    LU_CDUOutTimeUnknown.Displaycode as ClinicalDecisionUnitTimeOutUnknown,    LU_CDUOutTimeUnknown.UserDescription as ClinicalDecisionUnitTimeOutUnknownDesc,

    Lookup45.DisplayCode AS ChangeinLegalStatus, 
    Lookup45.UserDescription AS ChangeinLegalStatusDesc, dbo.AB_Abstract.ChartNumber, dbo.AB_Abstract.ChiefComplaint, 
    Lookup46.DisplayCode AS CoderNumber, Lookup46.UserDescription AS CoderNumberDesc, LUCompleteRecord.DisplayCode AS CompleteRecord, 
    LUCompleteRecord.UserDescription AS CompleteRecordDesc, LUComplication.DisplayCode AS Complication, 
    LUComplication.UserDescription AS ComplicationDesc, Lookup47.DisplayCode AS Complication1, Lookup47.UserDescription AS Complication1Desc, 
    Lookup48.DisplayCode AS Complication2, Lookup48.UserDescription AS Complication2Desc, Lookup49.DisplayCode AS Complication3, 
    Lookup49.UserDescription AS Complication3Desc, Lookup50.DisplayCode AS ContactMode, Lookup50.UserDescription AS ContactModeDesc, 
    Lookup51.DisplayCode AS CoronerCase, Lookup51.UserDescription AS CoronerCaseDesc, Lookup52.DisplayCode AS DataEntryCoder, 
    Lookup52.UserDescription AS DataEntryCoderDesc, dbo.AB_Abstract.DateLeftER, dbo.AB_ReproductiveCare.LastMensesDate AS DateofLastMenses, 
    dbo.AB_Abstract.DateReadyDischarge AS DateReadyforDisch, 

    dbo.AB_Abstract.CIHIDateSent AS DateSentToCIHI, 
    --NP - 00125
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILevel1, 
    --ED - 02102
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILevel2, 
    --2.x-0282
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILite, 

    Lookup53.DisplayCode AS DeathInER,
    Lookup53.UserDescription AS DeathInERDesc, Lookup54.DisplayCode AS DeathOnArrival, Lookup54.UserDescription AS DeathOnArrivalDesc, 
    dbo.AB_Abstract.DecisionAdmitDifference, dbo.AB_Abstract.DecisionAdmitDate AS DecisiontoAdmitDate, 
    dbo.AB_Abstract.DecisionAdmitTime AS DecisiontoAdmitTime, Lookup158.DisplayCode AS DecisionAdmitTimeUnknown, 
    Lookup158.UserDescription AS DecisionAdmitTimeUnknownDesc, dbo.AB_ReproductiveCare.DeliveryDate, dbo.AB_ReproductiveCare.DeliveryTime, 
    Lookup58.DisplayCode AS DiedDuringIntervention, Lookup58.UserDescription AS DiedDuringInterventionDesc, 
    LU_DischargeNurse.DisplayCode AS DischNursingArea, LU_DischargeNurse.UserDescription AS DischNursingAreaDesc, 
    Lookup59.DisplayCode AS DischPlanning, 
    Lookup59.UserDescription AS DischPlanningDesc, dbo.AB_Abstract.DischargeAge, Lookup60.DisplayCode AS DischargeDisposition, 
    Lookup60.UserDescription AS DischargeDispositionDesc, dbo.AB_Abstract.DischargeDate AS DispositionDate, 
    dbo.AB_Abstract.DischargeTime AS DispositionTime, LUDischargeTimeUnknown.DisplayCode AS DispositionTimeUnknown, 
    LUDischargeTimeUnknown.UserDescription AS DispositionTimeUnknownDesc, Lookup61.DisplayCode AS ECTTreatment, 
    Lookup61.UserDescription AS ECTTreatmentDesc, Lookup64.DisplayCode AS Education, Lookup64.UserDescription AS EducationDesc, 
    --ED - 02289
    LU_EDVisitIndicator.DisplayCode AS EDVisitIndicator, LU_EDVisitIndicator.UserDescription AS EDVisitIndicatorDesc,
    
    Lookup65.DisplayCode AS Employment, Lookup65.UserDescription AS EmploymentDesc, dbo.AB_Abstract.EntryCode, 
    dbo.AB_Abstract.EstimatedDischargeDate AS EstimateDischDate, dbo.AB_Abstract.ExitCode, Lookup67.DisplayCode AS FamilyPhysicianFlag, 
    Lookup67.UserDescription AS FamilyPhysicianFlagDesc, Lookup68.DisplayCode AS FinancialSupport, 
    Lookup68.UserDescription AS FinancialSupportDesc, dbo.AB_Abstract.FinishDate, dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, 
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS FullName, 
    FixedChartNumber,
    Lookup69.DisplayCode AS Gender, Lookup69.UserDescription AS GenderDesc, dbo.AB_ReproductiveCare.GestationalAge AS GestationalAgeinweeks, 
    Lookup157.DisplayCode AS GlasgowScale, Lookup157.UserDescription AS GlasgowScaleDesc, 
    dbo.AB_DeathInformation.DeathGreaterTenPO AS GreaterTenPO, Lookup70.DisplayCode AS HCNProvince, 
    Lookup70.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
    LU_Hospital.DisplayCode AS Hospital, LU_Hospital.UserDescription AS HospitalDesc, 
    dbo.AB_Abstract.HospitalAccountRecord,
    LUHelmetIndicator.DisplayCode AS HelmetIndicator, 
    LUHelmetIndicator.UserDescription AS HelmetIndicatorDesc, dbo.AB_DeathInformation.DeathInSCU AS InSCU, Lookup71.DisplayCode AS InitialOR, 
    Lookup71.UserDescription AS InitialORDesc, dbo.AB_Abstract.InjuryDate, Lookup72.DisplayCode AS Injury, Lookup72.UserDescription AS InjuryDesc, 
    dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
	
	Lookup73.DisplayCode AS InstitutionFrom, Lookup73.UserDescription AS InstitutionFromDesc, 
	LU_InstitutionFrom_Type.DisplayCode AS InstitutionFromType, LU_InstitutionFrom_Type.UserDescription AS InstitutionFromTypeDesc, 
    Lookup73.InstCareType AS InstFromCareType, Lookup73.HospitalType AS InstFromHospType, 
	
	Lookup74.DisplayCode AS InstitutionNumber, Lookup74.UserDescription AS InstitutionNumberDesc, 
	
	Lookup75.DisplayCode AS InstitutionTo, Lookup75.UserDescription AS InstitutionToDesc, 
	LU_InstitutionTo_Type.DisplayCode AS InstitutionToType, LU_InstitutionTo_Type.UserDescription AS InstitutionToTypeDesc, 
    Lookup75.InstCareType AS InstToCareType, Lookup75.HospitalType AS InstToHospType, dbo.AB_Abstract.InterfaceDate, 
    
	dbo.AB_Abstract.InterfaceTime, 

    Lookup83.DisplayCode AS IsAbstractCompleted, Lookup83.UserDescription AS IsAbstractCompletedDesc, 
    --NP - 00125
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel1, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel1Desc, 
    --ED - 02102
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel2, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel2Desc, 
    --2.x-0282
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLite, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLiteDesc, 

    Lookup84.DisplayCode AS IsAbstractCorrected, Lookup84.UserDescription AS IsAbstractCorrectedDesc, 
    --NP - 00125
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel1, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel1Desc, 
    --ED - 02102
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel2, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel2Desc, 
    --2.x-0282
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLite, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLiteDesc, 

    Lookup85.DisplayCode AS IsAbstractDeleted,   Lookup85.UserDescription AS IsAbstractDeletedDesc, 

    Lookup86.DisplayCode AS IsAbstractSubmitted, Lookup86.UserDescription AS IsAbstractSubmittedDesc,
    --NP - 00125 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel1, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel1Desc, 
    --ED - 02102 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel2, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel2Desc, 
    --2.x-0282
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLite, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLiteDesc, 

    Lookup87.DisplayCode AS IsAbstractValidated, Lookup87.UserDescription AS IsAbstractValidatedDesc, 
    --NP - 00125 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel1, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel1Desc, 
    --ED - 02102 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel2, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel2Desc, 
    --2.x-0282
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLite, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLiteDesc, 

    Lookup88.DisplayCode AS IsBirthdateEstimated,     Lookup88.UserDescription AS IsBirthdateEstimatedDesc, 
	LU_IsCustomValidated.DisplayCode AS IsCustomValidated, LU_IsCustomValidated.UserDescription AS IsCustomValidatedDesc, 
	
	dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSTotal AS LOSTime, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LOSMinutes AS LOSTotalMinutes, Lookup89.DisplayCode AS [Language], 
    Lookup89.UserDescription AS LanguageDesc, dbo.AB_Abstract.LastName, dbo.AB_DeathInformation.DeathLessTwoPO AS LessTwoPO, 
    Lookup90.DisplayCode AS LivingArrangement, Lookup90.UserDescription AS LivingArrangementDesc, Lookup91.DisplayCode AS LocationofInjury, 
    Lookup91.UserDescription AS LocationofInjuryDesc, Lookup93.DisplayCode AS MISCode, Lookup93.UserDescription AS MISCodeDesc, 
    dbo.AB_Abstract.MaidenName, Lookup94.DisplayCode AS MaritalStatus, Lookup94.UserDescription AS MaritalStatusDesc, 

	LU_MentalLegalStatusUponArrivalED.DisplayCode as MentalHealth_LegalStatusUponArrivaltoED, 
	LU_MentalLegalStatusUponArrivalED.UserDescription as MentalHealth_LegalStatusUponArrivaltoEDDesc,
	--LU_MentalLegalStatusAdmission.DisplayCode as MentalHealth_LegalStatusAtAdmission, 
	--LU_MentalLegalStatusAdmission.UserDescription as MentalHealth_LegalStatusAtAdmissionDesc,
	LU_MentalTypeRestraint_1.DisplayCode as MentalHealth_TypeOfRestraint_01,
	LU_MentalTypeRestraint_1.UserDescription as MentalHealth_TypeOfRestraint_01Desc,
	LU_MentalTypeRestraint_2.DisplayCode as MentalHealth_TypeOfRestraint_02,
	LU_MentalTypeRestraint_2.UserDescription as MentalHealth_TypeOfRestraint_02Desc,
	LU_MentalTypeRestraint_3.DisplayCode as MentalHealth_TypeOfRestraint_03,
	LU_MentalTypeRestraint_3.UserDescription as MentalHealth_TypeOfRestraint_03Desc,
	LU_MentalTypeRestraint_4.DisplayCode as MentalHealth_TypeOfRestraint_04,
	LU_MentalTypeRestraint_4.UserDescription as MentalHealth_TypeOfRestraint_04Desc,
	LU_MentalFrequencyRestraintUse_1.DisplayCode as MentalHealth_FrequencyOfRestraint_01,
	LU_MentalFrequencyRestraintUse_1.UserDescription as MentalHealth_FrequencyOfRestraint_01Desc,
	LU_MentalFrequencyRestraintUse_2.DisplayCode as MentalHealth_FrequencyOfRestraint_02,
	LU_MentalFrequencyRestraintUse_2.UserDescription as MentalHealth_FrequencyOfRestraint_02Desc,
	LU_MentalFrequencyRestraintUse_3.DisplayCode as MentalHealth_FrequencyOfRestraint_03,
	LU_MentalFrequencyRestraintUse_3.UserDescription as MentalHealth_FrequencyOfRestraint_03Desc,
	LU_MentalFrequencyRestraintUse_4.DisplayCode as MentalHealth_FrequencyOfRestraint_04,
	LU_MentalFrequencyRestraintUse_4.UserDescription as MentalHealth_FrequencyOfRestraint_04Desc,


    Lookup95.DisplayCode AS MethodofAdmission, Lookup95.UserDescription AS MethodofAdmissionDesc, dbo.AB_Abstract.MiddleName, 
    dbo.AB_Abstract.NewbornChart, dbo.AB_Abstract.NewbornDischargeDate AS NewbornDischDate, 
    dbo.AB_Abstract.NextSchedVisitDate AS NextScheduledVisitDate, dbo.AB_Abstract.NextSchedVisitTime AS NextScheduledVisitTime, 
    --ED-02091 
	AB_NACRS.NonPhysicianAssessmentDate, AB_NACRS.NonPhysicianAssessmentTime, 
	LU_NonPhysicianAssessmentTimeUnknown.DisplayCode AS NonPhysicianAssessmentTimeUnknown, LU_NonPhysicianAssessmentTimeUnknown.UserDescription AS NonPhysicianAssessmentTimeUnknownDesc,
	LU_NonPhysicianNumber.DisplayCode AS NonPhysicianNumber, LU_NonPhysicianNumber.UserDescription AS NonPhysicianNumberDesc,
	LU_NonPhysicianService.DisplayCode AS NonPhysicianService, LU_NonPhysicianService.UserDescription AS NonPhysicianServiceDesc,
    
    dbo.AB_MentalHealth.MentalNumberECT AS NumberofECT, dbo.AB_Abstract.NurseAssessDate AS NursingAssessmentDate, 
    dbo.AB_Abstract.NurseAssessTime AS NursingAssessmentTime, Lookup98.DisplayCode AS Occupation, 
    Lookup98.UserDescription AS OccupationDesc, Lookup99.DisplayCode AS OtherMedicalDeath, Lookup99.UserDescription AS OtherMedicalDeathDesc, 
    Lookup100.DisplayCode AS OtherBlood, Lookup100.UserDescription AS OtherBloodDesc, Lookup101.DisplayCode AS OtherBloodCrossMatched, 
    Lookup101.UserDescription AS OtherBloodCrossMatchedDesc, Lookup102.DisplayCode AS OtherBloodTyped, 
    Lookup102.UserDescription AS OtherBloodTypedDesc, dbo.AB_Blood.OtherBloodUnits, Lookup148.DisplayCode AS PCTASIndicator, 
    Lookup148.UserDescription AS PCTASIndicatorDesc, dbo.AB_Abstract.PhysicianEstimatedLOS AS PhysicianEstLOS, 
    Lookup103.DisplayCode AS Plasma, Lookup103.UserDescription AS PlasmaDesc, Lookup104.DisplayCode AS PlasmaCrossMatched, 
    Lookup104.UserDescription AS PlasmaCrossMatchedDesc, Lookup105.DisplayCode AS PlasmaTyped, 
    Lookup105.UserDescription AS PlasmaTypedDesc, dbo.AB_Blood.PlasmaUnits, Lookup106.DisplayCode AS Platelets, 
    Lookup106.UserDescription AS PlateletsDesc, Lookup107.DisplayCode AS PlateletsCrossMatched, 
    Lookup107.UserDescription AS PlateletsCrossMatchedDesc, Lookup108.DisplayCode AS PlateletsTyped, 
    Lookup108.UserDescription AS PlateletsTypedDesc, dbo.AB_Blood.PlateletsUnits, dbo.AB_Abstract.PostalCode, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), dbo.AB_Abstract.AdmitDate) AS PostalCodeDesc, -- ED - 01682

    dbo.AB_Abstract.PostOpDays, dbo.AB_Abstract.PreOpDays, Lookup110.DisplayCode AS PreamditWorkUp, Lookup110.UserDescription AS PreamditWorkUpDesc, 
    Lookup111.DisplayCode AS Pregnancy, Lookup111.UserDescription AS PregnancyDesc, dbo.AB_ReproductiveCare.PrevLiveBirths AS PrevLiveBirth, 
    Lookup112.DisplayCode AS PreviousPsychiartricAdmissions, Lookup112.UserDescription AS PreviousPsychiartricAdmDesc, 
    Lookup113.DisplayCode AS Program, Lookup113.UserDescription AS ProgramDesc, Lookup118.DisplayCode AS ProvinceNumber, 
    Lookup118.UserDescription AS ProvinceNumberDesc, LUReasonForVisit.DisplayCode AS ReasonForVisit, 
    LUReasonForVisit.UserDescription AS ReasonForVisitDesc, dbo.AB_Abstract.ReAdmitCode, 
	--PR - 04577
	LU_ReciprocalBillingStatus.DisplayCode AS ReciprocalBillingStatus, LU_ReciprocalBillingStatus.UserDescription AS ReciprocalBillingStatusDesc,

    Lookup132.DisplayCode AS RedBloodCell, 
    Lookup132.UserDescription AS RedBloodCellDesc, Lookup133.DisplayCode AS RedBloodCellCrossMatched, 
    Lookup133.UserDescription AS RedBloodCellCrossMatchedDesc, Lookup134.DisplayCode AS RedBloodCellTyped, 
    Lookup134.UserDescription AS RedBloodCellTypedDesc, dbo.AB_Blood.RedCellUnits AS RedBloodCellUnits, dbo.AB_Abstract.ReferralDate, 
    Lookup135.DisplayCode AS ReferredFrom, Lookup135.UserDescription AS ReferredFromDesc, Lookup136.DisplayCode AS ReferredTo, 
    Lookup136.UserDescription AS ReferredToDesc, LU_RefProvider.DisplayCode AS ReferringProvider, 
    LU_RefProvider.UserDescription AS ReferringProviderDesc, dbo.AB_Abstract.RegisterNumber, 
    dbo.AB_Abstract.EncounterNumber AS RegistrationNumber, dbo.AB_Abstract.EncounterSequence AS RegistrationSequenceNumber, 
    dbo.AB_Abstract.AdmitDate AS RegistrationVisitDate, dbo.AB_Abstract.AdmitTime AS RegistrationVisitTime, 
    dbo.AB_ReproductiveCare.ReprodComments AS ReproductiveCareComments, dbo.AB_Abstract.Reserved AS ReserveField, 
    Lookup138.DisplayCode AS ResidenceCode, Lookup138.UserDescription AS ResidenceCodeDesc, 
    LUResidenceProvince.DisplayCode AS ResidenceProvince, LUResidenceProvince.UserDescription AS ResidenceProvinceDesc, 
    LUResidenceRegion.DisplayCode AS ResidenceRegion, LUResidenceRegion.UserDescription AS ResidenceRegionDesc, 
    Lookup139.DisplayCode AS ResidenceType, Lookup139.UserDescription AS ResidenceTypeDesc, 
    Lookup140.DisplayCode AS ResponsiblityForPayment, Lookup140.UserDescription AS ResponsiblityForPaymentDesc, 
    Lookup153.DisplayCode AS SchedEDVisit, Lookup153.UserDescription AS SchedEDVisitDesc, Lookup156.DisplayCode AS SeatbeltIndicator, 
    Lookup156.UserDescription AS SeatbeltIndicatorDesc, dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup141.DisplayCode AS SecretVIPPatient, Lookup141.UserDescription AS SecretVIPPatientDesc, Lookup142.DisplayCode AS SiteNumber, 
    Lookup142.UserDescription AS SiteNumberDesc, Lookup143.DisplayCode AS SocialService, Lookup143.UserDescription AS SocialServiceDesc, 
    Lookup144.DisplayCode AS SourceofReferral, Lookup144.UserDescription AS SourceofReferralDesc, 
	--ED-02091
	LU_SpecialistNumber.DisplayCode AS SpecialistNumber, LU_SpecialistNumber.UserDescription AS SpecialistNumberDesc,
	AB_NACRS.SpecialistRequestDate, 
	LU_SpecialistService.DisplayCode AS SpecialistRequestService, LU_SpecialistService.UserDescription AS SpecialistRequestServiceDesc,
	AB_NACRS.SpecialistRequestTime, 
	LU_SpecialistRequestTimeUnknown.DisplayCode AS SpecialistRequestTimeUnknown, LU_SpecialistRequestTimeUnknown.UserDescription AS SpecialistRequestTimeUnknownDesc,
    
    LU_StakeholderType.DisplayCode AS StakeholderType, LU_StakeholderType.UserDescription AS StakeholderTypeDesc, 
    --ED - 02289
    LU_StatusAfterTriage.DisplayCode as StatusAfterTriage, LU_StatusAfterTriage.UserDescription as StatusAfterTriageDesc,
    
    Lookup145.DisplayCode AS Sterilization, Lookup145.UserDescription AS SterilizationDesc, 

    SubmissionLevel as SubmissionLevelCode, --ED - 01910
    AbstractNumber as SubmissionRecordID,

    Lookup146.DisplayCode AS SubsequentOR, 
    Lookup146.UserDescription AS SubsequentORDesc, Lookup147.DisplayCode AS Suicide, Lookup147.UserDescription AS SuicideDesc, 
    LUSurgicalCase.DisplayCode AS SurgicalCase, LUSurgicalCase.UserDescription AS SurgicalCaseDesc, dbo.AB_Abstract.TimeLeftER, 
    LU_TimeLeftERUnknown.DisplayCode AS TimeLeftERUnknown, LU_TimeLeftERUnknown.UserDescription AS TimeLeftERUnknownDEsc, 
    dbo.AB_Abstract.TransferOverloadDate, dbo.AB_Abstract.TransferOverloadTime, 
    dbo.AB_Abstract.TransferOverloadDifference AS TransferOverloadTimeDifference, Lookup149.DisplayCode AS TransfusionGiven, 
    Lookup149.UserDescription AS TransfusionGivenDesc, Lookup150.DisplayCode AS Trauma, Lookup150.UserDescription AS TraumaDesc, 
    dbo.AB_Abstract.TriageDate, Lookup151.DisplayCode AS TriageLevel, Lookup151.UserDescription AS TriageLevelDesc, dbo.AB_Abstract.TriageTime, 
    LU_TriageTimeUnknown.DisplayCode AS TriageTimeUnknown, LU_TriageTimeUnknown.UserDescription AS TriageTimeUnknownDesc, 
    Lookup152.DisplayCode AS TSICoder, Lookup152.UserDescription AS TSICoderDesc, dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, 
    dbo.AB_DeathInformation.DeathTwoTenPO AS TwoTenPO, dbo.AB_Abstract.UniqiueLifetimeID AS ULI, 
    dbo.AB_Abstract.UnplanReAdmit AS UnplannedReadmit, Lookup154.DisplayCode AS VisitStatus, Lookup154.UserDescription AS VisitStatusDesc, 
    Lookup155.DisplayCode AS VisitType, Lookup155.UserDescription AS VisitTypeDesc, 
	dbo.AB_Abstract.UniversalEpisodeIdentifier,
	dbo.AB_Abstract.WaitTimeER AS WaitTimeinER, 
    dbo.AB_Abstract.WaitAssessmentDifference AS WaittoAssessmentinMinutes, dbo.AB_Abstract.NurseAssessDiff AS WaittoNursingAssessmentDiff, 
    dbo.AB_Abstract.Weight, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID, 
    dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TriageTimeUnknown with (nolock) on dbo.AB_Abstract.TriageTimeUnknown = LU_TriageTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_Provider LU_RefProvider with (nolock) on dbo.AB_Abstract.RefPhysician = LU_RefProvider.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TimeLeftERUnknown with (nolock) on dbo.AB_Abstract.TimeLeftERUnknown = LU_TimeLeftERUnknown.Code LEFT OUTER JOIN
    dbo.LU_Provider LU_AttendingPhysician with (nolock) on dbo.AB_Abstract.AttendingPhysician = LU_AttendingPhysician.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_StakeholderType with (nolock) on dbo.AB_Abstract.StakeHolder = LU_StakeholderType.Code LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LUCompleteRecord with (nolock) on dbo.AB_Abstract.CompleteRecord = LUCompleteRecord.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LUHelmetIndicator with (nolock) on dbo.AB_Abstract.HelmetIndicator = LUHelmetIndicator.Code LEFT OUTER JOIN
    dbo.LU_InjuryActivity Lookup2 with (nolock) on dbo.AB_Abstract.InjuryActivity = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup4 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_ArrivalMode Lookup22 with (nolock) on dbo.AB_Abstract.ArrivalMode = Lookup22.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup44 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup44.Code LEFT OUTER JOIN
    dbo.U_Users Lookup46 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_ContactMode Lookup50 with (nolock) on dbo.AB_Abstract.ContactMode = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup52 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup52.Code LEFT OUTER JOIN
    dbo.LU_TherDischPlan Lookup59 with (nolock) on dbo.AB_Abstract.DischargePlanning = Lookup59.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_A Lookup60 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_Education Lookup64 with (nolock) on dbo.AB_Abstract.EducationLevel = Lookup64.Code LEFT OUTER JOIN
    dbo.LU_FamilyPhysician Lookup67 with (nolock) on dbo.AB_Abstract.FamilyPhysician = Lookup67.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup69 with (nolock) on dbo.AB_Abstract.Gender = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup70 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup70.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup72 with (nolock) on dbo.AB_Abstract.Injury = Lookup72.Code LEFT OUTER JOIN
    
	dbo.LU_Institution_10 Lookup73 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup73.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionFrom_Type with (nolock) on dbo.AB_Abstract.InstitutionFromType = LU_InstitutionFrom_Type.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup74 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup74.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup75 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup75.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionTo_Type with (nolock) on dbo.AB_Abstract.InstitutionToType = LU_InstitutionTo_Type.Code LEFT OUTER JOIN

    dbo.LU_AbstractStatus Lookup83 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup84 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus Lookup85 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup86 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup86.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup87 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup87.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_IsCustomValidated with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_IsCustomValidated.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup88 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup88.Code LEFT OUTER JOIN
    dbo.LU_Language Lookup89 with (nolock) on dbo.AB_Abstract.LanguageCode = Lookup89.Code LEFT OUTER JOIN
    dbo.LU_LivingArrangement Lookup90 with (nolock) on dbo.AB_Abstract.LivingArrangement = Lookup90.Code LEFT OUTER JOIN
    dbo.LU_InjuryLocation Lookup91 with (nolock) on dbo.AB_Abstract.InjuryLocation = Lookup91.Code LEFT OUTER JOIN
    dbo.LU_MISCode Lookup93 with (nolock) on dbo.AB_Abstract.MISCode = Lookup93.Code LEFT OUTER JOIN
    
    --PR - 03012
    dbo.LU_CodeFile LU_AmCareType with (nolock) on Lookup93.AmCareType = LU_AmCareType.Code LEFT OUTER JOIN
    
    dbo.LU_MaritalStatus Lookup94 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup94.Code LEFT OUTER JOIN
    dbo.LU_Occupation Lookup98 with (nolock) on dbo.AB_Abstract.Occupation = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_TherPreAdmitWorkUp Lookup110 with (nolock) on dbo.AB_Abstract.PreAdmitWorkUp = Lookup110.Code LEFT OUTER JOIN
    dbo.LU_Program Lookup113 with (nolock) on dbo.AB_Abstract.Program = Lookup113.Code LEFT OUTER JOIN
    dbo.LU_Province Lookup118 with (nolock) on dbo.AB_Abstract.ProvinceNumber = Lookup118.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup135 with (nolock) on dbo.AB_Abstract.ReferredFrom = Lookup135.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup136 with (nolock) on dbo.AB_Abstract.ReferredTo = Lookup136.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup138 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup138.Code LEFT OUTER JOIN
    dbo.LU_Region LUResidenceRegion with (nolock) on Lookup138.RegionCode = LUResidenceRegion.Code LEFT OUTER JOIN
    dbo.LU_Province LUResidenceProvince with (nolock) on Lookup138.ProvinceCode = LUResidenceProvince.Code LEFT OUTER JOIN
    dbo.LU_ResidenceType Lookup139 with (nolock) on dbo.AB_Abstract.ResidenceType = Lookup139.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup140 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup140.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup141 with (nolock) on dbo.AB_Abstract.Secret = Lookup141.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup142 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup142.Code LEFT OUTER JOIN
    dbo.LU_TherSocialService Lookup143 with (nolock) on dbo.AB_Abstract.SocialService = Lookup143.Code LEFT OUTER JOIN
    dbo.LU_TriageLevel Lookup151 with (nolock) on dbo.AB_Abstract.TriageLevel = Lookup151.Code LEFT OUTER JOIN
    dbo.U_Users Lookup152 with (nolock) on dbo.AB_Abstract.TSICoder = Lookup152.Code LEFT OUTER JOIN
    dbo.LU_VisitType Lookup154 with (nolock) on dbo.AB_Abstract.VisitStatus = Lookup154.Code LEFT OUTER JOIN
    dbo.LU_VisitType_10 Lookup155 with (nolock) on dbo.AB_Abstract.VisitType = Lookup155.Code LEFT OUTER JOIN
    dbo.AB_Ancillary with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Ancillary.AbstractID LEFT OUTER JOIN
    dbo.LU_Ancillary1 Lookup8 with (nolock) on dbo.AB_Ancillary.AncillaryField1 = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_Ancillary10 Lookup9 with (nolock) on dbo.AB_Ancillary.AncillaryField10 = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_Ancillary11 Lookup10 with (nolock) on dbo.AB_Ancillary.AncillaryField11 = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_Ancillary12 Lookup11 with (nolock) on dbo.AB_Ancillary.AncillaryField12 = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Ancillary2 Lookup12 with (nolock) on dbo.AB_Ancillary.AncillaryField2 = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_Ancillary3 Lookup13 with (nolock) on dbo.AB_Ancillary.AncillaryField3 = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_Ancillary4 Lookup14 with (nolock) on dbo.AB_Ancillary.AncillaryField4 = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_Ancillary5 Lookup15 with (nolock) on dbo.AB_Ancillary.AncillaryField5 = Lookup15.Code LEFT OUTER JOIN
    dbo.LU_Ancillary6 Lookup16 with (nolock) on dbo.AB_Ancillary.AncillaryField6 = Lookup16.Code LEFT OUTER JOIN
    dbo.LU_Ancillary7 Lookup17 with (nolock) on dbo.AB_Ancillary.AncillaryField7 = Lookup17.Code LEFT OUTER JOIN
    dbo.LU_Ancillary8 Lookup18 with (nolock) on dbo.AB_Ancillary.AncillaryField8 = Lookup18.Code LEFT OUTER JOIN
    dbo.LU_Ancillary9 Lookup19 with (nolock) on dbo.AB_Ancillary.AncillaryField9 = Lookup19.Code LEFT OUTER JOIN
    dbo.AB_BasicOption with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_BasicOption.AbstractID LEFT OUTER JOIN
    dbo.LU_BasicOption1 Lookup25 with (nolock) on dbo.AB_BasicOption.BasicOption1 = Lookup25.Code LEFT OUTER JOIN
    dbo.LU_BasicOption10 Lookup26 with (nolock) on dbo.AB_BasicOption.BasicOption10 = Lookup26.Code LEFT OUTER JOIN
    dbo.LU_BasicOption11 Lookup27 with (nolock) on dbo.AB_BasicOption.BasicOption11 = Lookup27.Code LEFT OUTER JOIN
    dbo.LU_BasicOption12 Lookup28 with (nolock) on dbo.AB_BasicOption.BasicOption12 = Lookup28.Code LEFT OUTER JOIN
    dbo.LU_BasicOption13 Lookup29 with (nolock) on dbo.AB_BasicOption.BasicOption13 = Lookup29.Code LEFT OUTER JOIN
    dbo.LU_BasicOption14 Lookup30 with (nolock) on dbo.AB_BasicOption.BasicOption14 = Lookup30.Code LEFT OUTER JOIN
    dbo.LU_BasicOption15 Lookup31 with (nolock) on dbo.AB_BasicOption.BasicOption15 = Lookup31.Code LEFT OUTER JOIN
    dbo.LU_BasicOption16 Lookup32 with (nolock) on dbo.AB_BasicOption.BasicOption16 = Lookup32.Code LEFT OUTER JOIN
    dbo.LU_BasicOption17 Lookup33 with (nolock) on dbo.AB_BasicOption.BasicOption17 = Lookup33.Code LEFT OUTER JOIN
    dbo.LU_BasicOption18 Lookup34 with (nolock) on dbo.AB_BasicOption.BasicOption18 = Lookup34.Code LEFT OUTER JOIN
    dbo.LU_BasicOption19 Lookup35 with (nolock) on dbo.AB_BasicOption.BasicOption19 = Lookup35.Code LEFT OUTER JOIN
    dbo.LU_BasicOption2 Lookup36 with (nolock) on dbo.AB_BasicOption.BasicOption2 = Lookup36.Code LEFT OUTER JOIN
    dbo.LU_BasicOption3 Lookup37 with (nolock) on dbo.AB_BasicOption.BasicOption3 = Lookup37.Code LEFT OUTER JOIN
    dbo.LU_BasicOption4 Lookup38 with (nolock) on dbo.AB_BasicOption.BasicOption4 = Lookup38.Code LEFT OUTER JOIN
    dbo.LU_BasicOption5 Lookup39 with (nolock) on dbo.AB_BasicOption.BasicOption5 = Lookup39.Code LEFT OUTER JOIN
    dbo.LU_BasicOption6 Lookup40 with (nolock) on dbo.AB_BasicOption.BasicOption6 = Lookup40.Code LEFT OUTER JOIN
    dbo.LU_BasicOption7 Lookup41 with (nolock) on dbo.AB_BasicOption.BasicOption7 = Lookup41.Code LEFT OUTER JOIN
    dbo.LU_BasicOption8 Lookup42 with (nolock) on dbo.AB_BasicOption.BasicOption8 = Lookup42.Code LEFT OUTER JOIN
    dbo.LU_BasicOption9 Lookup43 with (nolock) on dbo.AB_BasicOption.BasicOption9 = Lookup43.Code LEFT OUTER JOIN
    dbo.AB_Blood with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Blood.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup5 with (nolock) on dbo.AB_Blood.Albumin = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup6 with (nolock) on dbo.AB_Blood.AlbuminXMatch = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup7 with (nolock) on dbo.AB_Blood.AlbuminTyped = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup23 with (nolock) on dbo.AB_Blood.AutoTransfusion = Lookup23.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup100 with (nolock) on dbo.AB_Blood.OtherBlood = Lookup100.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup101 with (nolock) on dbo.AB_Blood.OtherBloodXMatch = Lookup101.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup102 with (nolock) on dbo.AB_Blood.OtherBloodTyped = Lookup102.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup103 with (nolock) on dbo.AB_Blood.Plasma = Lookup103.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup104 with (nolock) on dbo.AB_Blood.PlasmaXMatch = Lookup104.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup105 with (nolock) on dbo.AB_Blood.PlasmaTyped = Lookup105.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup106 with (nolock) on dbo.AB_Blood.Platelets = Lookup106.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup107 with (nolock) on dbo.AB_Blood.PlateletsXMatch = Lookup107.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup108 with (nolock) on dbo.AB_Blood.PlateletsTyped = Lookup108.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup132 with (nolock) on dbo.AB_Blood.RedBloodCell = Lookup132.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup133 with (nolock) on dbo.AB_Blood.RedCellXMatch = Lookup133.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup134 with (nolock) on dbo.AB_Blood.RedCellTyped = Lookup134.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup149 with (nolock) on dbo.AB_Blood.TransfusionIndicator = Lookup149.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_AntithrombinIII with (nolock) on dbo.AB_Blood.AntithrombinIII = LU_AntithrombinIII.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_C1Inhibitor with (nolock) on dbo.AB_Blood.C1Inhibitor = LU_C1Inhibitor.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryoprecipitatePlasma with (nolock) on dbo.AB_Blood.CryoprecipitatePlasma = LU_CryoprecipitatePlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryosupernatantPlasma with (nolock) on dbo.AB_Blood.CryosupernatantPlasma = LU_CryosupernatantPlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_FEIBA with (nolock) on dbo.AB_Blood.FEIBA = LU_FEIBA.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_Fibrinogen with (nolock) on dbo.AB_Blood.Fibrinogen = LU_Fibrinogen.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_IVIG_SCIG with (nolock) on dbo.AB_Blood.IVIG_SCIG = LU_IVIG_SCIG.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_PCC with (nolock) on dbo.AB_Blood.PCC = LU_PCC.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_ProteinC_OtherFactors with (nolock) on dbo.AB_Blood.ProteinC_OtherFactors = LU_ProteinC_OtherFactors.Code LEFT OUTER JOIN

    dbo.AB_DeathInformation with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_DeathInformation.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup24 with (nolock) on dbo.AB_DeathInformation.AutopsyPerformed = Lookup24.Code LEFT OUTER JOIN
    dbo.LU_CoronerCase Lookup51 with (nolock) on dbo.AB_DeathInformation.CoronerCase = Lookup51.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup53 with (nolock) on dbo.AB_DeathInformation.DeathInER = Lookup53.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup54 with (nolock) on dbo.AB_DeathInformation.DeathOnArrival = Lookup54.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup58 with (nolock) on dbo.AB_DeathInformation.DeathInOR = Lookup58.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup99 with (nolock) on dbo.AB_DeathInformation.OtherDeath = Lookup99.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup111 with (nolock) on dbo.AB_DeathInformation.PregnancyDeath = Lookup111.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup150 with (nolock) on dbo.AB_DeathInformation.TraumaDeath = Lookup150.Code LEFT OUTER JOIN
    dbo.AB_MentalHealth with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_MentalHealth.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup1 with (nolock) on dbo.AB_MentalHealth.MentalAWOL = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_MentalLegalStatus Lookup45 with (nolock) on dbo.AB_MentalHealth.MentalLegalStatus = Lookup45.Code LEFT OUTER JOIN
    dbo.LU_MentalECTTreat Lookup61 with (nolock) on dbo.AB_MentalHealth.MentalECTTreatment = Lookup61.Code LEFT OUTER JOIN
    dbo.LU_MentalEducation Lookup63 with (nolock) on dbo.AB_MentalHealth.MentalEducation = Lookup63.Code LEFT OUTER JOIN
    dbo.LU_MentalEmployment Lookup65 with (nolock) on dbo.AB_MentalHealth.MentalEmployment = Lookup65.Code LEFT OUTER JOIN
    dbo.LU_MentalFinancial Lookup68 with (nolock) on dbo.AB_MentalHealth.MentalFinancial = Lookup68.Code LEFT OUTER JOIN
    dbo.LU_MentalAdmitMethod Lookup95 with (nolock) on dbo.AB_MentalHealth.MentalAdmitMethod = Lookup95.Code LEFT OUTER JOIN
    dbo.LU_MentalPrevPsych Lookup112 with (nolock) on dbo.AB_MentalHealth.MentalPrevPsych = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup137 with (nolock) on dbo.AB_MentalHealth.MentalReferralTo = Lookup137.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup144 with (nolock) on dbo.AB_MentalHealth.MentalReferralSource = Lookup144.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup147 with (nolock) on dbo.AB_MentalHealth.MentalSuicide = Lookup147.Code LEFT OUTER JOIN
	dbo.LU_MentalLegalStatusUponArrivalED with (nolock) on dbo.AB_MentalHealth.LegalStatusUponArrivaltoED = LU_MentalLegalStatusUponArrivalED.Code LEFT OUTER JOIN
	--dbo.LU_MentalLegalStatusAdmission with (nolock) on dbo.AB_MentalHealth.LegalStatusAtAdmission = LU_MentalLegalStatusAdmission.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_1 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint01 = LU_MentalTypeRestraint_1.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_1 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint01 = LU_MentalFrequencyRestraintUse_1.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_2 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint02 = LU_MentalTypeRestraint_2.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_2 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint02 = LU_MentalFrequencyRestraintUse_2.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_3 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint03 = LU_MentalTypeRestraint_3.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_3 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint03 = LU_MentalFrequencyRestraintUse_3.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_4 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint04 = LU_MentalTypeRestraint_4.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_4 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint04 = LU_MentalFrequencyRestraintUse_4.Code LEFT OUTER JOIN


    dbo.AB_ReproductiveCare with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_ReproductiveCare.AbstractID LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup47 with (nolock) on dbo.AB_ReproductiveCare.Complication1 = Lookup47.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup48 with (nolock) on dbo.AB_ReproductiveCare.Complication2 = Lookup48.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup49 with (nolock) on dbo.AB_ReproductiveCare.Complication3 = Lookup49.Code left join
    dbo.LU_ReprodOR Lookup71 with (nolock) on Lookup71.Code = dbo.AB_ReproductiveCare.InitialOR left join
    dbo.LU_YesBlank Lookup145 with (nolock) on Lookup145.Code = dbo.AB_ReproductiveCare.Sterilization LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup146 with (nolock) on dbo.AB_ReproductiveCare.SubsequentOR = Lookup146.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup148 with (nolock) on dbo.AB_Abstract.PCTASIndicator = Lookup148.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup153 with (nolock) on dbo.AB_Abstract.SchedEDVisit = Lookup153.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup156 with (nolock) on dbo.AB_Abstract.SeatbeltIndicator = Lookup156.Code AND Lookup156.LookupID = 2 LEFT OUTER JOIN
    dbo.LU_Glasgow Lookup157 with (nolock) on dbo.AB_Abstract.GlasgowComaScale = Lookup157.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup158 with (nolock) on dbo.AB_Abstract.DecisionAdmitTimeUnknown = Lookup158.Code AND Lookup158.LookupID = 1 LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup159 with (nolock) on dbo.AB_Abstract.AssessmentTimeUnknown = Lookup159.Code AND Lookup159.LookupID = 1 LEFT OUTER JOIN
    dbo.LU_AbstractOverflow with (nolock) on dbo.AB_Abstract.AbstractOverflow = dbo.LU_AbstractOverflow.Code LEFT OUTER JOIN
    dbo.LU_YesBlank LUSurgicalCase with (nolock) on dbo.AB_Abstract.SurgicalCase = LUSurgicalCase.Code LEFT OUTER JOIN
    dbo.LU_YesBlank LUComplication with (nolock) on dbo.AB_Abstract.Complication = LUComplication.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile10 LUReasonForVisit with (nolock) on dbo.AB_Abstract.ReasonForVisit = LUReasonForVisit.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LUDischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LUDischargeTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_AdmitNurse with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurse.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_DischargeNurse with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurse.Code LEFT OUTER JOIN
    --ED - 01910
    dbo.LU_CodeFile LU_AmbulanceArrTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceArrTimeUnknown = LU_AmbulanceArrTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AmbulanceTranTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceTranTimeUnknown = LU_AmbulanceTranTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_AccessPrimaryHealthCareCode with (nolock) on dbo.AB_Abstract.AccessCareCode = dbo.LU_AccessPrimaryHealthCareCode.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_CDUFlag with (nolock) on dbo.AB_Abstract.CDUFlag = LU_CDUFlag.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUInTimeUnknown with (nolock) on dbo.AB_Abstract.CDUInTimeUnknown = LU_CDUInTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUOutTimeUnknown with (nolock) on dbo.AB_Abstract.CDUOutTimeUnknown = LU_CDUOutTimeUnknown.Code LEFT OUTER JOIN
    --NP - 00125
    dbo.LU_CIHICorrect LU_Level1_Correction with (nolock) on dbo.AB_Abstract.IsCorrectLevel1 = LU_Level1_Correction.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_Level1_Submission with (nolock) on dbo.AB_Abstract.IsSubmitLevel1 = LU_Level1_Submission.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Validation with (nolock) on dbo.AB_Abstract.IsValidLevel1 = LU_Level1_Validation.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Completed with (nolock) on dbo.AB_Abstract.IsCompleteLevel1 = LU_Level1_Completed.Code 
--PR - 04577
    LEFT OUTER JOIN dbo.LU_ReciprocalBillingStatus with (nolock) on dbo.AB_Abstract.IsReciprocalBilling = LU_ReciprocalBillingStatus.Code 
--ED-02091 
	left join dbo.AB_NACRS with (nolock) on AB_Abstract.AbstractID = AB_NACRS.AbstractID
	left join dbo.LU_Provider LU_SpecialistNumber with (nolock) on AB_NACRS.SpecialistNumber = LU_SpecialistNumber.Code
	left join dbo.LU_ProviderSpecialty LU_SpecialistService with (nolock) on AB_NACRS.SpecialistService = LU_SpecialistService.Code
	left join dbo.LU_CodeFile LU_SpecialistRequestTimeUnknown with (nolock) on AB_NACRS.SpecialistRequestTimeUnknown = LU_SpecialistRequestTimeUnknown.Code
	left join dbo.LU_Provider LU_NonPhysicianNumber with (nolock) on AB_NACRS.NonPhysicianNumber = LU_NonPhysicianNumber.Code
	left join dbo.LU_ProviderSpecialty LU_NonPhysicianService with (nolock) on AB_NACRS.NonPhysicianService = LU_NonPhysicianService.Code
	left join dbo.LU_CodeFile LU_NonPhysicianAssessmentTimeUnknown with (nolock) on AB_NACRS.NonPhysicianAssessmentTimeUnknown = LU_NonPhysicianAssessmentTimeUnknown.Code
	
	left join dbo.LU_CodeFile LU_AmCareTypeCode with (nolock) on AB_NACRS.AmCareTypeCode = LU_AmCareTypeCode.Code
	left join dbo.LU_CodeFile LU_AmCareGroup with (nolock) on AB_NACRS.AmCareGroup = LU_AmCareGroup.Code
	--ED - 02130
	left join dbo.LU_CodeFile LU_AmCareTypeCode_FromMISCode with (nolock) on Lookup93.AmCareTypeCode = LU_AmCareTypeCode_FromMISCode.CIHIValue and LU_AmCareTypeCode_FromMISCode.LookUpID = 1101 and LU_AmCareTypeCode_FromMISCode.code between 203501 and 203513
	left join dbo.LU_CodeFile LU_AmCareGroup_FromMISCode with (nolock) on Lookup93.AmCareGroup = LU_AmCareGroup_FromMISCode.CIHIValue and LU_AmCareGroup_FromMISCode.LookUPID = 1102 and LU_AmCareGroup_FromMISCode.code between 203601 and 203605
    
    --ED - 02298
    left join dbo.LU_YesNoSystem LU_EDVisitIndicator with (nolock) on dbo.AB_NACRS.EDVisitIndicator = LU_EDVisitIndicator.Code
    left join dbo.LU_StatusAfterTriage with (nolock) on dbo.AB_NACRS.StatusAfterTriage = LU_StatusAfterTriage.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 105)
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))











' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_060_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_060_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    InpatientRehabilitation = LU_ProjectQuestion1.DisplayCode, InpatientRehabilitationDesc = LU_ProjectQuestion1.UserDescription, 
    InpatientRehabilitationFacilityNumber =  isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''') + isnull(LU_ProjectQuestion5.CIHIValue, '''')  + isnull(LU_ProjectQuestion6.CIHIValue, ''''), 
    InpatientRehabilitationFacilityNumberDesc = (select top 1 UserDescription from LU_Institution_10 where cihivalue = (LU_ProjectQuestion2.CIHIValue + LU_ProjectQuestion3.CIHIValue + LU_ProjectQuestion4.CIHIValue + LU_ProjectQuestion5.CIHIValue + LU_ProjectQuestion6.CIHIValue) order by validto desc), 

    HomeCareRehabilitation = LU_ProjectQuestion7.DisplayCode,HomeCareRehabilitationDesc = LU_ProjectQuestion7.UserDescription, 
    HomeCareRehabilitationLHINNumber = isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') + isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, ''''), 
    HomeCareRehabilitationLHINNumberDesc = (select top 1 UserDescription from LU_Institution_10 where cihivalue = (LU_ProjectQuestion8.CIHIValue + LU_ProjectQuestion9.CIHIValue +  LU_ProjectQuestion10.CIHIValue  + LU_ProjectQuestion11.CIHIValue  + LU_ProjectQuestion12.CIHIValue) order by validto desc), 

    OutpatientRehabilitation = LU_ProjectQuestion13.DisplayCode, OutpatientRehabilitationDesc = LU_ProjectQuestion13.UserDescription, 
    OutpatientRehabilitationFacilityNumber = isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, ''''),
    OutpatientRehabilitationFacilityNumberDesc = (select top 1 UserDescription from LU_Institution_10 where cihivalue = (isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')) order by validto desc), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''060'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_065_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_065_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    BundledCareType = (case when len(LU_ProjectQuestion1.CIHIValue) = 6 
                            then LU_ProjectQuestion1.CIHIValue                           
                            else isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''') + isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''')
                       end), 
    BundledCareTypeDesc = (case when len(LU_ProjectQuestion1.CIHIValue) = 6 
                            then LU_ProjectQuestion1.UserDescription                           
                            else ''''
                       end), 

    InpatientRehabilitation = isnull(LU_ProjectQuestion7.DisplayCode, ''''), 
    InpatientRehabilitationDesc = isnull(LU_ProjectQuestion7.UserDescription, ''''), 
    InpatientRehabilitationInstitutionNumber =  isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') + isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, ''''), 
    InpatientRehabilitationInstitutionNumberDesc = (select top 1 UserDescription from LU_Institution_10 where cihivalue = (''5'' + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') + isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''')) order by validto desc), 

    HomeCare = LU_ProjectQuestion12.DisplayCode,
    HomeCareRehabilitationDesc = LU_ProjectQuestion12.UserDescription, 
    HomeCareLHINNumber = isnull(LU_ProjectQuestion13.CIHIValue, '''') + isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, ''''), 
    HomeCareLHINNumberDesc = (select top 1 UserDescription from LU_Institution_10 where cihivalue = (''5'' + isnull(LU_ProjectQuestion13.CIHIValue, '''') + isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''')) order by validto desc), 

    OutpatientRehabilitation = isnull(p.Question17, ''''), 
    OutpatientRehabilitationDesc = (case p.Question17 when ''Y'' then ''Outpatient rehabilitation planned for the patient'' 
                                                      when ''N'' then ''Outpatient rehabilitation not planned for this patient''
                                                      when ''D'' then ''Declined''
                                                      when ''9'' then ''Unknown ''
                                                      else ''''
                                    end),
    OutpatientRehabilitationInstitutionNumber = isnull(p.Question18, '''') + isnull(p.Question19, '''') + isnull(p.Question20, '''') + isnull(p.Question21, ''''),
    OutpatientRehabilitationInstitutionNumberDesc = (select top 1 UserDescription from LU_Institution_10 where cihivalue = (''5'' + isnull(p.Question18, '''') + isnull(p.Question19, '''') + isnull(p.Question20, '''') + isnull(p.Question21, '''')) order by validto desc), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''065'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_100_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_100_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 
    LU_ProjectQuestion1.DisplayCode AS CompleteRecordFlag, LU_ProjectQuestion1.UserDescription AS CompleteRecordFlagDesc, 
    LU_ProjectQuestion2.DisplayCode AS RecordAvailable, LU_ProjectQuestion2.UserDescription AS RecordAvailableDesc, 
    LU_ProjectQuestion3.DisplayCode AS OperativeReportAvailable, LU_ProjectQuestion3.UserDescription AS OperativeReportAvailableDesc, 
    LU_ProjectQuestion7.DisplayCode AS RecordSubsequentlyReviewedAfterCompletion, LU_ProjectQuestion7.UserDescription AS RecordSubsequentlyReviewedAfterCompletionDesc, 
    LU_ProjectQuestion8.DisplayCode AS DataChangedFromOriginalSubmission, LU_ProjectQuestion8.UserDescription AS DataChangedFromOriginalSubmissionDesc, 
    LU_ProjectQuestion9.DisplayCode AS PathologyReportAvailable, LU_ProjectQuestion9.UserDescription AS PathologyReportAvailableDesc, 
    DateofSubsequentReview = (case when Admitdate < ''2009/04/01'' or ProjectNumber = 3 then dbo.ConvertToDate(LU_ProjectQuestion13.CIHIValue + p.Question14 + p.Question15 + p.Question16 + p.Question17 + p.Question18 + p.Question19 + p.Question20)
                                   else dbo.ConvertToDate(LU_ProjectQuestion13.CIHIValue + p.Question21 + p.Question22 + p.Question23 + p.Question24 + p.Question16 + p.Question17 + p.Question14 + p.Question15)
                             end),
    DateofSubsequentReview_InValidate = (case when Admitdate < ''2009/04/01'' or ProjectNumber = 3 then dbo.CheckInvalidateDate(LU_ProjectQuestion13.CIHIValue + p.Question14 + p.Question15 + p.Question16 + p.Question17 + p.Question18 + p.Question19 + p.Question20)
                                              else dbo.CheckInvalidateDate(LU_ProjectQuestion13.CIHIValue + p.Question21 + p.Question22 + p.Question23 + p.Question24 + p.Question16 + p.Question17 + p.Question14 + p.Question15)
                                         end),
    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion4  with (nolock) on dbo.AB_Project.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion5  with (nolock) on dbo.AB_Project.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion6  with (nolock) on dbo.AB_Project.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion11 with (nolock) on dbo.AB_Project.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion12 with (nolock) on dbo.AB_Project.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE  AdmitDate > ''2006/03/31'' and LU_Project.CIHIValue = ''100'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_150_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_150_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 
    InterventionLineNumber = LU_ProjectQuestion1.CIHIValue + LU_ProjectQuestion1.CIHIValue, 
    DateCompletedReferralReceived = dbo.ConvertToDate(LU_ProjectQuestion1.CIHIValue + LU_ProjectQuestion2.CIHIValue + LU_ProjectQuestion3.CIHIValue + LU_ProjectQuestion4.CIHIValue + LU_ProjectQuestion5.CIHIValue + LU_ProjectQuestion6.CIHIValue + LU_ProjectQuestion7.CIHIValue + LU_ProjectQuestion8.CIHIValue + LU_ProjectQuestion9.CIHIValue + LU_ProjectQuestion10.CIHIValue),
    TypeOfSeverityPriorityUrgencyScoreUsed = LU_ProjectQuestion11.DisplayCode, TypeOfSeverityPriorityUrgencyScoreUsedDesc = LU_ProjectQuestion2.UserDescription, 
    SeverityPriorityUrgencyScore = isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') + isnull(p.Question14, '''') + isnull(p.Question15, ''''),
    DateType = p.Question16,
    OtherDate = dbo.ConvertToTime(p.Question17 + p.Question18 + p.Question19 + p.Question20 + p.Question21 + p.Question22 + p.Question23 + p.Question24), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''150'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = (5))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_202_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_202_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 
    Kidneys = LU_ProjectQuestion1.DisplayCode, KidneysDesc = LU_ProjectQuestion1.UserDescription, 
    Liver = LU_ProjectQuestion2.DisplayCode, LiverDesc = LU_ProjectQuestion2.UserDescription, 
    Heart = LU_ProjectQuestion3.DisplayCode, HeartDesc = LU_ProjectQuestion3.UserDescription, 
    Pancreas = LU_ProjectQuestion4.DisplayCode, PancreascDesc = LU_ProjectQuestion4.UserDescription, 
    PancreaticIsletCells = LU_ProjectQuestion5.DisplayCode, PancreaticIsletCellsDesc = LU_ProjectQuestion5.UserDescription, 
    Heartvalves = LU_ProjectQuestion6.DisplayCode, HeartvalvesDesc = LU_ProjectQuestion6.UserDescription, 
    Bowel = LU_ProjectQuestion7.DisplayCode, BowelDesc = LU_ProjectQuestion7.UserDescription, 
    Cornea = LU_ProjectQuestion8.DisplayCode, CorneaDesc = LU_ProjectQuestion8.UserDescription, 
    Skin = LU_ProjectQuestion9.DisplayCode, SkinDesc = LU_ProjectQuestion9.UserDescription, 
    Bone = LU_ProjectQuestion10.DisplayCode, BoneDesc = LU_ProjectQuestion10.UserDescription, 
    Other = LU_ProjectQuestion11.DisplayCode, OtherDesc = LU_ProjectQuestion11.UserDescription, 
    Lung = LU_ProjectQuestion13.DisplayCode, LungDesc = LU_ProjectQuestion13.UserDescription, 
   
    HoursBetweenDeathAndHarvesting = isnull(p.Question14, '''') + isnull(p.Question15, ''''),
    NumberOfOrgansIssueRetrieveved = isnull(p.Question16, '''') + isnull(p.Question17, ''''),
    ORTime = isnull(p.Question18, '''') + isnull(p.Question19, '''') + isnull(p.Question20, ''''),

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''202'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_250_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_250_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    MetalStent = LU_ProjectQuestion1.DisplayCode, MetalStentDesc = LU_ProjectQuestion1.UserDescription, 
    NumberEsophagealPolyps =  cast((case when isnumeric(isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''')) = 1 then isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') end) as int), 
    NumberStomachPolyps =  cast((case when isnumeric(isnull(LU_ProjectQuestion4.CIHIValue, '''') + isnull(LU_ProjectQuestion5.CIHIValue, '''')) = 1 then isnull(LU_ProjectQuestion4.CIHIValue, '''') + isnull(LU_ProjectQuestion5.CIHIValue, '''') end) as int), 
    NumberSmallIntestinePolyps =  cast((case when isnumeric(isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''')) = 1 then isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') end) as int), 
    NumberLargeIntestinePolyps =  cast((case when isnumeric(isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''')) = 1 then isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') end) as int), 
    NumberRectalPolyps =  cast((case when isnumeric(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''')) = 1 then isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') end) as int), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code 
    --dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''250'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_315_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[I10_Amcare_Projects_315_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    NumberMetalStents_Esophagus      = LU_ProjectQuestion1.CIHIValue,
    NumberMetalStents_SmallIntestine = LU_ProjectQuestion2.CIHIValue,
    NumberMetalStents_LargeIntestine = LU_ProjectQuestion3.CIHIValue,
    NumberMetalStents_Rectum         = LU_ProjectQuestion4.CIHIValue,
    NumberMetalStents_BileDucts      = LU_ProjectQuestion5.CIHIValue,

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code 
    --dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''315'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_316_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'create VIEW [dbo].[I10_Amcare_Projects_316_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    SizeLargestExcisedPolyp = (case when isnumeric(ltrim(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, ''''))) = 1 then cast(ltrim(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''')) as int) end),
    NumberPolypsMediumExcised = (case when isnumeric(ltrim(isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, ''''))) = 1 then cast(ltrim(isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''')) as int) end),

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code --LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''316'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_340_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_340_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 
    LU_ProjectQuestion1.DisplayCode AS CT_MRIScanWithin24HoursEDArrival, LU_ProjectQuestion1.UserDescription AS CT_MRIScanWithin24HoursEDArrivalDesc, 
    LU_ProjectQuestion2.DisplayCode AS ReferralToStrokePreventionServicesEDDischarge, LU_ProjectQuestion2.UserDescription AS ReferralToStrokePreventionServicesEDDischargeDesc, 
    LU_ProjectQuestion3.DisplayCode AS AdministrationAcuteThrombolysis, LU_ProjectQuestion3.UserDescription AS AdministrationAcuteThrombolysisDesc, 
    MonthOfAcuteThrombolysisAdministration = isnull(LU_ProjectQuestion4.CIHIValue, '''') + isnull(LU_ProjectQuestion5.CIHIValue, ''''),
    DayOfAcuteThrombolysisAdministration = isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, ''''),
    HourOfAcuteThrombolysisAdministration = isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, ''''),
    MinuteOfAcuteThrombolysisAdministration = isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, ''''),
    
    LU_ProjectQuestion12.DisplayCode AS PrescriptionForAntithromboticMedicationDischarge, LU_ProjectQuestion12.UserDescription AS PrescriptionForAntithromboticMedicationDischargeDesc, 

    StrokeSymptomOnsetDate = dbo.ConvertToDate(LU_ProjectQuestion13.CIHIValue + p.Question14 + p.Question15 + p.Question16 + p.Question17 + p.Question18 + p.Question19 + p.Question20),
    StrokeSymptomOnsetDateUnknown = dbo.CheckUnknownDate(LU_ProjectQuestion13.CIHIValue + p.Question14 + p.Question15 + p.Question16 + p.Question17 + p.Question18 + p.Question19 + p.Question20),

    StrokeSymptomOnsetTime = dbo.ConvertToTime(p.Question21 + p.Question22 + p.Question23 + p.Question24),
    StrokeSymptomOnsetTimeUnknown = dbo.CheckUnknownTime(p.Question21 + p.Question22 + p.Question23 + p.Question24),

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE AdmitDate > ''2010/03/31'' and LU_Project.CIHIValue = ''340'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = (5))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_640_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_640_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 
    LU_ProjectQuestion1.DisplayCode AS DysphagiaScreening, LU_ProjectQuestion1.UserDescription AS DysphagiaScreeningDesc, 
    LU_ProjectQuestion2.DisplayCode AS TelestrokeConsultation, LU_ProjectQuestion2.UserDescription AS TelestrokeConsultationDesc, 
    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code 
WHERE AdmitDate > ''2015/03/31'' and LU_Project.CIHIValue = ''640'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_740_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_740_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 
    LU_ProjectQuestion1.DisplayCode AS DocumentationAlphaFIM, LU_ProjectQuestion1.UserDescription AS DocumentationAlphaFIMDesc, 

    (case when isdate(LU_ProjectQuestion2.DisplayCode + LU_ProjectQuestion3.DisplayCode + LU_ProjectQuestion4.DisplayCode + LU_ProjectQuestion5.DisplayCode + ''/'' + LU_ProjectQuestion6.DisplayCode + LU_ProjectQuestion7.DisplayCode + ''/'' + LU_ProjectQuestion8.DisplayCode + LU_ProjectQuestion9.DisplayCode) = 1
          then   cast(LU_ProjectQuestion2.DisplayCode + LU_ProjectQuestion3.DisplayCode + LU_ProjectQuestion4.DisplayCode + LU_ProjectQuestion5.DisplayCode + ''/'' + LU_ProjectQuestion6.DisplayCode + LU_ProjectQuestion7.DisplayCode + ''/'' + LU_ProjectQuestion8.DisplayCode + LU_ProjectQuestion9.DisplayCode as datetime)
          else null
     end) AS AlphaFIMScoreCompletionDate, 

    isnull(LU_ProjectQuestion10.DisplayCode, '''') + isnull(LU_ProjectQuestion11.DisplayCode, '''') as ProjectFIMRawMotorRating,
    isnull(LU_ProjectQuestion12.DisplayCode, '''') + isnull(LU_ProjectQuestion13.DisplayCode, '''') as ProjectFIMRawCognitiveRating,

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE AdmitDate > ''2013/03/31'' and LU_Project.CIHIValue = ''740'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_960_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_960_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    DateOfFirstVisit = (case when isdate(LU_ProjectQuestion1.CIHIValue + LU_ProjectQuestion2.CIHIValue + LU_ProjectQuestion3.CIHIValue + LU_ProjectQuestion4.CIHIValue + LU_ProjectQuestion5.CIHIValue + LU_ProjectQuestion6.CIHIValue + LU_ProjectQuestion7.CIHIValue + LU_ProjectQuestion8.CIHIValue) = 1 then cast(LU_ProjectQuestion1.CIHIValue + LU_ProjectQuestion2.CIHIValue + LU_ProjectQuestion3.CIHIValue + LU_ProjectQuestion4.CIHIValue + LU_ProjectQuestion5.CIHIValue + LU_ProjectQuestion6.CIHIValue + LU_ProjectQuestion7.CIHIValue + LU_ProjectQuestion8.CIHIValue as datetime) end), 
    ReasonForDischarge =  LU_ProjectQuestion9.DisplayCode, ReasonForDischargeDesc = LU_ProjectQuestion9.UserDescription, 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code --LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code 
    --dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''960'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_961_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_961_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    Surgical_NonSurgicalStatus   =  LU_ProjectQuestion1.DisplayCode, Surgical_NonSurgicalStatusDesc = LU_ProjectQuestion1.UserDescription, 
    Traumatic_NonTraumaticStatus =  LU_ProjectQuestion2.DisplayCode, Traumatic_NonTraumaticStatusDesc = LU_ProjectQuestion2.UserDescription, 
    ExtremityInvolvement         =  LU_ProjectQuestion3.DisplayCode, ExtremityInvolvementDesc = LU_ProjectQuestion3.UserDescription, 
    HipFractureSurgicalStatus    =  LU_ProjectQuestion4.DisplayCode, HipFractureSurgicalStatusDesc = LU_ProjectQuestion4.UserDescription, 
    KneeHipReplacementPrimaryRevision  =  LU_ProjectQuestion5.DisplayCode, KneeHipReplacementPrimaryRevisionDesc  = LU_ProjectQuestion5.UserDescription, 
    BurnsPercentTotalBodySurfaceArea   =  LU_ProjectQuestion6.DisplayCode, BurnsPercentTotalBodySurfaceAreaDesc   = LU_ProjectQuestion6.UserDescription, 
    BilateralUpperLimbAmputationLevels =  LU_ProjectQuestion7.DisplayCode, BilateralUpperLimbAmputationLevelsDesc = LU_ProjectQuestion7.UserDescription, 
    BilateralLowerLimbAmputationLevels =  LU_ProjectQuestion8.DisplayCode, BilateralLowerLimbAmputationLevelsDesc = LU_ProjectQuestion8.UserDescription, 
    DementiainNeurological             =  LU_ProjectQuestion9.DisplayCode, DementiainNeurologicalDesc             = LU_ProjectQuestion9.UserDescription, 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code --LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code 
    --dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    --dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''961'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_962_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_962_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    TotalVisits_RegisteredNurse =  cast((case when isnumeric(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''')) = 1 
											  then isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''') 
										end) as int), 
	TotalVisits_RegisteredNurseAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, ''''))),

	ServiceDuration_RegisteredNurse =  cast((case when isnumeric(isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''')) = 1 
												 then isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') 
										     end) as int), 

    TotalVisits_RegisteredPracticalNurse =  cast((case when isnumeric(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''')) = 1 
											           then isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') 
												  end) as int), 
	TotalVisits_RegisteredPracticalNurseAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') )),

	ServiceDuration_RegisteredPracticalNurse =  cast((case when isnumeric(isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')) = 1 
												           then isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')
										              end) as int), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''962'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_963_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_963_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    TotalVisits_OccupationalTherapist =  cast((case when isnumeric(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''')) = 1 
											  then isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''') 
										end) as int), 
	TotalVisits_OccupationalTherapistAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, ''''))),

	ServiceDuration_OccupationalTherapist =  cast((case when isnumeric(isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''')) = 1 
												 then isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') 
										     end) as int), 

    TotalVisits_OccupationalTherapyAssistant =  cast((case when isnumeric(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''')) = 1 
											           then isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') 
												  end) as int), 
	TotalVisits_OccupationalTherapyAssistantAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') )),

	ServiceDuration_OccupationalTherapyAssistant =  cast((case when isnumeric(isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')) = 1 
												           then isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')
										              end) as int), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''963'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_964_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_964_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    TotalVisits_Physiotherapist =  cast((case when isnumeric(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''')) = 1 
											  then isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''') 
										end) as int), 
	TotalVisits_PhysiotherapistAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, ''''))),

	ServiceDuration_Physiotherapist =  cast((case when isnumeric(isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''')) = 1 
												 then isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') 
										     end) as int), 

    TotalVisits_PhysiotherapyAssistant =  cast((case when isnumeric(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''')) = 1 
											           then isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') 
												  end) as int), 
	TotalVisits_PhysiotherapyAssistantAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') )),

	ServiceDuration_PhysiotherapyAssistant =  cast((case when isnumeric(isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')) = 1 
												           then isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')
										              end) as int), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''964'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_965_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_965_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    TotalVisits_SpeechLanguagePathologist =  cast((case when isnumeric(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''')) = 1 
											  then isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''') 
										end) as int), 
	TotalVisits_SpeechLanguagePathologistAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, ''''))),

	ServiceDuration_SpeechLanguagePathologist =  cast((case when isnumeric(isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''')) = 1 
												 then isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') 
										     end) as int), 

    TotalVisits_CommunicationDisordersAssistant =  cast((case when isnumeric(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''')) = 1 
											           then isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') 
												  end) as int), 
	TotalVisits_CommunicationDisordersAssistantAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') )),

	ServiceDuration_CommunicationDisordersAssistant =  cast((case when isnumeric(isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')) = 1 
												           then isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')
										              end) as int), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''965'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_966_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_Amcare_Projects_966_VR]
AS
SELECT     
    LU_Project.DisplayCode AS ProjectNumber, LU_Project.UserDescription AS ProjectNumberDesc, 
    p.ProjectOccurrence, 

    TotalVisits_SocialWorker =  cast((case when isnumeric(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''')) = 1 
										   then isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, '''') 
									  end) as int), 
	TotalVisits_SocialWorkerAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion1.CIHIValue, '''') + isnull(LU_ProjectQuestion2.CIHIValue, '''') + isnull(LU_ProjectQuestion3.CIHIValue, '''') + isnull(LU_ProjectQuestion4.CIHIValue, ''''))),

	ServiceDuration_SocialWorker =  cast((case when isnumeric(isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''')) = 1 
											   then isnull(LU_ProjectQuestion5.CIHIValue, '''') + isnull(LU_ProjectQuestion6.CIHIValue, '''') + isnull(LU_ProjectQuestion7.CIHIValue, '''') + isnull(LU_ProjectQuestion8.CIHIValue, '''') + isnull(LU_ProjectQuestion9.CIHIValue, '''') 
										  end) as int), 

    TotalVisits_Other =  cast((case when isnumeric(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''')) = 1 
									then isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') 
							   end) as int), 
	TotalVisits_OtherAlpha = ltrim(rtrim(isnull(LU_ProjectQuestion10.CIHIValue, '''') + isnull(LU_ProjectQuestion11.CIHIValue, '''') + isnull(LU_ProjectQuestion12.CIHIValue, '''') + isnull(LU_ProjectQuestion13.CIHIValue, '''') )),

	ServiceDuration_Other =  cast((case when isnumeric(isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')) = 1 
										then isnull(p.Question14, '''') + isnull(p.Question15, '''') + isnull(p.Question16, '''') + isnull(p.Question17, '''') + isnull(p.Question18, '''')
								   end) as int), 

    p.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.AB_Project p with (nolock) on p.AbstractID = dbo.AB_Abstract.AbstractID inner JOIN
    dbo.LU_Project with (nolock) on p.ProjectNumber = LU_Project.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1  with (nolock) on p.Question1 = LU_ProjectQuestion1.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2  with (nolock) on p.Question2 = LU_ProjectQuestion2.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3  with (nolock) on p.Question3 = LU_ProjectQuestion3.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4  with (nolock) on p.Question4 = LU_ProjectQuestion4.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5  with (nolock) on p.Question5 = LU_ProjectQuestion5.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6  with (nolock) on p.Question6 = LU_ProjectQuestion6.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7  with (nolock) on p.Question7 = LU_ProjectQuestion7.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8  with (nolock) on p.Question8 = LU_ProjectQuestion8.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9  with (nolock) on p.Question9 = LU_ProjectQuestion9.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 with (nolock) on p.Question10 = LU_ProjectQuestion10.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 with (nolock) on p.Question11 = LU_ProjectQuestion11.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 with (nolock) on p.Question12 = LU_ProjectQuestion12.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 with (nolock) on p.Question13 = LU_ProjectQuestion13.Code 
WHERE LU_Project.CIHIValue = ''966'' and (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_Question_24_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[I10_Amcare_Projects_Question_24_VR]
AS
SELECT     
    Lookup115.DisplayCode AS ProjectNumber, Lookup115.UserDescription AS ProjectNumberDesc, 
    dbo.AB_Project.ProjectOccurrence, 
    Lookup120.DisplayCode AS Question1, Lookup120.UserDescription AS Question1Desc, 
    Lookup125.DisplayCode AS Question2, Lookup125.UserDescription AS Question2Desc, 
    Lookup126.DisplayCode AS Question3, Lookup126.UserDescription AS Question3Desc, 
    Lookup127.DisplayCode AS Question4, Lookup127.UserDescription AS Question4Desc, 
    Lookup128.DisplayCode AS Question5, Lookup128.UserDescription AS Question5Desc, 
    Lookup129.DisplayCode AS Question6, Lookup129.UserDescription AS Question6Desc, 
    Lookup130.DisplayCode AS Question7, Lookup130.UserDescription AS Question7Desc, 
    Lookup131.DisplayCode AS Question8, Lookup131.UserDescription AS Question8Desc, 
    Lookup132.DisplayCode AS Question9, Lookup132.UserDescription AS Question9Desc, 
    Lookup121.DisplayCode AS Question10, Lookup121.UserDescription AS Question10Desc, 
    Lookup122.DisplayCode AS Question11, Lookup122.UserDescription AS Question11Desc, 
    Lookup123.DisplayCode AS Question12, Lookup123.UserDescription AS Question12Desc, 
    Lookup124.DisplayCode AS Question13, Lookup124.UserDescription AS Question13Desc, 
    dbo.AB_Project.Question14, 
    dbo.AB_Project.Question15, 
    dbo.AB_Project.Question16, 
    dbo.AB_Project.Question17, 
    dbo.AB_Project.Question18, 
    dbo.AB_Project.Question19, 
    dbo.AB_Project.Question20, 
    dbo.AB_Project.Question21, 
    dbo.AB_Project.Question22, 
    dbo.AB_Project.Question23, 
    dbo.AB_Project.Question24, 
    dbo.AB_Project.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) left OUTER JOIN
    dbo.AB_Project with (nolock) on dbo.AB_Project.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_Project Lookup115 with (nolock) on dbo.AB_Project.ProjectNumber = Lookup115.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1 Lookup120 with (nolock) on dbo.AB_Project.Question1 = Lookup120.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 Lookup121 with (nolock) on dbo.AB_Project.Question10 = Lookup121.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 Lookup122 with (nolock) on dbo.AB_Project.Question11 = Lookup122.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 Lookup123 with (nolock) on dbo.AB_Project.Question12 = Lookup123.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 Lookup124 with (nolock) on dbo.AB_Project.Question13 = Lookup124.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2 Lookup125 with (nolock) on dbo.AB_Project.Question2 = Lookup125.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3 Lookup126 with (nolock) on dbo.AB_Project.Question3 = Lookup126.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4 Lookup127 with (nolock) on dbo.AB_Project.Question4 = Lookup127.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5 Lookup128 with (nolock) on dbo.AB_Project.Question5 = Lookup128.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6 Lookup129 with (nolock) on dbo.AB_Project.Question6 = Lookup129.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7 Lookup130 with (nolock) on dbo.AB_Project.Question7 = Lookup130.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8 Lookup131 with (nolock) on dbo.AB_Project.Question8 = Lookup131.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9 Lookup132 with (nolock) on dbo.AB_Project.Question9 = Lookup132.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)










' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Projects_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[I10_Amcare_Projects_VR]
AS
SELECT     
    Lookup115.DisplayCode AS ProjectNumber, Lookup115.UserDescription AS ProjectNumberDesc, 
    dbo.AB_Project.ProjectOccurrence, 
    Lookup120.DisplayCode AS Question1, Lookup120.UserDescription AS Question1Desc, 
    Lookup125.DisplayCode AS Question2, Lookup125.UserDescription AS Question2Desc, 
    Lookup126.DisplayCode AS Question3, Lookup126.UserDescription AS Question3Desc, 
    Lookup127.DisplayCode AS Question4, Lookup127.UserDescription AS Question4Desc, 
    Lookup128.DisplayCode AS Question5, Lookup128.UserDescription AS Question5Desc, 
    Lookup129.DisplayCode AS Question6, Lookup129.UserDescription AS Question6Desc, 
    Lookup130.DisplayCode AS Question7, Lookup130.UserDescription AS Question7Desc, 
    Lookup131.DisplayCode AS Question8, Lookup131.UserDescription AS Question8Desc, 
    Lookup132.DisplayCode AS Question9, Lookup132.UserDescription AS Question9Desc, 
    Lookup121.DisplayCode AS Question10, Lookup121.UserDescription AS Question10Desc, 
    Lookup122.DisplayCode AS Question11, Lookup122.UserDescription AS Question11Desc, 
    Lookup123.DisplayCode AS Question12, Lookup123.UserDescription AS Question12Desc, 
    Lookup124.DisplayCode AS Question13, Lookup124.UserDescription AS Question13Desc, 
    Question14 = isnull(dbo.AB_Project.Question14, '''') + isnull(dbo.AB_Project.Question15, ''''), 
    Question15 = isnull(dbo.AB_Project.Question16, '''') + isnull(dbo.AB_Project.Question17, ''''), 
    Question16 = isnull(dbo.AB_Project.Question18, '''') + isnull(dbo.AB_Project.Question19, '''') + isnull(dbo.AB_Project.Question20, ''''), 
    Question17 = isnull(dbo.AB_Project.Question21, '''') + isnull(dbo.AB_Project.Question22, '''') + isnull(dbo.AB_Project.Question23, '''') + isnull(dbo.AB_Project.Question24, ''''), 
    --dbo.AB_Project.Question18, 
    --dbo.AB_Project.Question19, 
    --dbo.AB_Project.Question20, 
    --dbo.AB_Project.Question21, 
    --dbo.AB_Project.Question22, 
    --dbo.AB_Project.Question23, 
    --dbo.AB_Project.Question24, 
    dbo.AB_Project.AbstractID AS zzAbstractLink
FROM          
    dbo.AB_Abstract with (nolock) left OUTER JOIN
    dbo.AB_Project with (nolock) on dbo.AB_Project.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_Project Lookup115 with (nolock) on dbo.AB_Project.ProjectNumber = Lookup115.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion1 Lookup120 with (nolock) on dbo.AB_Project.Question1 = Lookup120.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion10 Lookup121 with (nolock) on dbo.AB_Project.Question10 = Lookup121.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion11 Lookup122 with (nolock) on dbo.AB_Project.Question11 = Lookup122.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion12 Lookup123 with (nolock) on dbo.AB_Project.Question12 = Lookup123.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion13 Lookup124 with (nolock) on dbo.AB_Project.Question13 = Lookup124.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion2 Lookup125 with (nolock) on dbo.AB_Project.Question2 = Lookup125.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion3 Lookup126 with (nolock) on dbo.AB_Project.Question3 = Lookup126.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion4 Lookup127 with (nolock) on dbo.AB_Project.Question4 = Lookup127.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion5 Lookup128 with (nolock) on dbo.AB_Project.Question5 = Lookup128.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion6 Lookup129 with (nolock) on dbo.AB_Project.Question6 = Lookup129.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion7 Lookup130 with (nolock) on dbo.AB_Project.Question7 = Lookup130.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion8 Lookup131 with (nolock) on dbo.AB_Project.Question8 = Lookup131.Code LEFT OUTER JOIN
    dbo.LU_ProjectQuestion9 Lookup132 with (nolock) on dbo.AB_Project.Question9 = Lookup132.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)









' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_Providers_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[I10_Amcare_Providers_VR]
AS
SELECT     dbo.AB_Provider.ProviderArriveDate AS ProviderArrivedDate, dbo.AB_Provider.ProviderArriveTime AS ProviderArrivedTime, 
                      dbo.AB_Provider.ProviderCallDate AS ProviderCalledDate, dbo.AB_Provider.ProviderCallTime AS ProviderCalledTime, 
                      Lookup116.DisplayCode AS ProviderNumber, Lookup116.UserDescription AS ProviderNumberDesc, dbo.AB_Provider.ProviderOccurrence, 
                      dbo.AB_Provider.ProviderService, Lookup117.DisplayCode AS ProviderSpecialty, Lookup117.UserDescription AS ProviderSpecialtyDesc, 
                      dbo.AB_Provider.ProviderTotalTime, Lookup118.DisplayCode AS ProviderType, Lookup118.UserDescription AS ProviderTypeDesc, 
                      dbo.AB_Provider.AbstractID AS zzAbstractLink
FROM           
    dbo.AB_Abstract with (nolock) left OUTER JOIN
    dbo.AB_Provider with (nolock) ON dbo.AB_Provider.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.LU_Provider Lookup116 with (nolock) ON dbo.AB_Provider.ProviderNumber = Lookup116.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty Lookup117 with (nolock) ON dbo.AB_Provider.ProviderSpecialty = Lookup117.Code LEFT OUTER JOIN
    dbo.LU_ProviderType Lookup118 with (nolock) ON dbo.AB_Provider.ProviderType = Lookup118.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5) AND (dbo.AB_Provider.ProviderOccurrence IS NOT NULL)







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE view [dbo].[I10_Amcare_statistic_Reporting]
as
select aa.InstitutionNumber, InstitutionNumbereDesc, aa.BatchYear, aa.BatchPeriod, 
	AmCareGroup, AmCareGroupDesc,
	TotalRecords = TotalSubmitted + TotalSubmitted_None,
	TotalSubmitted,
	TotalSubmitted_None,

	Total_Emergency, Total_Emergency_Submitted,
	Total_UCC, Total_UCC_Submitted,
	Total_ED_MentalHealth, Total_ED_MentalHealth_Submitted,

	Total_DaySurgical, Total_DaySurgical_Submitted,
	Total_Endoscopy, Total_Endoscopy_Submitted
	Total_Cystoscopy, Total_Cystoscopy_Submitted,
	
	Total_Clinic, Total_Clinic_Submitted,
	Total_CardiacCatheterization, Total_CardiacCatheterization_Submitted,
	Total_Oncology, Total_Oncology_Submitted,
	--Total_CancerCareOntario, TotalCancerCareOntario_Submitted,
	Total_RenalDialysis, Total_RenalDialysis_Submitted,
	Total_MentalHealth, Total_MentalHealth_Submitted,
	
	Total_Diagnostic, Total_Diagnostic_Submitted,

	Total_Other, Total_Other_Submitted,

	TotalPurged = isnull(p.TotalPurged, 0), 
	TotalPurgedCorrection = isnull(p.TotalPurgedCorrection, 0),
	TotalPurgedNoCorrection = isnull(p.TotalPurgedNoCorrection, 0)
from 
(select 
	InstitutionNumber = H_Institutionprofile.CIHIValue,
	InstitutionNumbereDesc = H_Institutionprofile.UserDescription,
	BatchYear = Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	BatchPeriod = right(''00'' + cast(datepart(month, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then -9 else 3 end) as varchar(2)), 2),
	
	AmCareGroup = LU_MISCode.AmCareGroup, AmCareGroupDesc = LU_AmCareGroup.UserDescription,
	
	TotalSubmitted = sum(case when IsSubmited = 1 then 1 else 0 end),
	TotalSubmitted_None = sum(case when IsSubmited = 1 then 0 else 1 end),
	
	Total_Emergency = sum(case when LU_MISCode.AmCareTypeCode = ''10'' then 1 else 0 end),
	Total_Emergency_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''10'' then 1 else 0 end),
	
	Total_UCC = sum(case when LU_MISCode.AmCareTypeCode = ''11'' then 1 else 0 end),
	Total_UCC_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''11'' then 1 else 0 end),

	Total_ED_MentalHealth = sum(case when LU_MISCode.AmCareTypeCode = ''12'' then 1 else 0 end),
	Total_ED_MentalHealth_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''12'' then 1 else 0 end),

	Total_DaySurgical = sum(case when LU_MISCode.AmCareTypeCode = ''20'' then 1 else 0 end),
	Total_DaySurgical_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''20'' then 1 else 0 end),

	Total_Endoscopy = sum(case when LU_MISCode.AmCareTypeCode = ''21'' then 1 else 0 end),
	Total_Endoscopy_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''21'' then 1 else 0 end),

	Total_Cystoscopy = sum(case when LU_MISCode.AmCareTypeCode = ''22'' then 1 else 0 end),
	Total_Cystoscopy_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''22'' then 1 else 0 end),

	Total_Clinic = sum(case when LU_MISCode.AmCareTypeCode = ''30'' then 1 else 0 end),
	Total_Clinic_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''30'' then 1 else 0 end),

	Total_CardiacCatheterization = sum(case when LU_MISCode.AmCareTypeCode = ''31'' then 1 else 0 end),
	Total_CardiacCatheterization_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''31'' and IsSubmited = 1 then 1 else 0 end),
	
	Total_Oncology = sum(case when LU_MISCode.AmCareTypeCode = ''32'' then 1 else 0 end),
	Total_Oncology_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''32'' and IsSubmited = 1 then 1 else 0 end),
	
	Total_CancerCareOntario= sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 then 1 
									 else 0 end),
	Total_CancerCareOntario_Submitted = sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 and IsSubmited = 1 then 1 
												else 0 end),

	Total_RenalDialysis = sum(case when LU_MISCode.AmCareTypeCode = ''33'' then 1 else 0 end),
	Total_RenalDialysis_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''33'' and IsSubmited = 1 then 1 else 0 end),

	Total_MentalHealth = sum(case when LU_MISCode.AmCareTypeCode = ''34'' then 1 else 0 end),
	Total_MentalHealth_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''34'' and IsSubmited = 1 then 1 else 0 end),

	Total_Diagnostic = sum(case when LU_MISCode.AmCareTypeCode = ''80'' then 1 else 0 end),
	Total_Diagnostic_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''80'' and IsSubmited = 1 then 1 else 0 end),

	Total_Other = sum(case when LU_MISCode.AmCareTypeCode = ''90'' then 1 else 0 end),
	Total_Other_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''90'' and IsSubmited = 1 then 1 else 0 end)

from AB_Abstract  with (nolock)
	inner join H_Institutionprofile with (nolock) on AB_Abstract.InstitutionNumber = H_Institutionprofile.code
	left  join LU_MISCode with (nolock) on LU_MISCode.Code = AB_Abstract.MISCode
	left  join LU_CodeFile LU_AmCareGroup with (nolock) on LU_MISCode.AmCareGroup = LU_AmCareGroup.CIHIValue and LU_AmCareGroup.LookupID = 1102
where AdmitDate >= ''2010/04/01'' and Caretype = 5 and ICDType = ''T''
group by H_Institutionprofile.CIHIValue, H_Institutionprofile.UserDescription, 
	Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	right(''00'' + cast(datepart(month, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then -9 else 3 end) as varchar(2)), 2),
	LU_MISCode.AmCareGroup, LU_AmCareGroup.UserDescription
) aa
left join 
(select InstNumber as InstitutionNumber, BatchYear, BatchPeriod, 
	TotalPurged = count(*), 
	TotalPurgedCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected in (''R'', ''C'') then 1 else 0 end)),
	TotalPurgedNoCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected not in (''R'', ''C'') then 1 else 0 end))
 from dbo.REC_Purge with (nolock)
 where AppID = 401 
 group by InstNumber, BatchYear, BatchPeriod) P 
	on aa.InstitutionNumber = p.InstitutionNumber and aa.BatchYear = p.BatchYear and aa.BatchPeriod = p.BatchPeriod





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting_2009]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE view [dbo].[I10_Amcare_statistic_Reporting_2009]
as
select aa.InstitutionNumber, InstitutionNumbereDesc, aa.BatchYear, aa.BatchPeriod, 
	TotalRecords = TotalSubmitted + TotalSubmitted_None,
	TotalSubmitted,
	TotalSubmitted_None,
	TotalEmergency,
	TotalEmergency_Submitted,
	TotalDaySurgical,
	TotalDaySurgical_Submitted,
	TotalCardiacCatheterization,
	TotalCardiacCatheterization_Submitted,
	TotalOncology,
	TotalOncology_Submitted,
	TotalCancerCareOntario,
	TotalCancerCareOntario_Submitted,
	TotalRenalDialysis,
	TotalRenalDialysis_Submitted,
	TotalOthers = TotalSubmitted + TotalSubmitted_None - TotalEmergency - TotalDaySurgical
					- TotalCardiacCatheterization - TotalOncology - TotalCancerCareOntario
					- TotalRenalDialysis,
	TotalOthers_Submitted = TotalSubmitted - TotalEmergency_Submitted - TotalDaySurgical_Submitted
					- TotalCardiacCatheterization_Submitted - TotalOncology_Submitted 
					- TotalCancerCareOntario_Submitted - TotalRenalDialysis_Submitted,
	TotalPurged = isnull(p.TotalPurged, 0), 
	TotalPurgedCorrection = isnull(p.TotalPurgedCorrection, 0),
	TotalPurgedNoCorrection = isnull(p.TotalPurgedNoCorrection, 0)
from 
(select 
	InstitutionNumber = H_Institutionprofile.CIHIValue,
	InstitutionNumbereDesc = H_Institutionprofile.UserDescription,
	BatchYear = Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	BatchPeriod = right(''00'' + cast(datepart(month, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then -9 else 3 end) as varchar(2)), 2),
	TotalSubmitted = sum(case when IsSubmited = 1 then 1 else 0 end),
	TotalSubmitted_None = sum(case when IsSubmited = 1 then 0 else 1 end),
	TotalEmergency = sum(case when LU_MISCode.CIHIValue like ''7_310%'' then 1 else 0 end),
	TotalEmergency_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.CIHIValue like ''7_310%'' then 1 else 0 end),
	
	TotalDaySurgical = sum(case when LU_MISCode.CIHIValue like ''7_34055'' then 1 
								when LU_MISCode.CIHIValue like ''7_34025'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_34020'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_260%'' or 
									 LU_MISCode.CIHIValue like ''7_262%'' or
									 LU_MISCode.CIHIValue like ''7_265%'' or
									 LU_MISCode.CIHIValue like ''7_360%'' or
									 LU_MISCode.CIHIValue like ''7_362%'' or
									 LU_MISCode.CIHIValue like ''7_365%'' or
									 LU_MISCode.CIHIValue like ''7_369%'' or
									 LU_MISCode.CIHIValue like ''7_396%'' then 1
								else 0 end),

	TotalDaySurgical_Submitted = sum(case when IsSubmited = 1 then
						   (case when LU_MISCode.CIHIValue like ''7_34055'' then 1 
								when LU_MISCode.CIHIValue like ''7_34025'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_34020'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_260%'' or 
									 LU_MISCode.CIHIValue like ''7_262%'' or
									 LU_MISCode.CIHIValue like ''7_265%'' or
									 LU_MISCode.CIHIValue like ''7_360%'' or
									 LU_MISCode.CIHIValue like ''7_362%'' or
									 LU_MISCode.CIHIValue like ''7_365%'' or
									 LU_MISCode.CIHIValue like ''7_369%'' or
									 LU_MISCode.CIHIValue like ''7_396%'' then 1
								else 0 end)
							else 0 end),

	TotalCardiacCatheterization = sum(case when LU_MISCode.CIHIValue like ''7_41544%'' then 1 else 0 end),
	TotalCardiacCatheterization_Submitted = sum(case when LU_MISCode.CIHIValue like ''7_41544%'' and IsSubmited = 1 then 1 else 0 end),
	
	TotalOncology = sum(case when LU_MISCode.CIHIValue like ''7_34066%'' then 1 
							 when LU_MISCode.CIHIValue like ''7_466%'' then 1 
							 else 0 end),
	TotalOncology_Submitted = sum(case when LU_MISCode.CIHIValue like ''7_34066%'' and IsSubmited = 1 then 1 
									   when LU_MISCode.CIHIValue like ''7_466%''  and IsSubmited = 1 then 1 
									   else 0 end),
	TotalCancerCareOntario= sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 then 1 
									 else 0 end),
	TotalCancerCareOntario_Submitted = sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 and IsSubmited = 1 then 1 
												else 0 end),
	TotalRenalDialysis = sum(case when LU_MISCode.CIHIValue like ''7_34086%'' then 1 
						 		  when LU_MISCode.CIHIValue like ''7_53086%'' then 1 
								  else 0 end),
	TotalRenalDialysis_Submitted = sum(case when LU_MISCode.CIHIValue like ''7_34086%'' and IsSubmited = 1 then 1 
						 					when LU_MISCode.CIHIValue like ''7_53086%'' and IsSubmited = 1 then 1 
											else 0 end)
from AB_Abstract  with (nolock)
	inner join H_Institutionprofile with (nolock) on AB_Abstract.InstitutionNumber = H_Institutionprofile.code
	left join LU_MISCode with (nolock) on AB_Abstract.MISCode = LU_MISCode.Code
where AdmitDate <= ''2010/03/31'' and Caretype = 5 and ICDType = ''T''
group by H_Institutionprofile.CIHIValue, H_Institutionprofile.UserDescription, 
	Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	right(''00'' + cast(datepart(month, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then -9 else 3 end) as varchar(2)), 2)
) aa
left join 
(select InstNumber as InstitutionNumber, BatchYear, BatchPeriod, 
	TotalPurged = count(*), 
	TotalPurgedCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected in (''R'', ''C'') then 1 else 0 end)),
	TotalPurgedNoCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected not in (''R'', ''C'') then 1 else 0 end))
 from dbo.REC_Purge with (nolock)
 where AppID = 401 
 group by InstNumber, BatchYear, BatchPeriod) P 
	on aa.InstitutionNumber = p.InstitutionNumber and aa.BatchYear = p.BatchYear and aa.BatchPeriod = p.BatchPeriod




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting_BC]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[I10_Amcare_statistic_Reporting_BC]
as
select aa.InstitutionNumber, InstitutionNumbereDesc, aa.BatchYear, aa.BatchPeriod, 
	AmCareGroup, AmCareGroupDesc,
	TotalRecords = TotalSubmitted + TotalSubmitted_None,
	TotalSubmitted,
	TotalSubmitted_None,

	Total_Emergency, Total_Emergency_Submitted,
	Total_UCC, Total_UCC_Submitted,
	Total_ED_MentalHealth, Total_ED_MentalHealth_Submitted,

	Total_DaySurgical, Total_DaySurgical_Submitted,
	Total_Endoscopy, Total_Endoscopy_Submitted
	Total_Cystoscopy, Total_Cystoscopy_Submitted,
	
	Total_Clinic, Total_Clinic_Submitted,
	Total_CardiacCatheterization, Total_CardiacCatheterization_Submitted,
	Total_Oncology, Total_Oncology_Submitted,
	--Total_CancerCareOntario, TotalCancerCareOntario_Submitted,
	Total_RenalDialysis, Total_RenalDialysis_Submitted,
	Total_MentalHealth, Total_MentalHealth_Submitted,
	
	Total_Diagnostic, Total_Diagnostic_Submitted,

	Total_Other, Total_Other_Submitted,

	TotalPurged = isnull(p.TotalPurged, 0), 
	TotalPurgedCorrection = isnull(p.TotalPurgedCorrection, 0),
	TotalPurgedNoCorrection = isnull(p.TotalPurgedNoCorrection, 0)
from 
(select 
	InstitutionNumber = H_Institutionprofile.CIHIValue,
	InstitutionNumbereDesc = H_Institutionprofile.UserDescription,
	BatchYear = Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	BatchPeriod = lu_BatchPeriod.CIHIValue,
	
	AmCareGroup = LU_MISCode.AmCareGroup, AmCareGroupDesc = LU_AmCareGroup.UserDescription,
	
	TotalSubmitted = sum(case when IsSubmited = 1 then 1 else 0 end),
	TotalSubmitted_None = sum(case when IsSubmited = 1 then 0 else 1 end),
	
	Total_Emergency = sum(case when LU_MISCode.AmCareTypeCode = ''10'' then 1 else 0 end),
	Total_Emergency_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''10'' then 1 else 0 end),
	
	Total_UCC = sum(case when LU_MISCode.AmCareTypeCode = ''11'' then 1 else 0 end),
	Total_UCC_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''11'' then 1 else 0 end),

	Total_ED_MentalHealth = sum(case when LU_MISCode.AmCareTypeCode = ''12'' then 1 else 0 end),
	Total_ED_MentalHealth_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''12'' then 1 else 0 end),

	Total_DaySurgical = sum(case when LU_MISCode.AmCareTypeCode = ''20'' then 1 else 0 end),
	Total_DaySurgical_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''20'' then 1 else 0 end),

	Total_Endoscopy = sum(case when LU_MISCode.AmCareTypeCode = ''21'' then 1 else 0 end),
	Total_Endoscopy_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''21'' then 1 else 0 end),

	Total_Cystoscopy = sum(case when LU_MISCode.AmCareTypeCode = ''22'' then 1 else 0 end),
	Total_Cystoscopy_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''22'' then 1 else 0 end),

	Total_Clinic = sum(case when LU_MISCode.AmCareTypeCode = ''30'' then 1 else 0 end),
	Total_Clinic_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.AmCareTypeCode = ''30'' then 1 else 0 end),

	Total_CardiacCatheterization = sum(case when LU_MISCode.AmCareTypeCode = ''31'' then 1 else 0 end),
	Total_CardiacCatheterization_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''31'' and IsSubmited = 1 then 1 else 0 end),
	
	Total_Oncology = sum(case when LU_MISCode.AmCareTypeCode = ''32'' then 1 else 0 end),
	Total_Oncology_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''32'' and IsSubmited = 1 then 1 else 0 end),
	
	Total_CancerCareOntario= sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 then 1 
									 else 0 end),
	Total_CancerCareOntario_Submitted = sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 and IsSubmited = 1 then 1 
												else 0 end),

	Total_RenalDialysis = sum(case when LU_MISCode.AmCareTypeCode = ''33'' then 1 else 0 end),
	Total_RenalDialysis_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''33'' and IsSubmited = 1 then 1 else 0 end),

	Total_MentalHealth = sum(case when LU_MISCode.AmCareTypeCode = ''34'' then 1 else 0 end),
	Total_MentalHealth_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''34'' and IsSubmited = 1 then 1 else 0 end),

	Total_Diagnostic = sum(case when LU_MISCode.AmCareTypeCode = ''80'' then 1 else 0 end),
	Total_Diagnostic_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''80'' and IsSubmited = 1 then 1 else 0 end),

	Total_Other = sum(case when LU_MISCode.AmCareTypeCode = ''90'' then 1 else 0 end),
	Total_Other_Submitted = sum(case when LU_MISCode.AmCareTypeCode = ''90'' and IsSubmited = 1 then 1 else 0 end)

from AB_Abstract  with (nolock)
	inner join H_Institutionprofile with (nolock) on AB_Abstract.InstitutionNumber = H_Institutionprofile.code
	inner join lu_BatchPeriod with (nolock) on AB_Abstract.AdmitDate between LU_BatchPeriod.CIHIDateFrom and LU_BatchPeriod.CIHIDateTo
	left  join LU_MISCode with (nolock) on LU_MISCode.Code = AB_Abstract.MISCode
	left  join LU_CodeFile LU_AmCareGroup with (nolock) on LU_MISCode.AmCareGroup = LU_AmCareGroup.CIHIValue and LU_AmCareGroup.LookupID = 1102
where AdmitDate >= ''2010/04/01'' and Caretype = 5 and ICDType = ''T''
group by H_Institutionprofile.CIHIValue, H_Institutionprofile.UserDescription, 
	Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	lu_BatchPeriod.CIHIValue,
	LU_MISCode.AmCareGroup, LU_AmCareGroup.UserDescription
) aa
left join 
(select InstNumber as InstitutionNumber, BatchYear, BatchPeriod, 
	TotalPurged = count(*), 
	TotalPurgedCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected in (''R'', ''C'') then 1 else 0 end)),
	TotalPurgedNoCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected not in (''R'', ''C'') then 1 else 0 end))
 from dbo.REC_Purge with (nolock)
 where AppID = 401 
 group by InstNumber, BatchYear, BatchPeriod) P 
	on aa.InstitutionNumber = p.InstitutionNumber and aa.BatchYear = p.BatchYear and aa.BatchPeriod = p.BatchPeriod




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_statistic_Reporting_BC_2009]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE view [dbo].[I10_Amcare_statistic_Reporting_BC_2009]
as 
select aa.InstitutionNumber, InstitutionNumbereDesc, aa.BatchYear, aa.BatchPeriod, 
	TotalRecords = TotalSubmitted + TotalSubmitted_None,
	TotalSubmitted,
	TotalSubmitted_None,
	TotalEmergency,
	TotalEmergency_Submitted,
	TotalDaySurgical,
	TotalDaySurgical_Submitted,
	TotalCardiacCatheterization,
	TotalCardiacCatheterization_Submitted,
	TotalOncology,
	TotalOncology_Submitted,
	TotalCancerCareOntario,
	TotalCancerCareOntario_Submitted,
	TotalRenalDialysis,
	TotalRenalDialysis_Submitted,
	TotalOthers = TotalSubmitted + TotalSubmitted_None - TotalEmergency - TotalDaySurgical
					- TotalCardiacCatheterization - TotalOncology - TotalCancerCareOntario
					- TotalRenalDialysis,
	TotalOthers_Submitted = TotalSubmitted - TotalEmergency_Submitted - TotalDaySurgical_Submitted
					- TotalCardiacCatheterization_Submitted - TotalOncology_Submitted 
					- TotalCancerCareOntario_Submitted - TotalRenalDialysis_Submitted,
	TotalPurged = isnull(p.TotalPurged, 0), 
	TotalPurgedCorrection = isnull(p.TotalPurgedCorrection, 0),
	TotalPurgedNoCorrection = isnull(p.TotalPurgedNoCorrection, 0)
from 
(select 
	InstitutionNumber = H_Institutionprofile.CIHIValue,
	InstitutionNumbereDesc = H_Institutionprofile.UserDescription,
	BatchYear = Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	BatchPeriod = lu_BatchPeriod.CIHIValue,
	TotalSubmitted = sum(case when IsSubmited = 1 then 1 else 0 end),
	TotalSubmitted_None = sum(case when IsSubmited = 1 then 0 else 1 end),
	TotalEmergency = sum(case when LU_MISCode.CIHIValue like ''7_310%'' then 1 else 0 end),
	TotalEmergency_Submitted = sum(case when IsSubmited = 1 and LU_MISCode.CIHIValue like ''7_310%'' then 1 else 0 end),
	
	TotalDaySurgical = sum(case when LU_MISCode.CIHIValue like ''7_34055'' then 1 
								when LU_MISCode.CIHIValue like ''7_34025'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_34020'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_260%'' or 
									 LU_MISCode.CIHIValue like ''7_262%'' or
									 LU_MISCode.CIHIValue like ''7_265%'' or
									 LU_MISCode.CIHIValue like ''7_360%'' or
									 LU_MISCode.CIHIValue like ''7_362%'' or
									 LU_MISCode.CIHIValue like ''7_365%'' or
									 LU_MISCode.CIHIValue like ''7_369%'' or
									 LU_MISCode.CIHIValue like ''7_396%'' then 1
								else 0 end),

	TotalDaySurgical_Submitted = sum(case when IsSubmited = 1 then
						   (case when LU_MISCode.CIHIValue like ''7_34055'' then 1 
								when LU_MISCode.CIHIValue like ''7_34025'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_34020'' and AdmitDate < ''2009/04/01'' then 1 --For Abstract before 2009
								when LU_MISCode.CIHIValue like ''7_260%'' or 
									 LU_MISCode.CIHIValue like ''7_262%'' or
									 LU_MISCode.CIHIValue like ''7_265%'' or
									 LU_MISCode.CIHIValue like ''7_360%'' or
									 LU_MISCode.CIHIValue like ''7_362%'' or
									 LU_MISCode.CIHIValue like ''7_365%'' or
									 LU_MISCode.CIHIValue like ''7_369%'' or
									 LU_MISCode.CIHIValue like ''7_396%'' then 1
								else 0 end)
							else 0 end),

	TotalCardiacCatheterization = sum(case when LU_MISCode.CIHIValue like ''7_41544%'' then 1 else 0 end),
	TotalCardiacCatheterization_Submitted = sum(case when LU_MISCode.CIHIValue like ''7_41544%'' and IsSubmited = 1 then 1 else 0 end),
	
	TotalOncology = sum(case when LU_MISCode.CIHIValue like ''7_34066%'' then 1 
							 when LU_MISCode.CIHIValue like ''7_466%'' then 1 
							 else 0 end),
	TotalOncology_Submitted = sum(case when LU_MISCode.CIHIValue like ''7_34066%'' and IsSubmited = 1 then 1 
									   when LU_MISCode.CIHIValue like ''7_466%''  and IsSubmited = 1 then 1 
									   else 0 end),
	TotalCancerCareOntario= sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 then 1 
									 else 0 end),
	TotalCancerCareOntario_Submitted = sum(case when H_Institutionprofile.CIHIValue like ''5%'' and CIHI_AbstractID >= 9000000 and IsSubmited = 1 then 1 
												else 0 end),
	TotalRenalDialysis = sum(case when LU_MISCode.CIHIValue like ''7_34086%'' then 1 
						 		  when LU_MISCode.CIHIValue like ''7_53086%'' then 1 
								  else 0 end),
	TotalRenalDialysis_Submitted = sum(case when LU_MISCode.CIHIValue like ''7_34086%'' and IsSubmited = 1 then 1 
						 					when LU_MISCode.CIHIValue like ''7_53086%'' and IsSubmited = 1 then 1 
											else 0 end)
from AB_Abstract with (nolock) 
	inner join H_Institutionprofile with (nolock) on AB_Abstract.InstitutionNumber = H_Institutionprofile.code
	inner join lu_BatchPeriod with (nolock) on AB_Abstract.AdmitDate between LU_BatchPeriod.CIHIDateFrom and LU_BatchPeriod.CIHIDateTo
	left join LU_MISCode with (nolock) on AB_Abstract.MISCode = LU_MISCode.Code
where AdmitDate <=''2010/03/31'' and Caretype = 5 and ICDType = ''T''
group by H_Institutionprofile.CIHIValue, H_Institutionprofile.UserDescription, 
	Datepart(year, admitdate) - (case when datepart(month, admitdate) in (1, 2, 3) then 1 else 0 end),
	lu_BatchPeriod.CIHIValue
) aa
left join 
(select InstNumber as InstitutionNumber, BatchYear, BatchPeriod, 
	TotalPurged = count(*), 
	TotalPurgedCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected in (''R'', ''C'') then 1 else 0 end)),
	TotalPurgedNoCorrection = sum((case when IsSubmitted = ''Y'' and IsCorrected not in (''R'', ''C'') then 1 else 0 end))
 from dbo.REC_Purge with (nolock)
 where AppID = 401 
 group by InstNumber, BatchYear, BatchPeriod) P 
	on aa.InstitutionNumber = p.InstitutionNumber and aa.BatchYear = p.BatchYear and aa.BatchPeriod = p.BatchPeriod





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Amcare_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[I10_Amcare_VR]
AS
SELECT
    dbo.AB_ReproductiveCare.PrevPreTermDelivery AS [#ofPreviousPreTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevSpontAbortions AS [#ofPrevSpontaneousAbortions], 
    dbo.AB_ReproductiveCare.PrevTermDelivery AS [#ofPreviousTermDeliveries], 
    --ED - 01910
    LU_AccessPrimaryHealthCareCode.DisplayCode as AccessPrimaryHealthCareCode,  LU_AccessPrimaryHealthCareCode.UserDescription as AccessPrimaryHealthCareCodeDesc,
    AmbulanceArrDate as AmbulanceArrivalDate, AmbulanceArrTime as AmbulanceArrivalTime, 
    LU_AmbulanceArrTimeUnknown.DisplayCode as AmbulanceArrivalTimeUnknown,  LU_AmbulanceArrTimeUnknown.UserDescription as AmbulanceArrivalTimeUnknownDesc,
    AmbulanceTranDate as AmbulanceTransferCareDate, AmbulanceTranTime as AmbulanceTransferCareTime,
    LU_AmbulanceTranTimeUnknown.DisplayCode as AmbulanceTransferCareTimeUnknown,  LU_AmbulanceTranTimeUnknown.UserDescription as AmbulanceTransferCareTimeUnknownDesc,

    dbo.AB_ReproductiveCare.PrevInduceAbortions AS [#ofPrevTherapeuticAbortions], Lookup1.DisplayCode AS AWOL, 
    Lookup1.UserDescription AS AWOLDesc, dbo.AB_ReproductiveCare.AbortionDate AS AbortDate, dbo.AB_Abstract.AbstractNumber, 
    dbo.LU_AbstractOverflow.DisplayCode AS AbstractOverflow, dbo.LU_AbstractOverflow.UserDescription AS AbstractOverflowDesc, 
    dbo.AB_Abstract.InjuryActivityDescription AS ActivityDescription, Lookup2.DisplayCode AS ActivityWhenInjured, 
    Lookup2.UserDescription AS ActivityWhenInjuredDesc, dbo.AB_Abstract.AcuteLOS AS ActueLOS, Lookup3.DisplayCode AS AdmitbyAmbulance, 
    Lookup3.UserDescription AS AdmitbyAmbulanceDesc, dbo.AB_Abstract.AdmitCategory, 
    dbo.AB_Abstract.AdmittingDiagnosis AS AdmitDiagnosis, 
    LU_AdmitNurse.DisplayCode AS AdmitNursingArea, LU_AdmitNurse.UserDescription AS AdmitNursingAreaDesc, 
    dbo.AB_DeathInformation.DeathAfterAdmit AS AfterAdmit, 
    Lookup4.DisplayCode AS AgeCode, Lookup4.UserDescription AS AgeCodeDesc, dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, 
    Lookup5.DisplayCode AS Albumin, Lookup5.UserDescription AS AlbuminDesc, Lookup6.DisplayCode AS AlbuminCrossMatched, 
    Lookup6.UserDescription AS AlbuminCrossMatchedDesc, Lookup7.DisplayCode AS AlbuminTyped, Lookup7.UserDescription AS AlbuminTypedDesc, 
    dbo.AB_Blood.AlbuminUnits, dbo.AB_Abstract.ALCLOS, 
    dbo.AB_Abstract.AmbulanceReportNumber, 
    --ED-02091 & ED - 02130
    isnull(LU_AmCareGroup.DisplayCode, LU_AmCareGroup_FromMISCode.DisplayCode) AS AmCareGroup, 
    isnull(LU_AmCareGroup.UserDescription, LU_AmCareGroup_FromMISCode.UserDescription) AS AmCareGroupDesc, 
    --PR - 03010
    LU_AmCareType.DisplayCode AS AmcareCareType, LU_AmCareType.UserDescription AS AmcareCareTypeDesc, 
    --ED-02091  & ED - 02130
    isnull(LU_AmCareTypeCode.DisplayCode, LU_AmCareTypeCode_FromMISCode.DisplayCode) AS AmcareTypeCode, 
    isnull(LU_AmCareTypeCode.UserDescription, LU_AmCareTypeCode_FromMISCode.UserDescription) AS AmcareTypeCodeDesc, 
    
    dbo.AB_Ancillary.AncillaryField13 AS Ancil13, 
    dbo.AB_Ancillary.AncillaryField14 AS Ancil14, dbo.AB_Ancillary.AncillaryField15 AS Ancil15, dbo.AB_Ancillary.AncillaryField16 AS Ancil16, 
    dbo.AB_Ancillary.AncillaryField17 AS Ancil17, Lookup8.DisplayCode AS AncillaryField1, Lookup8.UserDescription AS AncillaryField1Desc, 
    Lookup9.DisplayCode AS AncillaryField10, Lookup9.UserDescription AS AncillaryField10Desc, Lookup10.DisplayCode AS AncillaryField11, 
    Lookup10.UserDescription AS AncillaryField11Desc, Lookup11.DisplayCode AS AncillaryField12, Lookup11.UserDescription AS AncillaryField12Desc, 
    Lookup12.DisplayCode AS AncillaryField2, Lookup12.UserDescription AS AncillaryField2Desc, Lookup13.DisplayCode AS AncillaryField3, 
    Lookup13.UserDescription AS AncillaryField3Desc, Lookup14.DisplayCode AS AncillaryField4, Lookup14.UserDescription AS AncillaryField4Desc, 
    Lookup15.DisplayCode AS AncillaryField5, Lookup15.UserDescription AS AncillaryField5Desc, Lookup16.DisplayCode AS AncillaryField6, 
    Lookup16.UserDescription AS AncillaryField6Desc, Lookup17.DisplayCode AS AncillaryField7, Lookup17.UserDescription AS AncillaryField7Desc, 
    Lookup18.DisplayCode AS AncillaryField8, Lookup18.UserDescription AS AncillaryField8Desc, Lookup19.DisplayCode AS AncillaryField9, 
    Lookup19.UserDescription AS AncillaryField9Desc, dbo.AB_Abstract.ArrivalDate, Lookup22.DisplayCode AS ArrivalMode, 
    Lookup22.UserDescription AS ArrivalModeDesc, dbo.AB_Abstract.ArrivalTime, dbo.AB_Abstract.ArrivalTriageDifference AS ArrivaltoTriageTime, 
    dbo.AB_Abstract.AssessmentDate, dbo.AB_Abstract.AssessmentTime, Lookup159.DisplayCode AS AssessmentTimeUnknown, 
    Lookup159.UserDescription AS AssessmentTimeUnknownDesc, LU_AttendingPhysician.DisplayCode AS AttendingPhysician, 
    LU_AttendingPhysician.UserDescription AS AttendingPhysicianDesc, Lookup23.DisplayCode AS AutoTransfusion, 
    Lookup23.UserDescription AS AutoTransfusionDesc, Lookup24.DisplayCode AS AutopsyPerformed, 
    Lookup24.UserDescription AS AutopsyPerformedDesc, Lookup25.DisplayCode AS BasicOption1, Lookup25.UserDescription AS BasicOption1Desc, 
    Lookup26.DisplayCode AS BasicOption10, Lookup26.UserDescription AS BasicOption10Desc, Lookup27.DisplayCode AS BasicOption11, 
    Lookup27.UserDescription AS BasicOption11Desc, Lookup28.DisplayCode AS BasicOption12, Lookup28.UserDescription AS BasicOption12Desc, 
    Lookup29.DisplayCode AS BasicOption13, Lookup29.UserDescription AS BasicOption13Desc, Lookup30.DisplayCode AS BasicOption14, 
    Lookup30.UserDescription AS BasicOption14Desc, Lookup31.DisplayCode AS BasicOption15, Lookup31.UserDescription AS BasicOption15Desc, 
    Lookup32.DisplayCode AS BasicOption16, Lookup32.UserDescription AS BasicOption16Desc, Lookup33.DisplayCode AS BasicOption17, 
    Lookup33.UserDescription AS BasicOption17Desc, Lookup34.DisplayCode AS BasicOption18, Lookup34.UserDescription AS BasicOption18Desc, 
    Lookup35.DisplayCode AS BasicOption19, Lookup35.UserDescription AS BasicOption19Desc, Lookup36.DisplayCode AS BasicOption2, 
    Lookup36.UserDescription AS BasicOption2Desc, Lookup37.DisplayCode AS BasicOption3, Lookup37.UserDescription AS BasicOption3Desc, 
    Lookup38.DisplayCode AS BasicOption4, Lookup38.UserDescription AS BasicOption4Desc, Lookup39.DisplayCode AS BasicOption5, 
    Lookup39.UserDescription AS BasicOption5Desc, Lookup40.DisplayCode AS BasicOption6, Lookup40.UserDescription AS BasicOption6Desc, 
    Lookup41.DisplayCode AS BasicOption7, Lookup41.UserDescription AS BasicOption7Desc, Lookup42.DisplayCode AS BasicOption8, 
    Lookup42.UserDescription AS BasicOption8Desc, Lookup43.DisplayCode AS BasicOption9, Lookup43.UserDescription AS BasicOption9Desc, 
    dbo.AB_Abstract.BatchNumber, Lookup44.DisplayCode AS BatchPeriod, Lookup44.UserDescription AS BatchPeriodDesc, 
    --PR - 06087
    BatchPeriod_BC = (case when left(Lookup74.CIHIValue, 1) <> ''9'' then null
                           when Lookup44.DisplayCode is not null then Lookup44.DisplayCode 
                           when AdmitDate is null then null
                           else (select top 1 DisplayCode from LU_BatchPeriod where AdmitDate between CIHIDateFrom and CIHIDateTo)
                      end),
    dbo.AB_Abstract.BatchYear,     dbo.AB_Abstract.BirthDate, 
	
	LU_AntithrombinIII.DisplayCode AS Blood_AntithrombinIII, LU_AntithrombinIII.UserDescription AS Blood_AntithrombinIIIDesc,
	LU_C1Inhibitor.DisplayCode AS Blood_C1Inhibitor, LU_C1Inhibitor.UserDescription AS Blood_C1InhibitorDesc,
	LU_CryoprecipitatePlasma.DisplayCode AS Blood_CryoprecipitatePlasma, LU_CryoprecipitatePlasma.UserDescription AS Blood_CryoprecipitatePlasmaDesc,
	LU_CryosupernatantPlasma.DisplayCode AS Blood_CryosupernatantPlasma, LU_CryosupernatantPlasma.UserDescription AS Blood_CryosupernatantPlasmaDesc,
	LU_FEIBA.DisplayCode AS Blood_FEIBA, LU_FEIBA.UserDescription AS Blood_FEIBADesc,
	LU_Fibrinogen.DisplayCode AS Blood_Fibrinogen, LU_Fibrinogen.UserDescription AS Blood_FibrinogenDesc,
	LU_IVIG_SCIG.DisplayCode AS Blood_IVIG_SCIG, LU_IVIG_SCIG.UserDescription AS Blood_IVIG_SCIGDesc,
	LU_PCC.DisplayCode AS Blood_PCC, LU_PCC.UserDescription AS Blood_PCCDesc,
	LU_ProteinC_OtherFactors.DisplayCode AS Blood_ProteinC_OtherFactors, LU_ProteinC_OtherFactors.UserDescription AS Blood_ProteinC_OtherFactorsDesc,

	dbo.AB_ReproductiveCare.BreastFeeding, 
    --ED - 01910
    LU_CDUFlag.Displaycode as ClinicalDecisionUnitFlag,    LU_CDUFlag.UserDescription as ClinicalDecisionUnitFlagDesc,
    CDUArrivalDate as ClinicalDecisionUnitDateIn, CDUArrivalTime as ClinicalDecisionUnitTimeIn,
    LU_CDUInTimeUnknown.Displaycode as ClinicalDecisionUnitTimeInUnknown,    LU_CDUInTimeUnknown.UserDescription as ClinicalDecisionUnitTimeInUnknownDesc,
    CDUOutDate as ClinicalDecisionUnitDateOut, CDUOutTime as ClinicalDecisionUnitTimeOut,
    LU_CDUOutTimeUnknown.Displaycode as ClinicalDecisionUnitTimeOutUnknown,    LU_CDUOutTimeUnknown.UserDescription as ClinicalDecisionUnitTimeOutUnknownDesc,

    Lookup45.DisplayCode AS ChangeinLegalStatus, 
    Lookup45.UserDescription AS ChangeinLegalStatusDesc, dbo.AB_Abstract.ChartNumber, dbo.AB_Abstract.ChiefComplaint, 
    Lookup46.DisplayCode AS CoderNumber, Lookup46.UserDescription AS CoderNumberDesc, LUCompleteRecord.DisplayCode AS CompleteRecord, 
    LUCompleteRecord.UserDescription AS CompleteRecordDesc, LUComplication.DisplayCode AS Complication, 
    LUComplication.UserDescription AS ComplicationDesc, Lookup47.DisplayCode AS Complication1, Lookup47.UserDescription AS Complication1Desc, 
    Lookup48.DisplayCode AS Complication2, Lookup48.UserDescription AS Complication2Desc, Lookup49.DisplayCode AS Complication3, 
    Lookup49.UserDescription AS Complication3Desc, Lookup50.DisplayCode AS ContactMode, Lookup50.UserDescription AS ContactModeDesc, 
    Lookup51.DisplayCode AS CoronerCase, Lookup51.UserDescription AS CoronerCaseDesc, Lookup52.DisplayCode AS DataEntryCoder, 
    Lookup52.UserDescription AS DataEntryCoderDesc, dbo.AB_Abstract.DateLeftER, dbo.AB_ReproductiveCare.LastMensesDate AS DateofLastMenses, 
    dbo.AB_Abstract.DateReadyDischarge AS DateReadyforDisch, 

    dbo.AB_Abstract.CIHIDateSent AS DateSentToCIHI, 
    --NP - 00125
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILevel1, 
    --ED - 02102
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILevel2, 
    --2.x-0282
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILite, 

    Lookup53.DisplayCode AS DeathInER,
    Lookup53.UserDescription AS DeathInERDesc, Lookup54.DisplayCode AS DeathOnArrival, Lookup54.UserDescription AS DeathOnArrivalDesc, 
    dbo.AB_Abstract.DecisionAdmitDifference, dbo.AB_Abstract.DecisionAdmitDate AS DecisiontoAdmitDate, 
    dbo.AB_Abstract.DecisionAdmitTime AS DecisiontoAdmitTime, Lookup158.DisplayCode AS DecisionAdmitTimeUnknown, 
    Lookup158.UserDescription AS DecisionAdmitTimeUnknownDesc, dbo.AB_ReproductiveCare.DeliveryDate, dbo.AB_ReproductiveCare.DeliveryTime, 
    Lookup58.DisplayCode AS DiedDuringIntervention, Lookup58.UserDescription AS DiedDuringInterventionDesc, 
    LU_DischargeNurse.DisplayCode AS DischNursingArea, LU_DischargeNurse.UserDescription AS DischNursingAreaDesc, 
    Lookup59.DisplayCode AS DischPlanning, 
    Lookup59.UserDescription AS DischPlanningDesc, dbo.AB_Abstract.DischargeAge, Lookup60.DisplayCode AS DischargeDisposition, 
    Lookup60.UserDescription AS DischargeDispositionDesc, dbo.AB_Abstract.DischargeDate AS DispositionDate, 
    dbo.AB_Abstract.DischargeTime AS DispositionTime, LUDischargeTimeUnknown.DisplayCode AS DispositionTimeUnknown, 
    LUDischargeTimeUnknown.UserDescription AS DispositionTimeUnknownDesc, Lookup61.DisplayCode AS ECTTreatment, 
    Lookup61.UserDescription AS ECTTreatmentDesc, Lookup64.DisplayCode AS Education, Lookup64.UserDescription AS EducationDesc, 
    --ED - 02289
    LU_EDVisitIndicator.DisplayCode AS EDVisitIndicator, LU_EDVisitIndicator.UserDescription AS EDVisitIndicatorDesc,
    
    Lookup65.DisplayCode AS Employment, Lookup65.UserDescription AS EmploymentDesc, dbo.AB_Abstract.EntryCode, 
    dbo.AB_Abstract.EstimatedDischargeDate AS EstimateDischDate, dbo.AB_Abstract.ExitCode, Lookup67.DisplayCode AS FamilyPhysicianFlag, 
    Lookup67.UserDescription AS FamilyPhysicianFlagDesc, Lookup68.DisplayCode AS FinancialSupport, 
    Lookup68.UserDescription AS FinancialSupportDesc, dbo.AB_Abstract.FinishDate, dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, 
    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS FullName, 
    FixedChartNumber,
    Lookup69.DisplayCode AS Gender, Lookup69.UserDescription AS GenderDesc, dbo.AB_ReproductiveCare.GestationalAge AS GestationalAgeinweeks, 
    Lookup157.DisplayCode AS GlasgowScale, Lookup157.UserDescription AS GlasgowScaleDesc, 
    dbo.AB_DeathInformation.DeathGreaterTenPO AS GreaterTenPO, Lookup70.DisplayCode AS HCNProvince, 
    Lookup70.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, dbo.AB_Abstract.HealthCareNumber, 
    LU_Hospital.DisplayCode AS Hospital, LU_Hospital.UserDescription AS HospitalDesc, 
    dbo.AB_Abstract.HospitalAccountRecord,
    LUHelmetIndicator.DisplayCode AS HelmetIndicator, 
    LUHelmetIndicator.UserDescription AS HelmetIndicatorDesc, dbo.AB_DeathInformation.DeathInSCU AS InSCU, Lookup71.DisplayCode AS InitialOR, 
    Lookup71.UserDescription AS InitialORDesc, dbo.AB_Abstract.InjuryDate, Lookup72.DisplayCode AS Injury, Lookup72.UserDescription AS InjuryDesc, 
    dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 
	
	Lookup73.DisplayCode AS InstitutionFrom, Lookup73.UserDescription AS InstitutionFromDesc, 
	LU_InstitutionFrom_Type.DisplayCode AS InstitutionFromType, LU_InstitutionFrom_Type.UserDescription AS InstitutionFromTypeDesc, 
    Lookup73.InstCareType AS InstFromCareType, Lookup73.HospitalType AS InstFromHospType, 
	
	Lookup74.DisplayCode AS InstitutionNumber, Lookup74.UserDescription AS InstitutionNumberDesc, 
	
	Lookup75.DisplayCode AS InstitutionTo, Lookup75.UserDescription AS InstitutionToDesc, 
	LU_InstitutionTo_Type.DisplayCode AS InstitutionToType, LU_InstitutionTo_Type.UserDescription AS InstitutionToTypeDesc, 
    Lookup75.InstCareType AS InstToCareType, Lookup75.HospitalType AS InstToHospType, dbo.AB_Abstract.InterfaceDate, 
    
	dbo.AB_Abstract.InterfaceTime, 

    Lookup83.DisplayCode AS IsAbstractCompleted, Lookup83.UserDescription AS IsAbstractCompletedDesc, 
    --NP - 00125
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel1, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel1Desc, 
    --ED - 02102
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel2, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel2Desc, 
    --2.x-0282
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLite, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLiteDesc, 

    Lookup84.DisplayCode AS IsAbstractCorrected, Lookup84.UserDescription AS IsAbstractCorrectedDesc, 
    --NP - 00125
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel1, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel1Desc, 
    --ED - 02102
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel2, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel2Desc, 
    --2.x-0282
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLite, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLiteDesc, 

    Lookup85.DisplayCode AS IsAbstractDeleted,   Lookup85.UserDescription AS IsAbstractDeletedDesc, 

    Lookup86.DisplayCode AS IsAbstractSubmitted, Lookup86.UserDescription AS IsAbstractSubmittedDesc,
    --NP - 00125 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel1, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel1Desc, 
    --ED - 02102 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel2, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel2Desc, 
    --2.x-0282
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLite, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLiteDesc, 

    Lookup87.DisplayCode AS IsAbstractValidated, Lookup87.UserDescription AS IsAbstractValidatedDesc, 
    --NP - 00125 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel1, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel1Desc, 
    --ED - 02102 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel2, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel2Desc, 
    --2.x-0282
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLite, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLiteDesc, 

    Lookup88.DisplayCode AS IsBirthdateEstimated,     Lookup88.UserDescription AS IsBirthdateEstimatedDesc, 
	LU_IsCustomValidated.DisplayCode AS IsCustomValidated, LU_IsCustomValidated.UserDescription AS IsCustomValidatedDesc, 
	
	dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSTotal AS LOSTime, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LOSMinutes AS LOSTotalMinutes, Lookup89.DisplayCode AS [Language], 
    Lookup89.UserDescription AS LanguageDesc, dbo.AB_Abstract.LastName, dbo.AB_DeathInformation.DeathLessTwoPO AS LessTwoPO, 
    Lookup90.DisplayCode AS LivingArrangement, Lookup90.UserDescription AS LivingArrangementDesc, Lookup91.DisplayCode AS LocationofInjury, 
    Lookup91.UserDescription AS LocationofInjuryDesc, Lookup93.DisplayCode AS MISCode, Lookup93.UserDescription AS MISCodeDesc, 
    dbo.AB_Abstract.MaidenName, Lookup94.DisplayCode AS MaritalStatus, Lookup94.UserDescription AS MaritalStatusDesc, 

	LU_MentalLegalStatusUponArrivalED.DisplayCode as MentalHealth_LegalStatusUponArrivaltoED, 
	LU_MentalLegalStatusUponArrivalED.UserDescription as MentalHealth_LegalStatusUponArrivaltoEDDesc,
	--LU_MentalLegalStatusAdmission.DisplayCode as MentalHealth_LegalStatusAtAdmission, 
	--LU_MentalLegalStatusAdmission.UserDescription as MentalHealth_LegalStatusAtAdmissionDesc,
	LU_MentalTypeRestraint_1.DisplayCode as MentalHealth_TypeOfRestraint_01,
	LU_MentalTypeRestraint_1.UserDescription as MentalHealth_TypeOfRestraint_01Desc,
	LU_MentalTypeRestraint_2.DisplayCode as MentalHealth_TypeOfRestraint_02,
	LU_MentalTypeRestraint_2.UserDescription as MentalHealth_TypeOfRestraint_02Desc,
	LU_MentalTypeRestraint_3.DisplayCode as MentalHealth_TypeOfRestraint_03,
	LU_MentalTypeRestraint_3.UserDescription as MentalHealth_TypeOfRestraint_03Desc,
	LU_MentalTypeRestraint_4.DisplayCode as MentalHealth_TypeOfRestraint_04,
	LU_MentalTypeRestraint_4.UserDescription as MentalHealth_TypeOfRestraint_04Desc,
	LU_MentalFrequencyRestraintUse_1.DisplayCode as MentalHealth_FrequencyOfRestraint_01,
	LU_MentalFrequencyRestraintUse_1.UserDescription as MentalHealth_FrequencyOfRestraint_01Desc,
	LU_MentalFrequencyRestraintUse_2.DisplayCode as MentalHealth_FrequencyOfRestraint_02,
	LU_MentalFrequencyRestraintUse_2.UserDescription as MentalHealth_FrequencyOfRestraint_02Desc,
	LU_MentalFrequencyRestraintUse_3.DisplayCode as MentalHealth_FrequencyOfRestraint_03,
	LU_MentalFrequencyRestraintUse_3.UserDescription as MentalHealth_FrequencyOfRestraint_03Desc,
	LU_MentalFrequencyRestraintUse_4.DisplayCode as MentalHealth_FrequencyOfRestraint_04,
	LU_MentalFrequencyRestraintUse_4.UserDescription as MentalHealth_FrequencyOfRestraint_04Desc,


    Lookup95.DisplayCode AS MethodofAdmission, Lookup95.UserDescription AS MethodofAdmissionDesc, dbo.AB_Abstract.MiddleName, 

    LU_IsLiteSubmission.DisplayCode AS NACRSClinicLiteSubmission, LU_IsLiteSubmission.UserDescription AS NACRSClinicLiteSubmissionDesc, 
    
    dbo.AB_Abstract.NewbornChart, dbo.AB_Abstract.NewbornDischargeDate AS NewbornDischDate, 
    dbo.AB_Abstract.NextSchedVisitDate AS NextScheduledVisitDate, dbo.AB_Abstract.NextSchedVisitTime AS NextScheduledVisitTime, 
    --ED-02091 
	AB_NACRS.NonPhysicianAssessmentDate, AB_NACRS.NonPhysicianAssessmentTime, 
	LU_NonPhysicianAssessmentTimeUnknown.DisplayCode AS NonPhysicianAssessmentTimeUnknown, LU_NonPhysicianAssessmentTimeUnknown.UserDescription AS NonPhysicianAssessmentTimeUnknownDesc,
	LU_NonPhysicianNumber.DisplayCode AS NonPhysicianNumber, LU_NonPhysicianNumber.UserDescription AS NonPhysicianNumberDesc,
	LU_NonPhysicianService.DisplayCode AS NonPhysicianService, LU_NonPhysicianService.UserDescription AS NonPhysicianServiceDesc,
    
    dbo.AB_MentalHealth.MentalNumberECT AS NumberofECT, dbo.AB_Abstract.NurseAssessDate AS NursingAssessmentDate, 
    dbo.AB_Abstract.NurseAssessTime AS NursingAssessmentTime, Lookup98.DisplayCode AS Occupation, 
    Lookup98.UserDescription AS OccupationDesc, Lookup99.DisplayCode AS OtherMedicalDeath, Lookup99.UserDescription AS OtherMedicalDeathDesc, 
    Lookup100.DisplayCode AS OtherBlood, Lookup100.UserDescription AS OtherBloodDesc, Lookup101.DisplayCode AS OtherBloodCrossMatched, 
    Lookup101.UserDescription AS OtherBloodCrossMatchedDesc, Lookup102.DisplayCode AS OtherBloodTyped, 
    Lookup102.UserDescription AS OtherBloodTypedDesc, dbo.AB_Blood.OtherBloodUnits, Lookup148.DisplayCode AS PCTASIndicator, 
    Lookup148.UserDescription AS PCTASIndicatorDesc, dbo.AB_Abstract.PhysicianEstimatedLOS AS PhysicianEstLOS, 
    Lookup103.DisplayCode AS Plasma, Lookup103.UserDescription AS PlasmaDesc, Lookup104.DisplayCode AS PlasmaCrossMatched, 
    Lookup104.UserDescription AS PlasmaCrossMatchedDesc, Lookup105.DisplayCode AS PlasmaTyped, 
    Lookup105.UserDescription AS PlasmaTypedDesc, dbo.AB_Blood.PlasmaUnits, Lookup106.DisplayCode AS Platelets, 
    Lookup106.UserDescription AS PlateletsDesc, Lookup107.DisplayCode AS PlateletsCrossMatched, 
    Lookup107.UserDescription AS PlateletsCrossMatchedDesc, Lookup108.DisplayCode AS PlateletsTyped, 
    Lookup108.UserDescription AS PlateletsTypedDesc, dbo.AB_Blood.PlateletsUnits, dbo.AB_Abstract.PostalCode, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), dbo.AB_Abstract.AdmitDate) AS PostalCodeDesc, -- ED - 01682

    dbo.AB_Abstract.PostOpDays, dbo.AB_Abstract.PreOpDays, Lookup110.DisplayCode AS PreamditWorkUp, Lookup110.UserDescription AS PreamditWorkUpDesc, 
    Lookup111.DisplayCode AS Pregnancy, Lookup111.UserDescription AS PregnancyDesc, dbo.AB_ReproductiveCare.PrevLiveBirths AS PrevLiveBirth, 
    Lookup112.DisplayCode AS PreviousPsychiartricAdmissions, Lookup112.UserDescription AS PreviousPsychiartricAdmDesc, 
    Lookup113.DisplayCode AS Program, Lookup113.UserDescription AS ProgramDesc, Lookup118.DisplayCode AS ProvinceNumber, 
    Lookup118.UserDescription AS ProvinceNumberDesc, LUReasonForVisit.DisplayCode AS ReasonForVisit, 
    LUReasonForVisit.UserDescription AS ReasonForVisitDesc, dbo.AB_Abstract.ReAdmitCode, 
	--PR - 04577
	LU_ReciprocalBillingStatus.DisplayCode AS ReciprocalBillingStatus, LU_ReciprocalBillingStatus.UserDescription AS ReciprocalBillingStatusDesc,

    Lookup132.DisplayCode AS RedBloodCell, 
    Lookup132.UserDescription AS RedBloodCellDesc, Lookup133.DisplayCode AS RedBloodCellCrossMatched, 
    Lookup133.UserDescription AS RedBloodCellCrossMatchedDesc, Lookup134.DisplayCode AS RedBloodCellTyped, 
    Lookup134.UserDescription AS RedBloodCellTypedDesc, dbo.AB_Blood.RedCellUnits AS RedBloodCellUnits, dbo.AB_Abstract.ReferralDate, 
    Lookup135.DisplayCode AS ReferredFrom, Lookup135.UserDescription AS ReferredFromDesc, Lookup136.DisplayCode AS ReferredTo, 
    Lookup136.UserDescription AS ReferredToDesc, LU_RefProvider.DisplayCode AS ReferringProvider, 
    LU_RefProvider.UserDescription AS ReferringProviderDesc, dbo.AB_Abstract.RegisterNumber, 
    dbo.AB_Abstract.EncounterNumber AS RegistrationNumber, dbo.AB_Abstract.EncounterSequence AS RegistrationSequenceNumber, 
    dbo.AB_Abstract.AdmitDate AS RegistrationVisitDate, dbo.AB_Abstract.AdmitTime AS RegistrationVisitTime, 
    dbo.AB_ReproductiveCare.ReprodComments AS ReproductiveCareComments, dbo.AB_Abstract.Reserved AS ReserveField, 
    Lookup138.DisplayCode AS ResidenceCode, Lookup138.UserDescription AS ResidenceCodeDesc, 
    LUResidenceProvince.DisplayCode AS ResidenceProvince, LUResidenceProvince.UserDescription AS ResidenceProvinceDesc, 
    LUResidenceRegion.DisplayCode AS ResidenceRegion, LUResidenceRegion.UserDescription AS ResidenceRegionDesc, 
    Lookup139.DisplayCode AS ResidenceType, Lookup139.UserDescription AS ResidenceTypeDesc, 
    Lookup140.DisplayCode AS ResponsiblityForPayment, Lookup140.UserDescription AS ResponsiblityForPaymentDesc, 
    Lookup153.DisplayCode AS SchedEDVisit, Lookup153.UserDescription AS SchedEDVisitDesc, Lookup156.DisplayCode AS SeatbeltIndicator, 
    Lookup156.UserDescription AS SeatbeltIndicatorDesc, dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup141.DisplayCode AS SecretVIPPatient, Lookup141.UserDescription AS SecretVIPPatientDesc, Lookup142.DisplayCode AS SiteNumber, 
    Lookup142.UserDescription AS SiteNumberDesc, Lookup143.DisplayCode AS SocialService, Lookup143.UserDescription AS SocialServiceDesc, 
    Lookup144.DisplayCode AS SourceofReferral, Lookup144.UserDescription AS SourceofReferralDesc, 
	--ED-02091
	LU_SpecialistNumber.DisplayCode AS SpecialistNumber, LU_SpecialistNumber.UserDescription AS SpecialistNumberDesc,
	AB_NACRS.SpecialistRequestDate, 
	LU_SpecialistService.DisplayCode AS SpecialistRequestService, LU_SpecialistService.UserDescription AS SpecialistRequestServiceDesc,
	AB_NACRS.SpecialistRequestTime, 
	LU_SpecialistRequestTimeUnknown.DisplayCode AS SpecialistRequestTimeUnknown, LU_SpecialistRequestTimeUnknown.UserDescription AS SpecialistRequestTimeUnknownDesc,
    
    LU_StakeholderType.DisplayCode AS StakeholderType, LU_StakeholderType.UserDescription AS StakeholderTypeDesc, 
    --ED - 02289
    LU_StatusAfterTriage.DisplayCode as StatusAfterTriage, LU_StatusAfterTriage.UserDescription as StatusAfterTriageDesc,
    
    Lookup145.DisplayCode AS Sterilization, Lookup145.UserDescription AS SterilizationDesc, 

    SubmissionLevel as SubmissionLevelCode, --ED - 01910
    AbstractNumber as SubmissionRecordID,

    Lookup146.DisplayCode AS SubsequentOR, 
    Lookup146.UserDescription AS SubsequentORDesc, Lookup147.DisplayCode AS Suicide, Lookup147.UserDescription AS SuicideDesc, 
    LUSurgicalCase.DisplayCode AS SurgicalCase, LUSurgicalCase.UserDescription AS SurgicalCaseDesc, dbo.AB_Abstract.TimeLeftER, 
    LU_TimeLeftERUnknown.DisplayCode AS TimeLeftERUnknown, LU_TimeLeftERUnknown.UserDescription AS TimeLeftERUnknownDEsc, 
    dbo.AB_Abstract.TransferOverloadDate, dbo.AB_Abstract.TransferOverloadTime, 
    dbo.AB_Abstract.TransferOverloadDifference AS TransferOverloadTimeDifference, Lookup149.DisplayCode AS TransfusionGiven, 
    Lookup149.UserDescription AS TransfusionGivenDesc, Lookup150.DisplayCode AS Trauma, Lookup150.UserDescription AS TraumaDesc, 
    dbo.AB_Abstract.TriageDate, Lookup151.DisplayCode AS TriageLevel, Lookup151.UserDescription AS TriageLevelDesc, dbo.AB_Abstract.TriageTime, 
    LU_TriageTimeUnknown.DisplayCode AS TriageTimeUnknown, LU_TriageTimeUnknown.UserDescription AS TriageTimeUnknownDesc, 
    Lookup152.DisplayCode AS TSICoder, Lookup152.UserDescription AS TSICoderDesc, dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, 
    dbo.AB_DeathInformation.DeathTwoTenPO AS TwoTenPO, dbo.AB_Abstract.UniqiueLifetimeID AS ULI, 
    dbo.AB_Abstract.UnplanReAdmit AS UnplannedReadmit, Lookup154.DisplayCode AS VisitStatus, Lookup154.UserDescription AS VisitStatusDesc, 
    Lookup155.DisplayCode AS VisitType, Lookup155.UserDescription AS VisitTypeDesc, 
	dbo.AB_Abstract.UniversalEpisodeIdentifier,
	dbo.AB_Abstract.WaitTimeER AS WaitTimeinER, 
    dbo.AB_Abstract.WaitAssessmentDifference AS WaittoAssessmentinMinutes, dbo.AB_Abstract.NurseAssessDiff AS WaittoNursingAssessmentDiff, 
    dbo.AB_Abstract.Weight, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID, 
    dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TriageTimeUnknown with (nolock) on dbo.AB_Abstract.TriageTimeUnknown = LU_TriageTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_Provider LU_RefProvider with (nolock) on dbo.AB_Abstract.RefPhysician = LU_RefProvider.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_TimeLeftERUnknown with (nolock) on dbo.AB_Abstract.TimeLeftERUnknown = LU_TimeLeftERUnknown.Code LEFT OUTER JOIN
    dbo.LU_Provider LU_AttendingPhysician with (nolock) on dbo.AB_Abstract.AttendingPhysician = LU_AttendingPhysician.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_StakeholderType with (nolock) on dbo.AB_Abstract.StakeHolder = LU_StakeholderType.Code LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LUCompleteRecord with (nolock) on dbo.AB_Abstract.CompleteRecord = LUCompleteRecord.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LUHelmetIndicator with (nolock) on dbo.AB_Abstract.HelmetIndicator = LUHelmetIndicator.Code LEFT OUTER JOIN
    dbo.LU_InjuryActivity Lookup2 with (nolock) on dbo.AB_Abstract.InjuryActivity = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup4 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_ArrivalMode Lookup22 with (nolock) on dbo.AB_Abstract.ArrivalMode = Lookup22.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup44 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup44.Code LEFT OUTER JOIN
    dbo.U_Users Lookup46 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_ContactMode Lookup50 with (nolock) on dbo.AB_Abstract.ContactMode = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup52 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup52.Code LEFT OUTER JOIN
    dbo.LU_TherDischPlan Lookup59 with (nolock) on dbo.AB_Abstract.DischargePlanning = Lookup59.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_A Lookup60 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_Education Lookup64 with (nolock) on dbo.AB_Abstract.EducationLevel = Lookup64.Code LEFT OUTER JOIN
    dbo.LU_FamilyPhysician Lookup67 with (nolock) on dbo.AB_Abstract.FamilyPhysician = Lookup67.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup69 with (nolock) on dbo.AB_Abstract.Gender = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup70 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup70.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup72 with (nolock) on dbo.AB_Abstract.Injury = Lookup72.Code LEFT OUTER JOIN
    
	dbo.LU_Institution_10 Lookup73 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup73.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionFrom_Type with (nolock) on dbo.AB_Abstract.InstitutionFromType = LU_InstitutionFrom_Type.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup74 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup74.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup75 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup75.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionTo_Type with (nolock) on dbo.AB_Abstract.InstitutionToType = LU_InstitutionTo_Type.Code LEFT OUTER JOIN

    dbo.LU_AbstractStatus Lookup83 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup84 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus Lookup85 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup86 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup86.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup87 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup87.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_IsCustomValidated with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_IsCustomValidated.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup88 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup88.Code LEFT OUTER JOIN
    dbo.LU_Language Lookup89 with (nolock) on dbo.AB_Abstract.LanguageCode = Lookup89.Code LEFT OUTER JOIN
    dbo.LU_LivingArrangement Lookup90 with (nolock) on dbo.AB_Abstract.LivingArrangement = Lookup90.Code LEFT OUTER JOIN
    dbo.LU_InjuryLocation Lookup91 with (nolock) on dbo.AB_Abstract.InjuryLocation = Lookup91.Code LEFT OUTER JOIN
    dbo.LU_MISCode Lookup93 with (nolock) on dbo.AB_Abstract.MISCode = Lookup93.Code LEFT OUTER JOIN
    
    --PR - 03012
    dbo.LU_CodeFile LU_AmCareType with (nolock) on Lookup93.AmCareType = LU_AmCareType.Code LEFT OUTER JOIN
    
    dbo.LU_MaritalStatus Lookup94 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup94.Code LEFT OUTER JOIN
    dbo.LU_Occupation Lookup98 with (nolock) on dbo.AB_Abstract.Occupation = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_TherPreAdmitWorkUp Lookup110 with (nolock) on dbo.AB_Abstract.PreAdmitWorkUp = Lookup110.Code LEFT OUTER JOIN
    dbo.LU_Program Lookup113 with (nolock) on dbo.AB_Abstract.Program = Lookup113.Code LEFT OUTER JOIN
    dbo.LU_Province Lookup118 with (nolock) on dbo.AB_Abstract.ProvinceNumber = Lookup118.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup135 with (nolock) on dbo.AB_Abstract.ReferredFrom = Lookup135.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup136 with (nolock) on dbo.AB_Abstract.ReferredTo = Lookup136.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup138 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup138.Code LEFT OUTER JOIN
    dbo.LU_Region LUResidenceRegion with (nolock) on Lookup138.RegionCode = LUResidenceRegion.Code LEFT OUTER JOIN
    dbo.LU_Province LUResidenceProvince with (nolock) on Lookup138.ProvinceCode = LUResidenceProvince.Code LEFT OUTER JOIN
    dbo.LU_ResidenceType Lookup139 with (nolock) on dbo.AB_Abstract.ResidenceType = Lookup139.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup140 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup140.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup141 with (nolock) on dbo.AB_Abstract.Secret = Lookup141.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup142 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup142.Code LEFT OUTER JOIN
    dbo.LU_TherSocialService Lookup143 with (nolock) on dbo.AB_Abstract.SocialService = Lookup143.Code LEFT OUTER JOIN
    dbo.LU_TriageLevel Lookup151 with (nolock) on dbo.AB_Abstract.TriageLevel = Lookup151.Code LEFT OUTER JOIN
    dbo.U_Users Lookup152 with (nolock) on dbo.AB_Abstract.TSICoder = Lookup152.Code LEFT OUTER JOIN
    dbo.LU_VisitType Lookup154 with (nolock) on dbo.AB_Abstract.VisitStatus = Lookup154.Code LEFT OUTER JOIN
    dbo.LU_VisitType_10 Lookup155 with (nolock) on dbo.AB_Abstract.VisitType = Lookup155.Code LEFT OUTER JOIN
    dbo.AB_Ancillary with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Ancillary.AbstractID LEFT OUTER JOIN
    dbo.LU_Ancillary1 Lookup8 with (nolock) on dbo.AB_Ancillary.AncillaryField1 = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_Ancillary10 Lookup9 with (nolock) on dbo.AB_Ancillary.AncillaryField10 = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_Ancillary11 Lookup10 with (nolock) on dbo.AB_Ancillary.AncillaryField11 = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_Ancillary12 Lookup11 with (nolock) on dbo.AB_Ancillary.AncillaryField12 = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Ancillary2 Lookup12 with (nolock) on dbo.AB_Ancillary.AncillaryField2 = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_Ancillary3 Lookup13 with (nolock) on dbo.AB_Ancillary.AncillaryField3 = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_Ancillary4 Lookup14 with (nolock) on dbo.AB_Ancillary.AncillaryField4 = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_Ancillary5 Lookup15 with (nolock) on dbo.AB_Ancillary.AncillaryField5 = Lookup15.Code LEFT OUTER JOIN
    dbo.LU_Ancillary6 Lookup16 with (nolock) on dbo.AB_Ancillary.AncillaryField6 = Lookup16.Code LEFT OUTER JOIN
    dbo.LU_Ancillary7 Lookup17 with (nolock) on dbo.AB_Ancillary.AncillaryField7 = Lookup17.Code LEFT OUTER JOIN
    dbo.LU_Ancillary8 Lookup18 with (nolock) on dbo.AB_Ancillary.AncillaryField8 = Lookup18.Code LEFT OUTER JOIN
    dbo.LU_Ancillary9 Lookup19 with (nolock) on dbo.AB_Ancillary.AncillaryField9 = Lookup19.Code LEFT OUTER JOIN
    dbo.AB_BasicOption with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_BasicOption.AbstractID LEFT OUTER JOIN
    dbo.LU_BasicOption1 Lookup25 with (nolock) on dbo.AB_BasicOption.BasicOption1 = Lookup25.Code LEFT OUTER JOIN
    dbo.LU_BasicOption10 Lookup26 with (nolock) on dbo.AB_BasicOption.BasicOption10 = Lookup26.Code LEFT OUTER JOIN
    dbo.LU_BasicOption11 Lookup27 with (nolock) on dbo.AB_BasicOption.BasicOption11 = Lookup27.Code LEFT OUTER JOIN
    dbo.LU_BasicOption12 Lookup28 with (nolock) on dbo.AB_BasicOption.BasicOption12 = Lookup28.Code LEFT OUTER JOIN
    dbo.LU_BasicOption13 Lookup29 with (nolock) on dbo.AB_BasicOption.BasicOption13 = Lookup29.Code LEFT OUTER JOIN
    dbo.LU_BasicOption14 Lookup30 with (nolock) on dbo.AB_BasicOption.BasicOption14 = Lookup30.Code LEFT OUTER JOIN
    dbo.LU_BasicOption15 Lookup31 with (nolock) on dbo.AB_BasicOption.BasicOption15 = Lookup31.Code LEFT OUTER JOIN
    dbo.LU_BasicOption16 Lookup32 with (nolock) on dbo.AB_BasicOption.BasicOption16 = Lookup32.Code LEFT OUTER JOIN
    dbo.LU_BasicOption17 Lookup33 with (nolock) on dbo.AB_BasicOption.BasicOption17 = Lookup33.Code LEFT OUTER JOIN
    dbo.LU_BasicOption18 Lookup34 with (nolock) on dbo.AB_BasicOption.BasicOption18 = Lookup34.Code LEFT OUTER JOIN
    dbo.LU_BasicOption19 Lookup35 with (nolock) on dbo.AB_BasicOption.BasicOption19 = Lookup35.Code LEFT OUTER JOIN
    dbo.LU_BasicOption2 Lookup36 with (nolock) on dbo.AB_BasicOption.BasicOption2 = Lookup36.Code LEFT OUTER JOIN
    dbo.LU_BasicOption3 Lookup37 with (nolock) on dbo.AB_BasicOption.BasicOption3 = Lookup37.Code LEFT OUTER JOIN
    dbo.LU_BasicOption4 Lookup38 with (nolock) on dbo.AB_BasicOption.BasicOption4 = Lookup38.Code LEFT OUTER JOIN
    dbo.LU_BasicOption5 Lookup39 with (nolock) on dbo.AB_BasicOption.BasicOption5 = Lookup39.Code LEFT OUTER JOIN
    dbo.LU_BasicOption6 Lookup40 with (nolock) on dbo.AB_BasicOption.BasicOption6 = Lookup40.Code LEFT OUTER JOIN
    dbo.LU_BasicOption7 Lookup41 with (nolock) on dbo.AB_BasicOption.BasicOption7 = Lookup41.Code LEFT OUTER JOIN
    dbo.LU_BasicOption8 Lookup42 with (nolock) on dbo.AB_BasicOption.BasicOption8 = Lookup42.Code LEFT OUTER JOIN
    dbo.LU_BasicOption9 Lookup43 with (nolock) on dbo.AB_BasicOption.BasicOption9 = Lookup43.Code LEFT OUTER JOIN
    dbo.AB_Blood with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_Blood.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup5 with (nolock) on dbo.AB_Blood.Albumin = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup6 with (nolock) on dbo.AB_Blood.AlbuminXMatch = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup7 with (nolock) on dbo.AB_Blood.AlbuminTyped = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup23 with (nolock) on dbo.AB_Blood.AutoTransfusion = Lookup23.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup100 with (nolock) on dbo.AB_Blood.OtherBlood = Lookup100.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup101 with (nolock) on dbo.AB_Blood.OtherBloodXMatch = Lookup101.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup102 with (nolock) on dbo.AB_Blood.OtherBloodTyped = Lookup102.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup103 with (nolock) on dbo.AB_Blood.Plasma = Lookup103.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup104 with (nolock) on dbo.AB_Blood.PlasmaXMatch = Lookup104.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup105 with (nolock) on dbo.AB_Blood.PlasmaTyped = Lookup105.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup106 with (nolock) on dbo.AB_Blood.Platelets = Lookup106.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup107 with (nolock) on dbo.AB_Blood.PlateletsXMatch = Lookup107.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup108 with (nolock) on dbo.AB_Blood.PlateletsTyped = Lookup108.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup132 with (nolock) on dbo.AB_Blood.RedBloodCell = Lookup132.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup133 with (nolock) on dbo.AB_Blood.RedCellXMatch = Lookup133.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup134 with (nolock) on dbo.AB_Blood.RedCellTyped = Lookup134.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup149 with (nolock) on dbo.AB_Blood.TransfusionIndicator = Lookup149.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_AntithrombinIII with (nolock) on dbo.AB_Blood.AntithrombinIII = LU_AntithrombinIII.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_C1Inhibitor with (nolock) on dbo.AB_Blood.C1Inhibitor = LU_C1Inhibitor.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryoprecipitatePlasma with (nolock) on dbo.AB_Blood.CryoprecipitatePlasma = LU_CryoprecipitatePlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_CryosupernatantPlasma with (nolock) on dbo.AB_Blood.CryosupernatantPlasma = LU_CryosupernatantPlasma.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_FEIBA with (nolock) on dbo.AB_Blood.FEIBA = LU_FEIBA.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_Fibrinogen with (nolock) on dbo.AB_Blood.Fibrinogen = LU_Fibrinogen.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_IVIG_SCIG with (nolock) on dbo.AB_Blood.IVIG_SCIG = LU_IVIG_SCIG.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_PCC with (nolock) on dbo.AB_Blood.PCC = LU_PCC.Code LEFT OUTER JOIN
	dbo.LU_YesNoAlpha LU_ProteinC_OtherFactors with (nolock) on dbo.AB_Blood.ProteinC_OtherFactors = LU_ProteinC_OtherFactors.Code LEFT OUTER JOIN

    dbo.AB_DeathInformation with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_DeathInformation.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup24 with (nolock) on dbo.AB_DeathInformation.AutopsyPerformed = Lookup24.Code LEFT OUTER JOIN
    dbo.LU_CoronerCase Lookup51 with (nolock) on dbo.AB_DeathInformation.CoronerCase = Lookup51.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup53 with (nolock) on dbo.AB_DeathInformation.DeathInER = Lookup53.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup54 with (nolock) on dbo.AB_DeathInformation.DeathOnArrival = Lookup54.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup58 with (nolock) on dbo.AB_DeathInformation.DeathInOR = Lookup58.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup99 with (nolock) on dbo.AB_DeathInformation.OtherDeath = Lookup99.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup111 with (nolock) on dbo.AB_DeathInformation.PregnancyDeath = Lookup111.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup150 with (nolock) on dbo.AB_DeathInformation.TraumaDeath = Lookup150.Code LEFT OUTER JOIN
    dbo.AB_MentalHealth with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_MentalHealth.AbstractID LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup1 with (nolock) on dbo.AB_MentalHealth.MentalAWOL = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_MentalLegalStatus Lookup45 with (nolock) on dbo.AB_MentalHealth.MentalLegalStatus = Lookup45.Code LEFT OUTER JOIN
    dbo.LU_MentalECTTreat Lookup61 with (nolock) on dbo.AB_MentalHealth.MentalECTTreatment = Lookup61.Code LEFT OUTER JOIN
    dbo.LU_MentalEducation Lookup63 with (nolock) on dbo.AB_MentalHealth.MentalEducation = Lookup63.Code LEFT OUTER JOIN
    dbo.LU_MentalEmployment Lookup65 with (nolock) on dbo.AB_MentalHealth.MentalEmployment = Lookup65.Code LEFT OUTER JOIN
    dbo.LU_MentalFinancial Lookup68 with (nolock) on dbo.AB_MentalHealth.MentalFinancial = Lookup68.Code LEFT OUTER JOIN
    dbo.LU_MentalAdmitMethod Lookup95 with (nolock) on dbo.AB_MentalHealth.MentalAdmitMethod = Lookup95.Code LEFT OUTER JOIN
    dbo.LU_MentalPrevPsych Lookup112 with (nolock) on dbo.AB_MentalHealth.MentalPrevPsych = Lookup112.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup137 with (nolock) on dbo.AB_MentalHealth.MentalReferralTo = Lookup137.Code LEFT OUTER JOIN
    dbo.LU_MentalReferral Lookup144 with (nolock) on dbo.AB_MentalHealth.MentalReferralSource = Lookup144.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup147 with (nolock) on dbo.AB_MentalHealth.MentalSuicide = Lookup147.Code LEFT OUTER JOIN
	dbo.LU_MentalLegalStatusUponArrivalED with (nolock) on dbo.AB_MentalHealth.LegalStatusUponArrivaltoED = LU_MentalLegalStatusUponArrivalED.Code LEFT OUTER JOIN
	--dbo.LU_MentalLegalStatusAdmission with (nolock) on dbo.AB_MentalHealth.LegalStatusAtAdmission = LU_MentalLegalStatusAdmission.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_1 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint01 = LU_MentalTypeRestraint_1.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_1 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint01 = LU_MentalFrequencyRestraintUse_1.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_2 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint02 = LU_MentalTypeRestraint_2.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_2 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint02 = LU_MentalFrequencyRestraintUse_2.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_3 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint03 = LU_MentalTypeRestraint_3.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_3 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint03 = LU_MentalFrequencyRestraintUse_3.Code LEFT OUTER JOIN
	dbo.LU_MentalTypeRestraint LU_MentalTypeRestraint_4 with (nolock) on dbo.AB_MentalHealth.TypeOfRestraint04 = LU_MentalTypeRestraint_4.Code LEFT OUTER JOIN
	dbo.LU_MentalFrequencyRestraintUse LU_MentalFrequencyRestraintUse_4 with (nolock) on dbo.AB_MentalHealth.FrequencyOfRestraint04 = LU_MentalFrequencyRestraintUse_4.Code LEFT OUTER JOIN


    dbo.AB_ReproductiveCare with (nolock) on dbo.AB_Abstract.AbstractID = dbo.AB_ReproductiveCare.AbstractID LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup47 with (nolock) on dbo.AB_ReproductiveCare.Complication1 = Lookup47.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup48 with (nolock) on dbo.AB_ReproductiveCare.Complication2 = Lookup48.Code LEFT OUTER JOIN
    dbo.LU_ReprodComplication Lookup49 with (nolock) on dbo.AB_ReproductiveCare.Complication3 = Lookup49.Code left join
    dbo.LU_ReprodOR Lookup71 with (nolock) on Lookup71.Code = dbo.AB_ReproductiveCare.InitialOR left join
    dbo.LU_YesBlank Lookup145 with (nolock) on Lookup145.Code = dbo.AB_ReproductiveCare.Sterilization LEFT OUTER JOIN
    dbo.LU_ReprodOR Lookup146 with (nolock) on dbo.AB_ReproductiveCare.SubsequentOR = Lookup146.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup148 with (nolock) on dbo.AB_Abstract.PCTASIndicator = Lookup148.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup153 with (nolock) on dbo.AB_Abstract.SchedEDVisit = Lookup153.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup156 with (nolock) on dbo.AB_Abstract.SeatbeltIndicator = Lookup156.Code AND Lookup156.LookupID = 2 LEFT OUTER JOIN
    dbo.LU_Glasgow Lookup157 with (nolock) on dbo.AB_Abstract.GlasgowComaScale = Lookup157.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup158 with (nolock) on dbo.AB_Abstract.DecisionAdmitTimeUnknown = Lookup158.Code AND Lookup158.LookupID = 1 LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup159 with (nolock) on dbo.AB_Abstract.AssessmentTimeUnknown = Lookup159.Code AND Lookup159.LookupID = 1 LEFT OUTER JOIN
    dbo.LU_AbstractOverflow with (nolock) on dbo.AB_Abstract.AbstractOverflow = dbo.LU_AbstractOverflow.Code LEFT OUTER JOIN
    dbo.LU_YesBlank LUSurgicalCase with (nolock) on dbo.AB_Abstract.SurgicalCase = LUSurgicalCase.Code LEFT OUTER JOIN
    dbo.LU_YesBlank LUComplication with (nolock) on dbo.AB_Abstract.Complication = LUComplication.Code LEFT OUTER JOIN
    dbo.ICD_DiagFile10 LUReasonForVisit with (nolock) on dbo.AB_Abstract.ReasonForVisit = LUReasonForVisit.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LUDischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LUDischargeTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_AdmitNurse with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurse.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_DischargeNurse with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurse.Code LEFT OUTER JOIN
    --ED - 01910
    dbo.LU_CodeFile LU_AmbulanceArrTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceArrTimeUnknown = LU_AmbulanceArrTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AmbulanceTranTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceTranTimeUnknown = LU_AmbulanceTranTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_AccessPrimaryHealthCareCode with (nolock) on dbo.AB_Abstract.AccessCareCode = dbo.LU_AccessPrimaryHealthCareCode.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_CDUFlag with (nolock) on dbo.AB_Abstract.CDUFlag = LU_CDUFlag.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUInTimeUnknown with (nolock) on dbo.AB_Abstract.CDUInTimeUnknown = LU_CDUInTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUOutTimeUnknown with (nolock) on dbo.AB_Abstract.CDUOutTimeUnknown = LU_CDUOutTimeUnknown.Code LEFT OUTER JOIN
    --NP - 00125
    dbo.LU_CIHICorrect LU_Level1_Correction with (nolock) on dbo.AB_Abstract.IsCorrectLevel1 = LU_Level1_Correction.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_Level1_Submission with (nolock) on dbo.AB_Abstract.IsSubmitLevel1 = LU_Level1_Submission.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Validation with (nolock) on dbo.AB_Abstract.IsValidLevel1 = LU_Level1_Validation.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Completed with (nolock) on dbo.AB_Abstract.IsCompleteLevel1 = LU_Level1_Completed.Code 
--PR - 04577
    LEFT OUTER JOIN dbo.LU_ReciprocalBillingStatus with (nolock) on dbo.AB_Abstract.IsReciprocalBilling = LU_ReciprocalBillingStatus.Code 
--ED-02091 
	left join dbo.AB_NACRS with (nolock) on AB_Abstract.AbstractID = AB_NACRS.AbstractID
	left join dbo.LU_Provider LU_SpecialistNumber with (nolock) on AB_NACRS.SpecialistNumber = LU_SpecialistNumber.Code
	left join dbo.LU_ProviderSpecialty LU_SpecialistService with (nolock) on AB_NACRS.SpecialistService = LU_SpecialistService.Code
	left join dbo.LU_CodeFile LU_SpecialistRequestTimeUnknown with (nolock) on AB_NACRS.SpecialistRequestTimeUnknown = LU_SpecialistRequestTimeUnknown.Code
	left join dbo.LU_Provider LU_NonPhysicianNumber with (nolock) on AB_NACRS.NonPhysicianNumber = LU_NonPhysicianNumber.Code
	left join dbo.LU_ProviderSpecialty LU_NonPhysicianService with (nolock) on AB_NACRS.NonPhysicianService = LU_NonPhysicianService.Code
	left join dbo.LU_CodeFile LU_NonPhysicianAssessmentTimeUnknown with (nolock) on AB_NACRS.NonPhysicianAssessmentTimeUnknown = LU_NonPhysicianAssessmentTimeUnknown.Code
	
	left join dbo.LU_CodeFile LU_AmCareTypeCode with (nolock) on AB_NACRS.AmCareTypeCode = LU_AmCareTypeCode.Code
	left join dbo.LU_CodeFile LU_AmCareGroup with (nolock) on AB_NACRS.AmCareGroup = LU_AmCareGroup.Code
	--ED - 02130
	left join dbo.LU_CodeFile LU_AmCareTypeCode_FromMISCode with (nolock) on Lookup93.AmCareTypeCode = LU_AmCareTypeCode_FromMISCode.CIHIValue and LU_AmCareTypeCode_FromMISCode.LookUpID = 1101 and LU_AmCareTypeCode_FromMISCode.code between 203501 and 203513
	left join dbo.LU_CodeFile LU_AmCareGroup_FromMISCode with (nolock) on Lookup93.AmCareGroup = LU_AmCareGroup_FromMISCode.CIHIValue and LU_AmCareGroup_FromMISCode.LookUPID = 1102 and LU_AmCareGroup_FromMISCode.code between 203601 and 203605
    
    --ED - 02298
    left join dbo.LU_YesNoSystem LU_EDVisitIndicator with (nolock) on dbo.AB_NACRS.EDVisitIndicator = LU_EDVisitIndicator.Code
    left join dbo.LU_StatusAfterTriage with (nolock) on dbo.AB_NACRS.StatusAfterTriage = LU_StatusAfterTriage.Code

    left join dbo.LU_YesNoSystem LU_IsLiteSubmission with (nolock) on dbo.AB_Abstract.IsLiteSubmission = LU_IsLiteSubmission.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))










' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmcareCIHIErrors]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[I10_AmcareCIHIErrors]
AS
SELECT distinct
    dbo.AB_NACRS10_Errors.BatchPeriod, 
    dbo.AB_NACRS10_Errors.BatchYear, 
    dbo.M_AmcareErrors.ErrorDescription, 
    dbo.AB_NACRS10_Errors.ErrorFileName, 
    dbo.AB_NACRS10_Errors.ErrorID, 
    dbo.AB_NACRS10_Errors.ImportDateTime, 
    dbo.H_InstitutionProfile.DisplayCode AS InstitutionNumber, 
    dbo.H_InstitutionProfile.UserDescription AS InstitutionNumberDesc, 
    dbo.AB_NACRS10_Errors.AbstractID AS zzAbstractLink
FROM dbo.AB_NACRS10_Errors  with (nolock)
    join AB_Abstract with (nolock) on AB_Abstract.AbstractID = AB_NACRS10_Errors.AbstractID
        LEFT OUTER JOIN dbo.H_InstitutionProfile  with (nolock)
            ON dbo.AB_NACRS10_Errors.InstitutionNumber = dbo.H_InstitutionProfile.Code 
        LEFT OUTER JOIN dbo.M_AmcareErrors  with (nolock)
            ON ltrim(dbo.AB_NACRS10_Errors.ErrorID) = dbo.M_AmcareErrors.ErrorNumber
            and (case when AB_Abstract.BatchYear < 2004 then 2004 else AB_Abstract.BatchYear end) = M_AmcareErrors.BatchYear




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmcareGeneral_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'


CREATE  VIEW [dbo].[I10_AmcareGeneral_VR]
AS
SELECT     
    dbo.AB_Abstract.AbstractNumber, dbo.AB_Abstract.AbstractOverflow, 
    --PR - 04386
    LU_AccessPrimaryHealthCareCode.DisplayCode as AccessPrimaryHealthCareCode,  LU_AccessPrimaryHealthCareCode.UserDescription as AccessPrimaryHealthCareCodeDesc,
    AmbulanceArrDate as AmbulanceArrivalDate, AmbulanceArrTime as AmbulanceArrivalTime, 
    LU_AmbulanceArrTimeUnknown.DisplayCode as AmbulanceArrivalTimeUnknown,  LU_AmbulanceArrTimeUnknown.UserDescription as AmbulanceArrivalTimeUnknownDesc,
    AmbulanceTranDate as AmbulanceTransferCareDate, AmbulanceTranTime as AmbulanceTransferCareTime,
    LU_AmbulanceTranTimeUnknown.DisplayCode as AmbulanceTransferCareTimeUnknown,  LU_AmbulanceTranTimeUnknown.UserDescription as AmbulanceTransferCareTimeUnknownDesc,


    dbo.AB_Abstract.InjuryActivityDescription AS ActivityDescription, 
    Lookup2.DisplayCode AS ActivityWhenInjured, Lookup2.UserDescription AS ActivityWhenInjuredDesc, 
    -- dbo.AB_Abstract.AcuteLOS AS ActueLOS, PR - 03013
    Lookup3.DisplayCode AS AdmitbyAmbulance, Lookup3.UserDescription AS AdmitbyAmbulanceDesc, 
    -- dbo.AB_Abstract.AdmitCategory, PR - 03013
    -- dbo.AB_Abstract.AdmittingDiagnosis AS AdmitDiagnosis, 
    LU_AdmitNurse.DisplayCode AS AdmitNursingArea, LU_AdmitNurse.UserDescription AS AdmitNursingAreaDesc, 
    
    Lookup4.DisplayCode AS AgeCode, Lookup4.UserDescription AS AgeCodeDesc, 
    dbo.AB_Abstract.AgeGroup, dbo.AB_Abstract.AgeNumber, 
    -- dbo.AB_Abstract.ALCLOS,   PR - 03013
    dbo.AB_Abstract.AmbulanceReportNumber, 
    --PR - 05147 --ED-02091 & ED - 02130
    isnull(LU_AmCareGroup.DisplayCode, LU_AmCareGroup_FromMISCode.DisplayCode) AS AmCareGroup, 
    isnull(LU_AmCareGroup.UserDescription, LU_AmCareGroup_FromMISCode.UserDescription) AS AmCareGroupDesc, 
    --PR - 03012
    LU_AmCareType.DisplayCode AS AmcareCareType, LU_AmCareType.UserDescription AS AmcareCareTypeDesc, 
    --PR - 05147 --ED-02091  & ED - 02130
    isnull(LU_AmCareTypeCode.DisplayCode, LU_AmCareTypeCode_FromMISCode.DisplayCode) AS AmcareTypeCode, 
    isnull(LU_AmCareTypeCode.UserDescription, LU_AmCareTypeCode_FromMISCode.UserDescription) AS AmcareTypeCodeDesc, 

    dbo.AB_Abstract.ArrivalDate, Lookup22.DisplayCode AS ArrivalMode, 
    Lookup22.UserDescription AS ArrivalModeDesc, dbo.AB_Abstract.ArrivalTime, dbo.AB_Abstract.ArrivalTriageDifference AS ArrivaltoTriageTime, 
    dbo.AB_Abstract.AssessmentDate, dbo.AB_Abstract.AssessmentTime, Lookup159.DisplayCode AS AssessmentTimeUnknown, 
    Lookup159.UserDescription AS AssessmentTimeUnknownDesc, dbo.AB_Abstract.AttendingPhysician, dbo.AB_Abstract.BatchNumber, 
    Lookup44.DisplayCode AS BatchPeriod, Lookup44.UserDescription AS BatchPeriodDesc, dbo.AB_Abstract.BatchYear, dbo.AB_Abstract.BirthDate, 
    dbo.AB_Abstract.ChartNumber, dbo.AB_Abstract.ChiefComplaint, 
    --PR - 04386
    LU_CDUFlag.Displaycode as ClinicalDecisionUnitFlag,    LU_CDUFlag.UserDescription as ClinicalDecisionUnitFlagDesc,
    CDUArrivalDate as ClinicalDecisionUnitDateIn, CDUArrivalTime as ClinicalDecisionUnitTimeIn,
    LU_CDUInTimeUnknown.Displaycode as ClinicalDecisionUnitTimeInUnknown,    LU_CDUInTimeUnknown.UserDescription as ClinicalDecisionUnitTimeInUnknownDesc,
    CDUOutDate as ClinicalDecisionUnitDateOut, CDUOutTime as ClinicalDecisionUnitTimeOut,
    LU_CDUOutTimeUnknown.Displaycode as ClinicalDecisionUnitTimeOutUnknown,    LU_CDUOutTimeUnknown.UserDescription as ClinicalDecisionUnitTimeOutUnknownDesc,

    Lookup46.DisplayCode AS CoderNumber, 
    Lookup46.UserDescription AS CoderNumberDesc, LUCompleteRecord.DisplayCode AS CompleteRecord, 
    LUCompleteRecord.UserDescription AS CompleteRecordDesc, dbo.AB_Abstract.Complication, Lookup50.DisplayCode AS ContactMode, 
    Lookup50.UserDescription AS ContactModeDesc, Lookup52.DisplayCode AS DataEntryCoder, Lookup52.UserDescription AS DataEntryCoderDesc, 
    dbo.AB_Abstract.DateLeftER, dbo.AB_Abstract.DateReadyDischarge AS DateReadyforDisch, 

    dbo.AB_Abstract.CIHIDateSent AS DateSenttoCIHI, 
    --NP - 00125
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILevel1, 
    --ED - 02102
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILevel2, 
    --2.x-0282
    dbo.AB_Abstract.CIHIDateSentLevel1 AS DateSentToCIHILite, 

    dbo.AB_Abstract.DecisionAdmitDifference, dbo.AB_Abstract.DecisionAdmitDate AS DecisiontoAdmitDate, 
    dbo.AB_Abstract.DecisionAdmitTime AS DecisiontoAdmitTime, Lookup158.DisplayCode AS DecisionAdmitTimeUnknown, 
    Lookup158.UserDescription AS DecisionAdmitTimeUnknownDesc, 
    
    LU_DischargeNurse.DisplayCode AS DischNursingArea, LU_DischargeNurse.UserDescription AS DischNursingAreaDesc, 
    Lookup59.DisplayCode AS DischPlanning, Lookup59.UserDescription AS DischPlanningDesc, dbo.AB_Abstract.DischargeAge, 
    Lookup60.DisplayCode AS DischargeDisposition, Lookup60.UserDescription AS DischargeDispositionDesc, 
    dbo.AB_Abstract.DischargeDate AS DispositionDate, 
    dbo.AB_Abstract.DischargeTime AS DispositionTime, 
    -- PR - 01600
    LUDischargeTimeUnknown.DisplayCode as DispositionTimeUnknown, LUDischargeTimeUnknown.UserDescription as DispositionTimeUnknownDesc,
    
    Lookup64.DisplayCode AS Education, 
    Lookup64.UserDescription AS EducationDesc, 
    --ED - 02289
    LU_EDVisitIndicator.DisplayCode AS EDVisitIndicator, LU_EDVisitIndicator.UserDescription AS EDVisitIndicatorDesc,

    dbo.AB_Abstract.EncounterNumber, dbo.AB_Abstract.EncounterSequence,
    --dbo.AB_Abstract.EntryCode,  PR - 03013
    dbo.AB_Abstract.EstimatedDischargeDate AS EstimateDischDate, 
    --dbo.AB_Abstract.ExitCode, PR - 03013
    Lookup67.DisplayCode AS FamilyPhysicianFlag, Lookup67.UserDescription AS FamilyPhysicianFlagDesc, 
    dbo.AB_Abstract.FinishDate, dbo.AB_Abstract.FinishTime, dbo.AB_Abstract.FirstName, ISNULL(dbo.AB_Abstract.LastName, '' '') 
    + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS FullName, 
    FixedChartNumber,
    Lookup69.DisplayCode AS Gender, 
    Lookup69.UserDescription AS GenderDesc, Lookup157.DisplayCode AS GlasgowScale, Lookup157.UserDescription AS GlasgowScaleDesc, 
    Lookup70.DisplayCode AS HCNProvince, Lookup70.UserDescription AS HCNProvinceDesc, dbo.AB_Abstract.HCNVersion, 
    dbo.AB_Abstract.HealthCareNumber, LUHelmetIndicator.DisplayCode AS HelmetIndicator, LUHelmetIndicator.UserDescription AS HelmetIndicatorDesc, 
    LU_Hospital.DisplayCode AS Hospital, LU_Hospital.UserDescription AS HospitalDesc, 
    dbo.AB_Abstract.HospitalAccountRecord,
    dbo.AB_Abstract.ICDType, dbo.AB_Abstract.InjuryDate, Lookup72.DisplayCode AS Injury, 
	Lookup72.UserDescription AS InjuryDesc, dbo.AB_Abstract.InputDate, dbo.AB_Abstract.InputTime, 

	Lookup73.DisplayCode AS InstitutionFrom,     Lookup73.UserDescription AS InstitutionFromDesc, 
	LU_InstitutionFrom_Type.DisplayCode AS InstitutionFromType, LU_InstitutionFrom_Type.UserDescription AS InstitutionFromTypeDesc, 
	Lookup73.InstCareType AS InstFromCareType, Lookup73.HospitalType AS InstFromHospType, 
	LU_InstitutionTo_Type.DisplayCode AS InstitutionToType, LU_InstitutionTo_Type.UserDescription AS InstitutionToTypeDesc, 

    Lookup74.DisplayCode AS InstitutionNumber, Lookup74.UserDescription AS InstitutionNumberDesc, 
	
	Lookup75.DisplayCode AS InstitutionTo,     Lookup75.UserDescription AS InstitutionToDesc, 
	Lookup75.InstCareType AS InstToCareType, Lookup75.HospitalType AS InstToHospType, 
    
	dbo.AB_Abstract.InterfaceDate, dbo.AB_Abstract.InterfaceTime, 

    Lookup83.DisplayCode AS IsAbstractCompleted, Lookup83.UserDescription AS IsAbstractCompletedDesc, 
    --NP - 00125
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel1, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel1Desc, 
    --ED - 02102
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLevel2, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLevel2Desc, 
    --2.x-0282
    LU_Level1_Completed.DisplayCode AS IsAbstractCompletedLite, LU_Level1_Completed.UserDescription AS IsAbstractCompletedLiteDesc, 

    Lookup84.DisplayCode AS IsAbstractCorrected,     Lookup84.UserDescription AS IsAbstractCorrectedDesc, 
    --NP - 00125
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel1, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel1Desc, 
    --ED - 02102
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLevel2, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLevel2Desc, 
    --2.x-0282
    LU_Level1_Correction.DisplayCode AS IsAbstractCorrectedLite, LU_Level1_Correction.UserDescription AS IsAbstractCorrectedLiteDesc, 

    Lookup85.DisplayCode AS IsAbstractDeleted,     Lookup85.UserDescription AS IsAbstractDeletedDesc, 

    Lookup86.DisplayCode AS IsAbstractSubmitted,    Lookup86.UserDescription AS IsAbstractSubmittedDesc, 
    --NP - 00125 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel1, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel1Desc, 
    --ED - 02102 
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLevel2, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLevel2Desc, 
    --2.x-0282
    LU_Level1_Submission.DisplayCode AS IsAbstractSubmittedLite, LU_Level1_Submission.UserDescription AS IsAbstractSubmittedLiteDesc, 

    Lookup87.DisplayCode AS IsAbstractValidated,    Lookup87.UserDescription AS IsAbstractValidatedDesc, 
    --NP - 00125 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel1, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel1Desc, 
    --ED - 02102 
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLevel2, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLevel2Desc, 
    --2.x-0282
    LU_Level1_Validation.DisplayCode AS IsAbstractValidatedLite, LU_Level1_Validation.UserDescription AS IsAbstractValidatedLiteDesc, 

    Lookup88.DisplayCode AS IsBirthdateEstimated,     Lookup88.UserDescription AS IsBirthdateEstimatedDesc, 
	LU_CustomStatus.DisplayCode AS IsCustomValidated, LU_CustomStatus.UserDescription AS IsCustomValidatedDesc, 

	dbo.AB_Abstract.LOSDays, dbo.AB_Abstract.LOSTotal AS LOSTime, 
    dbo.AB_Abstract.LOSTime AS LOSTimeinHours, dbo.AB_Abstract.LOSMinutes AS LOSTotalMinutes, Lookup89.DisplayCode AS [Language], 
    Lookup89.UserDescription AS LanguageDesc, dbo.AB_Abstract.LastName, Lookup90.DisplayCode AS LivingArrangement, 
    Lookup90.UserDescription AS LivingArrangementDesc, Lookup91.DisplayCode AS LocationofInjury, 
    Lookup91.UserDescription AS LocationofInjuryDesc, 
    --PR - 03013
    LU_MainDiagnosis.DisplayCode as MainDiagnosisCode, LU_MainDiagnosis.UserDescription as MainDiagnosisCodeDesc,
    LU_MainDiagnosis.CIHIValue as MainDiagnosisCodeCIHI,

    LU_MainIntervention.DisplayCode as MainInterventionCode, LU_MainIntervention.UserDescription as MainInterventionCodeDesc,
    LU_MainIntervention.CIHIValue as MainInterventionCodeCIHI,

    LU_MainProvider.DisplayCode as MainProviderNumberCode, LU_MainProvider.UserDescription as MainProviderNumberDesc,
    LU_MainProviderSpecialty.DisplayCode as MainProviderSpecialty, LU_MainProviderSpecialty.UserDescription as MainProviderSpecialtyDesc,

    Lookup93.DisplayCode AS MISCode, Lookup93.UserDescription AS MISCodeDesc, 

    dbo.AB_Abstract.MaidenName, Lookup94.DisplayCode AS MaritalStatus, Lookup94.UserDescription AS MaritalStatusDesc, 
    dbo.AB_Abstract.MiddleName, 

    LU_IsLiteSubmission.DisplayCode AS NACRSClinicLiteSubmission, LU_IsLiteSubmission.UserDescription AS NACRSClinicLiteSubmissionDesc, 
    
    dbo.AB_Abstract.NewbornChart, dbo.AB_Abstract.NewbornDischargeDate AS NewbornDischDate, 
    dbo.AB_Abstract.NextSchedVisitDate AS NextScheduledVisitDate, dbo.AB_Abstract.NextSchedVisitTime AS NextScheduledVisitTime, 
    dbo.AB_Abstract.NurseAssessDate AS NursingAssessmentDate, dbo.AB_Abstract.NurseAssessTime AS NursingAssessmentTime, 
    Lookup98.DisplayCode AS Occupation, Lookup98.UserDescription AS OccupationDesc, Lookup148.DisplayCode AS PCTASIndicator, 
    Lookup148.UserDescription AS PCTASIndicatorDesc, dbo.AB_Abstract.PhysicianEstimatedLOS AS PhysicianEstLOS, dbo.AB_Abstract.PostalCode, 

    -- ED - 01682
    dbo.GetPostalDescription(isnull(dbo.AB_Abstract.PostalCode, ''''), dbo.AB_Abstract.AdmitDate) AS PostalDescription, -- ED - 01682

    dbo.AB_Abstract.PostOpDays, dbo.AB_Abstract.PreOpDays, Lookup110.DisplayCode AS PreamditWorkUp, 
    Lookup110.UserDescription AS PreamditWorkUpDesc, Lookup113.DisplayCode AS Program, Lookup113.UserDescription AS ProgramDesc, 
    Lookup118.DisplayCode AS ProvinceNumber, Lookup118.UserDescription AS ProvinceNumberDesc, 

    --PR - 03013
    LU_ReasonDiagnosis.DisplayCode as ReasonForVisitDxCode, LU_ReasonDiagnosis.UserDescription as ReasonForVisitDxCodeDesc,
    LU_ReasonDiagnosis.CIHIValue as ReasonForVisitDxCodeCIHI,

    dbo.AB_Abstract.ReAdmitCode, 
    --PR - 04577
    LU_ReciprocalBillingStatus.DisplayCode AS ReciprocalBillingStatus, LU_ReciprocalBillingStatus.UserDescription AS ReciprocalBillingStatusDesc,

    dbo.AB_Abstract.ReferralDate, Lookup135.DisplayCode AS ReferredFrom, Lookup135.UserDescription AS ReferredFromDesc, 
    Lookup136.DisplayCode AS ReferredTo, Lookup136.UserDescription AS ReferredToDesc, dbo.AB_Abstract.RegisterNumber, 
    dbo.AB_Abstract.EncounterNumber AS RegistrationNumber, dbo.AB_Abstract.EncounterSequence AS RegistrationSequenceNumber, 
    dbo.AB_Abstract.AdmitDate AS RegistrationVisitDate, dbo.AB_Abstract.AdmitTime AS RegistrationVisitTime, 
    dbo.AB_Abstract.Reserved AS ReserveField, Lookup138.DisplayCode AS ResidenceCode, Lookup138.UserDescription AS ResidenceCodeDesc, 
    Lookup139.DisplayCode AS ResidenceType, Lookup139.UserDescription AS ResidenceTypeDesc, 
    Lookup140.DisplayCode AS ResponsiblityForPayment, Lookup140.UserDescription AS ResponsiblityForPaymentDesc, 
    Lookup153.DisplayCode AS SchedEDVisit, Lookup153.UserDescription AS SchedEDVisitDesc, Lookup156.DisplayCode AS SeatbeltIndicator, 
    Lookup156.UserDescription AS SeatbeltIndicatorDesc, dbo.AB_Abstract.SecondChartRegNumber AS SecondChartRegisterNumber, 
    Lookup141.DisplayCode AS SecretVIPPatient, Lookup141.UserDescription AS SecretVIPPatientDesc, Lookup142.DisplayCode AS SiteNumber, 
    Lookup142.UserDescription AS SiteNumberDesc, Lookup143.DisplayCode AS SocialService, Lookup143.UserDescription AS SocialServiceDesc, 
    LU_StakeholderType.DisplayCode AS StakeholderType, LU_StakeholderType.UserDescription AS StakeholderTypeDesc, 
    --ED - 02289
    LU_StatusAfterTriage.DisplayCode as StatusAfterTriage, LU_StatusAfterTriage.UserDescription as StatusAfterTriageDesc,

    dbo.AB_Abstract.SurgicalCase, dbo.AB_Abstract.TimeLeftER, dbo.AB_Abstract.TransferOverloadDate, dbo.AB_Abstract.TransferOverloadTime, 
    dbo.AB_Abstract.TransferOverloadDifference AS TransferOverloadTimeDifference, dbo.AB_Abstract.TriageDate, 
    Lookup151.DisplayCode AS TriageLevel, Lookup151.UserDescription AS TriageLevelDesc, dbo.AB_Abstract.TriageTime, 
    Lookup152.DisplayCode AS TSICoder, Lookup152.UserDescription AS TSICoderDesc, dbo.AB_Abstract.TSIDate, dbo.AB_Abstract.TSITime, 
    dbo.AB_Abstract.UniqiueLifetimeID AS ULI, 
	AB_Abstract.UniversalEpisodeIdentifier,

	dbo.AB_Abstract.UnplanReAdmit AS UnplannedReadmit, Lookup154.DisplayCode AS VisitStatus, 
    Lookup154.UserDescription AS VisitStatusDesc, Lookup155.DisplayCode AS VisitType, Lookup155.UserDescription AS VisitTypeDesc, 
    -- dbo.AB_Abstract.WaitTimeER AS WaitTimeinER, PR - 03013

    dbo.AB_Abstract.WaitAssessmentDifference AS WaittoAssessmentinMinutes, 
    dbo.AB_Abstract.NurseAssessDiff AS WaittoNursingAssessmentDiff, dbo.AB_Abstract.Weight, 
    dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID, 
    dbo.AB_Abstract.VolumeID AS zzVolumeLink
FROM         
    dbo.AB_Abstract with (nolock) LEFT OUTER JOIN
    dbo.LU_CodeFile LU_StakeholderType with (nolock) on dbo.AB_Abstract.StakeHolder = LU_StakeholderType.Code LEFT OUTER JOIN
    dbo.H_HospitalProfile LU_Hospital with (nolock) on dbo.AB_Abstract.HospitalID = LU_Hospital.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LUCompleteRecord with (nolock) on dbo.AB_Abstract.CompleteRecord = LUCompleteRecord.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LUHelmetIndicator with (nolock) on dbo.AB_Abstract.HelmetIndicator = LUHelmetIndicator.Code LEFT OUTER JOIN
    dbo.LU_InjuryActivity Lookup2 with (nolock) on dbo.AB_Abstract.InjuryActivity = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_AdmitAmbulance Lookup3 with (nolock) on dbo.AB_Abstract.AdmitAmbulance = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_AgeCode Lookup4 with (nolock) on dbo.AB_Abstract.AgeCode = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_ArrivalMode Lookup22 with (nolock) on dbo.AB_Abstract.ArrivalMode = Lookup22.Code LEFT OUTER JOIN
    dbo.LU_BatchPeriod Lookup44 with (nolock) on dbo.AB_Abstract.BatchPeriod = Lookup44.Code LEFT OUTER JOIN

    dbo.U_Users Lookup46 with (nolock) on dbo.AB_Abstract.CoderNumber = Lookup46.Code LEFT OUTER JOIN
    dbo.LU_ContactMode Lookup50 with (nolock) on dbo.AB_Abstract.ContactMode = Lookup50.Code LEFT OUTER JOIN
    dbo.U_Users Lookup52 with (nolock) on dbo.AB_Abstract.DataEntryCoder = Lookup52.Code LEFT OUTER JOIN
    dbo.LU_TherDischPlan Lookup59 with (nolock) on dbo.AB_Abstract.DischargePlanning = Lookup59.Code LEFT OUTER JOIN
    dbo.LU_DispositionCode_A Lookup60 with (nolock) on dbo.AB_Abstract.DispositionCode = Lookup60.Code LEFT OUTER JOIN
    dbo.LU_Education Lookup64 with (nolock) on dbo.AB_Abstract.EducationLevel = Lookup64.Code LEFT OUTER JOIN
    dbo.LU_FamilyPhysician Lookup67 with (nolock) on dbo.AB_Abstract.FamilyPhysician = Lookup67.Code LEFT OUTER JOIN
    dbo.LU_Gender_I Lookup69 with (nolock) on dbo.AB_Abstract.Gender = Lookup69.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince Lookup70 with (nolock) on dbo.AB_Abstract.HCNProvince = Lookup70.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup72 with (nolock) on dbo.AB_Abstract.Injury = Lookup72.Code LEFT OUTER JOIN

    dbo.LU_Institution_10 Lookup73 with (nolock) on dbo.AB_Abstract.InstitutionFrom = Lookup73.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionFrom_Type with (nolock) on dbo.AB_Abstract.InstitutionFromType = LU_InstitutionFrom_Type.Code LEFT OUTER JOIN
    dbo.H_InstitutionProfile Lookup74 with (nolock) on dbo.AB_Abstract.InstitutionNumber = Lookup74.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 Lookup75 with (nolock) on dbo.AB_Abstract.InstitutionTo = Lookup75.Code LEFT OUTER JOIN
	LU_Institution_TypeCode LU_InstitutionTo_Type with (nolock) on dbo.AB_Abstract.InstitutionToType = LU_InstitutionTo_Type.Code LEFT OUTER JOIN

    dbo.LU_AbstractStatus Lookup83 with (nolock) on dbo.AB_Abstract.IsCompleted = Lookup83.Code LEFT OUTER JOIN
    dbo.LU_CIHICorrect Lookup84 with (nolock) on dbo.AB_Abstract.IsCorrected = Lookup84.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus Lookup85 with (nolock) on dbo.AB_Abstract.IsDeleted = Lookup85.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem Lookup86 with (nolock) on dbo.AB_Abstract.IsSubmited = Lookup86.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus Lookup87 with (nolock) on dbo.AB_Abstract.IsValidated = Lookup87.Code LEFT OUTER JOIN
    dbo.LU_CustomStatus with (nolock) on dbo.AB_Abstract.IsCustomValidated = LU_CustomStatus.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha Lookup88 with (nolock) on dbo.AB_Abstract.BirthDateEstimated = Lookup88.Code LEFT OUTER JOIN
    dbo.LU_Language Lookup89 with (nolock) on dbo.AB_Abstract.LanguageCode = Lookup89.Code LEFT OUTER JOIN
    dbo.LU_LivingArrangement Lookup90 with (nolock) on dbo.AB_Abstract.LivingArrangement = Lookup90.Code LEFT OUTER JOIN
    dbo.LU_InjuryLocation Lookup91 with (nolock) on dbo.AB_Abstract.InjuryLocation = Lookup91.Code LEFT OUTER JOIN
    dbo.LU_MISCode Lookup93 with (nolock) on dbo.AB_Abstract.MISCode = Lookup93.Code LEFT OUTER JOIN
    --PR - 03012
    dbo.LU_CodeFile LU_AmCareType with (nolock) on Lookup93.AmCareType = LU_AmCareType.Code LEFT OUTER JOIN

    dbo.LU_MaritalStatus Lookup94 with (nolock) on dbo.AB_Abstract.MaritalStatus = Lookup94.Code LEFT OUTER JOIN
    dbo.LU_Occupation Lookup98 with (nolock) on dbo.AB_Abstract.Occupation = Lookup98.Code LEFT OUTER JOIN
    dbo.LU_TherPreAdmitWorkUp Lookup110 with (nolock) on dbo.AB_Abstract.PreAdmitWorkUp = Lookup110.Code LEFT OUTER JOIN
    dbo.LU_Program Lookup113 with (nolock) on dbo.AB_Abstract.Program = Lookup113.Code LEFT OUTER JOIN
    dbo.LU_Province Lookup118 with (nolock) on dbo.AB_Abstract.ProvinceNumber = Lookup118.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup135 with (nolock) on dbo.AB_Abstract.ReferredFrom = Lookup135.Code LEFT OUTER JOIN
    dbo.LU_Referral Lookup136 with (nolock) on dbo.AB_Abstract.ReferredTo = Lookup136.Code LEFT OUTER JOIN
    dbo.LU_ResidenceCode Lookup138 with (nolock) on dbo.AB_Abstract.ResidenceCode = Lookup138.Code LEFT OUTER JOIN
    dbo.LU_ResidenceType Lookup139 with (nolock) on dbo.AB_Abstract.ResidenceType = Lookup139.Code LEFT OUTER JOIN
    dbo.LU_RespPayment Lookup140 with (nolock) on dbo.AB_Abstract.ResponsiblePayment = Lookup140.Code LEFT OUTER JOIN
    dbo.LU_YesBlank Lookup141 with (nolock) on dbo.AB_Abstract.Secret = Lookup141.Code LEFT OUTER JOIN
    dbo.LU_Site Lookup142 with (nolock) on dbo.AB_Abstract.SiteNumber = Lookup142.Code LEFT OUTER JOIN
    dbo.LU_TherSocialService Lookup143 with (nolock) on dbo.AB_Abstract.SocialService = Lookup143.Code LEFT OUTER JOIN
    dbo.LU_TriageLevel Lookup151 with (nolock) on dbo.AB_Abstract.TriageLevel = Lookup151.Code LEFT OUTER JOIN
    dbo.U_Users Lookup152 with (nolock) on dbo.AB_Abstract.TSICoder = Lookup152.Code LEFT OUTER JOIN
    dbo.LU_VisitType Lookup154 with (nolock) on dbo.AB_Abstract.VisitStatus = Lookup154.Code LEFT OUTER JOIN
    dbo.LU_VisitType_10 Lookup155 with (nolock) on dbo.AB_Abstract.VisitType = Lookup155.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup148 with (nolock) on dbo.AB_Abstract.PCTASIndicator = Lookup148.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha Lookup153 with (nolock) on dbo.AB_Abstract.SchedEDVisit = Lookup153.Code LEFT OUTER JOIN
    dbo.LU_CodeFile Lookup156 with (nolock) on dbo.AB_Abstract.SeatbeltIndicator = Lookup156.Code AND Lookup156.LookupID = 2 LEFT OUTER JOIN
    dbo.LU_Glasgow Lookup157 with (nolock) on dbo.AB_Abstract.GlasgowComaScale = Lookup157.Code left join
    dbo.LU_CodeFile Lookup158 with (nolock) on Lookup158.Code = dbo.AB_Abstract.DecisionAdmitTimeUnknown AND Lookup158.LookupID = 1 left join
    dbo.LU_CodeFile Lookup159 with (nolock) on Lookup159.Code = dbo.AB_Abstract.AssessmentTimeUnknown AND Lookup159.LookupID = 1 Left Join
    -- PR - 01600
    LU_CodeFile LUDischargeTimeUnknown with (nolock) on dbo.AB_Abstract.DischargeTimeUnknown = LUDischargeTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_AdmitNurse with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurse.Code LEFT OUTER JOIN
    dbo.LU_NurseArea LU_DischargeNurse with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurse.Code LEFT JOIN
    -- PR - 03013
    dbo.AB_Diagnosis AB_MainDiagnosis with (nolock) on dbo.AB_Abstract.AbstractID = AB_MainDiagnosis.AbstractID and AB_MainDiagnosis.DiagnosisOccurrence = 1 LEFT JOIN
    dbo.ICD_DiagFile10 LU_MainDiagnosis with (nolock) on AB_MainDiagnosis.DiagnosisCode = LU_MainDiagnosis.Code LEFT OUTER JOIN
    dbo.AB_Provider AB_MainProvider with (nolock) on dbo.AB_Abstract.AbstractID = AB_MainProvider.AbstractID and AB_MainProvider.ProviderOccurrence = 1 LEFT JOIN
    dbo.LU_Provider LU_MainProvider with (nolock) on AB_MainProvider.ProviderNumber = LU_MainProvider.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty LU_MainProviderSpecialty with (nolock) on AB_MainProvider.ProviderSpecialty = LU_MainProviderSpecialty.Code LEFT OUTER JOIN

    dbo.AB_Intervention AB_MainIntervention with (nolock) on dbo.AB_Abstract.AbstractID = AB_MainIntervention.AbstractID and AB_MainIntervention.IntervOccurrence = 1 LEFT JOIN
    dbo.ICD_ProcFile10 LU_MainIntervention with (nolock) on AB_MainIntervention.IntervCode = LU_MainIntervention.Code LEFT OUTER JOIN

    dbo.AB_Diagnosis AB_ReasonDiagnosis with (nolock) on dbo.AB_Abstract.AbstractID = AB_ReasonDiagnosis.AbstractID and dbo.AB_Abstract.Admitdate > ''2006/03/31'' 
        and AB_ReasonDiagnosis.DiagnosisPrefix in (select code from dbo.LU_DiagnosisPrefix LU_ReasonVisit where LU_ReasonVisit.CIHIValue = ''R'') LEFT OUTER JOIN
    dbo.ICD_DiagFile10 LU_ReasonDiagnosis with (nolock) on AB_ReasonDiagnosis.DiagnosisCode = LU_ReasonDiagnosis.Code LEFT OUTER JOIN
    --PR - 04386
    dbo.LU_CodeFile LU_AmbulanceArrTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceArrTimeUnknown = LU_AmbulanceArrTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AmbulanceTranTimeUnknown with (nolock) on dbo.AB_Abstract.AmbulanceTranTimeUnknown = LU_AmbulanceTranTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_AccessPrimaryHealthCareCode with (nolock) on dbo.AB_Abstract.AccessCareCode = dbo.LU_AccessPrimaryHealthCareCode.Code LEFT OUTER JOIN
    dbo.LU_YesNoAlpha LU_CDUFlag with (nolock) on dbo.AB_Abstract.CDUFlag = LU_CDUFlag.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUInTimeUnknown with (nolock) on dbo.AB_Abstract.CDUInTimeUnknown = LU_CDUInTimeUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_CDUOutTimeUnknown with (nolock) on dbo.AB_Abstract.CDUOutTimeUnknown = LU_CDUOutTimeUnknown.Code LEFT OUTER JOIN
    --NP - 00125
    dbo.LU_CIHICorrect LU_Level1_Correction with (nolock) on dbo.AB_Abstract.IsCorrectLevel1 = LU_Level1_Correction.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_Level1_Submission with (nolock) on dbo.AB_Abstract.IsSubmitLevel1 = LU_Level1_Submission.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Validation with (nolock) on dbo.AB_Abstract.IsValidLevel1 = LU_Level1_Validation.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_Level1_Completed with (nolock) on dbo.AB_Abstract.IsCompleteLevel1 = LU_Level1_Completed.Code 
--PR - 04577
    LEFT OUTER JOIN dbo.LU_ReciprocalBillingStatus with (nolock) on dbo.AB_Abstract.IsReciprocalBilling = LU_ReciprocalBillingStatus.Code 

--PR - 05147 
	left join dbo.AB_NACRS with (nolock) on AB_Abstract.AbstractID = AB_NACRS.AbstractID
	left join dbo.LU_CodeFile LU_AmCareTypeCode with (nolock) on AB_NACRS.AmCareTypeCode = LU_AmCareTypeCode.Code
	left join dbo.LU_CodeFile LU_AmCareGroup with (nolock) on AB_NACRS.AmCareGroup = LU_AmCareGroup.Code
	left join dbo.LU_CodeFile LU_AmCareTypeCode_FromMISCode with (nolock) on Lookup93.AmCareTypeCode = LU_AmCareTypeCode_FromMISCode.CIHIValue and LU_AmCareTypeCode_FromMISCode.LookUpID = 1101 and LU_AmCareTypeCode_FromMISCode.code between 203501 and 203513
	left join dbo.LU_CodeFile LU_AmCareGroup_FromMISCode with (nolock) on Lookup93.AmCareGroup = LU_AmCareGroup_FromMISCode.CIHIValue and LU_AmCareGroup_FromMISCode.LookUPID = 1102 and LU_AmCareGroup_FromMISCode.code between 203601 and 203605
    --ED - 02298
    left join dbo.LU_YesNoSystem LU_EDVisitIndicator with (nolock) on dbo.AB_NACRS.EDVisitIndicator = LU_EDVisitIndicator.Code
    left join dbo.LU_StatusAfterTriage with (nolock) on dbo.AB_NACRS.StatusAfterTriage = LU_StatusAfterTriage.Code
    left join dbo.LU_YesNoSystem LU_IsLiteSubmission with (nolock) on dbo.AB_Abstract.IsLiteSubmission = LU_IsLiteSubmission.Code

WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_AmcareRecordKey_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[I10_AmcareRecordKey_VR]
AS
SELECT
	--PR - 07231
	LU_AdmitNurseArea.DisplayCode AS AdmitNurseAreaUnitLoc, LU_AdmitNurseArea.UserDescription AS AdmitNurseAreaUnitLocDesc, 

    LU_AmCareGroup_FromMISCode.DisplayCode AS AmCareGroup,          LU_AmCareGroup_FromMISCode.UserDescription AS AmCareGroupDesc, 
    LU_AmCareTypeCode_FromMISCode.DisplayCode AS AmcareTypeCode,    LU_AmCareTypeCode_FromMISCode.UserDescription AS AmcareTypeCodeDesc, 

    dbo.AB_Abstract.ChartNumber, 
	U_Users.DisplayCode AS CoderNumber, U_Users.UserDescription AS CoderNumberDesc, --ED - 02401
    DateLeftER as DatePatientLeftED, 
    LU_DispositionCode_A.DisplayCode AS DischargeDisposition, LU_DispositionCode_A.UserDescription AS DischargeDispositionDesc, 
    dbo.AB_Abstract.DischargeDate AS DispositionDate, dbo.AB_Abstract.DischargeTime AS DispositionTime, 
	--PR - 07231
	LU_DischargeNurseArea.DisplayCode AS DischNurseAreaUnitLoc, LU_DischargeNurseArea.UserDescription AS DischNurseAreaUnitLocDesc, 

    ISNULL(dbo.AB_Abstract.LastName, '' '') + '', '' + ISNULL(dbo.AB_Abstract.FirstName, '''') + '' '' + ISNULL(dbo.AB_Abstract.MiddleName, '''') AS FullName,     
    FixedChartNumber,
    dbo.AB_Abstract.HealthCareNumber, 
    H_InstitutionProfile.DisplayCode AS InstitutionNumber, H_InstitutionProfile.UserDescription AS InstitutionNumberDesc, 
    LU_MISCode.DisplayCode AS MISCode, LU_MISCode.UserDescription AS MISCodeDesc, 
    ReAdmitDifferenceDaysForNACRS = dbo.CalculateReAdmitDifferenceDaysForNACRS(ChartNumber, AdmitDate, AbstractID),
    dbo.AB_Abstract.EncounterNumber as RegistrationNumber,
    dbo.AB_Abstract.AdmitDate AS RegistrationVisitDate, dbo.AB_Abstract.AdmitTime AS RegistrationVisitTime, 
    TimeLeftER as TimePatientLeftED,
    dbo.AB_Abstract.AbstractID AS zzAbstractLink,
    dbo.AB_Abstract.RegionalPatientID as zzRegionalPatientID
FROM         
    dbo.AB_Abstract with (nolock) inner JOIN
    dbo.H_InstitutionProfile with (nolock) ON dbo.AB_Abstract.InstitutionNumber = H_InstitutionProfile.Code 
    left join LU_MISCode with (nolock) on LU_MISCode.Code = MISCode
    --ED - 02401
	left join U_Users with (nolock) on AB_Abstract.CoderNumber = U_Users.Code 
    left join dbo.LU_DispositionCode_A with (nolock) on dbo.AB_Abstract.DispositionCode = LU_DispositionCode_A.Code 
    --PR - 07231
    left join dbo.LU_NurseArea LU_AdmitNurseArea with (nolock) on dbo.AB_Abstract.AdmittingNurseArea = LU_AdmitNurseArea.Code 
    left join dbo.LU_NurseArea LU_DischargeNurseArea with (nolock) on dbo.AB_Abstract.DischargeNurseArea = LU_DischargeNurseArea.Code 
    left join dbo.H_HospitalProfile with (nolock) on dbo.AB_Abstract.HospitalID = H_HospitalProfile.Code 

--	left join dbo.LU_CodeFile LU_AmCareTypeCode with (nolock) on AB_NACRS.AmCareTypeCode = LU_AmCareTypeCode.Code
--	left join dbo.LU_CodeFile LU_AmCareGroup with (nolock) on AB_NACRS.AmCareGroup = LU_AmCareGroup.Code
	left join dbo.LU_CodeFile LU_AmCareTypeCode_FromMISCode with (nolock) on LU_MISCode.AmCareTypeCode = LU_AmCareTypeCode_FromMISCode.CIHIValue and LU_AmCareTypeCode_FromMISCode.LookUpID = 1101 and LU_AmCareTypeCode_FromMISCode.code between 203501 and 203513
	left join dbo.LU_CodeFile LU_AmCareGroup_FromMISCode with (nolock) on LU_MISCode.AmCareGroup = LU_AmCareGroup_FromMISCode.CIHIValue and LU_AmCareGroup_FromMISCode.LookUPID = 1102 and LU_AmCareGroup_FromMISCode.code between 203601 and 203605

WHERE     (dbo.AB_Abstract.ICDType = ''T'') AND (dbo.AB_Abstract.CareType = 5)
--QA - 00032 disable the domain securite issue
----PR - 07485
--    and (Suser_Sname() in (''MED2020Main'', ''WinRecs'') or AB_ABstract.HospitalID is null or AB_ABstract.HospitalID = 0
--    --EN - 00666
--        or Is_Member(nullif(ReportGroup, '''')) = 1)
----        or (select isnull(HospitalID, 0) from U_Users where NTAuthority = Suser_Sname()) in (0, isnull(AB_ABstract.HospitalID, 0))
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_BasicOption_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[I10_BasicOption_VR]
as
select
    BasicOption1  = dbo.lu_BasicOption1.DisplayCode,  BasicOption1Desc  = dbo.lu_BasicOption1.UserDescription,
    BasicOption2  = dbo.lu_BasicOption2.DisplayCode,  BasicOption2Desc  = dbo.lu_BasicOption2.UserDescription,
    BasicOption3  = dbo.lu_BasicOption3.DisplayCode,  BasicOption3Desc  = dbo.lu_BasicOption3.UserDescription,
    BasicOption4  = dbo.lu_BasicOption4.DisplayCode,  BasicOption4Desc  = dbo.lu_BasicOption4.UserDescription,
    BasicOption5  = dbo.lu_BasicOption5.DisplayCode,  BasicOption5Desc  = dbo.lu_BasicOption5.UserDescription,
    BasicOption6  = dbo.lu_BasicOption6.DisplayCode,  BasicOption6Desc  = dbo.lu_BasicOption6.UserDescription,
    BasicOption7  = dbo.lu_BasicOption7.DisplayCode,  BasicOption7Desc  = dbo.lu_BasicOption7.UserDescription,
    BasicOption8  = dbo.lu_BasicOption8.DisplayCode,  BasicOption8Desc  = dbo.lu_BasicOption8.UserDescription,
    BasicOption9  = dbo.lu_BasicOption9.DisplayCode,  BasicOption9Desc  = dbo.lu_BasicOption9.UserDescription,
    BasicOption10 = dbo.lu_BasicOption10.DisplayCode, BasicOption10Desc = dbo.lu_BasicOption10.UserDescription,
    BasicOption11 = dbo.lu_BasicOption11.DisplayCode, BasicOption11Desc = dbo.lu_BasicOption11.UserDescription,
    BasicOption12 = dbo.lu_BasicOption12.DisplayCode, BasicOption12Desc = dbo.lu_BasicOption12.UserDescription,
    BasicOption13 = dbo.lu_BasicOption13.DisplayCode, BasicOption13Desc = dbo.lu_BasicOption13.UserDescription,
    BasicOption14 = dbo.lu_BasicOption14.DisplayCode, BasicOption14Desc = dbo.lu_BasicOption14.UserDescription,
    BasicOption15 = dbo.lu_BasicOption15.DisplayCode, BasicOption15Desc = dbo.lu_BasicOption15.UserDescription,
    BasicOption16 = dbo.lu_BasicOption16.DisplayCode, BasicOption16Desc = dbo.lu_BasicOption16.UserDescription,
    BasicOption17 = dbo.lu_BasicOption17.DisplayCode, BasicOption17Desc = dbo.lu_BasicOption17.UserDescription,
    BasicOption18 = dbo.lu_BasicOption18.DisplayCode, BasicOption18Desc = dbo.lu_BasicOption18.UserDescription,
    BasicOption19 = dbo.lu_BasicOption19.DisplayCode, BasicOption19Desc = dbo.lu_BasicOption19.UserDescription,
    dbo.AB_BasicOption.AbstractID as zzabstractlink
from dbo.ab_abstract with (nolock) inner join 
    dbo.AB_BasicOption with (nolock) on dbo.ab_abstract.AbstractID = dbo.AB_BasicOption.AbstractID
    left join dbo.lu_BasicOption1  with (nolock) on dbo.AB_BasicOption.BasicOption1  =  dbo.lu_BasicOption1.Code
    left join dbo.lu_BasicOption2  with (nolock) on dbo.AB_BasicOption.BasicOption2  =  dbo.lu_BasicOption2.Code
    left join dbo.lu_BasicOption3  with (nolock) on dbo.AB_BasicOption.BasicOption3  =  dbo.lu_BasicOption3.Code
    left join dbo.lu_BasicOption4  with (nolock) on dbo.AB_BasicOption.BasicOption4  =  dbo.lu_BasicOption4.Code
    left join dbo.lu_BasicOption5  with (nolock) on dbo.AB_BasicOption.BasicOption5  =  dbo.lu_BasicOption5.Code
    left join dbo.lu_BasicOption6  with (nolock) on dbo.AB_BasicOption.BasicOption6  =  dbo.lu_BasicOption6.Code
    left join dbo.lu_BasicOption7  with (nolock) on dbo.AB_BasicOption.BasicOption7  =  dbo.lu_BasicOption7.Code
    left join dbo.lu_BasicOption8  with (nolock) on dbo.AB_BasicOption.BasicOption8  =  dbo.lu_BasicOption8.Code
    left join dbo.lu_BasicOption9  with (nolock) on dbo.AB_BasicOption.BasicOption9  =  dbo.lu_BasicOption9.Code
    left join dbo.lu_BasicOption10 with (nolock) on dbo.AB_BasicOption.BasicOption10 =  dbo.lu_BasicOption10.Code
    left join dbo.lu_BasicOption11 with (nolock) on dbo.AB_BasicOption.BasicOption11 =  dbo.lu_BasicOption11.Code
    left join dbo.lu_BasicOption12 with (nolock) on dbo.AB_BasicOption.BasicOption12 =  dbo.lu_BasicOption12.Code
    left join dbo.lu_BasicOption13 with (nolock) on dbo.AB_BasicOption.BasicOption13 =  dbo.lu_BasicOption13.Code
    left join dbo.lu_BasicOption14 with (nolock) on dbo.AB_BasicOption.BasicOption14 =  dbo.lu_BasicOption14.Code
    left join dbo.lu_BasicOption15 with (nolock) on dbo.AB_BasicOption.BasicOption15 =  dbo.lu_BasicOption15.Code
    left join dbo.lu_BasicOption16 with (nolock) on dbo.AB_BasicOption.BasicOption16 =  dbo.lu_BasicOption16.Code
    left join dbo.lu_BasicOption17 with (nolock) on dbo.AB_BasicOption.BasicOption17 =  dbo.lu_BasicOption17.Code
    left join dbo.lu_BasicOption18 with (nolock) on dbo.AB_BasicOption.BasicOption18 =  dbo.lu_BasicOption18.Code
    left join dbo.lu_BasicOption19 with (nolock) on dbo.AB_BasicOption.BasicOption19 =  dbo.lu_BasicOption19.Code
where ICDType = ''T''


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMG_2002Percentile]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'





CREATE   VIEW [dbo].[I10_CMG_2002Percentile]
AS
SELECT     dbo.CMG_ETC_2002T.ModelType, dbo.CMG_ETC_2002T.TenthPercent, dbo.CMG_ETC_2002T.TwentyFifthPercent, 
                      dbo.CMG_ETC_2002T.FiftiethPercent, AB_CMG.CMG_Year, dbo.AB_CMG.AbstractID AS zzAbstractLink
FROM         dbo.AB_CMG with (nolock) LEFT OUTER JOIN
                      dbo.AB_Abstract with (nolock) ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.CMG_ETC_2002T with (nolock) ON dbo.AB_CMG.Complexity = dbo.CMG_ETC_2002T.cicpxlvl AND dbo.AB_CMG.CMG = dbo.CMG_ETC_2002T.cmgcode
WHERE     (dbo.AB_CMG.CMG_Year = 2002) AND (dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber BETWEEN 18 AND 68) AND 
                      (dbo.CMG_ETC_2002T.ciagegroup = 2)
union all
SELECT     dbo.CMG_ETC_2002T.ModelType, dbo.CMG_ETC_2002T.TenthPercent, dbo.CMG_ETC_2002T.TwentyFifthPercent, 
                      dbo.CMG_ETC_2002T.FiftiethPercent, AB_CMG.CMG_Year, dbo.AB_CMG.AbstractID AS zzAbstractLink
FROM         dbo.AB_CMG with (nolock) LEFT OUTER JOIN
                      dbo.AB_Abstract with (nolock) ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.CMG_ETC_2002T with (nolock) ON dbo.AB_CMG.Complexity = dbo.CMG_ETC_2002T.cicpxlvl AND dbo.AB_CMG.CMG = dbo.CMG_ETC_2002T.cmgcode
WHERE     (dbo.AB_CMG.CMG_Year = 2002) AND (dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber BETWEEN 0 AND 17) AND 
                      (dbo.CMG_ETC_2002T.ciagegroup = 1) OR
                      (dbo.AB_CMG.CMG_Year = 2002) AND (dbo.AB_Abstract.AgeCode <> 3) AND (dbo.CMG_ETC_2002T.ciagegroup = 1)
union all
SELECT     dbo.CMG_ETC_2002T.ModelType, dbo.CMG_ETC_2002T.TenthPercent, dbo.CMG_ETC_2002T.TwentyFifthPercent, 
                      dbo.CMG_ETC_2002T.FiftiethPercent, AB_CMG.CMG_Year, dbo.AB_CMG.AbstractID AS zzAbstractLink
FROM         dbo.AB_CMG with (nolock) LEFT OUTER JOIN
                      dbo.AB_Abstract with (nolock) ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.CMG_ETC_2002T with (nolock) ON dbo.AB_CMG.Complexity = dbo.CMG_ETC_2002T.cicpxlvl AND dbo.AB_CMG.CMG = dbo.CMG_ETC_2002T.cmgcode
WHERE     (dbo.AB_CMG.CMG_Year = 2002) AND (dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber > 68) AND 
                      (dbo.CMG_ETC_2002T.ciagegroup = 3)







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMG_NonComplex_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[I10_CMG_NonComplex_VR]
AS
SELECT DISTINCT 
                      dbo.CMG_NonReporting.ciagelos AS MOHELOS, dbo.CMG_NonReporting.ciagtrim AS MOHTrim, dbo.AB_Abstract.AbstractID AS zzAbstractLink, 
                      dbo.AB_CMG.CMG_Year AS CMG_YearNonComplex
FROM         dbo.AB_CMG with (nolock) LEFT OUTER JOIN
    dbo.AB_Abstract with (nolock) INNER JOIN
    dbo.CMG_NonReporting with (nolock) ON dbo.AB_Abstract.AgeGroup = dbo.CMG_NonReporting.ciagegroup ON 
    dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID AND dbo.AB_CMG.CMG_Year = dbo.CMG_NonReporting.CMGNonYear AND 
    dbo.AB_CMG.CMG = dbo.CMG_NonReporting.CMGCode and 
    ((AB_Abstract.DischargeDate > ''2009/03/31'' and dbo.CMG_NonReporting.FiscalYear = 2008) or
     (AB_Abstract.DischargeDate between ''2007/04/01'' and ''2009/03/31'' and dbo.CMG_NonReporting.FiscalYear = 2007) or 
     (AB_Abstract.DischargeDate < ''2007/04/01'' and dbo.CMG_NonReporting.FiscalYear = 2006) or
     dbo.AB_CMG.CMG_Year < 2006 )
WHERE     (dbo.AB_CMG.CMG_Year > 2001) AND (dbo.AB_Abstract.AbstractID IS NOT NULL) AND (dbo.AB_CMG.OccurrenceNumber = 1)



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_CMG_VR]
AS
SELECT     dbo.AB_CMG.AcuteQuartile AS Acute_Quartile, 
	dbo.AB_CMG.BatchGroupDate,
	dbo.AB_CMG.CMG, dbo.AB_CMG.CMG_Description, 
	dbo.AB_CMG_FI.MedicalCMG, dbo.tGrouper_CMG_CMG.cmg_long_e_desc as MedicalCMGDesciption,
	dbo.AB_CMG.CMG_ELOS, dbo.AB_CMG.CMG_Split, 
    dbo.AB_CMG.CMG_Year, 
    dbo.AB_CMG.CMGAgeCategory, dbo.tGrouper_CMG_CMG_AGE_CATEGORY.CMG_AGE_CATEGORY_E_DESC AS CMGAgeCategoryDesc, 
    dbo.AB_CMG_FI.CMGReturnCode, 
    dbo.AB_CMG.ComorbidityLevel, dbo.tGrouper_CMG_COMORBIDITY_LEVEL.COMORBIDITY_LEVEL_E_DESC AS ComorbidityLevelDesc, 
    dbo.AB_CMG_FI.ComorbidityTotalFactor,
    dbo.AB_CMG.Complexity, dbo.CMG_LU_Complexity.UserDescription AS Complexity_Description, 
    dbo.ICD_DiagFile10.CIHIValue AS Diagnosis_CIHIValue, 
    dbo.ICD_DiagFile10.DisplayCode AS Diagnosis_Code, dbo.ICD_DiagFile10.UserDescription AS Diagnosis_Description, 
    dbo.ICD_DiagFile10.ShortDescription AS Diagnosis_CodeShortDesc, dbo.LU_DiagnosisType.DisplayCode AS Diagnosis_Type, 
    dbo.LU_DiagnosisType.UserDescription AS Diagnosis_Type_Desc, dbo.tGrouper_CMG_MCC_PARTITION.MCC_PARTITION_CODE AS DxIntervPartition, 
    dbo.tGrouper_CMG_MCC_PARTITION.MCC_PARTITION_E_DESC AS DxIntervPartitionDesc, 
    dbo.AB_CMG_FI.FI_BiopsyFlag,    --PR - 04306
    dbo.AB_CMG_FI.FI_CardioversionFlag, 
    dbo.AB_CMG_FI.FI_CellSaverFlag, 
	dbo.AB_CMG_FI.FI_ChemotherapyFlag, 
	dbo.AB_CMG_FI.FI_DialysisFlag, 
	dbo.AB_CMG_FI.FI_ECMOFlag,
    dbo.AB_CMG_FI.FI_EndoscopyFlag,    --PR - 04306 
    dbo.AB_CMG_FI.FI_FeedingTubeFlag, 
    dbo.AB_CMG_FI.FI_HeartResuscitationFlag, 
	FI_InvasiveVentilationGreat96Hours = dbo.AB_CMG_FI.FI_MechanicalVentGreat96Hours, 
	FI_InvasiveVentilationLess96Hours = dbo.AB_CMG_FI.FI_MechanicalVentLess96Hours, 
    dbo.AB_CMG_FI.FI_MechanicalVentGreat96Hours, 
    dbo.AB_CMG_FI.FI_MechanicalVentLess96Hours, 
	dbo.AB_CMG_FI.FI_ParacentesisFlag, 
	dbo.AB_CMG_FI.FI_ParenteralNutritionFlag, 
    dbo.AB_CMG_FI.FI_PleurocentesisFlag, 
	dbo.AB_CMG_FI.FI_RadiotherapyFlag, 
	dbo.AB_CMG_FI.FI_TracheostomyFlag, 
    dbo.AB_CMG_FI.FI_VascularAccessDdeviceFlag, 
    dbo.AB_CMG.CMGFiftiethPercent AS FiftiethPercentile, 
    
    FlaggedIntervFactorCount = (case when AB_CMG.CMG_year < 2015 then dbo.AB_CMG.FlaggedIntervFactorCount else null end), 
    FlaggedIntervFactorCountDesc = (case when AB_CMG.CMG_year < 2015 then dbo.tGrouper_CMG_FLAGGED_INTERV_CNT.FLAGGED_INTERV_E_DESC else null end), 
	--2.x-0549
	FlaggedInterventionGroup1 = (case when FI_MechanicalVentGreat96Hours = 1  or FI_ECMOFlag =  1 then ''Y'' else ''N'' end),
	FlaggedInterventionGroup2 = (case when FI_FeedingTubeFlag = 1 or FI_MechanicalVentLess96Hours = 1 or FI_ParenteralNutritionFlag = 1 or FI_TracheostomyFlag = 1 or
										   FI_VascularAccessDdeviceFlag = 1 then ''Y'' else ''N'' end),
	FlaggedInterventionGroup3 = (case when FI_CardioversionFlag = 1 or FI_CellSaverFlag = 1 or FI_ChemotherapyFlag = 1 or FI_DialysisFlag = 1 or FI_HeartResuscitationFlag = 1 or
										   FI_ParacentesisFlag = 1 or FI_PleurocentesisFlag = 1 or FI_RadiotherapyFlag = 1 or FI_BiopsyFlag =  1 or FI_EndoscopyFlag =  1
									  then ''Y'' else ''N'' end),

    FlaggedInterventionStatusCode = (case when AB_CMG.CMG_year >= 2015 then dbo.AB_CMG.FlaggedIntervFactorCount else null end), 
    FlaggedInterventionStatusCodeDesc = (case when AB_CMG.CMG_year >= 2015 then dbo.tGrouper_CMG_FLAGGED_INTERV_STATUS.flagged_interv_status_e_desc else null end), 
    
    dbo.AB_CMG.ICD_Type, 
    dbo.AB_CMG.InpatientRILevel, dbo.tGrouper_CMG_IP_RI_LEVEL.IP_RI_LEVEL_E_DESC AS InpatientRILevelDesc, 
    dbo.AB_CMG_FI.InpatientRITotalFactor,
    dbo.AB_CMG.InpatientRIWAtypicalCode, dbo.tGrouper_CMG_IP_RIW_ATYPICAL.IP_RIW_ATYPICAL_E_DESC AS InpatientRIWAtypicalCodeDesc, 
    LU_Intervention.DisplayCode AS InterventionAssignment, LU_Intervention.CIHIValue AS InterventionAssignmentCIHI, 
    LU_Intervention.UserDescription AS InterventionAssignmentDesc, 
    dbo.AB_CMG_FI.IntervAttStatus as InterventionAttributeStatus, 
    dbo.AB_CMG_FI.IntervAttLocation as InterventionAttributeLocation,
    dbo.AB_CMG_FI.IntervAttExtent as InterventionAttributeExtent,
    dbo.AB_CMG_FI.IntervEpisode as InterventionEpisode,
    dbo.AB_CMG.InterventionEventCount, 
    dbo.tGrouper_CMG_INTERVENTION_EVENT_CNT.INTERV_EVENT_CNT_E_DESC AS InterventionEventCountDesc, dbo.AB_CMG.InterventionOOHCount, 
    dbo.tGrouper_CMG_INTERVENTION_OOH_CNT.INTERV_OOH_CNT_E_DESC AS InterventionOOHCountDesc, dbo.AB_CMG.MCC, 
    dbo.tGrouper_CMG_MCC_LOGIC.mcc_long_e_desc AS MCC_Description, dbo.AB_CMG.MCC_Surg, dbo.AB_CMG.CMGModelType AS ModelType, 
    dbo.AB_CMG.MOH_Dollar, 
    dbo.AB_CMG.MOH_RIW,
    dbo.AB_CMG.OccurrenceNumber AS Occurrence_Number, 
    PercentileAgeGroup = (case when dbo.AB_CMG.CMGAgeCategory in (''A'', ''B'', ''C'', ''F'', ''G'', ''H'') then 1
                               when dbo.AB_CMG.CMGAgeCategory = ''R'' then 2
                               when dbo.AB_CMG.CMGAgeCategory = ''S'' then 3
                               when dbo.AB_CMG.CMGAgeCategory = ''T'' then 4
                          end),                          
    dbo.AB_CMG.CMG_RIW AS RIW, dbo.AB_CMG_FI.InpatientTypicalRIW,
    dbo.AB_CMG.RIW_Dollar, dbo.AB_CMG.CMGTenthPercent AS TenthPercentile, dbo.AB_CMG.CMG_Trim AS Trim, 
    dbo.AB_CMG.CMGTwentyFifthPercent AS TwentyFifthPercentile, 
    HIG_Code, HIG_Description, HIG_Weight, 
    HIG_AgeCategory, HIG_AgeCategoryDesc = (select top 1 hig_age_category_e_desc from dbo.tGrouper_HIG_Age_Category a where a.hig_age_category_code = HIG_AgeCategory and a.methodology_year = AB_HIG.GrouperYear),
    HIG_AtypicalCode, HIG_AtypicalCodeDesc = (select top 1 hig_atypical_e_desc from dbo.tGrouper_HIG_Atypical b where b.hig_atypical_code = HIG_AtypicalCode and b.methodology_year = AB_HIG.GrouperYear),
    HIG_ELOS, HIG_FI_TotalCount, 
    HIG_HomeCareFlag, HIG_MaternalAgeFlag, HIG_PalliativeCareFlag, HIG_OOHFlag, HIG_SCUFlag, HIG_LongStayTrimDays, HIG_ShortStayTrimDays, 
    dbo.AB_CMG.AbstractID AS zzAbstractLink
FROM         dbo.AB_CMG with (nolock) LEFT OUTER JOIN
      dbo.AB_CMG_FI with (nolock) on dbo.AB_CMG.AbstractID = dbo.AB_CMG_FI.AbstractID and dbo.AB_CMG.CMG_year = dbo.AB_CMG_FI.CMG_year
            and dbo.AB_CMG.OccurrenceNumber = dbo.AB_CMG_FI.OccurrenceNumber LEFT OUTER JOIN
      dbo.tGrouper_CMG_MCC_PARTITION with (nolock) on dbo.AB_CMG.CMG_Partition = dbo.tGrouper_CMG_MCC_PARTITION.MCC_PARTITION_CODE 
            and dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_MCC_PARTITION.METHODOLOGY_YEAR LEFT OUTER JOIN
      dbo.tGrouper_CMG_IP_RI_LEVEL with (nolock) on dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_IP_RI_LEVEL.METHODOLOGY_YEAR AND 
      dbo.AB_CMG.InpatientRILevel = dbo.tGrouper_CMG_IP_RI_LEVEL.IP_RI_LEVEL_CODE LEFT OUTER JOIN
      dbo.tGrouper_CMG_INTERVENTION_OOH_CNT with (nolock) on 
          dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_INTERVENTION_OOH_CNT.METHODOLOGY_YEAR AND 
          dbo.AB_CMG.InterventionOOHCount = dbo.tGrouper_CMG_INTERVENTION_OOH_CNT.INTERV_OOH_CNT_CODE LEFT OUTER JOIN
      dbo.tGrouper_CMG_INTERVENTION_EVENT_CNT with (nolock) on 
      dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_INTERVENTION_EVENT_CNT.METHODOLOGY_YEAR AND 
      dbo.AB_CMG.InterventionEventCount = dbo.tGrouper_CMG_INTERVENTION_EVENT_CNT.INTERV_EVENT_CNT_CODE LEFT OUTER JOIN
      
      dbo.tGrouper_CMG_FLAGGED_INTERV_CNT with (nolock) on dbo.AB_CMG.FlaggedIntervFactorCount = dbo.tGrouper_CMG_FLAGGED_INTERV_CNT.FLAGGED_INTERV_CODE LEFT OUTER JOIN
      dbo.tGrouper_CMG_FLAGGED_INTERV_STATUS with (nolock) on dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_FLAGGED_INTERV_STATUS.METHODOLOGY_YEAR and dbo.AB_CMG.FlaggedIntervFactorCount = dbo.tGrouper_CMG_FLAGGED_INTERV_STATUS.flagged_interv_status_code LEFT OUTER JOIN
      
      dbo.tGrouper_CMG_COMORBIDITY_LEVEL with (nolock) on dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_COMORBIDITY_LEVEL.METHODOLOGY_YEAR AND 
      dbo.AB_CMG.ComorbidityLevel = dbo.tGrouper_CMG_COMORBIDITY_LEVEL.COMORBIDITY_LEVEL_CODE LEFT OUTER JOIN
      dbo.tGrouper_CMG_CMG_AGE_CATEGORY with (nolock) on dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_CMG_AGE_CATEGORY.METHODOLOGY_YEAR AND 
        dbo.AB_CMG.CMGAgeCategory = dbo.tGrouper_CMG_CMG_AGE_CATEGORY.CMG_AGE_CATEGORY_CODE LEFT OUTER JOIN
      dbo.tGrouper_CMG_IP_RIW_ATYPICAL with (nolock) on dbo.AB_CMG.InpatientRIWAtypicalCode = dbo.tGrouper_CMG_IP_RIW_ATYPICAL.IP_RIW_ATYPICAL_CODE 
            and dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_IP_RIW_ATYPICAL.METHODOLOGY_YEAR LEFT OUTER JOIN

      dbo.tGrouper_CMG_MCC_LOGIC with (nolock) on dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_MCC_LOGIC.methodology_year AND 
          dbo.AB_CMG.MCC = dbo.tGrouper_CMG_MCC_LOGIC.mcc_code LEFT OUTER JOIN
      dbo.ICD_ProcFile10 AS LU_Intervention with (nolock) on dbo.AB_CMG.IntervCode = LU_Intervention.Code LEFT OUTER JOIN
      dbo.CMG_LU_Complexity with (nolock) on dbo.AB_CMG.Complexity = dbo.CMG_LU_Complexity.DisplayCode LEFT OUTER JOIN
      dbo.ICD_DiagFile10 with (nolock) on dbo.AB_CMG.Diagnosis_Code = dbo.ICD_DiagFile10.Code LEFT OUTER JOIN
      dbo.LU_DiagnosisType with (nolock) on dbo.AB_CMG.Diagnosis_Type = dbo.LU_DiagnosisType.Code left JOIN
      dbo.tGrouper_CMG_CMG with (nolock) on dbo.AB_CMG.CMG_Year = dbo.tGrouper_CMG_CMG.METHODOLOGY_YEAR and dbo.AB_CMG_FI.MedicalCMG = dbo.tGrouper_CMG_CMG.cmg_code left join
      AB_HIG with (nolock) on dbo.AB_CMG.AbstractID = AB_HIG.ABstractID and dbo.AB_CMG.OccurrenceNumber = AB_HIG.OccurrenceNumber
            and dbo.AB_CMG.CMG_Year = AB_HIG.GrouperYear
            
WHERE     (dbo.AB_CMG.ICD_Type = ''T'') 


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMGAverages_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[I10_CMGAverages_VR]
AS
SELECT     TOP 100 PERCENT dbo.AB_CMG.CMG AS CMGs, dbo.AB_CMG.CMG_Year AS CMGYears, AVG(dbo.AB_CMG.CMG_ELOS) AS ELOSAvg, 
                      COUNT(dbo.AB_CMG.AbstractID) AS HospitalCases, AVG(dbo.AB_CMG.CMG_RIW) AS RIWAvg, AVG(CAST(dbo.AB_CMG.CMG_Trim AS int)) AS TrimAvg, 
                      dbo.AB_CMG.Complexity, dbo.AB_Abstract.AgeGroup, cast(avg(cast(LOSDays as decimal(8,2))) as decimal(8,2)) as LOSDaysAvg
FROM         dbo.AB_CMG with (nolock) LEFT OUTER JOIN
                      dbo.AB_Abstract with (nolock) ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID
WHERE     (dbo.AB_CMG.OccurrenceNumber = ''1'') AND (dbo.AB_CMG.ICD_Type = ''T'') and CMG_YEAR = (CASE When datepart(mm, dischargedate) < 4 THEN datepart(yyyy, dischargedate) - 1 
When datepart(mm, dischargedate) > 3 THEN datepart(yyyy, dischargedate) END)
GROUP BY dbo.AB_CMG.CMG_Year, dbo.AB_CMG.CMG, dbo.AB_CMG.Complexity, dbo.AB_Abstract.AgeGroup









' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CMGOntPerc2002_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'




CREATE  VIEW [dbo].[I10_CMGOntPerc2002_VR]
AS
SELECT  AB_CMG.CMG, AB_CMG.CMG_Year, 
        dbo.CMG_ETC_2002O.TenthPercent, dbo.CMG_ETC_2002O.TwentyFifthPercent, 
        dbo.CMG_ETC_2002O.FiftiethPercent, dbo.AB_CMG.AbstractID AS zzAbstractLink
FROM         dbo.AB_CMG LEFT OUTER JOIN
    dbo.AB_Abstract with (nolock) ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.CMG_ETC_2002O with (nolock) ON dbo.AB_CMG.Complexity = dbo.CMG_ETC_2002O.cicpxlvl AND dbo.AB_CMG.CMG = dbo.CMG_ETC_2002O.cmgcode
WHERE     (dbo.AB_CMG.CMG_Year IN (2002, 2003, 2004)) AND 
(((dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber BETWEEN 18 AND 68) 
    AND (dbo.CMG_ETC_2002O.ciagegroup = 2))
or ((((dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber BETWEEN 0 AND 17)) 
    or (dbo.AB_Abstract.AgeCode <> 3)) AND (dbo.CMG_ETC_2002O.ciagegroup = 1))
or ((dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber > 68) 
    AND (dbo.CMG_ETC_2002O.ciagegroup = 3))
)

--Old Stuff
-- SELECT  AB_CMG.CMG, AB_CMG.CMG_Year, 
--         dbo.CMG_ETC_2002O.TenthPercent, dbo.CMG_ETC_2002O.TwentyFifthPercent, 
--         dbo.CMG_ETC_2002O.FiftiethPercent, dbo.AB_CMG.AbstractID AS zzAbstractLink
-- FROM         dbo.AB_CMG LEFT OUTER JOIN
--     dbo.AB_Abstract ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
--     dbo.CMG_ETC_2002O ON dbo.AB_CMG.Complexity = dbo.CMG_ETC_2002O.cicpxlvl AND dbo.AB_CMG.CMG = dbo.CMG_ETC_2002O.cmgcode
-- WHERE     (dbo.AB_CMG.CMG_Year IN (2002, 2003, 2004)) AND (dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber BETWEEN 18 AND 68) AND 
--                       (dbo.CMG_ETC_2002O.ciagegroup = 2)
-- union all
-- SELECT  AB_CMG.CMG, AB_CMG.CMG_Year, 
--         dbo.CMG_ETC_2002O.TenthPercent, dbo.CMG_ETC_2002O.TwentyFifthPercent, 
--         dbo.CMG_ETC_2002O.FiftiethPercent, dbo.AB_CMG.AbstractID AS zzAbstractLink
-- FROM         dbo.AB_CMG LEFT OUTER JOIN
--     dbo.AB_Abstract ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
--     dbo.CMG_ETC_2002O ON dbo.AB_CMG.Complexity = dbo.CMG_ETC_2002O.cicpxlvl AND dbo.AB_CMG.CMG = dbo.CMG_ETC_2002O.cmgcode
-- WHERE     (dbo.AB_CMG.CMG_Year IN (2002, 2003, 2004)) AND (dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber BETWEEN 0 AND 17) AND 
--                       (dbo.CMG_ETC_2002O.ciagegroup = 1) OR
--                       (dbo.AB_CMG.CMG_Year in (2002, 2003, 2004)) AND (dbo.AB_Abstract.AgeCode <> 3) AND (dbo.CMG_ETC_2002O.ciagegroup = 1)
-- union all
-- SELECT  AB_CMG.CMG, AB_CMG.CMG_Year, 
--         dbo.CMG_ETC_2002O.TenthPercent, dbo.CMG_ETC_2002O.TwentyFifthPercent, 
--         dbo.CMG_ETC_2002O.FiftiethPercent, dbo.AB_CMG.AbstractID AS zzAbstractLink
-- FROM         dbo.AB_CMG LEFT OUTER JOIN
--     dbo.AB_Abstract ON dbo.AB_CMG.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
--     dbo.CMG_ETC_2002O ON dbo.AB_CMG.Complexity = dbo.CMG_ETC_2002O.cicpxlvl AND dbo.AB_CMG.CMG = dbo.CMG_ETC_2002O.cmgcode
-- WHERE     (dbo.AB_CMG.CMG_Year IN (2002, 2003, 2004)) AND (dbo.AB_Abstract.AgeCode = 3) AND (dbo.AB_Abstract.AgeNumber > 68) AND 
--                       (dbo.CMG_ETC_2002O.ciagegroup = 3)








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_CRS_General_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE   VIEW [dbo].[I10_CRS_General_VR]
AS
SELECT     
--Demographic
    dbo.CRS_Demographic.AbstractID AS zzAbstractLink, dbo.CRS_Demographic.LinkID AS zzLinkBackgroudID, LU_AA8.DisplayCode AS AA8, 
    LU_AA8.UserDescription AS AA8_Desc, dbo.CRS_Demographic.AA1, dbo.CRS_Demographic.ChartNumber, dbo.CRS_Demographic.RegisterNumber, 
    dbo.CRS_Demographic.AdmitDate, dbo.CRS_Demographic.Z7, dbo.CRS_Demographic.A3, dbo.CRS_Demographic.DischargeDate, 
    dbo.CRS_Demographic.AB1b, dbo.CRS_Demographic.MaidenName, dbo.CRS_Demographic.LastName, dbo.CRS_Demographic.MiddleName, 
    dbo.CRS_Demographic.FirstName, dbo.LU_NurseArea.DisplayCode AS AdmittingNurseArea, 
    dbo.LU_NurseArea.UserDescription AS AdmittingNurseArea_Desc, dbo.CRS_Demographic.RoomNumber, LU_Gender.DisplayCode AS Gender, 
    LU_Gender.UserDescription AS Gender_Desc, dbo.CRS_Demographic.BirthDate, dbo.CRS_Demographic.AA4a, 
    LU_MaritalStatus.DisplayCode AS MaritalStatus, LU_MaritalStatus.UserDescription AS MaritalStatus_Desc, dbo.CRS_Demographic.HealthCareNumber, 
    dbo.LU_HCNProvince.DisplayCode AS HCNProvince, dbo.LU_HCNProvince.UserDescription AS HCNProvince_Desc, 
    dbo.H_InstitutionProfile.DisplayCode AS InstitutionNumber, dbo.H_InstitutionProfile.UserDescription AS InstitutionNumber_Desc, 
    LU_AB2a.DisplayCode AS AB2a, LU_AB2a.UserDescription AS AB2a_Desc, LU_AB2c.DisplayCode AS AB2c, LU_AB2c.UserDescription AS AB2c_Desc, 
    LU_Inst_From.DisplayCode AS InstitutionFrom, LU_Inst_From.UserDescription AS InstitutionFrom_Desc, LU_R3a.DisplayCode AS R3a, 
    LU_R3a.UserDescription AS R3a_Desc, LU_Inst_To.DisplayCode AS InstitutionTo, LU_Inst_To.UserDescription AS InstitutionTo_Desc, 
    LU_Z1.DisplayCode AS Z1, LU_Z1.UserDescription AS Z1_Desc, dbo.CRS_Demographic.IsCurrent, LU_IsSubmited.DisplayCode AS IsSubmited, 
    LU_IsSubmited.UserDescription AS IsSubmited_Desc, LU_IsValidated.DisplayCode AS IsValidated, 
    LU_IsValidated.UserDescription AS IsValidated_Desc, LU_IsCompleted.DisplayCode AS IsCompleted, 
    LU_IsCompleted.UserDescription AS IsCompleted_Desc, LU_IsDeleted.DisplayCode AS IsDeleted, LU_IsDeleted.UserDescription AS IsDeleted_Desc, 
    dbo.LU_Site.DisplayCode AS SiteNumber, dbo.LU_Site.UserDescription AS SiteNumber_Desc, LU_Coder.DisplayCode AS CoderNumber, 
    LU_Coder.UserDescription AS CoderNumber_Desc, dbo.CRS_Demographic.HCNVersion, dbo.CRS_Demographic.ZA6b, dbo.CRS_Demographic.ZAB1, 
    dbo.CRS_Demographic.ZR4, dbo.CRS_Demographic.InterfaceDate, dbo.CRS_Demographic.InterfaceTime, 
    U_InterfaceCoder.DisplayCode AS InterfaceCoder, U_InterfaceCoder.UserDescription AS InterfaceCoder_Desc, dbo.CRS_Demographic.InputDate, 
    dbo.CRS_Demographic.InputTime, U_DataEntryCoder.DisplayCode AS DataEntryCoder, U_DataEntryCoder.UserDescription AS DataEntryCoder_Desc, 
    dbo.CRS_Demographic.FinishDate, dbo.CRS_Demographic.FinishTime, LU_Secret.DisplayCode AS Secret, LU_Secret.UserDescription AS Secret_Desc,
     dbo.CRS_Demographic.TSIDate, dbo.CRS_Demographic.TSITime, U_TSICoder.DisplayCode AS TSICoder, 
    U_TSICoder.UserDescription AS TSICoder_Desc, LU_BirthDateEstimated.DisplayCode AS BirthDateEstimated, 
    LU_BirthDateEstimated.UserDescription AS BirthDateEstimated_Desc,
--Full 1
    (case CRS_AssessFull1.A7a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7a, 
    (case CRS_AssessFull1.A7a when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7a_Desc, 
    (case CRS_AssessFull1.A7b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7b, 
    (case CRS_AssessFull1.A7b when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7b_Desc, 
    (case CRS_AssessFull1.A7c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7c, 
    (case CRS_AssessFull1.A7c when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7c_Desc, 
    (case CRS_AssessFull1.A7d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7d, 
    (case CRS_AssessFull1.A7d when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7d_Desc, 
    (case CRS_AssessFull1.A7e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7e, 
    (case CRS_AssessFull1.A7e when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7e_Desc, 
    (case CRS_AssessFull1.A7f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7f, 
    (case CRS_AssessFull1.A7f when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7f_Desc, 
    (case CRS_AssessFull1.A7g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7g, 
    (case CRS_AssessFull1.A7g when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7g_Desc, 
    (case CRS_AssessFull1.A7h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7h, 
    (case CRS_AssessFull1.A7h when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7h_Desc, 
    (case CRS_AssessFull1.A7I when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7I, 
    (case CRS_AssessFull1.A7I when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7I_Desc, 
    (case CRS_AssessFull1.A7j when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7j, 
    (case CRS_AssessFull1.A7j when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7j_Desc, 
    (case CRS_AssessFull1.A7k when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as A7k, 
    (case CRS_AssessFull1.A7k when 1 then Y.UserDescription when 2 then N.UserDescription end) as A7k_Desc, 

    LU_C1.DisplayCode AS C1, LU_C1.UserDescription AS C1_Desc, 
    (case when CRS_AssessFull1.C2All > 0 then Y1.DisplayCode end) as C2All, 
    (case when CRS_AssessFull1.C2All > 0 then Y1.UserDescription end) as C2All_Desc, 
    LU_C2a.DisplayCode AS C2a, LU_C2a.UserDescription AS C2a_Desc, 
    LU_C2b.DisplayCode AS C2b, LU_C2b.UserDescription AS C2b_Desc, 
    LU_C2c.DisplayCode AS C2c, LU_C2c.UserDescription AS C2c_Desc, 
    (case when CRS_AssessFull1.C3All > 0 then Y1.DisplayCode end) as C3All, 
    (case when CRS_AssessFull1.C3All > 0 then Y1.UserDescription end) as C3All_Desc, 
    LU_C3a.DisplayCode AS C3a, LU_C3a.UserDescription AS C3a_Desc, 
    LU_C3b.DisplayCode AS C3b, LU_C3b.UserDescription AS C3b_Desc, LU_C3c.DisplayCode AS C3c, LU_C3c.UserDescription AS C3c_Desc, 
    LU_C3d.DisplayCode AS C3d, LU_C3d.UserDescription AS C3d_Desc, LU_C3e.DisplayCode AS C3e, LU_C3e.UserDescription AS C3e_Desc, 
    LU_C3f.DisplayCode AS C3f, LU_C3f.UserDescription AS C3f_Desc, LU_C5.DisplayCode AS C5, LU_C5.UserDescription AS C5_Desc, 
    LU_D1.DisplayCode AS D1, LU_D1.UserDescription AS D1_Desc, LU_D2a.DisplayCode AS D2a, LU_D2a.UserDescription AS D2a_Desc, 
    LU_D2b.DisplayCode AS D2b, LU_D2b.UserDescription AS D2b_Desc, LU_D3.DisplayCode AS D3, LU_D3.UserDescription AS D3_Desc, 
    (case when CRS_AssessFull1.F2All > 0 then Y1.DisplayCode end) as F2All, 
    (case when CRS_AssessFull1.F2All > 0 then Y1.UserDescription end) as F2All_Desc, 
    LU_F2a.DisplayCode AS F2a, LU_F2a.UserDescription AS F2a_Desc, 
    LU_F2b.DisplayCode AS F2b, LU_F2b.UserDescription AS F2b_Desc, LU_F2c.DisplayCode AS F2c, LU_F2c.UserDescription AS F2c_Desc, 
    LU_F2d.DisplayCode AS F2d, LU_F2d.UserDescription AS F2d_Desc, LU_F2e.DisplayCode AS F2e, LU_F2e.UserDescription AS F2e_Desc, 
    LU_F2f.DisplayCode AS F2f, LU_F2f.UserDescription AS F2f_Desc, LU_F2g.DisplayCode AS F2g, LU_F2g.UserDescription AS F2g_Desc, 
    LU_F3a.DisplayCode AS F3a, LU_F3a.UserDescription AS F3a_Desc, LU_F3b.DisplayCode AS F3b, LU_F3b.UserDescription AS F3b_Desc, 
    LU_F3c.DisplayCode AS F3c, LU_F3c.UserDescription AS F3c_Desc, 

    (case when CRS_AssessFull1.G5All > 0 then Y1.DisplayCode end) as G5All, 
    (case when CRS_AssessFull1.G5All > 0 then Y1.UserDescription end) as G5All_Desc, 
    (case CRS_AssessFull1.G5a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G5a, 
    (case CRS_AssessFull1.G5a when 1 then Y.UserDescription when 2 then N.UserDescription end) as G5a_Desc, 
    (case CRS_AssessFull1.G5b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G5b, 
    (case CRS_AssessFull1.G5b when 1 then Y.UserDescription when 2 then N.UserDescription end) as G5b_Desc, 
    (case CRS_AssessFull1.G5c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G5c, 
    (case CRS_AssessFull1.G5c when 1 then Y.UserDescription when 2 then N.UserDescription end) as G5c_Desc, 
    (case CRS_AssessFull1.G5d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G5d, 
    (case CRS_AssessFull1.G5d when 1 then Y.UserDescription when 2 then N.UserDescription end) as G5d_Desc, 

    (case when CRS_AssessFull1.G8All > 0 then Y1.DisplayCode end) as G8All, 
    (case when CRS_AssessFull1.G8All > 0 then Y1.UserDescription end) as G8All_Desc, 
    (case CRS_AssessFull1.G8a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G8a, 
    (case CRS_AssessFull1.G8a when 1 then Y.UserDescription when 2 then N.UserDescription end) as G8a_Desc, 
    (case CRS_AssessFull1.G8b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G8b, 
    (case CRS_AssessFull1.G8b when 1 then Y.UserDescription when 2 then N.UserDescription end) as G8b_Desc, 
    (case CRS_AssessFull1.G8c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G8c, 
    (case CRS_AssessFull1.G8c when 1 then Y.UserDescription when 2 then N.UserDescription end) as G8c_Desc, 
    (case CRS_AssessFull1.G8d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as G8d, 
    (case CRS_AssessFull1.G8d when 1 then Y.UserDescription when 2 then N.UserDescription end) as G8d_Desc, 

    LU_J3a.DisplayCode AS J3a, LU_J3a.UserDescription AS J3a_Desc, 
    LU_J3b.DisplayCode AS J3b, LU_J3b.UserDescription AS J3b_Desc, LU_J3c.DisplayCode AS J3c, LU_J3c.UserDescription AS J3c_Desc, 
    LU_J3d.DisplayCode AS J3d, LU_J3d.UserDescription AS J3d_Desc, LU_J3e.DisplayCode AS J3e, LU_J3e.UserDescription AS J3e_Desc, 
    LU_J3f.DisplayCode AS J3f, LU_J3f.UserDescription AS J3f_Desc, LU_J3g.DisplayCode AS J3g, LU_J3g.UserDescription AS J3g_Desc, 
    LU_J3h.DisplayCode AS J3h, LU_J3h.UserDescription AS J3h_Desc, LU_J3I.DisplayCode AS J3I, LU_J3I.UserDescription AS J3I_Desc, 
    LU_J3j.DisplayCode AS J3j, LU_J3j.UserDescription AS J3j_Desc, 
--Full 2
    (case when CRS_AssessFull2.L1All > 0 then Y1.DisplayCode end) as L1All, 
    (case when CRS_AssessFull2.L1All > 0 then Y1.UserDescription end) as L1All_Desc, 
    (case CRS_AssessFull2.L1a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as L1a, 
    (case CRS_AssessFull2.L1a when 1 then Y.UserDescription when 2 then N.UserDescription end) as L1a_Desc, 
    (case CRS_AssessFull2.L1b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as L1b, 
    (case CRS_AssessFull2.L1b when 1 then Y.UserDescription when 2 then N.UserDescription end) as L1b_Desc, 
    (case CRS_AssessFull2.L1c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as L1c, 
    (case CRS_AssessFull2.L1c when 1 then Y.UserDescription when 2 then N.UserDescription end) as L1c_Desc, 
    (case CRS_AssessFull2.L1d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as L1d, 
    (case CRS_AssessFull2.L1d when 1 then Y.UserDescription when 2 then N.UserDescription end) as L1d_Desc, 
    (case CRS_AssessFull2.L1e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as L1e, 
    (case CRS_AssessFull2.L1e when 1 then Y.UserDescription when 2 then N.UserDescription end) as L1e_Desc, 
    (case CRS_AssessFull2.L1f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as L1f, 
    (case CRS_AssessFull2.L1f when 1 then Y.UserDescription when 2 then N.UserDescription end) as L1f_Desc, 
    (case CRS_AssessFull2.M3 when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M3, 
    (case CRS_AssessFull2.M3 when 1 then Y.UserDescription when 2 then N.UserDescription end) as M3_Desc, 

    (case when CRS_AssessFull2.N3All > 0 then Y1.DisplayCode end) as N3All, 
    (case when CRS_AssessFull2.N3All > 0 then Y1.UserDescription end) as N3All_Desc, 
    LU_N3a.DisplayCode AS N3a, LU_N3a.UserDescription AS N3a_Desc, 
    LU_N3b.DisplayCode AS N3b, LU_N3b.UserDescription AS N3b_Desc, LU_N3c.DisplayCode AS N3c, LU_N3c.UserDescription AS N3c_Desc, 
    LU_N3d.DisplayCode AS N3d, LU_N3d.UserDescription AS N3d_Desc, 
    (case when CRS_AssessFull2.N4All > 0 then Y1.DisplayCode end) as N4All, 
    (case when CRS_AssessFull2.N4All > 0 then Y1.UserDescription end) as N4All_Desc, 
    LU_N4a.DisplayCode AS N4a, LU_N4a.UserDescription AS N4a_Desc, LU_N4b.DisplayCode AS N4b, LU_N4b.UserDescription AS N4b_Desc, 
    LU_N4c.DisplayCode AS N4c, LU_N4c.UserDescription AS N4c_Desc, LU_N4d.DisplayCode AS N4d, LU_N4d.UserDescription AS N4d_Desc, 
    LU_N4e.DisplayCode AS N4e, LU_N4e.UserDescription AS N4e_Desc, LU_N4f.DisplayCode AS N4f, LU_N4f.UserDescription AS N4f_Desc, 
    LU_N4g.DisplayCode AS N4g, LU_N4g.UserDescription AS N4g_Desc, LU_N4h.DisplayCode AS N4h, LU_N4h.UserDescription AS N4h_Desc, 
    LU_N4I.DisplayCode AS N4I, LU_N4I.UserDescription AS N4I_Desc, LU_N4j.DisplayCode AS N4j, LU_N4j.UserDescription AS N4j_Desc, 
    LU_N4k.DisplayCode AS N4k, LU_N4k.UserDescription AS N4k_Desc, LU_N4l.DisplayCode AS N4l, LU_N4l.UserDescription AS N4l_Desc, 
    LU_N5a.DisplayCode AS N5a, LU_N5a.UserDescription AS N5a_Desc, LU_N5b.DisplayCode AS N5b, LU_N5b.UserDescription AS N5b_Desc, 
    LU_O2.DisplayCode AS O2, LU_O2.UserDescription AS O2_Desc, 

    (case when CRS_AssessFull2.P2All > 0 then Y1.DisplayCode end) as P2All, 
    (case when CRS_AssessFull2.P2All > 0 then Y1.UserDescription end) as P2All_Desc, 
    (case CRS_AssessFull2.P2a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P2a, 
    (case CRS_AssessFull2.P2a when 1 then Y.UserDescription when 2 then N.UserDescription end) as P2a_Desc, 
    (case CRS_AssessFull2.P2b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P2b, 
    (case CRS_AssessFull2.P2b when 1 then Y.UserDescription when 2 then N.UserDescription end) as P2b_Desc, 
    (case CRS_AssessFull2.P2c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P2c, 
    (case CRS_AssessFull2.P2c when 1 then Y.UserDescription when 2 then N.UserDescription end) as P2c_Desc, 
    (case CRS_AssessFull2.P2d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P2d, 
    (case CRS_AssessFull2.P2d when 1 then Y.UserDescription when 2 then N.UserDescription end) as P2d_Desc, 
    (case CRS_AssessFull2.P2e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P2e, 
    (case CRS_AssessFull2.P2e when 1 then Y.UserDescription when 2 then N.UserDescription end) as P2e_Desc, 

    dbo.CRS_AssessFull2.P5, dbo.CRS_AssessFull2.P6, 
    (case CRS_AssessFull2.P9 when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P9, 
    (case CRS_AssessFull2.P9 when 1 then Y.UserDescription when 2 then N.UserDescription end) as P9_Desc, 
    (case CRS_AssessFull2.Q1a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as Q1a, 
    (case CRS_AssessFull2.Q1a when 1 then Y.UserDescription when 2 then N.UserDescription end) as Q1a_Desc, 
    (case CRS_AssessFull2.Q1b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as Q1b, 
    (case CRS_AssessFull2.Q1b when 1 then Y.UserDescription when 2 then N.UserDescription end) as Q1b_Desc, 
    LU_Q1c.DisplayCode AS Q1c, LU_Q1c.UserDescription AS Q1c_Desc, 
    (case CRS_AssessFull2.R1a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as R1a, 
    (case CRS_AssessFull2.R1a when 1 then Y.UserDescription when 2 then N.UserDescription end) as R1a_Desc, 
    LU_R1b.DisplayCode AS R1b, LU_R1b.UserDescription AS R1b_Desc, LU_R1c.DisplayCode AS R1c, 
    LU_R1c.UserDescription AS R1c_Desc, 

--Share 1

    (case when CRS_AssessShare1.A9All > 0 then Y1.DisplayCode end) as A9All, 
    (case when CRS_AssessShare1.A9All > 0 then Y1.UserDescription end) as A9All_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9a_Q.DisplayCode else (case CRS_AssessShare1.A9a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A9a, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9a_Q.UserDescription else (case CRS_AssessShare1.A9a when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A9a_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9b_Q.DisplayCode else (case CRS_AssessShare1.A9b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A9b, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9b_Q.UserDescription else (case CRS_AssessShare1.A9b when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A9b_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9c_Q.DisplayCode else (case CRS_AssessShare1.A9c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A9c, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9c_Q.UserDescription else (case CRS_AssessShare1.A9c when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A9c_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9d_Q.DisplayCode else (case CRS_AssessShare1.A9d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A9d, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9d_Q.UserDescription else (case CRS_AssessShare1.A9d when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A9d_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9e_Q.DisplayCode else (case CRS_AssessShare1.A9e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A9e, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9e_Q.UserDescription else (case CRS_AssessShare1.A9e when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A9e_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9f_Q.DisplayCode else (case CRS_AssessShare1.A9f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A9f, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A9f_Q.UserDescription else (case CRS_AssessShare1.A9f when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A9f_Desc, 

    (case when CRS_AssessShare1.A10All > 0 then Y1.DisplayCode end) as A10All, 
    (case when CRS_AssessShare1.A10All > 0 then Y1.UserDescription end) as A10All_Desc, 

    (case when LU_AA8.CIHIValue = ''05'' then LU_A10a_Q.DisplayCode else (case CRS_AssessShare1.A10a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10a, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10a_Q.UserDescription else (case CRS_AssessShare1.A10a when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10a_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10b_Q.DisplayCode else (case CRS_AssessShare1.A10b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10b, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10b_Q.UserDescription else (case CRS_AssessShare1.A10b when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10b_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10c_Q.DisplayCode else (case CRS_AssessShare1.A10c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10c, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10c_Q.UserDescription else (case CRS_AssessShare1.A10c when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10c_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10d_Q.DisplayCode else (case CRS_AssessShare1.A10d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10d, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10d_Q.UserDescription else (case CRS_AssessShare1.A10d when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10d_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10e_Q.DisplayCode else (case CRS_AssessShare1.A10e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10e, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10e_Q.UserDescription else (case CRS_AssessShare1.A10e when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10e_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10f_Q.DisplayCode else (case CRS_AssessShare1.A10f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10f, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10f_Q.UserDescription else (case CRS_AssessShare1.A10f when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10f_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10g_Q.DisplayCode else (case CRS_AssessShare1.A10g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10g, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10g_Q.UserDescription else (case CRS_AssessShare1.A10g when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10g_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10h_Q.DisplayCode else (case CRS_AssessShare1.A10h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS A10h, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_A10h_Q.UserDescription else (case CRS_AssessShare1.A10h when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS A10h_Desc, 

    (case CRS_AssessShare1.B1 when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS B1, 
    (case CRS_AssessShare1.B1 when 1 then Y.UserDescription when 2 then N.UserDescription end) AS B1_Desc, 

    LU_B2a.DisplayCode AS B2a, LU_B2a.UserDescription AS B2a_Desc, 
    LU_B2b.DisplayCode AS B2b, LU_B2b.UserDescription AS B2b_Desc, 
    (case when CRS_AssessShare1.B3All > 0 then Y1.DisplayCode end) as B3All, 
    (case when CRS_AssessShare1.B3All > 0 then Y1.UserDescription end) as B3All_Desc, 
    LU_B3a.DisplayCode AS B3a, LU_B3a.UserDescription AS B3a_Desc, LU_B3b.DisplayCode AS B3b, LU_B3b.UserDescription AS B3b_Desc, 
    LU_B3c.DisplayCode AS B3c, LU_B3c.UserDescription AS B3c_Desc, LU_B3d.DisplayCode AS B3d, LU_B3d.UserDescription AS B3d_Desc, 
    LU_B4.DisplayCode AS B4, LU_B4.UserDescription AS B4_Desc, LU_B5a.DisplayCode AS B5a, LU_B5a.UserDescription AS B5a_Desc, 
    LU_B5b.DisplayCode AS B5b, LU_B5b.UserDescription AS B5b_Desc, LU_B5c.DisplayCode AS B5c, LU_B5c.UserDescription AS B5c_Desc, 
    LU_B5d.DisplayCode AS B5d, LU_B5d.UserDescription AS B5d_Desc, LU_B5e.DisplayCode AS B5e, LU_B5e.UserDescription AS B5e_Desc, 
    LU_B5f.DisplayCode AS B5f, LU_B5f.UserDescription AS B5f_Desc, LU_B6.DisplayCode AS B6, LU_B6.UserDescription AS B6_Desc, 
    LU_C4.DisplayCode AS C4, LU_C4.UserDescription AS C4_Desc, LU_C6.DisplayCode AS C6, LU_C6.UserDescription AS C6_Desc, 
    LU_C7.DisplayCode AS C7, LU_C7.UserDescription AS C7_Desc, LU_E1a.DisplayCode AS E1a, LU_E1a.UserDescription AS E1a_Desc, 
    LU_E1b.DisplayCode AS E1b, LU_E1b.UserDescription AS E1b_Desc, LU_E1c.DisplayCode AS E1c, LU_E1c.UserDescription AS E1c_Desc, 
    LU_E1d.DisplayCode AS E1d, LU_E1d.UserDescription AS E1d_Desc, LU_E1e.DisplayCode AS E1e, LU_E1e.UserDescription AS E1e_Desc, 
    LU_E1f.DisplayCode AS E1f, LU_E1f.UserDescription AS E1f_Desc, LU_E1g.DisplayCode AS E1g, LU_E1g.UserDescription AS E1g_Desc, 
    LU_E1h.DisplayCode AS E1h, LU_E1h.UserDescription AS E1h_Desc, LU_E1I.DisplayCode AS E1I, LU_E1I.UserDescription AS E1I_Desc, 
    LU_E1j.DisplayCode AS E1j, LU_E1j.UserDescription AS E1j_Desc, LU_E1k.DisplayCode AS E1k, LU_E1k.UserDescription AS E1k_Desc, 
    LU_E1l.DisplayCode AS E1l, LU_E1l.UserDescription AS E1l_Desc, LU_E1m.DisplayCode AS E1m, LU_E1m.UserDescription AS E1m_Desc, 
    LU_E1n.DisplayCode AS E1n, LU_E1n.UserDescription AS E1n_Desc, LU_E1o.DisplayCode AS E1o, LU_E1o.UserDescription AS E1o_Desc, 
    LU_E1p.DisplayCode AS E1p, LU_E1p.UserDescription AS E1p_Desc, LU_E2.DisplayCode AS E2, LU_E2.UserDescription AS E2_Desc, 
    LU_E3.DisplayCode AS E3, LU_E3.UserDescription AS E3_Desc, LU_E4aA.DisplayCode AS E4aA, LU_E4aA.UserDescription AS E4aA_Desc, 
    LU_E4aB.DisplayCode AS E4aB, LU_E4aB.UserDescription AS E4aB_Desc, LU_E4bA.DisplayCode AS E4bA, LU_E4bA.UserDescription AS E4bA_Desc, 
    LU_E4bB.DisplayCode AS E4bB, LU_E4bB.UserDescription AS E4bB_Desc, LU_E4cA.DisplayCode AS E4cA, LU_E4cA.UserDescription AS E4cA_Desc, 
    LU_E4cB.DisplayCode AS E4cB, LU_E4cB.UserDescription AS E4cB_Desc, LU_E4dA.DisplayCode AS E4dA, LU_E4dA.UserDescription AS E4dA_Desc, 
    LU_E4dB.DisplayCode AS E4dB, LU_E4dB.UserDescription AS E4dB_Desc, LU_E4eA.DisplayCode AS E4eA, LU_E4eA.UserDescription AS E4eA_Desc, 
    LU_E4eB.DisplayCode AS E4eB, LU_E4eB.UserDescription AS E4eB_Desc, LU_E5.DisplayCode AS E5, LU_E5.UserDescription AS E5_Desc, 

--Share 2
    (case when CRS_AssessShare2.F1All > 0 then Y1.DisplayCode end) as F1All, 
    (case when CRS_AssessShare2.F1All > 0 then Y1.UserDescription end) as F1All_Desc, 
    LU_F1a.DisplayCode AS F1a, LU_F1a.UserDescription AS F1a_Desc, LU_F1b.DisplayCode AS F1b, LU_F1b.UserDescription AS F1b_Desc, 
    LU_F1c.DisplayCode AS F1c, LU_F1c.UserDescription AS F1c_Desc, LU_F1d.DisplayCode AS F1d, LU_F1d.UserDescription AS F1d_Desc, 
    LU_F1e.DisplayCode AS F1e, LU_F1e.UserDescription AS F1e_Desc, LU_F1f.DisplayCode AS F1f, LU_F1f.UserDescription AS F1f_Desc, 
    LU_G1aA.DisplayCode AS G1aA, LU_G1aA.UserDescription AS G1aA_Desc, LU_G1aB.DisplayCode AS G1aB, 
    LU_G1aB.UserDescription AS G1aB_Desc, LU_G1bA.DisplayCode AS G1bA, LU_G1bA.UserDescription AS G1bA_Desc, 
    LU_G1bB.DisplayCode AS G1bB, LU_G1bB.UserDescription AS G1bB_Desc, LU_G1cA.DisplayCode AS G1cA, LU_G1cA.UserDescription AS G1cA_Desc,
    LU_G1cB.DisplayCode AS G1cB, LU_G1cB.UserDescription AS G1cB_Desc, LU_G1dA.DisplayCode AS G1dA, 
    LU_G1dA.UserDescription AS G1dA_Desc, LU_G1dB.DisplayCode AS G1dB, LU_G1dB.UserDescription AS G1dB_Desc, 
    LU_G1eA.DisplayCode AS G1eA, LU_G1eA.UserDescription AS G1eA_Desc, LU_G1eB.DisplayCode AS G1eB, 
    LU_G1eB.UserDescription AS G1eB_Desc, LU_G1fA.DisplayCode AS G1fA, LU_G1fA.UserDescription AS G1fA_Desc, LU_G1fB.DisplayCode AS G1fB, 
    LU_G1fB.UserDescription AS G1fB_Desc, LU_G1gA.DisplayCode AS G1gA, LU_G1gA.UserDescription AS G1gA_Desc, LU_G1gB.DisplayCode AS G1gB, 
    LU_G1gB.UserDescription AS G1gB_Desc, LU_G1hA.DisplayCode AS G1hA, LU_G1hA.UserDescription AS G1hA_Desc, 
    LU_G1hB.DisplayCode AS G1hB, LU_G1hB.UserDescription AS G1hB_Desc, LU_G1IA.DisplayCode AS G1IA, LU_G1IA.UserDescription AS G1IA_Desc, 
    LU_G1IB.DisplayCode AS G1IB, LU_G1IB.UserDescription AS G1IB_Desc, LU_G1jA.DisplayCode AS G1jA, LU_G1jA.UserDescription AS G1jA_Desc, 
    LU_G1jB.DisplayCode AS G1jB, LU_G1jB.UserDescription AS G1jB_Desc, LU_G2A.DisplayCode AS G2A, LU_G2A.UserDescription AS G2A_Desc, 
    LU_G2B.DisplayCode AS G2B, LU_G2B.UserDescription AS G2B_Desc, LU_G3a.DisplayCode AS G3a, LU_G3a.UserDescription AS G3a_Desc, 
    LU_G3b.DisplayCode AS G3b, LU_G3b.UserDescription AS G3b_Desc, LU_G4aA.DisplayCode AS G4aA, LU_G4aA.UserDescription AS G4aA_Desc, 
    LU_G4aB.DisplayCode AS G4aB, LU_G4aB.UserDescription AS G4aB_Desc, LU_G4bA.DisplayCode AS G4bA, 
    LU_G4bA.UserDescription AS G4bA_Desc, LU_G4bB.DisplayCode AS G4bB, LU_G4bB.UserDescription AS G4bB_Desc, 
    LU_G4cA.DisplayCode AS G4cA, LU_G4cA.UserDescription AS G4cA_Desc, LU_G4cB.DisplayCode AS G4cB, LU_G4cB.UserDescription AS G4cB_Desc, 
    LU_G4dA.DisplayCode AS G4dA, LU_G4dA.UserDescription AS G4dA_Desc, LU_G4dB.DisplayCode AS G4dB, 
    LU_G4dB.UserDescription AS G4dB_Desc, LU_G4eA.DisplayCode AS G4eA, LU_G4eA.UserDescription AS G4eA_Desc, 
    LU_G4eB.DisplayCode AS G4eB, LU_G4eB.UserDescription AS G4eB_Desc, LU_G4fA.DisplayCode AS G4fA, LU_G4fA.UserDescription AS G4fA_Desc, 
    LU_G4fB.DisplayCode AS G4fB, LU_G4fB.UserDescription AS G4fB_Desc, 

    (case when CRS_AssessShare2.G6All > 0 then Y1.DisplayCode end) as G6All, 
    (case when CRS_AssessShare2.G6All > 0 then Y1.UserDescription end) as G6All_Desc, 

    (case CRS_AssessShare2.G6a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS G6a, 
    (case CRS_AssessShare2.G6a when 1 then Y.UserDescription when 2 then N.UserDescription end) AS G6a_Desc, 
    (case CRS_AssessShare2.G6b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS G6b, 
    (case CRS_AssessShare2.G6b when 1 then Y.UserDescription when 2 then N.UserDescription end) AS G6b_Desc, 
    (case CRS_AssessShare2.G6c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS G6c, 
    (case CRS_AssessShare2.G6c when 1 then Y.UserDescription when 2 then N.UserDescription end) AS G6c_Desc, 
    (case CRS_AssessShare2.G6d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS G6d,
    (case CRS_AssessShare2.G6d when 1 then Y.UserDescription when 2 then N.UserDescription end) AS G6d_Desc, 
    (case CRS_AssessShare2.G6e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS G6e, 
    (case CRS_AssessShare2.G6e when 1 then Y.UserDescription when 2 then N.UserDescription end) AS G6e_Desc, 
    (case CRS_AssessShare2.G7 when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS G7, 
    (case CRS_AssessShare2.G7 when 1 then Y.UserDescription when 2 then N.UserDescription end) AS G7_Desc, 

    LU_G9.DisplayCode AS G9, LU_G9.UserDescription AS G9_Desc, 

    LU_H1a.DisplayCode AS H1a, LU_H1a.UserDescription AS H1a_Desc, 
    LU_H1b.DisplayCode AS H1b, LU_H1b.UserDescription AS H1b_Desc, 
    (case when CRS_AssessShare2.H2All > 0 then Y1.DisplayCode end) as H2All, 
    (case when CRS_AssessShare2.H2All > 0 then Y1.UserDescription end) as H2All_Desc, 
    (case CRS_AssessShare2.H2a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H2a, 
    (case CRS_AssessShare2.H2a when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H2a_Desc, 
    (case CRS_AssessShare2.H2b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H2b, 
    (case CRS_AssessShare2.H2b when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H2b_Desc, 
    (case CRS_AssessShare2.H2c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H2c, 
    (case CRS_AssessShare2.H2c when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H2c_Desc, 
    (case CRS_AssessShare2.H2d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H2d, 
    (case CRS_AssessShare2.H2d when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H2d_Desc, 

    (case when CRS_AssessShare2.H3All > 0 then Y1.DisplayCode end) as H3All, 
    (case when CRS_AssessShare2.H3All > 0 then Y1.UserDescription end) as H3All_Desc, 
    (case CRS_AssessShare2.H3a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3a, 
    (case CRS_AssessShare2.H3a when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3a_Desc, 
    (case CRS_AssessShare2.H3b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3b, 
    (case CRS_AssessShare2.H3b when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3b_Desc, 
    (case CRS_AssessShare2.H3c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3c, 
    (case CRS_AssessShare2.H3c when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3c_Desc, 
    (case CRS_AssessShare2.H3d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3d, 
    (case CRS_AssessShare2.H3d when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3d_Desc, 
    (case CRS_AssessShare2.H3e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3e, 
    (case CRS_AssessShare2.H3e when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3e_Desc, 
    (case CRS_AssessShare2.H3f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3f, 
    (case CRS_AssessShare2.H3f when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3f_Desc, 
    (case CRS_AssessShare2.H3g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3g, 
    (case CRS_AssessShare2.H3g when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3g_Desc, 
    (case CRS_AssessShare2.H3h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3h, 
    (case CRS_AssessShare2.H3h when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3h_Desc, 
    (case CRS_AssessShare2.H3i when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS H3i, 
    (case CRS_AssessShare2.H3i when 1 then Y.UserDescription when 2 then N.UserDescription end) AS H3i_Desc, 
    LU_H4.DisplayCode AS H4, LU_H4.UserDescription AS H4_Desc, 
--Share 3
    (case when CRS_AssessShare3.I1All > 0 then Y1.DisplayCode end) as I1All, 
    (case when CRS_AssessShare3.I1All > 0 then Y1.UserDescription end) as I1All_Desc, 
    (case CRS_AssessShare3.I1a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1a, 
    (case CRS_AssessShare3.I1a when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1a_Desc, 
    (case CRS_AssessShare3.I1b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1b, 
    (case CRS_AssessShare3.I1b when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1b_Desc, 
    (case CRS_AssessShare3.I1c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1c, 
    (case CRS_AssessShare3.I1c when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1c_Desc, 
    (case CRS_AssessShare3.I1d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1d, 
    (case CRS_AssessShare3.I1d when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1d_Desc, 
    (case CRS_AssessShare3.I1e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1e, 
    (case CRS_AssessShare3.I1e when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1e_Desc, 
    (case CRS_AssessShare3.I1f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1f, 
    (case CRS_AssessShare3.I1f when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1f_Desc, 
    (case CRS_AssessShare3.I1g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1g, 
    (case CRS_AssessShare3.I1g when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1g_Desc, 
    (case CRS_AssessShare3.I1h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1h, 
    (case CRS_AssessShare3.I1h when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1h_Desc, 
    (case CRS_AssessShare3.I1I when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1I, 
    (case CRS_AssessShare3.I1I when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1I_Desc, 
    (case CRS_AssessShare3.I1j when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1j, 
    (case CRS_AssessShare3.I1j when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1j_Desc, 
    (case CRS_AssessShare3.I1k when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1k, 
    (case CRS_AssessShare3.I1k when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1k_Desc, 
    (case CRS_AssessShare3.I1l when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1l, 
    (case CRS_AssessShare3.I1l when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1l_Desc, 
    (case CRS_AssessShare3.I1m when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1m, 
    (case CRS_AssessShare3.I1m when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1m_Desc, 
    (case CRS_AssessShare3.I1n when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1n, 
    (case CRS_AssessShare3.I1n when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1n_Desc, 
    (case CRS_AssessShare3.I1o when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1o, 
    (case CRS_AssessShare3.I1o when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1o_Desc, 
    (case CRS_AssessShare3.I1p when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1p, 
    (case CRS_AssessShare3.I1p when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1p_Desc, 
    (case CRS_AssessShare3.I1q when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1q, 
    (case CRS_AssessShare3.I1q when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1q_Desc, 
    (case CRS_AssessShare3.I1r when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1r, 
    (case CRS_AssessShare3.I1r when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1r_Desc, 
    (case CRS_AssessShare3.I1s when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1s, 
    (case CRS_AssessShare3.I1s when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1s_Desc, 
    (case CRS_AssessShare3.I1t when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1t, 
    (case CRS_AssessShare3.I1t when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1t_Desc, 
    (case CRS_AssessShare3.I1u when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1u, 
    (case CRS_AssessShare3.I1u when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1u_Desc, 
    (case CRS_AssessShare3.I1v when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1v, 
    (case CRS_AssessShare3.I1v when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1v_Desc, 
    (case CRS_AssessShare3.I1w when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1w, 
    (case CRS_AssessShare3.I1w when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1w_Desc, 
    (case CRS_AssessShare3.I1x when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1x, 
    (case CRS_AssessShare3.I1x when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1x_Desc, 
    (case CRS_AssessShare3.I1y when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1y, 
    (case CRS_AssessShare3.I1y when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1y_Desc, 
    (case CRS_AssessShare3.I1z when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1z, 
    (case CRS_AssessShare3.I1z when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1z_Desc, 
    (case CRS_AssessShare3.I1aa when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1aa, 
    (case CRS_AssessShare3.I1aa when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1aa_Desc, 
    (case CRS_AssessShare3.I1bb when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1bb, 
    (case CRS_AssessShare3.I1bb when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1bb_Desc, 
    (case CRS_AssessShare3.I1cc when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1cc, 
    (case CRS_AssessShare3.I1cc when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1cc_Desc, 
    (case CRS_AssessShare3.I1dd when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1dd, 
    (case CRS_AssessShare3.I1dd when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1dd_Desc, 
    (case CRS_AssessShare3.I1ee when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1ee, 
    (case CRS_AssessShare3.I1ee when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1ee_Desc, 
    (case CRS_AssessShare3.I1ff when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1ff, 
    (case CRS_AssessShare3.I1ff when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1ff_Desc, 
    (case CRS_AssessShare3.I1gg when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1gg, 
    (case CRS_AssessShare3.I1gg when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1gg_Desc, 
    (case CRS_AssessShare3.I1hh when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1hh, 
    (case CRS_AssessShare3.I1hh when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1hh_Desc, 
    (case CRS_AssessShare3.I1ii when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1ii, 
    (case CRS_AssessShare3.I1ii when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1ii_Desc, 
    (case CRS_AssessShare3.I1jj when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1jj, 
    (case CRS_AssessShare3.I1jj when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1jj_Desc, 
    (case CRS_AssessShare3.I1kk when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1kk, 
    (case CRS_AssessShare3.I1kk when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1kk_Desc, 
    (case CRS_AssessShare3.I1ll when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1ll, 
    (case CRS_AssessShare3.I1ll when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1ll_Desc, 
    (case CRS_AssessShare3.I1mm when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1mm, 
    (case CRS_AssessShare3.I1mm when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1mm_Desc, 
    (case CRS_AssessShare3.I1nn when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1nn, 
    (case CRS_AssessShare3.I1nn when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1nn_Desc, 
    (case CRS_AssessShare3.I1oo when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1oo, 
    (case CRS_AssessShare3.I1oo when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1oo_Desc, 
    (case CRS_AssessShare3.I1pp when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1pp, 
    (case CRS_AssessShare3.I1pp when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1pp_Desc, 
    (case CRS_AssessShare3.I1qq when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1qq, 
    (case CRS_AssessShare3.I1qq when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1qq_Desc, 
    (case CRS_AssessShare3.I1rr when 1 then Y.DisplayCode when 2 then N.DisplayCode end) AS I1rr, 
    (case CRS_AssessShare3.I1rr when 1 then Y.UserDescription when 2 then N.UserDescription end) AS I1rr_Desc, 
    (case CRS_AssessShare3.I1ss when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I1ss, 
    (case CRS_AssessShare3.I1ss when 1 then Y.UserDescription when 2 then N.UserDescription end) as I1ss_Desc, 
    (case CRS_AssessShare3.I1tt when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I1tt, 
    (case CRS_AssessShare3.I1tt when 1 then Y.UserDescription when 2 then N.UserDescription end) as I1tt_Desc, 
    (case CRS_AssessShare3.I1uu when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I1uu, 
    (case CRS_AssessShare3.I1uu when 1 then Y.UserDescription when 2 then N.UserDescription end) as I1uu_Desc, 

    (case when CRS_AssessShare3.I2All > 0 then Y1.DisplayCode end) as I2All, 
    (case when CRS_AssessShare3.I2All > 0 then Y1.UserDescription end) as I2All_Desc, 
    (case CRS_AssessShare3.I2a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2a, 
    (case CRS_AssessShare3.I2a when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2a_Desc, 
    (case CRS_AssessShare3.I2b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2b, 
    (case CRS_AssessShare3.I2b when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2b_Desc, 
    (case CRS_AssessShare3.I2c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2c, 
    (case CRS_AssessShare3.I2c when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2c_Desc, 
    (case CRS_AssessShare3.I2d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2d, 
    (case CRS_AssessShare3.I2d when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2d_Desc, 
    (case CRS_AssessShare3.I2e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2e, 
    (case CRS_AssessShare3.I2e when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2e_Desc, 
    (case CRS_AssessShare3.I2f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2f, 
    (case CRS_AssessShare3.I2f when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2f_Desc, 
    (case CRS_AssessShare3.I2g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2g, 
    (case CRS_AssessShare3.I2g when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2g_Desc, 
    (case CRS_AssessShare3.I2h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2h, 
    (case CRS_AssessShare3.I2h when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2h_Desc, 
    (case CRS_AssessShare3.I2I when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2I, 
    (case CRS_AssessShare3.I2I when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2I_Desc, 
    (case CRS_AssessShare3.I2j when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2j, 
    (case CRS_AssessShare3.I2j when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2j_Desc, 
    (case CRS_AssessShare3.I2k when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2k, 
    (case CRS_AssessShare3.I2k when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2k_Desc, 
    (case CRS_AssessShare3.I2l when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2l, 
    (case CRS_AssessShare3.I2l when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2l_Desc, 
    (case CRS_AssessShare3.I2m when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as I2m, 
    (case CRS_AssessShare3.I2m when 1 then Y.UserDescription when 2 then N.UserDescription end) as I2m_Desc, 

    (case when CRS_AssessShare3.J1All > 0 then Y1.DisplayCode end) as J1All, 
    (case when CRS_AssessShare3.J1All > 0 then Y1.UserDescription end) as J1All_Desc, 
    (case CRS_AssessShare3.J1a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1a, 
    (case CRS_AssessShare3.J1a when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1a_Desc, 
    (case CRS_AssessShare3.J1b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1b, 
    (case CRS_AssessShare3.J1b when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1b_Desc, 
    (case CRS_AssessShare3.J1c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1c, 
    (case CRS_AssessShare3.J1c when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1c_Desc, 
    (case CRS_AssessShare3.J1d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1d, 
    (case CRS_AssessShare3.J1d when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1d_Desc, 
    (case CRS_AssessShare3.J1e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1e, 
    (case CRS_AssessShare3.J1e when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1e_Desc, 
    (case CRS_AssessShare3.J1f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1f, 
    (case CRS_AssessShare3.J1f when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1f_Desc, 
    (case CRS_AssessShare3.J1g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1g, 
    (case CRS_AssessShare3.J1g when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1g_Desc, 
    (case CRS_AssessShare3.J1h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1h, 
    (case CRS_AssessShare3.J1h when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1h_Desc, 
    (case CRS_AssessShare3.J1I when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1I, 
    (case CRS_AssessShare3.J1I when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1I_Desc, 
    (case CRS_AssessShare3.J1j when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1j, 
    (case CRS_AssessShare3.J1j when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1j_Desc, 
    (case CRS_AssessShare3.J1k when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1k, 
    (case CRS_AssessShare3.J1k when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1k_Desc, 
    (case CRS_AssessShare3.J1l when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1l, 
    (case CRS_AssessShare3.J1l when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1l_Desc, 
    (case CRS_AssessShare3.J1m when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1m, 
    (case CRS_AssessShare3.J1m when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1m_Desc, 
    (case CRS_AssessShare3.J1n when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1n, 
    (case CRS_AssessShare3.J1n when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1n_Desc, 
    (case CRS_AssessShare3.J1o when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J1o, 
    (case CRS_AssessShare3.J1o when 1 then Y.UserDescription when 2 then N.UserDescription end) as J1o_Desc, 
    LU_J2a.DisplayCode AS J2a, LU_J2a.UserDescription AS J2a_Desc, 
    LU_J2b.DisplayCode AS J2b, LU_J2b.UserDescription AS J2b_Desc, 

    (case when CRS_AssessShare3.J4All > 0 then Y1.DisplayCode end) as J4All, 
    (case when CRS_AssessShare3.J4All > 0 then Y1.UserDescription end) as J4All_Desc, 
    (case CRS_AssessShare3.J4a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J4a, 
    (case CRS_AssessShare3.J4a when 1 then Y.UserDescription when 2 then N.UserDescription end) as J4a_Desc, 
    (case CRS_AssessShare3.J4b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J4b, 
    (case CRS_AssessShare3.J4b when 1 then Y.UserDescription when 2 then N.UserDescription end) as J4b_Desc, 
    (case CRS_AssessShare3.J4c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J4c, 
    (case CRS_AssessShare3.J4c when 1 then Y.UserDescription when 2 then N.UserDescription end) as J4c_Desc, 
    (case CRS_AssessShare3.J4d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J4d, 
    (case CRS_AssessShare3.J4d when 1 then Y.UserDescription when 2 then N.UserDescription end) as J4d_Desc, 

    (case when CRS_AssessShare3.J5All > 0 then Y1.DisplayCode end) as J5All, 
    (case when CRS_AssessShare3.J5All > 0 then Y1.UserDescription end) as J5All_Desc, 
    (case CRS_AssessShare3.J5a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J5a, 
    (case CRS_AssessShare3.J5a when 1 then Y.UserDescription when 2 then N.UserDescription end) as J5a_Desc, 
    (case CRS_AssessShare3.J5b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J5b, 
    (case CRS_AssessShare3.J5b when 1 then Y.UserDescription when 2 then N.UserDescription end) as J5b_Desc, 
    (case CRS_AssessShare3.J5c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as J5c, 
    (case CRS_AssessShare3.J5c when 1 then Y.UserDescription when 2 then N.UserDescription end) as J5c_Desc, 
--Share 4
    (case when CRS_AssessShare4.K1All > 0 then Y1.DisplayCode end) as K1All, 
    (case when CRS_AssessShare4.K1All > 0 then Y1.UserDescription end) as K1All_Desc, 
    (case CRS_AssessShare4.K1a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K1a, 
    (case CRS_AssessShare4.K1a when 1 then Y.UserDescription when 2 then N.UserDescription end) as K1a_Desc, 
    (case CRS_AssessShare4.K1b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K1b, 
    (case CRS_AssessShare4.K1b when 1 then Y.UserDescription when 2 then N.UserDescription end) as K1b_Desc, 
    (case CRS_AssessShare4.K1c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K1c, 
    (case CRS_AssessShare4.K1c when 1 then Y.UserDescription when 2 then N.UserDescription end) as K1c_Desc, 

    dbo.CRS_AssessShare4.K2a, dbo.CRS_AssessShare4.K2b, 

    (case when LU_AA8.CIHIValue = ''05'' then LU_K3a_Q.DisplayCode else (case CRS_AssessShare4.K3a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS K3a, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_K3a_Q.UserDescription else (case CRS_AssessShare4.K3a when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS K3a_Desc, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_K3b_Q.DisplayCode else (case CRS_AssessShare4.K3b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) end) AS K3b, 
    (case when LU_AA8.CIHIValue = ''05'' then LU_K3b_Q.UserDescription else (case CRS_AssessShare4.K3b when 1 then Y.UserDescription when 2 then N.UserDescription end) end) AS K3b_Desc, 

    (case when CRS_AssessShare4.K4All > 0 then Y1.DisplayCode end) as K4All, 
    (case when CRS_AssessShare4.K4All > 0 then Y1.UserDescription end) as K4All_Desc, 
    (case CRS_AssessShare4.K4a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K4a, 
    (case CRS_AssessShare4.K4a when 1 then Y.UserDescription when 2 then N.UserDescription end) as K4a_Desc, 
    (case CRS_AssessShare4.K4b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K4b, 
    (case CRS_AssessShare4.K4b when 1 then Y.UserDescription when 2 then N.UserDescription end) as K4b_Desc, 
    (case CRS_AssessShare4.K4c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K4c, 
    (case CRS_AssessShare4.K4c when 1 then Y.UserDescription when 2 then N.UserDescription end) as K4c_Desc, 

    (case when CRS_AssessShare4.K5All > 0 then Y1.DisplayCode end) as K5All, 
    (case when CRS_AssessShare4.K5All > 0 then Y1.UserDescription end) as K5All_Desc, 
    (case CRS_AssessShare4.K5a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5a, 
    (case CRS_AssessShare4.K5a when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5a_Desc, 
    (case CRS_AssessShare4.K5b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5b, 
    (case CRS_AssessShare4.K5b when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5b_Desc, 
    (case CRS_AssessShare4.K5c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5c, 
    (case CRS_AssessShare4.K5c when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5c_Desc, 
    (case CRS_AssessShare4.K5d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5d, 
    (case CRS_AssessShare4.K5d when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5d_Desc, 
    (case CRS_AssessShare4.K5e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5e, 
    (case CRS_AssessShare4.K5e when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5e_Desc, 
    (case CRS_AssessShare4.K5f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5f, 
    (case CRS_AssessShare4.K5f when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5f_Desc, 
    (case CRS_AssessShare4.K5g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5g, 
    (case CRS_AssessShare4.K5g when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5g_Desc, 
    (case CRS_AssessShare4.K5h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as K5h, 
    (case CRS_AssessShare4.K5h when 1 then Y.UserDescription when 2 then N.UserDescription end) as K5h_Desc, 

    LU_K6a.DisplayCode AS K6a, LU_K6a.UserDescription AS K6a_Desc, 
    LU_K6b.DisplayCode AS K6b, LU_K6b.UserDescription AS K6b_Desc, 
    dbo.CRS_AssessShare4.M1a, dbo.CRS_AssessShare4.M1b, 
    dbo.CRS_AssessShare4.M1c, dbo.CRS_AssessShare4.M1d, 
    LU_M2a.DisplayCode AS M2a, LU_M2a.UserDescription AS M2a_Desc, 
    LU_M2b.DisplayCode AS M2b, LU_M2b.UserDescription AS M2b_Desc, 

    (case when CRS_AssessShare4.M4All > 0 then Y1.DisplayCode end) as M4All, 
    (case when CRS_AssessShare4.M4All > 0 then Y1.UserDescription end) as M4All_Desc, 
    (case CRS_AssessShare4.M4a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M4a, 
    (case CRS_AssessShare4.M4a when 1 then Y.UserDescription when 2 then N.UserDescription end) as M4a_Desc, 
    (case CRS_AssessShare4.M4b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M4b, 
    (case CRS_AssessShare4.M4b when 1 then Y.UserDescription when 2 then N.UserDescription end) as M4b_Desc, 
    (case CRS_AssessShare4.M4c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M4c, 
    (case CRS_AssessShare4.M4c when 1 then Y.UserDescription when 2 then N.UserDescription end) as M4c_Desc, 
    (case CRS_AssessShare4.M4d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M4d, 
    (case CRS_AssessShare4.M4d when 1 then Y.UserDescription when 2 then N.UserDescription end) as M4d_Desc, 
    (case CRS_AssessShare4.M4e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M4e, 
    (case CRS_AssessShare4.M4e when 1 then Y.UserDescription when 2 then N.UserDescription end) as M4e_Desc, 
    (case CRS_AssessShare4.M4f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M4f, 
    (case CRS_AssessShare4.M4f when 1 then Y.UserDescription when 2 then N.UserDescription end) as M4f_Desc, 
    (case CRS_AssessShare4.M4g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M4g, 
    (case CRS_AssessShare4.M4g when 1 then Y.UserDescription when 2 then N.UserDescription end) as M4g_Desc, 

    (case when CRS_AssessShare4.M5All > 0 then Y1.DisplayCode end) as M5All, 
    (case when CRS_AssessShare4.M5All > 0 then Y1.UserDescription end) as M5All_Desc, 
    (case CRS_AssessShare4.M5a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5a, 
    (case CRS_AssessShare4.M5a when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5a_Desc, 
    (case CRS_AssessShare4.M5b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5b, 
    (case CRS_AssessShare4.M5b when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5b_Desc, 
    (case CRS_AssessShare4.M5c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5c, 
    (case CRS_AssessShare4.M5c when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5c_Desc, 
    (case CRS_AssessShare4.M5d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5d, 
    (case CRS_AssessShare4.M5d when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5d_Desc, 
    (case CRS_AssessShare4.M5e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5e, 
    (case CRS_AssessShare4.M5e when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5e_Desc, 
    (case CRS_AssessShare4.M5f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5f, 
    (case CRS_AssessShare4.M5f when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5f_Desc, 
    (case CRS_AssessShare4.M5g when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5g, 
    (case CRS_AssessShare4.M5g when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5g_Desc, 
    (case CRS_AssessShare4.M5h when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5h, 
    (case CRS_AssessShare4.M5h when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5h_Desc, 
    (case CRS_AssessShare4.M5I when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M5I, 
    (case CRS_AssessShare4.M5I when 1 then Y.UserDescription when 2 then N.UserDescription end) as M5I_Desc, 

    (case when CRS_AssessShare4.M6All > 0 then Y1.DisplayCode end) as M6All, 
    (case when CRS_AssessShare4.M6All > 0 then Y1.UserDescription end) as M6All_Desc, 
    (case CRS_AssessShare4.M6a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M6a, 
    (case CRS_AssessShare4.M6a when 1 then Y.UserDescription when 2 then N.UserDescription end) as M6a_Desc, 
    (case CRS_AssessShare4.M6b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M6b, 
    (case CRS_AssessShare4.M6b when 1 then Y.UserDescription when 2 then N.UserDescription end) as M6b_Desc, 
    (case CRS_AssessShare4.M6c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M6c, 
    (case CRS_AssessShare4.M6c when 1 then Y.UserDescription when 2 then N.UserDescription end) as M6c_Desc, 
    (case CRS_AssessShare4.M6d when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M6d, 
    (case CRS_AssessShare4.M6d when 1 then Y.UserDescription when 2 then N.UserDescription end) as M6d_Desc, 
    (case CRS_AssessShare4.M6e when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M6e, 
    (case CRS_AssessShare4.M6e when 1 then Y.UserDescription when 2 then N.UserDescription end) as M6e_Desc, 
    (case CRS_AssessShare4.M6f when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as M6f, 
    (case CRS_AssessShare4.M6f when 1 then Y.UserDescription when 2 then N.UserDescription end) as M6f_Desc, 

    (case when CRS_AssessShare4.N1All > 0 then Y1.DisplayCode end) as N1All, 
    (case when CRS_AssessShare4.N1All > 0 then Y1.UserDescription end) as N1All_Desc, 
    (case CRS_AssessShare4.N1a when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as N1a, 
    (case CRS_AssessShare4.N1a when 1 then Y.UserDescription when 2 then N.UserDescription end) as N1a_Desc, 
    (case CRS_AssessShare4.N1b when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as N1b, 
    (case CRS_AssessShare4.N1b when 1 then Y.UserDescription when 2 then N.UserDescription end) as N1b_Desc, 
    (case CRS_AssessShare4.N1c when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as N1c, 
    (case CRS_AssessShare4.N1c when 1 then Y.UserDescription when 2 then N.UserDescription end) as N1c_Desc, 

    LU_N2.DisplayCode AS N2, LU_N2.UserDescription AS N2_Desc, dbo.CRS_AssessShare4.O1, dbo.CRS_AssessShare4.O3, 
    dbo.CRS_AssessShare4.O4a, dbo.CRS_AssessShare4.O4b, dbo.CRS_AssessShare4.O4c, dbo.CRS_AssessShare4.O4d, dbo.CRS_AssessShare4.O4e, 
    dbo.CRS_AssessShare4.O4f,
--Share 5
    LU_P1All.DisplayCode AS P1aAll, LU_P1All.UserDescription AS P1aAll_Desc, 
    (case CRS_AssessShare5.P1aa when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1aa, 
    (case CRS_AssessShare5.P1aa when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1aa_Desc, 
    (case CRS_AssessShare5.P1ab when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ab, 
    (case CRS_AssessShare5.P1ab when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ab_Desc, 
    (case CRS_AssessShare5.P1ac when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ac, 
    (case CRS_AssessShare5.P1ac when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ac_Desc, 
    (case CRS_AssessShare5.P1ad when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ad, 
    (case CRS_AssessShare5.P1ad when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ad_Desc, 
    (case CRS_AssessShare5.P1ae when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ae, 
    (case CRS_AssessShare5.P1ae when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ae_Desc, 
    (case CRS_AssessShare5.P1af when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1af, 
    (case CRS_AssessShare5.P1af when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1af_Desc, 
    (case CRS_AssessShare5.P1ag when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ag, 
    (case CRS_AssessShare5.P1ag when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ag_Desc, 
    (case CRS_AssessShare5.P1ah when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ah, 
    (case CRS_AssessShare5.P1ah when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ah_Desc, 
    (case CRS_AssessShare5.P1ai when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ai, 
    (case CRS_AssessShare5.P1ai when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ai_Desc, 
    (case CRS_AssessShare5.P1aj when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1aj, 
    (case CRS_AssessShare5.P1aj when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1aj_Desc, 
    (case CRS_AssessShare5.P1ak when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ak, 
    (case CRS_AssessShare5.P1ak when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ak_Desc, 
    (case CRS_AssessShare5.P1al when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1al, 
    (case CRS_AssessShare5.P1al when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1al_Desc, 
    (case CRS_AssessShare5.P1am when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1am, 
    (case CRS_AssessShare5.P1am when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1am_Desc, 
    (case CRS_AssessShare5.P1an when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1an, 
    (case CRS_AssessShare5.P1an when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1an_Desc, 
    (case CRS_AssessShare5.P1ao when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ao, 
    (case CRS_AssessShare5.P1ao when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ao_Desc, 
    (case CRS_AssessShare5.P1ap when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ap, 
    (case CRS_AssessShare5.P1ap when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ap_Desc, 
    (case CRS_AssessShare5.P1aq when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1aq, 
    (case CRS_AssessShare5.P1aq when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1aq_Desc, 
    (case CRS_AssessShare5.P1ar when 1 then Y.DisplayCode when 2 then N.DisplayCode end) as P1ar, 
    (case CRS_AssessShare5.P1ar when 1 then Y.UserDescription when 2 then N.UserDescription end) as P1ar_Desc, 

    dbo.CRS_AssessShare5.P1baA, dbo.CRS_AssessShare5.P1baB, 
    dbo.CRS_AssessShare5.P1bbA, dbo.CRS_AssessShare5.P1bbB, dbo.CRS_AssessShare5.P1bcA, dbo.CRS_AssessShare5.P1bcB, 
    dbo.CRS_AssessShare5.P1bdA, dbo.CRS_AssessShare5.P1bdB, dbo.CRS_AssessShare5.P1beA, dbo.CRS_AssessShare5.P1beB, 
    dbo.CRS_AssessShare5.P1bfA, dbo.CRS_AssessShare5.P1bfB, dbo.CRS_AssessShare5.P3a, dbo.CRS_AssessShare5.P3b, 
    dbo.CRS_AssessShare5.P3c, dbo.CRS_AssessShare5.P3d, dbo.CRS_AssessShare5.P3e, dbo.CRS_AssessShare5.P3f, dbo.CRS_AssessShare5.P3g, 
    dbo.CRS_AssessShare5.P3h, dbo.CRS_AssessShare5.P3I, dbo.CRS_AssessShare5.P3j, dbo.CRS_AssessShare5.P3k, LU_P4a.DisplayCode AS P4a, 
    LU_P4a.UserDescription AS P4a_Desc, LU_P4b.DisplayCode AS P4b, LU_P4b.UserDescription AS P4b_Desc, LU_P4c.DisplayCode AS P4c, 
    LU_P4c.UserDescription AS P4c_Desc, LU_P4d.DisplayCode AS P4d, LU_P4d.UserDescription AS P4d_Desc, LU_P4e.DisplayCode AS P4e, 
    LU_P4e.UserDescription AS P4e_Desc, dbo.CRS_AssessShare5.P7, dbo.CRS_AssessShare5.P8, LU_Q2.DisplayCode AS Q2, 
    LU_Q2.UserDescription AS Q2_Desc, dbo.CRS_AssessShare5.R2b,

--Diagnosis
    I3a, I3b, I3c, I3d, I3e, I3f
FROM     
    dbo.CRS_Demographic with (nolock) INNER JOIN
    dbo.LU_CodeFile LU_AA8 with (nolock) on dbo.CRS_Demographic.AA8 = LU_AA8.Code LEFT JOIN
    dbo.LU_CodeFile LU_Gender with (nolock) on dbo.CRS_Demographic.Gender = LU_Gender.Code LEFT JOIN
    dbo.H_InstitutionProfile with (nolock) on dbo.CRS_Demographic.InstitutionNumber = dbo.H_InstitutionProfile.Code LEFT OUTER JOIN
    dbo.LU_HCNProvince with (nolock) on dbo.LU_HCNProvince.Code = dbo.CRS_Demographic.HCNProvince LEFT OUTER JOIN
    dbo.U_Users U_TSICoder with (nolock) on dbo.CRS_Demographic.TSICoder = U_TSICoder.Code LEFT OUTER JOIN
    dbo.LU_YesBlank LU_Secret with (nolock) on dbo.CRS_Demographic.Secret = LU_Secret.Code LEFT OUTER JOIN
    dbo.U_Users U_DataEntryCoder with (nolock) on dbo.CRS_Demographic.DataEntryCoder = U_DataEntryCoder.Code LEFT OUTER JOIN
    dbo.U_Users U_InterfaceCoder with (nolock) on dbo.CRS_Demographic.InterfaceCoder = U_InterfaceCoder.Code LEFT OUTER JOIN
    dbo.U_Users LU_Coder with (nolock) on dbo.CRS_Demographic.CoderNumber = LU_Coder.Code LEFT OUTER JOIN
    dbo.LU_Site with (nolock) on dbo.CRS_Demographic.SiteNumber = dbo.LU_Site.Code LEFT OUTER JOIN
    dbo.LU_DeleteStatus LU_IsDeleted with (nolock) on dbo.CRS_Demographic.IsDeleted = LU_IsDeleted.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_IsCompleted with (nolock) on dbo.CRS_Demographic.IsCompleted = LU_IsCompleted.Code LEFT OUTER JOIN
    dbo.LU_AbstractStatus LU_IsValidated with (nolock) on dbo.CRS_Demographic.IsValidated = LU_IsValidated.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_IsSubmited with (nolock) on dbo.CRS_Demographic.IsSubmited = LU_IsSubmited.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Z1 with (nolock) on dbo.CRS_Demographic.Z1 = LU_Z1.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 LU_Inst_To with (nolock) on dbo.CRS_Demographic.InstitutionTo = LU_Inst_To.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_R3a with (nolock) on LU_R3a.Code = dbo.CRS_Demographic.R3a LEFT OUTER JOIN
    dbo.LU_Institution_10 LU_Inst_From with (nolock) on dbo.CRS_Demographic.InstitutionFrom = LU_Inst_From.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AB2c with (nolock) on dbo.CRS_Demographic.AB2c = LU_AB2c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_AB2a with (nolock) on dbo.CRS_Demographic.AB2a = LU_AB2a.Code LEFT OUTER JOIN
    dbo.LU_NurseArea with (nolock) on dbo.CRS_Demographic.AdmittingNurseArea = dbo.LU_NurseArea.Code LEFT OUTER JOIN
    dbo.LU_YesNoSystem LU_BirthDateEstimated with (nolock) on dbo.CRS_Demographic.BirthDateEstimated = LU_BirthDateEstimated.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_MaritalStatus with (nolock) on dbo.CRS_Demographic.MaritalStatus = LU_MaritalStatus.Code LEFT OUTER JOIN
-- Full 1
    dbo.CRS_AssessFull1 with (nolock) on CRS_Demographic.AbstractID = CRS_AssessFull1.AbstractID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3j with (nolock) on dbo.CRS_AssessFull1.J3j = LU_J3j.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3I with (nolock) on dbo.CRS_AssessFull1.J3I = LU_J3I.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3h with (nolock) on dbo.CRS_AssessFull1.J3h = LU_J3h.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3g with (nolock) on dbo.CRS_AssessFull1.J3g = LU_J3g.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3f with (nolock) on dbo.CRS_AssessFull1.J3f = LU_J3f.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3e with (nolock) on dbo.CRS_AssessFull1.J3e = LU_J3e.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3d with (nolock) on dbo.CRS_AssessFull1.J3d = LU_J3d.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3c with (nolock) on dbo.CRS_AssessFull1.J3c = LU_J3c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3b with (nolock) on dbo.CRS_AssessFull1.J3b = LU_J3b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J3a with (nolock) on dbo.CRS_AssessFull1.J3a = LU_J3a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F3c with (nolock) on dbo.CRS_AssessFull1.F3c = LU_F3c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F3b with (nolock) on dbo.CRS_AssessFull1.F3b = LU_F3b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F3a with (nolock) on dbo.CRS_AssessFull1.F3a = LU_F3a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F2g with (nolock) on dbo.CRS_AssessFull1.F2g = LU_F2g.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F2f with (nolock) on dbo.CRS_AssessFull1.F2f = LU_F2f.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F2e with (nolock) on dbo.CRS_AssessFull1.F2e = LU_F2e.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F2d with (nolock) on dbo.CRS_AssessFull1.F2d = LU_F2d.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F2c with (nolock) on dbo.CRS_AssessFull1.F2c = LU_F2c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F2b with (nolock) on dbo.CRS_AssessFull1.F2b = LU_F2b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F2a with (nolock) on dbo.CRS_AssessFull1.F2a = LU_F2a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_D3 with (nolock) on dbo.CRS_AssessFull1.D3 = LU_D3.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_D2b with (nolock) on dbo.CRS_AssessFull1.D2b = LU_D2b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_D2a with (nolock) on dbo.CRS_AssessFull1.D2a = LU_D2a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_D1 with (nolock) on dbo.CRS_AssessFull1.D1 = LU_D1.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C5 with (nolock) on dbo.CRS_AssessFull1.C5 = LU_C5.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C3f with (nolock) on dbo.CRS_AssessFull1.C3f = LU_C3f.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C3e with (nolock) on dbo.CRS_AssessFull1.C3e = LU_C3e.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C3d with (nolock) on dbo.CRS_AssessFull1.C3d = LU_C3d.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C3c with (nolock) on dbo.CRS_AssessFull1.C3c = LU_C3c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C3b with (nolock) on dbo.CRS_AssessFull1.C3b = LU_C3b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C3a with (nolock) on dbo.CRS_AssessFull1.C3a = LU_C3a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C2c with (nolock) on dbo.CRS_AssessFull1.C2c = LU_C2c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C2b with (nolock) on dbo.CRS_AssessFull1.C2b = LU_C2b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C2a with (nolock) on dbo.CRS_AssessFull1.C2a = LU_C2a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_C1 with (nolock) on dbo.CRS_AssessFull1.C1 = LU_C1.Code LEFT OUTER JOIN
--Full 2
    dbo.CRS_AssessFull2 with (nolock) on CRS_Demographic.AbstractID = CRS_AssessFull2.AbstractID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_R1c with (nolock) on dbo.CRS_AssessFull2.R1c = LU_R1c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_R1b with (nolock) on dbo.CRS_AssessFull2.R1b = LU_R1b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Q1c with (nolock) on dbo.CRS_AssessFull2.Q1c = LU_Q1c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_O2 with (nolock) on dbo.CRS_AssessFull2.O2 = LU_O2.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N5b with (nolock) on dbo.CRS_AssessFull2.N5b = LU_N5b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N5a with (nolock) on dbo.CRS_AssessFull2.N5a = LU_N5a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4l with (nolock) on dbo.CRS_AssessFull2.N4l = LU_N4l.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4k with (nolock) on dbo.CRS_AssessFull2.N4k = LU_N4k.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4j with (nolock) on dbo.CRS_AssessFull2.N4j = LU_N4j.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4I with (nolock) on dbo.CRS_AssessFull2.N4I = LU_N4I.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4h with (nolock) on dbo.CRS_AssessFull2.N4h = LU_N4h.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4g with (nolock) on dbo.CRS_AssessFull2.N4g = LU_N4g.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4f with (nolock) on dbo.CRS_AssessFull2.N4f = LU_N4f.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4e with (nolock) on dbo.CRS_AssessFull2.N4e = LU_N4e.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4d with (nolock) on dbo.CRS_AssessFull2.N4d = LU_N4d.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4c with (nolock) on dbo.CRS_AssessFull2.N4c = LU_N4c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4b with (nolock) on LU_N4b.Code = dbo.CRS_AssessFull2.N4b LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N4a with (nolock) on dbo.CRS_AssessFull2.N4a = LU_N4a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N3d with (nolock) on dbo.CRS_AssessFull2.N3d = LU_N3d.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N3c with (nolock) on LU_N3c.Code = dbo.CRS_AssessFull2.N3c LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N3b with (nolock) on dbo.CRS_AssessFull2.N3b = LU_N3b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_N3a with (nolock) on dbo.CRS_AssessFull2.N3a = LU_N3a.Code LEFT OUTER JOIN 

--Share 1
    dbo.CRS_AssessShare1 with (nolock) on CRS_AssessShare1.AbstractID = CRS_Demographic.AbstractID LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E5 with (nolock) on dbo.CRS_AssessShare1.E5 = LU_E5.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4eB with (nolock) on dbo.CRS_AssessShare1.E4eB = LU_E4eB.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4eA with (nolock) on LU_E4eA.Code = dbo.CRS_AssessShare1.E4eA LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4dB with (nolock) on dbo.CRS_AssessShare1.E4dB = LU_E4dB.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4dA with (nolock) on dbo.CRS_AssessShare1.E4dA = LU_E4dA.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4cB with (nolock) on dbo.CRS_AssessShare1.E4cB = LU_E4cB.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4cA with (nolock) on LU_E4cA.Code = dbo.CRS_AssessShare1.E4cA LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4bB with (nolock) on dbo.CRS_AssessShare1.E4bB = LU_E4bB.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4bA with (nolock) on LU_E4bA.Code = dbo.CRS_AssessShare1.E4bA LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4aB with (nolock) on dbo.CRS_AssessShare1.E4aB = LU_E4aB.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E4aA with (nolock) on dbo.CRS_AssessShare1.E4aA = LU_E4aA.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E3 with (nolock) on dbo.CRS_AssessShare1.E3 = LU_E3.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E2 with (nolock) on dbo.CRS_AssessShare1.E2 = LU_E2.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1p with (nolock) on dbo.CRS_AssessShare1.E1p = LU_E1p.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1o with (nolock) on LU_E1o.Code = dbo.CRS_AssessShare1.E1o LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1n with (nolock) on dbo.CRS_AssessShare1.E1n = LU_E1n.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1m with (nolock) on dbo.CRS_AssessShare1.E1m = LU_E1m.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1l with (nolock) on dbo.CRS_AssessShare1.E1l = LU_E1l.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1k with (nolock) on dbo.CRS_AssessShare1.E1k = LU_E1k.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1j with (nolock) on dbo.CRS_AssessShare1.E1j = LU_E1j.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1I with (nolock) on LU_E1I.Code = dbo.CRS_AssessShare1.E1I LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1h with (nolock) on dbo.CRS_AssessShare1.E1h = LU_E1h.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1g with (nolock) on dbo.CRS_AssessShare1.E1g = LU_E1g.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1f with (nolock) on dbo.CRS_AssessShare1.E1f = LU_E1f.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1e with (nolock) on dbo.CRS_AssessShare1.E1e = LU_E1e.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1d with (nolock) on dbo.CRS_AssessShare1.E1d = LU_E1d.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1c with (nolock) on dbo.CRS_AssessShare1.E1c = LU_E1c.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1b with (nolock) on dbo.CRS_AssessShare1.E1b = LU_E1b.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_E1a with (nolock) on dbo.CRS_AssessShare1.E1a = LU_E1a.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_C7 with (nolock) on dbo.CRS_AssessShare1.C7 = LU_C7.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_C6 with (nolock) on dbo.CRS_AssessShare1.C6 = LU_C6.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_C4 with (nolock) on dbo.CRS_AssessShare1.C4 = LU_C4.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B6 with (nolock) on dbo.CRS_AssessShare1.B6 = LU_B6.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B5f with (nolock) on dbo.CRS_AssessShare1.B5f = LU_B5f.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B5e with (nolock) on dbo.CRS_AssessShare1.B5e = LU_B5e.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B5d with (nolock) on LU_B5d.Code = dbo.CRS_AssessShare1.B5d LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B5c with (nolock) on dbo.CRS_AssessShare1.B5c = LU_B5c.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B5b with (nolock) on dbo.CRS_AssessShare1.B5b = LU_B5b.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B5a with (nolock) on dbo.CRS_AssessShare1.B5a = LU_B5a.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B4 with (nolock) on LU_B4.Code = dbo.CRS_AssessShare1.B4 LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B3a with (nolock) on dbo.CRS_AssessShare1.B3a = LU_B3a.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B3b with (nolock) on LU_B3b.Code = dbo.CRS_AssessShare1.B3b LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B3c with (nolock) on LU_B3c.Code = dbo.CRS_AssessShare1.B3c LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B3d with (nolock) on dbo.CRS_AssessShare1.B3d = LU_B3d.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B2b with (nolock) on dbo.CRS_AssessShare1.B2b = LU_B2b.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_B2a with (nolock) on dbo.CRS_AssessShare1.B2a = LU_B2a.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10h_Q with (nolock) on dbo.CRS_AssessShare1.A10h = LU_A10h_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10g_Q with (nolock) on dbo.CRS_AssessShare1.A10g = LU_A10g_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10f_Q with (nolock) on dbo.CRS_AssessShare1.A10f = LU_A10f_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10e_Q with (nolock) on dbo.CRS_AssessShare1.A10e = LU_A10e_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10d_Q with (nolock) on dbo.CRS_AssessShare1.A10d = LU_A10d_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10c_Q with (nolock) on dbo.CRS_AssessShare1.A10c = LU_A10c_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10b_Q with (nolock) on dbo.CRS_AssessShare1.A10b = LU_A10b_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A10a_Q with (nolock) on dbo.CRS_AssessShare1.A10a = LU_A10a_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A9f_Q with (nolock) on dbo.CRS_AssessShare1.A9f = LU_A9f_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A9e_Q with (nolock) on dbo.CRS_AssessShare1.A9e = LU_A9e_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A9d_Q with (nolock) on dbo.CRS_AssessShare1.A9d = LU_A9d_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A9c_Q with (nolock) on dbo.CRS_AssessShare1.A9c = LU_A9c_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A9b_Q with (nolock) on dbo.CRS_AssessShare1.A9b = LU_A9b_Q.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_A9a_Q with (nolock) on dbo.CRS_AssessShare1.A9a = LU_A9a_Q.Code LEFT OUTER JOIN 

--Share 2
    dbo.CRS_AssessShare2 with (nolock) on CRS_Demographic.AbstractID = CRS_AssessShare2.AbstractID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_H4 with (nolock) on dbo.CRS_AssessShare2.H4 = LU_H4.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_H1b with (nolock) on dbo.CRS_AssessShare2.H1b = LU_H1b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_H1a with (nolock) on dbo.CRS_AssessShare2.H1a = LU_H1a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G9 with (nolock) on dbo.CRS_AssessShare2.G9 = LU_G9.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4fB with (nolock) on LU_G4fB.Code = dbo.CRS_AssessShare2.G4fB LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4fA with (nolock) on dbo.CRS_AssessShare2.G4fA = LU_G4fA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4eB with (nolock) on LU_G4eB.Code = dbo.CRS_AssessShare2.G4eB LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4eA with (nolock) on LU_G4eA.Code = dbo.CRS_AssessShare2.G4eA LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4dB with (nolock) on LU_G4dB.Code = dbo.CRS_AssessShare2.G4dB LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4dA with (nolock) on dbo.CRS_AssessShare2.G4dA = LU_G4dA.Code LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_G4cB with (nolock) on LU_G4cB.Code = dbo.CRS_AssessShare2.G4cB LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4cA with (nolock) on dbo.CRS_AssessShare2.G4cA = LU_G4cA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4bB with (nolock) on dbo.CRS_AssessShare2.G4bB = LU_G4bB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4bA with (nolock) on dbo.CRS_AssessShare2.G4bA = LU_G4bA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4aB with (nolock) on dbo.CRS_AssessShare2.G4aB = LU_G4aB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G4aA with (nolock) on dbo.CRS_AssessShare2.G4aA = LU_G4aA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G3b with (nolock) on dbo.CRS_AssessShare2.G3b = LU_G3b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G3a with (nolock) on dbo.CRS_AssessShare2.G3a = LU_G3a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G2B with (nolock) on dbo.CRS_AssessShare2.G2B = LU_G2B.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G2A with (nolock) on dbo.CRS_AssessShare2.G2A = LU_G2A.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1jB with (nolock) on dbo.CRS_AssessShare2.G1jB = LU_G1jB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1jA with (nolock) on dbo.CRS_AssessShare2.G1jA = LU_G1jA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1IB with (nolock) on dbo.CRS_AssessShare2.G1iB = LU_G1IB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1IA with (nolock) on dbo.CRS_AssessShare2.G1iA = LU_G1IA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1hB with (nolock) on dbo.CRS_AssessShare2.G1hB = LU_G1hB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1hA with (nolock) on dbo.CRS_AssessShare2.G1hA = LU_G1hA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1gB with (nolock) on dbo.CRS_AssessShare2.G1gB = LU_G1gB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1gA with (nolock) on dbo.CRS_AssessShare2.G1gA = LU_G1gA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1fB with (nolock) on dbo.CRS_AssessShare2.G1fB = LU_G1fB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1fA with (nolock) on dbo.CRS_AssessShare2.G1fA = LU_G1fA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1eB with (nolock) on dbo.CRS_AssessShare2.G1eB = LU_G1eB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1eA with (nolock) on dbo.CRS_AssessShare2.G1eA = LU_G1eA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1dA with (nolock) on dbo.CRS_AssessShare2.G1dA = LU_G1dA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1dB with (nolock) on dbo.CRS_AssessShare2.G1dB = LU_G1dB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1cB with (nolock) on dbo.CRS_AssessShare2.G1cB = LU_G1cB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1cA with (nolock) on dbo.CRS_AssessShare2.G1cA = LU_G1cA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1bB with (nolock) on dbo.CRS_AssessShare2.G1bB = LU_G1bB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1bA with (nolock) on dbo.CRS_AssessShare2.G1bA = LU_G1bA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1aB with (nolock) on dbo.CRS_AssessShare2.G1aB = LU_G1aB.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_G1aA with (nolock) on dbo.CRS_AssessShare2.G1aA = LU_G1aA.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F1f with (nolock) on dbo.CRS_AssessShare2.F1f = LU_F1f.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F1e with (nolock) on dbo.CRS_AssessShare2.F1e = LU_F1e.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F1d with (nolock) on dbo.CRS_AssessShare2.F1d = LU_F1d.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F1c with (nolock) on dbo.CRS_AssessShare2.F1c = LU_F1c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F1b with (nolock) on dbo.CRS_AssessShare2.F1b = LU_F1b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_F1a with (nolock) on dbo.CRS_AssessShare2.F1a = LU_F1a.Code LEFT OUTER JOIN
--Share 3
    dbo.CRS_AssessShare3 with (nolock) on dbo.CRS_AssessShare3.AbstractID = dbo.CRS_Demographic.AbstractID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J2b with (nolock) on dbo.CRS_AssessShare3.J2b = LU_J2b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_J2a with (nolock) on dbo.CRS_AssessShare3.J2a = LU_J2a.Code LEFT OUTER JOIN
--Share 4
    dbo.CRS_AssessShare4 with (nolock) on CRS_Demographic.AbstractID = CRS_AssessShare4.AbstractID LEFT OUTER JOIN 
    dbo.LU_CodeFile LU_N2 with (nolock) on LU_N2.Code = dbo.CRS_AssessShare4.N2 LEFT OUTER JOIN
    dbo.LU_CodeFile LU_M2b with (nolock) on dbo.CRS_AssessShare4.M2b = LU_M2b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_M2a with (nolock) on dbo.CRS_AssessShare4.M2a = LU_M2a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_K6b with (nolock) on dbo.CRS_AssessShare4.K6b = LU_K6b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_K6a with (nolock) on dbo.CRS_AssessShare4.K6a = LU_K6a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_K3b_Q with (nolock) on LU_K3b_Q.Code = dbo.CRS_AssessShare4.K3b LEFT OUTER JOIN
    dbo.LU_CodeFile LU_K3a_Q with (nolock) on LU_K3a_Q.Code = dbo.CRS_AssessShare4.K3a LEFT OUTER JOIN  
--Share 5
    dbo.CRS_AssessShare5 with (nolock) on CRS_Demographic.AbstractID = CRS_AssessShare5.AbstractID LEFT OUTER JOIN
    dbo.LU_CodeFile LU_Q2 with (nolock) on dbo.CRS_AssessShare5.Q2 = LU_Q2.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_P4e with (nolock) on dbo.CRS_AssessShare5.P4e = LU_P4e.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_P4d with (nolock) on dbo.CRS_AssessShare5.P4d = LU_P4d.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_P4c with (nolock) on dbo.CRS_AssessShare5.P4c = LU_P4c.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_P4b with (nolock) on dbo.CRS_AssessShare5.P4b = LU_P4b.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_P4a with (nolock) on dbo.CRS_AssessShare5.P4a = LU_P4a.Code LEFT OUTER JOIN
    dbo.LU_CodeFile LU_P1All with (nolock) on dbo.CRS_AssessShare5.P1aAll = LU_P1All.Code LEFT OUTER JOIN

--Diagnosis
    dbo.CRS_Diagnosis with (nolock) on CRS_Demographic.AbstractID = CRS_Diagnosis.AbstractID
    cross join ( select top 1 DisplayCode, UserDescription from LU_YesNoSystem where code = 1 ) Y
    cross join ( select top 1 DisplayCode, UserDescription from LU_YesNoSystem where code = 2 ) N
    cross join ( select top 1 DisplayCode, UserDescription from LU_CodeFile where LookUpID = 1 ) Y1

/*
where 
    (isnull( CRS_Diagnosis.AbstractID, 0) + 
    isnull( CRS_AssessShare1.AbstractID, 0) +
    isnull( CRS_AssessShare2.AbstractID, 0) +
    isnull( CRS_AssessShare3.AbstractID, 0) +
    isnull( CRS_AssessShare4.AbstractID, 0) +
    isnull( CRS_AssessShare5.AbstractID, 0) +
    isnull( CRS_AssessFull1.AbstractID, 0) +
    isnull( CRS_AssessFull2.AbstractID, 0) ) > 0
*/




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Diagnosis_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

/*d(bo.AB_Diagnosis.DiagnosisICDType = ''T'')*/
CREATE VIEW [dbo].[I10_Diagnosis_VR]
AS
SELECT     TOP 100 PERCENT dbo.AB_Diagnosis.DiagnosisCluster, dbo.ICD_DiagFile10.CIHIValue AS DiagnosisCIHIValue, 
                      dbo.ICD_DiagFile10.DisplayCode AS DiagnosisCode, dbo.ICD_DiagFile10.UserDescription AS DiagnosisCodeDesc, 
                      dbo.ICD_DiagFile10.ShortDescription AS DiagnosisCodeShortDesc, dbo.ICD_DiagFile10.ICD9cm AS DiagnosisICD9cmEquivalent, 
                      dbo.ICD_DiagFile10.ICD9 AS DiagnosisICD9Equivalent, dbo.AB_Diagnosis.DiagnosisOccurrence, Lookup1.DisplayCode AS DiagnosisPrefix, 
                      Lookup1.UserDescription AS DiagnosisPrefixDesc, Lookup2.DisplayCode AS DiagnosisType, Lookup2.UserDescription AS DiagnosisTypeDesc, 
                      dbo.AB_Diagnosis.AbstractID AS zzAbstractLink
FROM         dbo.AB_Diagnosis with (nolock) INNER JOIN
                      dbo.AB_Abstract with (nolock) ON dbo.AB_Diagnosis.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.ICD_DiagFile10 with (nolock) ON dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile10.Code LEFT OUTER JOIN
                      dbo.LU_DiagnosisPrefix Lookup1 with (nolock) ON dbo.AB_Diagnosis.DiagnosisPrefix = Lookup1.Code LEFT OUTER JOIN
                      dbo.LU_DiagnosisType AS Lookup2 with (nolock) ON dbo.AB_Diagnosis.DiagnosisType = Lookup2.Code
WHERE     (dbo.AB_Abstract.ICDType = ''T'')


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_DiagnosisToICD9cm_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[I10_DiagnosisToICD9cm_VR]
AS
SELECT     TOP 100 PERCENT dbo.ICD_DiagFile10.DisplayCode AS DiagnosisCode, dbo.ICD_DiagFile10.UserDescription AS DiagnosisCodeDesc, 
                      dbo.ICD_DiagFile10.ShortDescription AS DiagnosisCodeShortDesc, Lookup1.DisplayCode AS DiagnosisPrefix, 
                      Lookup1.UserDescription AS DiagnosisPrefixDesc, Lookup2.DisplayCode AS DiagnosisType, Lookup2.UserDescription AS DiagnosisTypeDesc, 
                      dbo.ICD_DiagFile10.ICD9 AS ICD9Equivalent, dbo.ICD_DiagFile10.ICD9cm AS ICD9cmEquivalent, AB_Diagnosis_1.DiagnosisICDType, 
                      AB_Diagnosis_1.AbstractID AS zzAbstractLinkICD9cm
FROM         dbo.AB_Diagnosis with (nolock) LEFT OUTER JOIN
                      dbo.ICD_DiagFile10 with (nolock) LEFT OUTER JOIN
                      dbo.ICD_DiagFile9cm with (nolock) ON dbo.ICD_DiagFile10.ICD9cm = dbo.ICD_DiagFile9cm.CIHIValue RIGHT OUTER JOIN
                      dbo.AB_Diagnosis AB_Diagnosis_1 with (nolock) ON dbo.ICD_DiagFile9cm.Code = AB_Diagnosis_1.DiagnosisCode ON 
                      dbo.AB_Diagnosis.DiagnosisCode = dbo.ICD_DiagFile10.Code LEFT OUTER JOIN
                      dbo.LU_DiagnosisPrefix Lookup1 with (nolock) ON dbo.AB_Diagnosis.DiagnosisPrefix = Lookup1.Code LEFT OUTER JOIN
                      dbo.LU_DiagnosisType Lookup2 with (nolock) ON dbo.AB_Diagnosis.DiagnosisType = Lookup2.Code
WHERE     (AB_Diagnosis_1.DiagnosisICDType = ''C'')




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_DPG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[I10_DPG_VR]
as
select 
    DPGOccurrence = dpg.OccurrenceNumber, 
    DPG_Year, 
    DPG, 
    DPG_RIW, 
    DPG_MOH_RIW, 
    DPG_Description, 
    DPGReturnCode,
    p.DisplayCode as InterventionCode, p.UserDescription as InterventionCodeDesc,
    zzAbstractLink = dpg.AbstractID
from AB_DPG dpg with (nolock) 
    inner join AB_Abstract ab with (nolock) on dpg.AbstractID = ab.AbstractID
    left join icd_procfile10 p with (nolock) on dpg.InterventionCode = p.code
where ab.ICDType = ''T''



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_HIG_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'create VIEW [dbo].[I10_HIG_VR]
AS
SELECT   
    AB_HIG.GrouperYear, 
    AB_HIG.OccurrenceNumber AS Occurrence_Number, 
    HIG_Code, HIG_Description, HIG_Weight, 
    HIG_AgeCategory, HIG_AgeCategoryDesc = (select top 1 hig_age_category_e_desc from dbo.tGrouper_HIG_Age_Category a where a.hig_age_category_code = HIG_AgeCategory and a.methodology_year = AB_HIG.GrouperYear),
    HIG_AtypicalCode, HIG_AtypicalCodeDesc = (select top 1 hig_atypical_e_desc from dbo.tGrouper_HIG_Atypical b where b.hig_atypical_code = HIG_AtypicalCode and b.methodology_year = AB_HIG.GrouperYear),
    HIG_ELOS, HIG_FI_TotalCount, 
    HIG_HomeCareFlag, HIG_MaternalAgeFlag, HIG_PalliativeCareFlag, HIG_OOHFlag, HIG_SCUFlag, HIG_LongStayTrimDays, HIG_ShortStayTrimDays, 
    dbo.AB_HIG.AbstractID AS zzAbstractLink
FROM  AB_HIG with (nolock) 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_InterventionReplicate_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[I10_InterventionReplicate_VR]
AS
SELECT
    ISNULL(Lookup1.DisplayCode, OCC.AnaestheticTechnique) AS AnaestheticTechnique, ISNULL(Lookup1.UserDescription, 
    OCC.AnaestheticTechniqueDesc) AS AnaestheticTechniqueDesc, 
    ISNULL(Lookup2.DisplayCode, OCC.AnaesthetistID) AS AnaesthetistID, 
    ISNULL(Lookup2.UserDescription, OCC.AnaesthetistIDDesc) AS AnaesthetistIDDesc, 
    
    
    isnull(AB_Intervention.IntervJointIdentifier, OCC.CJRRJointIdentifier)  as CJRRJointIdentifier,
    isnull(LU_CJRR_RevisionReason.DisplayCode, OCC.CJRRRevisionReason) AS CJRRRevisionReason, 
    isnull(LU_CJRR_RevisionReason.UserDescription, OCC.CJRRRevisionReasonDesc) AS CJRRRevisionReasonDesc,

    ISNULL(Lookup3.DisplayCode, OCC.EUL) AS EUL, 
    ISNULL(Lookup3.UserDescription, OCC.EULDesc) AS EULDesc, ISNULL(Lookup4.DisplayCode, OCC.Extra) AS Extra, ISNULL(Lookup4.UserDescription, 
    OCC.ExtraDesc) AS ExtraDesc, Lookup5.DisplayCode AS IntervAttribExtent, Lookup5.UserDescription AS IntervAttribExtentDesc, 
    Lookup6.DisplayCode AS IntervAttribLocation, Lookup6.UserDescription AS IntervAttribLocationDesc, Lookup7.DisplayCode AS IntervAttribStatus, 
    Lookup7.UserDescription AS IntervAttribStatusDesc, dbo.ICD_ProcFile10.CIHIValue AS IntervCIHIValue, dbo.ICD_ProcFile10.DisplayCode AS IntervCode,
    dbo.ICD_ProcFile10.UserDescription AS IntervCodeDesc, dbo.ICD_ProcFile10.ShortDescription AS IntervCodeShortDesc, 
    ISNULL(dbo.AB_Intervention.IntervDate, OCC.IntervDate) AS IntervDate, ISNULL(dbo.AB_Intervention.IntervDateIn, OCC.IntervDateIn) AS IntervDateIn, 
    ISNULL(dbo.AB_Intervention.IntervDateOut, OCC.IntervDateOut) AS IntervDateOut, 

    --PR - 04332
    ISNULL(LU_IntervTimeInUnknown.DisplayCode, OCC.IntervEpisodeStartTimeUnknown)  AS IntervEpisodeStartTimeUnknown, 
    ISNULL(LU_IntervTimeInUnknown.UserDescription, OCC.IntervEpisodeStartTimeUnknownDesc) AS IntervEpisodeStartTimeUnknownDesc, 
    ISNULL(LU_IntervTimeOutUnknown.DisplayCode, OCC.IntervEpisodeEndTimeUnknown)  AS IntervEpisodeEndTimeUnknown, 
    ISNULL(LU_IntervTimeOutUnknown.UserDescription, OCC.IntervEpisodeEndTimeUnknownDesc) AS IntervEpisodeEndTimeUnknownDesc, 

    LU_Flagged.DisplayCode AS IntervFlaggedCategory, LU_Flagged.UserDescription AS IntervFlaggedCategoryDesc, 

    ISNULL(Lookup8.DisplayCode, OCC.IntervLocation)  AS IntervLocation, ISNULL(Lookup8.UserDescription, OCC.IntervLocationDesc) AS IntervLocationDesc, dbo.AB_Intervention.IntervOccurrence, 
    LU_IntervPreAdmitFlag.DisplayCode as IntervPreAdmitFlag, LU_IntervPreAdmitFlag.UserDescription as IntervPreAdmitFlagDesc, 
    ISNULL(Lookup9.DisplayCode, OCC.IntervProviderNumber) AS IntervProviderNumber, ISNULL(Lookup9.UserDescription, OCC.IntervProviderNumberDesc) AS IntervProviderNumberDesc, 
    ISNULL(Lookup15.DisplayCode, OCC.IntervProviderService) AS IntervProviderService, ISNULL(Lookup15.UserDescription, OCC.IntervProviderServiceDesc) AS IntervProviderServiceDesc, 
    ISNULL(Lookup10.DisplayCode, OCC.IntervProviderSpecialty) AS IntervProviderSpecialty, ISNULL(Lookup10.UserDescription, OCC.IntervProviderSpecialtyDesc) AS IntervProviderSpecialtyDesc, 
    --PR - 05248
    ISNULL(LU_IntervSuffix.DisplayCode, OCC.IntervSuffix) AS IntervSuffix, 
    ISNULL(LU_IntervSuffix.UserDescription, OCC.IntervSuffixDesc) AS IntervSuffixDesc, 

    ISNULL(dbo.AB_Intervention.IntervTimeIn, OCC.IntervTimeIn) AS IntervTimeIn, 
    ISNULL(dbo.AB_Intervention.IntervTimeMinutes, OCC.IntervTimeinMinutes) AS IntervTimeinMinutes, 
    ISNULL(dbo.AB_Intervention.IntervTimeOut, OCC.IntervTimeOut) AS IntervTimeOut, 
    ISNULL(Lookup11.DisplayCode, OCC.OOHIndicator) AS OOHIndicator, ISNULL(Lookup11.UserDescription, OCC.OOHIndicatorDesc) AS OOHIndicatorDesc, 
    ISNULL(Lookup12.DisplayCode, OCC.OOHInstitutionNumber) AS OOHInstitutionNumber, 
    ISNULL(Lookup12.UserDescription, OCC.OOHInstitutionNumberDesc) AS OOHInstitutionNumberDesc, 
    ISNULL(Lookup13.DisplayCode, OCC.TissueCode) AS TissueCode, ISNULL(Lookup13.UserDescription, OCC.TissueCodeDesc) AS TissueCodeDesc, 
    ISNULL(Lookup13.DefaultDescription, OCC.TissueCodeDesc_D) AS TissueCodeDesc_D, 
    ISNULL(Lookup14.DisplayCode, OCC.UnplannedReturntoOR) AS UnplannedReturntoOR, 
    ISNULL(Lookup14.UserDescription, OCC.UnplannedReturntoORDesc) AS UnplannedReturntoORDesc, 
    dbo.ICD_ProcFile10.ICD9 AS ICD9Equivalent, dbo.ICD_ProcFile10.ICD9cm AS ICD9cmEquivalent, 
    dbo.AB_Intervention.ORURN,
    dbo.AB_Intervention.AbstractID AS zzAbstractLink
FROM         dbo.AB_Intervention with (nolock) INNER JOIN
                      dbo.AB_Abstract with (nolock) on dbo.AB_Intervention.AbstractID = dbo.AB_Abstract.AbstractID LEFT OUTER JOIN
                      dbo.ICD_ProcFile10 with (nolock) on dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile10.Code LEFT OUTER JOIN
                      dbo.LU_AnaestTechnique Lookup1 with (nolock) on dbo.AB_Intervention.IntervAnaestTechnique = Lookup1.Code LEFT OUTER JOIN
                      dbo.LU_Provider Lookup2 with (nolock) on dbo.AB_Intervention.IntervAnaestID = Lookup2.Code LEFT OUTER JOIN
                      dbo.LU_IntervEUL Lookup3 with (nolock) on dbo.AB_Intervention.IntervEUL = Lookup3.Code LEFT OUTER JOIN
                      dbo.LU_IntervExtra Lookup4 with (nolock) on dbo.AB_Intervention.IntervExtra = Lookup4.Code LEFT OUTER JOIN
                      dbo.LU_IntervAttExtent Lookup5 with (nolock) on dbo.AB_Intervention.IntervAttribExtent = Lookup5.Code LEFT OUTER JOIN
                      dbo.LU_IntervAttLocation Lookup6 with (nolock) on dbo.AB_Intervention.IntervAttribLocation = Lookup6.Code LEFT OUTER JOIN
                      dbo.LU_IntervAttStatus Lookup7 with (nolock) on dbo.AB_Intervention.IntervAttribStatus = Lookup7.Code LEFT OUTER JOIN
                      dbo.LU_IntervLocation_AI Lookup8 with (nolock) on dbo.AB_Intervention.IntervLocation = Lookup8.Code LEFT OUTER JOIN
                      dbo.LU_Provider Lookup9 with (nolock) on dbo.AB_Intervention.IntervProviderNumber = Lookup9.Code LEFT OUTER JOIN
                      dbo.LU_ProviderSpecialty Lookup10 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup10.Code LEFT OUTER JOIN
                      dbo.LU_YesBlank Lookup11 with (nolock) on dbo.AB_Intervention.IntervOOHIndicator = Lookup11.Code LEFT OUTER JOIN
                      dbo.LU_Institution_10 Lookup12 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = Lookup12.Code LEFT OUTER JOIN
                      dbo.LU_IntervTissue Lookup13 with (nolock) on dbo.AB_Intervention.IntervTissueCode = Lookup13.Code LEFT OUTER JOIN
                      dbo.LU_YesBlankAlpha Lookup14 with (nolock) on dbo.AB_Intervention.IntervUnplanReturn = Lookup14.Code LEFT OUTER JOIN
                      dbo.LU_ProviderService Lookup15 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup15.Code LEFT OUTER JOIN
                      dbo.LU_CodeFile AS LU_IntervPreAdmitFlag with (nolock) on dbo.AB_Intervention.IntervPreAdmitFlag = LU_IntervPreAdmitFlag.Code LEFT OUTER JOIN
                      dbo.LU_CodeFile AS LU_IntervTimeInUnknown with (nolock) on dbo.AB_Intervention.IntervTimeInUnknown = LU_IntervTimeInUnknown.Code LEFT OUTER JOIN
                      dbo.LU_CodeFile AS LU_IntervTimeOutUnknown with (nolock) on dbo.AB_Intervention.IntervTimeOutUnknown = LU_IntervTimeOutUnknown.Code  LEFT OUTER JOIN
                      --PR - 05248
                      dbo.LU_IntervSuffix with (nolock) on dbo.AB_Intervention.IntervSuffix = LU_IntervSuffix.Code LEFT OUTER JOIN

    dbo.LU_CodeFile AS LU_Flagged with (nolock) on dbo.AB_Intervention.FlaggedIntervention = LU_Flagged.Code LEFT OUTER JOIN
    LU_CJRR_RevisionReason with (nolock) on dbo.AB_Intervention.IntervRevisionReason = LU_CJRR_RevisionReason.Code LEFT OUTER JOIN
                          (SELECT     S.AbstractID, S.IntervOccurrence, MIN(S.IntervOccurrence - T .IntervOccurrence) AS MinOcc
                            FROM          AB_Intervention s INNER JOIN
                                                       (SELECT     AbstractID, IntervOccurrence
                                                         FROM          AB_Intervention with (nolock)
                                                         WHERE      IntervDate IS NOT NULL) T ON S.AbstractID = T .AbstractID AND S.IntervOccurrence >= T .IntervOccurrence
                            GROUP BY S.AbstractID, S.IntervOccurrence) Dif ON dbo.AB_Intervention.AbstractID = Dif.AbstractID AND 
                      dbo.AB_Intervention.IntervOccurrence = Dif.IntervOccurrence LEFT OUTER JOIN
                          (SELECT     Lookup1.DisplayCode AS AnaestheticTechnique, Lookup1.UserDescription AS AnaestheticTechniqueDesc, 
                                                   Lookup2.DisplayCode AS AnaesthetistID, Lookup2.UserDescription AS AnaesthetistIDDesc, 
                                                    AB_Intervention.IntervJointIdentifier as CJRRJointIdentifier,
                                                   LU_CJRR_RevisionReason.DisplayCode AS CJRRRevisionReason, LU_CJRR_RevisionReason.UserDescription AS CJRRRevisionReasonDesc,
                                                   Lookup3.DisplayCode AS EUL, 
                                                   Lookup3.UserDescription AS EULDesc, Lookup4.DisplayCode AS Extra, Lookup4.UserDescription AS ExtraDesc, 
                                                   dbo.AB_Intervention.IntervDate, dbo.AB_Intervention.IntervDateIn, dbo.AB_Intervention.IntervDateOut, 
                                                   Lookup8.DisplayCode AS IntervLocation, Lookup8.UserDescription AS IntervLocationDesc, dbo.AB_Intervention.IntervOccurrence, 
                                                   Lookup9.DisplayCode AS IntervProviderNumber, Lookup9.UserDescription AS IntervProviderNumberDesc, 
                                                   Lookup15.DisplayCode AS IntervProviderService, Lookup15.UserDescription AS IntervProviderServiceDesc, 
                                                   Lookup10.DisplayCode AS IntervProviderSpecialty, Lookup10.UserDescription AS IntervProviderSpecialtyDesc, 
                                                   dbo.AB_Intervention.IntervTimeIn, dbo.AB_Intervention.IntervTimeMinutes AS IntervTimeinMinutes, dbo.AB_Intervention.IntervTimeOut, 
                                                   Lookup11.DisplayCode AS OOHIndicator, Lookup11.UserDescription AS OOHIndicatorDesc, 
                                                   Lookup12.DisplayCode AS OOHInstitutionNumber, Lookup12.UserDescription AS OOHInstitutionNumberDesc, 
                                                   Lookup13.DisplayCode AS TissueCode, Lookup13.UserDescription AS TissueCodeDesc, 
                                                   Lookup13.DefaultDescription AS TissueCodeDesc_D, Lookup14.DisplayCode AS UnplannedReturntoOR, 
                                                   Lookup14.UserDescription AS UnplannedReturntoORDesc, dbo.AB_Intervention.AbstractID,
                                                   --PR - 04332
                                                   LU_IntervTimeInUnknown.DisplayCode as IntervEpisodeStartTimeUnknown, LU_IntervTimeInUnknown.UserDescription as IntervEpisodeStartTimeUnknownDesc,
                                                   LU_IntervTimeOutUnknown.DisplayCode as IntervEpisodeEndTimeUnknown, LU_IntervTimeOutUnknown.UserDescription as IntervEpisodeEndTimeUnknownDesc,
                                                   LU_IntervSuffix.DisplayCode as IntervSuffix, LU_IntervSuffix.UserDescription as IntervSuffixDesc
    
                            FROM          dbo.AB_Intervention with (nolock) INNER JOIN
                                                   AB_Abstract with (nolock) on AB_Intervention.AbstractID = AB_Abstract.AbstractID LEFT OUTER JOIN
                                                   dbo.ICD_ProcFile10 with (nolock) on dbo.AB_Intervention.IntervCode = dbo.ICD_ProcFile10.Code LEFT OUTER JOIN
                                                   dbo.LU_AnaestTechnique Lookup1 with (nolock) on dbo.AB_Intervention.IntervAnaestTechnique = Lookup1.Code LEFT OUTER JOIN
                                                   dbo.LU_Provider Lookup2 with (nolock) on dbo.AB_Intervention.IntervAnaestID = Lookup2.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervEUL Lookup3 with (nolock) on dbo.AB_Intervention.IntervEUL = Lookup3.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervExtra Lookup4 with (nolock) on dbo.AB_Intervention.IntervExtra = Lookup4.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervAttExtent Lookup5 with (nolock) on dbo.AB_Intervention.IntervAttribExtent = Lookup5.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervAttLocation Lookup6 with (nolock) on dbo.AB_Intervention.IntervAttribLocation = Lookup6.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervAttStatus Lookup7 with (nolock) on dbo.AB_Intervention.IntervAttribStatus = Lookup7.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervLocation_AI Lookup8 with (nolock) on dbo.AB_Intervention.IntervLocation = Lookup8.Code LEFT OUTER JOIN
                                                   dbo.LU_Provider Lookup9 with (nolock) on dbo.AB_Intervention.IntervProviderNumber = Lookup9.Code LEFT OUTER JOIN
                                                   dbo.LU_ProviderSpecialty Lookup10 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup10.Code LEFT OUTER JOIN
                                                   dbo.LU_YesBlank Lookup11 with (nolock) on dbo.AB_Intervention.IntervOOHIndicator = Lookup11.Code LEFT OUTER JOIN
                                                   dbo.LU_Institution_10 Lookup12 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = Lookup12.Code LEFT OUTER JOIN
                                                   dbo.LU_IntervTissue Lookup13 with (nolock) on dbo.AB_Intervention.IntervTissueCode = Lookup13.Code LEFT OUTER JOIN
                                                   dbo.LU_YesBlankAlpha Lookup14 with (nolock) on dbo.AB_Intervention.IntervUnplanReturn = Lookup14.Code LEFT OUTER JOIN
                                                   dbo.LU_ProviderService Lookup15 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup15.Code LEFT OUTER JOIN
                                                   dbo.LU_CodeFile AS LU_IntervTimeInUnknown with (nolock) on dbo.AB_Intervention.IntervTimeInUnknown = LU_IntervTimeInUnknown.Code LEFT OUTER JOIN
                                                   dbo.LU_CodeFile AS LU_IntervTimeOutUnknown with (nolock) on dbo.AB_Intervention.IntervTimeOutUnknown = LU_IntervTimeOutUnknown.Code LEFT OUTER JOIN
                                                   --PR - 05248
                                                   dbo.LU_IntervSuffix with (nolock) on dbo.AB_Intervention.IntervSuffix = LU_IntervSuffix.Code LEFT OUTER JOIN
                                                   LU_CJRR_RevisionReason with (nolock) on dbo.AB_Intervention.IntervRevisionReason = LU_CJRR_RevisionReason.Code 
                            WHERE      AB_Abstract.ICDType = ''T'' AND AB_Intervention.IntervDate IS NOT NULL) OCC ON dbo.AB_Intervention.AbstractID = OCC.AbstractID AND 
                      dbo.AB_Intervention.IntervOccurrence >= OCC.IntervOccurrence AND dbo.AB_Intervention.IntervOccurrence - OCC.IntervOccurrence = Dif.MinOcc
WHERE     (dbo.AB_Abstract.ICDType = ''T'')
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_Interventions_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[I10_Interventions_VR]
AS
SELECT     
    Lookup1.DisplayCode AS AnaestheticTechnique, Lookup1.UserDescription AS AnaestheticTechniqueDesc, Lookup2.DisplayCode AS AnaesthetistID, 
    Lookup2.UserDescription AS AnaesthetistIDDesc, 
    
    AB_Intervention.IntervJointIdentifier as CJRRJointIdentifier,
    LU_CJRR_RevisionReason.DisplayCode AS CJRRRevisionReason, LU_CJRR_RevisionReason.UserDescription AS CJRRRevisionReasonDesc,

    Lookup3.DisplayCode AS EUL, Lookup3.UserDescription AS EULDesc, 
    Lookup4.DisplayCode AS Extra, Lookup4.UserDescription AS ExtraDesc, Lookup5.DisplayCode AS IntervAttribExtent, 
    Lookup5.UserDescription AS IntervAttribExtentDesc, Lookup6.DisplayCode AS IntervAttribLocation, 
    Lookup6.UserDescription AS IntervAttribLocationDesc, Lookup7.DisplayCode AS IntervAttribStatus, Lookup7.UserDescription AS IntervAttribStatusDesc, 
    dbo.ICD_ProcFile10.CIHIValue AS IntervCIHIValue, 
    dbo.ICD_ProcFile10.DisplayCode AS IntervCode, 
    dbo.ICD_ProcFile10.UserDescription AS IntervCodeDesc, 
    dbo.ICD_ProcFile10.ShortDescription AS IntervCodeShortDesc, 
    dbo.ICD_IntervClinicianTitle.CCI_ClinicianTitle as IntervCodeClinicianTitle,
	IntervComments,
    
    dbo.AB_Intervention.IntervDate, dbo.AB_Intervention.IntervDateIn, dbo.AB_Intervention.IntervDateOut,    
    --PR - 04332
    LU_IntervTimeInUnknown.DisplayCode as IntervEpisodeStartTimeUnknown, LU_IntervTimeInUnknown.UserDescription as IntervEpisodeStartTimeUnknownDesc,
    LU_IntervTimeOutUnknown.DisplayCode as IntervEpisodeEndTimeUnknown, LU_IntervTimeOutUnknown.UserDescription as IntervEpisodeEndTimeUnknownDesc,
    LU_Flagged.DisplayCode AS IntervFlaggedCategory, LU_Flagged.UserDescription AS IntervFlaggedCategoryDesc, 

    dbo.ICD_ProcFile10.ICD9 AS IntervICD9Equivalent, dbo.ICD_ProcFile10.ICD9cm AS IntervICD9cmEquivalent, Lookup8.DisplayCode AS IntervLocation, 
    Lookup8.UserDescription AS IntervLocationDesc, dbo.AB_Intervention.IntervOccurrence, 
    LU_IntervPreAdmitFlag.DisplayCode AS IntervPreAdmitFlag, LU_IntervPreAdmitFlag.UserDescription AS IntervPreAdmitFlagDesc, 
    Lookup9.DisplayCode AS IntervProviderNumber, 
    Lookup9.UserDescription AS IntervProviderNumberDesc, 
	(case when Caretype <> 5 then Lookup15.DisplayCode else '''' end) AS IntervProviderService,     
	(case when Caretype <> 5 then Lookup15.UserDescription else '''' end) AS IntervProviderServiceDesc, 
	(case when Caretype = 5 then Lookup10.DisplayCode else '''' end) AS IntervProviderSpecialty,     
	(case when Caretype = 5 then Lookup10.UserDescription else '''' end) AS IntervProviderSpecialtyDesc, 
    dbo.AB_Intervention.IntervTimeIn, 
    dbo.AB_Intervention.IntervTimeMinutes AS IntervTimeinMinutes, dbo.AB_Intervention.IntervTimeOut, Lookup11.DisplayCode AS OOHIndicator, 
    Lookup11.UserDescription AS OOHIndicatorDesc, Lookup12.DisplayCode AS OOHInstitutionNumber, 
    Lookup12.UserDescription AS OOHInstitutionNumberDesc, dbo.LU_YesNoSystem.DisplayCode AS SurgicalCode, 
    dbo.AB_Intervention.IntervTripNumber AS ORTripNumber, dbo.LU_YesNoSystem.UserDescription AS SurgicalCodeDesc, 
    Lookup13.DisplayCode AS TissueCode, Lookup13.UserDescription AS TissueCodeDesc, Lookup13.DefaultDescription AS TissueCodeDesc_D, 
    Lookup14.DisplayCode AS UnplannedReturntoOR, Lookup14.UserDescription AS UnplannedReturntoORDesc, 
    dbo.LU_IntervSuffix.DisplayCode AS IntervSuffix, dbo.LU_IntervSuffix.UserDescription AS IntervSuffixDesc,
    dbo.AB_Intervention.ORURN,
    dbo.AB_Intervention.AbstractID AS zzAbstractLink
    
FROM          
	dbo.AB_Abstract with (nolock) inner join 
    dbo.AB_Intervention with (nolock) on AB_Intervention.AbstractID = AB_Abstract.AbstractID LEFT OUTER JOIN
    dbo.ICD_ProcFile10 with (nolock) on dbo.ICD_ProcFile10.Code = dbo.AB_Intervention.IntervCode LEFT OUTER JOIN
    dbo.ICD_IntervClinicianTitle with (nolock) on dbo.ICD_IntervClinicianTitle.CCICode = dbo.ICD_ProcFile10.CIHIValue left OUTER JOIN

    dbo.LU_YesNoSystem with (nolock) on dbo.LU_YesNoSystem.Code = dbo.ICD_ProcFile10.SurgicalCode left OUTER JOIN
    dbo.LU_IntervSuffix with (nolock) on dbo.AB_Intervention.IntervSuffix = dbo.LU_IntervSuffix.Code left join
    dbo.LU_AnaestTechnique AS Lookup1 with (nolock) on dbo.AB_Intervention.IntervAnaestTechnique = Lookup1.Code LEFT OUTER JOIN
    dbo.LU_Provider AS Lookup2 with (nolock) on dbo.AB_Intervention.IntervAnaestID = Lookup2.Code LEFT OUTER JOIN
    dbo.LU_IntervEUL AS Lookup3 with (nolock) on dbo.AB_Intervention.IntervEUL = Lookup3.Code LEFT OUTER JOIN
    dbo.LU_IntervExtra AS Lookup4 with (nolock) on dbo.AB_Intervention.IntervExtra = Lookup4.Code LEFT OUTER JOIN
    dbo.LU_IntervAttExtent AS Lookup5 with (nolock) on dbo.AB_Intervention.IntervAttribExtent = Lookup5.Code LEFT OUTER JOIN
    dbo.LU_IntervAttLocation AS Lookup6 with (nolock) on dbo.AB_Intervention.IntervAttribLocation = Lookup6.Code LEFT OUTER JOIN
    dbo.LU_IntervAttStatus AS Lookup7 with (nolock) on dbo.AB_Intervention.IntervAttribStatus = Lookup7.Code LEFT OUTER JOIN
    dbo.LU_IntervLocation_AI AS Lookup8 with (nolock) on dbo.AB_Intervention.IntervLocation = Lookup8.Code LEFT OUTER JOIN
    dbo.LU_Provider AS Lookup9 with (nolock) on dbo.AB_Intervention.IntervProviderNumber = Lookup9.Code LEFT OUTER JOIN
    dbo.LU_ProviderSpecialty AS Lookup10 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup10.Code LEFT OUTER JOIN
    dbo.LU_YesBlank AS Lookup11 with (nolock) on dbo.AB_Intervention.IntervOOHIndicator = Lookup11.Code LEFT OUTER JOIN
    dbo.LU_Institution_10 AS Lookup12 with (nolock) on dbo.AB_Intervention.IntervOOHInstitution = Lookup12.Code LEFT OUTER JOIN
    dbo.LU_IntervTissue AS Lookup13 with (nolock) on dbo.AB_Intervention.IntervTissueCode = Lookup13.Code LEFT OUTER JOIN
    dbo.LU_YesBlankAlpha AS Lookup14 with (nolock) on dbo.AB_Intervention.IntervUnplanReturn = Lookup14.Code LEFT OUTER JOIN
    dbo.LU_ProviderService AS Lookup15 with (nolock) on dbo.AB_Intervention.IntervProviderService = Lookup15.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_IntervPreAdmitFlag with (nolock) on dbo.AB_Intervention.IntervPreAdmitFlag = LU_IntervPreAdmitFlag.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_IntervTimeInUnknown with (nolock) on dbo.AB_Intervention.IntervTimeInUnknown = LU_IntervTimeInUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_IntervTimeOutUnknown with (nolock) on dbo.AB_Intervention.IntervTimeOutUnknown = LU_IntervTimeOutUnknown.Code LEFT OUTER JOIN
    dbo.LU_CodeFile AS LU_Flagged with (nolock) on dbo.AB_Intervention.FlaggedIntervention = LU_Flagged.Code LEFT OUTER JOIN
    LU_CJRR_RevisionReason with (nolock) on dbo.AB_Intervention.IntervRevisionReason = LU_CJRR_RevisionReason.Code

WHERE     (dbo.AB_Intervention.IntervICDType = ''T'')

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_ALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[I10_MB_ALC_VR]
AS 
SELECT     dbo.AB_MB_ALC.ALCDays, dbo.AB_MB_ALC.Occurrence AS ALCOccurrence, dbo.LU_CodeFile.DisplayCode AS ALCReasonCode, 
                      dbo.LU_CodeFile.UserDescription AS ALCReasonCodeDesc, dbo.AB_MB_ALC.DateDesignatedALC, dbo.AB_MB_ALC.DateReassignedAcute, 
                      dbo.AB_MB_ALC.AbstractID AS zzAbstractLink
FROM         dbo.AB_MB_ALC with (nolock) LEFT OUTER JOIN
                      dbo.LU_CodeFile with (nolock) ON dbo.AB_MB_ALC.ALCReasonCode = dbo.LU_CodeFile.Code

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_FacilityStudy_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[I10_MB_FacilityStudy_VR]
AS 
SELECT     FacilityDateStudy, FacilityStudyCode, Occurrence AS FacilityStudyOccurrence, AbstractID AS zzAbstractLink
FROM         dbo.AB_MB_FacilityStudy with (nolock)

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_NonALC_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[I10_MB_NonALC_VR]
AS 
SELECT     dbo.AB_MB_NonALC.DaysNonALCDelay, dbo.LU_CodeFile.DisplayCode AS NonALCDelayReason, 
                      dbo.LU_CodeFile.UserDescription AS NonALCDelayReasonDesc, dbo.AB_MB_NonALC.Occurrence AS NonALCOccurrence, 
                      dbo.AB_MB_NonALC.AbstractID AS zzAbstractLink
FROM         dbo.AB_MB_NonALC with (nolock) LEFT OUTER JOIN
                      dbo.LU_CodeFile with (nolock) ON dbo.AB_MB_NonALC.NonALCDelayReason = dbo.LU_CodeFile.Code










' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[I10_MB_ReproductiveNewborn_VR]') AND OBJECTPROPERTY(id, N'IsView') = 1)
EXEC dbo.sp_executesql @statement = N'CREATE  VIEW [dbo].[I10_MB_ReproductiveNewborn_VR]
AS
SELECT 
    --CIHI
    [CIHI Reproductive Information Section] = '''',
    dbo.AB_ReproductiveCare.PrevTermDelivery AS [#ofPreviousDeliveries], 
    dbo.AB_ReproductiveCare.PrevLiveBirths AS [#ofPreviousLiveBirths], 
    dbo.AB_ReproductiveCare.PrevPreTermDelivery AS [#ofPreviousPreTermDeliveries], 
    dbo.AB_ReproductiveCare.PrevSpontAbortions AS [#ofPrevSpontaneousAbortions], 
    dbo.AB_ReproductiveCare.PrevInduceAbortions AS [#ofPrevTherapueticAbortions], 
    dbo.AB_ReproductiveCare.GestationalAge AS GestationalAgeInWeeks,
    dbo.AB_Manitoba.DeclarationNumber, 
    dbo.AB_ReproductiveCare.DeliveryDate, dbo.AB_ReproductiveCare.DeliveryTime, 
    LU_DeliveryTimeUnknown.DisplayCode as DeliveryTimeUnknown, LU_DeliveryTimeUnknown.UserDescription as DeliveryTimeUnknownDesc, 
    dbo.AB_ReproductiveCare.LastMensesDate AS DateofLastMenses, 
    LU_BreastFeeding.DisplayCode AS BreastFeedingonDischarge, LU_BreastFeeding.UserDescription AS BreastFeedingonDischargeDesc, 
    LU_InitialOR.DisplayCode AS InitialOR, LU_InitialOR.UserDescription AS InitialORDesc,     
    LU_ReprodOR.DisplayCode AS SubsequentOR, LU_ReprodOR.UserDescription AS SubsequentORDesc, 
    LU_ReprodSterilization.DisplayCode AS Sterilization, LU_ReprodSterilization.UserDescription AS SterilizationDesc, 

    LU_Complication1.DisplayCode AS Complication1, LU_Complication1.UserDescription AS Complication1Desc, 
    LU_Complication2.DisplayCode AS Complication2, LU_Complication2.UserDescription AS Complication2Desc, 
    LU_Complication3.DisplayCode AS Complication3, LU_Complication3.UserDescription AS Complication3Desc, 
    dbo.AB_ReproductiveCare.ReprodComments AS ReproductiveCareComments,
    --New born
    [MB New born Information Section] = '''',
    LU_AbstractType.DisplayCode AS AbstractType, LU_AbstractType.UserDescription AS AbstractTypeDesc, 
    
    LU_Presentation.DisplayCode AS Presentation, LU_Presentation.UserDescription AS PresentationDesc, 
    LU_PositionDelviery.DisplayCode as PositionatDelivery, LU_PositionDelviery.UserDescription as PositionatDeliveryDesc, 
    LU_PresentDelivery.DisplayCode as PresentationAtDelivery, LU_PresentDelivery.UserDescription as PresentationAtDeliveryDesc, 
    LU_RoutineCare.DisplayCode AS RoutineCare,     LU_RoutineCare.UserDescription AS RoutineCareDesc, 
    LU_FreeFlowOxygen.DisplayCode AS FreeFlowOxygen, LU_FreeFlowOxygen.UserDescription AS FreeFlowOxygenDesc, 
    LU_BagVentilation.DisplayCode AS BagVentilation, LU_BagVentilation.UserDescription AS BagVentilationDesc, 
    LU_IntubationNotMeconium.DisplayCode AS IntubationNotMeconium, LU_IntubationNotMeconium.UserDescription AS IntubationNotMeconiumDesc, 
    LU_MedicationResuscitation.DisplayCode AS MedicationResuscitation, LU_MedicationResuscitation.UserDescription AS MedicationResuscitationDesc,
    LU_NarconMaloxone.DisplayCode AS NarconMaloxone, LU_NarconMaloxone.UserDescription AS NarconMaloxoneDesc, 
    LU_ChestCompressions.DisplayCode AS ChestCompressions, LU_ChestCompressions.UserDescription AS ChestCompressionsDesc, 
    LU_Feeding.DisplayCode AS Feeding, LU_Feeding.UserDescription AS FeedingDesc, 
    LU_Meconium.DisplayCode AS Meconium, LU_Meconium.UserDescription AS MeconiumDesc, 
    dbo.AB_Manitoba.Apgar1Min, dbo.AB_Manitoba.Apgar5Min, 
    dbo.AB_Manitoba.Gestation as GestationAge_MB, 
    dbo.AB_Manitoba.MotherPHIN, 
    dbo.AB_Abstract.Weight AS Weightingrams, 
    --Mother
    [Mother Information Section] = '''',
    LU_AlcoholDuringPregnancy.DisplayCode AS AlcoholDuringPregnancy, LU_AlcoholDuringPregnancy.UserDescription AS AlcoholDuringPregnancyDesc, 
    LU_AnestheticLabor.DisplayCode as AnalgesicAnestheticDuringLabor, LU_AnestheticLabor.UserDescription as AnalgesicAnestheticDuringLaborDesc,
    LU_Days_WeekAlcoholConsumed.DisplayCode AS Days_WeekAlcoholConsumed, LU_Days_WeekAlcoholConsumed.UserDescription AS Days_WeekAlcoholConsumedDesc,
    dbo.AB_Manitoba.DrinksPerday, 
    --LU_Elopements.DisplayCode AS Elopements, LU_Elopements.UserDescription AS ElopementsDesc, 
    dbo.AB_Manitoba.FirstStageDuration, 
    dbo.AB_Manitoba.Gravida, 
    --LU_LeaveCertificates.DisplayCode AS LeaveCertificates, LU_LeaveCertificates.UserDescription AS LeaveCertificatesDesc, 
    LU_MBEducation.DisplayCode AS MBEducation, LU_MBEducation.UserDescription AS MBEducationDesc, 
    (case when isnull(DischargeDate, AdmitDate) < ''2008/04/01'' then dbo.AB_Manitoba.NumberPrenatalVisits else dbo.AB_Manitoba.NumberPrenatal end) AS PrenatalVisitsNumber, 
    dbo.AB_Manitoba.Parity,
    LU_PostConceptionalFolicAcid.DisplayCode AS PostConcep