--Update H_InstitutionProfile set InstitutionType = '1' where CIHIValue = '55018'
--GO
--2.x-1598
declare @maxID int
declare @Province varchar(50)
set @Province = (select top 1 p.CIHIValue from h_hospitalprofile h inner join lu_province p on h.provincenumber = p.code)
if @province = '5'
begin
    if exists (select * from lu_institution_10 where cihivalue = '55018')
        update lu_institution_10 
        set InstCareType = 'A', 
            HospitalType = 'AT', 
            IsAcute = 1, 
            InstitutionType = '1'
        where cihivalue = '55018'
    else
    begin
        set @maxID = 91753
        if exists (select * from lu_institution_10 where code = @maxID)
        begin
            set @maxID = (select max(code) from lu_institution_10) + 1
            if @maxID < 500000
                set @maxID = 500001
        end
        insert into [dbo].[LU_Institution_10](Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, InstCareType, HospitalType, IsAcute, HospitalID, LUText, InstitutionType)
        values(@maxID, '55018', 'Southlake Reactivation Care Centre - Church', 'Southlake Reactivation Care Centre - Church', '55018', '2019/04/01', '2099/03/31', '55018', 'A', 'AT', 1, 0, '', '1')
    end
end
GO
If not exists (select * from [dbo].[LU_Institution_Type] where [InstitutionNumber] = '55018')
    insert into [dbo].[LU_Institution_Type](Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD)
    values('ON', '55018', '1', 'Acute inpatient care', 'Southlake Reactivation Care Centre - Church', 'Y')
GO
--2.x-1602 -   HAR (hospital account record) or BAN (billing account number) 
delete from u_fields where [FieldID] = 758
GO
Insert into [dbo].[U_Fields](FieldID, InHouseDesc, SystemName, PropertyName, FieldAccess, IsGroup)
values(758, 'Hospital Account Record', 'HospitalAccountRecord', 'HospitalAccountRecord', 0, 0)
GO
if not exists (select * from u_usersfields where userid = 1 and appid = 401 and fieldid = 758)
	Update U_UsersFields
	set SortOrder = a.SortOrder + 1
	from U_UsersFields a
		inner join (select * from u_Usersfields where fieldid = 756) b 
		on a.UserID = b.UserID and a.AppID = b.AppID and a.SortOrder > b.SortOrder
GO
if not exists (select * from u_usersfields where userid = 1 and appid = 401 and fieldid = 758)
begin
	insert into  [dbo].[U_UsersFields](AppID, RoleID, UserID, FieldID, SortOrder, GroupID, MultipleIndex, MandatoryStatus, Needed, FieldSize, DataType, SubAppID, LookUpTable, CIHI_ID, Header_CIHI_English, Header_CIHI_French, Header_CIHI_Spanish, Header_User, FieldEnabled, FieldVisible, DefaultValue, ParamProcID, ParamOrder, ParamName, ParamDataType, ParamSize, NeedForUserDef, MainDataType, UNoteCode)
	select AppID, RoleID, UserID, FieldID = 758, 
		SortOrder = SortOrder + 1, 
		GroupID, MultipleIndex, 
        MandatoryStatus, 
        Needed = 0, FieldSize = 50, 
		DataType = 2,  
        SubAppID = 0, LookUpTable = '', CIHI_ID = '', 
		Header_CIHI_English = 'Hospital Account Record', Header_CIHI_French = null, Header_CIHI_Spanish = null, 
		Header_User = 'Hospital Account Record', 
		FieldEnabled = 2,  
        FieldVisible = 2,  
        DefaultValue = null, 
		ParamProcID = ParamProcID, 
		ParamOrder = ParamOrder + (case when AppID in (100, 101, 102, 200, 201, 202, 301, 401) then 2 else 1 end), 
		ParamName = 'pHar', 
		ParamDataType = 200, ParamSize = 50, NeedForUserDef = 0, 
		MainDataType = null, UNoteCode = null
	from [dbo].[U_UsersFields]
	where  fieldid = 756
end
GO
if not exists (select * from information_schema.columns where table_name = 'AB_Abstract' and column_name = 'HospitalAccountRecord')
begin
    alter table AB_Abstract add HospitalAccountRecord varchar(50)
    alter table AB_Main add HospitalAccountRecord varchar(50)
    alter table CRS_Demographic add HospitalAccountRecord varchar(50)
    alter table OMHRS_SecAA add HospitalAccountRecord varchar(50)
    alter table RH_ClientInfo add HospitalAccountRecord varchar(50)
end
GO
--2.x-1619  New 2019
Update lu_diagnosisprefix 
set ValidTo = '2019/03/31' 
where (CIHIValue = 'I' and code = 13) or (CIHIValue = 'J' and code = 14)
GO
if exists (select * from information_schema.tables where table_name = 'zzDiagnosis2019')
    drop table zzDiagnosis2019
GO
create table zzDiagnosis2019(
    Code int identity(29, 1),
    userdescription varchar(100),
    CIHIValue varchar(10)
)
GO
Insert into zzDiagnosis2019(userdescription, CIHIValue) values('Total/Hemi-Arthroplasty', 'D')
GO
Insert into zzDiagnosis2019(userdescription, CIHIValue) values('Reverse Arthroplasty', 'K')
GO
declare @MaxID int
--Move the diagnosis code to other place
if exists (select * from lu_diagnosisprefix p inner join zzDiagnosis2019 z on p.code = z.code where p.cihivalue <> z.CIHIValue or p.DefaultDescription <> 'RCA - ' + z.UserDescription)
    and exists (select * from lu_diagnosisprefix where code = 9 and cihivalue = 'W' and defaultdescription = 'RCA - Left body impairment')
begin
    set @MaxID = (select max(code) from lu_diagnosisprefix)
    if isnull(@MaxID, 0) < 50000 set @MaxID = 500000
    Update lu_diagnosisprefix set code = code + @MaxID where code between 29 and 30
    Update AB_diagnosis set diagnosisprefix = diagnosisprefix + @MaxID where diagnosisprefix between 29 and 30
end
GO
if not exists (select * from lu_diagnosisprefix where code = 29)
    and exists (select * from lu_diagnosisprefix where code = 9 and cihivalue = 'W' and defaultdescription = 'RCA - Left body impairment')
    Insert into lu_diagnosisprefix(Code, DisplayCode, UserDescription, DefaultDescription, CIHIValue, ValidFrom, ValidTo, InterfaceIn, HospitalID, LUText)
    select Code, CIHIValue, 'RCA - ' + UserDescription, 'RCA - ' + UserDescription, CIHIValue, '2018/04/01', '2099/03/31', CIHIValue, 0, ''
    from zzDiagnosis2019
GO
if exists (select * from information_schema.tables where table_name = 'zzDiagnosis2019')
    drop table zzDiagnosis2019
GO
update H_HospitalProfile 
set CDKey = substring(CDKey, 1, 26) + 'N' + substring(CDKey, 28, 50)
from H_HospitalProfile
where len(isnull(CDKey, '')) >= 27
GO
update lu_project
set Question1 = '1st digit of Size of Largest Excised Polyp >= 3cm'
where code = 37 and cihivalue = '316' and Question1 = '1st digit of Size of Largest Excised Polyp = 3cm'
GO
update lu_project
set Question2 = '2nd digit of Size of Largest Excised Polyp >= 3cm'
where code = 37 and cihivalue = '316' and Question2 = '2nd digit of Size of Largest Excised Polyp = 3cm'
GO
--EMT update
if not exists (select * from INFORMATION_SCHEMA.columns where table_name = 'W3_Version' and COLUMN_NAME = 'Version')
    alter table W3_Version add Version varchar(16) null
go

update W3_Version set Version = '1.0'
go

if not exists (select * from INFORMATION_SCHEMA.tables where table_name = 'AUD_EMTOperation')
    exec('
       CREATE TABLE [dbo].[AUD_EMTOperation]
              ([AuditID]                 [uniqueidentifier] not null
              ,[EngineRuleType] [int] NULL
              ,[AppID]                   [int] null
              ,[RecordID]                [int] null
              ,[UserID]                  [int] null
              ,[Successful]        [int] null
              ,[Operation]         [int] null
              ,[OperationTime]     [datetime] null      
       )')
go

--2.x-1612
if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AB_EncoderLog]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
create table [dbo].[AB_EncoderLog] 
( 	[RecordID]		[int] null
	, [Occurrence]		[int] null
    , [UserID]			[int] null
	, [ModuleID]		[int] null
	, [EncoderType]		[int] null	--1=Folio, 2=3M
    , [StartTime]		[datetime] null 
    , [EndTime]			[datetime] null 
	, [TimeMinutes]		[int] null
	, [TimeSeconds]		[int] null
	, [Status]			[int] null --1=Completed, 2=Cancelled
) on [PRIMARY]
go
if not exists (select * from sysindexes where name = 'idx_AB_EncoderLog_RecordID' and id = object_id(N'[dbo].[AB_EncoderLog]'))
begin
    create index idx_AB_EncoderLog_RecordID on [dbo].[AB_EncoderLog] ( 	[RecordID])
    create index idx_AB_EncoderLog_UserID on [dbo].[AB_EncoderLog] ( 	UserID)
end
go
if exists (select * from information_schema.tables where table_name = 'zzInstType')
    drop table zzInstType
GO
create table zzInstType(
    Province varchar(10), 
    InstitutionNumber varchar(10), 
    InstitutionType varchar(10), 
    InstitutionTypeDescription varchar(100), 
    InstitutionName varchar(100), 
    SubmittingToDAD varchar(10)
)
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00004', '1', 'ACUTE INPT', 'WESTERN MEMORIAL REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00005', '1', 'ACUTE INPT', 'NOTRE DAME BAY MEMORIAL HEALTH CTR.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00007', '1', 'ACUTE INPT', 'BONAVISTA COMMUNITY HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00008', '1', 'ACUTE INPT', 'BONNE BAY HEALTH CARE CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00009', '1', 'ACUTE INPT', 'Dr. Y.K. JEON KITTIWAKE HEALTH CTR.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00010', '1', 'ACUTE INPT', 'CALDER HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00012', '1', 'ACUTE INPT', 'DR. CHARLES L. LEGROW HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00014', '1', 'ACUTE INPT', 'FOGO ISLAND HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00016', '1', 'ACUTE INPT', 'CONNAIGRE PENINSULA HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00018', '1', 'ACUTE INPT', 'DR. A. A. WILKINSON MEM. HEALTH CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00019', '1', 'ACUTE INPT', 'PLACENTIA HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00020', '1', 'ACUTE INPT', 'GREEN BAY HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00021', '1', 'ACUTE INPT', 'SIR THOMAS RODDICK HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00025', '1', 'ACUTE INPT', 'RUFUS GUINCHARD HEALTH CARE CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00026', '1', 'ACUTE INPT', 'THE CHARLES S. CURTIS MEM. HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00038', '1', 'ACUTE INPT', 'CENTRAL NEWFOUNDLAND REG. HLTH CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00039', '1', 'ACUTE INPT', 'A. M. GUY MEMORIAL HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00049', '1', 'ACUTE INPT', 'JAMES PATON MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00050', '1', 'ACUTE INPT', 'BAIE VERTE PENINSULA HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00053', '1', 'ACUTE INPT', 'DR. WALTER TEMPLEMAN COMM. HLTH CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00059', '1', 'ACUTE INPT', 'LABRADOR HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00060', '1', 'ACUTE INPT', 'CARBONEAR GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00064', '1', 'ACUTE INPT', 'DR. G. B. CROSS MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00065', '1', 'ACUTE INPT', 'BURIN PENINSULA HEALTH CARE CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00069', 'P', 'HOSPICE/PALTIV', 'DR. LEONARD A. MILLER CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00080', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-NU (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00081', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-PE (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00082', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-NS (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00083', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-NB (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00084', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-QC (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00085', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-ON (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00086', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-MB (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00087', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-SK (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00088', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-AB (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00089', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-BC (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00090', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-YK (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00091', '1', 'ACUTE INPT', 'GENERIC FACILITY NUMBER-NT (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00098', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-OUTSIDE CANADA (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00214', '1', 'ACUTE INPT', 'ST. CLARE''S MERCY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00215', '1', 'ACUTE INPT', 'HEALTH SCIENCES CENTRE ST. JOHN''S', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00216', '1', 'ACUTE INPT', 'WATERFORD HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '00217', '1', 'ACUTE INPT', 'LABRADOR WEST HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01004', 'A', 'DAY SURGERY', 'WESTERN MEMORIAL REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01012', 'A', 'DAY SURGERY', 'DR. CHARLES L. LEGROW HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01021', 'A', 'DAY SURGERY', 'SIR THOMAS RODDICK HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01026', 'A', 'DAY SURGERY', 'THE CHARLES S. CURTIS MEM. HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01038', 'A', 'DAY SURGERY', 'CENTRAL NEWFOUNDLAND REG. HLTH CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01049', 'A', 'DAY SURGERY', 'JAMES PATON MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01059', 'A', 'DAY SURGERY', 'LABRADOR HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01060', 'A', 'DAY SURGERY', 'CARBONEAR GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01064', 'A', 'DAY SURGERY', 'DR. G. B. CROSS MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01065', 'A', 'DAY SURGERY', 'BURIN PENINSULA HEALTH CARE CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01214', 'A', 'DAY SURGERY', 'ST. CLARE''S MERCY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01215', 'A', 'DAY SURGERY', 'HEALTH SCIENCES CENTREST. JOHNS', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01216', 'A', 'DAY SURGERY', 'WATERFORD HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '01217', 'A', 'DAY SURGERY', 'LABRADOR WEST HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02004', 'E', 'EMERGENCY DPT', 'WESTERN MEMORIAL REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02005', 'E', 'EMERGENCY DPT', 'NOTRE DAME BAY MEMORIAL HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02007', 'E', 'EMERGENCY DPT', 'BONAVISTA COMMUNITY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02008', 'E', 'EMERGENCY DPT', 'BONNE BAY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02009', 'E', 'EMERGENCY DPT', 'DR. Y.K. JEON KITTIWAKE HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02010', 'E', 'EMERGENCY DPT', 'CALDER HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02012', 'E', 'EMERGENCY DPT', 'DR. CHARLES L. LEGROW HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02014', 'E', 'EMERGENCY DPT', 'FOGO ISLAND HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02015', 'E', 'EMERGENCY DPT', 'DR. S. BECKLEY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02016', 'E', 'EMERGENCY DPT', 'CONNAIGRE PENINSULA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02018', 'E', 'EMERGENCY DPT', 'DR. A. A. WILKINSON MEM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02019', 'E', 'EMERGENCY DPT', 'PLACENTIA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02020', 'E', 'EMERGENCY DPT', 'GREEN BAY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02021', 'E', 'EMERGENCY DPT', 'SIR THOMAS RODDICK HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02022', 'E', 'EMERGENCY DPT', 'U.S. MEMORIAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02023', 'E', 'EMERGENCY DPT', 'DR. HUGH TWOMEY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02025', 'E', 'EMERGENCY DPT', 'RUFUS GUINCHARD HEALTH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02026', 'E', 'EMERGENCY DPT', 'THE CHARLES S. CURTIS MEM. HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02030', 'E', 'EMERGENCY DPT', 'WHITE BAY CENTRAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02031', 'E', 'EMERGENCY DPT', 'STRAIT OF BELLE ISLE HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02032', 'E', 'EMERGENCY DPT', 'LABRADOR SOUTH HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02038', 'E', 'EMERGENCY DPT', 'CENTRAL NEWFOUNDLAND REG. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02039', 'E', 'EMERGENCY DPT', 'A. M. GUY MEMORIAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02049', 'E', 'EMERGENCY DPT', 'JAMES PATON MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02050', 'E', 'EMERGENCY DPT', 'BAIE VERTE PENINSULA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02053', 'E', 'EMERGENCY DPT', 'DR. WALTER TEMPLEMAN COMM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02059', 'E', 'EMERGENCY DPT', 'LABRADOR HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02060', 'E', 'EMERGENCY DPT', 'CARBONEAR GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02064', 'E', 'EMERGENCY DPT', 'DR. G. B. CROSS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02065', 'E', 'EMERGENCY DPT', 'BURIN PENINSULA HEALTH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02115', 'E', 'EMERGENCY DPT', 'NORTH HAVEN MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02174', 'E', 'EMERGENCY DPT', 'DR. WM. H. NEWHOOK COMM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02182', 'E', 'EMERGENCY DPT', 'BAY D''ESPOIR COMMUNITY HEALTH CTR.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02214', 'E', 'EMERGENCY DPT', 'ST. CLARE''S MERCY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02215', 'E', 'EMERGENCY DPT', 'HEALTH SCIENCES CENTRE - ST JOHN''S', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02216', 'E', 'EMERGENCY DPT', 'WATERFORD HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '02217', 'E', 'EMERGENCY DPT', 'Labrador West Health Centre', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03005', '4', 'LT CARE', 'NOTRE DAME BAY MEMORIAL HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03008', '4', 'LT CARE', 'BONNE BAY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03010', '4', 'LT CARE', 'CALDER HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03012', '4', 'LT CARE', 'DR. CHARLES L. LEGROW HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03014', '4', 'LT CARE', 'FOGO ISLAND HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03016', '4', 'LT CARE', 'CONNAIGRE PENINSULA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03019', '4', 'LT CARE', 'PLACENTIA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03022', '4', 'LT CARE', 'U.S. MEMORIAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03023', '4', 'LT CARE', 'DR. HUGH TWOMEY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03025', '4', 'LT CARE', 'RUFUS GUINCHARD HEALTH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03026', '4', 'LT CARE', 'THE CHARLES S. CURTIS MEM. HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03032', '4', 'LT CARE', 'LABRADOR SOUTH HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03036', '4', 'LT CARE', 'ST. PATRICK''S MERCY HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03039', '4', 'LT CARE', 'A. M. GUY MEMORIAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03050', '4', 'LT CARE', 'BAIE VERTE PENINSULA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03053', '4', 'LT CARE', 'DR. WALTER TEMPLEMAN COMM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03054', '4', 'LT CARE', 'SAINT LUKE''S HOMES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03064', '4', 'LT CARE', 'DR. G. B. CROSS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03069', '4', 'LT CARE', 'DR. LEONARD A. MILLER CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03072', '4', 'LT CARE', 'GEN.FAC.NUM.UNCLASSIFIEDNURSINGHOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03100', '4', 'LT CARE', 'THE AGNES PRATT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03101', '4', 'LT CARE', 'BAY ST. GEORGE LONG TERM CARE CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03102', '4', 'LT CARE', 'BLUE CREST INTERFAITH HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03103', '4', 'LT CARE', 'BONNEWS LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03105', '4', 'LT CARE', 'CARMELITE HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03108', '4', 'LT CARE', 'THE SALVATION ARMY GLENBROOK LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03110', '4', 'LT CARE', 'HAPPY VALLEY GOOSE BAY LTC HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03112', '4', 'LT CARE', 'LAKESIDE HOMES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03115', '4', 'LT CARE', 'NORTH HAVEN MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03117', '4', 'LT CARE', 'JOHN M. GRAY CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03197', 'G', 'GROUP/SUPPORT', 'GEN. FAC. NUM.-COMMUNITY CARE HOMES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03198', 'G', 'GROUP/SUPPORT', 'GEN. FAC. NUM. - FAMILY CARE HOMES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03199', 'G', 'GROUP/SUPPORT', 'GEN. FAC. NUM.-PERSONAL CARE HOMES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03200', '4', 'LT CARE', 'DR. ALBERT O''MAHONY MEMORIAL MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03201', '4', 'LT CARE', 'VALLEY VISTA SENIOR CITIZEN COMPLEX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03202', '4', 'LT CARE', 'GOLDEN HEIGHTS MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03204', '4', 'LT CARE', 'LIONS MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03206', '4', 'LT CARE', 'CORNER BROOK LONG TERM CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03207', '4', 'LT CARE', 'PLEASANT VIEW TOWERS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03208', '4', 'LT CARE', 'CORNER BROOK PROTECTIVE COMM RESID', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03209', '4', 'LT CARE', 'LEWISPORTE PROTECTIVE COMM. RESID.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03210', '4', 'LT CARE', 'PTE. JOSIAH SQUIBB MEM. PAVILLION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03211', '4', 'LT CARE', 'BONAVISTA PROTECTIVE COMMUNITY RES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03216', '3', 'INPT CCC', 'WATERFORD HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03217', '4', 'LT CARE', 'LABRADOR WEST HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03219', '4', 'LT CARE', 'CLARENVILLE PROTECTIVE COMM. RES.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03220', 'C', 'CORRECTIONAL', 'GEN. FAC. NUM-CORRECTIONAL FACILITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03221', 'G', 'GROUP/SUPPORT', 'GFN-GROUP LIVING/SUPPORTIVE HOUSING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03222', 'H', 'TRANSIT HOUSE', 'GEN.FAC.NUM.-TRANSITIONAL HOUSING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03242', 'G', 'GROUP/SUPPORT', 'ACADIAN VILLAGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03243', 'G', 'GROUP/SUPPORT', 'ADMIRAL''S COAST RETIREMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03244', 'G', 'GROUP/SUPPORT', 'ALDERWOOD ESTATES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03245', 'G', 'GROUP/SUPPORT', 'BACCALIEU RETIREMENT LIVING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03246', 'G', 'GROUP/SUPPORT', 'BARTON''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03247', 'G', 'GROUP/SUPPORT', 'BAY ROBERT''S RETIREMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03248', 'G', 'GROUP/SUPPORT', 'BAYSHORE ESTATES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03249', 'G', 'GROUP/SUPPORT', 'BAYVIEW HEIGHTS MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03250', 'G', 'GROUP/SUPPORT', 'BEACHSIDE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03251', 'G', 'GROUP/SUPPORT', 'BLOW ME DOWN RETIREMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03252', 'G', 'GROUP/SUPPORT', 'BONAVENTURE RETIREMENT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03253', 'G', 'GROUP/SUPPORT', 'BONAVISTA RETIREMENT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03254', 'G', 'GROUP/SUPPORT', 'BRAKE''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03255', 'G', 'GROUP/SUPPORT', 'CALLINGWOOD DOWNS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03256', 'G', 'GROUP/SUPPORT', 'CAMBRIDGE ESTATES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03257', 'G', 'GROUP/SUPPORT', 'CANNING''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03258', 'G', 'GROUP/SUPPORT', 'CARMANVILLE TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03259', 'G', 'GROUP/SUPPORT', 'CLARENVILLE RETIREMENT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03260', 'G', 'GROUP/SUPPORT', 'COZY QUARTERS PCH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03261', 'G', 'GROUP/SUPPORT', 'CRADEA MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03262', 'G', 'GROUP/SUPPORT', 'CROSSWINDS SENIORS RESORT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03263', 'G', 'GROUP/SUPPORT', 'DEER LAKE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03264', 'G', 'GROUP/SUPPORT', 'EASON''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03265', 'G', 'GROUP/SUPPORT', 'FAHEY''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03266', 'G', 'GROUP/SUPPORT', 'GANDER BAY RETIREMENT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03267', 'G', 'GROUP/SUPPORT', 'GATEWAY RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03268', 'G', 'GROUP/SUPPORT', 'GOLDEN YEARS ESTATES - GANDER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03269', 'G', 'GROUP/SUPPORT', 'GOLDEN YEARS ESTATES - GRAND FALLS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03270', 'G', 'GROUP/SUPPORT', 'GRAND BANK RETIREMENT LIVING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03271', 'G', 'GROUP/SUPPORT', 'GREEN BAY RETIREMENT LIVING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03272', 'G', 'GROUP/SUPPORT', 'GREENWOOD REST HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03273', 'G', 'GROUP/SUPPORT', 'HARBOURVIEW MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03274', 'G', 'GROUP/SUPPORT', 'HILLCREST ESTATE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03275', 'G', 'GROUP/SUPPORT', 'HILLCREST MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03276', 'G', 'GROUP/SUPPORT', 'HILLTOP MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03277', 'G', 'GROUP/SUPPORT', 'HOLLETT''S RETIREMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03278', 'G', 'GROUP/SUPPORT', 'ISLANDSIDE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03279', 'G', 'GROUP/SUPPORT', 'IVY DURLEY PLACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03280', 'G', 'GROUP/SUPPORT', 'KARWOOD RETIREMENT RETREAT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03281', 'G', 'GROUP/SUPPORT', 'KATHERINE HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03282', 'G', 'GROUP/SUPPORT', 'KELLY''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03283', 'G', 'GROUP/SUPPORT', 'KILLICK RETIREMENT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03284', 'G', 'GROUP/SUPPORT', 'LEWIS'' PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03285', 'G', 'GROUP/SUPPORT', 'LINDA''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03286', 'G', 'GROUP/SUPPORT', 'LOHNES COMPLEX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03287', 'G', 'GROUP/SUPPORT', 'LUXURY ESTATES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03288', 'G', 'GROUP/SUPPORT', 'MAIN RIVER RETIREMENT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03289', 'G', 'GROUP/SUPPORT', 'MARYSTOWN RETIREMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03290', 'G', 'GROUP/SUPPORT', 'MEADOW CREEK RETIREMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03291', 'G', 'GROUP/SUPPORT', 'MIRAQUINN HILLTOP MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03292', 'G', 'GROUP/SUPPORT', 'MJ PCH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03293', 'G', 'GROUP/SUPPORT', 'MOUNT MARGARET MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03294', 'G', 'GROUP/SUPPORT', 'MOUNTAIN HOPE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03295', 'G', 'GROUP/SUPPORT', 'MOUNTAIN VIEW RETIREMENT CENTER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03296', 'G', 'GROUP/SUPPORT', 'MOUNTAINVIEW HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03297', 'G', 'GROUP/SUPPORT', 'MURPHY''S SHADY REST LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03298', 'G', 'GROUP/SUPPORT', 'NIGHTINGALE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03299', 'G', 'GROUP/SUPPORT', 'NORTH POND MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03300', 'G', 'GROUP/SUPPORT', 'NORTHERN RETIREMENT HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03301', 'G', 'GROUP/SUPPORT', 'OCEAN VIEW GUEST HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03302', 'G', 'GROUP/SUPPORT', 'OCEANSIDE HOME CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03303', 'G', 'GROUP/SUPPORT', 'ORAM''S BAYWATCH MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03304', 'G', 'GROUP/SUPPORT', 'ORAM''S BIRCHVIEW MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03305', 'G', 'GROUP/SUPPORT', 'ORAM''S EMMANUEL MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03306', 'G', 'GROUP/SUPPORT', 'OTTERBURY MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03307', 'G', 'GROUP/SUPPORT', 'PEARL HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03308', 'G', 'GROUP/SUPPORT', 'PLEASANTVIEW MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03309', 'G', 'GROUP/SUPPORT', 'RIVERHEAD MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03310', 'G', 'GROUP/SUPPORT', 'ROBINSON''S PERSONAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03311', 'G', 'GROUP/SUPPORT', 'RODDICKTON HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03312', 'G', 'GROUP/SUPPORT', 'RUBY MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03313', 'G', 'GROUP/SUPPORT', 'SHAG ROCK MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03314', 'G', 'GROUP/SUPPORT', 'SHIRLEY''S HAVEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03315', 'G', 'GROUP/SUPPORT', 'SHIRLEY''S HAVEN #2', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03316', 'G', 'GROUP/SUPPORT', 'SIVERWOOD MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03317', 'G', 'GROUP/SUPPORT', 'SPRINGDALE RETIREMENT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03318', 'G', 'GROUP/SUPPORT', 'SUNSET MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03319', 'G', 'GROUP/SUPPORT', 'TOBIN''S GUEST HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03320', 'G', 'GROUP/SUPPORT', 'TWILIGHT MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03321', 'G', 'GROUP/SUPPORT', 'TWIN TOWN MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03322', 'G', 'GROUP/SUPPORT', 'WHITE''S FAMILY CARE RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03323', 'G', 'GROUP/SUPPORT', 'WINTER HOLME MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03324', 'G', 'GROUP/SUPPORT', 'WOODFORD''S COMFORT MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03325', 'G', 'GROUP/SUPPORT', 'XAVIER HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03331', 'G', 'GROUP/SUPPORT', 'CHANCELLOR PARK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '03332', 'G', 'GROUP/SUPPORT', 'HERITAGE SQUARE RETIREMENT LIVING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05004', 'N', 'AMBULATORY CAR', 'WESTERN MEMORIAL REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05005', 'N', 'AMBULATORY CAR', 'NOTRE DAME BAY MEMORIAL HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05007', 'N', 'AMBULATORY CAR', 'BONAVISTA COMMUNITY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05008', 'N', 'AMBULATORY CAR', 'BONNE BAY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05009', 'N', 'AMBULATORY CAR', 'DR. Y.K. JEON KITTIWAKE HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05010', 'N', 'AMBULATORY CAR', 'CALDER HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05012', 'N', 'AMBULATORY CAR', 'DR. CHARLES L. LEGROW HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05014', 'N', 'AMBULATORY CAR', 'FOGO ISLAND HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05015', 'N', 'AMBULATORY CAR', 'DR. S. BECKLEY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05016', 'N', 'AMBULATORY CAR', 'CONNAIGRE PENINSULA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05018', 'N', 'AMBULATORY CAR', 'DR. A. A. WILKINSON MEM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05019', 'N', 'AMBULATORY CAR', 'PLACENTIA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05020', 'N', 'AMBULATORY CAR', 'GREEN BAY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05021', 'N', 'AMBULATORY CAR', 'SIR THOMAS RODDICK HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05025', 'N', 'AMBULATORY CAR', 'RUFUS GUINCHARD HEALTH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05026', 'N', 'AMBULATORY CAR', 'THE CHARLES S. CURTIS MEM. HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05027', '0', 'COMMUNITY CLIN', 'CARTWRIGHT COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05028', '0', 'COMMUNITY CLIN', 'MANI ASHINI HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05030', 'N', 'AMBULATORY CAR', 'WHITE BAY CENTRAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05031', 'N', 'AMBULATORY CAR', 'STRAIT OF BELLE ISLE HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05032', 'N', 'AMBULATORY CAR', 'LABRADOR SOUTH HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05033', '0', 'COMMUNITY CLIN', 'MARY''S HARBOUR COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05035', '0', 'COMMUNITY CLIN', 'NAIN COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05038', 'N', 'AMBULATORY CAR', 'CENTRAL NEWFOUNDLAND REG. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05039', 'N', 'AMBULATORY CAR', 'A. M. GUY MEMORIAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05045', '0', 'COMMUNITY CLIN', 'HOPEDALE COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05047', '0', 'COMMUNITY CLIN', 'MAKKOVIK COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05049', 'N', 'AMBULATORY CAR', 'JAMES PATON MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05050', 'N', 'AMBULATORY CAR', 'BAIE VERTE PENINSULA HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05053', 'N', 'AMBULATORY CAR', 'DR. WALTER TEMPLEMAN COMM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05057', 'N', 'AMBULATORY CAR', 'CHURCHILL FALLS COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05059', 'N', 'AMBULATORY CAR', 'LABRADOR HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05060', 'N', 'AMBULATORY CAR', 'CARBONEAR GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05064', 'N', 'AMBULATORY CAR', 'DR. G. B. CROSS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05065', 'N', 'AMBULATORY CAR', 'BURIN PENINSULA HEALTH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05066', '0', 'COMMUNITY CLIN', 'GROSSWATER BAY COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05067', '0', 'COMMUNITY CLIN', 'BLACK TICKLE COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05074', '8', 'HOME CARE', 'HOME CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05079', 'U', 'UNKNOWN', 'GENFACNUMUNKNOWNNLHLTHCLINIC/AGENCY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05084', 'N', 'AMBULATORY CAR', 'GEN. FAC. NUM. - QUEBEC (NON-ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05092', '0', 'COMMUNITY CLIN', 'ST. LEWIS COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05093', '0', 'COMMUNITY CLIN', 'POSTVILLE COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05094', '0', 'COMMUNITY CLIN', 'CHARLOTTETOWN COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05096', '0', 'COMMUNITY CLIN', 'NATUASHISH COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05097', '0', 'COMMUNITY CLIN', 'PORT HOPE SIMPSON COMMUNITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05151', '0', 'COMMUNITY CLIN', 'CARMANVILLE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05152', '0', 'COMMUNITY CLIN', 'CENTREVILLE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05153', '0', 'COMMUNITY CLIN', 'CODROY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05154', '0', 'COMMUNITY CLIN', 'COW HEAD CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05155', '0', 'COMMUNITY CLIN', 'DANIEL''S HARBOUR CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05156', '0', 'COMMUNITY CLIN', 'DEGRAS CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05157', '0', 'COMMUNITY CLIN', 'EASTPORT CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05158', '0', 'COMMUNITY CLIN', 'FRANCOIS CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05159', '0', 'COMMUNITY CLIN', 'GAMBO CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05160', '0', 'COMMUNITY CLIN', 'GANDER BAY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05161', '0', 'COMMUNITY CLIN', 'GLOVERTOWN CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05164', '0', 'COMMUNITY CLIN', 'GREY RIVER CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05166', '0', 'COMMUNITY CLIN', 'HARE BAY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05167', '0', 'COMMUNITY CLIN', 'HERMITAGE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05168', '0', 'COMMUNITY CLIN', 'JEFFREY''S CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05169', '0', 'COMMUNITY CLIN', 'LASCIE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05170', '0', 'COMMUNITY CLIN', 'LEWISPORTE HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05171', '0', 'COMMUNITY CLIN', 'LOURDES CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05172', '0', 'COMMUNITY CLIN', 'MOSE AMBROSE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05173', '0', 'COMMUNITY CLIN', 'MUSGRAVE HARBOUR CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05174', 'N', 'AMBULATORY CAR', 'DR. WM. H. NEWHOOK COMM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05175', '0', 'COMMUNITY CLIN', 'PARKERS COVE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05176', '0', 'COMMUNITY CLIN', 'PARSON''S POND CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05177', '0', 'COMMUNITY CLIN', 'PETITE FORTE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05178', '0', 'COMMUNITY CLIN', 'PETITES AND LA POILE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05179', '0', 'COMMUNITY CLIN', 'RAMEA CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05180', '0', 'COMMUNITY CLIN', 'ROSE BLANCHE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05181', '0', 'COMMUNITY CLIN', 'SOUTHEAST BIGHT CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05182', '0', 'COMMUNITY CLIN', 'BAY D''ESPOIR CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05183', '0', 'COMMUNITY CLIN', 'ST. BRENDAN''S CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05184', '0', 'COMMUNITY CLIN', 'ST. GEORGE''S CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05185', '0', 'COMMUNITY CLIN', 'STEPHENVILLE CROSSING CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05186', '0', 'COMMUNITY CLIN', 'VIRGIN ARM CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05189', '0', 'COMMUNITY CLIN', 'WOODY POINT CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05191', '0', 'COMMUNITY CLIN', 'TRINITY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05214', 'N', 'AMBULATORY CAR', 'ST. CLARE''S MERCY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05215', 'N', 'AMBULATORY CAR', 'HEALTH SCIENCES CENTRE ST. JOHN''S', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05216', 'N', 'AMBULATORY CAR', 'WATERFORD HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05217', 'N', 'AMBULATORY CAR', 'Labrador West Health Centre', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05223', '0', 'COMMUNITY CLIN', 'BAY ST. GEORGE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05224', '0', 'COMMUNITY CLIN', 'PLACENTIA WEST MEDICAL CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05225', '0', 'COMMUNITY CLIN', 'CHANGE ISLAND CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05226', '0', 'COMMUNITY CLIN', 'DEER LAKE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05227', '0', 'COMMUNITY CLIN', 'FERRYLAND CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05228', '0', 'COMMUNITY CLIN', 'HAMPDEN CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05229', '0', 'COMMUNITY CLIN', 'JACKSON''S ARM CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05230', '0', 'COMMUNITY CLIN', 'MCCALLUM CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05231', '0', 'COMMUNITY CLIN', 'MOUNT CARMEL CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05232', '0', 'COMMUNITY CLIN', 'RENCONTRE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05233', '0', 'COMMUNITY CLIN', 'SHEA HEIGHTS CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05234', '0', 'COMMUNITY CLIN', 'SOPS ARM CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05235', '0', 'COMMUNITY CLIN', 'ST. MARY''S CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05236', '0', 'COMMUNITY CLIN', 'TERRENCEVILLE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05237', '0', 'COMMUNITY CLIN', 'TROUT RIVER CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05238', '0', 'COMMUNITY CLIN', 'WESTERN MEMORIAL HEALTH CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05239', 'M', 'COMM MH ADDICT', 'GENERIC-COMMBASEDMENTALHLTH&ADDICT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05240', '0', 'COMMUNITY CLIN', 'GENERIC - COMMUNITY BASED SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05241', 'J', 'OTH NON-HEALTH', 'GENERIC - NON-HEALTH FAC./SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05326', '0', 'COMMUNITY CLIN', 'CHOICES FOR YOUTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05327', '0', 'COMMUNITY CLIN', 'GATHERING PLACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05328', '0', 'COMMUNITY CLIN', 'NEW HOPE CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05329', '0', 'COMMUNITY CLIN', 'SHOP (SAFE HARBOUR OUTREACH PRGRM)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '05330', '0', 'COMMUNITY CLIN', 'COISH PLACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '06203', 'T', 'MH/ADDICT RX', 'HUMBERWOOD CENTRE(RESIDENTIAL CARE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '06205', 'T', 'MH/ADDICT RX', 'RECOVERY CENTRE (RESIDENTIAL CARE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '06212', 'T', 'MH/ADDICT RX', 'HOPE VALLEY CTR (RESIDENTIAL CARE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '06213', 'T', 'MH/ADDICT RX', 'TUCKAMORE CENTRE (RESIDENTIAL CARE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '06218', 'T', 'MH/ADDICT RX', 'THE GRACE CENTRE (RESIDENTIAL CARE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '08069', '2', 'INPT REHAB', 'DR. LEONARD A. MILLER CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '08206', '2', 'INPT REHAB', 'CORNER BROOK LONG TERM CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NL', '09215', 'N', 'AMBULATORY CAR', 'HEALTH SCIENCE CENTRE - ST.JOHN''S', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '10001', '1', 'ACUTE INPT', 'QUEEN ELIZABETH HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '10003', '1', 'ACUTE INPT', 'PRINCE COUNTY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '10004', '1', 'ACUTE INPT', 'WESTERN HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '10005', '1', 'ACUTE INPT', 'KINGS COUNTY MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '10006', '1', 'ACUTE INPT', 'COMMUNITY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '10007', '1', 'ACUTE INPT', 'SOURIS HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '12015', '2', 'INPT REHAB', 'PRINCE EDWARD HOME RESTORATIVE CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14008', '4', 'LT CARE', 'STEWART MEMORIAL HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14014', '4', 'LT CARE', 'BEACH GROVE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14015', '4', 'LT CARE', 'PRINCE EDWARD HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14016', '4', 'LT CARE', 'WEDGEWOOD MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14017', '4', 'LT CARE', 'SUMMERSET MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14018', '4', 'LT CARE', 'MAPLEWOOD MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14019', '4', 'LT CARE', 'COLVILLE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14020', '4', 'LT CARE', 'RIVERVIEW MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14021', '4', 'LT CARE', 'GARDEN HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14022', '4', 'LT CARE', 'WHISPERWOOD VILLA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14025', '4', 'LT CARE', 'ATLANTIC BAPTIST NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14028', '4', 'LT CARE', 'CLINTON VIEW LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14029', '4', 'LT CARE', 'DR. JOHN GILLIS MEMORIAL LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14030', '4', 'LT CARE', 'SOUTH SHORE VILLA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14031', '4', 'LT CARE', 'SHERWOOD HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14035', 'G', 'GROUP/SUPPORT', 'GENERIC NUMBER - COMMUNITY CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14036', '4', 'LT CARE', 'MARGARET STEWART ELLIS HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14156', '4', 'LT CARE', 'ANDREW''S LODGE CHARLOTTETOWN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14170', '4', 'LT CARE', 'ANDREW''S LODGE SUMMERSIDE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14189', '4', 'LT CARE', 'ANDREW''S OF STRATFORD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14190', '4', 'LT CARE', 'PARK WEST LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '14998', '4', 'LT CARE', 'THE MOUNT CONTINUING CARE COMMUNITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15002', '5', 'INPT MENTAL', 'HILLSBOROUGH HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15003', 'M', 'COMM MH ADDICT', 'PCH COMMUNITY MENTAL HEALTH & ADDIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15007', 'M', 'COMM MH ADDICT', 'SOURIS HOSPITAL MENTAL HEALTH SERV.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15011', 'T', 'MH/ADDICT RX', 'PROVINCIAL ADDICTIONS TREATMENT FAC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15933', 'T', 'MH/ADDICT RX', 'LACEY HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15934', 'T', 'MH/ADDICT RX', 'TALBOT HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15935', 'T', 'MH/ADDICT RX', 'ST. ELEANORS HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15936', 'T', 'MH/ADDICT RX', 'DEACON HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15937', 'T', 'MH/ADDICT RX', 'YOUTH RECOVERY CTR-STRENGTH PROGRAM', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15938', 'T', 'MH/ADDICT RX', 'LENNON HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15941', 'M', 'COMM MH ADDICT', 'MCGILL COMMUNITY MENTAL HEALTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15942', 'M', 'COMM MH ADDICT', 'RICHMOND CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15944', 'M', 'COMM MH ADDICT', 'ALBERTON MENTAL HEALTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15945', 'M', 'COMM MH ADDICT', 'O''LEARY MENTAL HEALTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '15946', 'T', 'MH/ADDICT RX', 'MONTAGUE MENTAL HEALTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16009', 'P', 'HOSPICE/PALTIV', 'PROV. PALLTIV. CARE CTR-HOSPICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16032', 'C', 'CORRECTIONAL', 'PROVINCIAL CORRECTIONAL CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16033', 'C', 'CORRECTIONAL', 'PRINCE COUNTY CORRECTIONAL CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16034', 'C', 'CORRECTIONAL', 'PEI YOUTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16939', '8', 'HOME CARE', 'GENERIC NUMBER - HOME CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16940', '8', 'HOME CARE', 'INTEGRATED PALLIATIVE CARE PROGRAM', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16948', 'G', 'GROUP/SUPPORT', 'GENERIC NUMBER - GROUP HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '16950', 'G', 'GROUP/SUPPORT', 'ANDERSON HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '17001', 'N', 'AMBULATORY CAR', 'QUEEN ELIZABETH HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '17003', 'N', 'AMBULATORY CAR', 'PRINCE COUNTY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '17004', 'N', 'AMBULATORY CAR', 'WESTERN HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '17005', 'N', 'AMBULATORY CAR', 'KINGS COUNTY MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '17006', 'N', 'AMBULATORY CAR', 'COMMUNITY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '17007', 'N', 'AMBULATORY CAR', 'SOURIS HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18051', '1', 'ACUTE INPT', 'OOP, MONCTON HOSPITAL, ACUTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18052', '1', 'ACUTE INPT', 'OOP, DR. GEORGE-L. -DUMONT, ACUTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18053', '1', 'ACUTE INPT', 'OOP, ST. JOHN REGIONAL HOSP, ACUTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18103', 'A', 'DAY SURGERY', 'OOP, IWK HEALTH CENTRE, DAY SURGERY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18114', 'A', 'DAY SURGERY', 'OOP, QELL HEALTH SCIENCES CTR, DS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18151', 'A', 'DAY SURGERY', 'OOP, MONCTON HOSPITAL, DAY SURGERY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18152', 'A', 'DAY SURGERY', 'OOP, DR. GEORGE-L. -DUMONT, DS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18153', 'A', 'DAY SURGERY', 'OOP, ST. JOHN REGIONAL HOSPITAL, DS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18203', '1', 'ACUTE INPT', 'OOP, IWK HEALTH CENTRE, ACUTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18214', '1', 'ACUTE INPT', 'OOP, QELL HEALTH SCIENCES CTR,ACUTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18910', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-CANADA(ACUTE FACILITY)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18911', '1', 'ACUTE INPT', 'GEN.FAC.NUM-UNITEDSTATES(ACUTE FAC)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18916', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), NS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18917', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), NB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18918', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), NL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18919', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), ON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18920', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), MB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18921', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), SK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18922', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), AB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18923', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), BC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18924', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), QC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18925', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), NT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18926', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), NU', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18927', '1', 'ACUTE INPT', 'OUT-OF-PROVINCE (ACUTE), YK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18928', '2', 'INPT REHAB', 'OOP(REHAB)STANCASSIDYCTRFORREHAB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18929', '5', 'INPT MENTAL', 'OOP,(INPATIENT MENTAL HLTH),PORTAGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18930', '5', 'INPT MENTAL', 'OOP,INPATMENTALHLTH,PEELCHILDREN''S', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18931', '5', 'INPT MENTAL', 'OOP,INPATIENTMENTALHLTHHOMEWOODHLTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '18932', '5', 'INPT MENTAL', 'OOPINPATIENTMENTALHLTHBELLWOODHLTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('PE', '19009', '1', 'ACUTE INPT', 'PROVINCIAL PALLIATIVE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20002', '1', 'ACUTE INPT', 'OOP/OOC ACUTE INPATIENT CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20011', '1', 'ACUTE INPT', 'ABERDEEN HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20012', '1', 'ACUTE INPT', 'ALL SAINT''S SPRINGHILL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20013', '1', 'ACUTE INPT', 'ANNAPOLIS COMMUNITY HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20014', '1', 'ACUTE INPT', 'SOUTH SHORE REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20015', '1', 'ACUTE INPT', 'BUCHANAN MEMORIAL COMM. HLTH CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20018', '1', 'ACUTE INPT', 'COLCHESTER EAST HANTS HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20020', '1', 'ACUTE INPT', 'DIGBY GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20022', '1', 'ACUTE INPT', 'EASTERN MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20023', '1', 'ACUTE INPT', 'EASTERN SHORE MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20027', '1', 'ACUTE INPT', 'GUYSBOROUGH MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20030', '1', 'ACUTE INPT', 'CUMBERLAND REGIONAL HEALTH CARE CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20032', '1', 'ACUTE INPT', 'LILLIAN FRASER MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20033', '1', 'ACUTE INPT', 'MUSQUODOBOIT VALLEY MEMORIAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20034', '1', 'ACUTE INPT', 'INVERNESS CONSOLIDATED MEM. HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20035', '1', 'ACUTE INPT', 'NORTH CUMBERLAND MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20037', '1', 'ACUTE INPT', 'HANTS COMMUNITY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20038', '1', 'ACUTE INPT', 'QUEEN''S GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20039', '1', 'ACUTE INPT', 'ROSEWAY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20043', '1', 'ACUTE INPT', 'ST. MARTHA''S REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20045', '1', 'ACUTE INPT', 'ST. MARY''S MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20047', '1', 'ACUTE INPT', 'SACRED HEART COMMUNITY HEALTH CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20048', '1', 'ACUTE INPT', 'SOLDIERS'' MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20049', '1', 'ACUTE INPT', 'SOUTH CUMBERLAND COMM. CARE CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20052', '1', 'ACUTE INPT', 'TWIN OAKS MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20053', '1', 'ACUTE INPT', 'VICTORIA COUNTY MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20056', '1', 'ACUTE INPT', 'YARMOUTH REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20058', '3', 'INPT CCC', 'BAYVIEW MEMORIAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20065', '1', 'ACUTE INPT', 'DARTMOUTH GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20067', '1', 'ACUTE INPT', 'VALLEY REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20068', '1', 'ACUTE INPT', 'STRAIT RICHMOND HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20077', '1', 'ACUTE INPT', 'NOVA SCOTIA HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20085', '1', 'ACUTE INPT', 'QUEEN ELIZABETH II HEALTH SC. CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20086', '1', 'ACUTE INPT', 'IWK HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20087', '1', 'ACUTE INPT', 'CAPE BRETON HEALTH CARE COMPLEX', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '20114', '1', 'ACUTE INPT', 'FISHERMEN''S MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '22071', '5', 'INPT MENTAL', 'EAST COAST FORENSIC HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '22086', '5', 'INPT MENTAL', 'IWK HLTH CNTR - SECURE CARE UNIT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '23077', '5', 'INPT MENTAL', 'MEMORY LANE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '24012', '2', 'INPT REHAB', 'ALL SAINT''S SPRINGHILL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '24043', '2', 'INPT REHAB', 'ST. MARTHA''S REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '24050', '2', 'INPT REHAB', 'SUTHERLAND HARRIS MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '24085', '2', 'INPT REHAB', 'QUEEN ELIZABETH II HEALTH SC. CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '24087', '3', 'INPT CCC', 'CAPE BRETON HEALTH CARE COMPLEX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '24114', '2', 'INPT REHAB', 'FISHERMEN''S MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25043', '4', 'LT CARE', 'ST. MARTHA''S REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25048', '4', 'LT CARE', 'SOLDIERS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25050', '4', 'LT CARE', 'SUTHERLAND HARRIS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25056', '4', 'LT CARE', 'YARMOUTH REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25058', '4', 'LT CARE', 'BAYVIEW MEMORIAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25085', '4', 'LT CARE', 'QUEEN ELIZABETH II HEALTH SC. CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25087', '4', 'LT CARE', 'CAPE BRETON HEALTH CARE COMPLEX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '25114', '4', 'LT CARE', 'FISHERMEN''S MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29002', 'U', 'UNKNOWN', 'OOP/OOC NON-ACUTE INSTITUTION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29003', '4', 'LT CARE', 'LTC 24HR NURSING CARE IN NS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29011', 'N', 'AMBULATORY CAR', 'ABERDEEN HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29012', 'N', 'AMBULATORY CAR', 'ALL SAINT''S SPRINGHILL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29013', 'N', 'AMBULATORY CAR', 'ANNAPOLIS COMMUNITY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29014', 'N', 'AMBULATORY CAR', 'SOUTH SHORE REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29015', 'N', 'AMBULATORY CAR', 'BUCHANAN MEMORIAL COMM. HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29018', 'N', 'AMBULATORY CAR', 'COLCHESTER EAST HANTS HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29020', 'N', 'AMBULATORY CAR', 'DIGBY GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29021', 'N', 'AMBULATORY CAR', 'EASTERN KINGS MEMORIAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29022', 'N', 'AMBULATORY CAR', 'EASTERN MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29023', 'N', 'AMBULATORY CAR', 'EASTERN SHORE MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29027', 'N', 'AMBULATORY CAR', 'GUYSBOROUGH MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29030', 'N', 'AMBULATORY CAR', 'CUMBERLAND REGIONAL HEALTH CARE CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29032', 'N', 'AMBULATORY CAR', 'LILLIAN FRASER MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29033', 'N', 'AMBULATORY CAR', 'MUSQUODOBOIT VALLEY MEMORIAL HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29034', 'N', 'AMBULATORY CAR', 'INVERNESS CONSOLIDATED MEM. HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29035', 'N', 'AMBULATORY CAR', 'NORTH CUMBERLAND MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29037', 'N', 'AMBULATORY CAR', 'HANTS COMMUNITY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29038', 'N', 'AMBULATORY CAR', 'QUEEN''S GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29039', 'N', 'AMBULATORY CAR', 'ROSEWAY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29040', '4', 'LT CARE', 'ST. ANNE COMMUNITY&NURSING CARE CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29043', 'N', 'AMBULATORY CAR', 'ST. MARTHA''S REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29045', 'N', 'AMBULATORY CAR', 'ST. MARY''S MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29047', 'N', 'AMBULATORY CAR', 'SACRED HEART COMMUNITY HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29048', 'N', 'AMBULATORY CAR', 'SOLDIERS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29049', 'N', 'AMBULATORY CAR', 'SOUTH CUMBERLAND COMMUNITY CARE CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29052', 'N', 'AMBULATORY CAR', 'TWIN OAKS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29053', 'N', 'AMBULATORY CAR', 'VICTORIA COUNTY MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29055', 'N', 'AMBULATORY CAR', 'WESTERN KINGS MEMORIAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29056', 'N', 'AMBULATORY CAR', 'YARMOUTH REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29061', 'N', 'AMBULATORY CAR', 'COBEQUID COMMUNITY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29065', 'N', 'AMBULATORY CAR', 'DARTMOUTH GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29067', 'N', 'AMBULATORY CAR', 'VALLEY REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29068', 'N', 'AMBULATORY CAR', 'STRAIT RICHMOND HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29077', 'N', 'AMBULATORY CAR', 'NOVA SCOTIA HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29085', 'N', 'AMBULATORY CAR', 'QUEEN ELIZABETH II HEALTH SC. CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29086', 'N', 'AMBULATORY CAR', 'IWK HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29087', 'N', 'AMBULATORY CAR', 'CAPE BRETON HEALTH CARE COMPLEX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29089', '8', 'HOME CARE', 'HOME CARE SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29114', 'N', 'AMBULATORY CAR', 'FISHERMEN''S MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29800', '0', 'COMMUNITY CLIN', 'GEN. FAC. - COMMUNITY BASED CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29802', 'F', 'OTHER HEALTH', 'GEN. FAC. - OTHER HEALTH FACILITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29803', 'J', 'OTH NON-HEALTH', 'GEN. FAC.-OTHER NON-HEALTH FACILITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29804', 'U', 'UNKNOWN', 'GENERIC FACILITY - UNKNOWN FACILITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29805', '4', 'LT CARE', 'GEN. FAC. - VETERAN''S AFFAIRS - LTC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29991', 'P', 'HOSPICE/PALTIV', 'HOSPICE/PALLIATIVE CARE FACILITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29992', 'T', 'MH/ADDICT RX', 'MENTAL HLTH/ADDICTION TREATMENT CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29993', 'M', 'COMM MH ADDICT', 'COMMUNITY MENTAL HEALTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29994', 'G', 'GROUP/SUPPORT', 'GROUP LIVING/SUPPORTIVE HOUSING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29995', 'H', 'TRANSIT HOUSE', 'TRANSITIONAL HOUSING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NS', '29996', 'C', 'CORRECTIONAL', 'CORRECTIONAL FACILITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30001', '1', 'ACUTE INPT', 'DR. EVERETT CHALMERS REGIONAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30005', '1', 'ACUTE INPT', 'HPITAL RGIONAL DE CAMPBELLTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30009', '1', 'ACUTE INPT', 'HPITAL RGIONAL D''EDMUNDSTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30016', '1', 'ACUTE INPT', 'GRAND MANAN HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30018', '1', 'ACUTE INPT', 'HPITAL DE LAMQUE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30020', '1', 'ACUTE INPT', 'THE MONCTON HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30022', '1', 'ACUTE INPT', 'MIRAMICHI REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30023', '1', 'ACUTE INPT', 'HOTEL-DIEU OF ST. JOSEPH', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30026', '1', 'ACUTE INPT', 'SACKVILLE MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30029', '1', 'ACUTE INPT', 'SAINT JOHN REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30032', '1', 'ACUTE INPT', 'HOTEL-DIEU ST-JOSEPH DE ST-QUENTIN', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30033', '1', 'ACUTE INPT', 'CHARLOTTE COUNTY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30034', '1', 'ACUTE INPT', 'SUSSEX HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30035', '1', 'ACUTE INPT', 'HPITAL DE TRACADIE-SHEILA', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30039', '1', 'ACUTE INPT', 'HPITAL RGIONAL CHALEUR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30041', '1', 'ACUTE INPT', 'HPITAL DE L''ENFANT-JSUS RHSJ', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30042', '1', 'ACUTE INPT', 'HPITAL GNRAL DE GRAND-SAULT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30045', '1', 'ACUTE INPT', 'HPITAL DE STELLA-MARIS-DE-KENT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30046', '1', 'ACUTE INPT', 'OROMOCTO PUBLIC HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30048', '1', 'ACUTE INPT', 'CHU DR-GEORGES-L.-DUMONT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30049', '1', 'ACUTE INPT', 'UPPER RIVER VALLEY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30050', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-QC FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30060', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-ON FACILITIES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30065', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-NS FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30070', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-PE FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30074', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-NL FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30075', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-MB FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30076', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-SK FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30077', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-AB FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30078', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-BC FACILITIES (ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30079', '1', 'ACUTE INPT', 'GENFACNUMYK,NT,NU FACILITIES(ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30080', '1', 'ACUTE INPT', 'GEN.FAC.NUM.-FACILITIESINUSA(ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '30090', '1', 'ACUTE INPT', 'GENFACNUMFACINOTHERCOUNTRIES(ACUTE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31001', 'A', 'DAY SURGERY', 'DR. EVERETT CHALMERS REGIONAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31005', 'A', 'DAY SURGERY', 'HPITAL RGIONAL DE CAMPBELLTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31009', 'A', 'DAY SURGERY', 'HPITAL RGIONAL D''EDMUNDSTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31020', 'A', 'DAY SURGERY', 'THE MONCTON HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31022', 'A', 'DAY SURGERY', 'MIRAMICHI REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31026', 'A', 'DAY SURGERY', 'SACKVILLE MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31029', 'A', 'DAY SURGERY', 'SAINT JOHN REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31031', 'A', 'DAY SURGERY', 'ST. JOSEPH''S HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31033', 'A', 'DAY SURGERY', 'CHARLOTTE COUNTY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31034', 'A', 'DAY SURGERY', 'SUSSEX HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31039', 'A', 'DAY SURGERY', 'HPITAL RGIONAL CHALEUR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31042', 'A', 'DAY SURGERY', 'HPITAL GNRAL DE GRAND-SAULT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31046', 'A', 'DAY SURGERY', 'OROMOCTO PUBLIC HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31048', 'A', 'DAY SURGERY', 'CHU DR-GEORGES-L.-DUMONT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31049', 'A', 'DAY SURGERY', 'UPPER RIVER VALLEY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31050', 'A', 'DAY SURGERY', 'QUEBEC FACILITIES, (DAY SURGERY)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31065', 'A', 'DAY SURGERY', 'GEN. FAC. NUM. - NS FACILITIES (DS)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '31080', 'A', 'DAY SURGERY', 'GEN.FAC.NUM.-FACILITIESINUSA(DS)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32001', 'N', 'AMBULATORY CAR', 'DR. EVERETT CHALMERS REGIONAL HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32005', 'N', 'AMBULATORY CAR', 'HPITAL RGIONAL DE CAMPBELLTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32009', 'N', 'AMBULATORY CAR', 'HPITAL RGIONAL D''EDMUNDSTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32016', 'N', 'AMBULATORY CAR', 'GRAND MANAN HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32018', 'N', 'AMBULATORY CAR', 'HPITAL DE LAMQUE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32020', 'A', 'DAY SURGERY', 'THE MONCTON HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32022', 'N', 'AMBULATORY CAR', 'MIRAMICHI REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32023', 'N', 'AMBULATORY CAR', 'HOTEL-DIEU OF ST. JOSEPH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32026', 'N', 'AMBULATORY CAR', 'SACKVILLE MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32029', 'A', 'DAY SURGERY', 'SAINT JOHN REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32031', 'A', 'DAY SURGERY', 'ST. JOSEPH''S HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32032', 'N', 'AMBULATORY CAR', 'HOTEL-DIEU ST-JOSEPH DE ST-QUENTIN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32033', 'N', 'AMBULATORY CAR', 'CHARLOTTE COUNTY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32034', 'N', 'AMBULATORY CAR', 'SUSSEX HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32035', 'N', 'AMBULATORY CAR', 'HPITAL DE TRACADIE-SHEILA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32039', 'N', 'AMBULATORY CAR', 'CHALEUR REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32041', 'N', 'AMBULATORY CAR', 'HPITAL DE L''ENFANT-JSUS RHSJ', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32042', 'N', 'AMBULATORY CAR', 'HPITAL GNRAL DE GRAND-SAULT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32045', 'N', 'AMBULATORY CAR', 'HPITAL DE STELLA-MARIS-DE-KENT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32046', 'N', 'AMBULATORY CAR', 'OROMOCTO PUBLIC HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32048', 'A', 'DAY SURGERY', 'CHU DR-GEORGES-L.-DUMONT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '32049', 'N', 'AMBULATORY CAR', 'UPPER RIVER VALLEY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33001', '3', 'INPT CCC', 'DR. EVERETT CHALMERS REGIONAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33005', '3', 'INPT CCC', 'HPITAL RGIONAL DE CAMPBELLTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33009', '3', 'INPT CCC', 'HPITAL RGIONAL D''EDMUNDSTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33020', '3', 'INPT CCC', 'THE MONCTON HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33022', '3', 'INPT CCC', 'MIRAMICHI REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33029', '3', 'INPT CCC', 'Saint John Regional Hospital', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33031', '3', 'INPT CCC', 'ST. JOSEPH''S HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33033', '3', 'INPT CCC', 'CHARLOTTE COUNTY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33039', '3', 'INPT CCC', 'HPITAL RGIONAL CHALEUR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33046', '3', 'INPT CCC', 'OROMOCTO PUBLIC HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33048', '3', 'INPT CCC', 'CHU DR-GEORGES-L.-DUMONT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33050', '3', 'INPT CCC', 'QUEBEC FACILITIES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33301', '4', 'LT CARE', 'YORK MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33302', '4', 'LT CARE', 'THEKENNETHE.SPENCERNURSINGHOMEINC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33303', '4', 'LT CARE', 'UNITEDCHURCHHOMEFORSRCITIZENSINC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33304', '4', 'LT CARE', 'FOREST DALE HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33305', '4', 'LT CARE', 'FOYER SAINT-ANTOINE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33306', '4', 'LT CARE', 'FOYERSTTHOMASDELAVALLEDEMEMRAMCOOK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33307', '4', 'LT CARE', 'JORDAN LIFECARE CENTRE INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33308', '4', 'LT CARE', 'MANOIR SAINT-JEAN BAPTISTE INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33309', '4', 'LT CARE', 'REXTON LIONS NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33310', '4', 'LT CARE', 'SHANNEX RLC LTD. MONARCH HALL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33311', '4', 'LT CARE', 'THE SALVATION ARMY LAKEVIEW MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33312', '4', 'LT CARE', 'VILLA DU REPOS INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33313', '4', 'LT CARE', 'VILLA MARIA INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33314', '4', 'LT CARE', 'VILLA PROVIDENCE SHDIAC INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33315', '4', 'LT CARE', 'WESTFORD NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33316', '4', 'LT CARE', 'CAMPOBELLO LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33317', '4', 'LT CARE', 'CARLETON KIRK NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33318', '4', 'LT CARE', 'CHURCH OF ST JOHN & ST STEPHEN HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33319', '4', 'LT CARE', 'DR. V. A. SNOW CENTRE INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33320', '4', 'LT CARE', 'FUNDY NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33321', '4', 'LT CARE', 'GRAND MANAN NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33322', '4', 'LT CARE', 'KENNEBEC MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33323', '4', 'LT CARE', 'KINGS WAY CARE CENTRE INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33324', '4', 'LT CARE', 'KIWANIS NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33325', '4', 'LT CARE', 'LINCOURT MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33326', '4', 'LT CARE', 'LOCH LOMOND VILLA INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33327', '4', 'LT CARE', 'PASSAMAQUODDY LODGE INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33328', '4', 'LT CARE', 'ROCMAURA INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33329', '4', 'LT CARE', 'SHANNEX RLC LTD. EMBASSY HALL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33330', '4', 'LT CARE', 'TURNBULL NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33331', '4', 'LT CARE', 'CARLETON MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33332', '4', 'LT CARE', 'CENTRAL CARLETON NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33333', '4', 'LT CARE', 'CENTRAL NEW BRUNSWICK NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33334', '4', 'LT CARE', 'ORCHARD VIEW', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33335', '4', 'LT CARE', 'MILL COVE NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33336', '4', 'LT CARE', 'NASHWAAK VILLA INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33337', '4', 'LT CARE', 'PINE GROVE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33338', '4', 'LT CARE', 'RIVER VIEW MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33339', '4', 'LT CARE', 'SHANNEX RLC LTD. THOMAS HALL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33340', '4', 'LT CARE', 'TOBIQUE VALLEY MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33341', '4', 'LT CARE', 'VICTORIA GLEN MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33342', '4', 'LT CARE', 'WAUKLEHEGAN MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33343', '4', 'LT CARE', 'WHITE RAPIDS MANOR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33344', '4', 'LT CARE', 'W. G. BISHOP NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33345', '4', 'LT CARE', 'FOYER NOTRE-DAME DE SAINT-LONARD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33347', '4', 'LT CARE', 'FOYER STE. ELIZABETH INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33348', '4', 'LT CARE', 'GRANDFALLSMANORINC.MANOIRDESCHUTES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33349', '4', 'LT CARE', 'RSIDENCE MGR. MELANSON INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33352', '4', 'LT CARE', 'CAMPBELLTON NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33353', '4', 'LT CARE', 'DALHOUSIE NURSING HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33354', '4', 'LT CARE', 'VILLA SORMANY INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33355', '4', 'LT CARE', 'ROBERTI.KNOWLESVETERANSUNITVILLACHA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33356', '4', 'LT CARE', 'FOYER NOTRE-DAME-DE-LOURDES INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33357', '4', 'LT CARE', 'FOYER ASSOMPTION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33358', '4', 'LT CARE', 'MIRAMICHI SENIOR CITIZENS HOME INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33359', '4', 'LT CARE', 'MOUNT SAINT JOSEPH OF CHATHAM, N.B.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33361', '4', 'LT CARE', 'TABUSINTAC NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33362', '4', 'LT CARE', 'RSIDENCES INKERMAN INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33363', '4', 'LT CARE', 'RSIDENCES LUCIEN SAINDON INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33364', '4', 'LT CARE', 'RSIDENCES MGR. CHIASSON INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33366', '4', 'LT CARE', 'MANOIR DITH B. PINET', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33367', '4', 'LT CARE', 'VILLA BEAUSJOUR INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33368', '4', 'LT CARE', 'VILLA SAINT-JOSEPH INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33369', '4', 'LT CARE', 'LES RSIDENCES JODIN INC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33371', '4', 'LT CARE', 'LE COMPLEXE RENDEZ-VOUS INC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33372', '4', 'LT CARE', 'SHANNEX RLC LTD. - FREDERICK HALL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33373', '4', 'LT CARE', 'SHANNEX RLC LTD. - TUCKER HALL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '33381', '4', 'LT CARE', 'Pavillon Richard', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '34001', '3', 'INPT CCC', 'DR. EVERETT CHALMERS REGIONAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '34005', '3', 'INPT CCC', 'HPITAL RGIONAL DE CAMPBELLTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '34029', '3', 'INPT CCC', 'SAINT JOHN REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '34048', '3', 'INPT CCC', 'CHU DR-GEORGES-L.-DUMONT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '35001', '2', 'INPT REHAB', 'DR. EVERETT CHALMERS REGIONAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '35012', '2', 'INPT REHAB', 'THESTANCASSIDYCTREFORREHABILITATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '35020', '2', 'INPT REHAB', 'THE MONCTON HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '35022', '2', 'INPT REHAB', 'MIRAMICHI REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '35029', '2', 'INPT REHAB', 'SAINT JOHN REGIONAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '35048', '2', 'INPT REHAB', 'CHU DR-GEORGES-L.-DUMONT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '35050', '2', 'INPT REHAB', 'GEN. FAC. NUM.-QUEBEC FAC. (REHAB)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36700', '8', 'HOME CARE', 'VITALITE&HORIZONHLTHNET EMP UNSPEC.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36711', '8', 'HOME CARE', 'BLANCHE BOURGEOIS EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36712', '8', 'HOME CARE', 'SHDIAC EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36713', '8', 'HOME CARE', 'KENT EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36721', '8', 'HOME CARE', 'SAINT JOHN EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36722', '8', 'HOME CARE', 'ST. STEPHEN EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36723', '8', 'HOME CARE', 'EASTERN CHARLOTTE EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36725', '8', 'HOME CARE', 'SUSSEX EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36726', '8', 'HOME CARE', 'KENNEBECASIS EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36731', '8', 'HOME CARE', 'WOODSTOCK EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36732', '8', 'HOME CARE', 'PERTH EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36733', '8', 'HOME CARE', 'FREDERICTON EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36734', '8', 'HOME CARE', 'OROMOCTO EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36736', '8', 'HOME CARE', 'BOIESTOWN EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36741', '8', 'HOME CARE', 'GRAND FALLS EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36742', '8', 'HOME CARE', 'EDMUNSTON EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36743', '8', 'HOME CARE', 'KEDGWICK EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36751', '8', 'HOME CARE', 'RESTIGOUCHE EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36761', '8', 'HOME CARE', 'BATHURST EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36762', '8', 'HOME CARE', 'PNINS. ACADIENNE TRACADIE EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36763', '8', 'HOME CARE', 'PNINS. ACADIENNE CARAQUET EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36764', '8', 'HOME CARE', 'PNINS. ACADIENNE LAMQUE EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36771', '8', 'HOME CARE', 'MIRAMICHI EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36772', '8', 'HOME CARE', 'NGUAC EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36773', '8', 'HOME CARE', 'BLACKVILLE EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36781', '8', 'HOME CARE', 'DRISCOLL EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '36782', '8', 'HOME CARE', 'TANTRAMAR EMP UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37001', '8', 'HOME CARE', 'THE EVERETT CHALMERS REGIONAL HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37003', '0', 'COMMUNITY CLIN', 'FUNDY HEALTH CENTREBLACKS HARBOUR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37008', '0', 'COMMUNITY CLIN', 'CTR DE SANT COMM. ST-JOSEPH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37017', '0', 'COMMUNITY CLIN', 'HARVEY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37018', '0', 'COMMUNITY CLIN', 'HPITAL DE LAMQUE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37019', '0', 'COMMUNITY CLIN', 'QUEENS NORTH COMMUNITY HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37024', '0', 'COMMUNITY CLIN', 'TOBIQUE VALLEY COMMUNITY HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37028', '0', 'COMMUNITY CLIN', 'STANLEY HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37031', '0', 'COMMUNITY CLIN', 'ST. JOSEPH''S HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37033', '0', 'COMMUNITY CLIN', 'CHARLOTTE COUNTY WELLNESS CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37038', '0', 'COMMUNITY CLIN', 'ALBERT COUNTY HEALTH & WELLNESS CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37044', '0', 'COMMUNITY CLIN', 'MCADAM HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37051', '0', 'COMMUNITY CLIN', 'CENTREDESANTNOREEN-RICHARDHLTHCTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37052', '0', 'COMMUNITY CLIN', 'MDISANT SAINT-JEAN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37053', '0', 'COMMUNITY CLIN', 'CTR DE SANT COMM. DE ST-ISADORE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37057', '0', 'COMMUNITY CLIN', 'GIBSON HEALTH CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37058', '0', 'COMMUNITY CLIN', 'CENTRAL MIRAMICHI COMM. HEALTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37062', '0', 'COMMUNITY CLIN', 'OROMOCTO HEALTH CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37063', '0', 'COMMUNITY CLIN', 'FREDERICTON DOWNTOWN COMM. HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37481', 'P', 'HOSPICE/PALTIV', 'BOBBY''S HOSPICE - SAINT JOHN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37482', 'P', 'HOSPICE/PALTIV', 'HOSPICE HOUSE - FREDERICTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37601', 'F', 'OTHER HEALTH', 'MIDWIFERY SERV. DRCHALMERSREG.HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37605', 'F', 'OTHER HEALTH', 'MIDWIFERYSERV.HP.RG.DECAMPBELLTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37609', 'F', 'OTHER HEALTH', 'MIDWIFERY SERV.HP.RG.D''EDMUNDSTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37620', 'F', 'OTHER HEALTH', 'MIDWIFERY SERV. THE MONCTON HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37622', 'F', 'OTHER HEALTH', 'MIDWIFERY SERV. MIRAMICHI REG.HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37629', 'F', 'OTHER HEALTH', 'MIDWIFERY SERV. ST JOHN REG. HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37639', 'F', 'OTHER HEALTH', 'MIDWIFERY SERV. HP. RG. CHALEUR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37648', 'F', 'OTHER HEALTH', 'MIDWIFERYSERV.CHUDR.GEORGESL.DUMONT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '37649', 'F', 'OTHER HEALTH', 'MIDWIFERYSERV.UPPERRIVERVALLEYHOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '38011', '5', 'INPT MENTAL', 'CENTRE HOSPITALIER RESTIGOUCHE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '38015', '5', 'INPT MENTAL', 'CENTRACARE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39001', 'E', 'EMERGENCY DPT', 'DR. EVERETT CHALMERS REGIONAL HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39005', 'E', 'EMERGENCY DPT', 'HPITAL RGIONAL DE CAMPBELLTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39009', 'E', 'EMERGENCY DPT', 'HPITAL RGIONAL D''EDMUNDSTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39016', 'E', 'EMERGENCY DPT', 'GRAND MANAN HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39018', 'E', 'EMERGENCY DPT', 'HPITAL DE LAMQUE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39020', 'E', 'EMERGENCY DPT', 'THE MONCTON HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39022', 'E', 'EMERGENCY DPT', 'MIRAMICHI REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39023', 'E', 'EMERGENCY DPT', 'HOTEL-DIEU OF ST. JOSEPH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39026', 'E', 'EMERGENCY DPT', 'SACKVILLE MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39029', 'E', 'EMERGENCY DPT', 'SAINT JOHN REGIONAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39031', 'E', 'EMERGENCY DPT', 'ST. JOSEPH''S HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39032', 'E', 'EMERGENCY DPT', 'HOTEL-DIEU ST-JOSEPH DE ST-QUENTIN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39033', 'E', 'EMERGENCY DPT', 'CHARLOTTE COUNTY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39034', 'E', 'EMERGENCY DPT', 'SUSSEX HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39035', 'E', 'EMERGENCY DPT', 'HPITAL DE TRACADIE-SHEILA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39039', 'E', 'EMERGENCY DPT', 'HPITAL RGIONAL CHALEUR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39041', 'E', 'EMERGENCY DPT', 'HPITAL DE L''ENFANT-JSUS RHSJ', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39042', 'E', 'EMERGENCY DPT', 'HPITAL GNRAL DE GRAND-SAULT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39045', 'E', 'EMERGENCY DPT', 'HPITAL DE STELLA-MARIS-DE-KENT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39046', 'E', 'EMERGENCY DPT', 'OROMOCTO PUBLIC HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39048', 'E', 'EMERGENCY DPT', 'CHU DR-GEORGES-L.-DUMONT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39049', 'E', 'EMERGENCY DPT', 'UPPER RIVER VALLEY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39065', 'E', 'EMERGENCY DPT', 'ER-ANY NS HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39070', 'E', 'EMERGENCY DPT', 'GENERIC NUMBER - ED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39080', 'E', 'EMERGENCY DPT', 'GENFACNUM-FAC.INTHEUSA(EMERG. DEPT)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39974', 'M', 'COMM MH ADDICT', 'GEN. NUM.-COMMUNITY MENTAL HLTH CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39976', 'T', 'MH/ADDICT RX', 'GEN.NUM.-ADDICTION TREATMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39978', 'H', 'TRANSIT HOUSE', 'GEN.NUM.-HOMELESS&TRANSITIONSHELTER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39996', 'C', 'CORRECTIONAL', 'CORRECTIONAL FACILITIES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39998', '8', 'HOME CARE', 'GENERIC NUMBER-HOME WITH SUPPORT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('NB', '39999', 'G', 'GROUP/SUPPORT', 'GENERIC NUMBER -SPECIAL CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40001', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40002', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40003', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40004', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40005', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40009', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40010', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40011', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40012', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40013', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40014', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40015', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40017', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40018', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40019', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40020', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40021', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40022', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40023', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40024', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40025', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40026', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40027', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40028', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40029', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40035', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40036', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40037', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40038', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40039', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40040', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40041', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40042', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40043', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40044', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40045', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40046', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40047', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40048', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40049', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40050', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40051', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40052', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40053', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40054', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40055', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40056', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40057', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40058', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40059', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40060', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40061', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40062', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40063', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40064', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40065', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40066', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40067', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40068', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40069', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40070', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40071', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40072', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40073', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40074', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40075', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40076', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40077', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40078', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40079', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40080', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40081', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40082', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40083', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40084', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40085', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40086', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40087', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40088', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40089', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40094', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40097', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40098', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40099', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40100', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40101', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40102', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40103', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40104', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40105', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40106', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40107', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40108', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40109', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40110', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40111', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40112', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40113', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40114', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40115', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40116', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40117', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40118', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40119', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40120', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40121', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40122', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40123', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40124', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40125', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40126', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40127', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40128', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40129', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40130', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40131', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40132', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40133', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40134', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40135', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40136', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40137', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40138', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40139', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40140', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40141', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40142', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40143', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40144', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40145', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40146', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40147', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40148', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40149', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40150', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40151', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40152', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40153', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40154', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40155', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40156', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40157', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40158', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40160', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40161', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40162', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40163', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40164', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40165', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40166', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40167', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40168', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40169', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40170', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40171', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40172', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40173', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40174', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40175', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40176', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40177', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40178', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40180', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40185', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40186', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40187', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40188', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40189', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40191', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40192', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40193', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40194', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40195', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40196', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40197', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40198', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40199', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40200', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40202', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40203', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40204', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40205', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40206', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40207', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40208', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '40209', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '41405', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42000', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42001', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42002', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42004', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42006', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42008', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42010', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42012', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42014', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42016', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42017', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42019', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42021', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42022', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42024', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42025', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42027', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42029', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42031', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42033', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42035', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42037', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42038', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42040', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42042', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42043', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42044', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42045', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42046', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42048', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42050', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42052', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42054', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42056', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42058', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42059', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42061', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42063', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42064', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42066', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42068', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42070', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42072', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42073', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42075', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42076', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42081', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42083', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42085', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42087', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42089', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42091', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42093', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42095', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42097', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42099', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42101', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42102', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42104', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42106', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42108', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42110', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42111', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42113', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42114', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42116', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42118', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42119', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42121', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42123', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42125', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42126', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42128', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42130', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42132', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42133', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42134', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42135', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42136', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42138', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42140', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42141', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42143', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42145', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42147', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42149', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42151', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42153', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42157', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42158', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42159', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42161', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42163', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42165', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42167', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42169', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42171', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42173', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42175', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42178', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42180', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42182', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42184', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42186', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42188', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42190', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42194', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42196', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42197', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42199', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42201', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42202', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42204', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42206', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42208', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42209', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42211', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42213', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42215', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42216', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42217', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42219', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42221', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42223', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42227', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42229', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42231', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42232', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42234', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42236', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42238', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42240', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42242', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42244', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42246', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42248', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42250', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42252', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42254', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42256', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42257', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42259', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42261', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42262', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42264', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42265', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42267', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42269', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42271', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42272', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42274', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42275', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42277', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42279', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42281', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42283', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42285', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42287', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42289', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42290', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42292', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42294', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42296', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42300', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42302', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42304', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42305', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42309', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42311', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42313', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42314', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42316', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42317', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42321', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42323', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42325', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42400', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42401', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42402', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42403', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42405', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42406', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42407', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '42408', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43001', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43002', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43003', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43004', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43005', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43006', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43009', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43010', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43011', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43012', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43013', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43014', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43016', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43017', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43018', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43019', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43020', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43021', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43022', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43023', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43024', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43025', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43026', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43027', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43028', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43029', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43030', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43031', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43032', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43033', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43034', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43035', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43036', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43037', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43038', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43039', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43040', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43041', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43042', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43043', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43044', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43045', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43047', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43048', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43049', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43050', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43051', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43052', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43053', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43054', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43055', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43056', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43057', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43058', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43059', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43060', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43061', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43062', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43063', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43064', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43065', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43066', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43067', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43068', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43069', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43070', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43071', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43072', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43073', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43074', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43075', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43076', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43077', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43078', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43079', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43080', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43081', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43082', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43083', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43084', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43085', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43086', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43087', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43088', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43089', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43090', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43091', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43092', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43097', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43100', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43101', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43102', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43103', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43104', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43105', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43106', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43107', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43108', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43109', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43110', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43111', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43112', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43113', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43114', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43115', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43116', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43117', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43118', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43119', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43120', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43121', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43122', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43123', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43124', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43125', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43126', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43127', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43128', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43129', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43130', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43131', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43132', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43133', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43134', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43135', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43136', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43137', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43138', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43139', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43140', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43141', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43142', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43143', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43144', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43145', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43146', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43147', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43148', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43149', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43150', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43151', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43152', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43153', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43154', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43155', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43156', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43157', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43158', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43159', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43160', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43161', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43162', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43163', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43164', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43165', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43166', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43168', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43169', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43171', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43172', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43175', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43176', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43177', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43178', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43179', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43180', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43181', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43182', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43183', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43184', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43185', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43186', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43187', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43188', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43189', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43190', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43191', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43192', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43193', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43194', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43195', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43196', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43197', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43198', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43199', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43200', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43201', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43202', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43203', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43204', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43205', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43206', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43207', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43208', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43209', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43210', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43211', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43212', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43213', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43214', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43215', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43216', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43217', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43218', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43219', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43220', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43221', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43222', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43223', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43224', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43225', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43226', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43227', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43228', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43229', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43230', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43231', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43232', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43233', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43234', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43235', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43236', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43237', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43238', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43239', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43240', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43241', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43242', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43243', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43244', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43245', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43246', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43247', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43248', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43249', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43250', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43251', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43253', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43254', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43255', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43256', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43257', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43258', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43259', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43260', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43261', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43262', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43263', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43264', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43265', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43266', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43267', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43268', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43269', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43270', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43272', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43273', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43274', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43275', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43276', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43277', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43278', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43279', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43280', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43281', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43282', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43283', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43284', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43285', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43286', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43287', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43288', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43289', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43290', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43291', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43292', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43293', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43294', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43295', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43296', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43297', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43298', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43299', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43300', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43301', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43302', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43303', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43304', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43305', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43306', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43307', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43308', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43309', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43310', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43311', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43312', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43313', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43314', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43315', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43316', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43317', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43318', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43319', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43320', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43321', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43322', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43323', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43324', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43325', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43326', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43327', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43330', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43335', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43338', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43346', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43347', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43348', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43353', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43354', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43361', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43367', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43368', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43369', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43370', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43371', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43372', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43374', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43375', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43376', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43377', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43378', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43379', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43380', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43381', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43382', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43383', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43384', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43385', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43386', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43387', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43388', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43389', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43390', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43391', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43392', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43393', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43394', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43395', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43396', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43397', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43398', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43399', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43400', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43401', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43402', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43403', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43404', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43405', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43406', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43407', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43408', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43409', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43410', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43411', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43412', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43413', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43414', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43415', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43416', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43417', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43418', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43419', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43420', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43421', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43422', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43423', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43424', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43425', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43426', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43427', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43428', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43429', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43430', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43431', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43432', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43433', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43434', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43435', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43436', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43437', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43438', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43439', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43440', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43441', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43442', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43443', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43444', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43445', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43446', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43447', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43448', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43449', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43450', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43451', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43452', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43453', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43454', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43455', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43456', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43457', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43458', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43460', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43461', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43462', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43463', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43464', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43465', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43466', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43467', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43468', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43469', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43470', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43471', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43472', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43473', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43474', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43475', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43476', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43477', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43478', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43479', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43480', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43481', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43482', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43483', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43484', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43485', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43486', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43487', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43488', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43489', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43490', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43491', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43492', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43493', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43494', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43495', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43496', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43497', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43498', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43499', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43500', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43501', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43502', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43503', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43504', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43505', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43506', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43507', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43508', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43509', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43510', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43511', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43512', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43513', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43514', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43515', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43516', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43517', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43518', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43519', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43520', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43521', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43522', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43523', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43524', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43525', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43526', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43527', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43528', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43529', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43530', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43531', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43532', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43533', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43534', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43535', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43536', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43537', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43538', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43539', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43540', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43541', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43542', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43543', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43544', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43545', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43546', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43547', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43548', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43549', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43550', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43551', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43552', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43553', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43554', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43555', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43556', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43557', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43558', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43559', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43560', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43561', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43562', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43563', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43564', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43565', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43566', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43567', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43568', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43569', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43570', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43571', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43572', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43573', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43574', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43575', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43576', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43577', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43578', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43579', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43580', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43581', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43582', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43583', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43584', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43585', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43586', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43587', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43588', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43589', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43590', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43591', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43592', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43593', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43594', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43595', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43596', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43597', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43598', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43599', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43600', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43601', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43602', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43603', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43604', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43605', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43606', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43607', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43608', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43609', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43610', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43611', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43612', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43613', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43614', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43615', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43616', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43617', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43618', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43619', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43620', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43621', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43622', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43623', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43624', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43625', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43626', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43627', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43628', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43629', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43630', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43631', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43632', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43633', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43634', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43635', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43636', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43637', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43638', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43639', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43640', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43641', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43642', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43643', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43644', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43645', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43646', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43647', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43648', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43649', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43650', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43651', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43652', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43653', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43654', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43655', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43656', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43657', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43658', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43659', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43660', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43661', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43662', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43663', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43664', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43665', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43666', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43667', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43668', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43669', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43670', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43671', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43672', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43673', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43674', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43675', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43676', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43677', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43678', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43679', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43680', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43681', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43682', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43683', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43684', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43685', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43686', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43687', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43688', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43689', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43690', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43691', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43692', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43693', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43694', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43695', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43696', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43697', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43698', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43699', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43700', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43701', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43702', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43703', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43704', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43705', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43706', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43707', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43708', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43709', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43710', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43711', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43712', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43713', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43714', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43715', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43716', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43717', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43718', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43719', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43720', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43721', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43722', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43723', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43724', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43725', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43726', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43727', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43728', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43729', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43730', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43731', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43732', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43733', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43734', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43735', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43736', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43737', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43738', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43739', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43740', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43741', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43742', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43743', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43744', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43745', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43746', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43747', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43748', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43749', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43750', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43751', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43752', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43753', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43754', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43755', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43756', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43757', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43758', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43759', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43760', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43761', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43762', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43763', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43764', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43765', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43766', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43767', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43768', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43769', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43770', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43771', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43772', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43773', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43774', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43775', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43776', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43777', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43778', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43779', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43780', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43781', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43782', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43783', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43784', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43785', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43786', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43787', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43788', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43789', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43790', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43791', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43792', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43793', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43794', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43795', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43796', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43797', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43798', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43799', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43800', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43801', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43802', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43803', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43804', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43805', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43806', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43807', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43808', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43809', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43810', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43811', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43812', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43813', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43814', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43815', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43816', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43817', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43818', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43819', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43820', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43821', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43822', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43823', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43824', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43825', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43826', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43827', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43828', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43829', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43830', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43831', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43832', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43833', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43834', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43835', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43836', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43837', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43838', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43839', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43840', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43841', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43842', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43843', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43844', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43845', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43846', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43847', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43848', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43849', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43850', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43851', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43852', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43853', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43854', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43855', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43856', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43857', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43858', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43859', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43860', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43861', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43862', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43863', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43864', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43865', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43866', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43867', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43868', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43869', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43870', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43871', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43872', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43873', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43874', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43875', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43876', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43877', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43878', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43879', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43880', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43881', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43882', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43883', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43884', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43885', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43886', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43887', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43888', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43889', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43890', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43891', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43892', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43893', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43894', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43895', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43896', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43897', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43898', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43899', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43900', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43901', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43902', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43903', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43904', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43905', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43906', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43907', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43908', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43909', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43910', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43911', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43912', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43913', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43914', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43915', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43916', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43917', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43918', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43919', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43920', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43921', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43922', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43923', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43924', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43925', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43926', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43927', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43928', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43929', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43930', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43931', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43932', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43933', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43934', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43935', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43936', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43937', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43938', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43939', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43940', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43941', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43942', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43943', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43944', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43945', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43946', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43947', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43948', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43949', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43950', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43951', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43952', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43953', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43954', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43955', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43956', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43957', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43958', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43959', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43960', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43961', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43962', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43963', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43964', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43965', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43966', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43967', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43968', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43969', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43970', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43971', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43972', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43973', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43974', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43975', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43976', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43977', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43978', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43979', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43980', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43981', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43982', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43983', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43984', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43986', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43987', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43988', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43989', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43990', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43992', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43993', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43994', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43995', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43996', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43997', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43998', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '43999', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44000', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44002', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44003', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44005', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44006', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44007', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44008', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44009', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44010', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44011', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44012', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44013', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44014', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44015', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44016', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44017', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44018', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44019', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44020', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44021', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44023', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44024', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44025', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44026', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44027', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44028', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44029', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44030', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44031', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44032', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44033', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44034', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44035', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44036', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44037', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44038', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44039', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44040', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44041', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44042', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44043', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44044', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44045', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44046', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44048', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44049', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44050', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44051', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44052', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44053', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44054', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44055', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44056', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44057', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44058', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44059', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44060', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44061', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44062', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44063', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44064', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44065', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44066', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44067', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44068', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44069', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44071', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44072', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44073', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44074', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44075', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44076', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44077', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44078', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44079', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44080', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44081', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44082', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44083', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44084', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44085', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44086', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44087', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44088', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44089', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44090', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44091', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44092', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44093', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44094', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44095', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44096', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44097', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44098', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44099', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44100', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44101', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44102', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44103', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44104', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44105', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44106', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44107', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44108', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44109', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44111', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44113', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44114', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44115', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44116', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44117', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44118', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44119', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44120', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44121', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44122', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44123', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44124', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44125', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44126', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44127', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44128', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44129', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44130', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44131', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44132', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44133', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44134', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44135', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44136', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44137', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44138', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44139', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44140', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44141', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44142', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44143', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44144', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44145', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44146', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44147', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44148', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44149', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44150', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44151', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44152', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44153', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44154', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44155', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44156', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44157', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44158', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44159', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44160', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44161', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44162', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44163', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44164', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44165', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44166', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44167', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44168', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44169', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44170', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44171', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44172', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44173', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44174', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44175', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44176', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44177', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44178', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44179', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44180', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44181', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44182', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44183', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44185', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44186', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44188', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44189', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44190', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44191', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44192', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44193', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44194', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44195', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44196', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44197', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44198', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44199', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44200', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44201', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44202', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44203', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44204', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44205', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44206', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44207', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44208', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44209', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44210', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44211', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44212', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44213', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44214', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44215', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44216', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44217', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44218', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44219', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44220', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44221', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44222', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44223', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44224', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44225', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44226', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44227', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44228', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44229', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44230', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44231', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44232', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44233', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44234', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44235', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44236', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44237', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44238', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44239', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44240', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44241', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44242', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44243', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44244', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44245', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44246', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44247', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44248', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44249', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44250', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44251', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44252', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44253', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44254', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44255', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44256', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44257', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44258', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44259', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44260', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44261', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44262', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44263', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44264', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44265', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44266', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44267', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44268', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44269', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44270', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44271', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44272', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44273', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44275', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44276', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44277', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44278', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44279', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44280', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44281', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44282', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44285', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44286', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44287', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44288', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44290', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44291', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44292', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44293', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44294', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44295', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44296', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44297', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44298', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44299', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44300', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44301', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44302', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44304', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44306', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44308', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44309', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44310', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44311', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44312', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44313', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44314', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44315', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44316', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44317', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44318', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44319', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44320', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44321', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44322', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44323', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44324', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44325', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44326', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44327', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44328', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44331', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44333', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44334', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44335', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44336', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44337', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44339', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44340', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44341', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44342', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44343', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44344', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44345', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44346', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44347', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44348', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44349', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44350', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44351', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44352', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44353', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44354', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44355', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44356', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44357', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44358', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44359', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44360', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44361', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44362', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44363', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44364', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44365', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44366', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44367', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44371', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44372', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44373', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44374', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44375', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44376', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44378', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44381', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44383', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44384', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44385', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44386', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44387', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44388', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44389', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44390', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44391', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44392', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44393', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44394', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44395', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44396', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44397', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44398', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44399', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44401', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44402', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44403', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44404', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44405', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44407', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44408', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44409', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44410', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44411', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44412', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44413', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44414', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44415', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44416', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44417', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44418', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44419', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44420', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44421', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44422', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44423', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44425', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44426', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44427', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44428', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44429', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44430', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44431', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44432', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44433', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44435', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44436', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44437', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44438', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44439', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44440', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44441', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44442', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44443', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44444', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44445', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44446', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44447', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44448', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44450', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44451', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44452', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44453', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44454', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44455', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44456', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44457', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44458', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44459', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44460', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44461', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44463', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44464', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44465', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44466', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44467', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44468', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44469', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44470', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44471', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44472', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44473', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44474', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44475', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44476', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44478', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44479', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44480', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44481', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44482', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44483', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44484', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44485', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44486', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44487', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44488', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44489', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44490', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44492', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44493', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44494', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44495', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44496', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44497', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44498', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44499', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44500', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44501', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44503', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44504', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44505', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44506', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44507', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44508', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44509', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44510', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44511', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44512', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44513', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44514', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44515', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44516', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44517', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44518', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44519', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44520', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44521', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44522', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44523', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44524', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44525', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44526', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44527', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44528', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44529', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44531', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44532', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44534', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44540', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44541', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44542', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44543', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44544', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44545', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44547', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44548', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44549', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44550', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44551', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44552', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44553', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44554', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44555', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44556', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44557', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44558', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44559', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44560', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44561', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44562', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44563', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44564', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44565', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44567', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44568', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44569', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44570', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44571', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44572', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44573', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44574', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44575', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44576', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44577', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44578', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44579', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44580', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44581', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44583', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44584', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44585', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44586', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44587', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44588', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44589', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44590', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44591', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44593', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44595', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44596', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44597', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44598', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44599', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44600', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44601', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44602', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44603', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44604', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44605', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44606', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44607', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44609', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44611', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44612', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44613', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44614', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44615', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44616', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44618', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44619', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44620', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44621', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44622', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44623', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44624', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44625', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44626', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44627', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44628', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44630', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44631', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44632', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44633', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44634', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44635', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44636', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44637', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44638', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44639', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44640', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44641', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44642', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44643', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44644', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44645', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44646', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44647', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44648', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44649', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44650', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44651', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44652', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44653', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44654', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44655', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44656', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44657', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44658', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44659', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44660', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44661', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44662', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44663', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44664', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44665', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44666', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44667', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44668', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44669', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44670', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44671', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44672', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44673', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44675', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44676', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44677', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44678', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44679', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44680', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44681', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44682', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44683', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44684', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44685', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44686', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44687', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44688', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44689', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44690', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44691', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44692', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44693', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44694', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44696', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44697', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44698', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44699', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44700', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44701', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44702', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44703', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44704', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44705', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44706', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44707', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44708', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44709', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44711', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44712', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44713', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44714', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44715', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44716', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44717', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44718', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44719', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44720', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44721', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44722', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44723', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44724', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44725', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44726', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44727', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44728', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44729', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44730', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44731', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44733', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44734', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44735', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44736', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44737', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44739', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44740', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44741', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44742', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44743', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44744', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44745', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44746', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44747', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44748', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44749', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44750', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44751', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44753', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44754', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44756', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44757', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44758', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44760', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44761', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44762', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44763', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44764', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44765', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44766', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44767', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44768', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44769', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44770', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44771', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44772', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44773', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44774', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44775', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44776', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44777', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44778', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44779', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44780', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44781', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44782', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44783', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44784', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44786', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44787', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44788', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44789', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44790', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44791', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44792', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44793', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44794', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44795', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44797', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44798', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44799', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44800', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44801', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44802', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44803', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44804', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44805', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44806', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44807', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44808', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44809', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44810', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44811', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44812', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44814', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44815', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44816', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44817', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44818', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44819', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44820', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44821', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44822', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44824', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44825', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44826', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44827', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44829', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44830', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44831', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44832', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44833', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44834', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44835', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44836', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44837', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44838', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44839', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44840', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44841', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44842', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44843', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44844', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44845', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44846', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44847', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44848', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44849', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44850', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44851', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44852', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44853', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44854', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44855', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44856', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44857', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44858', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44859', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44860', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44861', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44862', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44863', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44864', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44865', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44866', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44867', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44868', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44869', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44871', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44872', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44873', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '44874', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45001', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45006', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45008', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45009', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45010', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45011', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45012', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45014', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45015', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45016', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45018', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45019', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45020', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45022', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45023', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45024', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45025', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45026', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45027', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45028', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45029', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45030', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45031', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45034', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45035', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45036', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45037', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45038', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45040', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45041', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45044', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45045', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45046', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45047', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45049', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45050', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45051', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45052', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45053', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45054', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45055', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45056', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45058', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45059', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45060', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45061', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45062', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45063', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45065', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45066', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45067', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45068', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45069', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45070', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45071', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45072', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45073', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45074', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45075', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45076', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45077', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45078', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45079', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45080', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45081', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45082', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45083', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45087', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45088', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45089', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45090', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45091', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45092', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45093', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45094', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45095', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45096', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45097', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45098', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45099', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45100', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45103', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45104', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45106', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45107', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45108', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45109', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45110', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45111', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45112', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45113', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45114', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45116', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45117', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45119', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45120', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45121', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45122', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45123', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45125', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45126', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45127', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45128', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45129', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45133', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45134', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45135', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45136', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45137', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45138', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45139', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45140', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45141', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45142', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45143', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45144', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45145', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45146', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45147', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45148', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45149', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45150', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45151', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45153', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45154', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45155', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45156', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45157', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45158', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45160', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45166', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45167', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45168', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45169', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45170', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45171', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45172', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45174', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45175', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45176', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45177', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45178', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45179', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45180', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45181', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45182', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45183', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45184', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45185', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45186', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45187', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45188', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45189', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45190', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45191', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45192', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45193', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45194', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45195', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45196', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45197', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45198', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45199', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45200', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45201', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45202', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45203', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45204', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45205', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45206', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45207', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45208', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45209', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45210', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45211', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45212', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45213', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45214', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45215', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45216', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45217', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45220', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45221', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45222', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45223', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45224', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45225', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45226', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45227', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45228', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45229', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45230', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45231', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45232', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45233', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45234', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45235', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45236', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45237', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45238', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45239', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45240', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45241', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45242', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45243', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45244', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45245', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45246', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45247', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45248', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45249', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45250', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45251', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45252', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45253', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45254', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45255', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45256', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45257', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45258', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45259', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45260', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45261', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45262', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45263', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45264', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45265', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45266', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45267', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45268', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45269', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45270', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45271', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45272', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45273', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45274', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45275', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45276', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45277', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45278', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45279', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45280', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45281', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45283', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45284', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45285', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45286', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45287', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45288', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45289', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45290', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45291', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45292', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45293', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45294', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45295', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45296', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45297', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45298', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45299', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45300', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45301', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45302', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45303', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45304', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45306', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45307', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45308', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45309', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45311', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45312', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45313', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45314', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45316', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45317', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45319', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45320', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45321', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45322', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45323', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45324', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45325', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45326', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45327', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45328', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45329', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45330', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45331', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45332', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45333', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45334', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45335', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45336', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45337', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45338', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45339', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45341', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45342', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45343', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45344', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45345', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45346', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45347', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45348', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45349', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45350', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45351', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45352', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45354', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45355', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45356', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45358', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45359', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45360', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45361', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45362', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45363', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45364', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45365', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45366', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45367', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45368', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45369', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45370', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45371', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45372', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45373', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45374', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45375', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45376', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45377', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45378', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45379', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45380', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45381', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45382', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45384', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45385', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45386', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45387', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45388', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45389', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45390', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45391', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45392', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45393', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45394', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45395', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45396', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45397', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45398', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45399', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45400', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45401', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45402', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45403', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45404', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45405', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45406', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45407', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45408', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45409', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45410', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45411', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45412', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45413', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45414', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45415', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45416', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45417', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45418', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45419', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45420', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45421', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45422', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45423', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45424', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45425', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45426', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45427', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45428', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45429', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45430', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45431', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45432', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45433', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45434', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45436', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45437', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45438', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45439', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45440', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45441', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45442', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45443', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45444', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45445', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45446', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45447', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45448', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45449', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45450', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45451', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45452', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45453', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45454', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45455', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45456', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45457', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45458', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45459', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45460', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45461', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45462', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45463', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45464', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45465', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45466', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45467', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45468', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45469', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45470', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45471', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45472', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45473', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45474', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45476', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '45477', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46000', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46001', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46002', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46003', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46004', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46005', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46006', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46007', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46008', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46009', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46010', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46011', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46013', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46014', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46015', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46017', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46018', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46019', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46020', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46021', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46022', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46023', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46024', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46025', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46026', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46027', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46028', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46029', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46030', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46031', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46032', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46033', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46034', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46035', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46036', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46037', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46038', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46039', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46040', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46041', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46042', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46043', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46044', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46045', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46046', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46047', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46048', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46049', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46050', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46052', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46053', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46054', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46055', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46056', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46057', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46058', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46059', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46060', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46061', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46062', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46063', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46064', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46065', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46066', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46067', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46068', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46069', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46070', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46071', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46072', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46073', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46074', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46075', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46076', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46077', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46078', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46079', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46080', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46081', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46082', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46083', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46084', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46085', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46086', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46087', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46088', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46089', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46090', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46091', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46092', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46093', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46094', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46095', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46096', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46097', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46098', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46099', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46100', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46101', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46102', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46103', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46104', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46105', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46106', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46107', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46108', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46110', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46111', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46112', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46113', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46114', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46115', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46116', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46117', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46118', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46119', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46120', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46121', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46122', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46123', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46124', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46125', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46126', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46127', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46128', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46129', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46130', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46131', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46132', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46133', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46134', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46135', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46136', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46137', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46138', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46140', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46141', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46142', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46143', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46144', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46145', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46146', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46147', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46148', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46149', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46150', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46151', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46152', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46153', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46154', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46155', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46156', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46157', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46158', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46159', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46160', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46161', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46162', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46163', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46164', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46165', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46166', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46167', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46168', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46169', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46170', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46171', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46172', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46173', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46175', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46176', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46177', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46178', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46179', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46180', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46181', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46182', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46183', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46184', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46185', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46186', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46187', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46188', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46189', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46190', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46191', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46192', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46193', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46194', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46195', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46196', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46197', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46198', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46200', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46201', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46203', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46204', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46205', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46206', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46207', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46208', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46209', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46210', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46212', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46213', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46214', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46215', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46216', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46217', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46218', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46219', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46220', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46221', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46223', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46224', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46225', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46226', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46228', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46229', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46230', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46231', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46232', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46233', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46234', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46235', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46236', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46237', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46238', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46239', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46240', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46241', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46242', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46243', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46244', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46245', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46246', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46247', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46248', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46249', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46250', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46251', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46252', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46253', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46254', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46255', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46256', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46258', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46260', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46261', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46262', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46263', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46264', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46265', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46266', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46267', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46268', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46269', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46270', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46271', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46272', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46273', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46274', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46275', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46276', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46277', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46279', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46280', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46281', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46282', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46283', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46284', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46285', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46286', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46287', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46288', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46289', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46290', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46291', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46292', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46293', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46295', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46296', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46297', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46298', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46299', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46300', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46301', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46302', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46303', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46304', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46305', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46306', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46307', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46308', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46309', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46310', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46311', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46312', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46314', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46316', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46317', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46318', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46319', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46320', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46321', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46322', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46323', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46324', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46325', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46326', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46327', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46328', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46329', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46330', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46331', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46332', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46333', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46334', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46335', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46336', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46339', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46340', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46341', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46342', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46343', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46344', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46345', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46346', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46347', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46349', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46350', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46351', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46352', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46353', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46354', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46355', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46356', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46357', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46358', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46359', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46360', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46361', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46362', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46363', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46364', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46365', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46366', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46367', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46368', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46369', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46370', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46371', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46372', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46374', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46375', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46376', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46377', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46378', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46379', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46380', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46382', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46383', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46384', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46385', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46386', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46387', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46388', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46389', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46390', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46391', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46392', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46393', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46394', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46395', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46396', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46397', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46398', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46399', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46400', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46401', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46402', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46403', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46404', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46405', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46406', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46407', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46409', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46410', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46411', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46412', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46413', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46415', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46416', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46418', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46419', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46420', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46421', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46422', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46423', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46424', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46425', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46426', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46427', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46428', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46429', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46430', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46431', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46432', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46433', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46434', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46435', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46436', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46437', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46438', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46439', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46440', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46441', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46442', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46443', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46444', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46445', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46446', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46447', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46450', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46451', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46452', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46453', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46454', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46455', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46456', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46457', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46459', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46460', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46461', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46462', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46463', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46464', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46466', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46467', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46468', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46469', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46470', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46471', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46472', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46473', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46475', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46476', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46477', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46478', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46479', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46480', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46481', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46482', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46483', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46484', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46485', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46486', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46487', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46488', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46489', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46490', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46491', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46492', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46493', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46494', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46495', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46498', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46499', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46500', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46501', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46502', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46503', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46506', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46507', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46508', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46509', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46510', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46511', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46512', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46513', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46515', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46516', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46517', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46518', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46519', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46520', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46521', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46522', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46523', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46524', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46525', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46526', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46527', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46528', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46529', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46530', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46531', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46532', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46533', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46534', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46535', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46536', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46537', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46538', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46539', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46540', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46541', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46542', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46543', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46544', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46545', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46546', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46547', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46548', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46549', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46550', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46551', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46552', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46553', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46554', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46555', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46556', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46557', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46558', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46559', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46560', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46561', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46562', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46563', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46564', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46565', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46566', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46567', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46568', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46569', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46570', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46571', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46572', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46573', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46574', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46575', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46576', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46577', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46578', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46579', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46580', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46581', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46582', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46583', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46584', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46585', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46586', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46587', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46588', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46589', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46590', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46591', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46592', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46593', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46594', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46595', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46596', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46597', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46598', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46599', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46600', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46601', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46602', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46603', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46604', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46605', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46606', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46607', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46608', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46609', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46610', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46611', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46612', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46613', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46614', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46615', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46616', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46617', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46618', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46619', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46620', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46621', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46622', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46623', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46624', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46625', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46626', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46627', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46628', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46629', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46630', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46631', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46632', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46633', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46634', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46635', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46636', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46637', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46638', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46639', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46640', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46641', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46642', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46643', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46644', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46645', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46646', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46647', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46648', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46649', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46650', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46651', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46652', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46653', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46654', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46655', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46657', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46658', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46659', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46660', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46662', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46664', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46665', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '46667', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47000', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47001', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47002', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47004', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47005', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47006', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47007', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47008', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47009', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47011', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47012', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47013', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47014', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47015', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47016', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47017', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47018', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47019', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47020', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47021', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47022', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47023', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47024', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47025', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47026', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47027', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47028', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47029', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47030', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47031', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47032', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47033', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47034', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47035', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47037', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47038', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47039', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47040', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47041', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47042', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47043', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47044', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47045', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47046', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47047', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47048', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47049', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47050', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47051', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47052', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47053', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47054', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47055', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47056', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47057', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47058', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47059', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47060', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47061', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47062', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47063', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47064', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47065', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47066', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47067', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47068', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47069', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47070', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47071', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47072', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47073', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47074', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47075', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47076', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47077', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47078', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47079', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47080', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47081', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47082', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47083', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47084', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47085', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47086', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47087', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47088', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47089', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47090', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47091', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47092', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47093', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47094', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47095', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47096', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47097', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47098', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47099', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47100', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47101', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47102', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47103', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47104', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47105', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47106', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47107', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47108', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47109', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47110', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47111', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47112', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47113', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47114', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47115', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47118', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47119', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47120', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47121', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47122', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47123', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47124', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47125', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47126', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47127', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47128', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47130', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47131', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47132', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47133', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47134', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47135', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47136', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47137', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47138', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47139', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47140', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47141', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47142', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47143', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47144', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47145', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47146', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47147', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47148', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47149', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47150', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47151', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47152', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47153', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47154', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47155', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47156', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47157', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47158', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47159', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47160', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47161', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47162', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47163', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47164', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47165', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47166', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47167', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47168', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47169', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47170', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47171', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47172', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47173', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47174', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47175', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47176', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47177', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47178', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47179', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47180', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47181', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47182', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47183', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47184', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47185', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47186', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47187', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47188', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47189', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47190', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47191', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47192', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47193', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47194', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47195', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47196', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47197', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47198', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47199', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47200', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47201', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47202', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47204', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47205', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47206', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47207', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47208', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47209', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47210', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47211', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47212', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47213', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47214', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47215', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47216', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47217', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47218', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47219', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47220', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47221', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47222', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47223', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47224', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47225', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47226', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47227', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47228', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47229', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47230', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47231', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47232', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47233', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47234', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47235', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47236', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47237', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47238', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47239', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47240', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47241', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47242', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47244', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47245', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47246', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47247', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47248', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47249', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47250', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47251', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47252', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47253', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47255', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '47264', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48000', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48001', 'E', 'EMERGENCY DPT', 'HP CLSC ET CTR HB DE ROBERVAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48002', 'E', 'EMERGENCY DPT', 'HPITAL D''AMQUI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48003', 'E', 'EMERGENCY DPT', 'HPITAL RGIONAL DE RIMOUSKI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48004', 'E', 'EMERGENCY DPT', 'CH RGIONAL DU GRAND-PORTAGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48005', 'E', 'EMERGENCY DPT', 'HPITAL DE MATANE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48006', 'E', 'EMERGENCY DPT', 'CLSC DE POHENEGAMOOK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48007', 'E', 'EMERGENCY DPT', 'HPITAL DE NOTRE-DAME-DU-LAC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48008', 'E', 'EMERGENCY DPT', 'CENTRE HOSPITALIER TROIS-PISTOLES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48009', 'E', 'EMERGENCY DPT', 'HPITAL NOTRE-DAME-DE-FATIMA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48010', 'E', 'EMERGENCY DPT', 'HPITAL DE CHICOUTIMI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48011', 'E', 'EMERGENCY DPT', 'HPITAL DE DOLBEAU-MISTASSINI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48012', 'E', 'EMERGENCY DPT', 'HPITAL D''ALMA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48013', 'E', 'EMERGENCY DPT', 'HPITAL DE LA BAIE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48014', 'E', 'EMERGENCY DPT', 'HPITAL ET CR DE JONQUIRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48015', 'E', 'EMERGENCY DPT', 'HPITAL JEFFERY HALE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48016', 'E', 'EMERGENCY DPT', 'HPITAL DE LA MALBAIE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48017', 'E', 'EMERGENCY DPT', 'HPITAL DE L''ENFANT-JSUS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48018', 'E', 'EMERGENCY DPT', 'HPITAL DU SAINT-SACREMENT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48019', 'E', 'EMERGENCY DPT', 'PAVILLON L''HTEL-DIEU DE QUBEC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48020', 'E', 'EMERGENCY DPT', 'PAVILLON CH DE LUNIVERSIT LAVAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48021', 'E', 'EMERGENCY DPT', 'HPITAL DU SAINT-SACREMENT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48022', 'E', 'EMERGENCY DPT', 'HP RG DE PORTNEUF/CLSC ST-RAYMOND', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48023', 'E', 'EMERGENCY DPT', 'HPITAL CHAUVEAU', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48024', 'E', 'EMERGENCY DPT', 'HPITAL DE SAINTE-ANNE-DE-BEAUPR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48025', 'E', 'EMERGENCY DPT', 'HTEL-DIEU D''ARTHABASKA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48026', 'E', 'EMERGENCY DPT', 'HPITAL SAINTE-CROIX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48027', 'E', 'EMERGENCY DPT', 'CLSC CTR HB HP CLOUTIER-DU-RIVAGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48028', 'E', 'EMERGENCY DPT', 'CSSS DU HAUT-SAINT-MAURICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48029', 'E', 'EMERGENCY DPT', 'CLSC CTR HB LA PETITE-NATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48030', 'E', 'EMERGENCY DPT', 'HPITAL DU CENTRE-DE-LA-MAURICIE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48031', 'E', 'EMERGENCY DPT', 'PAVILLON SAINTE-MARIE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48032', 'E', 'EMERGENCY DPT', 'CMSSS CHRIST-ROI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48033', 'E', 'EMERGENCY DPT', 'CHUS - HPITAL FLEURIMONT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48034', 'E', 'EMERGENCY DPT', 'CHUS - HTEL-DIEU DE SHERBROOKE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48035', 'E', 'EMERGENCY DPT', 'CSSS DE MEMPHRMAGOG', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48036', 'E', 'EMERGENCY DPT', 'HP CLSC ET CTR HB DASBESTOS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48037', 'E', 'EMERGENCY DPT', 'CSSS DE LA MRC-DE COATICOOK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48038', 'E', 'EMERGENCY DPT', 'CSSS DU GRANIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48039', 'E', 'EMERGENCY DPT', 'HP DE SOINS PSY DE LEST-DE-MTL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48040', 'E', 'EMERGENCY DPT', 'HPITAL GNRAL DU LAKESHORE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48041', 'E', 'EMERGENCY DPT', 'HPITAL SANTA CABRINI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48042', 'E', 'EMERGENCY DPT', 'INSTITUT DE CARDIOLOGIE DE MONTRAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48043', 'E', 'EMERGENCY DPT', 'HPITAL DU SACR-COEUR DE MONTRAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48044', 'E', 'EMERGENCY DPT', 'HP SANT MENTALE ALBERT-PRVOST', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48045', 'E', 'EMERGENCY DPT', 'HPITAL GNRAL DE MONTRAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48046', 'E', 'EMERGENCY DPT', 'HPITAL FLEURY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48047', 'E', 'EMERGENCY DPT', 'HPITAL JEAN-TALON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48048', 'E', 'EMERGENCY DPT', 'HPITAL GNRAL JUIF', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48049', 'E', 'EMERGENCY DPT', 'HPITAL DE LACHINE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48050', 'E', 'EMERGENCY DPT', 'CHU SAINTE-JUSTINE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48051', 'E', 'EMERGENCY DPT', 'CENTRE HOSPITALIER DE ST. MARY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48052', 'E', 'EMERGENCY DPT', 'HPITAL MAISONNEUVE-ROSEMONT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48053', 'E', 'EMERGENCY DPT', 'HPITAL DOUGLAS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48054', 'E', 'EMERGENCY DPT', 'HPITAL DE VERDUN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48055', 'E', 'EMERGENCY DPT', 'HTEL-DIEU DU CHUM', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48056', 'E', 'EMERGENCY DPT', 'HPITAL NOTRE-DAME DU CHUM', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48057', 'E', 'EMERGENCY DPT', 'HPITAL SAINT-LUC DU CHUM', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48058', 'E', 'EMERGENCY DPT', 'HPITAL DE MONTRAL POUR ENFANTS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48059', 'E', 'EMERGENCY DPT', 'HPITAL ROYAL VICTORIA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48060', 'E', 'EMERGENCY DPT', 'HPITAL DE LASALLE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48061', 'E', 'EMERGENCY DPT', 'HPITAL DE PAPINEAU', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48062', 'E', 'EMERGENCY DPT', 'HPITAL DU PONTIAC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48063', 'E', 'EMERGENCY DPT', 'CLSC DE MANSFIELD ET PONTEFRACT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48064', 'E', 'EMERGENCY DPT', 'HPITAL DE GATINEAU', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48065', 'E', 'EMERGENCY DPT', 'HPITAL DE HULL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48066', 'E', 'EMERGENCY DPT', 'HPITAL DE MANIWAKI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48067', 'E', 'EMERGENCY DPT', 'HPITAL D''AMOS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48068', 'E', 'EMERGENCY DPT', 'HPITAL DE ROUYN-NORANDA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48069', 'E', 'EMERGENCY DPT', 'PT SERV TMISCAMING-ET-DE-KIPAWA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48070', 'E', 'EMERGENCY DPT', 'PAVILLON STE-FAMILLE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48071', 'E', 'EMERGENCY DPT', 'CSCD LA SARRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48072', 'E', 'EMERGENCY DPT', 'HP ET CENTRE RADAPT DP VAL-DOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48073', 'E', 'EMERGENCY DPT', 'HPITAL ET CTR HB DE SEPT-LES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48074', 'E', 'EMERGENCY DPT', 'HPITAL LE ROYER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48075', 'E', 'EMERGENCY DPT', 'CSSS H-CTE-NORD (PAV ESCOUMINS)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48076', 'E', 'EMERGENCY DPT', 'CSSS H-CTE-NORD (PAV FORESTVILLE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48077', 'E', 'EMERGENCY DPT', 'CSSS DE LA MINGANIE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48081', 'E', 'EMERGENCY DPT', 'HPITAL DE L''ARCHIPEL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48082', 'E', 'EMERGENCY DPT', 'HPITAL DE MARIA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48083', 'E', 'EMERGENCY DPT', 'CLSC DE PASPBIAC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48084', 'E', 'EMERGENCY DPT', 'HPITAL DE GASP', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48085', 'E', 'EMERGENCY DPT', 'CLSC DE GRANDE-VALLE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48086', 'E', 'EMERGENCY DPT', 'CLSC DE MURDOCHVILLE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48087', 'E', 'EMERGENCY DPT', 'HPITAL DE SAINTE-ANNE-DES-MONTS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48088', 'E', 'EMERGENCY DPT', 'HPITAL DE CHANDLER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48089', 'E', 'EMERGENCY DPT', 'HTEL-DIEU DE LVIS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48090', 'E', 'EMERGENCY DPT', 'CTR PAUL-GILBERT- CTR HB CHARNY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48091', 'E', 'EMERGENCY DPT', 'HPITAL DE THETFORD MINES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48092', 'E', 'EMERGENCY DPT', 'HPITAL DE MONTMAGNY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48093', 'E', 'EMERGENCY DPT', 'HPITAL DE ST-GEORGES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48094', 'E', 'EMERGENCY DPT', 'HPITAL CIT DE LA SANT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48095', 'E', 'EMERGENCY DPT', 'HPITAL PIERRE-LE GARDEUR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48096', 'E', 'EMERGENCY DPT', 'CH RGIONAL DE LANAUDIRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48097', 'E', 'EMERGENCY DPT', 'HPITAL DE SAINT-JRME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48098', 'E', 'EMERGENCY DPT', 'HPITAL DE SAINT-EUSTACHE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48099', 'E', 'EMERGENCY DPT', 'CMSSS D''ARGENTEUIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48100', 'E', 'EMERGENCY DPT', 'HPITAL DE MONT-LAURIER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48101', 'E', 'EMERGENCY DPT', 'CENTRE DE SERVICES DE RIVIRE-ROUGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48102', 'E', 'EMERGENCY DPT', 'HPITAL LAURENTIEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48103', 'E', 'EMERGENCY DPT', 'HPITAL HONOR-MERCIER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48104', 'E', 'EMERGENCY DPT', 'HPITAL BARRIE MEMORIAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48105', 'E', 'EMERGENCY DPT', 'HPITAL BROME-MISSISQUOI-PERKINS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48106', 'E', 'EMERGENCY DPT', 'HPITAL DU HAUT-RICHELIEU', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48107', 'E', 'EMERGENCY DPT', 'HPITAL DE GRANBY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48108', 'E', 'EMERGENCY DPT', 'HPITAL CHARLES-LEMOYNE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48109', 'E', 'EMERGENCY DPT', 'HPITAL DU SUROT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48110', 'E', 'EMERGENCY DPT', 'HTEL-DIEU DE SOREL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48111', 'E', 'EMERGENCY DPT', 'HPITAL PIERRE-BOUCHER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48112', 'E', 'EMERGENCY DPT', 'HPITAL ANNA-LABERGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48113', 'E', 'EMERGENCY DPT', 'HP MMORIAL DE WAKEFIELD MEM HOSP', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48114', 'E', 'EMERGENCY DPT', 'HPITAL DE BAIE-SAINT-PAUL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48115', 'E', 'EMERGENCY DPT', 'IU CARDIOLOGIE ET PNEUMOLOGIE DE QC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48116', 'E', 'EMERGENCY DPT', 'CMSSS DE FORTIERVILLE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48117', 'E', 'EMERGENCY DPT', 'CSSS DE PORT-CARTIER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48118', 'E', 'EMERGENCY DPT', 'CSSS DE LA BASSE-CTE-NORD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48119', 'E', 'EMERGENCY DPT', 'CSSS DE L''HMATITE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48120', 'E', 'EMERGENCY DPT', 'PAVILLON L''HTEL-DIEU DE QUBEC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48121', 'E', 'EMERGENCY DPT', 'CMSSS AVELLIN-DALCOURT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48163', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48365', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48366', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48367', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48368', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48371', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '48383', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49000', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49001', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49002', '8', 'HOME CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49003', '5', 'INPT MENTAL', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49004', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49005', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49006', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49007', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49008', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49009', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49010', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49011', 'A', 'DAY SURGERY', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49012', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49013', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49014', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49015', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49016', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49017', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49018', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49019', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49020', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49021', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49022', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49023', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49024', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49025', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49026', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49027', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49029', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49030', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49031', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49032', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49033', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49034', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49035', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49036', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49037', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49038', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49039', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49040', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49041', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49042', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49043', '1', 'ACUTE INPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49044', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49045', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49046', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49047', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49048', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49049', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49050', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49051', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49052', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49053', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49054', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49055', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49056', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49057', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49058', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49059', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49060', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49061', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49062', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49063', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49064', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49065', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49066', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49067', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49068', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49069', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49070', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49071', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49072', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49074', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49075', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49077', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49078', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49079', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49080', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49081', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49082', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49083', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49084', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49085', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49086', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49087', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49088', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49089', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49090', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49091', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49092', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49093', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49094', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49095', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49096', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49097', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49098', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49099', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49100', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49101', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49102', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49103', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49104', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49105', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49106', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49107', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49108', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49109', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49110', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49111', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49112', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49113', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49114', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49115', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49116', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49117', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49118', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49119', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49120', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49121', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49122', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49123', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49124', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49125', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49126', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49127', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49128', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49129', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49130', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49131', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49132', '4', 'LT CARE', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49133', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49134', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49135', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49136', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49137', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49138', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49139', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49140', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49141', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49142', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49143', '2', 'INPT REHAB', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49144', '3', 'INPT CCC', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49145', '0', 'COMMUNITY CLIN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49146', 'E', 'EMERGENCY DPT', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49990', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49991', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('QC', '49998', 'U', 'UNKNOWN', '', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50001', '1', 'ACUTE INPT', 'ACTIVE TREATMENT HOSP-ONT-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50002', '2', 'INPT REHAB', 'GENERAL REHAB HOSP-ONT-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50003', '3', 'INPT CCC', 'CHRONIC HOSPITAL - ONT - GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50004', '4', 'LT CARE', 'NURSING HOME - ONTARIO - GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50005', '5', 'INPT MENTAL', 'PSYCHIATRIC HOSPITAL-ONT-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50006', 'U', 'UNKNOWN', 'UNCLASSIFIED HLTH INST-ONT-GENERIC#', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50007', '2', 'INPT REHAB', 'SPECIAL REHAB HOSP-ONT-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50008', '8', 'HOME CARE', 'HOME CARE PROGRAM-ONTARIO-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50009', 'G', 'GROUP/SUPPORT', 'HOME FOR THE AGED-ONTARIO-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50010', 'F', 'OTHER HEALTH', 'MIDWIFE-ONTARIO-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50011', 'H', 'TRANSIT HOUSE', 'TRANSIT.HOUSING/SHELTER ON-GENERIC#', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50012', 'M', 'COMM MH ADDICT', 'COMMUNITY BASED MENTAL HLTH-ON GEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50013', 'P', 'HOSPICE/PALTIV', 'HOSPICE/PALLIATIVE CARE FAC. ON GEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50014', 'G', 'GROUP/SUPPORT', 'GROUP LIVING/SUPP HOUSING - ON GEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50015', 'T', 'MH/ADDICT RX', 'DETOXIFICATION CENTRE -ON-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50016', 'J', 'OTH NON-HEALTH', 'CHILDREN AID SOCIETY-ON-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '50017', '0', 'COMMUNITY CLIN', 'COMM. BASED CLINIC -ON-GENERIC #', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51002', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-BRANTFO', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51005', 'G', 'GROUP/SUPPORT', 'BRANTWOOD RESIDENTIAL DEVT CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51011', 'G', 'GROUP/SUPPORT', 'JOHN NOBLE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51024', '4', 'LT CARE', 'PARKVIEW MANOR HEALTH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51030', '1', 'ACUTE INPT', 'GREY BRUCE HLTH SERVICES-LIONS HEAD', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51031', '4', 'LT CARE', 'PINECREST MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51034', '4', 'LT CARE', 'SOUTHAMPTON CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51035', 'G', 'GROUP/SUPPORT', 'BRUCELEA HAVEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51040', 'G', 'GROUP/SUPPORT', 'GATEWAY HAVEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51048', 'G', 'GROUP/SUPPORT', 'DUFFERIN OAKS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51052', 'G', 'GROUP/SUPPORT', 'BOBIER VILLA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51053', '4', 'LT CARE', 'CARESSANT CARE ON MARY BUCKE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51056', 'G', 'GROUP/SUPPORT', 'ELGIN MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51059', '1', 'ACUTE INPT', 'ST THOMAS-ELGIN GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51060', '3', 'INPT CCC', 'ST THOMAS-ELGIN GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51065', '4', 'LT CARE', 'RICHMOND TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51066', '4', 'LT CARE', 'ILER LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51067', '1', 'ACUTE INPT', 'ERIE SHORES HEALTHCARE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51068', '3', 'INPT CCC', 'ERIE SHORES HEALTHCARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51069', '4', 'LT CARE', 'FRANKLIN GARDENS LTC HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51071', 'G', 'GROUP/SUPPORT', 'SUN PARLOR HOME FOR SENIOR CITIZENS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51072', 'G', 'GROUP/SUPPORT', 'ALEXANDER HALL CNIB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51074', '4', 'LT CARE', 'BERKSHIRE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51075', '4', 'LT CARE', 'BROUILLETTE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51079', '1', 'ACUTE INPT', 'WINDSOR REGIONAL HOSP-METROPOLITAN', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51080', 'T', 'MH/ADDICT RX', 'WINDSOR MEN''S DETOXIFICATION CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51083', '4', 'LT CARE', 'BANWELL GARDENS CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51093', '4', 'LT CARE', 'COUNTRY VILLAGE HEALTH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51094', 'G', 'GROUP/SUPPORT', 'FAIRMOUNT HOME FOR THE AGED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51096', '4', 'LT CARE', 'EXTENDICARE/KINGSTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51106', 'G', 'GROUP/SUPPORT', 'ONGWANADA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51108', 'G', 'GROUP/SUPPORT', 'PROVIDENCE CARE CTR-PROVIDENCE MANO', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51109', 'G', 'GROUP/SUPPORT', 'QUINTE ST LAWRENCE HALL CNIB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51110', '2', 'INPT REHAB', 'HOTEL DIEU HOSP - CHILD DEVELOP CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51111', 'G', 'GROUP/SUPPORT', 'RIDEAUCREST HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51112', '3', 'INPT CCC', 'PROVIDENCE CARE HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51115', '4', 'LT CARE', 'COUNTRY LANE LTC RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51116', '5', 'INPT MENTAL', 'HINCKS DELLCREST CENTRE (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51117', '5', 'INPT MENTAL', 'KERRY''S PLACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51124', '1', 'ACUTE INPT', 'HANOVER AND DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51126', '4', 'LT CARE', 'CENTRAL PARK LODGE-HANOVER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51129', 'G', 'GROUP/SUPPORT', 'GREY GABLES HOME FOR THE AGED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51132', '4', 'LT CARE', 'MEAFORD LONG TERM CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51137', 'G', 'GROUP/SUPPORT', 'LEE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51141', '4', 'LT CARE', 'VERSA-CARE SUMMIT PLACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51143', '4', 'LT CARE', 'ERRINRUNG NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51145', 'G', 'GROUP/SUPPORT', 'GRANDVIEW LODGE/DUNNVILLE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51146', '1', 'ACUTE INPT', 'HALDIMAND WAR MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51147', '3', 'INPT CCC', 'HALDIMAND WAR MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51149', '1', 'ACUTE INPT', 'WEST HALDIMAND GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51152', '5', 'INPT MENTAL', 'BROWNDALE ONTARIO', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51154', 'G', 'GROUP/SUPPORT', 'HYLAND CREST SENIOR CITIZEN''S HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51156', '4', 'LT CARE', 'WELLINGTON PARK CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51160', '1', 'ACUTE INPT', 'JOSEPH BRANT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51161', '3', 'INPT CCC', 'JOSEPH BRANT HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51162', '4', 'LT CARE', 'MAPLE VILLA LONG TERM CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51165', 'G', 'GROUP/SUPPORT', 'ALLENDALE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51169', '4', 'LT CARE', 'MOUNT NEMO CHRISTIAN NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51175', 'G', 'GROUP/SUPPORT', 'HASTINGS CENTENNIAL MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51183', 'G', 'GROUP/SUPPORT', 'HASTINGS MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51186', '4', 'LT CARE', 'WESTGATE LODGE NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51188', '4', 'LT CARE', 'FRIENDLY MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51190', 'G', 'GROUP/SUPPORT', 'PLAINFIELD COMMUNITY HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51191', '4', 'LT CARE', 'STIRLING MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51193', '1', 'ACUTE INPT', 'CANADIAN FORCES HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51195', '4', 'LT CARE', 'TRENT VALLEY LODGE NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51199', '1', 'ACUTE INPT', 'CLINTON PUBLIC HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51200', '3', 'INPT CCC', 'CLINTON PUBLIC HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51202', 'G', 'GROUP/SUPPORT', 'HURONVIEW', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51203', '1', 'ACUTE INPT', 'SOUTH HURON HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51204', '3', 'INPT CCC', 'SOUTH HURON HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51205', '4', 'LT CARE', 'FORDWICH VILLAGE NURSING HOME (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51206', '1', 'ACUTE INPT', 'ALEXANDRA MARINE & GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51210', '4', 'LT CARE', 'MAITLAND MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51211', '4', 'LT CARE', 'QUEENSWAY NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51213', '1', 'ACUTE INPT', 'SEAFORTH COMMUNITY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51214', '3', 'INPT CCC', 'SEAFORTH COMMUNITY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51215', '4', 'LT CARE', 'SEAFORTH MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51217', '1', 'ACUTE INPT', 'WINGHAM AND DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51218', '3', 'INPT CCC', 'WINGHAM AND DISTRICT HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51219', 'G', 'GROUP/SUPPORT', 'BLUEWATER REST HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51221', '5', 'INPT MENTAL', 'SOUTHWESTERN REGIONAL CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51222', '4', 'LT CARE', 'COPPER TERRACE LTC FACILITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51226', '2', 'INPT REHAB', 'PRISM CTR AUDIOLOGY&CHILDREN''S REHA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51236', '4', 'LT CARE', 'TILBURY MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51240', 'G', 'GROUP/SUPPORT', 'NORTH LAMBTON LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51242', '4', 'LT CARE', 'FIDDICK''S NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51243', 'G', 'GROUP/SUPPORT', 'LAMBTON MEADOWVIEW VILLA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51244', '4', 'LT CARE', 'VISION NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51246', '2', 'INPT REHAB', 'PATHWAYS HEALTH CENTRE FOR CHILDREN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51250', '4', 'LT CARE', 'SUMAC LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51252', '4', 'LT CARE', 'TRILLIUM VILLA NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51253', '4', 'LT CARE', 'WATFORD NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51254', '1', 'ACUTE INPT', 'ALMONTE GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51255', '4', 'LT CARE', 'ALMONTE COUNTRY HAVEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51256', '1', 'ACUTE INPT', 'CARLETON PLACE & DISTRICT MEM. HOSP', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51259', '4', 'LT CARE', 'STONERIDGE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51264', 'G', 'GROUP/SUPPORT', 'LANARK LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51265', '4', 'LT CARE', 'PERTH COMMUNITY CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51268', '4', 'LT CARE', 'BROADVIEW NURSING CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51269', '1', 'ACUTE INPT', 'PERTH&SMITHS FALLS DIST-SMITHS FALL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51272', 'G', 'GROUP/SUPPORT', 'MAPLE VIEW LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51273', '1', 'ACUTE INPT', 'BROCKVILLE GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51278', '4', 'LT CARE', 'SHERWOOD PARK MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51279', 'G', 'GROUP/SUPPORT', 'ST LAWRENCE LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51282', '4', 'LT CARE', 'ROSEBRIDGE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51284', '1', 'ACUTE INPT', 'KEMPTVILLE DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51285', '3', 'INPT CCC', 'KEMPTVILLE DISTRICT HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51288', '4', 'LT CARE', 'HILLTOP MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51290', '4', 'LT CARE', 'WELLINGTON HOUSE NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51291', '4', 'LT CARE', 'CARVETH CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51295', '1', 'ACUTE INPT', 'LENNOX & ADDINGTON COUNTY GEN. HOSP', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51296', '3', 'INPT CCC', 'LENNOX & ADDINGTON COUNTY GEN. HOSP', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51300', 'T', 'MH/ADDICT RX', 'TORONTO EAST HEALTH NETWORK - DETOX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51302', '1', 'ACUTE INPT', 'TOR. EAST HLTH NTWRK-MICHAEL GARRON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51305', '4', 'LT CARE', 'EATONVILLE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51306', '4', 'LT CARE', 'GARDEN COURT NURSING HOME(ETOBICOKE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51307', 'G', 'GROUP/SUPPORT', 'IVAN FRANKO HOME (ETOBICOKE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51308', 'G', 'GROUP/SUPPORT', 'KIPLING ACRES  (ETOBICOKE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51310', '5', 'INPT MENTAL', 'TURNING POINT YOUTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51313', '5', 'INPT MENTAL', 'THISTLETOWN REGIONAL CTR(ETOBICOKE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51315', '3', 'INPT CCC', 'BAYCREST HOSPITAL (NORTH YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51316', '4', 'LT CARE', 'EXTENDICARE/BAYVIEW (NORTH YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51318', 'G', 'GROUP/SUPPORT', 'CAREFREE LODGE  (NORTH YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51320', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-CHELTEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51321', 'G', 'GROUP/SUPPORT', 'CUMMER LODGE (NORTH YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51322', '5', 'INPT MENTAL', 'DELLCREST CHILDRENS CTR(NORTH YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51324', '4', 'LT CARE', 'DOWNSVIEW LONG TERM CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51325', '4', 'LT CARE', 'CHARTWELL GIBSON LONG TERM CARE RES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51326', 'G', 'GROUP/SUPPORT', 'THE JEWISH HOME FOR THE AGED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51328', '4', 'LT CARE', 'NORTH PARK NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51330', '1', 'ACUTE INPT', 'NORTH YORK GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51331', '4', 'LT CARE', 'HAWTHORNE PLACE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51332', '1', 'ACUTE INPT', 'DON MILLS SURGICAL UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51338', '3', 'INPT CCC', 'ST JOSEPH''S INFIRMARY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51341', 'G', 'GROUP/SUPPORT', 'THOMPSON HOUSE (NORTH YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51344', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-ALTAMON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51345', 'G', 'GROUP/SUPPORT', 'BENDALE ACRES (SCARBOROUGH)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51348', '4', 'LT CARE', 'CRAIGLEE NURSING HOME (SCARBOROUGH)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51349', '4', 'LT CARE', 'EXTENDICARE/SCARBOROUGH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51351', '4', 'LT CARE', 'EXTENDICARE/GUILDWOOD (SCARBOROUGH)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51352', '4', 'LT CARE', 'KENNEDY LODGE NURSING HOME (SCARBOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51358', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-ROCKCLI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51359', '5', 'INPT MENTAL', 'SACRED HEART CHILD AND FAMILY CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51370', '4', 'LT CARE', 'VERMONT SQUARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51372', 'G', 'GROUP/SUPPORT', 'BELLWOODS PARK HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51373', 'G', 'GROUP/SUPPORT', 'BELMONT HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51374', '4', 'LT CARE', 'MAIN STREET TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51385', '5', 'INPT MENTAL', 'CENTRAL TORONTO YOUTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51396', '5', 'INPT MENTAL', 'EARLSCOURT CHILD & FAMILY CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51401', 'G', 'GROUP/SUPPORT', 'FUDGER HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51402', '4', 'LT CARE', 'HERITAGE NURSING HOME (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51405', '5', 'INPT MENTAL', 'C M HINCKS TREATMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51406', '1', 'ACUTE INPT', 'THE HOSPITAL FOR SICK CHILDREN', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51407', '5', 'INPT MENTAL', 'YOUTHLINKS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51408', 'G', 'GROUP/SUPPORT', 'INA GRAFTON GAGE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51412', '5', 'INPT MENTAL', 'JEWISH FAMILY AND CHILD SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51416', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-ST.GEOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51419', '4', 'LT CARE', 'MAYNARD NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51421', 'G', 'GROUP/SUPPORT', 'MC LEOD HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51424', 'G', 'GROUP/SUPPORT', 'NISBET LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51425', '4', 'LT CARE', 'NORWOOD NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51427', '5', 'INPT MENTAL', 'OOLAGEN COMMUNITY SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51430', '4', 'LT CARE', 'ELM GROVE LIVING CENTRE INC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51441', '3', 'INPT CCC', 'RUNNYMEDE HEALTHCARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51456', 'G', 'GROUP/SUPPORT', 'TRUE DAVIDSON ACRES (EAST YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51457', '4', 'LT CARE', 'TYNDALL NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51460', 'T', 'MH/ADDICT RX', 'TORONTO WESTERN HOSPITAL DETOX UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51461', '5', 'INPT MENTAL', 'WEST END CRECHE CHILD&FAMILY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51462', '4', 'LT CARE', 'CHARTWELL WHITE EAGLE LTC RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51465', '5', 'INPT MENTAL', 'YOUTHDALE RESD TREAT CTR-VICTORIA S', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51467', '4', 'LT CARE', 'CEDARVALE TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51469', '3', 'INPT CCC', 'WEST PARK HEALTHCARE CTR (YORK CITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51471', '2', 'INPT REHAB', 'WEST PARK HEALTHCARE CTR (YORK CITY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51472', '4', 'LT CARE', 'CRAIGHOLME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51473', '5', 'INPT MENTAL', 'CRAIGWOOD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51475', '4', 'LT CARE', 'MIDDLESEX TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51476', '4', 'LT CARE', 'COUNTRY TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51481', 'T', 'MH/ADDICT RX', 'CHILD & PARENT RESOURCES INSTITUTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51483', 'G', 'GROUP/SUPPORT', 'DEARNESS HOME FOR SENIOR CITIZENS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51484', 'T', 'MH/ADDICT RX', 'ST.JOSEPH''S HEALTH CARE,LONDON DETO', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51485', '4', 'LT CARE', 'EXTENDICARE/LONDON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51487', '2', 'INPT REHAB', 'THAMES VALLEY CHILDRENS TRTMNT CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51489', '5', 'INPT MENTAL', 'MADAME VANIER CHILDRENS SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51497', '1', 'ACUTE INPT', 'ST.JOSEPH''S HEALTH CARE,LONDON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51499', 'G', 'GROUP/SUPPORT', 'TWEEDSMUIR HALL CNIB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51507', '1', 'ACUTE INPT', 'FOUR COUNTIES HEALTH SERVICES CORP', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51510', '4', 'LT CARE', 'CHELSEY PARK (OXFORD) NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51515', '1', 'ACUTE INPT', 'STRATHROY MIDDLESEX GENERAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51520', '4', 'LT CARE', 'BABCOCK COMMUNITY CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51522', 'G', 'GROUP/SUPPORT', 'PINES (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51531', 'G', 'GROUP/SUPPORT', 'ALBRIGHT GARDENS HOMES INCORPORATED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51535', '4', 'LT CARE', 'CRESCENT PARK LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51536', '4', 'LT CARE', 'KILEAN LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51540', 'G', 'GROUP/SUPPORT', 'DORCHESTER MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51545', '4', 'LT CARE', 'OAKWOOD PARK LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51546', 'G', 'GROUP/SUPPORT', 'R. H. LAWSON EVENTIDE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51547', '4', 'LT CARE', 'CHARTWELL NIAGARA LTC RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51554', '4', 'LT CARE', 'WEST PARK HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51555', '4', 'LT CARE', 'EXTENDICARE/ST CATHARINES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51556', '4', 'LT CARE', 'HEIDEHOF LONG TERM CARE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51558', 'G', 'GROUP/SUPPORT', 'INA GRAFTON-GAGE HOME (NIAGARA)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51559', 'G', 'GROUP/SUPPORT', 'LINHAVEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51560', 'G', 'GROUP/SUPPORT', 'LINWELL HALL CNIB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51561', '4', 'LT CARE', 'GARDEN CITY MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51564', '2', 'INPT REHAB', 'NIAGARA CHILDREN''S CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51569', 'T', 'MH/ADDICT RX', 'NIAGARA HLTH SYSTEM-STCATHARINESGEN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51572', 'G', 'GROUP/SUPPORT', 'TABOR MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51578', 'G', 'GROUP/SUPPORT', 'BETHESDA HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51585', '4', 'LT CARE', 'NIAGARA HEALTH SYSTEM,WELLAND SITE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51587', '4', 'LT CARE', 'CARESSANT CARE COURTLAND', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51588', '4', 'LT CARE', 'DOVER CLIFFS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51591', '1', 'ACUTE INPT', 'NORFOLK GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51592', '3', 'INPT CCC', 'NORFOLK GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51593', '4', 'LT CARE', 'NORFOLK HOSPITAL NURSING HOME (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51597', '1', 'ACUTE INPT', 'CAMPBELLFORD MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51599', '4', 'LT CARE', 'BURNBRAE GARDENS LTC RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51602', 'G', 'GROUP/SUPPORT', 'GOLDEN PLOUGH LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51605', '4', 'LT CARE', 'REGENCY MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51606', '4', 'LT CARE', 'COMMUNITY NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51612', 'G', 'GROUP/SUPPORT', 'LAKEVIEW MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51614', '4', 'LT CARE', 'MARNWOOD LIFECARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51617', '4', 'LT CARE', 'STRATHAVEN LIFECARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51619', '4', 'LT CARE', 'CHARTWELL BON AIR LTC RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51624', '4', 'LT CARE', 'FOSTERBROOKE-LTC FAC NEWCAST', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51627', '4', 'LT CARE', 'EXTENDICARE/OSHAWA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51628', 'G', 'GROUP/SUPPORT', 'HILLSDALE ESTATES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51631', '4', 'LT CARE', 'THORNTON VIEW', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51632', '2', 'INPT REHAB', 'GRANDVIEW REHAB & TREATMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51633', '4', 'LT CARE', 'CHARTWELL BALLYCLIFFE LONG TERM CA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51638', '4', 'LT CARE', 'COMMUNITY NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51646', 'G', 'GROUP/SUPPORT', 'FAIRVIEW LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51647', '4', 'LT CARE', 'SUNNYCREST NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51651', 'G', 'GROUP/SUPPORT', 'BRUYERE CONTINUING CARE INC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51652', '4', 'LT CARE', 'CARLINGVIEW MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51655', 'G', 'GROUP/SUPPORT', 'CARLETON LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51657', '1', 'ACUTE INPT', 'CHEO-OTTAWA CHILDREN''S TRMNT. CTR.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51658', '4', 'LT CARE', 'EXTENDICARE/STARWOOD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51660', 'G', 'GROUP/SUPPORT', 'HILLEL LODGE (THE BESS AND MOE GREE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51661', '1', 'ACUTE INPT', 'HOPITAL MONTFORT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51667', '4', 'LT CARE', 'EXTENDICARE/MEDEX', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51669', 'N', 'AMBULATORY CAR', 'NATIONAL DEFENCE MEDICAL CTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51671', '4', 'LT CARE', 'EXTENDICARE/NEW ORCHARD LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51675', '5', 'INPT MENTAL', 'ROBERTS/SMART CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51681', '1', 'ACUTE INPT', 'QUEENSWAY-CARLETON HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51688', 'G', 'GROUP/SUPPORT', 'ST PATRICK''S HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51692', '4', 'LT CARE', 'SARSFIELD COLONIAL HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51693', 'G', 'GROUP/SUPPORT', 'CENTRE D''ACCUEIL CHAMPLAIN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51696', '1', 'ACUTE INPT', 'ALEXANDRA HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51697', '3', 'INPT CCC', 'ALEXANDRA HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51698', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-OXFORD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51705', '4', 'LT CARE', 'PEOPLECARE TAVISTOCK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51706', '4', 'LT CARE', 'MAPLES HOME FOR SENIORS (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51707', '4', 'LT CARE', 'MAPLE MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51709', '1', 'ACUTE INPT', 'TILLSONBURG DISTRICT MEMORIAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51710', '3', 'INPT CCC', 'TILLSONBURG DISTRICT MEMORIAL HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51716', '1', 'ACUTE INPT', 'WOODSTOCK GENERAL HOSPITAL TRUST', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51717', '3', 'INPT CCC', 'WOODSTOCK GENERAL HOSPITAL TRUST', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51719', 'G', 'GROUP/SUPPORT', 'PEEL MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51722', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-TULLAMO', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51725', '4', 'LT CARE', 'KING NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51727', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-MISSISS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51728', '2', 'INPT REHAB', 'ERINOAK SERV YOUNG PEOP W/PHYS DIS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51729', '4', 'LT CARE', 'COOKSVILLE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51730', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-STREETS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51735', 'G', 'GROUP/SUPPORT', 'SHERIDAN VILLA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51736', '4', 'LT CARE', 'MISSISSAUGA NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51740', '1', 'ACUTE INPT', 'LISTOWEL MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51741', '3', 'INPT CCC', 'LISTOWEL MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51742', 'G', 'GROUP/SUPPORT', 'KNOLLCREST LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51744', 'G', 'GROUP/SUPPORT', 'RITZ LUTHERAN VILLA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51746', '4', 'LT CARE', 'MITCHELL NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51748', '1', 'ACUTE INPT', 'ST MARYS MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51751', '4', 'LT CARE', 'HILLSIDE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51753', 'G', 'GROUP/SUPPORT', 'SPRUCE LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51754', '1', 'ACUTE INPT', 'STRATFORD GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51755', '3', 'INPT CCC', 'STRATFORD GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51756', '4', 'LT CARE', 'PEOPLE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51763', '2', 'INPT REHAB', 'FIVE COUNTIES CHILDRENS CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51764', '4', 'LT CARE', 'EXTENDICARE/PETERBOROUGH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51765', 'G', 'GROUP/SUPPORT', 'FAIRHAVEN HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51768', '1', 'ACUTE INPT', 'PETERBOROUGH REGIONAL HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51769', '3', 'INPT CCC', 'PETERBOROUGH REGIONAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51771', '4', 'LT CARE', 'SPRINGDALE COUNTRY MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51773', '4', 'LT CARE', 'CARESSANT CARE BOURGET', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51776', '4', 'LT CARE', 'ST JACQUES NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51777', '1', 'ACUTE INPT', 'HAWKESBURY & DISTRICT GENERAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51778', '4', 'LT CARE', 'RESIDENCE CHAMPLAIN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51781', '4', 'LT CARE', 'CHARTWELL CHAMPLAIN LTC RESID', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51783', 'G', 'GROUP/SUPPORT', 'PRESCOTT & RUSSELL RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51787', '4', 'LT CARE', 'HALLOWELL HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51789', '4', 'LT CARE', 'KENTWOOD PARK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51791', 'G', 'GROUP/SUPPORT', 'MC FARLAND (H.J.) MEMORIAL HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51798', '4', 'LT CARE', 'WEST LAKE TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51799', '1', 'ACUTE INPT', 'ARNPRIOR REGIONAL HEALTH', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51800', '3', 'INPT CCC', 'ARNPRIOR REGIONAL HEALTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51801', '1', 'ACUTE INPT', 'ST FRANCIS MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51803', '1', 'ACUTE INPT', 'DEEP RIVER AND DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51804', '1', 'ACUTE INPT', 'PEMBROKE REGIONAL HOSPITAL INC.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51805', '3', 'INPT CCC', 'PEMBROKE REG. HOSP. INC. MARIANHILL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51812', 'G', 'GROUP/SUPPORT', 'BONNECHERE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51813', '1', 'ACUTE INPT', 'RENFREW VICTORIA HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51814', '3', 'INPT CCC', 'RENFREW VICTORIA HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51816', '4', 'LT CARE', 'GOOD SAMARITAN NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51817', '1', 'ACUTE INPT', 'STEVENSON MEMORIAL HOSP. ALLISTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51821', '4', 'LT CARE', 'COLEMAN CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51822', '4', 'LT CARE', 'GROVE PARK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51823', 'G', 'GROUP/SUPPORT', 'IOOF HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51824', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-BARRIE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51825', '1', 'ACUTE INPT', 'ROYAL VICTORIA REGIONAL HEALTH CTR', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51827', 'G', 'GROUP/SUPPORT', 'SIMCOE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51829', '1', 'ACUTE INPT', 'CANADIAN ARMED FORCES BASE HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51831', '4', 'LT CARE', 'BAY HAVEN NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51833', '1', 'ACUTE INPT', 'COLLINGWOOD GENERAL & MARINE HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51839', 'G', 'GROUP/SUPPORT', 'SUNSET MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51840', '4', 'LT CARE', 'LEISUREWORLD CAREGIVING CTR-CREEDAN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51844', '1', 'ACUTE INPT', 'GEORGIAN BAY GEN. HOSP-MIDLAND SITE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51846', '4', 'LT CARE', 'VILLA CARE CENTRE (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51847', '4', 'LT CARE', 'OAK TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51852', '5', 'INPT MENTAL', 'HURONIA REGIONAL CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51853', '1', 'ACUTE INPT', 'ORILLIA SOLDIERS'' MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51854', '3', 'INPT CCC', 'ORILLIA SOLDIERS'' MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51856', '5', 'INPT MENTAL', 'NEW PATH YOUTH AND FAMILY SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51857', 'G', 'GROUP/SUPPORT', 'TRILLIUM MANOR HOME FOR THE AGED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51859', 'G', 'GROUP/SUPPORT', 'GEORGIAN MANOR HOME FOR THE AGED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51869', '4', 'LT CARE', 'COMMUNITY NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51870', '1', 'ACUTE INPT', 'GLENGARRY MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51871', '4', 'LT CARE', 'HEARTWOOD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51873', 'G', 'GROUP/SUPPORT', 'GLEN-STOR-DUN LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51877', '4', 'LT CARE', 'PARISIEN MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51878', 'G', 'GROUP/SUPPORT', 'ST JOSEPH''S VILLA (CORNWALL)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51882', 'G', 'GROUP/SUPPORT', 'MAXVILLE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51885', '1', 'ACUTE INPT', 'WINCHESTER DISTRICT MEMORIAL HOSP.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51886', '3', 'INPT CCC', 'WINCHESTER DISTRICT MEMORIAL HOSP.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51887', '4', 'LT CARE', 'SPECIALTY CARE CASE MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51890', '5', 'INPT MENTAL', 'CHIMO YOUTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51893', '1', 'ACUTE INPT', 'ROSS MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51894', '3', 'INPT CCC', 'ROSS MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51897', 'G', 'GROUP/SUPPORT', 'VICTORIA MANOR HOME FOR THE AGED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51899', 'G', 'GROUP/SUPPORT', 'FAIRVIEW MENNONITE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51900', '4', 'LT CARE', 'GOLDEN YEARS NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51901', '4', 'LT CARE', 'HILLTOP MANOR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51905', '1', 'ACUTE INPT', 'CAMBRIDGE MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51907', '4', 'LT CARE', 'CAMBRIDGE COUNTRY MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51908', '4', 'LT CARE', 'CHARTWELL ELMIRA LTC RESIDENCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51910', '4', 'LT CARE', 'FOREST HEIGHTS LONG TERM CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51912', '2', 'INPT REHAB', 'GRAND RIVER HOSP CORP-FREEPORT SITE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51914', 'G', 'GROUP/SUPPORT', 'HURONIA HALL CNIB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51915', 'T', 'MH/ADDICT RX', 'GRAND RIVER HOSPITAL DETOX CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51919', '2', 'INPT REHAB', 'KIDSABILITY CTR FOR CHILD DEVELOP', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51920', 'G', 'GROUP/SUPPORT', 'PEOPLECARE A.R.GOUDIE KITCHENER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51921', '1', 'ACUTE INPT', 'ST MARY''S GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51922', '4', 'LT CARE', 'TRINITY VILLAGE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51923', 'G', 'GROUP/SUPPORT', 'SUNNYSIDE HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51926', 'G', 'GROUP/SUPPORT', 'NITHVIEW HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51927', '4', 'LT CARE', 'DERBECKER''S HERITAGE HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51929', '5', 'INPT MENTAL', 'LUTHERWOOD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51931', '4', 'LT CARE', 'PINEHAVEN NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51932', 'G', 'GROUP/SUPPORT', 'SUNBEAM RESIDENTIAL DEVLPNT CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51936', '1', 'ACUTE INPT', 'GROVES MEMORIAL COMMUNITY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51937', '3', 'INPT CCC', 'GROVES MEMORIAL COMMUNITY HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51939', '4', 'LT CARE', 'CARESSANT CARE FERGUS NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51943', 'G', 'GROUP/SUPPORT', 'ELLIOTT HOME (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51946', '1', 'ACUTE INPT', 'GUELPH GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51949', '4', 'LT CARE', 'LAPOINTE-FISHER NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51950', 'G', 'GROUP/SUPPORT', 'ST JOSEPH''S HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51952', '3', 'INPT CCC', 'ST JOSEPH''S HEALTH CENTRE,GUELPH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51953', '4', 'LT CARE', 'CARESSANT CARE HARRISTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51959', '4', 'LT CARE', 'SAUGEEN VALLEY NURSING CENTER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51965', '4', 'LT CARE', 'BLACKADAR NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51966', '4', 'LT CARE', 'ST JOSEPH''S VILLA (DUNDAS)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51967', 'G', 'GROUP/SUPPORT', 'WENTWORTH LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51968', '4', 'LT CARE', 'ORCHARD TERRACE CARE CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51969', '4', 'LT CARE', 'BAYWOODS PLACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51975', '5', 'INPT MENTAL', 'CHEDOKE MCMASTER CHILD FAMILY CTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51978', 'G', 'GROUP/SUPPORT', 'RYGIEL HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51982', '1', 'ACUTE INPT', 'HAMILTON HEALTH SCIENCES CORP-GEN.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51983', '1', 'ACUTE INPT', 'HAMILTON HLTH SCI. CORP-JURAVINSKI', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51986', '2', 'INPT REHAB', 'HAMILTON HLTH SCI. CORP MCMASTER S', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51990', '4', 'LT CARE', 'IDLEWYLD MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51991', '5', 'INPT MENTAL', 'LYNWOOD HALL CHILD AND FAMILY CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51992', 'G', 'GROUP/SUPPORT', 'MACASSA LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '51994', '1', 'ACUTE INPT', 'HAMILTON HLTH SCI. CORP-MCMASTER', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52003', '1', 'ACUTE INPT', 'ST JOSEPH''S HLTH CARE SYST-HAMILTON', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52009', '4', 'LT CARE', 'VICTORIA GARDENS LONG TERM CARE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52011', 'T', 'MH/ADDICT RX', 'HAMILTON DETOXIFICATION CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52014', '4', 'LT CARE', 'CHARTWELL AURORA LONG TERM CARE RES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52015', '5', 'INPT MENTAL', 'BLUE HILLS ACADEMY FERGUSON HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52021', '4', 'LT CARE', 'WILLOWS ESTATE NURSING HOME (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52022', '5', 'INPT MENTAL', 'YOUTHDALE RESD TREAT CTR-SPADINA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52023', '4', 'LT CARE', 'KING CITY LODGE NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52025', 'G', 'GROUP/SUPPORT', 'BETHANY LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52028', 'G', 'GROUP/SUPPORT', 'UNION VILLA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52033', '4', 'LT CARE', 'EAGLE TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52034', 'G', 'GROUP/SUPPORT', 'YORK REGION NEWMARKET HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52038', '1', 'ACUTE INPT', 'SOUTHLAKE REGIONAL HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52046', '1', 'ACUTE INPT', 'MACKENZIE HEALTH', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52048', '4', 'LT CARE', 'RIVER GLEN HAVEN NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52049', '1', 'ACUTE INPT', 'SHOULDICE HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52057', '1', 'ACUTE INPT', 'NORTH SHORE HLTH NTWRK-BLIND RIVER', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52058', '1', 'ACUTE INPT', 'ST JOSEPH''S GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52059', '3', 'INPT CCC', 'ST JOSEPH''S GENERAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52061', '1', 'ACUTE INPT', 'HORNEPAYNE COMMUNITY HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52071', '2', 'INPT REHAB', 'THRIVE CHILD DEVELOPMENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52073', '4', 'LT CARE', 'EXTENDICARE/VAN DAELE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52076', '1', 'ACUTE INPT', 'LADY DUNN HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52078', '1', 'ACUTE INPT', 'LADY MINTO HOSPITAL (THE)', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52079', '3', 'INPT CCC', 'LADY MINTO HOSPITAL (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52082', '1', 'ACUTE INPT', 'HOPITAL NOTRE DAME HOSP. (HEARST)', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52083', '3', 'INPT CCC', 'HOPITAL NOTRE DAME HOSP. (HEARST)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52084', '1', 'ACUTE INPT', 'ANSON GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52085', 'G', 'GROUP/SUPPORT', 'SOUTH CENTENNIAL MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52086', '4', 'LT CARE', 'EXTENDICARE/KAPUSKASING', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52087', 'G', 'GROUP/SUPPORT', 'NORTH CENTENNIAL MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52088', '1', 'ACUTE INPT', 'SENSENBRENNER HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52089', '3', 'INPT CCC', 'SENSENBRENNER HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52090', '1', 'ACUTE INPT', 'BINGHAM MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52094', '1', 'ACUTE INPT', 'SMOOTH ROCK FALLS HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52095', 'G', 'GROUP/SUPPORT', 'GOLDEN MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52100', '4', 'LT CARE', 'EXTENDICARE TIMMINS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52102', '6', 'NURSING STNS', 'BIG TROUT LAKE NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52103', '1', 'ACUTE INPT', 'DRYDEN REGIONAL HEALTH CENTRE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52104', '3', 'INPT CCC', 'DRYDEN REGIONAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52105', '6', 'NURSING STNS', 'FORT HOPE NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52106', '6', 'NURSING STNS', 'KASHECHEWAN NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52107', 'T', 'MH/ADDICT RX', 'MORNINGSTAR DETOX DROP-IN CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52109', '4', 'LT CARE', 'BIRCHWOOD TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52110', '1', 'ACUTE INPT', 'LAKE-OF-THE-WOODS DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52111', 'G', 'GROUP/SUPPORT', 'PINECREST', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52112', '6', 'NURSING STNS', 'LANSDOWNE HOUSE NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52113', '6', 'NURSING STNS', 'NEW OSNABURGH NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52114', '6', 'NURSING STNS', 'PIKANGIKUM NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52115', '1', 'ACUTE INPT', 'RED LAKE MARGARET COCHENOUR MEM.', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52116', '6', 'NURSING STNS', 'ROUND LAKE NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52117', '6', 'NURSING STNS', 'SANDY LAKE NURSING STATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52120', 'G', 'GROUP/SUPPORT', 'MANITOULIN CENTENNIAL MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52121', '1', 'ACUTE INPT', 'MANITOULIN HLTH CTR-LITTLE CURRENT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52123', '1', 'ACUTE INPT', 'MANITOULIN HLTH CTR-MINDEMOYA UNIT', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52124', '4', 'LT CARE', 'WIKWEMIKONG NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52125', '4', 'LT CARE', 'NIPISSING MANOR NURSING CARE CENTER', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52126', '1', 'ACUTE INPT', 'MATTAWA GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52127', 'G', 'GROUP/SUPPORT', 'CASSELLHOLME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52128', '4', 'LT CARE', 'LEISUREWORLDCAREGIVINGCTR-NORTHBAY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52134', 'G', 'GROUP/SUPPORT', 'AU CHATEAU', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52137', 'G', 'GROUP/SUPPORT', 'BELVEDERE HEIGHTS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52142', '5', 'INPT MENTAL', 'YOUTHDALE RESID TREATMENT CTR LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52144', 'G', 'GROUP/SUPPORT', 'EASTHOLME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52147', '1', 'ACUTE INPT', 'ATIKOKAN GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52148', '1', 'ACUTE INPT', 'RIVERSIDE HEALTH CARE FAC-EMO SITE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52150', '1', 'ACUTE INPT', 'RIVERSIDE HLTH CARE FAC-LAVERENDRYE', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52151', '3', 'INPT CCC', 'RIVERSIDE HLTH CARE FAC-LAVERENDRYE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52152', 'G', 'GROUP/SUPPORT', 'RAINYCREST', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52153', '1', 'ACUTE INPT', 'RIVERSIDE HLTH CARE FAC-RAINY RIVER', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52157', '4', 'LT CARE', 'EXTENDICARE/FALCONBRIDGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52158', 'T', 'MH/ADDICT RX', 'PINEGATE DETOX CENTRE (MEN''S)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52162', 'G', 'GROUP/SUPPORT', 'PIONEER MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52167', '2', 'INPT REHAB', 'HOPITAL REG. DE SUDBURY REG. HOS', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52172', '4', 'LT CARE', 'EXTENDICARE/YORK', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52173', '1', 'ACUTE INPT', 'SERVICES DE SANTE DE CHAPLEAU', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52174', '1', 'ACUTE INPT', 'ESPANOLA GENERAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52175', '1', 'ACUTE INPT', 'GERALDTON DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52176', '1', 'ACUTE INPT', 'SANTE MANITOUWADGE HEALTH', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52178', '1', 'ACUTE INPT', 'NIPIGON DISTRICT MEMORIAL HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52179', 'G', 'GROUP/SUPPORT', 'BIRCHWOOD TERRACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52181', '4', 'LT CARE', 'LAKEHEAD MANOR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52183', 'T', 'MH/ADDICT RX', 'BALMORAL DETOXIFICATION CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52185', 'G', 'GROUP/SUPPORT', 'CUMBERLAND HALL CNIB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52193', '2', 'INPT REHAB', 'GEORGE JEFFREY CHILDREN''S TREAT CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52200', 'G', 'GROUP/SUPPORT', 'CTR FOR DEVELOPMENTALY CHALLENGED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52204', '1', 'ACUTE INPT', 'ENGLEHART AND DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52205', '4', 'LT CARE', 'NORTHVIEW NURSING HOME', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52206', '4', 'LT CARE', 'EXTENDICARE/TRI-TOWN', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52207', '1', 'ACUTE INPT', 'TEMISKAMING HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52208', '3', 'INPT CCC', 'TEMISKAMING HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52209', '4', 'LT CARE', 'EXTENDICARE/KIRKLAND LAKE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52211', '1', 'ACUTE INPT', 'KIRKLAND AND DISTRICT HOSPITAL', 'Y')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52212', '3', 'INPT CCC', 'KIRKLAND AND DISTRICT HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52217', '3', 'INPT CCC', 'SOUTHLAKE REGIONAL HEALTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52218', '3', 'INPT CCC', 'MACKENZIE HEALTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52220', 'G', 'GROUP/SUPPORT', 'ST.JOSEPH''S HLTH CARE,LONDON-PARKWO', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52223', '2', 'INPT REHAB', 'PROVIDENCE CARE HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52224', '3', 'INPT CCC', 'LAKE-OF-THE-WOODS DISTRICT HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52226', 'F', 'OTHER HEALTH', 'ALGOMA DISTRICT HEALTH UNIT (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52227', 'F', 'OTHER HEALTH', 'BRANT COUNTY HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52230', 'F', 'OTHER HEALTH', 'DURHAM REGIONAL HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52233', 'F', 'OTHER HEALTH', 'GREY BRUCE HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52234', 'F', 'OTHER HEALTH', 'HALDIMAND-NORFOLK HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52235', 'F', 'OTHER HEALTH', 'HALIBURTON KAWARTHA PINE RIDGE DIST', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52236', 'F', 'OTHER HEALTH', 'HALTON REGIONAL HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52237', 'F', 'OTHER HEALTH', 'CITY OF HAMILTON HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52238', 'F', 'OTHER HEALTH', 'HASTINGS&PRINCE EDWARD COUNTIES HLT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52239', 'F', 'OTHER HEALTH', 'HURON COUNTY HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52240', 'F', 'OTHER HEALTH', 'CHATHAM-KENT HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52241', 'F', 'OTHER HEALTH', 'KINGSTON FRONTENAC&LENNOX&ADDINGTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52242', 'F', 'OTHER HEALTH', 'LAMBTON HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52243', 'F', 'OTHER HEALTH', 'LEEDS GRENVILLE&LANARK DIST. HLTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52244', 'F', 'OTHER HEALTH', 'MIDDLESEX-LONDON HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52246', 'F', 'OTHER HEALTH', 'NIAGARA REGIONAL AREA HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52247', 'F', 'OTHER HEALTH', 'NORTH BAY PARRY SOUND DISTRICT HLTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52249', 'F', 'OTHER HEALTH', 'NORTHWESTERN HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52251', 'F', 'OTHER HEALTH', 'CITY OF OTTAWA HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52253', 'F', 'OTHER HEALTH', 'PEEL REGIONAL HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52254', 'F', 'OTHER HEALTH', 'PERTH DISTRICT HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52255', 'F', 'OTHER HEALTH', 'PETERBOROUGH COUNTY-CITY HLTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52256', 'F', 'OTHER HEALTH', 'PORCUPINE HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52257', 'F', 'OTHER HEALTH', 'RENFREW COUNTY & DISTRICT HLTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52258', 'F', 'OTHER HEALTH', 'EASTERN ONTARIO HEALTH UNIT (THE)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52260', 'F', 'OTHER HEALTH', 'SIMCOE MUSKOKA DISTRICT HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52261', 'F', 'OTHER HEALTH', 'SUDBURY AND DISTRICT HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52262', 'F', 'OTHER HEALTH', 'THUNDER BAY DISTRICT HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52263', 'F', 'OTHER HEALTH', 'TIMISKAMING HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52265', 'F', 'OTHER HEALTH', 'WATERLOO HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52266', 'F', 'OTHER HEALTH', 'WELLINGTON-DUFFERIN-GUELPH HLTH UNI', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52268', 'F', 'OTHER HEALTH', 'WINDSOR-ESSEX COUNTY HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52270', 'F', 'OTHER HEALTH', 'YORK REGIONAL HEALTH UNIT', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52276', 'C', 'CORRECTIONAL', 'ONTARIO CORRECTIONAL INSTITUTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52278', 'C', 'CORRECTIONAL', 'BRANTFORD JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52281', 'C', 'CORRECTIONAL', 'BROCKVILLE JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52284', 'C', 'CORRECTIONAL', 'BROOKSIDE YOUTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52287', 'C', 'CORRECTIONAL', 'FORT FRANCES JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52294', 'C', 'CORRECTIONAL', 'KENORA JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52301', 'C', 'CORRECTIONAL', 'MAPLEHURST CORRECTION&TREATMENT CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52302', 'C', 'CORRECTIONAL', 'TORONTO INTERMITTENT CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52303', 'C', 'CORRECTIONAL', 'MONTEITH CORRECTIONAL CENTRE & JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52304', 'C', 'CORRECTIONAL', 'QUINTE DETENTION CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52306', 'C', 'CORRECTIONAL', 'NORTH BAY JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52317', 'C', 'CORRECTIONAL', 'SARNIA JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52318', 'C', 'CORRECTIONAL', 'ALGOMA TREATMENT AND REMAND CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52319', 'C', 'CORRECTIONAL', 'SPRUCEDALE YOUTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52322', 'C', 'CORRECTIONAL', 'STRATFORD JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52323', 'C', 'CORRECTIONAL', 'CECIL FACER YOUTH CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52324', 'C', 'CORRECTIONAL', 'SUDBURY JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52325', 'C', 'CORRECTIONAL', 'THUNDER BAY CORRECTIONAL CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52326', 'C', 'CORRECTIONAL', 'THUNDER BAY JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52327', 'C', 'CORRECTIONAL', 'CORRECTIONAL SERVICES MAIN OFFICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52330', 'C', 'CORRECTIONAL', 'WALKERTON JAIL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52334', '5', 'INPT MENTAL', 'STOTHERS PRE SCHOOL CHILD CARE CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52337', '5', 'INPT MENTAL', 'LAKE-OF-THE-WOODS CHILD DEVT CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52338', '5', 'INPT MENTAL', 'INTEGRA FOUNDATION CAMP TOWNEE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52339', '5', 'INPT MENTAL', 'CRECHE CHILD AND FAMILY SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52340', '5', 'INPT MENTAL', 'ADVENTURE PLACE  (NORTH YORK)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52343', '5', 'INPT MENTAL', 'SERTOMA CENTRE FOR CHILDREN & YOUTH', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52344', '5', 'INPT MENTAL', 'WEST END CRECHE CHILD&FAMILY CLINIC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52345', '5', 'INPT MENTAL', 'YORKTOWN CHILD AND FAMILY', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52348', '5', 'INPT MENTAL', 'INTEGRA FOUNDATION', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52356', 'J', 'OTH NON-HEALTH', 'W ROSS MACDONALD SCHOOL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52357', 'J', 'OTH NON-HEALTH', 'SIR JAMES WHITNEY SCHOOL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52358', 'J', 'OTH NON-HEALTH', 'ROBARTS SCHOOL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52359', 'J', 'OTH NON-HEALTH', 'ERNEST C DRURY SCHOOL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52361', '5', 'INPT MENTAL', 'CHIMO YOUTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52364', '5', 'INPT MENTAL', 'FRONTENAC YOUTH SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52366', '5', 'INPT MENTAL', 'ETOBICOKE CHILDREN''S CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52369', 'G', 'GROUP/SUPPORT', 'TERCENTENNIAL LODGE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52399', '3', 'INPT CCC', 'GLENGARRY MEMORIAL HOSPITAL', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52400', '4', 'LT CARE', 'SUNNYBROOK HEALTH SCIENCES CENTRE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52401', '4', 'LT CARE', 'MACKENZIE PLACE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52403', '5', 'INPT MENTAL', 'BLUE HILLS ACADEMY SUMMIT HOUSE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52407', 'U', 'UNKNOWN', 'SUNPARLOUR EMERGENCY SERVICES INC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52410', 'U', 'UNKNOWN', 'BRIGDEN & DISTRICT AMBULANCE SERV.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52411', 'U', 'UNKNOWN', 'GILPIN AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52412', 'U', 'UNKNOWN', 'PETROLIA & DIST AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52414', 'U', 'UNKNOWN', 'LAMBTON MIDDLESEX AMBULANCE SERV.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52415', 'U', 'UNKNOWN', 'DENNING BROTHERS AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52416', 'U', 'UNKNOWN', 'NORTH MIDDLESEX AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52417', 'U', 'UNKNOWN', 'LUCAN AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52418', 'U', 'UNKNOWN', 'THAMES VALLEY AMBULANCE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52419', 'U', 'UNKNOWN', 'RODNEY AMBULANCE SERVICE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52420', 'U', 'UNKNOWN', 'WOODSTOCK AMBULANCE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52421', 'U', 'UNKNOWN', 'STRATFORD AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52422', 'U', 'UNKNOWN', 'HOFFMAN AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52423', 'U', 'UNKNOWN', 'ZURICH AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52424', 'U', 'UNKNOWN', 'SEAFORTH DISTRICT AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52425', 'U', 'UNKNOWN', 'SARNIA GENERAL HOSPITAL AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52426', 'U', 'UNKNOWN', 'ST THOMAS-ELGIN GEN. HOSP AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52427', 'U', 'UNKNOWN', 'TILLSONBURG DIST MEM HOSP AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52428', 'U', 'UNKNOWN', 'ST MARYS MEMORIAL HOSP. AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52429', 'U', 'UNKNOWN', 'STRATFORD GENERAL HOSP. AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52430', 'U', 'UNKNOWN', 'LISTOWEL MEMORIAL HOSP. AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52431', 'U', 'UNKNOWN', 'OSHAWA DISTRICT AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52432', 'U', 'UNKNOWN', 'WINGHAM AND DISTRICT HOSP AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52433', 'U', 'UNKNOWN', 'OWEN SOUND EMERGENCY SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52435', 'U', 'UNKNOWN', 'BRUCE PENINSULA HEALTH SERVICES AMB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52437', 'U', 'UNKNOWN', 'WALKERTON AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52438', 'U', 'UNKNOWN', 'HANOVER & DISTRICT HOSP AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52439', 'U', 'UNKNOWN', 'OWEN SOUND EMERGENCY SERVICES INC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52440', 'U', 'UNKNOWN', 'DURHAM MEMORIAL HOSPITAL AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52441', 'U', 'UNKNOWN', 'CENTRE GREY GENERAL HOSP. AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52443', 'U', 'UNKNOWN', 'WINDSOR PROVINCIAL AMBULANCE SERV.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52444', 'U', 'UNKNOWN', 'AMHERSTBURG ANDERDON MALDON VOL AMB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52445', 'U', 'UNKNOWN', 'PELEE ISLAND VOLUNTEER AMB. SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52446', 'U', 'UNKNOWN', 'MOUNT FOREST DIST AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52447', 'U', 'UNKNOWN', 'PALMERSTON AND DISTRICT AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52449', 'U', 'UNKNOWN', 'ROYAL CITY AMBULANCE SERVICE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52450', 'U', 'UNKNOWN', 'VERHOEVE AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52451', 'U', 'UNKNOWN', 'D L MURPHY AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52452', 'U', 'UNKNOWN', 'GREENS AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52455', 'U', 'UNKNOWN', 'PORT COLBORNE DISTRICT AMB. SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52456', 'U', 'UNKNOWN', 'BOOK AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52457', 'U', 'UNKNOWN', 'FLEETWOOD AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52458', 'U', 'UNKNOWN', 'SUPERIOR AMBULANCE LIMITED', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52460', 'U', 'UNKNOWN', 'DISTRICT OF HALTON-MISSISSAUGA AMB.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52465', 'U', 'UNKNOWN', 'WEST LINCOLN AMBULANCE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52466', 'U', 'UNKNOWN', 'SHELBURNE DISTRICT HOSPITAL AMB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52467', 'U', 'UNKNOWN', 'ROYAL CITY AMBULANCE SERVICE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52468', 'U', 'UNKNOWN', 'KITCHENER-WATERLOO REGIONAL AMB INC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52469', 'U', 'UNKNOWN', 'CAMBRIDGE MEMORIAL HOSP. AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52471', 'U', 'UNKNOWN', 'WEST HALDIMAND GEN HOSP AMB. SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52472', 'U', 'UNKNOWN', 'HALDIMAND WAR MEM. HOSP AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52473', 'U', 'UNKNOWN', 'HOTEL DIEU HOSPITAL AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52474', 'U', 'UNKNOWN', 'NIAGARA FALLS DISTRICT AMB SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52475', 'U', 'UNKNOWN', 'NIAGARA-ON-THE-LAKE AMBULANCE SERV.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52476', 'U', 'UNKNOWN', 'BRANT COUNTY AMBULANCE SERVICE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52477', 'U', 'UNKNOWN', 'ANCASTER AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52478', 'U', 'UNKNOWN', 'LEE AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52479', 'U', 'UNKNOWN', 'MC KECHNIE AMBULANCE SERVICE INC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52480', 'U', 'UNKNOWN', 'MIDLAND DISTRICT AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52481', 'U', 'UNKNOWN', 'BEAVERTON & DISTRICT AMBULANCE SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52482', 'U', 'UNKNOWN', 'BOBCAYGEON AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52483', 'U', 'UNKNOWN', 'MEDAVIE EMS ONTARIO (MEMSO)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52484', 'U', 'UNKNOWN', 'LEWIS AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52485', 'U', 'UNKNOWN', 'COBOURG & DIST AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52486', 'U', 'UNKNOWN', 'RUTHERFORD''S AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52487', 'U', 'UNKNOWN', 'FENELON FALLS AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52488', 'U', 'UNKNOWN', 'MEDAVIE EMS ONTARIO (MEMSO)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52497', 'U', 'UNKNOWN', 'WHITBY-BOWMANVILLE AMBULANCE SERV.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52500', 'U', 'UNKNOWN', 'STEVENSON MEM. HOSP. AMB ALLISTON', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52501', 'U', 'UNKNOWN', 'AJAX & PICKERING AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52502', 'U', 'UNKNOWN', 'ROYAL VICTORIA HOSP BARRIE&DIST AMB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52504', 'U', 'UNKNOWN', 'CAMPBELLFORD MEMORIAL HOSPITAL AMB', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52505', 'U', 'UNKNOWN', 'MEDAVIE EMS ONTARIO (MEMSO)', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52506', 'U', 'UNKNOWN', 'YORK COUNTY HOSPITAL AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52507', 'U', 'UNKNOWN', 'DUFFERIN AREA HOSPITAL AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52508', 'U', 'UNKNOWN', 'PETERBOROUGH & DIST AMBULANCE SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52509', 'U', 'UNKNOWN', 'UXBRIDGE AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52514', 'U', 'UNKNOWN', 'ORILLIA DISTRICT AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52516', 'U', 'UNKNOWN', 'C.A.C.C-MISSISSAUGA', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52517', 'U', 'UNKNOWN', 'OSHAWA-MARKHAM AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52518', 'U', 'UNKNOWN', 'BOLTON&DISTR VOLUNTEER AMB. ASSOC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52521', 'U', 'UNKNOWN', 'NOBLETON AMBULANCE SERVICE ASSOC', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52522', 'U', 'UNKNOWN', 'WASAGA BEACH AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52523', 'U', 'UNKNOWN', 'HALIBURTON & DIST AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52524', 'U', 'UNKNOWN', 'CENTRAL AMBULANCE COMMUNICATION CTR', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52525', 'U', 'UNKNOWN', 'HALIBURTON COUNTY AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52526', 'U', 'UNKNOWN', 'TORONTO EMERGENCY MEDICAL SERVICES', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52527', 'U', 'UNKNOWN', 'LAMARRE & SON AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52529', 'U', 'UNKNOWN', 'CITY AMBULANCE SERVICE OF QUINTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52530', 'U', 'UNKNOWN', 'CITY AMBULANCE SERVICE OF QUINTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52531', 'U', 'UNKNOWN', 'LA SALLE AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52532', 'U', 'UNKNOWN', 'CARLETON PLACE/RICHMOND AMB. SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52533', 'U', 'UNKNOWN', 'ST LAWRENCE & DISTRICT AMB SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52534', 'U', 'UNKNOWN', 'NOEL AMBULANCE SERVICE LTD', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52536', 'U', 'UNKNOWN', 'ST LAWRENCE & DISTRICT AMB SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52537', 'U', 'UNKNOWN', 'ST LAWRENCE & DISTRICT AMB SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52538', 'U', 'UNKNOWN', 'GANANOQUE PROVINCIAL AMBULANCE SERV', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52539', 'U', 'UNKNOWN', 'PARHAM AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52540', 'U', 'UNKNOWN', 'UPPER OTTAWA VALLEY AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52541', 'U', 'UNKNOWN', 'DISTRICT AMBULANCE SERVICE LTD.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52542', 'U', 'UNKNOWN', 'BANCROFT AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52543', 'U', 'UNKNOWN', 'CITY AMBULANCE SERVICE OF QUINTE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52544', 'U', 'UNKNOWN', 'ALEXANDRIA & DISTRICT AMB. SERV.', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52545', 'U', 'UNKNOWN', 'ALMONTE DISTRICT AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52546', 'U', 'UNKNOWN', 'PERTH AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52547', 'U', 'UNKNOWN', 'ARNPRIOR & KANATA AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52548', 'U', 'UNKNOWN', 'BARRY''S BAY DISTRICT AMBULANCE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52549', 'U', 'UNKNOWN', 'PEMBROKE DISTRICT AMBULANCE SERVICE', 'N')
GO
insert into zzInstType(Province, InstitutionNumber, InstitutionType, InstitutionTypeDescription, InstitutionName, SubmittingToDAD) values('ON', '52550', 'U', 'UNKNOWN', 'BROCKVILLE & DIST AMBULANCE SERVICE', 'N')
GO
